// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"

	v1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1alpha1"
	monitoringv1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/client/applyconfiguration/monitoring/v1alpha1"
	scheme "github.com/prometheus-operator/prometheus-operator/pkg/client/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// ScrapeConfigsGetter has a method to return a ScrapeConfigInterface.
// A group's client should implement this interface.
type ScrapeConfigsGetter interface {
	ScrapeConfigs(namespace string) ScrapeConfigInterface
}

// ScrapeConfigInterface has methods to work with ScrapeConfig resources.
type ScrapeConfigInterface interface {
	Create(ctx context.Context, scrapeConfig *v1alpha1.ScrapeConfig, opts v1.CreateOptions) (*v1alpha1.ScrapeConfig, error)
	Update(ctx context.Context, scrapeConfig *v1alpha1.ScrapeConfig, opts v1.UpdateOptions) (*v1alpha1.ScrapeConfig, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ScrapeConfig, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ScrapeConfigList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ScrapeConfig, err error)
	Apply(ctx context.Context, scrapeConfig *monitoringv1alpha1.ScrapeConfigApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.ScrapeConfig, err error)
	ScrapeConfigExpansion
}

// scrapeConfigs implements ScrapeConfigInterface
type scrapeConfigs struct {
	*gentype.ClientWithListAndApply[*v1alpha1.ScrapeConfig, *v1alpha1.ScrapeConfigList, *monitoringv1alpha1.ScrapeConfigApplyConfiguration]
}

// newScrapeConfigs returns a ScrapeConfigs
func newScrapeConfigs(c *MonitoringV1alpha1Client, namespace string) *scrapeConfigs {
	return &scrapeConfigs{
		gentype.NewClientWithListAndApply[*v1alpha1.ScrapeConfig, *v1alpha1.ScrapeConfigList, *monitoringv1alpha1.ScrapeConfigApplyConfiguration](
			"scrapeconfigs",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v1alpha1.ScrapeConfig { return &v1alpha1.ScrapeConfig{} },
			func() *v1alpha1.ScrapeConfigList { return &v1alpha1.ScrapeConfigList{} }),
	}
}
