// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"

	v1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1alpha1"
	monitoringv1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/client/applyconfiguration/monitoring/v1alpha1"
	scheme "github.com/prometheus-operator/prometheus-operator/pkg/client/versioned/scheme"
	autoscalingv1 "k8s.io/api/autoscaling/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// PrometheusAgentsGetter has a method to return a PrometheusAgentInterface.
// A group's client should implement this interface.
type PrometheusAgentsGetter interface {
	PrometheusAgents(namespace string) PrometheusAgentInterface
}

// PrometheusAgentInterface has methods to work with PrometheusAgent resources.
type PrometheusAgentInterface interface {
	Create(ctx context.Context, prometheusAgent *v1alpha1.PrometheusAgent, opts v1.CreateOptions) (*v1alpha1.PrometheusAgent, error)
	Update(ctx context.Context, prometheusAgent *v1alpha1.PrometheusAgent, opts v1.UpdateOptions) (*v1alpha1.PrometheusAgent, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, prometheusAgent *v1alpha1.PrometheusAgent, opts v1.UpdateOptions) (*v1alpha1.PrometheusAgent, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.PrometheusAgent, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.PrometheusAgentList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.PrometheusAgent, err error)
	Apply(ctx context.Context, prometheusAgent *monitoringv1alpha1.PrometheusAgentApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.PrometheusAgent, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, prometheusAgent *monitoringv1alpha1.PrometheusAgentApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.PrometheusAgent, err error)
	GetScale(ctx context.Context, prometheusAgentName string, options v1.GetOptions) (*autoscalingv1.Scale, error)
	UpdateScale(ctx context.Context, prometheusAgentName string, scale *autoscalingv1.Scale, opts v1.UpdateOptions) (*autoscalingv1.Scale, error)

	PrometheusAgentExpansion
}

// prometheusAgents implements PrometheusAgentInterface
type prometheusAgents struct {
	*gentype.ClientWithListAndApply[*v1alpha1.PrometheusAgent, *v1alpha1.PrometheusAgentList, *monitoringv1alpha1.PrometheusAgentApplyConfiguration]
}

// newPrometheusAgents returns a PrometheusAgents
func newPrometheusAgents(c *MonitoringV1alpha1Client, namespace string) *prometheusAgents {
	return &prometheusAgents{
		gentype.NewClientWithListAndApply[*v1alpha1.PrometheusAgent, *v1alpha1.PrometheusAgentList, *monitoringv1alpha1.PrometheusAgentApplyConfiguration](
			"prometheusagents",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v1alpha1.PrometheusAgent { return &v1alpha1.PrometheusAgent{} },
			func() *v1alpha1.PrometheusAgentList { return &v1alpha1.PrometheusAgentList{} }),
	}
}

// GetScale takes name of the prometheusAgent, and returns the corresponding autoscalingv1.Scale object, and an error if there is any.
func (c *prometheusAgents) GetScale(ctx context.Context, prometheusAgentName string, options v1.GetOptions) (result *autoscalingv1.Scale, err error) {
	result = &autoscalingv1.Scale{}
	err = c.GetClient().Get().
		Namespace(c.GetNamespace()).
		Resource("prometheusagents").
		Name(prometheusAgentName).
		SubResource("scale").
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// UpdateScale takes the top resource name and the representation of a scale and updates it. Returns the server's representation of the scale, and an error, if there is any.
func (c *prometheusAgents) UpdateScale(ctx context.Context, prometheusAgentName string, scale *autoscalingv1.Scale, opts v1.UpdateOptions) (result *autoscalingv1.Scale, err error) {
	result = &autoscalingv1.Scale{}
	err = c.GetClient().Put().
		Namespace(c.GetNamespace()).
		Resource("prometheusagents").
		Name(prometheusAgentName).
		SubResource("scale").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(scale).
		Do(ctx).
		Into(result)
	return
}
