// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1alpha1"
	monitoringv1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/client/applyconfiguration/monitoring/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeAlertmanagerConfigs implements AlertmanagerConfigInterface
type FakeAlertmanagerConfigs struct {
	Fake *FakeMonitoringV1alpha1
	ns   string
}

var alertmanagerconfigsResource = v1alpha1.SchemeGroupVersion.WithResource("alertmanagerconfigs")

var alertmanagerconfigsKind = v1alpha1.SchemeGroupVersion.WithKind("AlertmanagerConfig")

// Get takes name of the alertmanagerConfig, and returns the corresponding alertmanagerConfig object, and an error if there is any.
func (c *FakeAlertmanagerConfigs) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.AlertmanagerConfig, err error) {
	emptyResult := &v1alpha1.AlertmanagerConfig{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(alertmanagerconfigsResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.AlertmanagerConfig), err
}

// List takes label and field selectors, and returns the list of AlertmanagerConfigs that match those selectors.
func (c *FakeAlertmanagerConfigs) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.AlertmanagerConfigList, err error) {
	emptyResult := &v1alpha1.AlertmanagerConfigList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(alertmanagerconfigsResource, alertmanagerconfigsKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.AlertmanagerConfigList{ListMeta: obj.(*v1alpha1.AlertmanagerConfigList).ListMeta}
	for _, item := range obj.(*v1alpha1.AlertmanagerConfigList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested alertmanagerConfigs.
func (c *FakeAlertmanagerConfigs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(alertmanagerconfigsResource, c.ns, opts))

}

// Create takes the representation of a alertmanagerConfig and creates it.  Returns the server's representation of the alertmanagerConfig, and an error, if there is any.
func (c *FakeAlertmanagerConfigs) Create(ctx context.Context, alertmanagerConfig *v1alpha1.AlertmanagerConfig, opts v1.CreateOptions) (result *v1alpha1.AlertmanagerConfig, err error) {
	emptyResult := &v1alpha1.AlertmanagerConfig{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(alertmanagerconfigsResource, c.ns, alertmanagerConfig, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.AlertmanagerConfig), err
}

// Update takes the representation of a alertmanagerConfig and updates it. Returns the server's representation of the alertmanagerConfig, and an error, if there is any.
func (c *FakeAlertmanagerConfigs) Update(ctx context.Context, alertmanagerConfig *v1alpha1.AlertmanagerConfig, opts v1.UpdateOptions) (result *v1alpha1.AlertmanagerConfig, err error) {
	emptyResult := &v1alpha1.AlertmanagerConfig{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(alertmanagerconfigsResource, c.ns, alertmanagerConfig, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.AlertmanagerConfig), err
}

// Delete takes name of the alertmanagerConfig and deletes it. Returns an error if one occurs.
func (c *FakeAlertmanagerConfigs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(alertmanagerconfigsResource, c.ns, name, opts), &v1alpha1.AlertmanagerConfig{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeAlertmanagerConfigs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(alertmanagerconfigsResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.AlertmanagerConfigList{})
	return err
}

// Patch applies the patch and returns the patched alertmanagerConfig.
func (c *FakeAlertmanagerConfigs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.AlertmanagerConfig, err error) {
	emptyResult := &v1alpha1.AlertmanagerConfig{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(alertmanagerconfigsResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.AlertmanagerConfig), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied alertmanagerConfig.
func (c *FakeAlertmanagerConfigs) Apply(ctx context.Context, alertmanagerConfig *monitoringv1alpha1.AlertmanagerConfigApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.AlertmanagerConfig, err error) {
	if alertmanagerConfig == nil {
		return nil, fmt.Errorf("alertmanagerConfig provided to Apply must not be nil")
	}
	data, err := json.Marshal(alertmanagerConfig)
	if err != nil {
		return nil, err
	}
	name := alertmanagerConfig.Name
	if name == nil {
		return nil, fmt.Errorf("alertmanagerConfig.Name must be provided to Apply")
	}
	emptyResult := &v1alpha1.AlertmanagerConfig{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(alertmanagerconfigsResource, c.ns, *name, types.ApplyPatchType, data, opts.ToPatchOptions()), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.AlertmanagerConfig), err
}
