// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/client/applyconfiguration/monitoring/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeServiceMonitors implements ServiceMonitorInterface
type FakeServiceMonitors struct {
	Fake *FakeMonitoringV1
	ns   string
}

var servicemonitorsResource = v1.SchemeGroupVersion.WithResource("servicemonitors")

var servicemonitorsKind = v1.SchemeGroupVersion.WithKind("ServiceMonitor")

// Get takes name of the serviceMonitor, and returns the corresponding serviceMonitor object, and an error if there is any.
func (c *FakeServiceMonitors) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ServiceMonitor, err error) {
	emptyResult := &v1.ServiceMonitor{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(servicemonitorsResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.ServiceMonitor), err
}

// List takes label and field selectors, and returns the list of ServiceMonitors that match those selectors.
func (c *FakeServiceMonitors) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ServiceMonitorList, err error) {
	emptyResult := &v1.ServiceMonitorList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(servicemonitorsResource, servicemonitorsKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.ServiceMonitorList{ListMeta: obj.(*v1.ServiceMonitorList).ListMeta}
	for _, item := range obj.(*v1.ServiceMonitorList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested serviceMonitors.
func (c *FakeServiceMonitors) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(servicemonitorsResource, c.ns, opts))

}

// Create takes the representation of a serviceMonitor and creates it.  Returns the server's representation of the serviceMonitor, and an error, if there is any.
func (c *FakeServiceMonitors) Create(ctx context.Context, serviceMonitor *v1.ServiceMonitor, opts metav1.CreateOptions) (result *v1.ServiceMonitor, err error) {
	emptyResult := &v1.ServiceMonitor{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(servicemonitorsResource, c.ns, serviceMonitor, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.ServiceMonitor), err
}

// Update takes the representation of a serviceMonitor and updates it. Returns the server's representation of the serviceMonitor, and an error, if there is any.
func (c *FakeServiceMonitors) Update(ctx context.Context, serviceMonitor *v1.ServiceMonitor, opts metav1.UpdateOptions) (result *v1.ServiceMonitor, err error) {
	emptyResult := &v1.ServiceMonitor{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(servicemonitorsResource, c.ns, serviceMonitor, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.ServiceMonitor), err
}

// Delete takes name of the serviceMonitor and deletes it. Returns an error if one occurs.
func (c *FakeServiceMonitors) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(servicemonitorsResource, c.ns, name, opts), &v1.ServiceMonitor{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeServiceMonitors) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(servicemonitorsResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1.ServiceMonitorList{})
	return err
}

// Patch applies the patch and returns the patched serviceMonitor.
func (c *FakeServiceMonitors) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ServiceMonitor, err error) {
	emptyResult := &v1.ServiceMonitor{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(servicemonitorsResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.ServiceMonitor), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied serviceMonitor.
func (c *FakeServiceMonitors) Apply(ctx context.Context, serviceMonitor *monitoringv1.ServiceMonitorApplyConfiguration, opts metav1.ApplyOptions) (result *v1.ServiceMonitor, err error) {
	if serviceMonitor == nil {
		return nil, fmt.Errorf("serviceMonitor provided to Apply must not be nil")
	}
	data, err := json.Marshal(serviceMonitor)
	if err != nil {
		return nil, err
	}
	name := serviceMonitor.Name
	if name == nil {
		return nil, fmt.Errorf("serviceMonitor.Name must be provided to Apply")
	}
	emptyResult := &v1.ServiceMonitor{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(servicemonitorsResource, c.ns, *name, types.ApplyPatchType, data, opts.ToPatchOptions()), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.ServiceMonitor), err
}
