// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1alpha1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// ScrapeConfigLister helps list ScrapeConfigs.
// All objects returned here must be treated as read-only.
type ScrapeConfigLister interface {
	// List lists all ScrapeConfigs in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.ScrapeConfig, err error)
	// ScrapeConfigs returns an object that can list and get ScrapeConfigs.
	ScrapeConfigs(namespace string) ScrapeConfigNamespaceLister
	ScrapeConfigListerExpansion
}

// scrapeConfigLister implements the ScrapeConfigLister interface.
type scrapeConfigLister struct {
	listers.ResourceIndexer[*v1alpha1.ScrapeConfig]
}

// NewScrapeConfigLister returns a new ScrapeConfigLister.
func NewScrapeConfigLister(indexer cache.Indexer) ScrapeConfigLister {
	return &scrapeConfigLister{listers.New[*v1alpha1.ScrapeConfig](indexer, v1alpha1.Resource("scrapeconfig"))}
}

// ScrapeConfigs returns an object that can list and get ScrapeConfigs.
func (s *scrapeConfigLister) ScrapeConfigs(namespace string) ScrapeConfigNamespaceLister {
	return scrapeConfigNamespaceLister{listers.NewNamespaced[*v1alpha1.ScrapeConfig](s.ResourceIndexer, namespace)}
}

// ScrapeConfigNamespaceLister helps list and get ScrapeConfigs.
// All objects returned here must be treated as read-only.
type ScrapeConfigNamespaceLister interface {
	// List lists all ScrapeConfigs in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.ScrapeConfig, err error)
	// Get retrieves the ScrapeConfig from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.ScrapeConfig, error)
	ScrapeConfigNamespaceListerExpansion
}

// scrapeConfigNamespaceLister implements the ScrapeConfigNamespaceLister
// interface.
type scrapeConfigNamespaceLister struct {
	listers.ResourceIndexer[*v1alpha1.ScrapeConfig]
}
