// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// AlertmanagerLister helps list Alertmanagers.
// All objects returned here must be treated as read-only.
type AlertmanagerLister interface {
	// List lists all Alertmanagers in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Alertmanager, err error)
	// Alertmanagers returns an object that can list and get Alertmanagers.
	Alertmanagers(namespace string) AlertmanagerNamespaceLister
	AlertmanagerListerExpansion
}

// alertmanagerLister implements the AlertmanagerLister interface.
type alertmanagerLister struct {
	listers.ResourceIndexer[*v1.Alertmanager]
}

// NewAlertmanagerLister returns a new AlertmanagerLister.
func NewAlertmanagerLister(indexer cache.Indexer) AlertmanagerLister {
	return &alertmanagerLister{listers.New[*v1.Alertmanager](indexer, v1.Resource("alertmanager"))}
}

// Alertmanagers returns an object that can list and get Alertmanagers.
func (s *alertmanagerLister) Alertmanagers(namespace string) AlertmanagerNamespaceLister {
	return alertmanagerNamespaceLister{listers.NewNamespaced[*v1.Alertmanager](s.ResourceIndexer, namespace)}
}

// AlertmanagerNamespaceLister helps list and get Alertmanagers.
// All objects returned here must be treated as read-only.
type AlertmanagerNamespaceLister interface {
	// List lists all Alertmanagers in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Alertmanager, err error)
	// Get retrieves the Alertmanager from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.Alertmanager, error)
	AlertmanagerNamespaceListerExpansion
}

// alertmanagerNamespaceLister implements the AlertmanagerNamespaceLister
// interface.
type alertmanagerNamespaceLister struct {
	listers.ResourceIndexer[*v1.Alertmanager]
}
