// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	v1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1alpha1"
	v1 "k8s.io/api/core/v1"
)

// OVHCloudSDConfigApplyConfiguration represents a declarative configuration of the OVHCloudSDConfig type for use
// with apply.
type OVHCloudSDConfigApplyConfiguration struct {
	ApplicationKey    *string                `json:"applicationKey,omitempty"`
	ApplicationSecret *v1.SecretKeySelector  `json:"applicationSecret,omitempty"`
	ConsumerKey       *v1.SecretKeySelector  `json:"consumerKey,omitempty"`
	Service           *v1alpha1.OVHService   `json:"service,omitempty"`
	Endpoint          *string                `json:"endpoint,omitempty"`
	RefreshInterval   *monitoringv1.Duration `json:"refreshInterval,omitempty"`
}

// OVHCloudSDConfigApplyConfiguration constructs a declarative configuration of the OVHCloudSDConfig type for use with
// apply.
func OVHCloudSDConfig() *OVHCloudSDConfigApplyConfiguration {
	return &OVHCloudSDConfigApplyConfiguration{}
}

// WithApplicationKey sets the ApplicationKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ApplicationKey field is set to the value of the last call.
func (b *OVHCloudSDConfigApplyConfiguration) WithApplicationKey(value string) *OVHCloudSDConfigApplyConfiguration {
	b.ApplicationKey = &value
	return b
}

// WithApplicationSecret sets the ApplicationSecret field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ApplicationSecret field is set to the value of the last call.
func (b *OVHCloudSDConfigApplyConfiguration) WithApplicationSecret(value v1.SecretKeySelector) *OVHCloudSDConfigApplyConfiguration {
	b.ApplicationSecret = &value
	return b
}

// WithConsumerKey sets the ConsumerKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ConsumerKey field is set to the value of the last call.
func (b *OVHCloudSDConfigApplyConfiguration) WithConsumerKey(value v1.SecretKeySelector) *OVHCloudSDConfigApplyConfiguration {
	b.ConsumerKey = &value
	return b
}

// WithService sets the Service field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Service field is set to the value of the last call.
func (b *OVHCloudSDConfigApplyConfiguration) WithService(value v1alpha1.OVHService) *OVHCloudSDConfigApplyConfiguration {
	b.Service = &value
	return b
}

// WithEndpoint sets the Endpoint field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Endpoint field is set to the value of the last call.
func (b *OVHCloudSDConfigApplyConfiguration) WithEndpoint(value string) *OVHCloudSDConfigApplyConfiguration {
	b.Endpoint = &value
	return b
}

// WithRefreshInterval sets the RefreshInterval field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RefreshInterval field is set to the value of the last call.
func (b *OVHCloudSDConfigApplyConfiguration) WithRefreshInterval(value monitoringv1.Duration) *OVHCloudSDConfigApplyConfiguration {
	b.RefreshInterval = &value
	return b
}
