// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	v1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
)

// GCESDConfigApplyConfiguration represents a declarative configuration of the GCESDConfig type for use
// with apply.
type GCESDConfigApplyConfiguration struct {
	Project         *string      `json:"project,omitempty"`
	Zone            *string      `json:"zone,omitempty"`
	Filter          *string      `json:"filter,omitempty"`
	RefreshInterval *v1.Duration `json:"refreshInterval,omitempty"`
	Port            *int         `json:"port,omitempty"`
	TagSeparator    *string      `json:"tagSeparator,omitempty"`
}

// GCESDConfigApplyConfiguration constructs a declarative configuration of the GCESDConfig type for use with
// apply.
func GCESDConfig() *GCESDConfigApplyConfiguration {
	return &GCESDConfigApplyConfiguration{}
}

// WithProject sets the Project field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Project field is set to the value of the last call.
func (b *GCESDConfigApplyConfiguration) WithProject(value string) *GCESDConfigApplyConfiguration {
	b.Project = &value
	return b
}

// WithZone sets the Zone field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Zone field is set to the value of the last call.
func (b *GCESDConfigApplyConfiguration) WithZone(value string) *GCESDConfigApplyConfiguration {
	b.Zone = &value
	return b
}

// WithFilter sets the Filter field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Filter field is set to the value of the last call.
func (b *GCESDConfigApplyConfiguration) WithFilter(value string) *GCESDConfigApplyConfiguration {
	b.Filter = &value
	return b
}

// WithRefreshInterval sets the RefreshInterval field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RefreshInterval field is set to the value of the last call.
func (b *GCESDConfigApplyConfiguration) WithRefreshInterval(value v1.Duration) *GCESDConfigApplyConfiguration {
	b.RefreshInterval = &value
	return b
}

// WithPort sets the Port field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Port field is set to the value of the last call.
func (b *GCESDConfigApplyConfiguration) WithPort(value int) *GCESDConfigApplyConfiguration {
	b.Port = &value
	return b
}

// WithTagSeparator sets the TagSeparator field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TagSeparator field is set to the value of the last call.
func (b *GCESDConfigApplyConfiguration) WithTagSeparator(value string) *GCESDConfigApplyConfiguration {
	b.TagSeparator = &value
	return b
}
