// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	v1 "k8s.io/api/core/v1"
)

// Sigv4ApplyConfiguration represents a declarative configuration of the Sigv4 type for use
// with apply.
type Sigv4ApplyConfiguration struct {
	Region    *string               `json:"region,omitempty"`
	AccessKey *v1.SecretKeySelector `json:"accessKey,omitempty"`
	SecretKey *v1.SecretKeySelector `json:"secretKey,omitempty"`
	Profile   *string               `json:"profile,omitempty"`
	RoleArn   *string               `json:"roleArn,omitempty"`
}

// Sigv4ApplyConfiguration constructs a declarative configuration of the Sigv4 type for use with
// apply.
func Sigv4() *Sigv4ApplyConfiguration {
	return &Sigv4ApplyConfiguration{}
}

// WithRegion sets the Region field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Region field is set to the value of the last call.
func (b *Sigv4ApplyConfiguration) WithRegion(value string) *Sigv4ApplyConfiguration {
	b.Region = &value
	return b
}

// WithAccessKey sets the AccessKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AccessKey field is set to the value of the last call.
func (b *Sigv4ApplyConfiguration) WithAccessKey(value v1.SecretKeySelector) *Sigv4ApplyConfiguration {
	b.AccessKey = &value
	return b
}

// WithSecretKey sets the SecretKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecretKey field is set to the value of the last call.
func (b *Sigv4ApplyConfiguration) WithSecretKey(value v1.SecretKeySelector) *Sigv4ApplyConfiguration {
	b.SecretKey = &value
	return b
}

// WithProfile sets the Profile field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Profile field is set to the value of the last call.
func (b *Sigv4ApplyConfiguration) WithProfile(value string) *Sigv4ApplyConfiguration {
	b.Profile = &value
	return b
}

// WithRoleArn sets the RoleArn field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RoleArn field is set to the value of the last call.
func (b *Sigv4ApplyConfiguration) WithRoleArn(value string) *Sigv4ApplyConfiguration {
	b.RoleArn = &value
	return b
}
