// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	appsv1 "k8s.io/api/apps/v1"
	corev1 "k8s.io/api/core/v1"
	metav1 "k8s.io/client-go/applyconfigurations/meta/v1"
)

// PrometheusSpecApplyConfiguration represents a declarative configuration of the PrometheusSpec type for use
// with apply.
type PrometheusSpecApplyConfiguration struct {
	CommonPrometheusFieldsApplyConfiguration `json:",inline"`
	Runtime                                  *RuntimeConfigApplyConfiguration                `json:"runtime,omitempty"`
	BaseImage                                *string                                         `json:"baseImage,omitempty"`
	Tag                                      *string                                         `json:"tag,omitempty"`
	SHA                                      *string                                         `json:"sha,omitempty"`
	Retention                                *monitoringv1.Duration                          `json:"retention,omitempty"`
	RetentionSize                            *monitoringv1.ByteSize                          `json:"retentionSize,omitempty"`
	DisableCompaction                        *bool                                           `json:"disableCompaction,omitempty"`
	Rules                                    *RulesApplyConfiguration                        `json:"rules,omitempty"`
	PrometheusRulesExcludedFromEnforce       []PrometheusRuleExcludeConfigApplyConfiguration `json:"prometheusRulesExcludedFromEnforce,omitempty"`
	RuleSelector                             *metav1.LabelSelectorApplyConfiguration         `json:"ruleSelector,omitempty"`
	RuleNamespaceSelector                    *metav1.LabelSelectorApplyConfiguration         `json:"ruleNamespaceSelector,omitempty"`
	Query                                    *QuerySpecApplyConfiguration                    `json:"query,omitempty"`
	Alerting                                 *AlertingSpecApplyConfiguration                 `json:"alerting,omitempty"`
	AdditionalAlertRelabelConfigs            *corev1.SecretKeySelector                       `json:"additionalAlertRelabelConfigs,omitempty"`
	AdditionalAlertManagerConfigs            *corev1.SecretKeySelector                       `json:"additionalAlertManagerConfigs,omitempty"`
	RemoteRead                               []RemoteReadSpecApplyConfiguration              `json:"remoteRead,omitempty"`
	Thanos                                   *ThanosSpecApplyConfiguration                   `json:"thanos,omitempty"`
	QueryLogFile                             *string                                         `json:"queryLogFile,omitempty"`
	AllowOverlappingBlocks                   *bool                                           `json:"allowOverlappingBlocks,omitempty"`
	Exemplars                                *ExemplarsApplyConfiguration                    `json:"exemplars,omitempty"`
	EvaluationInterval                       *monitoringv1.Duration                          `json:"evaluationInterval,omitempty"`
	RuleQueryOffset                          *monitoringv1.Duration                          `json:"ruleQueryOffset,omitempty"`
	EnableAdminAPI                           *bool                                           `json:"enableAdminAPI,omitempty"`
}

// PrometheusSpecApplyConfiguration constructs a declarative configuration of the PrometheusSpec type for use with
// apply.
func PrometheusSpec() *PrometheusSpecApplyConfiguration {
	return &PrometheusSpecApplyConfiguration{}
}

// WithPodMetadata sets the PodMetadata field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodMetadata field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithPodMetadata(value *EmbeddedObjectMetadataApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.PodMetadata = value
	return b
}

// WithServiceMonitorSelector sets the ServiceMonitorSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceMonitorSelector field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithServiceMonitorSelector(value *metav1.LabelSelectorApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.ServiceMonitorSelector = value
	return b
}

// WithServiceMonitorNamespaceSelector sets the ServiceMonitorNamespaceSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceMonitorNamespaceSelector field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithServiceMonitorNamespaceSelector(value *metav1.LabelSelectorApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.ServiceMonitorNamespaceSelector = value
	return b
}

// WithPodMonitorSelector sets the PodMonitorSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodMonitorSelector field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithPodMonitorSelector(value *metav1.LabelSelectorApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.PodMonitorSelector = value
	return b
}

// WithPodMonitorNamespaceSelector sets the PodMonitorNamespaceSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodMonitorNamespaceSelector field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithPodMonitorNamespaceSelector(value *metav1.LabelSelectorApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.PodMonitorNamespaceSelector = value
	return b
}

// WithProbeSelector sets the ProbeSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProbeSelector field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithProbeSelector(value *metav1.LabelSelectorApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.ProbeSelector = value
	return b
}

// WithProbeNamespaceSelector sets the ProbeNamespaceSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProbeNamespaceSelector field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithProbeNamespaceSelector(value *metav1.LabelSelectorApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.ProbeNamespaceSelector = value
	return b
}

// WithScrapeConfigSelector sets the ScrapeConfigSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ScrapeConfigSelector field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithScrapeConfigSelector(value *metav1.LabelSelectorApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.ScrapeConfigSelector = value
	return b
}

// WithScrapeConfigNamespaceSelector sets the ScrapeConfigNamespaceSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ScrapeConfigNamespaceSelector field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithScrapeConfigNamespaceSelector(value *metav1.LabelSelectorApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.ScrapeConfigNamespaceSelector = value
	return b
}

// WithVersion sets the Version field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Version field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithVersion(value string) *PrometheusSpecApplyConfiguration {
	b.Version = &value
	return b
}

// WithPaused sets the Paused field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Paused field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithPaused(value bool) *PrometheusSpecApplyConfiguration {
	b.Paused = &value
	return b
}

// WithImage sets the Image field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Image field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithImage(value string) *PrometheusSpecApplyConfiguration {
	b.Image = &value
	return b
}

// WithImagePullPolicy sets the ImagePullPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ImagePullPolicy field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithImagePullPolicy(value corev1.PullPolicy) *PrometheusSpecApplyConfiguration {
	b.ImagePullPolicy = &value
	return b
}

// WithImagePullSecrets adds the given value to the ImagePullSecrets field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ImagePullSecrets field.
func (b *PrometheusSpecApplyConfiguration) WithImagePullSecrets(values ...corev1.LocalObjectReference) *PrometheusSpecApplyConfiguration {
	for i := range values {
		b.ImagePullSecrets = append(b.ImagePullSecrets, values[i])
	}
	return b
}

// WithReplicas sets the Replicas field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Replicas field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithReplicas(value int32) *PrometheusSpecApplyConfiguration {
	b.Replicas = &value
	return b
}

// WithShards sets the Shards field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Shards field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithShards(value int32) *PrometheusSpecApplyConfiguration {
	b.Shards = &value
	return b
}

// WithReplicaExternalLabelName sets the ReplicaExternalLabelName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ReplicaExternalLabelName field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithReplicaExternalLabelName(value string) *PrometheusSpecApplyConfiguration {
	b.ReplicaExternalLabelName = &value
	return b
}

// WithPrometheusExternalLabelName sets the PrometheusExternalLabelName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PrometheusExternalLabelName field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithPrometheusExternalLabelName(value string) *PrometheusSpecApplyConfiguration {
	b.PrometheusExternalLabelName = &value
	return b
}

// WithLogLevel sets the LogLevel field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LogLevel field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithLogLevel(value string) *PrometheusSpecApplyConfiguration {
	b.LogLevel = &value
	return b
}

// WithLogFormat sets the LogFormat field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LogFormat field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithLogFormat(value string) *PrometheusSpecApplyConfiguration {
	b.LogFormat = &value
	return b
}

// WithScrapeInterval sets the ScrapeInterval field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ScrapeInterval field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithScrapeInterval(value monitoringv1.Duration) *PrometheusSpecApplyConfiguration {
	b.ScrapeInterval = &value
	return b
}

// WithScrapeTimeout sets the ScrapeTimeout field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ScrapeTimeout field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithScrapeTimeout(value monitoringv1.Duration) *PrometheusSpecApplyConfiguration {
	b.ScrapeTimeout = &value
	return b
}

// WithScrapeProtocols adds the given value to the ScrapeProtocols field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ScrapeProtocols field.
func (b *PrometheusSpecApplyConfiguration) WithScrapeProtocols(values ...monitoringv1.ScrapeProtocol) *PrometheusSpecApplyConfiguration {
	for i := range values {
		b.ScrapeProtocols = append(b.ScrapeProtocols, values[i])
	}
	return b
}

// WithExternalLabels puts the entries into the ExternalLabels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the ExternalLabels field,
// overwriting an existing map entries in ExternalLabels field with the same key.
func (b *PrometheusSpecApplyConfiguration) WithExternalLabels(entries map[string]string) *PrometheusSpecApplyConfiguration {
	if b.ExternalLabels == nil && len(entries) > 0 {
		b.ExternalLabels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.ExternalLabels[k] = v
	}
	return b
}

// WithEnableRemoteWriteReceiver sets the EnableRemoteWriteReceiver field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnableRemoteWriteReceiver field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithEnableRemoteWriteReceiver(value bool) *PrometheusSpecApplyConfiguration {
	b.EnableRemoteWriteReceiver = &value
	return b
}

// WithRemoteWriteReceiverMessageVersions adds the given value to the RemoteWriteReceiverMessageVersions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RemoteWriteReceiverMessageVersions field.
func (b *PrometheusSpecApplyConfiguration) WithRemoteWriteReceiverMessageVersions(values ...monitoringv1.RemoteWriteMessageVersion) *PrometheusSpecApplyConfiguration {
	for i := range values {
		b.RemoteWriteReceiverMessageVersions = append(b.RemoteWriteReceiverMessageVersions, values[i])
	}
	return b
}

// WithEnableFeatures adds the given value to the EnableFeatures field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the EnableFeatures field.
func (b *PrometheusSpecApplyConfiguration) WithEnableFeatures(values ...monitoringv1.EnableFeature) *PrometheusSpecApplyConfiguration {
	for i := range values {
		b.EnableFeatures = append(b.EnableFeatures, values[i])
	}
	return b
}

// WithExternalURL sets the ExternalURL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ExternalURL field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithExternalURL(value string) *PrometheusSpecApplyConfiguration {
	b.ExternalURL = &value
	return b
}

// WithRoutePrefix sets the RoutePrefix field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RoutePrefix field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithRoutePrefix(value string) *PrometheusSpecApplyConfiguration {
	b.RoutePrefix = &value
	return b
}

// WithStorage sets the Storage field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Storage field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithStorage(value *StorageSpecApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.Storage = value
	return b
}

// WithVolumes adds the given value to the Volumes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Volumes field.
func (b *PrometheusSpecApplyConfiguration) WithVolumes(values ...corev1.Volume) *PrometheusSpecApplyConfiguration {
	for i := range values {
		b.Volumes = append(b.Volumes, values[i])
	}
	return b
}

// WithVolumeMounts adds the given value to the VolumeMounts field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the VolumeMounts field.
func (b *PrometheusSpecApplyConfiguration) WithVolumeMounts(values ...corev1.VolumeMount) *PrometheusSpecApplyConfiguration {
	for i := range values {
		b.VolumeMounts = append(b.VolumeMounts, values[i])
	}
	return b
}

// WithPersistentVolumeClaimRetentionPolicy sets the PersistentVolumeClaimRetentionPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PersistentVolumeClaimRetentionPolicy field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithPersistentVolumeClaimRetentionPolicy(value appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy) *PrometheusSpecApplyConfiguration {
	b.PersistentVolumeClaimRetentionPolicy = &value
	return b
}

// WithWeb sets the Web field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Web field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithWeb(value *PrometheusWebSpecApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.Web = value
	return b
}

// WithResources sets the Resources field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Resources field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithResources(value corev1.ResourceRequirements) *PrometheusSpecApplyConfiguration {
	b.Resources = &value
	return b
}

// WithNodeSelector puts the entries into the NodeSelector field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the NodeSelector field,
// overwriting an existing map entries in NodeSelector field with the same key.
func (b *PrometheusSpecApplyConfiguration) WithNodeSelector(entries map[string]string) *PrometheusSpecApplyConfiguration {
	if b.NodeSelector == nil && len(entries) > 0 {
		b.NodeSelector = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.NodeSelector[k] = v
	}
	return b
}

// WithServiceAccountName sets the ServiceAccountName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceAccountName field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithServiceAccountName(value string) *PrometheusSpecApplyConfiguration {
	b.ServiceAccountName = &value
	return b
}

// WithAutomountServiceAccountToken sets the AutomountServiceAccountToken field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AutomountServiceAccountToken field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithAutomountServiceAccountToken(value bool) *PrometheusSpecApplyConfiguration {
	b.AutomountServiceAccountToken = &value
	return b
}

// WithSecrets adds the given value to the Secrets field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Secrets field.
func (b *PrometheusSpecApplyConfiguration) WithSecrets(values ...string) *PrometheusSpecApplyConfiguration {
	for i := range values {
		b.Secrets = append(b.Secrets, values[i])
	}
	return b
}

// WithConfigMaps adds the given value to the ConfigMaps field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ConfigMaps field.
func (b *PrometheusSpecApplyConfiguration) WithConfigMaps(values ...string) *PrometheusSpecApplyConfiguration {
	for i := range values {
		b.ConfigMaps = append(b.ConfigMaps, values[i])
	}
	return b
}

// WithAffinity sets the Affinity field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Affinity field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithAffinity(value corev1.Affinity) *PrometheusSpecApplyConfiguration {
	b.Affinity = &value
	return b
}

// WithTolerations adds the given value to the Tolerations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Tolerations field.
func (b *PrometheusSpecApplyConfiguration) WithTolerations(values ...corev1.Toleration) *PrometheusSpecApplyConfiguration {
	for i := range values {
		b.Tolerations = append(b.Tolerations, values[i])
	}
	return b
}

// WithTopologySpreadConstraints adds the given value to the TopologySpreadConstraints field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the TopologySpreadConstraints field.
func (b *PrometheusSpecApplyConfiguration) WithTopologySpreadConstraints(values ...*TopologySpreadConstraintApplyConfiguration) *PrometheusSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithTopologySpreadConstraints")
		}
		b.TopologySpreadConstraints = append(b.TopologySpreadConstraints, *values[i])
	}
	return b
}

// WithRemoteWrite adds the given value to the RemoteWrite field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RemoteWrite field.
func (b *PrometheusSpecApplyConfiguration) WithRemoteWrite(values ...*RemoteWriteSpecApplyConfiguration) *PrometheusSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRemoteWrite")
		}
		b.RemoteWrite = append(b.RemoteWrite, *values[i])
	}
	return b
}

// WithOTLP sets the OTLP field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the OTLP field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithOTLP(value *OTLPConfigApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.OTLP = value
	return b
}

// WithSecurityContext sets the SecurityContext field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecurityContext field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithSecurityContext(value corev1.PodSecurityContext) *PrometheusSpecApplyConfiguration {
	b.SecurityContext = &value
	return b
}

// WithDNSPolicy sets the DNSPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DNSPolicy field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithDNSPolicy(value monitoringv1.DNSPolicy) *PrometheusSpecApplyConfiguration {
	b.DNSPolicy = &value
	return b
}

// WithDNSConfig sets the DNSConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DNSConfig field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithDNSConfig(value *PodDNSConfigApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.DNSConfig = value
	return b
}

// WithListenLocal sets the ListenLocal field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ListenLocal field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithListenLocal(value bool) *PrometheusSpecApplyConfiguration {
	b.ListenLocal = &value
	return b
}

// WithContainers adds the given value to the Containers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Containers field.
func (b *PrometheusSpecApplyConfiguration) WithContainers(values ...corev1.Container) *PrometheusSpecApplyConfiguration {
	for i := range values {
		b.Containers = append(b.Containers, values[i])
	}
	return b
}

// WithInitContainers adds the given value to the InitContainers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the InitContainers field.
func (b *PrometheusSpecApplyConfiguration) WithInitContainers(values ...corev1.Container) *PrometheusSpecApplyConfiguration {
	for i := range values {
		b.InitContainers = append(b.InitContainers, values[i])
	}
	return b
}

// WithAdditionalScrapeConfigs sets the AdditionalScrapeConfigs field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AdditionalScrapeConfigs field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithAdditionalScrapeConfigs(value corev1.SecretKeySelector) *PrometheusSpecApplyConfiguration {
	b.AdditionalScrapeConfigs = &value
	return b
}

// WithAPIServerConfig sets the APIServerConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIServerConfig field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithAPIServerConfig(value *APIServerConfigApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.APIServerConfig = value
	return b
}

// WithPriorityClassName sets the PriorityClassName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PriorityClassName field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithPriorityClassName(value string) *PrometheusSpecApplyConfiguration {
	b.PriorityClassName = &value
	return b
}

// WithPortName sets the PortName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PortName field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithPortName(value string) *PrometheusSpecApplyConfiguration {
	b.PortName = &value
	return b
}

// WithArbitraryFSAccessThroughSMs sets the ArbitraryFSAccessThroughSMs field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ArbitraryFSAccessThroughSMs field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithArbitraryFSAccessThroughSMs(value *ArbitraryFSAccessThroughSMsConfigApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.ArbitraryFSAccessThroughSMs = value
	return b
}

// WithOverrideHonorLabels sets the OverrideHonorLabels field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the OverrideHonorLabels field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithOverrideHonorLabels(value bool) *PrometheusSpecApplyConfiguration {
	b.OverrideHonorLabels = &value
	return b
}

// WithOverrideHonorTimestamps sets the OverrideHonorTimestamps field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the OverrideHonorTimestamps field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithOverrideHonorTimestamps(value bool) *PrometheusSpecApplyConfiguration {
	b.OverrideHonorTimestamps = &value
	return b
}

// WithIgnoreNamespaceSelectors sets the IgnoreNamespaceSelectors field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IgnoreNamespaceSelectors field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithIgnoreNamespaceSelectors(value bool) *PrometheusSpecApplyConfiguration {
	b.IgnoreNamespaceSelectors = &value
	return b
}

// WithEnforcedNamespaceLabel sets the EnforcedNamespaceLabel field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedNamespaceLabel field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithEnforcedNamespaceLabel(value string) *PrometheusSpecApplyConfiguration {
	b.EnforcedNamespaceLabel = &value
	return b
}

// WithEnforcedSampleLimit sets the EnforcedSampleLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedSampleLimit field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithEnforcedSampleLimit(value uint64) *PrometheusSpecApplyConfiguration {
	b.EnforcedSampleLimit = &value
	return b
}

// WithEnforcedTargetLimit sets the EnforcedTargetLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedTargetLimit field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithEnforcedTargetLimit(value uint64) *PrometheusSpecApplyConfiguration {
	b.EnforcedTargetLimit = &value
	return b
}

// WithEnforcedLabelLimit sets the EnforcedLabelLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedLabelLimit field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithEnforcedLabelLimit(value uint64) *PrometheusSpecApplyConfiguration {
	b.EnforcedLabelLimit = &value
	return b
}

// WithEnforcedLabelNameLengthLimit sets the EnforcedLabelNameLengthLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedLabelNameLengthLimit field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithEnforcedLabelNameLengthLimit(value uint64) *PrometheusSpecApplyConfiguration {
	b.EnforcedLabelNameLengthLimit = &value
	return b
}

// WithEnforcedLabelValueLengthLimit sets the EnforcedLabelValueLengthLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedLabelValueLengthLimit field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithEnforcedLabelValueLengthLimit(value uint64) *PrometheusSpecApplyConfiguration {
	b.EnforcedLabelValueLengthLimit = &value
	return b
}

// WithEnforcedKeepDroppedTargets sets the EnforcedKeepDroppedTargets field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedKeepDroppedTargets field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithEnforcedKeepDroppedTargets(value uint64) *PrometheusSpecApplyConfiguration {
	b.EnforcedKeepDroppedTargets = &value
	return b
}

// WithEnforcedBodySizeLimit sets the EnforcedBodySizeLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnforcedBodySizeLimit field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithEnforcedBodySizeLimit(value monitoringv1.ByteSize) *PrometheusSpecApplyConfiguration {
	b.EnforcedBodySizeLimit = &value
	return b
}

// WithMinReadySeconds sets the MinReadySeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MinReadySeconds field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithMinReadySeconds(value uint32) *PrometheusSpecApplyConfiguration {
	b.MinReadySeconds = &value
	return b
}

// WithHostAliases adds the given value to the HostAliases field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the HostAliases field.
func (b *PrometheusSpecApplyConfiguration) WithHostAliases(values ...*HostAliasApplyConfiguration) *PrometheusSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithHostAliases")
		}
		b.HostAliases = append(b.HostAliases, *values[i])
	}
	return b
}

// WithAdditionalArgs adds the given value to the AdditionalArgs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AdditionalArgs field.
func (b *PrometheusSpecApplyConfiguration) WithAdditionalArgs(values ...*ArgumentApplyConfiguration) *PrometheusSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithAdditionalArgs")
		}
		b.AdditionalArgs = append(b.AdditionalArgs, *values[i])
	}
	return b
}

// WithWALCompression sets the WALCompression field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the WALCompression field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithWALCompression(value bool) *PrometheusSpecApplyConfiguration {
	b.WALCompression = &value
	return b
}

// WithExcludedFromEnforcement adds the given value to the ExcludedFromEnforcement field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ExcludedFromEnforcement field.
func (b *PrometheusSpecApplyConfiguration) WithExcludedFromEnforcement(values ...*ObjectReferenceApplyConfiguration) *PrometheusSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithExcludedFromEnforcement")
		}
		b.ExcludedFromEnforcement = append(b.ExcludedFromEnforcement, *values[i])
	}
	return b
}

// WithHostNetwork sets the HostNetwork field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HostNetwork field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithHostNetwork(value bool) *PrometheusSpecApplyConfiguration {
	b.HostNetwork = &value
	return b
}

// WithPodTargetLabels adds the given value to the PodTargetLabels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the PodTargetLabels field.
func (b *PrometheusSpecApplyConfiguration) WithPodTargetLabels(values ...string) *PrometheusSpecApplyConfiguration {
	for i := range values {
		b.PodTargetLabels = append(b.PodTargetLabels, values[i])
	}
	return b
}

// WithTracingConfig sets the TracingConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TracingConfig field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithTracingConfig(value *PrometheusTracingConfigApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.TracingConfig = value
	return b
}

// WithBodySizeLimit sets the BodySizeLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BodySizeLimit field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithBodySizeLimit(value monitoringv1.ByteSize) *PrometheusSpecApplyConfiguration {
	b.BodySizeLimit = &value
	return b
}

// WithSampleLimit sets the SampleLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SampleLimit field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithSampleLimit(value uint64) *PrometheusSpecApplyConfiguration {
	b.SampleLimit = &value
	return b
}

// WithTargetLimit sets the TargetLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TargetLimit field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithTargetLimit(value uint64) *PrometheusSpecApplyConfiguration {
	b.TargetLimit = &value
	return b
}

// WithLabelLimit sets the LabelLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LabelLimit field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithLabelLimit(value uint64) *PrometheusSpecApplyConfiguration {
	b.LabelLimit = &value
	return b
}

// WithLabelNameLengthLimit sets the LabelNameLengthLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LabelNameLengthLimit field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithLabelNameLengthLimit(value uint64) *PrometheusSpecApplyConfiguration {
	b.LabelNameLengthLimit = &value
	return b
}

// WithLabelValueLengthLimit sets the LabelValueLengthLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LabelValueLengthLimit field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithLabelValueLengthLimit(value uint64) *PrometheusSpecApplyConfiguration {
	b.LabelValueLengthLimit = &value
	return b
}

// WithKeepDroppedTargets sets the KeepDroppedTargets field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the KeepDroppedTargets field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithKeepDroppedTargets(value uint64) *PrometheusSpecApplyConfiguration {
	b.KeepDroppedTargets = &value
	return b
}

// WithReloadStrategy sets the ReloadStrategy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ReloadStrategy field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithReloadStrategy(value monitoringv1.ReloadStrategyType) *PrometheusSpecApplyConfiguration {
	b.ReloadStrategy = &value
	return b
}

// WithMaximumStartupDurationSeconds sets the MaximumStartupDurationSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaximumStartupDurationSeconds field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithMaximumStartupDurationSeconds(value int32) *PrometheusSpecApplyConfiguration {
	b.MaximumStartupDurationSeconds = &value
	return b
}

// WithScrapeClasses adds the given value to the ScrapeClasses field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ScrapeClasses field.
func (b *PrometheusSpecApplyConfiguration) WithScrapeClasses(values ...*ScrapeClassApplyConfiguration) *PrometheusSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithScrapeClasses")
		}
		b.ScrapeClasses = append(b.ScrapeClasses, *values[i])
	}
	return b
}

// WithServiceDiscoveryRole sets the ServiceDiscoveryRole field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceDiscoveryRole field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithServiceDiscoveryRole(value monitoringv1.ServiceDiscoveryRole) *PrometheusSpecApplyConfiguration {
	b.ServiceDiscoveryRole = &value
	return b
}

// WithTSDB sets the TSDB field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TSDB field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithTSDB(value *TSDBSpecApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.TSDB = value
	return b
}

// WithRuntime sets the Runtime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Runtime field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithRuntime(value *RuntimeConfigApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.Runtime = value
	return b
}

// WithBaseImage sets the BaseImage field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BaseImage field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithBaseImage(value string) *PrometheusSpecApplyConfiguration {
	b.BaseImage = &value
	return b
}

// WithTag sets the Tag field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Tag field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithTag(value string) *PrometheusSpecApplyConfiguration {
	b.Tag = &value
	return b
}

// WithSHA sets the SHA field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SHA field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithSHA(value string) *PrometheusSpecApplyConfiguration {
	b.SHA = &value
	return b
}

// WithRetention sets the Retention field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Retention field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithRetention(value monitoringv1.Duration) *PrometheusSpecApplyConfiguration {
	b.Retention = &value
	return b
}

// WithRetentionSize sets the RetentionSize field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RetentionSize field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithRetentionSize(value monitoringv1.ByteSize) *PrometheusSpecApplyConfiguration {
	b.RetentionSize = &value
	return b
}

// WithDisableCompaction sets the DisableCompaction field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DisableCompaction field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithDisableCompaction(value bool) *PrometheusSpecApplyConfiguration {
	b.DisableCompaction = &value
	return b
}

// WithRules sets the Rules field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Rules field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithRules(value *RulesApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.Rules = value
	return b
}

// WithPrometheusRulesExcludedFromEnforce adds the given value to the PrometheusRulesExcludedFromEnforce field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the PrometheusRulesExcludedFromEnforce field.
func (b *PrometheusSpecApplyConfiguration) WithPrometheusRulesExcludedFromEnforce(values ...*PrometheusRuleExcludeConfigApplyConfiguration) *PrometheusSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithPrometheusRulesExcludedFromEnforce")
		}
		b.PrometheusRulesExcludedFromEnforce = append(b.PrometheusRulesExcludedFromEnforce, *values[i])
	}
	return b
}

// WithRuleSelector sets the RuleSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RuleSelector field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithRuleSelector(value *metav1.LabelSelectorApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.RuleSelector = value
	return b
}

// WithRuleNamespaceSelector sets the RuleNamespaceSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RuleNamespaceSelector field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithRuleNamespaceSelector(value *metav1.LabelSelectorApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.RuleNamespaceSelector = value
	return b
}

// WithQuery sets the Query field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Query field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithQuery(value *QuerySpecApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.Query = value
	return b
}

// WithAlerting sets the Alerting field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Alerting field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithAlerting(value *AlertingSpecApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.Alerting = value
	return b
}

// WithAdditionalAlertRelabelConfigs sets the AdditionalAlertRelabelConfigs field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AdditionalAlertRelabelConfigs field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithAdditionalAlertRelabelConfigs(value corev1.SecretKeySelector) *PrometheusSpecApplyConfiguration {
	b.AdditionalAlertRelabelConfigs = &value
	return b
}

// WithAdditionalAlertManagerConfigs sets the AdditionalAlertManagerConfigs field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AdditionalAlertManagerConfigs field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithAdditionalAlertManagerConfigs(value corev1.SecretKeySelector) *PrometheusSpecApplyConfiguration {
	b.AdditionalAlertManagerConfigs = &value
	return b
}

// WithRemoteRead adds the given value to the RemoteRead field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RemoteRead field.
func (b *PrometheusSpecApplyConfiguration) WithRemoteRead(values ...*RemoteReadSpecApplyConfiguration) *PrometheusSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRemoteRead")
		}
		b.RemoteRead = append(b.RemoteRead, *values[i])
	}
	return b
}

// WithThanos sets the Thanos field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Thanos field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithThanos(value *ThanosSpecApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.Thanos = value
	return b
}

// WithQueryLogFile sets the QueryLogFile field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the QueryLogFile field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithQueryLogFile(value string) *PrometheusSpecApplyConfiguration {
	b.QueryLogFile = &value
	return b
}

// WithAllowOverlappingBlocks sets the AllowOverlappingBlocks field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AllowOverlappingBlocks field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithAllowOverlappingBlocks(value bool) *PrometheusSpecApplyConfiguration {
	b.AllowOverlappingBlocks = &value
	return b
}

// WithExemplars sets the Exemplars field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Exemplars field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithExemplars(value *ExemplarsApplyConfiguration) *PrometheusSpecApplyConfiguration {
	b.Exemplars = value
	return b
}

// WithEvaluationInterval sets the EvaluationInterval field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EvaluationInterval field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithEvaluationInterval(value monitoringv1.Duration) *PrometheusSpecApplyConfiguration {
	b.EvaluationInterval = &value
	return b
}

// WithRuleQueryOffset sets the RuleQueryOffset field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RuleQueryOffset field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithRuleQueryOffset(value monitoringv1.Duration) *PrometheusSpecApplyConfiguration {
	b.RuleQueryOffset = &value
	return b
}

// WithEnableAdminAPI sets the EnableAdminAPI field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnableAdminAPI field is set to the value of the last call.
func (b *PrometheusSpecApplyConfiguration) WithEnableAdminAPI(value bool) *PrometheusSpecApplyConfiguration {
	b.EnableAdminAPI = &value
	return b
}
