// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// ProbeTargetStaticConfigApplyConfiguration represents a declarative configuration of the ProbeTargetStaticConfig type for use
// with apply.
type ProbeTargetStaticConfigApplyConfiguration struct {
	Targets        []string                          `json:"static,omitempty"`
	Labels         map[string]string                 `json:"labels,omitempty"`
	RelabelConfigs []RelabelConfigApplyConfiguration `json:"relabelingConfigs,omitempty"`
}

// ProbeTargetStaticConfigApplyConfiguration constructs a declarative configuration of the ProbeTargetStaticConfig type for use with
// apply.
func ProbeTargetStaticConfig() *ProbeTargetStaticConfigApplyConfiguration {
	return &ProbeTargetStaticConfigApplyConfiguration{}
}

// WithTargets adds the given value to the Targets field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Targets field.
func (b *ProbeTargetStaticConfigApplyConfiguration) WithTargets(values ...string) *ProbeTargetStaticConfigApplyConfiguration {
	for i := range values {
		b.Targets = append(b.Targets, values[i])
	}
	return b
}

// WithLabels puts the entries into the Labels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Labels field,
// overwriting an existing map entries in Labels field with the same key.
func (b *ProbeTargetStaticConfigApplyConfiguration) WithLabels(entries map[string]string) *ProbeTargetStaticConfigApplyConfiguration {
	if b.Labels == nil && len(entries) > 0 {
		b.Labels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Labels[k] = v
	}
	return b
}

// WithRelabelConfigs adds the given value to the RelabelConfigs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RelabelConfigs field.
func (b *ProbeTargetStaticConfigApplyConfiguration) WithRelabelConfigs(values ...*RelabelConfigApplyConfiguration) *ProbeTargetStaticConfigApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRelabelConfigs")
		}
		b.RelabelConfigs = append(b.RelabelConfigs, *values[i])
	}
	return b
}
