// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	v1 "k8s.io/api/core/v1"
)

// AzureOAuthApplyConfiguration represents a declarative configuration of the AzureOAuth type for use
// with apply.
type AzureOAuthApplyConfiguration struct {
	ClientID     *string               `json:"clientId,omitempty"`
	ClientSecret *v1.SecretKeySelector `json:"clientSecret,omitempty"`
	TenantID     *string               `json:"tenantId,omitempty"`
}

// AzureOAuthApplyConfiguration constructs a declarative configuration of the AzureOAuth type for use with
// apply.
func AzureOAuth() *AzureOAuthApplyConfiguration {
	return &AzureOAuthApplyConfiguration{}
}

// WithClientID sets the ClientID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ClientID field is set to the value of the last call.
func (b *AzureOAuthApplyConfiguration) WithClientID(value string) *AzureOAuthApplyConfiguration {
	b.ClientID = &value
	return b
}

// WithClientSecret sets the ClientSecret field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ClientSecret field is set to the value of the last call.
func (b *AzureOAuthApplyConfiguration) WithClientSecret(value v1.SecretKeySelector) *AzureOAuthApplyConfiguration {
	b.ClientSecret = &value
	return b
}

// WithTenantID sets the TenantID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TenantID field is set to the value of the last call.
func (b *AzureOAuthApplyConfiguration) WithTenantID(value string) *AzureOAuthApplyConfiguration {
	b.TenantID = &value
	return b
}
