// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
)

// AlertmanagerEndpointsApplyConfiguration represents a declarative configuration of the AlertmanagerEndpoints type for use
// with apply.
type AlertmanagerEndpointsApplyConfiguration struct {
	Namespace           *string                              `json:"namespace,omitempty"`
	Name                *string                              `json:"name,omitempty"`
	Port                *intstr.IntOrString                  `json:"port,omitempty"`
	Scheme              *string                              `json:"scheme,omitempty"`
	PathPrefix          *string                              `json:"pathPrefix,omitempty"`
	TLSConfig           *TLSConfigApplyConfiguration         `json:"tlsConfig,omitempty"`
	BasicAuth           *BasicAuthApplyConfiguration         `json:"basicAuth,omitempty"`
	BearerTokenFile     *string                              `json:"bearerTokenFile,omitempty"`
	Authorization       *SafeAuthorizationApplyConfiguration `json:"authorization,omitempty"`
	Sigv4               *Sigv4ApplyConfiguration             `json:"sigv4,omitempty"`
	APIVersion          *string                              `json:"apiVersion,omitempty"`
	Timeout             *monitoringv1.Duration               `json:"timeout,omitempty"`
	EnableHttp2         *bool                                `json:"enableHttp2,omitempty"`
	RelabelConfigs      []RelabelConfigApplyConfiguration    `json:"relabelings,omitempty"`
	AlertRelabelConfigs []RelabelConfigApplyConfiguration    `json:"alertRelabelings,omitempty"`
}

// AlertmanagerEndpointsApplyConfiguration constructs a declarative configuration of the AlertmanagerEndpoints type for use with
// apply.
func AlertmanagerEndpoints() *AlertmanagerEndpointsApplyConfiguration {
	return &AlertmanagerEndpointsApplyConfiguration{}
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *AlertmanagerEndpointsApplyConfiguration) WithNamespace(value string) *AlertmanagerEndpointsApplyConfiguration {
	b.Namespace = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *AlertmanagerEndpointsApplyConfiguration) WithName(value string) *AlertmanagerEndpointsApplyConfiguration {
	b.Name = &value
	return b
}

// WithPort sets the Port field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Port field is set to the value of the last call.
func (b *AlertmanagerEndpointsApplyConfiguration) WithPort(value intstr.IntOrString) *AlertmanagerEndpointsApplyConfiguration {
	b.Port = &value
	return b
}

// WithScheme sets the Scheme field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Scheme field is set to the value of the last call.
func (b *AlertmanagerEndpointsApplyConfiguration) WithScheme(value string) *AlertmanagerEndpointsApplyConfiguration {
	b.Scheme = &value
	return b
}

// WithPathPrefix sets the PathPrefix field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PathPrefix field is set to the value of the last call.
func (b *AlertmanagerEndpointsApplyConfiguration) WithPathPrefix(value string) *AlertmanagerEndpointsApplyConfiguration {
	b.PathPrefix = &value
	return b
}

// WithTLSConfig sets the TLSConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TLSConfig field is set to the value of the last call.
func (b *AlertmanagerEndpointsApplyConfiguration) WithTLSConfig(value *TLSConfigApplyConfiguration) *AlertmanagerEndpointsApplyConfiguration {
	b.TLSConfig = value
	return b
}

// WithBasicAuth sets the BasicAuth field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BasicAuth field is set to the value of the last call.
func (b *AlertmanagerEndpointsApplyConfiguration) WithBasicAuth(value *BasicAuthApplyConfiguration) *AlertmanagerEndpointsApplyConfiguration {
	b.BasicAuth = value
	return b
}

// WithBearerTokenFile sets the BearerTokenFile field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BearerTokenFile field is set to the value of the last call.
func (b *AlertmanagerEndpointsApplyConfiguration) WithBearerTokenFile(value string) *AlertmanagerEndpointsApplyConfiguration {
	b.BearerTokenFile = &value
	return b
}

// WithAuthorization sets the Authorization field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Authorization field is set to the value of the last call.
func (b *AlertmanagerEndpointsApplyConfiguration) WithAuthorization(value *SafeAuthorizationApplyConfiguration) *AlertmanagerEndpointsApplyConfiguration {
	b.Authorization = value
	return b
}

// WithSigv4 sets the Sigv4 field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Sigv4 field is set to the value of the last call.
func (b *AlertmanagerEndpointsApplyConfiguration) WithSigv4(value *Sigv4ApplyConfiguration) *AlertmanagerEndpointsApplyConfiguration {
	b.Sigv4 = value
	return b
}

// WithAPIVersion sets the APIVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIVersion field is set to the value of the last call.
func (b *AlertmanagerEndpointsApplyConfiguration) WithAPIVersion(value string) *AlertmanagerEndpointsApplyConfiguration {
	b.APIVersion = &value
	return b
}

// WithTimeout sets the Timeout field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Timeout field is set to the value of the last call.
func (b *AlertmanagerEndpointsApplyConfiguration) WithTimeout(value monitoringv1.Duration) *AlertmanagerEndpointsApplyConfiguration {
	b.Timeout = &value
	return b
}

// WithEnableHttp2 sets the EnableHttp2 field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnableHttp2 field is set to the value of the last call.
func (b *AlertmanagerEndpointsApplyConfiguration) WithEnableHttp2(value bool) *AlertmanagerEndpointsApplyConfiguration {
	b.EnableHttp2 = &value
	return b
}

// WithRelabelConfigs adds the given value to the RelabelConfigs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RelabelConfigs field.
func (b *AlertmanagerEndpointsApplyConfiguration) WithRelabelConfigs(values ...*RelabelConfigApplyConfiguration) *AlertmanagerEndpointsApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRelabelConfigs")
		}
		b.RelabelConfigs = append(b.RelabelConfigs, *values[i])
	}
	return b
}

// WithAlertRelabelConfigs adds the given value to the AlertRelabelConfigs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AlertRelabelConfigs field.
func (b *AlertmanagerEndpointsApplyConfiguration) WithAlertRelabelConfigs(values ...*RelabelConfigApplyConfiguration) *AlertmanagerEndpointsApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithAlertRelabelConfigs")
		}
		b.AlertRelabelConfigs = append(b.AlertRelabelConfigs, *values[i])
	}
	return b
}
