---
weight: 209
toc: true
title: Strategic Merge Patch
menu:
    docs:
        parent: operator
lead: ""
images: []
draft: false
description: Using strategic merge patch to overwrite container definition.
---

This document describes how to overwrite the configuration generated by the
operator using [strategic merge
patches](https://kubernetes.io/docs/tasks/manage-kubernetes-objects/update-api-object-kubectl-patch/#use-a-strategic-merge-patch-to-update-a-deployment).

When users need to apply a specific configuration to the containers that is
either not exposed in the custom resource definitions or already defined by
the operator, strategic merge patch can be used.

## How does it work?

The `Prometheus`, `Alertmanager`, and `ThanosRuler` CRDs expose a
`spec.containers` field which allows to:

* Override fields for the containers generated by the operator.
* Inject fields for existing containers.

## How to patch a container probe

### Merging patch for Prometheus

The following manifest overwrites the `failureThreshold` value of startup
probe of the Prometheus container:

```yaml
apiVersion: monitoring.coreos.com/v1
kind: Prometheus
metadata:
  name: overwrite-failureThreshold
spec:
  containers:
  - name: prometheus
    startupProbe:
      failureThreshold: 500
```

### Merging patch for Alertmanager

The following manifest overwrites the `failureThreshold` values of the
readiness and liveness probes for the Alertmanager container.

```yaml
apiVersion: monitoring.coreos.com/v1
kind: Alertmanager
metadata:
  name: overwrite-probes
spec:
  containers:
  - name: alertmanager
    livenessProbe:
      failureThreshold: 5
    readinessProbe:
      failureThreshold: 5
```

## How to inject an environment variable in an existing container

The following manifest injects the environment variable `GOMEMLIMIT` to the Prometheus container:

```yaml
apiVersion: monitoring.coreos.com/v1
kind: Prometheus
metadata:
  name: inject-env-var
spec:
  containers:
  - name: "prometheus"
    env:
    - name: GOMEMLIMIT
      value: 6Gi
```

## How to inject a sidecar container

The following manifest injects an additional container to the generated StatefulSet:

```yaml
apiVersion: monitoring.coreos.com/v1
kind: Prometheus
metadata:
  name: inject-sidecar
spec:
  containers:
  - name: "sleep"
    image: "busybox"
    args:
    - sleep
    - "3600"
```

## How to inject additional CLI arguments into the prometheus container

The following manifest injects an additional CLI argument in the default
Prometheus argument list. Note the use of `.spec.additionalArgs` in this
example.
Using `.spec.containers[*].args` directly would instead overwrite the container's
`args` list completely, including the default arguments.

```yaml
apiVersion: monitoring.coreos.com/v1
kind: Prometheus
metadata:
  name: additional-arguments
spec:
  additionalArgs:
  - name: "scrape.timestamp-tolerance"
    value: "15ms"
```
