This file was generated by `calico-felix-docgen`. Do not edit directly.

## Sections
* [Datastore connection](#datastore-connection)
* [Process: Feature detection/overrides](#process-feature-detectionoverrides)
* [Process: Go runtime](#process-go-runtime)
* [Process: Health port and timeouts](#process-health-port-and-timeouts)
* [Process: Logging](#process-logging)
* [Process: Prometheus metrics](#process-prometheus-metrics)
* [Dataplane: Common](#dataplane-common)
* [Dataplane: iptables](#dataplane-iptables)
* [Dataplane: nftables](#dataplane-nftables)
* [Dataplane: eBPF](#dataplane-ebpf)
* [Dataplane: Windows](#dataplane-windows)
* [Dataplane: OpenStack support](#dataplane-openstack-support)
* [Dataplane: XDP acceleration for iptables dataplane](#dataplane-xdp-acceleration-for-iptables-dataplane)
* [Overlay: VXLAN overlay](#overlay-vxlan-overlay)
* [Overlay: IP-in-IP](#overlay-ip-in-ip)
* [Overlay: Wireguard](#overlay-wireguard)
* [AWS integration](#aws-integration)
* [Debug/test-only (generally unsupported)](#debugtest-only-generally-unsupported)
* [Usage reporting](#usage-reporting)

## <a id="datastore-connection">Datastore connection

### `DatastoreType` (config file / env var only)

Controls which datastore driver Felix will use. Typically, this is detected from the environment
and it does not need to be set manually. (For example, if `KUBECONFIG` is set, the kubernetes datastore driver
will be used by default).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DatastoreType` |
| Encoding (env var/config file) | One of: <code>etcdv3</code>, <code>kubernetes</code> (case insensitive) |
| Default value (above encoding) | `etcdv3` |
| Notes | Required, config file / env var only, Felix will exit if the value is invalid. | 

### `EtcdAddr` (config file / env var only)

When using the `etcdv3` datastore driver, the etcd server and port to connect to. If EtcdEndpoints
is also specified, it takes precedence.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_EtcdAddr` |
| Encoding (env var/config file) | String matching regex <code>^[^:/]+:\d+$</code> |
| Default value (above encoding) | `127.0.0.1:2379` |
| Notes | Config file / env var only. | 

### `EtcdCaFile` (config file / env var only)

When using the `etcdv3` datastore driver, path to TLS CA file to use when connecting to
etcd. If the CA file is specified, the other TLS parameters are mandatory.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_EtcdCaFile` |
| Encoding (env var/config file) | Path to file, which must exist |
| Default value (above encoding) | none |
| Notes | Config file / env var only. | 

### `EtcdCertFile` (config file / env var only)

When using the `etcdv3` datastore driver, path to TLS certificate file to use when connecting to
etcd. If the certificate file is specified, the other TLS parameters are mandatory.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_EtcdCertFile` |
| Encoding (env var/config file) | Path to file, which must exist |
| Default value (above encoding) | none |
| Notes | Config file / env var only. | 

### `EtcdEndpoints` (config file / env var only)

When using the `etcdv3` datastore driver, comma-delimited list of etcd endpoints to connect to,
replaces EtcdAddr and EtcdScheme.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_EtcdEndpoints` |
| Encoding (env var/config file) | List of HTTP endpoints: comma-delimited list of <code>http(s)://hostname:port</code> |
| Default value (above encoding) | none |
| Notes | Config file / env var only. | 

### `EtcdKeyFile` (config file / env var only)

When using the `etcdv3` datastore driver, path to TLS private key file to use when connecting to
etcd. If the key file is specified, the other TLS parameters are mandatory.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_EtcdKeyFile` |
| Encoding (env var/config file) | Path to file, which must exist |
| Default value (above encoding) | none |
| Notes | Config file / env var only. | 

### `EtcdScheme` (config file / env var only)

EtcdAddr: when using the `etcdv3` datastore driver, the URL scheme to use. If EtcdEndpoints
is also specified, it takes precedence.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_EtcdScheme` |
| Encoding (env var/config file) | One of: <code>http</code>, <code>https</code> (case insensitive) |
| Default value (above encoding) | `http` |
| Notes | Config file / env var only. | 

### `FelixHostname` (config file / env var only)

The name of this node, used to identify resources in the datastore that belong to this node.
Auto-detected from the node's hostname if not provided.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_FelixHostname` |
| Encoding (env var/config file) | String matching regex <code>^[a-zA-Z0-9_.-]+$</code> |
| Default value (above encoding) | none |
| Notes | Required, config file / env var only. | 

### `TyphaAddr` (config file / env var only)

If set, tells Felix to connect to Typha at the given address and port. Overrides TyphaK8sServiceName.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_TyphaAddr` |
| Encoding (env var/config file) | String matching regex <code>^[^:/]+:\d+$</code> |
| Default value (above encoding) | none |
| Notes | Config file / env var only. | 

### `TyphaCAFile` (config file / env var only)

Path to the TLS CA file to use when communicating with Typha. If this parameter is specified,
the other TLS parameters must also be specified.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_TyphaCAFile` |
| Encoding (env var/config file) | Path to file, which must exist |
| Default value (above encoding) | none |
| Notes | Config file / env var only. | 

### `TyphaCN` (config file / env var only)

Common name to use when authenticating to Typha over TLS. If any TLS parameters are specified then one of
TyphaCN and TyphaURISAN must be set.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_TyphaCN` |
| Encoding (env var/config file) | String |
| Default value (above encoding) | none |
| Notes | Config file / env var only. | 

### `TyphaCertFile` (config file / env var only)

Path to the TLS certificate to use when communicating with Typha. If this parameter is specified,
the other TLS parameters must also be specified.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_TyphaCertFile` |
| Encoding (env var/config file) | Path to file, which must exist |
| Default value (above encoding) | none |
| Notes | Config file / env var only. | 

### `TyphaK8sNamespace` (config file / env var only)

Namespace to look in when looking for Typha's service (see TyphaK8sServiceName).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_TyphaK8sNamespace` |
| Encoding (env var/config file) | String |
| Default value (above encoding) | `kube-system` |
| Notes | Required, config file / env var only. | 

### `TyphaK8sServiceName` (config file / env var only)

If set, tells Felix to connect to Typha by looking up the Endpoints of the given Kubernetes
Service in namespace specified by TyphaK8sNamespace.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_TyphaK8sServiceName` |
| Encoding (env var/config file) | String |
| Default value (above encoding) | none |
| Notes | Config file / env var only. | 

### `TyphaKeyFile` (config file / env var only)

Path to the TLS private key to use when communicating with Typha. If this parameter is specified,
the other TLS parameters must also be specified.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_TyphaKeyFile` |
| Encoding (env var/config file) | Path to file, which must exist |
| Default value (above encoding) | none |
| Notes | Config file / env var only. | 

### `TyphaReadTimeout` (config file / env var only)

Read timeout when reading from the Typha connection. If typha sends no data for this long,
Felix will exit and restart. (Note that Typha sends regular pings so traffic is always expected.)

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_TyphaReadTimeout` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `30` (30s) |
| Notes | Config file / env var only. | 

### `TyphaURISAN` (config file / env var only)

URI SAN to use when authenticating to Typha over TLS. If any TLS parameters are specified then one of
TyphaCN and TyphaURISAN must be set.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_TyphaURISAN` |
| Encoding (env var/config file) | String |
| Default value (above encoding) | none |
| Notes | Config file / env var only. | 

### `TyphaWriteTimeout` (config file / env var only)

Write timeout when writing data to Typha.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_TyphaWriteTimeout` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `10` (10s) |
| Notes | Config file / env var only. | 

## <a id="process-feature-detectionoverrides">Process: Feature detection/overrides

### `FeatureDetectOverride` (config file) / `featureDetectOverride` (YAML)

Used to override feature detection based on auto-detected platform
capabilities. Values are specified in a comma separated list with no spaces, example;
"SNATFullyRandom=true,MASQFullyRandom=false,RestoreSupportsLock=". A value of "true" or "false" will
force enable/disable feature, empty or omitted values fall back to auto-detection.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_FeatureDetectOverride` |
| Encoding (env var/config file) | Comma-delimited list of key=value pairs |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `featureDetectOverride` (YAML) `FeatureDetectOverride` (Go API) |
| `FelixConfiguration` schema | String matching the regular expression <code>^([a-zA-Z0-9-_]+=(true\|false\|),)*([a-zA-Z0-9-_]+=(true\|false\|))?$</code>. |
| Default value (YAML) | none |

### `FeatureGates` (config file) / `featureGates` (YAML)

Used to enable or disable tech-preview Calico features.
Values are specified in a comma separated list with no spaces, example;
"BPFConnectTimeLoadBalancingWorkaround=enabled,XyZ=false". This is
used to enable features that are not fully production ready.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_FeatureGates` |
| Encoding (env var/config file) | Comma-delimited list of key=value pairs |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `featureGates` (YAML) `FeatureGates` (Go API) |
| `FelixConfiguration` schema | String matching the regular expression <code>^([a-zA-Z0-9-_]+=([^=]+),)*([a-zA-Z0-9-_]+=([^=]+))?$</code>. |
| Default value (YAML) | none |

## <a id="process-go-runtime">Process: Go runtime

### `GoGCThreshold` (config file) / `goGCThreshold` (YAML)

Sets the Go runtime's garbage collection threshold. I.e. the percentage that the heap is
allowed to grow before garbage collection is triggered. In general, doubling the value halves the CPU time
spent doing GC, but it also doubles peak GC memory overhead. A special value of -1 can be used
to disable GC entirely; this should only be used in conjunction with the GoMemoryLimitMB setting.

This setting is overridden by the GOGC environment variable.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_GoGCThreshold` |
| Encoding (env var/config file) | Integer: [-1,2<sup>63</sup>-1] |
| Default value (above encoding) | `40` |
| `FelixConfiguration` field | `goGCThreshold` (YAML) `GoGCThreshold` (Go API) |
| `FelixConfiguration` schema | Integer: [-1,2<sup>63</sup>-1] |
| Default value (YAML) | `40` |

### `GoMaxProcs` (config file) / `goMaxProcs` (YAML)

Sets the maximum number of CPUs that the Go runtime will use concurrently. A value of -1 means
"use the system default"; typically the number of real CPUs on the system.

this setting is overridden by the GOMAXPROCS environment variable.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_GoMaxProcs` |
| Encoding (env var/config file) | Integer: [-1,2<sup>63</sup>-1] |
| Default value (above encoding) | `-1` |
| `FelixConfiguration` field | `goMaxProcs` (YAML) `GoMaxProcs` (Go API) |
| `FelixConfiguration` schema | Integer: [-1,2<sup>63</sup>-1] |
| Default value (YAML) | `-1` |

### `GoMemoryLimitMB` (config file) / `goMemoryLimitMB` (YAML)

Sets a (soft) memory limit for the Go runtime in MB. The Go runtime will try to keep its memory
usage under the limit by triggering GC as needed. To avoid thrashing, it will exceed the limit if GC starts to
take more than 50% of the process's CPU time. A value of -1 disables the memory limit.

Note that the memory limit, if used, must be considerably less than any hard resource limit set at the container
or pod level. This is because felix is not the only process that must run in the container or pod.

This setting is overridden by the GOMEMLIMIT environment variable.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_GoMemoryLimitMB` |
| Encoding (env var/config file) | Integer: [-1,2<sup>63</sup>-1] |
| Default value (above encoding) | `-1` |
| `FelixConfiguration` field | `goMemoryLimitMB` (YAML) `GoMemoryLimitMB` (Go API) |
| `FelixConfiguration` schema | Integer: [-1,2<sup>63</sup>-1] |
| Default value (YAML) | `-1` |

## <a id="process-health-port-and-timeouts">Process: Health port and timeouts

### `HealthEnabled` (config file) / `healthEnabled` (YAML)

If set to true, enables Felix's health port, which provides readiness and liveness endpoints.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_HealthEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `healthEnabled` (YAML) `HealthEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `HealthHost` (config file) / `healthHost` (YAML)

The host that the health server should bind to.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_HealthHost` |
| Encoding (env var/config file) | String matching regex <code>^[a-zA-Z0-9:._+-]{1,64}$</code> |
| Default value (above encoding) | `localhost` |
| `FelixConfiguration` field | `healthHost` (YAML) `HealthHost` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `localhost` |

### `HealthPort` (config file) / `healthPort` (YAML)

The TCP port that the health server should bind to.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_HealthPort` |
| Encoding (env var/config file) | Integer: [0,65535] |
| Default value (above encoding) | `9099` |
| `FelixConfiguration` field | `healthPort` (YAML) `HealthPort` (Go API) |
| `FelixConfiguration` schema | Integer: [0,65535] |
| Default value (YAML) | `9099` |

### `HealthTimeoutOverrides` (config file) / `healthTimeoutOverrides` (YAML)

Allows the internal watchdog timeouts of individual subcomponents to be
overridden. This is useful for working around "false positive" liveness timeouts that can occur
in particularly stressful workloads or if CPU is constrained. For a list of active
subcomponents, see Felix's logs.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_HealthTimeoutOverrides` |
| Encoding (env var/config file) | Comma-delimited list of <code>&lt;key&gt;=&lt;duration&gt;</code> pairs, where durations use Go's standard format (e.g. 1s, 1m, 1h3m2s) |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `healthTimeoutOverrides` (YAML) `HealthTimeoutOverrides` (Go API) |
| `FelixConfiguration` schema | List of health timeout overrides: <code>[{name: "&lt;name&gt;", timeout: "&lt;duration&gt;"}, ...]</code> where <code>&lt;duration&gt;</code> is in the Go duration format, for example <code>1m30s</code>. |
| Default value (YAML) | none |

## <a id="process-logging">Process: Logging

### `LogDebugFilenameRegex` (config file) / `logDebugFilenameRegex` (YAML)

Controls which source code files have their Debug log output included in the logs.
Only logs from files with names that match the given regular expression are included. The filter only applies
to Debug level logs.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_LogDebugFilenameRegex` |
| Encoding (env var/config file) | Regular expression |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `logDebugFilenameRegex` (YAML) `LogDebugFilenameRegex` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | none |

### `LogFilePath` (config file) / `logFilePath` (YAML)

The full path to the Felix log. Set to none to disable file logging.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_LogFilePath` |
| Encoding (env var/config file) | Path to file |
| Default value (above encoding) | `/var/log/calico/felix.log` |
| `FelixConfiguration` field | `logFilePath` (YAML) `LogFilePath` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `/var/log/calico/felix.log` |
| Notes | Felix will exit if the value is invalid. | 

### `LogPrefix` (config file) / `logPrefix` (YAML)

The log prefix that Felix uses when rendering LOG rules.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_LogPrefix` |
| Encoding (env var/config file) | String |
| Default value (above encoding) | `calico-packet` |
| `FelixConfiguration` field | `logPrefix` (YAML) `LogPrefix` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `calico-packet` |

### `LogSeverityFile` (config file) / `logSeverityFile` (YAML)

The log severity above which logs are sent to the log file.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_LogSeverityFile` |
| Encoding (env var/config file) | One of: <code>DEBUG</code>, <code>ERROR</code>, <code>FATAL</code>, <code>INFO</code>, <code>WARNING</code> (case insensitive) |
| Default value (above encoding) | `INFO` |
| `FelixConfiguration` field | `logSeverityFile` (YAML) `LogSeverityFile` (Go API) |
| `FelixConfiguration` schema | One of: <code>Debug</code>, <code>Error</code>, <code>Fatal</code>, <code>Info</code>, <code>Warning</code>. |
| Default value (YAML) | `Info` |

### `LogSeverityScreen` (config file) / `logSeverityScreen` (YAML)

The log severity above which logs are sent to the stdout.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_LogSeverityScreen` |
| Encoding (env var/config file) | One of: <code>DEBUG</code>, <code>ERROR</code>, <code>FATAL</code>, <code>INFO</code>, <code>WARNING</code> (case insensitive) |
| Default value (above encoding) | `INFO` |
| `FelixConfiguration` field | `logSeverityScreen` (YAML) `LogSeverityScreen` (Go API) |
| `FelixConfiguration` schema | One of: <code>Debug</code>, <code>Error</code>, <code>Fatal</code>, <code>Info</code>, <code>Warning</code>. |
| Default value (YAML) | `Info` |

### `LogSeveritySys` (config file) / `logSeveritySys` (YAML)

The log severity above which logs are sent to the syslog. Set to None for no logging to syslog.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_LogSeveritySys` |
| Encoding (env var/config file) | One of: <code>DEBUG</code>, <code>ERROR</code>, <code>FATAL</code>, <code>INFO</code>, <code>WARNING</code> (case insensitive) |
| Default value (above encoding) | `INFO` |
| `FelixConfiguration` field | `logSeveritySys` (YAML) `LogSeveritySys` (Go API) |
| `FelixConfiguration` schema | One of: <code>Debug</code>, <code>Error</code>, <code>Fatal</code>, <code>Info</code>, <code>Warning</code>. |
| Default value (YAML) | `Info` |

## <a id="process-prometheus-metrics">Process: Prometheus metrics

### `PrometheusGoMetricsEnabled` (config file) / `prometheusGoMetricsEnabled` (YAML)

Disables Go runtime metrics collection, which the Prometheus client does by default, when
set to false. This reduces the number of metrics reported, reducing Prometheus load.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_PrometheusGoMetricsEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `true` |
| `FelixConfiguration` field | `prometheusGoMetricsEnabled` (YAML) `PrometheusGoMetricsEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `true` |

### `PrometheusMetricsEnabled` (config file) / `prometheusMetricsEnabled` (YAML)

Enables the Prometheus metrics server in Felix if set to true.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_PrometheusMetricsEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `prometheusMetricsEnabled` (YAML) `PrometheusMetricsEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `PrometheusMetricsHost` (config file) / `prometheusMetricsHost` (YAML)

The host that the Prometheus metrics server should bind to.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_PrometheusMetricsHost` |
| Encoding (env var/config file) | String matching regex <code>^[a-zA-Z0-9:._+-]{1,64}$</code> |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `prometheusMetricsHost` (YAML) `PrometheusMetricsHost` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | none |

### `PrometheusMetricsPort` (config file) / `prometheusMetricsPort` (YAML)

The TCP port that the Prometheus metrics server should bind to.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_PrometheusMetricsPort` |
| Encoding (env var/config file) | Integer: [0,65535] |
| Default value (above encoding) | `9091` |
| `FelixConfiguration` field | `prometheusMetricsPort` (YAML) `PrometheusMetricsPort` (Go API) |
| `FelixConfiguration` schema | Integer: [0,65535] |
| Default value (YAML) | `9091` |

### `PrometheusProcessMetricsEnabled` (config file) / `prometheusProcessMetricsEnabled` (YAML)

Disables process metrics collection, which the Prometheus client does by default, when
set to false. This reduces the number of metrics reported, reducing Prometheus load.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_PrometheusProcessMetricsEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `true` |
| `FelixConfiguration` field | `prometheusProcessMetricsEnabled` (YAML) `PrometheusProcessMetricsEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `true` |

### `PrometheusWireGuardMetricsEnabled` (config file) / `prometheusWireGuardMetricsEnabled` (YAML)

Disables wireguard metrics collection, which the Prometheus client does by default, when
set to false. This reduces the number of metrics reported, reducing Prometheus load.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_PrometheusWireGuardMetricsEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `true` |
| `FelixConfiguration` field | `prometheusWireGuardMetricsEnabled` (YAML) `PrometheusWireGuardMetricsEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `true` |

## <a id="dataplane-common">Dataplane: Common

### `AllowIPIPPacketsFromWorkloads` (config file) / `allowIPIPPacketsFromWorkloads` (YAML)

Controls whether Felix will add a rule to drop IPIP encapsulated traffic
from workloads.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_AllowIPIPPacketsFromWorkloads` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `allowIPIPPacketsFromWorkloads` (YAML) `AllowIPIPPacketsFromWorkloads` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `AllowVXLANPacketsFromWorkloads` (config file) / `allowVXLANPacketsFromWorkloads` (YAML)

Controls whether Felix will add a rule to drop VXLAN encapsulated traffic
from workloads.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_AllowVXLANPacketsFromWorkloads` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `allowVXLANPacketsFromWorkloads` (YAML) `AllowVXLANPacketsFromWorkloads` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `ChainInsertMode` (config file) / `chainInsertMode` (YAML)

Controls whether Felix hooks the kernel's top-level iptables chains by inserting a rule
at the top of the chain or by appending a rule at the bottom. insert is the safe default since it prevents
Calico's rules from being bypassed. If you switch to append mode, be sure that the other rules in the chains
signal acceptance by falling through to the Calico rules, otherwise the Calico policy will be bypassed.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_ChainInsertMode` |
| Encoding (env var/config file) | One of: <code>append</code>, <code>insert</code> (case insensitive) |
| Default value (above encoding) | `insert` |
| `FelixConfiguration` field | `chainInsertMode` (YAML) `ChainInsertMode` (Go API) |
| `FelixConfiguration` schema | One of: <code>Append</code>, <code>Insert</code>. |
| Default value (YAML) | `Insert` |
| Notes | Required, Felix will exit if the value is invalid. | 

### `DataplaneDriver` (config file) / `dataplaneDriver` (YAML)

Filename of the external dataplane driver to use. Only used if UseInternalDataplaneDriver
is set to false.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DataplaneDriver` |
| Encoding (env var/config file) | Path to executable, which must exist. If not an absolute path, the directory containing this binary and the system path will be searched. |
| Default value (above encoding) | `calico-iptables-plugin` |
| `FelixConfiguration` field | `dataplaneDriver` (YAML) `DataplaneDriver` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `calico-iptables-plugin` |
| Notes | Required, Felix will exit if the value is invalid. | 

### `DataplaneWatchdogTimeout` (config file) / `dataplaneWatchdogTimeout` (YAML)

The readiness/liveness timeout used for Felix's (internal) dataplane driver.
Deprecated: replaced by the generic HealthTimeoutOverrides.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DataplaneWatchdogTimeout` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `90` (1m30s) |
| `FelixConfiguration` field | `dataplaneWatchdogTimeout` (YAML) `DataplaneWatchdogTimeout` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `1m30s` |

### `DefaultEndpointToHostAction` (config file) / `defaultEndpointToHostAction` (YAML)

Controls what happens to traffic that goes from a workload endpoint to the host
itself (after the endpoint's egress policy is applied). By default, Calico blocks traffic from workload
endpoints to the host itself with an iptables "DROP" action. If you want to allow some or all traffic from
endpoint to host, set this parameter to RETURN or ACCEPT. Use RETURN if you have your own rules in the iptables
"INPUT" chain; Calico will insert its rules at the top of that chain, then "RETURN" packets to the "INPUT" chain
once it has completed processing workload endpoint egress policy. Use ACCEPT to unconditionally accept packets
from workloads after processing workload endpoint egress policy.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DefaultEndpointToHostAction` |
| Encoding (env var/config file) | One of: <code>ACCEPT</code>, <code>DROP</code>, <code>RETURN</code> (case insensitive) |
| Default value (above encoding) | `DROP` |
| `FelixConfiguration` field | `defaultEndpointToHostAction` (YAML) `DefaultEndpointToHostAction` (Go API) |
| `FelixConfiguration` schema | One of: <code>Accept</code>, <code>Drop</code>, <code>Return</code>. |
| Default value (YAML) | `Drop` |
| Notes | Required, Felix will exit if the value is invalid. | 

### `DeviceRouteProtocol` (config file) / `deviceRouteProtocol` (YAML)

Controls the protocol to set on routes programmed by Felix. The protocol is an 8-bit label
used to identify the owner of the route.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DeviceRouteProtocol` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `3` |
| `FelixConfiguration` field | `deviceRouteProtocol` (YAML) `DeviceRouteProtocol` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `3` |

### `DeviceRouteSourceAddress` (config file) / `deviceRouteSourceAddress` (YAML)

IPv4 address to set as the source hint for routes programmed by Felix. When not set
the source address for local traffic from host to workload will be determined by the kernel.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DeviceRouteSourceAddress` |
| Encoding (env var/config file) | IPv4 address |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `deviceRouteSourceAddress` (YAML) `DeviceRouteSourceAddress` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | none |

### `DeviceRouteSourceAddressIPv6` (config file) / `deviceRouteSourceAddressIPv6` (YAML)

IPv6 address to set as the source hint for routes programmed by Felix. When not set
the source address for local traffic from host to workload will be determined by the kernel.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DeviceRouteSourceAddressIPv6` |
| Encoding (env var/config file) | IPv6 address |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `deviceRouteSourceAddressIPv6` (YAML) `DeviceRouteSourceAddressIPv6` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | none |

### `DisableConntrackInvalidCheck` (config file) / `disableConntrackInvalidCheck` (YAML)

Disables the check for invalid connections in conntrack. While the conntrack
invalid check helps to detect malicious traffic, it can also cause issues with certain multi-NIC scenarios.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DisableConntrackInvalidCheck` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `disableConntrackInvalidCheck` (YAML) `DisableConntrackInvalidCheck` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `EndpointStatusPathPrefix` (config file) / `endpointStatusPathPrefix` (YAML)

The path to the directory where endpoint status will be written. Endpoint status
file reporting is disabled if field is left empty.

Chosen directory should match the directory used by the CNI plugin for PodStartupDelay.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_EndpointStatusPathPrefix` |
| Encoding (env var/config file) | Path to file |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `endpointStatusPathPrefix` (YAML) `EndpointStatusPathPrefix` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | none |

### `ExternalNodesCIDRList` (config file) / `externalNodesList` (YAML)

A list of CIDR's of external, non-Calico nodes from which VXLAN/IPIP overlay traffic
will be allowed. By default, external tunneled traffic is blocked to reduce attack surface.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_ExternalNodesCIDRList` |
| Encoding (env var/config file) | Comma-delimited list of CIDRs |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `externalNodesList` (YAML) `ExternalNodesCIDRList` (Go API) |
| `FelixConfiguration` schema | List of strings: <code>["&lt;string&gt;", ...]</code>. |
| Default value (YAML) | none |
| Notes | Felix will exit if the value is invalid. | 

### `FailsafeInboundHostPorts` (config file) / `failsafeInboundHostPorts` (YAML)

A list of ProtoPort struct objects including UDP/TCP/SCTP ports and CIDRs that Felix will
allow incoming traffic to host endpoints on irrespective of the security policy. This is useful to avoid accidentally
cutting off a host with incorrect configuration. For backwards compatibility, if the protocol is not specified,
it defaults to "tcp". If a CIDR is not specified, it will allow traffic from all addresses. To disable all inbound host ports,
use the value "[]". The default value allows ssh access, DHCP, BGP, etcd and the Kubernetes API.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_FailsafeInboundHostPorts` |
| Encoding (env var/config file) | Comma-delimited list of numeric ports with optional protocol and CIDR:<code>(tcp\|udp):&lt;cidr&gt;:&lt;port&gt;</code>, <code>(tcp\|udp):&lt;port&gt;</code> or <code>&lt;port&gt;</code>. IPv6 CIDRs must be enclosed in square brackets. |
| Default value (above encoding) | `tcp:22,udp:68,tcp:179,tcp:2379,tcp:2380,tcp:5473,tcp:6443,tcp:6666,tcp:6667` |
| `FelixConfiguration` field | `failsafeInboundHostPorts` (YAML) `FailsafeInboundHostPorts` (Go API) |
| `FelixConfiguration` schema | List of protocol/port objects with optional CIDR match: <code>[{protocol: "TCP\|UDP", port: &lt;port&gt;, net: "&lt;cidr&gt;"}, ...]</code>. |
| Default value (YAML) | `[{"protocol":"tcp","port":22},{"protocol":"udp","port":68},{"protocol":"tcp","port":179},{"protocol":"tcp","port":2379},{"protocol":"tcp","port":2380},{"protocol":"tcp","port":5473},{"protocol":"tcp","port":6443},{"protocol":"tcp","port":6666},{"protocol":"tcp","port":6667}]` |
| Notes | Felix will exit if the value is invalid. | 

### `FailsafeOutboundHostPorts` (config file) / `failsafeOutboundHostPorts` (YAML)

A list of PortProto struct objects including UDP/TCP/SCTP ports and CIDRs that Felix
will allow outgoing traffic from host endpoints to irrespective of the security policy. This is useful to avoid accidentally
cutting off a host with incorrect configuration. For backwards compatibility, if the protocol is not specified, it defaults
to "tcp". If a CIDR is not specified, it will allow traffic from all addresses. To disable all outbound host ports,
use the value "[]". The default value opens etcd's standard ports to ensure that Felix does not get cut off from etcd
as well as allowing DHCP, DNS, BGP and the Kubernetes API.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_FailsafeOutboundHostPorts` |
| Encoding (env var/config file) | Comma-delimited list of numeric ports with optional protocol and CIDR:<code>(tcp\|udp):&lt;cidr&gt;:&lt;port&gt;</code>, <code>(tcp\|udp):&lt;port&gt;</code> or <code>&lt;port&gt;</code>. IPv6 CIDRs must be enclosed in square brackets. |
| Default value (above encoding) | `udp:53,udp:67,tcp:179,tcp:2379,tcp:2380,tcp:5473,tcp:6443,tcp:6666,tcp:6667` |
| `FelixConfiguration` field | `failsafeOutboundHostPorts` (YAML) `FailsafeOutboundHostPorts` (Go API) |
| `FelixConfiguration` schema | List of protocol/port objects with optional CIDR match: <code>[{protocol: "TCP\|UDP", port: &lt;port&gt;, net: "&lt;cidr&gt;"}, ...]</code>. |
| Default value (YAML) | `[{"protocol":"udp","port":53},{"protocol":"udp","port":67},{"protocol":"tcp","port":179},{"protocol":"tcp","port":2379},{"protocol":"tcp","port":2380},{"protocol":"tcp","port":5473},{"protocol":"tcp","port":6443},{"protocol":"tcp","port":6666},{"protocol":"tcp","port":6667}]` |
| Notes | Felix will exit if the value is invalid. | 

### `FloatingIPs` (config file) / `floatingIPs` (YAML)

Configures whether or not Felix will program non-OpenStack floating IP addresses. (OpenStack-derived
floating IPs are always programmed, regardless of this setting.)

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_FloatingIPs` |
| Encoding (env var/config file) | One of: <code>Disabled</code>, <code>Enabled</code> (case insensitive) |
| Default value (above encoding) | `Disabled` |
| `FelixConfiguration` field | `floatingIPs` (YAML) `FloatingIPs` (Go API) |
| `FelixConfiguration` schema | One of: <code>Disabled</code>, <code>Enabled</code>. |
| Default value (YAML) | `Disabled` |

### `IPForwarding` (config file) / `ipForwarding` (YAML)

Controls whether Felix sets the host sysctls to enable IP forwarding. IP forwarding is required
when using Calico for workload networking. This should be disabled only on hosts where Calico is used solely for
host protection. In BPF mode, due to a kernel interaction, either IPForwarding must be enabled or BPFEnforceRPF
must be disabled.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IPForwarding` |
| Encoding (env var/config file) | One of: <code>Disabled</code>, <code>Enabled</code> (case insensitive) |
| Default value (above encoding) | `Enabled` |
| `FelixConfiguration` field | `ipForwarding` (YAML) `IPForwarding` (Go API) |
| `FelixConfiguration` schema | One of: <code>Disabled</code>, <code>Enabled</code>. |
| Default value (YAML) | `Enabled` |

### `InterfaceExclude` (config file) / `interfaceExclude` (YAML)

A comma-separated list of interface names that should be excluded when Felix is resolving
host endpoints. The default value ensures that Felix ignores Kubernetes' internal `kube-ipvs0` device. If you
want to exclude multiple interface names using a single value, the list supports regular expressions. For
regular expressions you must wrap the value with `/`. For example having values `/^kube/,veth1` will exclude
all interfaces that begin with `kube` and also the interface `veth1`.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_InterfaceExclude` |
| Encoding (env var/config file) | Comma-delimited list of Linux interface names/regex patterns. Regex patterns must start/end with <code>/</code>. |
| Default value (above encoding) | `kube-ipvs0` |
| `FelixConfiguration` field | `interfaceExclude` (YAML) `InterfaceExclude` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `kube-ipvs0` |

### `InterfacePrefix` (config file) / `interfacePrefix` (YAML)

The interface name prefix that identifies workload endpoints and so distinguishes
them from host endpoint interfaces. Note: in environments other than bare metal, the orchestrators
configure this appropriately. For example our Kubernetes and Docker integrations set the 'cali' value,
and our OpenStack integration sets the 'tap' value.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_InterfacePrefix` |
| Encoding (env var/config file) | String matching regex <code>^[a-zA-Z0-9_-]{1,15}(,[a-zA-Z0-9_-]{1,15})*$</code> |
| Default value (above encoding) | `cali` |
| `FelixConfiguration` field | `interfacePrefix` (YAML) `InterfacePrefix` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `cali` |
| Notes | Required, Felix will exit if the value is invalid. | 

### `InterfaceRefreshInterval` (config file) / `interfaceRefreshInterval` (YAML)

The period at which Felix rescans local interfaces to verify their state.
The rescan can be disabled by setting the interval to 0.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_InterfaceRefreshInterval` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `90` (1m30s) |
| `FelixConfiguration` field | `interfaceRefreshInterval` (YAML) `InterfaceRefreshInterval` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `1m30s` |

### `Ipv6Support` (config file) / `ipv6Support` (YAML)

Controls whether Felix enables support for IPv6 (if supported by the in-use dataplane).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_Ipv6Support` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `true` |
| `FelixConfiguration` field | `ipv6Support` (YAML) `IPv6Support` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `true` |

### `MTUIfacePattern` (config file) / `mtuIfacePattern` (YAML)

A regular expression that controls which interfaces Felix should scan in order
to calculate the host's MTU.
This should not match workload interfaces (usually named cali...).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_MTUIfacePattern` |
| Encoding (env var/config file) | Regular expression |
| Default value (above encoding) | `^((en\|wl\|ww\|sl\|ib)[Pcopsvx].*\|(eth\|wlan\|wwan).*)` |
| `FelixConfiguration` field | `mtuIfacePattern` (YAML) `MTUIfacePattern` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `^((en\|wl\|ww\|sl\|ib)[Pcopsvx].*\|(eth\|wlan\|wwan).*)` |

### `NATOutgoingAddress` (config file) / `natOutgoingAddress` (YAML)

Specifies an address to use when performing source NAT for traffic in a natOutgoing pool that
is leaving the network. By default the address used is an address on the interface the traffic is leaving on
(i.e. it uses the iptables MASQUERADE target).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_NATOutgoingAddress` |
| Encoding (env var/config file) | IPv4 address |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `natOutgoingAddress` (YAML) `NATOutgoingAddress` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | none |

### `NATPortRange` (config file) / `natPortRange` (YAML)

Specifies the range of ports that is used for port mapping when doing outgoing NAT. When unset the default behavior of the
network stack is used.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_NATPortRange` |
| Encoding (env var/config file) | Port range: either a single number in [0,65535] or a range of numbers <code>n:m</code> |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `natPortRange` (YAML) `NATPortRange` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `0` |

### `NFTablesMode` (config file) / `nftablesMode` (YAML)

Configures nftables support in Felix.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_NFTablesMode` |
| Encoding (env var/config file) | One of: <code>Disabled</code>, <code>Enabled</code> (case insensitive) |
| Default value (above encoding) | `Disabled` |
| `FelixConfiguration` field | `nftablesMode` (YAML) `NFTablesMode` (Go API) |
| `FelixConfiguration` schema | One of: <code>Auto</code>, <code>Disabled</code>, <code>Enabled</code>. |
| Default value (YAML) | `Disabled` |

### `NetlinkTimeoutSecs` (config file) / `netlinkTimeout` (YAML)

The timeout when talking to the kernel over the netlink protocol, used for programming
routes, rules, and other kernel objects.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_NetlinkTimeoutSecs` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `10` (10s) |
| `FelixConfiguration` field | `netlinkTimeout` (YAML) `NetlinkTimeout` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `10s` |

### `PolicySyncPathPrefix` (config file) / `policySyncPathPrefix` (YAML)

Used to by Felix to communicate policy changes to external services,
like Application layer policy.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_PolicySyncPathPrefix` |
| Encoding (env var/config file) | Path to file |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `policySyncPathPrefix` (YAML) `PolicySyncPathPrefix` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | none |

### `RemoveExternalRoutes` (config file) / `removeExternalRoutes` (YAML)

Controls whether Felix will remove unexpected routes to workload interfaces. Felix will
always clean up expected routes that use the configured DeviceRouteProtocol. To add your own routes, you must
use a distinct protocol (in addition to setting this field to false).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_RemoveExternalRoutes` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `true` |
| `FelixConfiguration` field | `removeExternalRoutes` (YAML) `RemoveExternalRoutes` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `true` |

### `RouteRefreshInterval` (config file) / `routeRefreshInterval` (YAML)

The period at which Felix re-checks the routes
in the dataplane to ensure that no other process has accidentally broken Calico's rules.
Set to 0 to disable route refresh.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_RouteRefreshInterval` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `90` (1m30s) |
| `FelixConfiguration` field | `routeRefreshInterval` (YAML) `RouteRefreshInterval` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `1m30s` |

### `RouteSource` (config file) / `routeSource` (YAML)

Configures where Felix gets its routing information.
- WorkloadIPs: use workload endpoints to construct routes.
- CalicoIPAM: the default - use IPAM data to construct routes.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_RouteSource` |
| Encoding (env var/config file) | One of: <code>CalicoIPAM</code>, <code>WorkloadIPs</code> (case insensitive) |
| Default value (above encoding) | `CalicoIPAM` |
| `FelixConfiguration` field | `routeSource` (YAML) `RouteSource` (Go API) |
| `FelixConfiguration` schema | One of: <code>CalicoIPAM</code>, <code>WorkloadIPs</code>. |
| Default value (YAML) | `CalicoIPAM` |

### `RouteSyncDisabled` (config file) / `routeSyncDisabled` (YAML)

Will disable all operations performed on the route table. Set to true to
run in network-policy mode only.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_RouteSyncDisabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `routeSyncDisabled` (YAML) `RouteSyncDisabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `RouteTableRange` (config file) / `routeTableRange` (YAML)

Deprecated in favor of RouteTableRanges.
Calico programs additional Linux route tables for various purposes.
RouteTableRange specifies the indices of the route tables that Calico should use.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_RouteTableRange` |
| Encoding (env var/config file) | Range of route table indices <code>n-m</code>, where <code>n</code> and <code>m</code> are integers in [0,250]. |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `routeTableRange` (YAML) `RouteTableRange` (Go API) |
| `FelixConfiguration` schema | Route table range: <code>{min:&lt;n&gt;, max&lt;m&gt;}</code>. |
| Default value (YAML) | none |
| Notes | Felix will exit if the value is invalid. | 

### `RouteTableRanges` (config file) / `routeTableRanges` (YAML)

Calico programs additional Linux route tables for various purposes.
RouteTableRanges specifies a set of table index ranges that Calico should use.
Deprecates`RouteTableRange`, overrides `RouteTableRange`.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_RouteTableRanges` |
| Encoding (env var/config file) | Comma or space-delimited list of route table ranges of the form <code>n-m</code> where <code>n</code> and <code>m</code> are integers in [0,4294967295]. The sum of the sizes of all ranges may not exceed 65535. |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `routeTableRanges` (YAML) `RouteTableRanges` (Go API) |
| `FelixConfiguration` schema | List of route table ranges: <code>[{min:&lt;n&gt;, max&lt;m&gt;}, ...]</code>. |
| Default value (YAML) | none |
| Notes | Felix will exit if the value is invalid. | 

### `ServiceLoopPrevention` (config file) / `serviceLoopPrevention` (YAML)

When service IP advertisement is enabled, prevent routing loops to service IPs that are
not in use, by dropping or rejecting packets that do not get DNAT'd by kube-proxy.
Unless set to "Disabled", in which case such routing loops continue to be allowed.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_ServiceLoopPrevention` |
| Encoding (env var/config file) | One of: <code>Disabled</code>, <code>Drop</code>, <code>Reject</code> (case insensitive) |
| Default value (above encoding) | `Drop` |
| `FelixConfiguration` field | `serviceLoopPrevention` (YAML) `ServiceLoopPrevention` (Go API) |
| `FelixConfiguration` schema | One of: <code>Disabled</code>, <code>Drop</code>, <code>Reject</code>. |
| Default value (YAML) | `Drop` |

### `SidecarAccelerationEnabled` (config file) / `sidecarAccelerationEnabled` (YAML)

Enables experimental sidecar acceleration.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_SidecarAccelerationEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `sidecarAccelerationEnabled` (YAML) `SidecarAccelerationEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `UseInternalDataplaneDriver` (config file) / `useInternalDataplaneDriver` (YAML)

If true, Felix will use its internal dataplane programming logic. If false, it
will launch an external dataplane driver and communicate with it over protobuf.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_UseInternalDataplaneDriver` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `true` |
| `FelixConfiguration` field | `useInternalDataplaneDriver` (YAML) `UseInternalDataplaneDriver` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `true` |

### `WorkloadSourceSpoofing` (config file) / `workloadSourceSpoofing` (YAML)

Controls whether pods can use the allowedSourcePrefixes annotation to send traffic with a source IP
address that is not theirs. This is disabled by default. When set to "Any", pods can request any prefix.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_WorkloadSourceSpoofing` |
| Encoding (env var/config file) | One of: <code>Any</code>, <code>Disabled</code> (case insensitive) |
| Default value (above encoding) | `Disabled` |
| `FelixConfiguration` field | `workloadSourceSpoofing` (YAML) `WorkloadSourceSpoofing` (Go API) |
| `FelixConfiguration` schema | One of: <code>Any</code>, <code>Disabled</code>. |
| Default value (YAML) | `Disabled` |

## <a id="dataplane-iptables">Dataplane: iptables

### `IpsetsRefreshInterval` (config file) / `ipsetsRefreshInterval` (YAML)

Controls the period at which Felix re-checks all IP sets to look for discrepancies.
Set to 0 to disable the periodic refresh.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IpsetsRefreshInterval` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `90` (1m30s) |
| `FelixConfiguration` field | `ipsetsRefreshInterval` (YAML) `IpsetsRefreshInterval` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `1m30s` |

### `IptablesBackend` (config file) / `iptablesBackend` (YAML)

Controls which backend of iptables will be used. The default is `Auto`.

Warning: changing this on a running system can leave "orphaned" rules in the "other" backend. These
should be cleaned up to avoid confusing interactions.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IptablesBackend` |
| Encoding (env var/config file) | One of: <code>auto</code>, <code>legacy</code>, <code>nft</code> (case insensitive) |
| Default value (above encoding) | `auto` |
| `FelixConfiguration` field | `iptablesBackend` (YAML) `IptablesBackend` (Go API) |
| `FelixConfiguration` schema | One of: <code>Auto</code>, <code>Legacy</code>, <code>NFT</code>. |
| Default value (YAML) | `Auto` |

### `IptablesFilterAllowAction` (config file) / `iptablesFilterAllowAction` (YAML)

Controls what happens to traffic that is accepted by a Felix policy chain in the
iptables filter table (which is used for "normal" policy). The default will immediately `Accept` the traffic. Use
`Return` to send the traffic back up to the system chains for further processing.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IptablesFilterAllowAction` |
| Encoding (env var/config file) | One of: <code>ACCEPT</code>, <code>RETURN</code> (case insensitive) |
| Default value (above encoding) | `ACCEPT` |
| `FelixConfiguration` field | `iptablesFilterAllowAction` (YAML) `IptablesFilterAllowAction` (Go API) |
| `FelixConfiguration` schema | One of: <code>Accept</code>, <code>Return</code>. |
| Default value (YAML) | `Accept` |
| Notes | Required, Felix will exit if the value is invalid. | 

### `IptablesFilterDenyAction` (config file) / `iptablesFilterDenyAction` (YAML)

Controls what happens to traffic that is denied by network policy. By default Calico blocks traffic
with an iptables "DROP" action. If you want to use "REJECT" action instead you can configure it in here.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IptablesFilterDenyAction` |
| Encoding (env var/config file) | One of: <code>DROP</code>, <code>REJECT</code> (case insensitive) |
| Default value (above encoding) | `DROP` |
| `FelixConfiguration` field | `iptablesFilterDenyAction` (YAML) `IptablesFilterDenyAction` (Go API) |
| `FelixConfiguration` schema | One of: <code>Drop</code>, <code>Reject</code>. |
| Default value (YAML) | `Drop` |
| Notes | Required, Felix will exit if the value is invalid. | 

### `IptablesLockFilePath` (config file) / `iptablesLockFilePath` (YAML)

The location of the iptables lock file. You may need to change this
if the lock file is not in its standard location (for example if you have mapped it into Felix's
container at a different path).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IptablesLockFilePath` |
| Encoding (env var/config file) | Path to file |
| Default value (above encoding) | `/run/xtables.lock` |
| `FelixConfiguration` field | `iptablesLockFilePath` (YAML) `IptablesLockFilePath` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `/run/xtables.lock` |

### `IptablesLockProbeIntervalMillis` (config file) / `iptablesLockProbeInterval` (YAML)

When IptablesLockTimeout is enabled: the time that Felix will wait between
attempts to acquire the iptables lock if it is not available. Lower values make Felix more
responsive when the lock is contended, but use more CPU.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IptablesLockProbeIntervalMillis` |
| Encoding (env var/config file) | Milliseconds (floating point) |
| Default value (above encoding) | `50` (50ms) |
| `FelixConfiguration` field | `iptablesLockProbeInterval` (YAML) `IptablesLockProbeInterval` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `50ms` |

### `IptablesLockTimeoutSecs` (config file) / `iptablesLockTimeout` (YAML)

The time that Felix itself will wait for the iptables lock (rather than delegating the
lock handling to the `iptables` command).

Deprecated: `iptables-restore` v1.8+ always takes the lock, so enabling this feature results in deadlock.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IptablesLockTimeoutSecs` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `0` (0s) |
| `FelixConfiguration` field | `iptablesLockTimeout` (YAML) `IptablesLockTimeout` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `0s` |

### `IptablesMangleAllowAction` (config file) / `iptablesMangleAllowAction` (YAML)

Controls what happens to traffic that is accepted by a Felix policy chain in the
iptables mangle table (which is used for "pre-DNAT" policy). The default will immediately `Accept` the traffic.
Use `Return` to send the traffic back up to the system chains for further processing.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IptablesMangleAllowAction` |
| Encoding (env var/config file) | One of: <code>ACCEPT</code>, <code>RETURN</code> (case insensitive) |
| Default value (above encoding) | `ACCEPT` |
| `FelixConfiguration` field | `iptablesMangleAllowAction` (YAML) `IptablesMangleAllowAction` (Go API) |
| `FelixConfiguration` schema | One of: <code>Accept</code>, <code>Return</code>. |
| Default value (YAML) | `Accept` |
| Notes | Required, Felix will exit if the value is invalid. | 

### `IptablesMarkMask` (config file) / `iptablesMarkMask` (YAML)

The mask that Felix selects its IPTables Mark bits from. Should be a 32 bit hexadecimal
number with at least 8 bits set, none of which clash with any other mark bits in use on the system.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IptablesMarkMask` |
| Encoding (env var/config file) | 32-bit bitmask (hex or deccimal allowed) with at least 2 bits set, example: <code>0xffff0000</code> |
| Default value (above encoding) | `0xffff0000` |
| `FelixConfiguration` field | `iptablesMarkMask` (YAML) `IptablesMarkMask` (Go API) |
| `FelixConfiguration` schema | Unsigned 32-bit integer. |
| Default value (YAML) | `0xffff0000` |
| Notes | Required, Felix will exit if the value is invalid. | 

### `IptablesNATOutgoingInterfaceFilter` (config file) / `iptablesNATOutgoingInterfaceFilter` (YAML)

This parameter can be used to limit the host interfaces on which Calico will apply SNAT to traffic leaving a
Calico IPAM pool with "NAT outgoing" enabled. This can be useful if you have a main data interface, where
traffic should be SNATted and a secondary device (such as the docker bridge) which is local to the host and
doesn't require SNAT. This parameter uses the iptables interface matching syntax, which allows + as a
wildcard. Most users will not need to set this. Example: if your data interfaces are eth0 and eth1 and you
want to exclude the docker bridge, you could set this to eth+.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IptablesNATOutgoingInterfaceFilter` |
| Encoding (env var/config file) | String matching regex <code>^[a-zA-Z0-9:._+-]{1,15}$</code> |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `iptablesNATOutgoingInterfaceFilter` (YAML) `IptablesNATOutgoingInterfaceFilter` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | none |

### `IptablesPostWriteCheckIntervalSecs` (config file) / `iptablesPostWriteCheckInterval` (YAML)

The period after Felix has done a write
to the dataplane that it schedules an extra read back in order to check the write was not
clobbered by another process. This should only occur if another application on the system
doesn't respect the iptables lock.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IptablesPostWriteCheckIntervalSecs` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `5` (5s) |
| `FelixConfiguration` field | `iptablesPostWriteCheckInterval` (YAML) `IptablesPostWriteCheckInterval` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `5s` |

### `IptablesRefreshInterval` (config file) / `iptablesRefreshInterval` (YAML)

The period at which Felix re-checks the IP sets
in the dataplane to ensure that no other process has accidentally broken Calico's rules.
Set to 0 to disable IP sets refresh. Note: the default for this value is lower than the
other refresh intervals as a workaround for a Linux kernel bug that was fixed in kernel
version 4.11. If you are using v4.11 or greater you may want to set this to, a higher value
to reduce Felix CPU usage.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IptablesRefreshInterval` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `180` (3m0s) |
| `FelixConfiguration` field | `iptablesRefreshInterval` (YAML) `IptablesRefreshInterval` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `3m0s` |

### `KubeNodePortRanges` (config file) / `kubeNodePortRanges` (YAML)

Holds list of port ranges used for service node ports. Only used if felix detects kube-proxy running in ipvs mode.
Felix uses these ranges to separate host and workload traffic. .

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_KubeNodePortRanges` |
| Encoding (env var/config file) | List of port ranges: comma-delimited list of either single numbers in range [0,65535] or a ranges of numbers <code>n:m</code> |
| Default value (above encoding) | `30000:32767` |
| `FelixConfiguration` field | `kubeNodePortRanges` (YAML) `KubeNodePortRanges` (Go API) |
| `FelixConfiguration` schema | List of ports: <code>[&lt;port&gt;, ...]</code> where <code>&lt;port&gt;</code> is a port number (integer) or range (string), for example <code>80</code>, <code>8080:8089</code>. |
| Default value (YAML) | `["30000:32767"]` |

### `MaxIpsetSize` (config file) / `maxIpsetSize` (YAML)

The maximum number of IP addresses that can be stored in an IP set. Not applicable
if using the nftables backend.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_MaxIpsetSize` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `1048576` |
| `FelixConfiguration` field | `maxIpsetSize` (YAML) `MaxIpsetSize` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `1048576` |
| Notes | Required. | 

## <a id="dataplane-nftables">Dataplane: nftables

### `NftablesFilterAllowAction` (config file) / `nftablesFilterAllowAction` (YAML)

Controls the nftables action that Felix uses to represent the "allow" policy verdict
in the filter table. The default is to `ACCEPT` the traffic, which is a terminal action. Alternatively,
`RETURN` can be used to return the traffic back to the top-level chain for further processing by your rules.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_NftablesFilterAllowAction` |
| Encoding (env var/config file) | One of: <code>ACCEPT</code>, <code>RETURN</code> (case insensitive) |
| Default value (above encoding) | `ACCEPT` |
| `FelixConfiguration` field | `nftablesFilterAllowAction` (YAML) `NftablesFilterAllowAction` (Go API) |
| `FelixConfiguration` schema | One of: <code>Accept</code>, <code>Return</code>. |
| Default value (YAML) | `Accept` |
| Notes | Required, Felix will exit if the value is invalid. | 

### `NftablesFilterDenyAction` (config file) / `nftablesFilterDenyAction` (YAML)

Controls what happens to traffic that is denied by network policy. By default, Calico
blocks traffic with a "drop" action. If you want to use a "reject" action instead you can configure it here.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_NftablesFilterDenyAction` |
| Encoding (env var/config file) | One of: <code>DROP</code>, <code>REJECT</code> (case insensitive) |
| Default value (above encoding) | `DROP` |
| `FelixConfiguration` field | `nftablesFilterDenyAction` (YAML) `NftablesFilterDenyAction` (Go API) |
| `FelixConfiguration` schema | One of: <code>Drop</code>, <code>Reject</code>. |
| Default value (YAML) | `Drop` |
| Notes | Required, Felix will exit if the value is invalid. | 

### `NftablesMangleAllowAction` (config file) / `nftablesMangleAllowAction` (YAML)

Controls the nftables action that Felix uses to represent the "allow" policy verdict
in the mangle table. The default is to `ACCEPT` the traffic, which is a terminal action. Alternatively,
`RETURN` can be used to return the traffic back to the top-level chain for further processing by your rules.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_NftablesMangleAllowAction` |
| Encoding (env var/config file) | One of: <code>ACCEPT</code>, <code>RETURN</code> (case insensitive) |
| Default value (above encoding) | `ACCEPT` |
| `FelixConfiguration` field | `nftablesMangleAllowAction` (YAML) `NftablesMangleAllowAction` (Go API) |
| `FelixConfiguration` schema | One of: <code>Accept</code>, <code>Return</code>. |
| Default value (YAML) | `Accept` |
| Notes | Required, Felix will exit if the value is invalid. | 

### `NftablesMarkMask` (config file) / `nftablesMarkMask` (YAML)

The mask that Felix selects its nftables Mark bits from. Should be a 32 bit hexadecimal
number with at least 8 bits set, none of which clash with any other mark bits in use on the system.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_NftablesMarkMask` |
| Encoding (env var/config file) | 32-bit bitmask (hex or deccimal allowed) with at least 2 bits set, example: <code>0xffff0000</code> |
| Default value (above encoding) | `0xffff0000` |
| `FelixConfiguration` field | `nftablesMarkMask` (YAML) `NftablesMarkMask` (Go API) |
| `FelixConfiguration` schema | Unsigned 32-bit integer. |
| Default value (YAML) | `0xffff0000` |
| Notes | Required, Felix will exit if the value is invalid. | 

### `NftablesRefreshInterval` (config file) / `nftablesRefreshInterval` (YAML)

Controls the interval at which Felix periodically refreshes the nftables rules.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_NftablesRefreshInterval` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `180` (3m0s) |
| `FelixConfiguration` field | `nftablesRefreshInterval` (YAML) `NftablesRefreshInterval` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `3m0s` |

## <a id="dataplane-ebpf">Dataplane: eBPF

### `BPFCTLBLogFilter` (config file) / `bpfCTLBLogFilter` (YAML)

Specifies, what is logged by connect time load balancer when BPFLogLevel is
debug. Currently has to be specified as 'all' when BPFLogFilters is set
to see CTLB logs.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFCTLBLogFilter` |
| Encoding (env var/config file) | One of: <code>all</code> (case insensitive) |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `bpfCTLBLogFilter` (YAML) `BPFCTLBLogFilter` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | none |

### `BPFConnectTimeLoadBalancing` (config file) / `bpfConnectTimeLoadBalancing` (YAML)

When in BPF mode, controls whether Felix installs the connect-time load
balancer. The connect-time load balancer is required for the host to be able to reach Kubernetes services
and it improves the performance of pod-to-service connections.When set to TCP, connect time load balancing
is available only for services with TCP ports.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFConnectTimeLoadBalancing` |
| Encoding (env var/config file) | One of: <code>Disabled</code>, <code>Enabled</code>, <code>TCP</code> (case insensitive) |
| Default value (above encoding) | `TCP` |
| `FelixConfiguration` field | `bpfConnectTimeLoadBalancing` (YAML) `BPFConnectTimeLoadBalancing` (Go API) |
| `FelixConfiguration` schema | One of: <code>Disabled</code>, <code>Enabled</code>, <code>TCP</code>. |
| Default value (YAML) | `TCP` |
| Notes | Required. | 

### `BPFConnectTimeLoadBalancingEnabled` (config file) / `bpfConnectTimeLoadBalancingEnabled` (YAML)

When in BPF mode, controls whether Felix installs the connection-time load
balancer. The connect-time load balancer is required for the host to be able to reach Kubernetes services
and it improves the performance of pod-to-service connections. The only reason to disable it is for debugging
purposes.

Deprecated: Use BPFConnectTimeLoadBalancing.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFConnectTimeLoadBalancingEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `bpfConnectTimeLoadBalancingEnabled` (YAML) `BPFConnectTimeLoadBalancingEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | none |

### `BPFConntrackCleanupMode` (config file) / `bpfConntrackMode` (YAML)

Controls how BPF conntrack entries are cleaned up. `Auto` will use a BPF program if supported,
falling back to userspace if not. `Userspace` will always use the userspace cleanup code. `BPFProgram` will
always use the BPF program (failing if not supported).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFConntrackCleanupMode` |
| Encoding (env var/config file) | One of: <code>Auto</code>, <code>BPFProgram</code>, <code>Userspace</code> (case insensitive) |
| Default value (above encoding) | `Auto` |
| `FelixConfiguration` field | `bpfConntrackMode` (YAML) `BPFConntrackCleanupMode` (Go API) |
| `FelixConfiguration` schema | One of: <code>Auto</code>, <code>BPFProgram</code>, <code>Userspace</code>. |
| Default value (YAML) | `Auto` |

### `BPFConntrackLogLevel` (config file) / `bpfConntrackLogLevel` (YAML)

Controls the log level of the BPF conntrack cleanup program, which runs periodically
to clean up expired BPF conntrack entries.
.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFConntrackLogLevel` |
| Encoding (env var/config file) | One of: <code>debug</code>, <code>off</code> (case insensitive) |
| Default value (above encoding) | `off` |
| `FelixConfiguration` field | `bpfConntrackLogLevel` (YAML) `BPFConntrackLogLevel` (Go API) |
| `FelixConfiguration` schema | One of: <code>Debug</code>, <code>Off</code>. |
| Default value (YAML) | `off` |
| Notes | Required. | 

### `BPFDSROptoutCIDRs` (config file) / `bpfDSROptoutCIDRs` (YAML)

A list of CIDRs which are excluded from DSR. That is, clients
in those CIDRs will access service node ports as if BPFExternalServiceMode was set to
Tunnel.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFDSROptoutCIDRs` |
| Encoding (env var/config file) | Comma-delimited list of CIDRs |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `bpfDSROptoutCIDRs` (YAML) `BPFDSROptoutCIDRs` (Go API) |
| `FelixConfiguration` schema | List of CIDRs: <code>["&lt;cidr&gt;", ...]</code>. |
| Default value (YAML) | none |

### `BPFDataIfacePattern` (config file) / `bpfDataIfacePattern` (YAML)

A regular expression that controls which interfaces Felix should attach BPF programs to
in order to catch traffic to/from the network. This needs to match the interfaces that Calico workload traffic
flows over as well as any interfaces that handle incoming traffic to nodeports and services from outside the
cluster. It should not match the workload interfaces (usually named cali...) or any other special device managed
by Calico itself (e.g., tunnels).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFDataIfacePattern` |
| Encoding (env var/config file) | Regular expression |
| Default value (above encoding) | `^((en\|wl\|ww\|sl\|ib)[Popsx].*\|(eth\|wlan\|wwan\|bond).*)` |
| `FelixConfiguration` field | `bpfDataIfacePattern` (YAML) `BPFDataIfacePattern` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `^((en\|wl\|ww\|sl\|ib)[Popsx].*\|(eth\|wlan\|wwan\|bond).*)` |

### `BPFDisableGROForIfaces` (config file) / `bpfDisableGROForIfaces` (YAML)

A regular expression that controls which interfaces Felix should disable the
Generic Receive Offload [GRO] option. It should not match the workload interfaces (usually named cali...).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFDisableGROForIfaces` |
| Encoding (env var/config file) | Regular expression |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `bpfDisableGROForIfaces` (YAML) `BPFDisableGROForIfaces` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | none |

### `BPFDisableUnprivileged` (config file) / `bpfDisableUnprivileged` (YAML)

If enabled, Felix sets the kernel.unprivileged_bpf_disabled sysctl to disable
unprivileged use of BPF. This ensures that unprivileged users cannot access Calico's BPF maps and
cannot insert their own BPF programs to interfere with Calico's.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFDisableUnprivileged` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `true` |
| `FelixConfiguration` field | `bpfDisableUnprivileged` (YAML) `BPFDisableUnprivileged` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `true` |

### `BPFEnabled` (config file) / `bpfEnabled` (YAML)

If enabled Felix will use the BPF dataplane.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `bpfEnabled` (YAML) `BPFEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `BPFEnforceRPF` (config file) / `bpfEnforceRPF` (YAML)

Enforce strict RPF on all host interfaces with BPF programs regardless of
what is the per-interfaces or global setting. Possible values are Disabled, Strict
or Loose.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFEnforceRPF` |
| Encoding (env var/config file) | One of: <code>Disabled</code>, <code>Loose</code>, <code>Strict</code> (case insensitive) |
| Default value (above encoding) | `Loose` |
| `FelixConfiguration` field | `bpfEnforceRPF` (YAML) `BPFEnforceRPF` (Go API) |
| `FelixConfiguration` schema | One of: <code>Disabled</code>, <code>Loose</code>, <code>Strict</code>. |
| Default value (YAML) | `Loose` |
| Notes | Required. | 

### `BPFExcludeCIDRsFromNAT` (config file) / `bpfExcludeCIDRsFromNAT` (YAML)

A list of CIDRs that are to be excluded from NAT
resolution so that host can handle them. A typical usecase is node local
DNS cache.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFExcludeCIDRsFromNAT` |
| Encoding (env var/config file) | Comma-delimited list of CIDRs |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `bpfExcludeCIDRsFromNAT` (YAML) `BPFExcludeCIDRsFromNAT` (Go API) |
| `FelixConfiguration` schema | List of CIDRs: <code>["&lt;cidr&gt;", ...]</code>. |
| Default value (YAML) | none |

### `BPFExtToServiceConnmark` (config file) / `bpfExtToServiceConnmark` (YAML)

In BPF mode, controls a 32bit mark that is set on connections from an
external client to a local service. This mark allows us to control how packets of that
connection are routed within the host and how is routing interpreted by RPF check.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFExtToServiceConnmark` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `0` |
| `FelixConfiguration` field | `bpfExtToServiceConnmark` (YAML) `BPFExtToServiceConnmark` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `0` |

### `BPFExternalServiceMode` (config file) / `bpfExternalServiceMode` (YAML)

In BPF mode, controls how connections from outside the cluster to services (node ports
and cluster IPs) are forwarded to remote workloads. If set to "Tunnel" then both request and response traffic
is tunneled to the remote node. If set to "DSR", the request traffic is tunneled but the response traffic
is sent directly from the remote node. In "DSR" mode, the remote node appears to use the IP of the ingress
node; this requires a permissive L2 network.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFExternalServiceMode` |
| Encoding (env var/config file) | One of: <code>dsr</code>, <code>tunnel</code> (case insensitive) |
| Default value (above encoding) | `tunnel` |
| `FelixConfiguration` field | `bpfExternalServiceMode` (YAML) `BPFExternalServiceMode` (Go API) |
| `FelixConfiguration` schema | One of: <code>DSR</code>, <code>Tunnel</code>. |
| Default value (YAML) | `Tunnel` |
| Notes | Required. | 

### `BPFForceTrackPacketsFromIfaces` (config file) / `bpfForceTrackPacketsFromIfaces` (YAML)

In BPF mode, forces traffic from these interfaces
to skip Calico's iptables NOTRACK rule, allowing traffic from those interfaces to be
tracked by Linux conntrack. Should only be used for interfaces that are not used for
the Calico fabric. For example, a docker bridge device for non-Calico-networked
containers.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFForceTrackPacketsFromIfaces` |
| Encoding (env var/config file) | Comma-delimited list of strings, each matching the regex <code>^[a-zA-Z0-9:._+-]{1,15}$</code> |
| Default value (above encoding) | `docker+` |
| `FelixConfiguration` field | `bpfForceTrackPacketsFromIfaces` (YAML) `BPFForceTrackPacketsFromIfaces` (Go API) |
| `FelixConfiguration` schema | List of interface names (may use <code>+</code> as a wildcard: <code>["&lt;name&gt;", ...]</code>. |
| Default value (YAML) | `["docker+"]` |

### `BPFHostConntrackBypass` (config file) / `bpfHostConntrackBypass` (YAML)

Controls whether to bypass Linux conntrack in BPF mode for
workloads and services.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFHostConntrackBypass` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `bpfHostConntrackBypass` (YAML) `BPFHostConntrackBypass` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `BPFHostNetworkedNATWithoutCTLB` (config file) / `bpfHostNetworkedNATWithoutCTLB` (YAML)

When in BPF mode, controls whether Felix does a NAT without CTLB. This along with BPFConnectTimeLoadBalancing
determines the CTLB behavior.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFHostNetworkedNATWithoutCTLB` |
| Encoding (env var/config file) | One of: <code>Disabled</code>, <code>Enabled</code> (case insensitive) |
| Default value (above encoding) | `Enabled` |
| `FelixConfiguration` field | `bpfHostNetworkedNATWithoutCTLB` (YAML) `BPFHostNetworkedNATWithoutCTLB` (Go API) |
| `FelixConfiguration` schema | One of: <code>Disabled</code>, <code>Enabled</code>. |
| Default value (YAML) | `Enabled` |
| Notes | Required. | 

### `BPFKubeProxyEndpointSlicesEnabled` (config file) / `bpfKubeProxyEndpointSlicesEnabled` (YAML)

Deprecated and has no effect. BPF
kube-proxy always accepts endpoint slices. This option will be removed in
the next release.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFKubeProxyEndpointSlicesEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `true` |
| `FelixConfiguration` field | `bpfKubeProxyEndpointSlicesEnabled` (YAML) `BPFKubeProxyEndpointSlicesEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `true` |

### `BPFKubeProxyIptablesCleanupEnabled` (config file) / `bpfKubeProxyIptablesCleanupEnabled` (YAML)

If enabled in BPF mode, Felix will proactively clean up the upstream
Kubernetes kube-proxy's iptables chains. Should only be enabled if kube-proxy is not running.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFKubeProxyIptablesCleanupEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `true` |
| `FelixConfiguration` field | `bpfKubeProxyIptablesCleanupEnabled` (YAML) `BPFKubeProxyIptablesCleanupEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `true` |

### `BPFKubeProxyMinSyncPeriod` (config file) / `bpfKubeProxyMinSyncPeriod` (YAML)

In BPF mode, controls the minimum time between updates to the dataplane for Felix's
embedded kube-proxy. Lower values give reduced set-up latency. Higher values reduce Felix CPU usage by
batching up more work.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFKubeProxyMinSyncPeriod` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `1` (1s) |
| `FelixConfiguration` field | `bpfKubeProxyMinSyncPeriod` (YAML) `BPFKubeProxyMinSyncPeriod` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `1s` |

### `BPFL3IfacePattern` (config file) / `bpfL3IfacePattern` (YAML)

A regular expression that allows to list tunnel devices like wireguard or vxlan (i.e., L3 devices)
in addition to BPFDataIfacePattern. That is, tunnel interfaces not created by Calico, that Calico workload traffic flows
over as well as any interfaces that handle incoming traffic to nodeports and services from outside the cluster.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFL3IfacePattern` |
| Encoding (env var/config file) | Regular expression |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `bpfL3IfacePattern` (YAML) `BPFL3IfacePattern` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | none |

### `BPFLogFilters` (config file) / `bpfLogFilters` (YAML)

A map of key=values where the value is
a pcap filter expression and the key is an interface name with 'all'
denoting all interfaces, 'weps' all workload endpoints and 'heps' all host
endpoints.

When specified as an env var, it accepts a comma-separated list of
key=values.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFLogFilters` |
| Encoding (env var/config file) | Comma-delimited list of key=value pairs |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `bpfLogFilters` (YAML) `BPFLogFilters` (Go API) |
| `FelixConfiguration` schema | `object` |
| Default value (YAML) | none |

### `BPFLogLevel` (config file) / `bpfLogLevel` (YAML)

Controls the log level of the BPF programs when in BPF dataplane mode. One of "Off", "Info", or
"Debug". The logs are emitted to the BPF trace pipe, accessible with the command `tc exec bpf debug`.
.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFLogLevel` |
| Encoding (env var/config file) | One of: <code>debug</code>, <code>info</code>, <code>off</code> (case insensitive) |
| Default value (above encoding) | `off` |
| `FelixConfiguration` field | `bpfLogLevel` (YAML) `BPFLogLevel` (Go API) |
| `FelixConfiguration` schema | One of: <code>Debug</code>, <code>Info</code>, <code>Off</code>. |
| Default value (YAML) | `Off` |
| Notes | Required. | 

### `BPFMapSizeConntrack` (config file) / `bpfMapSizeConntrack` (YAML)

Sets the size for the conntrack map. This map must be large enough to hold
an entry for each active connection. Warning: changing the size of the conntrack map can cause disruption.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFMapSizeConntrack` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `512000` |
| `FelixConfiguration` field | `bpfMapSizeConntrack` (YAML) `BPFMapSizeConntrack` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `512000` |
| Notes | Required. | 

### `BPFMapSizeConntrackCleanupQueue` (config file) / `bpfMapSizeConntrackCleanupQueue` (YAML)

Sets the size for the map used to hold NAT conntrack entries that are queued
for cleanup. This should be big enough to hold all the NAT entries that expire within one cleanup interval.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFMapSizeConntrackCleanupQueue` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `100000` |
| `FelixConfiguration` field | `bpfMapSizeConntrackCleanupQueue` (YAML) `BPFMapSizeConntrackCleanupQueue` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `100000` |
| Notes | Required. | 

### `BPFMapSizeIPSets` (config file) / `bpfMapSizeIPSets` (YAML)

Sets the size for ipsets map. The IP sets map must be large enough to hold an entry
for each endpoint matched by every selector in the source/destination matches in network policy. Selectors
such as "all()" can result in large numbers of entries (one entry per endpoint in that case).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFMapSizeIPSets` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `1048576` |
| `FelixConfiguration` field | `bpfMapSizeIPSets` (YAML) `BPFMapSizeIPSets` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `1048576` |
| Notes | Required. | 

### `BPFMapSizeIfState` (config file) / `bpfMapSizeIfState` (YAML)

Sets the size for ifstate map. The ifstate map must be large enough to hold an entry
for each device (host + workloads) on a host.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFMapSizeIfState` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `1000` |
| `FelixConfiguration` field | `bpfMapSizeIfState` (YAML) `BPFMapSizeIfState` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `1000` |
| Notes | Required. | 

### `BPFMapSizeNATAffinity` (config file) / `bpfMapSizeNATAffinity` (YAML)

Sets the size of the BPF map that stores the affinity of a connection (for services that
enable that feature.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFMapSizeNATAffinity` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `65536` |
| `FelixConfiguration` field | `bpfMapSizeNATAffinity` (YAML) `BPFMapSizeNATAffinity` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `65536` |
| Notes | Required. | 

### `BPFMapSizeNATBackend` (config file) / `bpfMapSizeNATBackend` (YAML)

Sets the size for NAT back end map.
This is the total number of endpoints. This is mostly
more than the size of the number of services.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFMapSizeNATBackend` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `262144` |
| `FelixConfiguration` field | `bpfMapSizeNATBackend` (YAML) `BPFMapSizeNATBackend` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `262144` |
| Notes | Required. | 

### `BPFMapSizeNATFrontend` (config file) / `bpfMapSizeNATFrontend` (YAML)

Sets the size for NAT front end map.
FrontendMap should be large enough to hold an entry for each nodeport,
external IP and each port in each service.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFMapSizeNATFrontend` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `65536` |
| `FelixConfiguration` field | `bpfMapSizeNATFrontend` (YAML) `BPFMapSizeNATFrontend` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `65536` |
| Notes | Required. | 

### `BPFMapSizePerCPUConntrack` (config file) / `bpfMapSizePerCpuConntrack` (YAML)

Determines the size of conntrack map based on the number of CPUs. If set to a
non-zero value, overrides BPFMapSizeConntrack with `BPFMapSizePerCPUConntrack * (Number of CPUs)`.
This map must be large enough to hold an entry for each active connection. Warning: changing the size of the
conntrack map can cause disruption.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFMapSizePerCPUConntrack` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `0` |
| `FelixConfiguration` field | `bpfMapSizePerCpuConntrack` (YAML) `BPFMapSizePerCPUConntrack` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `0` |

### `BPFMapSizeRoute` (config file) / `bpfMapSizeRoute` (YAML)

Sets the size for the routes map. The routes map should be large enough
to hold one entry per workload and a handful of entries per host (enough to cover its own IPs and
tunnel IPs).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFMapSizeRoute` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `262144` |
| `FelixConfiguration` field | `bpfMapSizeRoute` (YAML) `BPFMapSizeRoute` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `262144` |
| Notes | Required. | 

### `BPFPSNATPorts` (config file) / `bpfPSNATPorts` (YAML)

Sets the range from which we randomly pick a port if there is a source port
collision. This should be within the ephemeral range as defined by RFC 6056 (1024–65535) and
preferably outside the ephemeral ranges used by common operating systems. Linux uses
32768–60999, while others mostly use the IANA defined range 49152–65535. It is not necessarily
a problem if this range overlaps with the operating systems. Both ends of the range are
inclusive.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFPSNATPorts` |
| Encoding (env var/config file) | Port range: either a single number in [0,65535] or a range of numbers <code>n:m</code> |
| Default value (above encoding) | `20000:29999` |
| `FelixConfiguration` field | `bpfPSNATPorts` (YAML) `BPFPSNATPorts` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `20000:29999` |

### `BPFPolicyDebugEnabled` (config file) / `bpfPolicyDebugEnabled` (YAML)

When true, Felix records detailed information
about the BPF policy programs, which can be examined with the calico-bpf command-line tool.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFPolicyDebugEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `true` |
| `FelixConfiguration` field | `bpfPolicyDebugEnabled` (YAML) `BPFPolicyDebugEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `true` |

### `BPFProfiling` (config file) / `bpfProfiling` (YAML)

Controls profiling of BPF programs. At the monent, it can be
Disabled or Enabled.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFProfiling` |
| Encoding (env var/config file) | One of: <code>Disabled</code>, <code>Enabled</code> (case insensitive) |
| Default value (above encoding) | `Disabled` |
| `FelixConfiguration` field | `bpfProfiling` (YAML) `BPFProfiling` (Go API) |
| `FelixConfiguration` schema | One of: <code>Disabled</code>, <code>Enabled</code>. |
| Default value (YAML) | `Disabled` |
| Notes | Required. | 

### `BPFRedirectToPeer` (config file) / `bpfRedirectToPeer` (YAML)

Controls which whether it is allowed to forward straight to the
peer side of the workload devices. It is allowed for any host L2 devices by default
(L2Only), but it breaks TCP dump on the host side of workload device as it bypasses
it on ingress. Value of Enabled also allows redirection from L3 host devices like
IPIP tunnel or Wireguard directly to the peer side of the workload's device. This
makes redirection faster, however, it breaks tools like tcpdump on the peer side.
Use Enabled with caution.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_BPFRedirectToPeer` |
| Encoding (env var/config file) | One of: <code>Disabled</code>, <code>Enabled</code>, <code>L2Only</code> (case insensitive) |
| Default value (above encoding) | `L2Only` |
| `FelixConfiguration` field | `bpfRedirectToPeer` (YAML) `BPFRedirectToPeer` (Go API) |
| `FelixConfiguration` schema | One of: <code>Disabled</code>, <code>Enabled</code>, <code>L2Only</code>. |
| Default value (YAML) | `L2Only` |
| Notes | Required. | 

## <a id="dataplane-windows">Dataplane: Windows

### `WindowsManageFirewallRules` (config file) / `windowsManageFirewallRules` (YAML)

Configures whether or not Felix will program Windows Firewall rules (to allow inbound access to its own metrics ports).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_WindowsManageFirewallRules` |
| Encoding (env var/config file) | One of: <code>Disabled</code>, <code>Enabled</code> (case insensitive) |
| Default value (above encoding) | `Disabled` |
| `FelixConfiguration` field | `windowsManageFirewallRules` (YAML) `WindowsManageFirewallRules` (Go API) |
| `FelixConfiguration` schema | One of: <code>Disabled</code>, <code>Enabled</code>. |
| Default value (YAML) | `Disabled` |

## <a id="dataplane-openstack-support">Dataplane: OpenStack support

### `EndpointReportingDelaySecs` (config file) / `endpointReportingDelay` (YAML)

The delay before Felix reports endpoint status to the datastore. This is only used
by the OpenStack integration.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_EndpointReportingDelaySecs` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `1` (1s) |
| `FelixConfiguration` field | `endpointReportingDelay` (YAML) `EndpointReportingDelay` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `1s` |

### `EndpointReportingEnabled` (config file) / `endpointReportingEnabled` (YAML)

Controls whether Felix reports endpoint status to the datastore. This is only used
by the OpenStack integration.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_EndpointReportingEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `endpointReportingEnabled` (YAML) `EndpointReportingEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `MetadataAddr` (config file) / `metadataAddr` (YAML)

The IP address or domain name of the server that can answer VM queries for
cloud-init metadata. In OpenStack, this corresponds to the machine running nova-api (or in
Ubuntu, nova-api-metadata). A value of none (case-insensitive) means that Felix should not
set up any NAT rule for the metadata path.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_MetadataAddr` |
| Encoding (env var/config file) | String matching regex <code>^[a-zA-Z0-9_.-]+$</code> |
| Default value (above encoding) | `127.0.0.1` |
| `FelixConfiguration` field | `metadataAddr` (YAML) `MetadataAddr` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `127.0.0.1` |
| Notes | Felix will exit if the value is invalid. | 

### `MetadataPort` (config file) / `metadataPort` (YAML)

The port of the metadata server. This, combined with global.MetadataAddr (if
not 'None'), is used to set up a NAT rule, from 169.254.169.254:80 to MetadataAddr:MetadataPort.
In most cases this should not need to be changed .

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_MetadataPort` |
| Encoding (env var/config file) | Integer: [0,65535] |
| Default value (above encoding) | `8775` |
| `FelixConfiguration` field | `metadataPort` (YAML) `MetadataPort` (Go API) |
| `FelixConfiguration` schema | Integer: [0,65535] |
| Default value (YAML) | `8775` |
| Notes | Felix will exit if the value is invalid. | 

### `OpenstackRegion` (config file) / `openstackRegion` (YAML)

The name of the region that a particular Felix belongs to. In a multi-region
Calico/OpenStack deployment, this must be configured somehow for each Felix (here in the datamodel,
or in felix.cfg or the environment on each compute node), and must match the [calico]
openstack_region value configured in neutron.conf on each node.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_OpenstackRegion` |
| Encoding (env var/config file) | OpenStack region name (must be a valid DNS label) |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `openstackRegion` (YAML) `OpenstackRegion` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | none |
| Notes | Felix will exit if the value is invalid. | 

### `ReportingIntervalSecs` (config file) / `reportingInterval` (YAML)

The interval at which Felix reports its status into the datastore or 0 to disable.
Must be non-zero in OpenStack deployments.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_ReportingIntervalSecs` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `30` (30s) |
| `FelixConfiguration` field | `reportingInterval` (YAML) `ReportingInterval` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `30s` |

### `ReportingTTLSecs` (config file) / `reportingTTL` (YAML)

The time-to-live setting for process-wide status reports.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_ReportingTTLSecs` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `90` (1m30s) |
| `FelixConfiguration` field | `reportingTTL` (YAML) `ReportingTTL` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `1m30s` |

## <a id="dataplane-xdp-acceleration-for-iptables-dataplane">Dataplane: XDP acceleration for iptables dataplane

### `GenericXDPEnabled` (config file) / `genericXDPEnabled` (YAML)

Enables Generic XDP so network cards that don't support XDP offload or driver
modes can use XDP. This is not recommended since it doesn't provide better performance than
iptables.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_GenericXDPEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `genericXDPEnabled` (YAML) `GenericXDPEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `XDPEnabled` (config file) / `xdpEnabled` (YAML)

Enables XDP acceleration for suitable untracked incoming deny rules.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_XDPEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `true` |
| `FelixConfiguration` field | `xdpEnabled` (YAML) `XDPEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `true` |

### `XDPRefreshInterval` (config file) / `xdpRefreshInterval` (YAML)

The period at which Felix re-checks all XDP state to ensure that no
other process has accidentally broken Calico's BPF maps or attached programs. Set to 0 to
disable XDP refresh.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_XDPRefreshInterval` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `90` (1m30s) |
| `FelixConfiguration` field | `xdpRefreshInterval` (YAML) `XDPRefreshInterval` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `1m30s` |

## <a id="overlay-vxlan-overlay">Overlay: VXLAN overlay

### `VXLANEnabled` (config file) / `vxlanEnabled` (YAML)

Overrides whether Felix should create the VXLAN tunnel device for IPv4 VXLAN networking.
Optional as Felix determines this based on the existing IP pools.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_VXLANEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `vxlanEnabled` (YAML) `VXLANEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | none |

### `VXLANMTU` (config file) / `vxlanMTU` (YAML)

The MTU to set on the IPv4 VXLAN tunnel device. Optional as Felix auto-detects the MTU based on the
MTU of the host's interfaces.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_VXLANMTU` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `0` |
| `FelixConfiguration` field | `vxlanMTU` (YAML) `VXLANMTU` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `0` |

### `VXLANMTUV6` (config file) / `vxlanMTUV6` (YAML)

The MTU to set on the IPv6 VXLAN tunnel device. Optional as Felix auto-detects the MTU based on the
MTU of the host's interfaces.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_VXLANMTUV6` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `0` |
| `FelixConfiguration` field | `vxlanMTUV6` (YAML) `VXLANMTUV6` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `0` |

### `VXLANPort` (config file) / `vxlanPort` (YAML)

The UDP port number to use for VXLAN traffic.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_VXLANPort` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `4789` |
| `FelixConfiguration` field | `vxlanPort` (YAML) `VXLANPort` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `4789` |

### `VXLANVNI` (config file) / `vxlanVNI` (YAML)

The VXLAN VNI to use for VXLAN traffic. You may need to change this if the default value is
in use on your system.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_VXLANVNI` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `4096` |
| `FelixConfiguration` field | `vxlanVNI` (YAML) `VXLANVNI` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `4096` |

## <a id="overlay-ip-in-ip">Overlay: IP-in-IP

### `IpInIpEnabled` (config file) / `ipipEnabled` (YAML)

Overrides whether Felix should configure an IPIP interface on the host. Optional as Felix
determines this based on the existing IP pools.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IpInIpEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `ipipEnabled` (YAML) `IPIPEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | none |

### `IpInIpMtu` (config file) / `ipipMTU` (YAML)

Controls the MTU to set on the IPIP tunnel device. Optional as Felix auto-detects the MTU based on the
MTU of the host's interfaces.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_IpInIpMtu` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `0` |
| `FelixConfiguration` field | `ipipMTU` (YAML) `IPIPMTU` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `0` |

## <a id="overlay-wireguard">Overlay: Wireguard

### `WireguardEnabled` (config file) / `wireguardEnabled` (YAML)

Controls whether Wireguard is enabled for IPv4 (encapsulating IPv4 traffic over an IPv4 underlay network).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_WireguardEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `wireguardEnabled` (YAML) `WireguardEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `WireguardEnabledV6` (config file) / `wireguardEnabledV6` (YAML)

Controls whether Wireguard is enabled for IPv6 (encapsulating IPv6 traffic over an IPv6 underlay network).

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_WireguardEnabledV6` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `wireguardEnabledV6` (YAML) `WireguardEnabledV6` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `WireguardHostEncryptionEnabled` (config file) / `wireguardHostEncryptionEnabled` (YAML)

Controls whether Wireguard host-to-host encryption is enabled.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_WireguardHostEncryptionEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `wireguardHostEncryptionEnabled` (YAML) `WireguardHostEncryptionEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `WireguardInterfaceName` (config file) / `wireguardInterfaceName` (YAML)

Specifies the name to use for the IPv4 Wireguard interface.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_WireguardInterfaceName` |
| Encoding (env var/config file) | String matching regex <code>^[a-zA-Z0-9:._+-]{1,15}$</code> |
| Default value (above encoding) | `wireguard.cali` |
| `FelixConfiguration` field | `wireguardInterfaceName` (YAML) `WireguardInterfaceName` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `wireguard.cali` |
| Notes | Required. | 

### `WireguardInterfaceNameV6` (config file) / `wireguardInterfaceNameV6` (YAML)

Specifies the name to use for the IPv6 Wireguard interface.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_WireguardInterfaceNameV6` |
| Encoding (env var/config file) | String matching regex <code>^[a-zA-Z0-9:._+-]{1,15}$</code> |
| Default value (above encoding) | `wg-v6.cali` |
| `FelixConfiguration` field | `wireguardInterfaceNameV6` (YAML) `WireguardInterfaceNameV6` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `wg-v6.cali` |
| Notes | Required. | 

### `WireguardListeningPort` (config file) / `wireguardListeningPort` (YAML)

Controls the listening port used by IPv4 Wireguard.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_WireguardListeningPort` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `51820` |
| `FelixConfiguration` field | `wireguardListeningPort` (YAML) `WireguardListeningPort` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `51820` |

### `WireguardListeningPortV6` (config file) / `wireguardListeningPortV6` (YAML)

Controls the listening port used by IPv6 Wireguard.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_WireguardListeningPortV6` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `51821` |
| `FelixConfiguration` field | `wireguardListeningPortV6` (YAML) `WireguardListeningPortV6` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `51821` |

### `WireguardMTU` (config file) / `wireguardMTU` (YAML)

Controls the MTU on the IPv4 Wireguard interface. See Configuring MTU.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_WireguardMTU` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `0` |
| `FelixConfiguration` field | `wireguardMTU` (YAML) `WireguardMTU` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `0` |

### `WireguardMTUV6` (config file) / `wireguardMTUV6` (YAML)

Controls the MTU on the IPv6 Wireguard interface. See Configuring MTU.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_WireguardMTUV6` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `0` |
| `FelixConfiguration` field | `wireguardMTUV6` (YAML) `WireguardMTUV6` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `0` |

### `WireguardPersistentKeepAlive` (config file) / `wireguardKeepAlive` (YAML)

Controls Wireguard PersistentKeepalive option. Set 0 to disable.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_WireguardPersistentKeepAlive` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `0` (0s) |
| `FelixConfiguration` field | `wireguardKeepAlive` (YAML) `WireguardPersistentKeepAlive` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `0s` |

### `WireguardRoutingRulePriority` (config file) / `wireguardRoutingRulePriority` (YAML)

Controls the priority value to use for the Wireguard routing rule.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_WireguardRoutingRulePriority` |
| Encoding (env var/config file) | Integer |
| Default value (above encoding) | `99` |
| `FelixConfiguration` field | `wireguardRoutingRulePriority` (YAML) `WireguardRoutingRulePriority` (Go API) |
| `FelixConfiguration` schema | Integer |
| Default value (YAML) | `99` |

### `WireguardThreadingEnabled` (config file) / `wireguardThreadingEnabled` (YAML)

Controls whether Wireguard has NAPI threading enabled.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_WireguardThreadingEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `wireguardThreadingEnabled` (YAML) `WireguardThreadingEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

## <a id="aws-integration">AWS integration

### `AWSSrcDstCheck` (config file) / `awsSrcDstCheck` (YAML)

Controls whether Felix will try to change the "source/dest check" setting on the EC2 instance
on which it is running. A value of "Disable" will try to disable the source/dest check. Disabling the check
allows for sending workload traffic without encapsulation within the same AWS subnet.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_AWSSrcDstCheck` |
| Encoding (env var/config file) | One of: <code>Disable</code>, <code>DoNothing</code>, <code>Enable</code> (case insensitive) |
| Default value (above encoding) | `DoNothing` |
| `FelixConfiguration` field | `awsSrcDstCheck` (YAML) `AWSSrcDstCheck` (Go API) |
| `FelixConfiguration` schema | One of: <code>Disable</code>, <code>DoNothing</code>, <code>Enable</code>. |
| Default value (YAML) | `DoNothing` |
| Notes | Required. | 

## <a id="debugtest-only-generally-unsupported">Debug/test-only (generally unsupported)

### `DebugBPFCgroupV2` (config file / env var only)

Controls the cgroup v2 path that we apply the connect-time load balancer to. Most distros
are configured for cgroup v1, which prevents all but the root cgroup v2 from working so this is only useful
for development right now.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DebugBPFCgroupV2` |
| Encoding (env var/config file) | String |
| Default value (above encoding) | none |
| Notes | Config file / env var only. | 

### `DebugBPFMapRepinEnabled` (config file / env var only)

Can be used to prevent Felix from repinning its BPF maps at startup. This is useful for
testing with multiple Felix instances running on one host.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DebugBPFMapRepinEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| Notes | Config file / env var only. | 

### `DebugCPUProfilePath` (config file / env var only)

Unsupported diagnostic setting, used when testing Felix.  Not exposed in `FelixConfiguration`.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DebugCPUProfilePath` |
| Encoding (env var/config file) | Path to file |
| Default value (above encoding) | `/tmp/felix-cpu-<timestamp>.pprof` |

### `DebugDisableLogDropping` (config file) / `debugDisableLogDropping` (YAML)

Disables the dropping of log messages when the log buffer is full. This can
significantly impact performance if log write-out is a bottleneck.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DebugDisableLogDropping` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |
| `FelixConfiguration` field | `debugDisableLogDropping` (YAML) `DebugDisableLogDropping` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `false` |

### `DebugHost` (config file) / `debugHost` (YAML)

The host IP or hostname to bind the debug port to. Only used
if DebugPort is set.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DebugHost` |
| Encoding (env var/config file) | String matching regex <code>^[a-zA-Z0-9:._+-]{1,64}$</code> |
| Default value (above encoding) | `localhost` |
| `FelixConfiguration` field | `debugHost` (YAML) `DebugHost` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | `localhost` |

### `DebugMemoryProfilePath` (config file) / `debugMemoryProfilePath` (YAML)

The path to write the memory profile to when triggered by signal.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DebugMemoryProfilePath` |
| Encoding (env var/config file) | Path to file |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `debugMemoryProfilePath` (YAML) `DebugMemoryProfilePath` (Go API) |
| `FelixConfiguration` schema | String. |
| Default value (YAML) | none |

### `DebugPanicAfter` (config file / env var only)

Unsupported diagnostic setting, used when testing Felix.  Not exposed in `FelixConfiguration`.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DebugPanicAfter` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `0` (0s) |

### `DebugPort` (config file) / `debugPort` (YAML)

If set, enables Felix's debug HTTP port, which allows memory and CPU profiles
to be retrieved. The debug port is not secure, it should not be exposed to the internet.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DebugPort` |
| Encoding (env var/config file) | Integer: [0,65535] |
| Default value (above encoding) | none |
| `FelixConfiguration` field | `debugPort` (YAML) `DebugPort` (Go API) |
| `FelixConfiguration` schema | Integer: [0,65535] |
| Default value (YAML) | none |

### `DebugSimulateCalcGraphHangAfter` (config file) / `debugSimulateCalcGraphHangAfter` (YAML)

Used to simulate a hang in the calculation graph after the specified duration.
This is useful in tests of the watchdog system only!

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DebugSimulateCalcGraphHangAfter` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `0` (0s) |
| `FelixConfiguration` field | `debugSimulateCalcGraphHangAfter` (YAML) `DebugSimulateCalcGraphHangAfter` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `0s` |

### `DebugSimulateDataRace` (config file / env var only)

Unsupported diagnostic setting, used when testing Felix.  Not exposed in `FelixConfiguration`.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DebugSimulateDataRace` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `false` |

### `DebugSimulateDataplaneApplyDelay` (config file) / `debugSimulateDataplaneApplyDelay` (YAML)

Adds an artificial delay to every dataplane operation. This is useful for
simulating a heavily loaded system for test purposes only.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DebugSimulateDataplaneApplyDelay` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `0` (0s) |
| `FelixConfiguration` field | `debugSimulateDataplaneApplyDelay` (YAML) `DebugSimulateDataplaneApplyDelay` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `0s` |

### `DebugSimulateDataplaneHangAfter` (config file) / `debugSimulateDataplaneHangAfter` (YAML)

Used to simulate a hang in the dataplane after the specified duration.
This is useful in tests of the watchdog system only!

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_DebugSimulateDataplaneHangAfter` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `0` (0s) |
| `FelixConfiguration` field | `debugSimulateDataplaneHangAfter` (YAML) `DebugSimulateDataplaneHangAfter` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `0s` |

## <a id="usage-reporting">Usage reporting

### `UsageReportingEnabled` (config file) / `usageReportingEnabled` (YAML)

Reports anonymous Calico version number and cluster size to projectcalico.org. Logs warnings returned by the usage
server. For example, if a significant security vulnerability has been discovered in the version of Calico being used.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_UsageReportingEnabled` |
| Encoding (env var/config file) | Boolean: <code>true</code>, <code>1</code>, <code>yes</code>, <code>y</code>, <code>t</code> accepted as True; <code>false</code>, <code>0</code>, <code>no</code>, <code>n</code>, <code>f</code> accepted (case insensitively) as False. |
| Default value (above encoding) | `true` |
| `FelixConfiguration` field | `usageReportingEnabled` (YAML) `UsageReportingEnabled` (Go API) |
| `FelixConfiguration` schema | Boolean. |
| Default value (YAML) | `true` |

### `UsageReportingInitialDelaySecs` (config file) / `usageReportingInitialDelay` (YAML)

Controls the minimum delay before Felix makes a report.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_UsageReportingInitialDelaySecs` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `300` (5m0s) |
| `FelixConfiguration` field | `usageReportingInitialDelay` (YAML) `UsageReportingInitialDelay` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `5m0s` |

### `UsageReportingIntervalSecs` (config file) / `usageReportingInterval` (YAML)

Controls the interval at which Felix makes reports.

| Detail |   |
| --- | --- |
| Environment variable | `FELIX_UsageReportingIntervalSecs` |
| Encoding (env var/config file) | Seconds (floating point) |
| Default value (above encoding) | `86400` (24h0m0s) |
| `FelixConfiguration` field | `usageReportingInterval` (YAML) `UsageReportingInterval` (Go API) |
| `FelixConfiguration` schema | Duration string, for example <code>1m30s123ms</code> or <code>1h5m</code>. |
| Default value (YAML) | `24h0m0s` |

