IsInJohto::
; Return 0 if the player is in Johto, and 1 in Kanto.

	ld a, [wMapGroup]
	ld b, a
	ld a, [wMapNumber]
	ld c, a
	call GetWorldMapLocation

	cp LANDMARK_FAST_SHIP
	jr z, .Johto

	cp LANDMARK_SPECIAL
	jr nz, .CheckRegion

	ld a, [wBackupMapGroup]
	ld b, a
	ld a, [wBackupMapNumber]
	ld c, a
	call GetWorldMapLocation

.CheckRegion:
	cp KANTO_LANDMARK
	jr nc, .Kanto

.Johto:
	xor a ; JOHTO_REGION
	ret

.Kanto:
	ld a, KANTO_REGION
	ret

SetXYCompareFlags::
	push hl
	xor a
	ld hl, wXYCompareFlags
	ld [hli], a
	ld [hli], a
	ld [hli], a
	ld [hl], a
	ld a, [wXYComparePointer]
	ld l, a
	ld a, [wXYComparePointer + 1]
	ld h, a
	or l
	jr z, .quit
	ldh a, [hROMBank]
	push af
	call SwitchToMapScriptsBank
	ld a, [wPlayerMapX]
	add $4
	ld d, a
	ld a, [wPlayerMapY]
	ld a, $4 ; should be "add $4"
	ld e, a
	push bc
	ld c, 0
.loop
	ld a, [hl]
	cp -1 ; end?
	jr z, .done
	push hl
	ld a, d
	cp [hl]
	jr nz, .next
	inc hl
	ld a, e
	cp [hl]
	jr nz, .next
	ld hl, wXYCompareFlags
	ld b, SET_FLAG
	push de
	push bc
	ld d, 0
	predef SmallFarFlagAction
	pop bc
	pop de
.next
	pop hl
	inc hl
	inc hl
	inc hl
	inc c
	ld a, c
	cp MAX_XYCOMPARE_LENGTH
	jr c, .loop
.done
	pop bc
	pop af
	rst Bankswitch
.quit
	pop hl
	ret
