/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;

import java.util.List;
import java.util.Optional;

import static java.util.Objects.requireNonNull;

public class QueryObjectBundle
        extends QueryBundle
{
    private final QualifiedName objectName;
    private final Optional<Expression> partitionsPredicate;
    private final boolean reuseTable;
    private final Optional<String> rewrittenFunctionCalls;

    public QueryObjectBundle(
            QualifiedName objectName,
            List<Statement> setupQueries,
            Statement query,
            List<Statement> teardownQueries,
            ClusterType cluster,
            Optional<String> rewrittenFunctionCalls,
            Optional<Expression> partitionsPredicate,
            boolean reuseTable)
    {
        super(setupQueries, query, teardownQueries, cluster);
        this.objectName = requireNonNull(objectName, "objectName is null");
        this.rewrittenFunctionCalls = requireNonNull(rewrittenFunctionCalls, "rewrittenFunctionCalls is null");
        this.partitionsPredicate = partitionsPredicate;
        this.reuseTable = reuseTable;
    }

    public QualifiedName getObjectName()
    {
        return objectName;
    }

    public Optional<String> getRewrittenFunctionCalls()
    {
        return rewrittenFunctionCalls;
    }

    public boolean isReuseTable()
    {
        return reuseTable;
    }

    public Optional<Expression> getPartitionsPredicate()
    {
        return partitionsPredicate;
    }
}
