/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.facebook.presto.spi.function;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static com.facebook.presto.spi.function.SqlFunctionVisibility.PUBLIC;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Retention(RUNTIME)
@Target({TYPE, METHOD})
public @interface AggregationFunction
{
    String value() default "";

    boolean decomposable() default true;

    /**
     * Indicates whether the result of the function depends on the order in which data is fed in,
     * which allows the engine to optimize away ORDER BY clauses in aggregation calls
     */
    boolean isOrderSensitive() default false;

    SqlFunctionVisibility visibility() default PUBLIC;

    String[] alias() default {};

    boolean isCalledOnNullInput() default false;
}
