/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.facebook.presto.orc;

import io.airlift.units.DataSize;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import static io.airlift.units.DataSize.Unit.MEGABYTE;

public class OrcReaderTestingUtils
{
    private OrcReaderTestingUtils() {}

    public static OrcReaderOptions createDefaultTestConfig()
    {
        return createTestingReaderOptions(false);
    }

    public static OrcReaderOptions createTestingReaderOptions(boolean zstdJniDecompressionEnabled)
    {
        DataSize dataSize = new DataSize(1, MEGABYTE);
        return OrcReaderOptions.builder()
                .withMaxMergeDistance(dataSize)
                .withTinyStripeThreshold(dataSize)
                .withMaxBlockSize(dataSize)
                .withZstdJniDecompressionEnabled(zstdJniDecompressionEnabled)
                .build();
    }

    public static File getResourceFile(String resourceName)
            throws IOException
    {
        File resourceFile = File.createTempFile("presto-orc-test", null);
        resourceFile.deleteOnExit();

        Files.copy(OrcReaderTestingUtils.class.getClassLoader().getResourceAsStream(resourceName), resourceFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        return resourceFile;
    }
}
