/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;

public interface StatisticsBuilder
{
    void addBlock(Type type, Block block);

    default void addValue(Type type, Block block, int position)
    {
        throw new UnsupportedOperationException();
    }

    ColumnStatistics buildColumnStatistics();

    /**
     * Increment the storage (after compression) size for a given column.
     */
    void incrementSize(long size);

    /**
     * Increment the raw data size of a column data before compression.
     */
    void incrementRawSize(long rawSize);
}
