/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace facebook::presto::protocol {
struct TableWriterNode : public PlanNode {
  std::shared_ptr<PlanNode> source = {};
  // TODO Add target
  VariableReferenceExpression rowCountVariable = {};
  VariableReferenceExpression fragmentVariable = {};
  VariableReferenceExpression tableCommitContextVariable = {};
  List<VariableReferenceExpression> columns = {};
  List<String> columnNames = {};
  List<VariableReferenceExpression> notNullColumnVariables = {};
  std::shared_ptr<PartitioningScheme> partitioningScheme = {};
  std::shared_ptr<PartitioningScheme> preferredShufflePartitioningScheme = {};
  std::shared_ptr<StatisticAggregations> statisticsAggregation = {};

  TableWriterNode() noexcept;
};
void to_json(json& j, const TableWriterNode& p);
void from_json(const json& j, TableWriterNode& p);
} // namespace facebook::presto::protocol
