/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.common.ErrorType;
import com.facebook.presto.spi.ErrorCodeSupplier;

import static com.facebook.presto.common.ErrorType.EXTERNAL;
import static com.facebook.presto.common.ErrorType.INTERNAL_ERROR;

/**
 * Kafka connector specific error codes.
 */
public enum KafkaErrorCode
        implements ErrorCodeSupplier
{
    KAFKA_SPLIT_ERROR(0, EXTERNAL),
    KAFKA_CONSUMER_ERROR(1, EXTERNAL),
    KAFKA_SCHEMA_ERROR(2, EXTERNAL),
    KAFKA_PRODUCER_ERROR(3, INTERNAL_ERROR);

    private final ErrorCode errorCode;

    KafkaErrorCode(int code, ErrorType type)
    {
        errorCode = new ErrorCode(code + 0x0102_0000, name(), type);
    }

    @Override
    public ErrorCode toErrorCode()
    {
        return errorCode;
    }
}
