/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.facebook.presto.iceberg.nessie;

import com.google.common.collect.ImmutableMap;

import java.util.Map;

import static com.facebook.presto.iceberg.CatalogType.NESSIE;

public class NessieTestUtil
{
    private NessieTestUtil()
    {
    }

    public static Map<String, String> nessieConnectorProperties(String serverUri)
    {
        return ImmutableMap.of("iceberg.catalog.type", NESSIE.name(), "iceberg.nessie.uri", serverUri);
    }
}
