/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;

import java.util.Map;
import java.util.Optional;

// TODO interface only has one implementation; inline it
public interface PartitionObjectBuilder
{
    Partition buildPartitionObject(
            ConnectorSession session,
            Table table,
            PartitionUpdate partitionUpdate,
            String prestoVersion,
            Map<String, String> extraParameters,
            Optional<Partition> previousPartition,
            Optional<byte[]> rowIDPartitionComponent);
}
