/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.airlift.stats.CounterStat;
import com.google.common.cache.LoadingCache;

public class NoopMetastoreCacheStats
        implements MetastoreCacheStats
{
    public static final NoopMetastoreCacheStats NOOP_METASTORE_CACHE_STATS = new NoopMetastoreCacheStats();

    @Override
    public void setTableCache(LoadingCache<?, ?> tableCache)
    {
    }

    @Override
    public void setPartitionNamesCache(LoadingCache<?, ?> partitionNamesCache)
    {
    }

    @Override
    public void setPartitionCache(LoadingCache<?, ?> partitionCache)
    {
    }

    @Override
    public void incrementPartitionsWithColumnCountGreaterThanThreshold()
    {
    }

    public long getTableCacheHit()
    {
        return 0;
    }

    public long getTableCacheMiss()
    {
        return 0;
    }

    public long getTableCacheEviction()
    {
        return 0;
    }

    public long getTableCacheSize()
    {
        return 0;
    }

    public long getPartitionNamesCacheHit()
    {
        return 0;
    }

    public long getPartitionNamesCacheMiss()
    {
        return 0;
    }

    public long getPartitionNamesCacheEviction()
    {
        return 0;
    }

    public long getPartitionNamesCacheSize()
    {
        return 0;
    }

    public long getPartitionCacheHit()
    {
        return 0;
    }

    public long getPartitionCacheMiss()
    {
        return 0;
    }

    public long getPartitionCacheEviction()
    {
        return 0;
    }

    public long getPartitionCacheSize()
    {
        return 0;
    }

    @Override
    public CounterStat getPartitionsWithColumnCountGreaterThanThreshold()
    {
        return null;
    }
}
