# MultiVendor E-Commerce Website for Post Department of India

Welcome to the MultiVendor E-Commerce Website project designed for the Post Department of India. This README file provides an overview of the project, its features, and instructions for setting it up.

## Table of Contents
- [Introduction](#introduction)
- [Features](#features)
- [Prerequisites](#prerequisites)
- [Installation](#installation)
- [Usage](#usage)

## Introduction
This MultiVendor E-Commerce Website is a web application designed to facilitate e-commerce activities for the Post Department of India. It enables multiple vendors to list their products for sale and customers to browse, purchase, and track their orders seamlessly. The website is built using the Django framework, a robust and secure web development framework.

## Features
- **Multi-Vendor Support**: Multiple vendors can register and list their products on the platform.
- **User Authentication**: Secure user authentication and authorization system.
- **Product Listings**: Vendors can add, edit, and remove products from their storefront.
- **Product Search**: Customers can easily search for products by category, name, or keywords.
- **Shopping Cart**: Users can add products to their shopping cart and proceed to checkout.
- **Order Tracking**: Customers can track the status of their orders.
- **Payment Integration**: Secure payment processing for online transactions.
- **Admin Dashboard**: An admin panel for managing vendors, orders, and products.
- **User Reviews**: Customers can leave reviews and ratings for products.
- **Responsive Design**: Mobile-friendly design for a seamless user experience.

## Prerequisites
Before you begin, ensure you have met the following requirements:
- Python (version 3.6 or higher) installed on your system.
- Django web framework installed. You can install it using pip: `pip install django`.
- Database system (e.g., PostgreSQL, MySQL, SQLite) and appropriate configurations.

## Installation
1. Clone this repository to your local machine:
```shell
https://github.com/prasad-chavan1/Multivendor-Ecomm.git
```

2. Go to Multivendor-Ecomm directory:
```shell
cd Multivendor-Ecomm
```

3. Create new Virtual Environment:
```shell
python -m venv myenv
```

4. Activate virtual environment:
```shell
myenv\Scripts\activate
```

5. Install Requirements:
```shell
pip install -r requirements.txt
```

6. Run Program:
```shell
python manage.py runserver
```

7. Migrations to Model:
```shell
python manage.py makemigrations
```

8. Migrate Model:
```shell
python manage.py migrate
```

9. Create Super User:
```shell
python manage.py createsuperuser
```

10. Good to go Paste this url in your broswer:
```shell
http://127.0.0.1:8000/admin
```

## Contributions
🎉 We welcome contributions to our project! 🚀 Whether you're a seasoned developer or just getting started, your contributions are valuable to us. We believe in the power of collaboration, and together, we can achieve great things. Feel free to explore our project, open issues, submit pull requests, and help make it even better. Let's code together! 💻🙌 #ContributeToOurProject
