# Project Wizard: Your Gateway to Open Source Engineering Projects

Are you an engineering graduate looking to kickstart your career in the world of technology and innovation? Welcome to Project-Wizard, your ultimate destination for a curated collection of open-source projects tailored specifically for engineering graduates.

---
## Maintainers

### Pralin Khaira ![Owner: Pralin](https://img.shields.io/badge/Owner-PralinKhaira-purple?logo=github)

<details>
  <summary>Contact Pralin Khaira</summary>

- **GitHub:** [Pralin Khaira](https://github.com/pralinkhaira/)
- **Email:** [pralin.khaira.1903@gmail.com](mailto:pralin.khaira.1903@gmail.com)
- **Website:** [Portfolio Website](https://pralinkhaira.github.io/)

</details>

### Akshant Saini ![Collaborator: Akshant](https://img.shields.io/badge/Collaborator-AkshantSaini-blue?logo=github)

<details>
  <summary>Contact Akshant Saini</summary>

- **GitHub:** [Akshant Saini](https://github.com/theakshantsaini/)
- **Email:** [Mail Me!](mailto:be.coder.19@gmail.com)

</details>

### Dhyey ![Collaborator: Dhyey](https://img.shields.io/badge/Collaborator-Dhyey-blue?logo=github)

<details>
  <summary>Contact Dhyey</summary>

- **GitHub:** [InvisiblePro](https://github.com/InvisiblePro)
- **Email:** [Mail Me!](mailto:hacker.invisiblepro@proton.me)

</details>


---

<div align="center">

<img src="https://img.shields.io/badge/hacktoberfest-2024-blueviolet" alt="Hacktober Badge"/>
 <img src="https://img.shields.io/static/v1?label=%F0%9F%8C%9F&message=If%20Useful&style=style=flat&color=BC4E99" alt="Star Badge"/>
 <a href="https://github.com/pralinkhaira" ><img src="https://img.shields.io/badge/Contributions-welcome-violet.svg?style=flat&logo=git" alt="Contributions" /></a>
 
 <a href="https://github.com/pralinkhaira1903" ><img src="https://img.shields.io/badge/Hacktoberfest--Accepted-cyan" alt="HF2k23" /></a>
 <a href="https://github.com/pralinkhaira/Project-Wizard/pulls?q=is%3Apr+is%3Aclosed"><img src="https://img.shields.io/github/issues-closed/pralinkhaira/Project-Wizard" alt="PR's Merged"/></a>
 
 <a href="https://github.com/pralinkhaira/Project-Wizard/graphs/contributors"><img alt="GitHub contributors" src="https://img.shields.io/github/contributors/pralinkhaira/Project-Wizard?color=2b9348"></a>
 <a href="https://github.com/pralinkhaira/Project-Wizard/blob/master/LICENSE"><img src="https://img.shields.io/github/license/pralinkhaira/Project-Wizard?color=2b9348" alt="License Badge"/></a>

</div>

## Why Project-Wizard?

Embarking on your engineering journey is an exciting and challenging adventure. However, it can be daunting to figure out where to begin or how to gain practical experience. Project-Wizard is here to guide you through this process by offering a diverse range of open-source projects from various engineering disciplines, including computer science, electrical engineering, mechanical engineering, and more.

## Key Features:

1. **Curated Selection:** Our team of experts carefully selects and categorizes open-source projects that are perfect for engineering graduates. Whether you're interested in software development, hardware design, robotics, or any other engineering field, we have projects to suit your interests.

2. **Skill Development:** Each project comes with a detailed description, required skillsets, and step-by-step instructions, making it easy for you to get started and gain hands-on experience. You'll have the opportunity to enhance your technical skills and build a strong portfolio.

3. **Community Collaboration:** Connect with a vibrant community of like-minded engineering enthusiasts, mentors, and fellow graduates. Share your progress, seek advice, and collaborate on projects to accelerate your learning and expand your network.

4. **Career Boost:** Completing open-source projects from Project-Wizard not only enriches your knowledge but also enhances your resume. Employers value candidates who have demonstrated practical experience in real-world projects.

5. **Accessible and Free:** Project-Wizard is open to all and completely free of charge. We believe that access to quality engineering projects should be available to everyone, regardless of their background or financial resources.

## Get Started Today!

Dive into the world of open source, gain valuable engineering experience, and set yourself on the path to a successful career. Project-Wizard is your portal to endless possibilities. Start exploring, learning, and building your engineering future now.

Join Project-Wizard and unleash your engineering potential!

---

## Table of Contents

- [Contributing](#contributing)
- [Features](#features)
- [Notes](#notes)
- [Hacktoberfest 2024](#hacktoberfest-2024)
- [Contributors](#contributors)

---

## Contributing

We welcome contributions from engineering graduates who are passionate about open source projects. Here's how you can contribute:

1. Upload your project files to the relevant language folders.

2. Create a separate folder for your project with the main program file named `main.__` and include any other necessary data files.

3. Ensure that your program is executable on various systems. If specific versions are required, please mention them in the project files.

4. Provide a `requirements.txt` file if your project depends on specific modules or packages.

5. If your project passes our tests and is deemed valuable, your pull request will be accepted.

6. Full guide on how to contribute is available [Contribution](Contribution.md) ~ Typo corrected by [Chaitanya](https://github.com/Chaitanya110703) Thanks!

**Please follow these guidelines to ensure your pull request is accepted.**

## Features

Project-Wizard aims to contribute to the field of engineering in various ways:

- Utilizing computer vision technology for innovative solutions.
  
- Enhancing security systems with computer vision applications.
  
- Exploring machine learning applications based on computer vision for real-world data recognition and analysis.

All contributions are highly appreciated. Join us in shaping the future of engineering!

## Notes

1. Fake or invalid pull requests will not be accepted.

2. If your project includes bugs, we may ask you to update or change it, and the pull request will be marked as 'bugs.'

3. Spammy pull requests will be marked as 'spam.'

4. We do not accept README.md updates as valid contributions, although we have contributers.md for adding your name there!

5. Additions to Contributers.md will be accepted/approved only if you contribute by adding a valid project!

## Hacktoberfest 2024

We are excited to announce that Project-Wizard is a part of Hacktoberfest 2024, celebrating its 11th anniversary.

![Hacktoberfest 2024](https://hacktoberfest.com/_next/static/media/logo-hacktoberfest-11--footer.cc639da3.svg)

## Contributors

We appreciate all [contributors](Contributers.md) who make Project-Wizard possible.

<a href="https://github.compralinkhaira/Project-Wizard/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=pralinkhaira/Project-Wizard" />
</a>

<br>
<br/>


![Owner: Pralin](https://img.shields.io/badge/Owner-PralinKhaira-purple?logo=github)
![Hacktoberfest-Accepted](https://img.shields.io/badge/Hacktoberfest--Accepted-cyan)
