import { EnvironmentId } from '@/react/portainer/environments/types';
import axios, { parseAxiosError } from '@/portainer/services/axios';
import { ImageId, ImageName } from '@/docker/models/image';

import { buildDockerProxyUrl } from '../buildDockerProxyUrl';

/**
 * Raw docker API proxy
 * @param environmentId
 * @param id
 * @param repo string generated by `buildImageFullURIFromModel` or `buildImageFullURI`
 * @returns
 */
export async function tagImage(
  environmentId: EnvironmentId,
  id: ImageId | ImageName,
  repo: string,
  tag?: string
) {
  try {
    const { data } = await axios.post(
      buildDockerProxyUrl(environmentId, 'images', id, 'tag'),
      {},
      { params: { repo, tag } }
    );
    return data;
  } catch (e) {
    throw parseAxiosError(e, 'Unable to tag image');
  }
}
