angular.module('portainer.kubernetes').factory('KubernetesEndpoints', function KubernetesEndpointsFactory($resource, API_ENDPOINT_ENDPOINTS, EndpointProvider) {
  'use strict';
  return function (namespace) {
    const url = API_ENDPOINT_ENDPOINTS + '/:endpointId/kubernetes/api/v1' + (namespace ? '/namespaces/:namespace' : '') + '/endpoints/:id';
    return $resource(
      url,
      {
        endpointId: EndpointProvider.endpointID,
        namespace: namespace,
      },
      {
        get: {
          method: 'GET',
          ignoreLoadingBar: true,
        },
      }
    );
  };
});
