#ifndef TEST_TIMEZONEID_10_H
#define TEST_TIMEZONEID_10_H

#include "TimeManager.h"
#include "TestHelper.h"

void run_TimeZoneId_10_Tests(const TimeManager& timeManager)
{
	uint16_t testCount = 0;
	uint16_t failedCount = 0;

	testCount++; failedCount += test(timeManager, 10, 2018, 1, 15, 13, 27, 0, false);         // UTC: 1:27 PM Local: 9:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 12, 15, 24, 0, false);         // UTC: 3:24 PM Local: 11:24 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 16, 6, 3, 0, false);           // UTC: 6:03 AM Local: 2:03 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 25, 11, 45, 0, false);         // UTC: 11:45 AM Local: 7:45 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 6, 12, 33, 0, false);          // UTC: 12:33 PM Local: 8:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 8, 19, 22, 0, false);          // UTC: 7:22 PM Local: 3:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 26, 13, 17, 0, false);         // UTC: 1:17 PM Local: 9:17 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 5, 5, 26, 0, false);           // UTC: 5:26 AM Local: 1:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 6, 22, 3, 0, false);           // UTC: 10:03 PM Local: 6:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 27, 13, 28, 0, false);         // UTC: 1:28 PM Local: 9:28 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 25, 8, 14, 0, false);          // UTC: 8:14 AM Local: 4:14 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 8, 15, 22, 0, false);          // UTC: 3:22 PM Local: 11:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 15, 14, 21, 0, false);         // UTC: 2:21 PM Local: 10:21 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 1, 22, 44, 0, false);          // UTC: 10:44 PM Local: 6:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 21, 6, 47, 0, false);          // UTC: 6:47 AM Local: 2:47 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 26, 22, 32, 0, false);         // UTC: 10:32 PM Local: 6:32 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 16, 13, 16, 0, false);         // UTC: 1:16 PM Local: 9:16 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 18, 13, 23, 0, false);         // UTC: 1:23 PM Local: 9:23 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 14, 8, 21, 0, false);          // UTC: 8:21 AM Local: 4:21 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 1, 5, 41, 0, false);           // UTC: 5:41 AM Local: 1:41 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 10, 13, 40, 0, false);         // UTC: 1:40 PM Local: 9:40 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 16, 22, 7, 0, false);          // UTC: 10:07 PM Local: 6:07 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 15, 20, 51, 0, false);         // UTC: 8:51 PM Local: 4:51 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 6, 16, 12, 0, false);          // UTC: 4:12 PM Local: 12:12 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 1, 1, 21, 35, 0, false);          // UTC: 9:35 PM Local: 5:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 15, 9, 55, 0, false);          // UTC: 9:55 AM Local: 5:55 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 18, 5, 58, 0, false);          // UTC: 5:58 AM Local: 1:58 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 14, 9, 1, 0, false);           // UTC: 9:01 AM Local: 5:01 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 6, 6, 47, 0, false);           // UTC: 6:47 AM Local: 2:47 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 23, 18, 17, 0, false);         // UTC: 6:17 PM Local: 2:17 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 1, 11, 22, 0, false);          // UTC: 11:22 AM Local: 7:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 18, 15, 21, 0, false);         // UTC: 3:21 PM Local: 11:21 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 2, 4, 18, 0, false);           // UTC: 4:18 AM Local: 12:18 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 19, 9, 5, 0, false);           // UTC: 9:05 AM Local: 5:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 19, 8, 50, 0, false);          // UTC: 8:50 AM Local: 4:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 2, 14, 38, 0, false);          // UTC: 2:38 PM Local: 10:38 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 22, 21, 56, 0, false);         // UTC: 9:56 PM Local: 5:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 12, 8, 0, 0, false);           // UTC: 8:00 AM Local: 4:00 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 20, 19, 12, 0, false);         // UTC: 7:12 PM Local: 3:12 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 19, 8, 42, 0, false);          // UTC: 8:42 AM Local: 4:42 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 9, 16, 7, 0, false);           // UTC: 4:07 PM Local: 12:07 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 16, 4, 12, 0, false);          // UTC: 4:12 AM Local: 12:12 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 23, 8, 15, 0, false);          // UTC: 8:15 AM Local: 4:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 7, 11, 11, 0, false);          // UTC: 11:11 AM Local: 7:11 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 18, 22, 47, 0, false);         // UTC: 10:47 PM Local: 6:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 25, 18, 0, 0, false);          // UTC: 6:00 PM Local: 2:00 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 5, 3, 39, 0, false);           // UTC: 3:39 AM Local: 11:39 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 4, 0, 49, 0, false);           // UTC: 12:49 AM Local: 8:49 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 10, 13, 8, 0, false);          // UTC: 1:08 PM Local: 9:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 2, 11, 21, 47, 0, false);         // UTC: 9:47 PM Local: 5:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 5, 8, 49, 0, false);           // UTC: 8:49 AM Local: 4:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 17, 7, 42, 0, false);          // UTC: 7:42 AM Local: 3:42 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 27, 2, 11, 0, false);          // UTC: 2:11 AM Local: 10:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 18, 5, 14, 0, false);          // UTC: 5:14 AM Local: 1:14 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 11, 13, 26, 0, false);         // UTC: 1:26 PM Local: 9:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 21, 17, 23, 0, false);         // UTC: 5:23 PM Local: 1:23 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 6, 18, 2, 0, false);           // UTC: 6:02 PM Local: 2:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 6, 11, 11, 0, false);          // UTC: 11:11 AM Local: 7:11 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 2, 4, 39, 0, false);           // UTC: 4:39 AM Local: 12:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 8, 5, 34, 0, false);           // UTC: 5:34 AM Local: 1:34 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 3, 10, 26, 0, false);          // UTC: 10:26 AM Local: 6:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 13, 1, 6, 0, false);           // UTC: 1:06 AM Local: 9:06 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 10, 1, 36, 0, false);          // UTC: 1:36 AM Local: 9:36 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 3, 21, 42, 0, false);          // UTC: 9:42 PM Local: 5:42 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 22, 12, 53, 0, false);         // UTC: 12:53 PM Local: 8:53 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 12, 17, 27, 0, false);         // UTC: 5:27 PM Local: 1:27 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 11, 13, 48, 0, false);         // UTC: 1:48 PM Local: 9:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 20, 4, 6, 0, false);           // UTC: 4:06 AM Local: 12:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 21, 22, 51, 0, false);         // UTC: 10:51 PM Local: 6:51 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 18, 12, 9, 0, false);          // UTC: 12:09 PM Local: 8:09 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 2, 15, 50, 0, false);          // UTC: 3:50 PM Local: 11:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 17, 12, 46, 0, false);         // UTC: 12:46 PM Local: 8:46 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 22, 21, 29, 0, false);         // UTC: 9:29 PM Local: 5:29 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 10, 9, 43, 0, false);          // UTC: 9:43 AM Local: 5:43 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 3, 22, 2, 52, 0, false);          // UTC: 2:52 AM Local: 10:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 9, 8, 57, 0, false);           // UTC: 8:57 AM Local: 4:57 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 8, 14, 25, 0, false);          // UTC: 2:25 PM Local: 10:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 6, 20, 39, 0, false);          // UTC: 8:39 PM Local: 4:39 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 21, 7, 14, 0, false);          // UTC: 7:14 AM Local: 3:14 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 9, 15, 6, 0, false);           // UTC: 3:06 PM Local: 11:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 7, 16, 29, 0, false);          // UTC: 4:29 PM Local: 12:29 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 13, 0, 14, 0, false);          // UTC: 12:14 AM Local: 8:14 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 24, 4, 57, 0, false);          // UTC: 4:57 AM Local: 12:57 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 4, 14, 47, 0, false);          // UTC: 2:47 PM Local: 10:47 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 26, 1, 10, 0, false);          // UTC: 1:10 AM Local: 9:10 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 3, 21, 5, 0, false);           // UTC: 9:05 PM Local: 5:05 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 6, 10, 34, 0, false);          // UTC: 10:34 AM Local: 6:34 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 25, 8, 54, 0, false);          // UTC: 8:54 AM Local: 4:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 20, 19, 47, 0, false);         // UTC: 7:47 PM Local: 3:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 6, 19, 13, 0, false);          // UTC: 7:13 PM Local: 3:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 15, 10, 15, 0, false);         // UTC: 10:15 AM Local: 6:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 11, 2, 40, 0, false);          // UTC: 2:40 AM Local: 10:40 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 7, 7, 4, 0, false);            // UTC: 7:04 AM Local: 3:04 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 18, 10, 10, 0, false);         // UTC: 10:10 AM Local: 6:10 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 27, 3, 58, 0, false);          // UTC: 3:58 AM Local: 11:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 17, 5, 49, 0, false);          // UTC: 5:49 AM Local: 1:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 13, 15, 22, 0, false);         // UTC: 3:22 PM Local: 11:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 5, 2, 13, 0, false);           // UTC: 2:13 AM Local: 10:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 15, 7, 21, 0, false);          // UTC: 7:21 AM Local: 3:21 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 4, 16, 16, 10, 0, false);         // UTC: 4:10 PM Local: 12:10 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 12, 15, 20, 0, false);         // UTC: 3:20 PM Local: 11:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 21, 13, 9, 0, false);          // UTC: 1:09 PM Local: 9:09 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 15, 13, 54, 0, false);         // UTC: 1:54 PM Local: 9:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 14, 19, 37, 0, false);         // UTC: 7:37 PM Local: 3:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 1, 13, 0, 0, false);           // UTC: 1:00 PM Local: 9:00 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 11, 21, 11, 0, false);         // UTC: 9:11 PM Local: 5:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 26, 2, 35, 0, false);          // UTC: 2:35 AM Local: 10:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 27, 16, 10, 0, false);         // UTC: 4:10 PM Local: 12:10 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 23, 8, 20, 0, false);          // UTC: 8:20 AM Local: 4:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 1, 19, 47, 0, false);          // UTC: 7:47 PM Local: 3:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 9, 15, 34, 0, false);          // UTC: 3:34 PM Local: 11:34 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 25, 5, 45, 0, false);          // UTC: 5:45 AM Local: 1:45 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 23, 5, 34, 0, false);          // UTC: 5:34 AM Local: 1:34 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 23, 1, 39, 0, false);          // UTC: 1:39 AM Local: 9:39 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 25, 22, 47, 0, false);         // UTC: 10:47 PM Local: 6:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 21, 3, 31, 0, false);          // UTC: 3:31 AM Local: 11:31 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 7, 2, 23, 0, false);           // UTC: 2:23 AM Local: 10:23 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 5, 14, 36, 0, false);          // UTC: 2:36 PM Local: 10:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 16, 10, 56, 0, false);         // UTC: 10:56 AM Local: 6:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 5, 21, 11, 0, false);          // UTC: 9:11 PM Local: 5:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 22, 11, 41, 0, false);         // UTC: 11:41 AM Local: 7:41 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 4, 3, 12, 0, false);           // UTC: 3:12 AM Local: 11:12 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 2, 2, 20, 0, false);           // UTC: 2:20 AM Local: 10:20 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 7, 13, 39, 0, false);          // UTC: 1:39 PM Local: 9:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 5, 17, 2, 2, 0, false);           // UTC: 2:02 AM Local: 10:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 26, 1, 42, 0, false);          // UTC: 1:42 AM Local: 9:42 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 11, 2, 14, 0, false);          // UTC: 2:14 AM Local: 10:14 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 23, 18, 44, 0, false);         // UTC: 6:44 PM Local: 2:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 11, 3, 1, 0, false);           // UTC: 3:01 AM Local: 11:01 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 26, 7, 45, 0, false);          // UTC: 7:45 AM Local: 3:45 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 22, 14, 19, 0, false);         // UTC: 2:19 PM Local: 10:19 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 11, 0, 32, 0, false);          // UTC: 12:32 AM Local: 8:32 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 27, 17, 48, 0, false);         // UTC: 5:48 PM Local: 1:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 16, 15, 0, 0, false);          // UTC: 3:00 PM Local: 11:00 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 6, 22, 31, 0, false);          // UTC: 10:31 PM Local: 6:31 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 20, 12, 30, 0, false);         // UTC: 12:30 PM Local: 8:30 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 16, 14, 22, 0, false);         // UTC: 2:22 PM Local: 10:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 7, 18, 48, 0, false);          // UTC: 6:48 PM Local: 2:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 26, 22, 41, 0, false);         // UTC: 10:41 PM Local: 6:41 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 26, 16, 0, 0, false);          // UTC: 4:00 PM Local: 12:00 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 6, 2, 48, 0, false);           // UTC: 2:48 AM Local: 10:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 16, 9, 55, 0, false);          // UTC: 9:55 AM Local: 5:55 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 10, 4, 6, 0, false);           // UTC: 4:06 AM Local: 12:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 14, 22, 17, 0, false);         // UTC: 10:17 PM Local: 6:17 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 25, 18, 24, 0, false);         // UTC: 6:24 PM Local: 2:24 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 7, 14, 47, 0, false);          // UTC: 2:47 PM Local: 10:47 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 6, 15, 35, 0, false);          // UTC: 3:35 PM Local: 11:35 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 14, 8, 39, 0, false);          // UTC: 8:39 AM Local: 4:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 11, 13, 50, 0, false);         // UTC: 1:50 PM Local: 9:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 6, 14, 10, 0, 0, false);          // UTC: 10:00 AM Local: 6:00 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 23, 0, 2, 0, false);           // UTC: 12:02 AM Local: 8:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 22, 9, 33, 0, false);          // UTC: 9:33 AM Local: 5:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 6, 14, 33, 0, false);          // UTC: 2:33 PM Local: 10:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 17, 8, 21, 0, false);          // UTC: 8:21 AM Local: 4:21 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 11, 1, 40, 0, false);          // UTC: 1:40 AM Local: 9:40 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 3, 7, 0, 0, false);            // UTC: 7:00 AM Local: 3:00 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 12, 16, 21, 0, false);         // UTC: 4:21 PM Local: 12:21 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 25, 17, 3, 0, false);          // UTC: 5:03 PM Local: 1:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 11, 15, 43, 0, false);         // UTC: 3:43 PM Local: 11:43 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 5, 4, 50, 0, false);           // UTC: 4:50 AM Local: 12:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 3, 19, 43, 0, false);          // UTC: 7:43 PM Local: 3:43 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 3, 14, 56, 0, false);          // UTC: 2:56 PM Local: 10:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 7, 2, 22, 0, false);           // UTC: 2:22 AM Local: 10:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 23, 0, 0, 0, false);           // UTC: 12:00 AM Local: 8:00 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 7, 14, 16, 0, false);          // UTC: 2:16 PM Local: 10:16 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 7, 2, 17, 0, false);           // UTC: 2:17 AM Local: 10:17 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 27, 7, 14, 0, false);          // UTC: 7:14 AM Local: 3:14 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 23, 2, 44, 0, false);          // UTC: 2:44 AM Local: 10:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 18, 21, 15, 0, false);         // UTC: 9:15 PM Local: 5:15 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 27, 9, 42, 0, false);          // UTC: 9:42 AM Local: 5:42 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 23, 1, 25, 0, false);          // UTC: 1:25 AM Local: 9:25 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 20, 11, 33, 0, false);         // UTC: 11:33 AM Local: 7:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 17, 6, 25, 0, false);          // UTC: 6:25 AM Local: 2:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 20, 18, 13, 0, false);         // UTC: 6:13 PM Local: 2:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 7, 18, 13, 39, 0, false);         // UTC: 1:39 PM Local: 9:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 10, 15, 8, 0, false);          // UTC: 3:08 PM Local: 11:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 22, 3, 32, 0, false);          // UTC: 3:32 AM Local: 11:32 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 12, 3, 52, 0, false);          // UTC: 3:52 AM Local: 11:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 17, 5, 42, 0, false);          // UTC: 5:42 AM Local: 1:42 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 27, 10, 41, 0, false);         // UTC: 10:41 AM Local: 6:41 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 19, 6, 40, 0, false);          // UTC: 6:40 AM Local: 2:40 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 18, 22, 58, 0, false);         // UTC: 10:58 PM Local: 6:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 16, 11, 5, 0, false);          // UTC: 11:05 AM Local: 7:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 20, 14, 49, 0, false);         // UTC: 2:49 PM Local: 10:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 24, 5, 28, 0, false);          // UTC: 5:28 AM Local: 1:28 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 1, 4, 31, 0, false);           // UTC: 4:31 AM Local: 12:31 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 2, 6, 16, 0, false);           // UTC: 6:16 AM Local: 2:16 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 4, 4, 13, 0, false);           // UTC: 4:13 AM Local: 12:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 5, 9, 51, 0, false);           // UTC: 9:51 AM Local: 5:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 15, 2, 15, 0, false);          // UTC: 2:15 AM Local: 10:15 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 23, 14, 48, 0, false);         // UTC: 2:48 PM Local: 10:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 20, 0, 32, 0, false);          // UTC: 12:32 AM Local: 8:32 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 15, 22, 33, 0, false);         // UTC: 10:33 PM Local: 6:33 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 19, 17, 9, 0, false);          // UTC: 5:09 PM Local: 1:09 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 2, 1, 32, 0, false);           // UTC: 1:32 AM Local: 9:32 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 20, 13, 54, 0, false);         // UTC: 1:54 PM Local: 9:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 11, 13, 3, 0, false);          // UTC: 1:03 PM Local: 9:03 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 6, 21, 10, 0, false);          // UTC: 9:10 PM Local: 5:10 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 12, 13, 5, 0, false);          // UTC: 1:05 PM Local: 9:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 8, 13, 11, 34, 0, false);         // UTC: 11:34 AM Local: 7:34 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 3, 1, 23, 0, false);           // UTC: 1:23 AM Local: 9:23 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 23, 20, 58, 0, false);         // UTC: 8:58 PM Local: 4:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 1, 3, 11, 0, false);           // UTC: 3:11 AM Local: 11:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 26, 10, 13, 0, false);         // UTC: 10:13 AM Local: 6:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 26, 8, 30, 0, false);          // UTC: 8:30 AM Local: 4:30 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 4, 1, 7, 0, false);            // UTC: 1:07 AM Local: 9:07 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 19, 10, 49, 0, false);         // UTC: 10:49 AM Local: 6:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 26, 3, 29, 0, false);          // UTC: 3:29 AM Local: 11:29 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 6, 14, 41, 0, false);          // UTC: 2:41 PM Local: 10:41 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 18, 6, 27, 0, false);          // UTC: 6:27 AM Local: 2:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 13, 1, 28, 0, false);          // UTC: 1:28 AM Local: 9:28 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 27, 13, 42, 0, false);         // UTC: 1:42 PM Local: 9:42 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 21, 4, 11, 0, false);          // UTC: 4:11 AM Local: 12:11 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 16, 16, 25, 0, false);         // UTC: 4:25 PM Local: 12:25 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 20, 10, 8, 0, false);          // UTC: 10:08 AM Local: 6:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 23, 5, 31, 0, false);          // UTC: 5:31 AM Local: 1:31 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 18, 7, 29, 0, false);          // UTC: 7:29 AM Local: 3:29 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 26, 17, 2, 0, false);          // UTC: 5:02 PM Local: 1:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 21, 3, 53, 0, false);          // UTC: 3:53 AM Local: 11:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 25, 14, 13, 0, false);         // UTC: 2:13 PM Local: 10:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 8, 8, 49, 0, false);           // UTC: 8:49 AM Local: 4:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 20, 11, 22, 0, false);         // UTC: 11:22 AM Local: 7:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 20, 22, 47, 0, false);         // UTC: 10:47 PM Local: 6:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 22, 8, 52, 0, false);          // UTC: 8:52 AM Local: 4:52 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 9, 26, 2, 44, 0, false);          // UTC: 2:44 AM Local: 10:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 12, 5, 39, 0, false);         // UTC: 5:39 AM Local: 1:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 10, 8, 24, 0, false);         // UTC: 8:24 AM Local: 4:24 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 5, 22, 57, 0, false);         // UTC: 10:57 PM Local: 6:57 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 27, 11, 18, 0, false);        // UTC: 11:18 AM Local: 7:18 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 13, 5, 25, 0, false);         // UTC: 5:25 AM Local: 1:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 22, 19, 32, 0, false);        // UTC: 7:32 PM Local: 3:32 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 27, 6, 18, 0, false);         // UTC: 6:18 AM Local: 2:18 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 16, 22, 57, 0, false);        // UTC: 10:57 PM Local: 6:57 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 21, 2, 15, 0, false);         // UTC: 2:15 AM Local: 10:15 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 20, 19, 56, 0, false);        // UTC: 7:56 PM Local: 3:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 17, 0, 39, 0, false);         // UTC: 12:39 AM Local: 8:39 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 8, 7, 54, 0, false);          // UTC: 7:54 AM Local: 3:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 7, 12, 16, 0, false);         // UTC: 12:16 PM Local: 8:16 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 22, 2, 23, 0, false);         // UTC: 2:23 AM Local: 10:23 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 24, 17, 57, 0, false);        // UTC: 5:57 PM Local: 1:57 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 3, 6, 43, 0, false);          // UTC: 6:43 AM Local: 2:43 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 11, 22, 29, 0, false);        // UTC: 10:29 PM Local: 6:29 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 9, 22, 49, 0, false);         // UTC: 10:49 PM Local: 6:49 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 12, 19, 13, 0, false);        // UTC: 7:13 PM Local: 3:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 19, 14, 15, 0, false);        // UTC: 2:15 PM Local: 10:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 5, 9, 7, 0, false);           // UTC: 9:07 AM Local: 5:07 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 1, 8, 28, 0, false);          // UTC: 8:28 AM Local: 4:28 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 18, 3, 53, 0, false);         // UTC: 3:53 AM Local: 11:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 14, 13, 18, 0, false);        // UTC: 1:18 PM Local: 9:18 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 10, 8, 3, 9, 0, false);           // UTC: 3:09 AM Local: 11:09 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 25, 16, 13, 0, false);        // UTC: 4:13 PM Local: 12:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 27, 15, 48, 0, false);        // UTC: 3:48 PM Local: 11:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 15, 8, 50, 0, false);         // UTC: 8:50 AM Local: 4:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 13, 6, 2, 0, false);          // UTC: 6:02 AM Local: 2:02 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 23, 19, 29, 0, false);        // UTC: 7:29 PM Local: 3:29 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 19, 12, 54, 0, false);        // UTC: 12:54 PM Local: 8:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 1, 14, 40, 0, false);         // UTC: 2:40 PM Local: 10:40 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 8, 19, 23, 0, false);         // UTC: 7:23 PM Local: 3:23 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 14, 10, 7, 0, false);         // UTC: 10:07 AM Local: 6:07 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 23, 20, 24, 0, false);        // UTC: 8:24 PM Local: 4:24 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 6, 1, 47, 0, false);          // UTC: 1:47 AM Local: 9:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 19, 11, 7, 0, false);         // UTC: 11:07 AM Local: 7:07 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 1, 16, 55, 0, false);         // UTC: 4:55 PM Local: 12:55 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 12, 14, 4, 0, false);         // UTC: 2:04 PM Local: 10:04 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 8, 12, 4, 0, false);          // UTC: 12:04 PM Local: 8:04 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 12, 18, 18, 0, false);        // UTC: 6:18 PM Local: 2:18 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 12, 18, 2, 0, false);         // UTC: 6:02 PM Local: 2:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 11, 5, 30, 0, false);         // UTC: 5:30 AM Local: 1:30 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 13, 15, 49, 0, false);        // UTC: 3:49 PM Local: 11:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 23, 11, 13, 0, false);        // UTC: 11:13 AM Local: 7:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 20, 16, 28, 0, false);        // UTC: 4:28 PM Local: 12:28 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 12, 5, 12, 0, false);         // UTC: 5:12 AM Local: 1:12 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 7, 3, 20, 0, false);          // UTC: 3:20 AM Local: 11:20 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 11, 15, 49, 0, false);        // UTC: 3:49 PM Local: 11:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 11, 27, 13, 0, 0, false);         // UTC: 1:00 PM Local: 9:00 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 17, 22, 18, 0, false);        // UTC: 10:18 PM Local: 6:18 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 9, 1, 37, 0, false);          // UTC: 1:37 AM Local: 9:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 22, 9, 3, 0, false);          // UTC: 9:03 AM Local: 5:03 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 11, 18, 48, 0, false);        // UTC: 6:48 PM Local: 2:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 9, 5, 50, 0, false);          // UTC: 5:50 AM Local: 1:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 8, 3, 11, 0, false);          // UTC: 3:11 AM Local: 11:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 20, 16, 55, 0, false);        // UTC: 4:55 PM Local: 12:55 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 16, 19, 17, 0, false);        // UTC: 7:17 PM Local: 3:17 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 24, 4, 38, 0, false);         // UTC: 4:38 AM Local: 12:38 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 26, 0, 7, 0, false);          // UTC: 12:07 AM Local: 8:07 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 6, 9, 38, 0, false);          // UTC: 9:38 AM Local: 5:38 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 14, 19, 38, 0, false);        // UTC: 7:38 PM Local: 3:38 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 15, 11, 25, 0, false);        // UTC: 11:25 AM Local: 7:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 17, 20, 16, 0, false);        // UTC: 8:16 PM Local: 4:16 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 12, 1, 26, 0, false);         // UTC: 1:26 AM Local: 9:26 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 11, 21, 55, 0, false);        // UTC: 9:55 PM Local: 5:55 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 14, 1, 30, 0, false);         // UTC: 1:30 AM Local: 9:30 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 18, 6, 50, 0, false);         // UTC: 6:50 AM Local: 2:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 3, 0, 9, 0, false);           // UTC: 12:09 AM Local: 8:09 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 1, 10, 51, 0, false);         // UTC: 10:51 AM Local: 6:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 27, 19, 22, 0, false);        // UTC: 7:22 PM Local: 3:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 26, 3, 24, 0, false);         // UTC: 3:24 AM Local: 11:24 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 5, 18, 21, 0, false);         // UTC: 6:21 PM Local: 2:21 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 6, 17, 38, 0, false);         // UTC: 5:38 PM Local: 1:38 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2018, 12, 22, 2, 49, 0, false);         // UTC: 2:49 AM Local: 10:49 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 18, 3, 45, 0, false);          // UTC: 3:45 AM Local: 11:45 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 23, 10, 14, 0, false);         // UTC: 10:14 AM Local: 6:14 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 20, 10, 55, 0, false);         // UTC: 10:55 AM Local: 6:55 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 17, 13, 7, 0, false);          // UTC: 1:07 PM Local: 9:07 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 22, 9, 48, 0, false);          // UTC: 9:48 AM Local: 5:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 14, 11, 3, 0, false);          // UTC: 11:03 AM Local: 7:03 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 15, 14, 1, 0, false);          // UTC: 2:01 PM Local: 10:01 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 25, 11, 52, 0, false);         // UTC: 11:52 AM Local: 7:52 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 2, 4, 8, 0, false);            // UTC: 4:08 AM Local: 12:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 16, 7, 19, 0, false);          // UTC: 7:19 AM Local: 3:19 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 24, 19, 10, 0, false);         // UTC: 7:10 PM Local: 3:10 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 1, 9, 51, 0, false);           // UTC: 9:51 AM Local: 5:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 11, 3, 57, 0, false);          // UTC: 3:57 AM Local: 11:57 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 17, 6, 23, 0, false);          // UTC: 6:23 AM Local: 2:23 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 12, 7, 35, 0, false);          // UTC: 7:35 AM Local: 3:35 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 8, 9, 22, 0, false);           // UTC: 9:22 AM Local: 5:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 15, 16, 14, 0, false);         // UTC: 4:14 PM Local: 12:14 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 17, 5, 29, 0, false);          // UTC: 5:29 AM Local: 1:29 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 22, 17, 39, 0, false);         // UTC: 5:39 PM Local: 1:39 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 24, 18, 15, 0, false);         // UTC: 6:15 PM Local: 2:15 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 4, 3, 8, 0, false);            // UTC: 3:08 AM Local: 11:08 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 17, 17, 42, 0, false);         // UTC: 5:42 PM Local: 1:42 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 26, 17, 58, 0, false);         // UTC: 5:58 PM Local: 1:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 26, 2, 20, 0, false);          // UTC: 2:20 AM Local: 10:20 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 1, 3, 21, 20, 0, false);          // UTC: 9:20 PM Local: 5:20 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 17, 10, 9, 0, false);          // UTC: 10:09 AM Local: 6:09 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 8, 17, 48, 0, false);          // UTC: 5:48 PM Local: 1:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 21, 0, 35, 0, false);          // UTC: 12:35 AM Local: 8:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 3, 5, 36, 0, false);           // UTC: 5:36 AM Local: 1:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 19, 5, 39, 0, false);          // UTC: 5:39 AM Local: 1:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 6, 12, 21, 0, false);          // UTC: 12:21 PM Local: 8:21 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 20, 11, 6, 0, false);          // UTC: 11:06 AM Local: 7:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 7, 18, 33, 0, false);          // UTC: 6:33 PM Local: 2:33 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 24, 7, 37, 0, false);          // UTC: 7:37 AM Local: 3:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 11, 13, 36, 0, false);         // UTC: 1:36 PM Local: 9:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 24, 11, 18, 0, false);         // UTC: 11:18 AM Local: 7:18 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 4, 4, 16, 0, false);           // UTC: 4:16 AM Local: 12:16 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 14, 13, 2, 0, false);          // UTC: 1:02 PM Local: 9:02 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 12, 8, 8, 0, false);           // UTC: 8:08 AM Local: 4:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 15, 12, 29, 0, false);         // UTC: 12:29 PM Local: 8:29 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 3, 6, 32, 0, false);           // UTC: 6:32 AM Local: 2:32 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 9, 17, 32, 0, false);          // UTC: 5:32 PM Local: 1:32 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 27, 8, 24, 0, false);          // UTC: 8:24 AM Local: 4:24 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 7, 8, 38, 0, false);           // UTC: 8:38 AM Local: 4:38 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 17, 9, 25, 0, false);          // UTC: 9:25 AM Local: 5:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 6, 8, 23, 0, false);           // UTC: 8:23 AM Local: 4:23 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 27, 4, 43, 0, false);          // UTC: 4:43 AM Local: 12:43 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 9, 12, 2, 0, false);           // UTC: 12:02 PM Local: 8:02 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 11, 15, 56, 0, false);         // UTC: 3:56 PM Local: 11:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 2, 9, 6, 8, 0, false);            // UTC: 6:08 AM Local: 2:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 27, 16, 16, 0, false);         // UTC: 4:16 PM Local: 12:16 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 2, 18, 3, 0, false);           // UTC: 6:03 PM Local: 2:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 3, 1, 50, 0, false);           // UTC: 1:50 AM Local: 9:50 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 2, 20, 8, 0, false);           // UTC: 8:08 PM Local: 4:08 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 25, 20, 47, 0, false);         // UTC: 8:47 PM Local: 4:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 17, 20, 9, 0, false);          // UTC: 8:09 PM Local: 4:09 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 17, 5, 58, 0, false);          // UTC: 5:58 AM Local: 1:58 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 21, 12, 19, 0, false);         // UTC: 12:19 PM Local: 8:19 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 21, 18, 43, 0, false);         // UTC: 6:43 PM Local: 2:43 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 14, 21, 3, 0, false);          // UTC: 9:03 PM Local: 5:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 17, 15, 5, 0, false);          // UTC: 3:05 PM Local: 11:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 8, 6, 39, 0, false);           // UTC: 6:39 AM Local: 2:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 10, 12, 35, 0, false);         // UTC: 12:35 PM Local: 8:35 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 10, 2, 17, 0, false);          // UTC: 2:17 AM Local: 10:17 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 15, 21, 18, 0, false);         // UTC: 9:18 PM Local: 5:18 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 16, 9, 37, 0, false);          // UTC: 9:37 AM Local: 5:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 7, 17, 46, 0, false);          // UTC: 5:46 PM Local: 1:46 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 22, 15, 2, 0, false);          // UTC: 3:02 PM Local: 11:02 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 5, 5, 9, 0, false);            // UTC: 5:09 AM Local: 1:09 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 26, 7, 0, 0, false);           // UTC: 7:00 AM Local: 3:00 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 9, 13, 7, 0, false);           // UTC: 1:07 PM Local: 9:07 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 22, 10, 12, 0, false);         // UTC: 10:12 AM Local: 6:12 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 2, 14, 37, 0, false);          // UTC: 2:37 PM Local: 10:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 4, 5, 22, 0, false);           // UTC: 5:22 AM Local: 1:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 3, 16, 5, 8, 0, false);           // UTC: 5:08 AM Local: 1:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 19, 4, 36, 0, false);          // UTC: 4:36 AM Local: 12:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 1, 3, 22, 0, false);           // UTC: 3:22 AM Local: 11:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 3, 6, 10, 0, false);           // UTC: 6:10 AM Local: 2:10 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 8, 18, 58, 0, false);          // UTC: 6:58 PM Local: 2:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 2, 2, 2, 0, false);            // UTC: 2:02 AM Local: 10:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 14, 9, 13, 0, false);          // UTC: 9:13 AM Local: 5:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 17, 1, 30, 0, false);          // UTC: 1:30 AM Local: 9:30 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 5, 17, 28, 0, false);          // UTC: 5:28 PM Local: 1:28 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 3, 12, 44, 0, false);          // UTC: 12:44 PM Local: 8:44 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 27, 2, 29, 0, false);          // UTC: 2:29 AM Local: 10:29 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 11, 5, 25, 0, false);          // UTC: 5:25 AM Local: 1:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 24, 10, 2, 0, false);          // UTC: 10:02 AM Local: 6:02 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 15, 21, 8, 0, false);          // UTC: 9:08 PM Local: 5:08 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 17, 4, 19, 0, false);          // UTC: 4:19 AM Local: 12:19 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 27, 11, 37, 0, false);         // UTC: 11:37 AM Local: 7:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 6, 0, 31, 0, false);           // UTC: 12:31 AM Local: 8:31 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 17, 14, 50, 0, false);         // UTC: 2:50 PM Local: 10:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 5, 22, 11, 0, false);          // UTC: 10:11 PM Local: 6:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 18, 12, 25, 0, false);         // UTC: 12:25 PM Local: 8:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 4, 21, 37, 0, false);          // UTC: 9:37 PM Local: 5:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 18, 2, 9, 0, false);           // UTC: 2:09 AM Local: 10:09 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 19, 20, 34, 0, false);         // UTC: 8:34 PM Local: 4:34 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 16, 3, 38, 0, false);          // UTC: 3:38 AM Local: 11:38 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 1, 21, 27, 0, false);          // UTC: 9:27 PM Local: 5:27 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 4, 3, 22, 49, 0, false);          // UTC: 10:49 PM Local: 6:49 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 6, 4, 15, 0, false);           // UTC: 4:15 AM Local: 12:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 23, 20, 30, 0, false);         // UTC: 8:30 PM Local: 4:30 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 6, 9, 27, 0, false);           // UTC: 9:27 AM Local: 5:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 18, 5, 15, 0, false);          // UTC: 5:15 AM Local: 1:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 7, 5, 55, 0, false);           // UTC: 5:55 AM Local: 1:55 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 17, 9, 1, 0, false);           // UTC: 9:01 AM Local: 5:01 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 14, 22, 5, 0, false);          // UTC: 10:05 PM Local: 6:05 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 5, 6, 36, 0, false);           // UTC: 6:36 AM Local: 2:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 2, 14, 50, 0, false);          // UTC: 2:50 PM Local: 10:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 24, 13, 40, 0, false);         // UTC: 1:40 PM Local: 9:40 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 11, 1, 0, 0, false);           // UTC: 1:00 AM Local: 9:00 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 10, 10, 18, 0, false);         // UTC: 10:18 AM Local: 6:18 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 5, 6, 2, 0, false);            // UTC: 6:02 AM Local: 2:02 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 4, 9, 42, 0, false);           // UTC: 9:42 AM Local: 5:42 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 19, 0, 37, 0, false);          // UTC: 12:37 AM Local: 8:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 9, 7, 53, 0, false);           // UTC: 7:53 AM Local: 3:53 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 20, 9, 31, 0, false);          // UTC: 9:31 AM Local: 5:31 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 13, 13, 57, 0, false);         // UTC: 1:57 PM Local: 9:57 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 21, 0, 53, 0, false);          // UTC: 12:53 AM Local: 8:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 18, 18, 13, 0, false);         // UTC: 6:13 PM Local: 2:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 18, 7, 47, 0, false);          // UTC: 7:47 AM Local: 3:47 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 22, 6, 10, 0, false);          // UTC: 6:10 AM Local: 2:10 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 7, 20, 47, 0, false);          // UTC: 8:47 PM Local: 4:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 17, 10, 7, 0, false);          // UTC: 10:07 AM Local: 6:07 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 5, 27, 8, 33, 0, false);          // UTC: 8:33 AM Local: 4:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 10, 10, 16, 0, false);         // UTC: 10:16 AM Local: 6:16 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 27, 16, 18, 0, false);         // UTC: 4:18 PM Local: 12:18 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 26, 4, 10, 0, false);          // UTC: 4:10 AM Local: 12:10 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 4, 21, 28, 0, false);          // UTC: 9:28 PM Local: 5:28 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 1, 13, 24, 0, false);          // UTC: 1:24 PM Local: 9:24 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 12, 12, 29, 0, false);         // UTC: 12:29 PM Local: 8:29 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 22, 10, 5, 0, false);          // UTC: 10:05 AM Local: 6:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 25, 20, 44, 0, false);         // UTC: 8:44 PM Local: 4:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 13, 1, 26, 0, false);          // UTC: 1:26 AM Local: 9:26 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 3, 2, 57, 0, false);           // UTC: 2:57 AM Local: 10:57 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 11, 10, 13, 0, false);         // UTC: 10:13 AM Local: 6:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 11, 9, 33, 0, false);          // UTC: 9:33 AM Local: 5:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 18, 14, 2, 0, false);          // UTC: 2:02 PM Local: 10:02 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 25, 16, 8, 0, false);          // UTC: 4:08 PM Local: 12:08 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 17, 14, 20, 0, false);         // UTC: 2:20 PM Local: 10:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 19, 5, 16, 0, false);          // UTC: 5:16 AM Local: 1:16 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 11, 4, 52, 0, false);          // UTC: 4:52 AM Local: 12:52 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 18, 3, 53, 0, false);          // UTC: 3:53 AM Local: 11:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 13, 10, 32, 0, false);         // UTC: 10:32 AM Local: 6:32 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 15, 12, 39, 0, false);         // UTC: 12:39 PM Local: 8:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 24, 19, 5, 0, false);          // UTC: 7:05 PM Local: 3:05 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 6, 17, 26, 0, false);          // UTC: 5:26 PM Local: 1:26 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 7, 14, 11, 0, false);          // UTC: 2:11 PM Local: 10:11 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 23, 17, 53, 0, false);         // UTC: 5:53 PM Local: 1:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 6, 13, 20, 43, 0, false);         // UTC: 8:43 PM Local: 4:43 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 26, 6, 15, 0, false);          // UTC: 6:15 AM Local: 2:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 11, 17, 49, 0, false);         // UTC: 5:49 PM Local: 1:49 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 5, 16, 51, 0, false);          // UTC: 4:51 PM Local: 12:51 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 2, 17, 18, 0, false);          // UTC: 5:18 PM Local: 1:18 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 9, 21, 56, 0, false);          // UTC: 9:56 PM Local: 5:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 1, 2, 7, 0, false);            // UTC: 2:07 AM Local: 10:07 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 11, 0, 51, 0, false);          // UTC: 12:51 AM Local: 8:51 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 2, 9, 53, 0, false);           // UTC: 9:53 AM Local: 5:53 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 25, 9, 35, 0, false);          // UTC: 9:35 AM Local: 5:35 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 3, 12, 25, 0, false);          // UTC: 12:25 PM Local: 8:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 27, 4, 15, 0, false);          // UTC: 4:15 AM Local: 12:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 5, 12, 8, 0, false);           // UTC: 12:08 PM Local: 8:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 8, 2, 44, 0, false);           // UTC: 2:44 AM Local: 10:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 23, 15, 8, 0, false);          // UTC: 3:08 PM Local: 11:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 6, 3, 57, 0, false);           // UTC: 3:57 AM Local: 11:57 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 4, 21, 40, 0, false);          // UTC: 9:40 PM Local: 5:40 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 7, 18, 40, 0, false);          // UTC: 6:40 PM Local: 2:40 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 22, 1, 50, 0, false);          // UTC: 1:50 AM Local: 9:50 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 24, 20, 52, 0, false);         // UTC: 8:52 PM Local: 4:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 10, 11, 20, 0, false);         // UTC: 11:20 AM Local: 7:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 7, 1, 8, 0, false);            // UTC: 1:08 AM Local: 9:08 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 13, 1, 34, 0, false);          // UTC: 1:34 AM Local: 9:34 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 2, 3, 23, 0, false);           // UTC: 3:23 AM Local: 11:23 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 23, 16, 57, 0, false);         // UTC: 4:57 PM Local: 12:57 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 7, 11, 12, 20, 0, false);         // UTC: 12:20 PM Local: 8:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 20, 19, 15, 0, false);         // UTC: 7:15 PM Local: 3:15 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 26, 17, 28, 0, false);         // UTC: 5:28 PM Local: 1:28 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 25, 19, 42, 0, false);         // UTC: 7:42 PM Local: 3:42 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 21, 4, 6, 0, false);           // UTC: 4:06 AM Local: 12:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 11, 6, 38, 0, false);          // UTC: 6:38 AM Local: 2:38 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 7, 21, 36, 0, false);          // UTC: 9:36 PM Local: 5:36 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 12, 13, 35, 0, false);         // UTC: 1:35 PM Local: 9:35 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 1, 17, 3, 0, false);           // UTC: 5:03 PM Local: 1:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 11, 2, 47, 0, false);          // UTC: 2:47 AM Local: 10:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 8, 9, 5, 0, false);            // UTC: 9:05 AM Local: 5:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 19, 9, 30, 0, false);          // UTC: 9:30 AM Local: 5:30 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 14, 3, 0, 0, false);           // UTC: 3:00 AM Local: 11:00 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 17, 9, 43, 0, false);          // UTC: 9:43 AM Local: 5:43 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 24, 7, 13, 0, false);          // UTC: 7:13 AM Local: 3:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 12, 16, 50, 0, false);         // UTC: 4:50 PM Local: 12:50 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 14, 14, 49, 0, false);         // UTC: 2:49 PM Local: 10:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 21, 13, 48, 0, false);         // UTC: 1:48 PM Local: 9:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 10, 22, 55, 0, false);         // UTC: 10:55 PM Local: 6:55 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 21, 16, 6, 0, false);          // UTC: 4:06 PM Local: 12:06 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 6, 12, 39, 0, false);          // UTC: 12:39 PM Local: 8:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 19, 14, 27, 0, false);         // UTC: 2:27 PM Local: 10:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 18, 1, 47, 0, false);          // UTC: 1:47 AM Local: 9:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 16, 20, 8, 0, false);          // UTC: 8:08 PM Local: 4:08 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 18, 14, 29, 0, false);         // UTC: 2:29 PM Local: 10:29 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 8, 24, 12, 17, 0, false);         // UTC: 12:17 PM Local: 8:17 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 11, 13, 3, 0, false);          // UTC: 1:03 PM Local: 9:03 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 6, 20, 26, 0, false);          // UTC: 8:26 PM Local: 4:26 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 27, 12, 48, 0, false);         // UTC: 12:48 PM Local: 8:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 8, 7, 26, 0, false);           // UTC: 7:26 AM Local: 3:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 16, 17, 25, 0, false);         // UTC: 5:25 PM Local: 1:25 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 25, 9, 51, 0, false);          // UTC: 9:51 AM Local: 5:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 2, 4, 39, 0, false);           // UTC: 4:39 AM Local: 12:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 21, 18, 38, 0, false);         // UTC: 6:38 PM Local: 2:38 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 2, 20, 44, 0, false);          // UTC: 8:44 PM Local: 4:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 19, 2, 55, 0, false);          // UTC: 2:55 AM Local: 10:55 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 9, 11, 24, 0, false);          // UTC: 11:24 AM Local: 7:24 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 18, 8, 7, 0, false);           // UTC: 8:07 AM Local: 4:07 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 2, 22, 38, 0, false);          // UTC: 10:38 PM Local: 6:38 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 7, 16, 5, 0, false);           // UTC: 4:05 PM Local: 12:05 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 18, 8, 41, 0, false);          // UTC: 8:41 AM Local: 4:41 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 10, 22, 7, 0, false);          // UTC: 10:07 PM Local: 6:07 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 20, 16, 11, 0, false);         // UTC: 4:11 PM Local: 12:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 17, 18, 21, 0, false);         // UTC: 6:21 PM Local: 2:21 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 17, 14, 47, 0, false);         // UTC: 2:47 PM Local: 10:47 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 11, 3, 58, 0, false);          // UTC: 3:58 AM Local: 11:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 19, 6, 25, 0, false);          // UTC: 6:25 AM Local: 2:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 24, 21, 51, 0, false);         // UTC: 9:51 PM Local: 5:51 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 1, 21, 24, 0, false);          // UTC: 9:24 PM Local: 5:24 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 9, 19, 25, 0, false);          // UTC: 7:25 PM Local: 3:25 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 9, 6, 19, 27, 0, false);          // UTC: 7:27 PM Local: 3:27 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 16, 2, 24, 0, false);         // UTC: 2:24 AM Local: 10:24 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 26, 15, 53, 0, false);        // UTC: 3:53 PM Local: 11:53 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 17, 22, 22, 0, false);        // UTC: 10:22 PM Local: 6:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 21, 15, 39, 0, false);        // UTC: 3:39 PM Local: 11:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 2, 0, 42, 0, false);          // UTC: 12:42 AM Local: 8:42 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 10, 14, 49, 0, false);        // UTC: 2:49 PM Local: 10:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 19, 12, 26, 0, false);        // UTC: 12:26 PM Local: 8:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 18, 17, 24, 0, false);        // UTC: 5:24 PM Local: 1:24 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 23, 7, 3, 0, false);          // UTC: 7:03 AM Local: 3:03 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 20, 9, 51, 0, false);         // UTC: 9:51 AM Local: 5:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 21, 9, 56, 0, false);         // UTC: 9:56 AM Local: 5:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 25, 1, 29, 0, false);         // UTC: 1:29 AM Local: 9:29 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 11, 10, 27, 0, false);        // UTC: 10:27 AM Local: 6:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 3, 1, 15, 0, false);          // UTC: 1:15 AM Local: 9:15 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 2, 2, 15, 0, false);          // UTC: 2:15 AM Local: 10:15 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 6, 22, 54, 0, false);         // UTC: 10:54 PM Local: 6:54 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 19, 22, 12, 0, false);        // UTC: 10:12 PM Local: 6:12 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 17, 12, 18, 0, false);        // UTC: 12:18 PM Local: 8:18 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 1, 20, 22, 0, false);         // UTC: 8:22 PM Local: 4:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 1, 2, 20, 0, false);          // UTC: 2:20 AM Local: 10:20 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 23, 20, 34, 0, false);        // UTC: 8:34 PM Local: 4:34 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 14, 22, 16, 0, false);        // UTC: 10:16 PM Local: 6:16 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 20, 3, 56, 0, false);         // UTC: 3:56 AM Local: 11:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 7, 22, 11, 0, false);         // UTC: 10:11 PM Local: 6:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 10, 11, 13, 26, 0, false);        // UTC: 1:26 PM Local: 9:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 5, 14, 36, 0, false);         // UTC: 2:36 PM Local: 10:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 4, 14, 20, 0, false);         // UTC: 2:20 PM Local: 10:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 4, 0, 26, 0, false);          // UTC: 12:26 AM Local: 8:26 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 18, 3, 51, 0, false);         // UTC: 3:51 AM Local: 11:51 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 18, 20, 8, 0, false);         // UTC: 8:08 PM Local: 4:08 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 4, 8, 20, 0, false);          // UTC: 8:20 AM Local: 4:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 3, 5, 10, 0, false);          // UTC: 5:10 AM Local: 1:10 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 19, 12, 8, 0, false);         // UTC: 12:08 PM Local: 8:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 27, 11, 50, 0, false);        // UTC: 11:50 AM Local: 7:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 27, 10, 0, 0, false);         // UTC: 10:00 AM Local: 6:00 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 1, 4, 56, 0, false);          // UTC: 4:56 AM Local: 12:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 24, 19, 17, 0, false);        // UTC: 7:17 PM Local: 3:17 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 21, 19, 27, 0, false);        // UTC: 7:27 PM Local: 3:27 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 1, 16, 51, 0, false);         // UTC: 4:51 PM Local: 12:51 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 4, 19, 48, 0, false);         // UTC: 7:48 PM Local: 3:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 11, 1, 14, 0, false);         // UTC: 1:14 AM Local: 9:14 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 22, 2, 34, 0, false);         // UTC: 2:34 AM Local: 10:34 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 23, 6, 20, 0, false);         // UTC: 6:20 AM Local: 2:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 8, 11, 4, 0, false);          // UTC: 11:04 AM Local: 7:04 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 14, 3, 9, 0, false);          // UTC: 3:09 AM Local: 11:09 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 13, 3, 33, 0, false);         // UTC: 3:33 AM Local: 11:33 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 12, 14, 56, 0, false);        // UTC: 2:56 PM Local: 10:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 25, 18, 3, 0, false);         // UTC: 6:03 PM Local: 2:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 24, 8, 29, 0, false);         // UTC: 8:29 AM Local: 4:29 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 11, 24, 2, 30, 0, false);         // UTC: 2:30 AM Local: 10:30 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 9, 12, 40, 0, false);         // UTC: 12:40 PM Local: 8:40 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 9, 13, 25, 0, false);         // UTC: 1:25 PM Local: 9:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 17, 3, 20, 0, false);         // UTC: 3:20 AM Local: 11:20 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 12, 4, 56, 0, false);         // UTC: 4:56 AM Local: 12:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 17, 13, 19, 0, false);        // UTC: 1:19 PM Local: 9:19 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 6, 6, 42, 0, false);          // UTC: 6:42 AM Local: 2:42 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 9, 12, 33, 0, false);         // UTC: 12:33 PM Local: 8:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 9, 16, 13, 0, false);         // UTC: 4:13 PM Local: 12:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 24, 11, 15, 0, false);        // UTC: 11:15 AM Local: 7:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 5, 21, 43, 0, false);         // UTC: 9:43 PM Local: 5:43 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 3, 22, 10, 0, false);         // UTC: 10:10 PM Local: 6:10 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 23, 22, 56, 0, false);        // UTC: 10:56 PM Local: 6:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 11, 3, 33, 0, false);         // UTC: 3:33 AM Local: 11:33 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 21, 19, 58, 0, false);        // UTC: 7:58 PM Local: 3:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 6, 0, 26, 0, false);          // UTC: 12:26 AM Local: 8:26 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 27, 6, 13, 0, false);         // UTC: 6:13 AM Local: 2:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 20, 14, 6, 0, false);         // UTC: 2:06 PM Local: 10:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 22, 13, 33, 0, false);        // UTC: 1:33 PM Local: 9:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 26, 22, 49, 0, false);        // UTC: 10:49 PM Local: 6:49 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 13, 10, 5, 0, false);         // UTC: 10:05 AM Local: 6:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 5, 10, 12, 0, false);         // UTC: 10:12 AM Local: 6:12 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 17, 7, 12, 0, false);         // UTC: 7:12 AM Local: 3:12 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 22, 18, 35, 0, false);        // UTC: 6:35 PM Local: 2:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 11, 18, 5, 0, false);         // UTC: 6:05 PM Local: 2:05 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2019, 12, 5, 12, 39, 0, false);         // UTC: 12:39 PM Local: 8:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 16, 1, 39, 0, false);          // UTC: 1:39 AM Local: 9:39 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 22, 20, 11, 0, false);         // UTC: 8:11 PM Local: 4:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 1, 10, 18, 0, false);          // UTC: 10:18 AM Local: 6:18 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 17, 7, 22, 0, false);          // UTC: 7:22 AM Local: 3:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 17, 20, 58, 0, false);         // UTC: 8:58 PM Local: 4:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 4, 21, 43, 0, false);          // UTC: 9:43 PM Local: 5:43 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 13, 13, 24, 0, false);         // UTC: 1:24 PM Local: 9:24 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 22, 13, 41, 0, false);         // UTC: 1:41 PM Local: 9:41 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 7, 5, 28, 0, false);           // UTC: 5:28 AM Local: 1:28 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 18, 8, 48, 0, false);          // UTC: 8:48 AM Local: 4:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 1, 14, 1, 0, false);           // UTC: 2:01 PM Local: 10:01 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 25, 8, 53, 0, false);          // UTC: 8:53 AM Local: 4:53 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 5, 15, 33, 0, false);          // UTC: 3:33 PM Local: 11:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 25, 3, 58, 0, false);          // UTC: 3:58 AM Local: 11:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 25, 0, 0, 0, false);           // UTC: 12:00 AM Local: 8:00 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 23, 4, 54, 0, false);          // UTC: 4:54 AM Local: 12:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 17, 5, 52, 0, false);          // UTC: 5:52 AM Local: 1:52 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 10, 15, 58, 0, false);         // UTC: 3:58 PM Local: 11:58 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 7, 18, 28, 0, false);          // UTC: 6:28 PM Local: 2:28 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 27, 12, 38, 0, false);         // UTC: 12:38 PM Local: 8:38 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 20, 9, 5, 0, false);           // UTC: 9:05 AM Local: 5:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 14, 13, 39, 0, false);         // UTC: 1:39 PM Local: 9:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 10, 16, 29, 0, false);         // UTC: 4:29 PM Local: 12:29 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 3, 22, 15, 0, false);          // UTC: 10:15 PM Local: 6:15 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 1, 5, 12, 25, 0, false);          // UTC: 12:25 PM Local: 8:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 12, 20, 35, 0, false);         // UTC: 8:35 PM Local: 4:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 19, 9, 2, 0, false);           // UTC: 9:02 AM Local: 5:02 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 16, 0, 6, 0, false);           // UTC: 12:06 AM Local: 8:06 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 26, 15, 55, 0, false);         // UTC: 3:55 PM Local: 11:55 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 2, 14, 33, 0, false);          // UTC: 2:33 PM Local: 10:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 12, 4, 7, 0, false);           // UTC: 4:07 AM Local: 12:07 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 25, 4, 43, 0, false);          // UTC: 4:43 AM Local: 12:43 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 25, 8, 24, 0, false);          // UTC: 8:24 AM Local: 4:24 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 10, 10, 27, 0, false);         // UTC: 10:27 AM Local: 6:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 12, 12, 15, 0, false);         // UTC: 12:15 PM Local: 8:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 17, 4, 7, 0, false);           // UTC: 4:07 AM Local: 12:07 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 15, 19, 53, 0, false);         // UTC: 7:53 PM Local: 3:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 25, 6, 8, 0, false);           // UTC: 6:08 AM Local: 2:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 17, 3, 22, 0, false);          // UTC: 3:22 AM Local: 11:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 27, 13, 54, 0, false);         // UTC: 1:54 PM Local: 9:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 20, 7, 4, 0, false);           // UTC: 7:04 AM Local: 3:04 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 26, 15, 46, 0, false);         // UTC: 3:46 PM Local: 11:46 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 4, 5, 21, 0, false);           // UTC: 5:21 AM Local: 1:21 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 20, 12, 29, 0, false);         // UTC: 12:29 PM Local: 8:29 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 5, 8, 55, 0, false);           // UTC: 8:55 AM Local: 4:55 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 16, 2, 29, 0, false);          // UTC: 2:29 AM Local: 10:29 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 23, 7, 27, 0, false);          // UTC: 7:27 AM Local: 3:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 22, 11, 47, 0, false);         // UTC: 11:47 AM Local: 7:47 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 18, 12, 54, 0, false);         // UTC: 12:54 PM Local: 8:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 2, 27, 6, 1, 0, false);           // UTC: 6:01 AM Local: 2:01 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 10, 21, 48, 0, false);         // UTC: 9:48 PM Local: 5:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 14, 13, 8, 0, false);          // UTC: 1:08 PM Local: 9:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 11, 11, 51, 0, false);         // UTC: 11:51 AM Local: 7:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 14, 10, 55, 0, false);         // UTC: 10:55 AM Local: 6:55 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 21, 19, 18, 0, false);         // UTC: 7:18 PM Local: 3:18 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 11, 16, 53, 0, false);         // UTC: 4:53 PM Local: 12:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 6, 0, 1, 0, false);            // UTC: 12:01 AM Local: 8:01 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 24, 3, 14, 0, false);          // UTC: 3:14 AM Local: 11:14 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 13, 21, 49, 0, false);         // UTC: 9:49 PM Local: 5:49 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 8, 6, 7, 0, false);            // UTC: 6:07 AM Local: 2:07 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 24, 3, 56, 0, false);          // UTC: 3:56 AM Local: 11:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 10, 8, 35, 0, false);          // UTC: 8:35 AM Local: 4:35 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 19, 16, 44, 0, false);         // UTC: 4:44 PM Local: 12:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 22, 4, 37, 0, false);          // UTC: 4:37 AM Local: 12:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 18, 8, 50, 0, false);          // UTC: 8:50 AM Local: 4:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 15, 1, 38, 0, false);          // UTC: 1:38 AM Local: 9:38 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 14, 6, 48, 0, false);          // UTC: 6:48 AM Local: 2:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 1, 18, 16, 0, false);          // UTC: 6:16 PM Local: 2:16 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 1, 11, 46, 0, false);          // UTC: 11:46 AM Local: 7:46 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 16, 0, 40, 0, false);          // UTC: 12:40 AM Local: 8:40 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 9, 2, 13, 0, false);           // UTC: 2:13 AM Local: 10:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 21, 14, 18, 0, false);         // UTC: 2:18 PM Local: 10:18 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 27, 9, 28, 0, false);          // UTC: 9:28 AM Local: 5:28 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 19, 16, 0, 0, false);          // UTC: 4:00 PM Local: 12:00 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 3, 5, 9, 49, 0, false);           // UTC: 9:49 AM Local: 5:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 11, 5, 46, 0, false);          // UTC: 5:46 AM Local: 1:46 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 11, 21, 51, 0, false);         // UTC: 9:51 PM Local: 5:51 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 5, 17, 0, 0, false);           // UTC: 5:00 PM Local: 1:00 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 8, 19, 22, 0, false);          // UTC: 7:22 PM Local: 3:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 19, 7, 51, 0, false);          // UTC: 7:51 AM Local: 3:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 23, 2, 39, 0, false);          // UTC: 2:39 AM Local: 10:39 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 2, 11, 4, 0, false);           // UTC: 11:04 AM Local: 7:04 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 11, 20, 42, 0, false);         // UTC: 8:42 PM Local: 4:42 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 15, 12, 36, 0, false);         // UTC: 12:36 PM Local: 8:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 5, 18, 32, 0, false);          // UTC: 6:32 PM Local: 2:32 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 23, 19, 22, 0, false);         // UTC: 7:22 PM Local: 3:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 12, 14, 13, 0, false);         // UTC: 2:13 PM Local: 10:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 1, 3, 5, 0, false);            // UTC: 3:05 AM Local: 11:05 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 22, 2, 20, 0, false);          // UTC: 2:20 AM Local: 10:20 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 7, 10, 45, 0, false);          // UTC: 10:45 AM Local: 6:45 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 26, 7, 5, 0, false);           // UTC: 7:05 AM Local: 3:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 17, 20, 34, 0, false);         // UTC: 8:34 PM Local: 4:34 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 9, 2, 53, 0, false);           // UTC: 2:53 AM Local: 10:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 21, 22, 21, 0, false);         // UTC: 10:21 PM Local: 6:21 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 2, 20, 23, 0, false);          // UTC: 8:23 PM Local: 4:23 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 7, 0, 57, 0, false);           // UTC: 12:57 AM Local: 8:57 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 13, 10, 0, 0, false);          // UTC: 10:00 AM Local: 6:00 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 27, 5, 42, 0, false);          // UTC: 5:42 AM Local: 1:42 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 18, 18, 56, 0, false);         // UTC: 6:56 PM Local: 2:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 4, 16, 6, 22, 0, false);          // UTC: 6:22 AM Local: 2:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 20, 3, 25, 0, false);          // UTC: 3:25 AM Local: 11:25 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 26, 13, 13, 0, false);         // UTC: 1:13 PM Local: 9:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 15, 12, 54, 0, false);         // UTC: 12:54 PM Local: 8:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 26, 11, 44, 0, false);         // UTC: 11:44 AM Local: 7:44 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 14, 15, 36, 0, false);         // UTC: 3:36 PM Local: 11:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 24, 21, 17, 0, false);         // UTC: 9:17 PM Local: 5:17 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 20, 12, 6, 0, false);          // UTC: 12:06 PM Local: 8:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 10, 17, 58, 0, false);         // UTC: 5:58 PM Local: 1:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 21, 21, 4, 0, false);          // UTC: 9:04 PM Local: 5:04 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 11, 22, 3, 0, false);          // UTC: 10:03 PM Local: 6:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 17, 17, 49, 0, false);         // UTC: 5:49 PM Local: 1:49 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 15, 0, 48, 0, false);          // UTC: 12:48 AM Local: 8:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 26, 2, 16, 0, false);          // UTC: 2:16 AM Local: 10:16 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 5, 16, 26, 0, false);          // UTC: 4:26 PM Local: 12:26 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 2, 11, 57, 0, false);          // UTC: 11:57 AM Local: 7:57 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 8, 11, 34, 0, false);          // UTC: 11:34 AM Local: 7:34 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 3, 17, 51, 0, false);          // UTC: 5:51 PM Local: 1:51 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 19, 20, 41, 0, false);         // UTC: 8:41 PM Local: 4:41 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 8, 8, 23, 0, false);           // UTC: 8:23 AM Local: 4:23 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 12, 4, 37, 0, false);          // UTC: 4:37 AM Local: 12:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 5, 3, 34, 0, false);           // UTC: 3:34 AM Local: 11:34 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 24, 7, 44, 0, false);          // UTC: 7:44 AM Local: 3:44 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 25, 22, 37, 0, false);         // UTC: 10:37 PM Local: 6:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 22, 21, 49, 0, false);         // UTC: 9:49 PM Local: 5:49 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 5, 1, 12, 49, 0, false);          // UTC: 12:49 PM Local: 8:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 18, 7, 15, 0, false);          // UTC: 7:15 AM Local: 3:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 1, 11, 26, 0, false);          // UTC: 11:26 AM Local: 7:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 14, 6, 11, 0, false);          // UTC: 6:11 AM Local: 2:11 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 5, 21, 51, 0, false);          // UTC: 9:51 PM Local: 5:51 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 4, 6, 39, 0, false);           // UTC: 6:39 AM Local: 2:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 12, 11, 54, 0, false);         // UTC: 11:54 AM Local: 7:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 18, 0, 32, 0, false);          // UTC: 12:32 AM Local: 8:32 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 24, 4, 9, 0, false);           // UTC: 4:09 AM Local: 12:09 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 7, 7, 32, 0, false);           // UTC: 7:32 AM Local: 3:32 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 26, 7, 49, 0, false);          // UTC: 7:49 AM Local: 3:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 1, 15, 20, 0, false);          // UTC: 3:20 PM Local: 11:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 24, 13, 3, 0, false);          // UTC: 1:03 PM Local: 9:03 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 4, 9, 40, 0, false);           // UTC: 9:40 AM Local: 5:40 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 6, 15, 52, 0, false);          // UTC: 3:52 PM Local: 11:52 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 11, 15, 22, 0, false);         // UTC: 3:22 PM Local: 11:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 24, 18, 41, 0, false);         // UTC: 6:41 PM Local: 2:41 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 27, 8, 25, 0, false);          // UTC: 8:25 AM Local: 4:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 26, 8, 30, 0, false);          // UTC: 8:30 AM Local: 4:30 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 8, 18, 7, 0, false);           // UTC: 6:07 PM Local: 2:07 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 3, 18, 9, 0, false);           // UTC: 6:09 PM Local: 2:09 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 25, 12, 56, 0, false);         // UTC: 12:56 PM Local: 8:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 10, 3, 16, 0, false);          // UTC: 3:16 AM Local: 11:16 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 15, 5, 38, 0, false);          // UTC: 5:38 AM Local: 1:38 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 17, 6, 3, 0, false);           // UTC: 6:03 AM Local: 2:03 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 6, 7, 10, 21, 0, false);          // UTC: 10:21 AM Local: 6:21 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 18, 10, 29, 0, false);         // UTC: 10:29 AM Local: 6:29 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 22, 7, 32, 0, false);          // UTC: 7:32 AM Local: 3:32 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 23, 22, 56, 0, false);         // UTC: 10:56 PM Local: 6:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 11, 2, 17, 0, false);          // UTC: 2:17 AM Local: 10:17 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 23, 13, 47, 0, false);         // UTC: 1:47 PM Local: 9:47 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 25, 0, 38, 0, false);          // UTC: 12:38 AM Local: 8:38 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 14, 6, 6, 0, false);           // UTC: 6:06 AM Local: 2:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 26, 0, 31, 0, false);          // UTC: 12:31 AM Local: 8:31 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 3, 8, 31, 0, false);           // UTC: 8:31 AM Local: 4:31 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 1, 8, 3, 0, false);            // UTC: 8:03 AM Local: 4:03 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 11, 16, 54, 0, false);         // UTC: 4:54 PM Local: 12:54 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 5, 14, 18, 0, false);          // UTC: 2:18 PM Local: 10:18 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 18, 7, 26, 0, false);          // UTC: 7:26 AM Local: 3:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 17, 1, 34, 0, false);          // UTC: 1:34 AM Local: 9:34 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 27, 21, 3, 0, false);          // UTC: 9:03 PM Local: 5:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 27, 16, 39, 0, false);         // UTC: 4:39 PM Local: 12:39 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 23, 15, 15, 0, false);         // UTC: 3:15 PM Local: 11:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 12, 16, 9, 0, false);          // UTC: 4:09 PM Local: 12:09 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 7, 16, 25, 0, false);          // UTC: 4:25 PM Local: 12:25 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 26, 15, 58, 0, false);         // UTC: 3:58 PM Local: 11:58 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 1, 18, 36, 0, false);          // UTC: 6:36 PM Local: 2:36 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 24, 0, 23, 0, false);          // UTC: 12:23 AM Local: 8:23 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 11, 15, 55, 0, false);         // UTC: 3:55 PM Local: 11:55 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 14, 6, 42, 0, false);          // UTC: 6:42 AM Local: 2:42 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 7, 6, 20, 14, 0, false);          // UTC: 8:14 PM Local: 4:14 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 15, 21, 5, 0, false);          // UTC: 9:05 PM Local: 5:05 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 14, 2, 38, 0, false);          // UTC: 2:38 AM Local: 10:38 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 24, 4, 39, 0, false);          // UTC: 4:39 AM Local: 12:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 22, 22, 57, 0, false);         // UTC: 10:57 PM Local: 6:57 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 21, 20, 54, 0, false);         // UTC: 8:54 PM Local: 4:54 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 24, 15, 37, 0, false);         // UTC: 3:37 PM Local: 11:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 13, 14, 13, 0, false);         // UTC: 2:13 PM Local: 10:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 27, 2, 54, 0, false);          // UTC: 2:54 AM Local: 10:54 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 18, 13, 1, 0, false);          // UTC: 1:01 PM Local: 9:01 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 20, 8, 23, 0, false);          // UTC: 8:23 AM Local: 4:23 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 15, 4, 48, 0, false);          // UTC: 4:48 AM Local: 12:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 25, 16, 45, 0, false);         // UTC: 4:45 PM Local: 12:45 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 10, 10, 32, 0, false);         // UTC: 10:32 AM Local: 6:32 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 9, 3, 37, 0, false);           // UTC: 3:37 AM Local: 11:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 26, 2, 3, 0, false);           // UTC: 2:03 AM Local: 10:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 12, 14, 45, 0, false);         // UTC: 2:45 PM Local: 10:45 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 1, 13, 36, 0, false);          // UTC: 1:36 PM Local: 9:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 3, 17, 16, 0, false);          // UTC: 5:16 PM Local: 1:16 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 1, 12, 49, 0, false);          // UTC: 12:49 PM Local: 8:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 5, 19, 31, 0, false);          // UTC: 7:31 PM Local: 3:31 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 17, 3, 48, 0, false);          // UTC: 3:48 AM Local: 11:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 8, 5, 44, 0, false);           // UTC: 5:44 AM Local: 1:44 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 5, 19, 10, 0, false);          // UTC: 7:10 PM Local: 3:10 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 5, 12, 12, 0, false);          // UTC: 12:12 PM Local: 8:12 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 8, 3, 2, 28, 0, false);           // UTC: 2:28 AM Local: 10:28 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 17, 0, 1, 0, false);           // UTC: 12:01 AM Local: 8:01 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 24, 5, 57, 0, false);          // UTC: 5:57 AM Local: 1:57 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 7, 16, 44, 0, false);          // UTC: 4:44 PM Local: 12:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 22, 10, 27, 0, false);         // UTC: 10:27 AM Local: 6:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 15, 21, 9, 0, false);          // UTC: 9:09 PM Local: 5:09 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 26, 4, 37, 0, false);          // UTC: 4:37 AM Local: 12:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 1, 16, 58, 0, false);          // UTC: 4:58 PM Local: 12:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 22, 15, 50, 0, false);         // UTC: 3:50 PM Local: 11:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 9, 6, 46, 0, false);           // UTC: 6:46 AM Local: 2:46 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 16, 19, 3, 0, false);          // UTC: 7:03 PM Local: 3:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 11, 0, 36, 0, false);          // UTC: 12:36 AM Local: 8:36 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 22, 9, 31, 0, false);          // UTC: 9:31 AM Local: 5:31 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 22, 6, 35, 0, false);          // UTC: 6:35 AM Local: 2:35 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 15, 8, 26, 0, false);          // UTC: 8:26 AM Local: 4:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 2, 11, 45, 0, false);          // UTC: 11:45 AM Local: 7:45 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 8, 14, 54, 0, false);          // UTC: 2:54 PM Local: 10:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 1, 5, 21, 0, false);           // UTC: 5:21 AM Local: 1:21 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 16, 1, 25, 0, false);          // UTC: 1:25 AM Local: 9:25 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 14, 18, 21, 0, false);         // UTC: 6:21 PM Local: 2:21 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 5, 13, 56, 0, false);          // UTC: 1:56 PM Local: 9:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 5, 15, 49, 0, false);          // UTC: 3:49 PM Local: 11:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 19, 8, 27, 0, false);          // UTC: 8:27 AM Local: 4:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 23, 17, 30, 0, false);         // UTC: 5:30 PM Local: 1:30 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 18, 2, 52, 0, false);          // UTC: 2:52 AM Local: 10:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 9, 1, 10, 19, 0, false);          // UTC: 10:19 AM Local: 6:19 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 15, 17, 9, 0, false);         // UTC: 5:09 PM Local: 1:09 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 3, 0, 37, 0, false);          // UTC: 12:37 AM Local: 8:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 24, 13, 37, 0, false);        // UTC: 1:37 PM Local: 9:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 20, 19, 56, 0, false);        // UTC: 7:56 PM Local: 3:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 6, 6, 35, 0, false);          // UTC: 6:35 AM Local: 2:35 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 5, 14, 42, 0, false);         // UTC: 2:42 PM Local: 10:42 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 18, 8, 41, 0, false);         // UTC: 8:41 AM Local: 4:41 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 17, 8, 6, 0, false);          // UTC: 8:06 AM Local: 4:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 9, 10, 51, 0, false);         // UTC: 10:51 AM Local: 6:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 12, 8, 6, 0, false);          // UTC: 8:06 AM Local: 4:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 13, 12, 33, 0, false);        // UTC: 12:33 PM Local: 8:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 3, 22, 2, 0, false);          // UTC: 10:02 PM Local: 6:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 6, 2, 33, 0, false);          // UTC: 2:33 AM Local: 10:33 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 9, 7, 5, 0, false);           // UTC: 7:05 AM Local: 3:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 6, 22, 32, 0, false);         // UTC: 10:32 PM Local: 6:32 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 15, 15, 26, 0, false);        // UTC: 3:26 PM Local: 11:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 25, 10, 28, 0, false);        // UTC: 10:28 AM Local: 6:28 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 5, 8, 6, 0, false);           // UTC: 8:06 AM Local: 4:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 17, 21, 22, 0, false);        // UTC: 9:22 PM Local: 5:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 2, 17, 33, 0, false);         // UTC: 5:33 PM Local: 1:33 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 21, 10, 11, 0, false);        // UTC: 10:11 AM Local: 6:11 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 15, 5, 16, 0, false);         // UTC: 5:16 AM Local: 1:16 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 11, 2, 19, 0, false);         // UTC: 2:19 AM Local: 10:19 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 16, 21, 32, 0, false);        // UTC: 9:32 PM Local: 5:32 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 10, 5, 7, 2, 0, false);           // UTC: 7:02 AM Local: 3:02 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 17, 9, 22, 0, false);         // UTC: 9:22 AM Local: 5:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 16, 17, 46, 0, false);        // UTC: 5:46 PM Local: 1:46 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 12, 11, 53, 0, false);        // UTC: 11:53 AM Local: 7:53 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 18, 7, 9, 0, false);          // UTC: 7:09 AM Local: 3:09 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 13, 10, 2, 0, false);         // UTC: 10:02 AM Local: 6:02 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 19, 3, 18, 0, false);         // UTC: 3:18 AM Local: 11:18 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 27, 12, 51, 0, false);        // UTC: 12:51 PM Local: 8:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 25, 15, 44, 0, false);        // UTC: 3:44 PM Local: 11:44 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 8, 3, 33, 0, false);          // UTC: 3:33 AM Local: 11:33 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 4, 8, 30, 0, false);          // UTC: 8:30 AM Local: 4:30 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 25, 22, 3, 0, false);         // UTC: 10:03 PM Local: 6:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 2, 0, 29, 0, false);          // UTC: 12:29 AM Local: 8:29 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 27, 11, 58, 0, false);        // UTC: 11:58 AM Local: 7:58 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 22, 7, 56, 0, false);         // UTC: 7:56 AM Local: 3:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 8, 20, 53, 0, false);         // UTC: 8:53 PM Local: 4:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 4, 20, 36, 0, false);         // UTC: 8:36 PM Local: 4:36 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 9, 20, 47, 0, false);         // UTC: 8:47 PM Local: 4:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 7, 3, 45, 0, false);          // UTC: 3:45 AM Local: 11:45 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 5, 16, 45, 0, false);         // UTC: 4:45 PM Local: 12:45 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 17, 7, 37, 0, false);         // UTC: 7:37 AM Local: 3:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 6, 6, 9, 0, false);           // UTC: 6:09 AM Local: 2:09 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 11, 16, 19, 0, false);        // UTC: 4:19 PM Local: 12:19 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 3, 9, 27, 0, false);          // UTC: 9:27 AM Local: 5:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 15, 15, 38, 0, false);        // UTC: 3:38 PM Local: 11:38 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 11, 9, 4, 12, 0, false);          // UTC: 4:12 AM Local: 12:12 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 25, 14, 44, 0, false);        // UTC: 2:44 PM Local: 10:44 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 23, 3, 13, 0, false);         // UTC: 3:13 AM Local: 11:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 26, 18, 27, 0, false);        // UTC: 6:27 PM Local: 2:27 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 20, 15, 48, 0, false);        // UTC: 3:48 PM Local: 11:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 9, 20, 17, 0, false);         // UTC: 8:17 PM Local: 4:17 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 20, 8, 10, 0, false);         // UTC: 8:10 AM Local: 4:10 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 10, 13, 2, 0, false);         // UTC: 1:02 PM Local: 9:02 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 22, 20, 11, 0, false);        // UTC: 8:11 PM Local: 4:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 16, 0, 29, 0, false);         // UTC: 12:29 AM Local: 8:29 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 5, 17, 12, 0, false);         // UTC: 5:12 PM Local: 1:12 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 5, 21, 56, 0, false);         // UTC: 9:56 PM Local: 5:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 15, 6, 4, 0, false);          // UTC: 6:04 AM Local: 2:04 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 1, 17, 9, 0, false);          // UTC: 5:09 PM Local: 1:09 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 11, 6, 28, 0, false);         // UTC: 6:28 AM Local: 2:28 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 19, 15, 1, 0, false);         // UTC: 3:01 PM Local: 11:01 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 15, 18, 31, 0, false);        // UTC: 6:31 PM Local: 2:31 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 5, 18, 17, 0, false);         // UTC: 6:17 PM Local: 2:17 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 13, 21, 37, 0, false);        // UTC: 9:37 PM Local: 5:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 5, 2, 42, 0, false);          // UTC: 2:42 AM Local: 10:42 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 16, 6, 7, 0, false);          // UTC: 6:07 AM Local: 2:07 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 20, 18, 3, 0, false);         // UTC: 6:03 PM Local: 2:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 7, 12, 45, 0, false);         // UTC: 12:45 PM Local: 8:45 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 24, 17, 36, 0, false);        // UTC: 5:36 PM Local: 1:36 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 6, 16, 35, 0, false);         // UTC: 4:35 PM Local: 12:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 10, 2020, 12, 1, 22, 17, 0, false);         // UTC: 10:17 PM Local: 6:17 PM Offset: -04:00:00

	Serial.println(); Serial.print(failedCount); Serial.print(" of "); Serial.print(testCount); Serial.println(" test(s) failed.");
}
#endif
