#ifndef TEST_TIMEZONEID_9_H
#define TEST_TIMEZONEID_9_H

#include "TimeManager.h"
#include "TestHelper.h"

void run_TimeZoneId_9_Tests(const TimeManager& timeManager)
{
	uint16_t testCount = 0;
	uint16_t failedCount = 0;

	testCount++; failedCount += test(timeManager, 9, 2018, 1, 15, 20, 35, 0, false);          // UTC: 8:35 PM Local: 3:35 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 5, 0, 58, 0, false);            // UTC: 12:58 AM Local: 7:58 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 15, 21, 24, 0, false);          // UTC: 9:24 PM Local: 4:24 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 12, 22, 10, 0, false);          // UTC: 10:10 PM Local: 5:10 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 13, 17, 58, 0, false);          // UTC: 5:58 PM Local: 12:58 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 9, 20, 43, 0, false);           // UTC: 8:43 PM Local: 3:43 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 10, 18, 44, 0, false);          // UTC: 6:44 PM Local: 1:44 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 8, 18, 24, 0, false);           // UTC: 6:24 PM Local: 1:24 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 2, 9, 7, 0, false);             // UTC: 9:07 AM Local: 4:07 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 14, 15, 8, 0, false);           // UTC: 3:08 PM Local: 10:08 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 22, 11, 32, 0, false);          // UTC: 11:32 AM Local: 6:32 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 16, 22, 6, 0, false);           // UTC: 10:06 PM Local: 5:06 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 3, 8, 40, 0, false);            // UTC: 8:40 AM Local: 3:40 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 26, 4, 22, 0, false);           // UTC: 4:22 AM Local: 11:22 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 19, 12, 31, 0, false);          // UTC: 12:31 PM Local: 7:31 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 15, 19, 25, 0, false);          // UTC: 7:25 PM Local: 2:25 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 16, 16, 26, 0, false);          // UTC: 4:26 PM Local: 11:26 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 5, 0, 43, 0, false);            // UTC: 12:43 AM Local: 7:43 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 21, 6, 3, 0, false);            // UTC: 6:03 AM Local: 1:03 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 5, 2, 33, 0, false);            // UTC: 2:33 AM Local: 9:33 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 24, 0, 15, 0, false);           // UTC: 12:15 AM Local: 7:15 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 8, 13, 28, 0, false);           // UTC: 1:28 PM Local: 8:28 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 17, 20, 46, 0, false);          // UTC: 8:46 PM Local: 3:46 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 24, 4, 30, 0, false);           // UTC: 4:30 AM Local: 11:30 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 1, 2, 9, 36, 0, false);            // UTC: 9:36 AM Local: 4:36 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 11, 13, 16, 0, false);          // UTC: 1:16 PM Local: 8:16 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 25, 12, 33, 0, false);          // UTC: 12:33 PM Local: 7:33 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 19, 21, 55, 0, false);          // UTC: 9:55 PM Local: 4:55 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 19, 14, 27, 0, false);          // UTC: 2:27 PM Local: 9:27 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 22, 18, 41, 0, false);          // UTC: 6:41 PM Local: 1:41 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 2, 21, 16, 0, false);           // UTC: 9:16 PM Local: 4:16 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 4, 2, 8, 0, false);             // UTC: 2:08 AM Local: 9:08 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 4, 9, 55, 0, false);            // UTC: 9:55 AM Local: 4:55 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 2, 20, 58, 0, false);           // UTC: 8:58 PM Local: 3:58 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 18, 15, 31, 0, false);          // UTC: 3:31 PM Local: 10:31 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 26, 2, 36, 0, false);           // UTC: 2:36 AM Local: 9:36 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 4, 9, 41, 0, false);            // UTC: 9:41 AM Local: 4:41 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 22, 6, 34, 0, false);           // UTC: 6:34 AM Local: 1:34 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 1, 3, 5, 0, false);             // UTC: 3:05 AM Local: 10:05 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 9, 12, 56, 0, false);           // UTC: 12:56 PM Local: 7:56 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 1, 18, 4, 0, false);            // UTC: 6:04 PM Local: 1:04 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 3, 19, 16, 0, false);           // UTC: 7:16 PM Local: 2:16 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 7, 21, 17, 0, false);           // UTC: 9:17 PM Local: 4:17 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 13, 5, 8, 0, false);            // UTC: 5:08 AM Local: 12:08 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 10, 19, 36, 0, false);          // UTC: 7:36 PM Local: 2:36 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 16, 0, 15, 0, false);           // UTC: 12:15 AM Local: 7:15 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 11, 17, 30, 0, false);          // UTC: 5:30 PM Local: 12:30 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 24, 15, 23, 0, false);          // UTC: 3:23 PM Local: 10:23 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 1, 5, 37, 0, false);            // UTC: 5:37 AM Local: 12:37 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 2, 19, 2, 56, 0, false);           // UTC: 2:56 AM Local: 9:56 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 2, 18, 50, 0, false);           // UTC: 6:50 PM Local: 1:50 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 27, 0, 4, 0, true);             // UTC: 12:04 AM Local: 8:04 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 25, 13, 49, 0, true);           // UTC: 1:49 PM Local: 9:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 8, 15, 11, 0, false);           // UTC: 3:11 PM Local: 10:11 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 9, 14, 8, 0, false);            // UTC: 2:08 PM Local: 9:08 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 15, 10, 25, 0, true);           // UTC: 10:25 AM Local: 6:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 26, 9, 7, 0, true);             // UTC: 9:07 AM Local: 5:07 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 23, 21, 46, 0, true);           // UTC: 9:46 PM Local: 5:46 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 12, 3, 8, 0, true);             // UTC: 3:08 AM Local: 11:08 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 19, 1, 34, 0, true);            // UTC: 1:34 AM Local: 9:34 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 18, 12, 48, 0, true);           // UTC: 12:48 PM Local: 8:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 10, 9, 27, 0, false);           // UTC: 9:27 AM Local: 4:27 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 8, 8, 48, 0, false);            // UTC: 8:48 AM Local: 3:48 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 15, 15, 27, 0, true);           // UTC: 3:27 PM Local: 11:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 12, 3, 5, 0, true);             // UTC: 3:05 AM Local: 11:05 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 10, 12, 2, 0, false);           // UTC: 12:02 PM Local: 7:02 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 8, 10, 47, 0, false);           // UTC: 10:47 AM Local: 5:47 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 6, 16, 40, 0, false);           // UTC: 4:40 PM Local: 11:40 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 23, 5, 51, 0, true);            // UTC: 5:51 AM Local: 1:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 2, 12, 51, 0, false);           // UTC: 12:51 PM Local: 7:51 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 26, 5, 29, 0, true);            // UTC: 5:29 AM Local: 1:29 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 8, 14, 7, 0, false);            // UTC: 2:07 PM Local: 9:07 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 11, 22, 12, 0, true);           // UTC: 10:12 PM Local: 6:12 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 19, 6, 5, 0, true);             // UTC: 6:05 AM Local: 2:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 3, 17, 9, 44, 0, true);            // UTC: 9:44 AM Local: 5:44 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 18, 9, 47, 0, true);            // UTC: 9:47 AM Local: 5:47 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 20, 2, 37, 0, true);            // UTC: 2:37 AM Local: 10:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 3, 9, 36, 0, true);             // UTC: 9:36 AM Local: 5:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 21, 9, 48, 0, true);            // UTC: 9:48 AM Local: 5:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 4, 11, 12, 0, true);            // UTC: 11:12 AM Local: 7:12 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 16, 5, 47, 0, true);            // UTC: 5:47 AM Local: 1:47 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 26, 13, 24, 0, true);           // UTC: 1:24 PM Local: 9:24 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 26, 3, 29, 0, true);            // UTC: 3:29 AM Local: 11:29 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 26, 21, 32, 0, true);           // UTC: 9:32 PM Local: 5:32 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 23, 13, 10, 0, true);           // UTC: 1:10 PM Local: 9:10 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 20, 14, 18, 0, true);           // UTC: 2:18 PM Local: 10:18 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 26, 3, 47, 0, true);            // UTC: 3:47 AM Local: 11:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 2, 8, 27, 0, true);             // UTC: 8:27 AM Local: 4:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 7, 19, 49, 0, true);            // UTC: 7:49 PM Local: 3:49 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 24, 11, 12, 0, true);           // UTC: 11:12 AM Local: 7:12 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 9, 5, 27, 0, true);             // UTC: 5:27 AM Local: 1:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 1, 2, 2, 0, true);              // UTC: 2:02 AM Local: 10:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 8, 14, 49, 0, true);            // UTC: 2:49 PM Local: 10:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 10, 16, 15, 0, true);           // UTC: 4:15 PM Local: 12:15 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 9, 17, 8, 0, true);             // UTC: 5:08 PM Local: 1:08 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 3, 6, 49, 0, true);             // UTC: 6:49 AM Local: 2:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 12, 1, 47, 0, true);            // UTC: 1:47 AM Local: 9:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 14, 4, 20, 0, true);            // UTC: 4:20 AM Local: 12:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 11, 12, 50, 0, true);           // UTC: 12:50 PM Local: 8:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 4, 10, 16, 43, 0, true);           // UTC: 4:43 PM Local: 12:43 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 16, 1, 38, 0, true);            // UTC: 1:38 AM Local: 9:38 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 8, 14, 41, 0, true);            // UTC: 2:41 PM Local: 10:41 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 2, 18, 28, 0, true);            // UTC: 6:28 PM Local: 2:28 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 4, 9, 57, 0, true);             // UTC: 9:57 AM Local: 5:57 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 13, 13, 28, 0, true);           // UTC: 1:28 PM Local: 9:28 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 15, 17, 36, 0, true);           // UTC: 5:36 PM Local: 1:36 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 9, 3, 34, 0, true);             // UTC: 3:34 AM Local: 11:34 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 1, 10, 24, 0, true);            // UTC: 10:24 AM Local: 6:24 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 11, 18, 3, 0, true);            // UTC: 6:03 PM Local: 2:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 4, 13, 33, 0, true);            // UTC: 1:33 PM Local: 9:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 6, 21, 53, 0, true);            // UTC: 9:53 PM Local: 5:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 3, 17, 36, 0, true);            // UTC: 5:36 PM Local: 1:36 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 17, 0, 5, 0, true);             // UTC: 12:05 AM Local: 8:05 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 12, 0, 27, 0, true);            // UTC: 12:27 AM Local: 8:27 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 10, 6, 38, 0, true);            // UTC: 6:38 AM Local: 2:38 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 23, 0, 35, 0, true);            // UTC: 12:35 AM Local: 8:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 24, 19, 44, 0, true);           // UTC: 7:44 PM Local: 3:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 7, 0, 33, 0, true);             // UTC: 12:33 AM Local: 8:33 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 5, 13, 37, 0, true);            // UTC: 1:37 PM Local: 9:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 7, 20, 49, 0, true);            // UTC: 8:49 PM Local: 4:49 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 18, 21, 12, 0, true);           // UTC: 9:12 PM Local: 5:12 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 25, 21, 27, 0, true);           // UTC: 9:27 PM Local: 5:27 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 2, 8, 48, 0, true);             // UTC: 8:48 AM Local: 4:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 24, 21, 44, 0, true);           // UTC: 9:44 PM Local: 5:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 5, 15, 20, 8, 0, true);            // UTC: 8:08 PM Local: 4:08 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 4, 15, 8, 0, true);             // UTC: 3:08 PM Local: 11:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 21, 12, 46, 0, true);           // UTC: 12:46 PM Local: 8:46 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 13, 6, 44, 0, true);            // UTC: 6:44 AM Local: 2:44 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 23, 21, 54, 0, true);           // UTC: 9:54 PM Local: 5:54 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 10, 21, 11, 0, true);           // UTC: 9:11 PM Local: 5:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 27, 8, 6, 0, true);             // UTC: 8:06 AM Local: 4:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 7, 18, 4, 0, true);             // UTC: 6:04 PM Local: 2:04 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 7, 10, 20, 0, true);            // UTC: 10:20 AM Local: 6:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 6, 17, 37, 0, true);            // UTC: 5:37 PM Local: 1:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 22, 0, 54, 0, true);            // UTC: 12:54 AM Local: 8:54 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 27, 16, 8, 0, true);            // UTC: 4:08 PM Local: 12:08 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 12, 0, 53, 0, true);            // UTC: 12:53 AM Local: 8:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 14, 10, 20, 0, true);           // UTC: 10:20 AM Local: 6:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 2, 3, 39, 0, true);             // UTC: 3:39 AM Local: 11:39 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 13, 2, 0, 0, true);             // UTC: 2:00 AM Local: 10:00 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 15, 16, 25, 0, true);           // UTC: 4:25 PM Local: 12:25 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 17, 20, 33, 0, true);           // UTC: 8:33 PM Local: 4:33 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 18, 6, 4, 0, true);             // UTC: 6:04 AM Local: 2:04 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 2, 19, 12, 0, true);            // UTC: 7:12 PM Local: 3:12 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 22, 13, 46, 0, true);           // UTC: 1:46 PM Local: 9:46 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 4, 15, 15, 0, true);            // UTC: 3:15 PM Local: 11:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 23, 18, 13, 0, true);           // UTC: 6:13 PM Local: 2:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 22, 20, 53, 0, true);           // UTC: 8:53 PM Local: 4:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 8, 11, 53, 0, true);            // UTC: 11:53 AM Local: 7:53 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 6, 21, 4, 37, 0, true);            // UTC: 4:37 AM Local: 12:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 11, 18, 21, 0, true);           // UTC: 6:21 PM Local: 2:21 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 10, 15, 2, 0, true);            // UTC: 3:02 PM Local: 11:02 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 6, 3, 8, 0, true);              // UTC: 3:08 AM Local: 11:08 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 10, 7, 26, 0, true);            // UTC: 7:26 AM Local: 3:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 2, 8, 9, 0, true);              // UTC: 8:09 AM Local: 4:09 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 20, 15, 52, 0, true);           // UTC: 3:52 PM Local: 11:52 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 16, 21, 28, 0, true);           // UTC: 9:28 PM Local: 5:28 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 12, 14, 15, 0, true);           // UTC: 2:15 PM Local: 10:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 21, 17, 48, 0, true);           // UTC: 5:48 PM Local: 1:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 15, 7, 22, 0, true);            // UTC: 7:22 AM Local: 3:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 18, 20, 3, 0, true);            // UTC: 8:03 PM Local: 4:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 12, 15, 3, 0, true);            // UTC: 3:03 PM Local: 11:03 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 23, 10, 53, 0, true);           // UTC: 10:53 AM Local: 6:53 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 20, 21, 31, 0, true);           // UTC: 9:31 PM Local: 5:31 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 4, 10, 28, 0, true);            // UTC: 10:28 AM Local: 6:28 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 21, 16, 31, 0, true);           // UTC: 4:31 PM Local: 12:31 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 20, 13, 47, 0, true);           // UTC: 1:47 PM Local: 9:47 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 1, 4, 16, 0, true);             // UTC: 4:16 AM Local: 12:16 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 5, 22, 10, 0, true);            // UTC: 10:10 PM Local: 6:10 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 3, 13, 53, 0, true);            // UTC: 1:53 PM Local: 9:53 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 6, 15, 48, 0, true);            // UTC: 3:48 PM Local: 11:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 21, 16, 27, 0, true);           // UTC: 4:27 PM Local: 12:27 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 11, 14, 41, 0, true);           // UTC: 2:41 PM Local: 10:41 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 3, 19, 13, 0, true);            // UTC: 7:13 PM Local: 3:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 7, 27, 18, 58, 0, true);           // UTC: 6:58 PM Local: 2:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 26, 6, 8, 0, true);             // UTC: 6:08 AM Local: 2:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 22, 22, 2, 0, true);            // UTC: 10:02 PM Local: 6:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 9, 18, 44, 0, true);            // UTC: 6:44 PM Local: 2:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 16, 14, 39, 0, true);           // UTC: 2:39 PM Local: 10:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 22, 6, 40, 0, true);            // UTC: 6:40 AM Local: 2:40 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 25, 17, 52, 0, true);           // UTC: 5:52 PM Local: 1:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 27, 11, 15, 0, true);           // UTC: 11:15 AM Local: 7:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 19, 8, 45, 0, true);            // UTC: 8:45 AM Local: 4:45 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 1, 8, 5, 0, true);              // UTC: 8:05 AM Local: 4:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 23, 14, 42, 0, true);           // UTC: 2:42 PM Local: 10:42 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 16, 0, 22, 0, true);            // UTC: 12:22 AM Local: 8:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 8, 4, 40, 0, true);             // UTC: 4:40 AM Local: 12:40 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 1, 7, 33, 0, true);             // UTC: 7:33 AM Local: 3:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 24, 21, 52, 0, true);           // UTC: 9:52 PM Local: 5:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 3, 4, 2, 0, true);              // UTC: 4:02 AM Local: 12:02 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 22, 13, 19, 0, true);           // UTC: 1:19 PM Local: 9:19 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 1, 4, 5, 0, true);              // UTC: 4:05 AM Local: 12:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 9, 22, 18, 0, true);            // UTC: 10:18 PM Local: 6:18 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 20, 5, 54, 0, true);            // UTC: 5:54 AM Local: 1:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 10, 17, 35, 0, true);           // UTC: 5:35 PM Local: 1:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 26, 10, 8, 0, true);            // UTC: 10:08 AM Local: 6:08 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 1, 22, 37, 0, true);            // UTC: 10:37 PM Local: 6:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 8, 11, 5, 0, true);             // UTC: 11:05 AM Local: 7:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 1, 19, 26, 0, true);            // UTC: 7:26 PM Local: 3:26 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 8, 9, 2, 35, 0, true);             // UTC: 2:35 AM Local: 10:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 10, 14, 10, 0, true);           // UTC: 2:10 PM Local: 10:10 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 20, 5, 46, 0, true);            // UTC: 5:46 AM Local: 1:46 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 21, 18, 25, 0, true);           // UTC: 6:25 PM Local: 2:25 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 17, 5, 1, 0, true);             // UTC: 5:01 AM Local: 1:01 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 2, 12, 55, 0, true);            // UTC: 12:55 PM Local: 8:55 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 21, 15, 32, 0, true);           // UTC: 3:32 PM Local: 11:32 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 27, 21, 25, 0, true);           // UTC: 9:25 PM Local: 5:25 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 20, 1, 11, 0, true);            // UTC: 1:11 AM Local: 9:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 12, 11, 5, 0, true);            // UTC: 11:05 AM Local: 7:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 7, 0, 20, 0, true);             // UTC: 12:20 AM Local: 8:20 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 18, 0, 51, 0, true);            // UTC: 12:51 AM Local: 8:51 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 20, 8, 37, 0, true);            // UTC: 8:37 AM Local: 4:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 21, 14, 30, 0, true);           // UTC: 2:30 PM Local: 10:30 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 22, 4, 39, 0, true);            // UTC: 4:39 AM Local: 12:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 20, 9, 43, 0, true);            // UTC: 9:43 AM Local: 5:43 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 17, 4, 56, 0, true);            // UTC: 4:56 AM Local: 12:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 5, 5, 12, 0, true);             // UTC: 5:12 AM Local: 1:12 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 25, 8, 11, 0, true);            // UTC: 8:11 AM Local: 4:11 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 5, 14, 33, 0, true);            // UTC: 2:33 PM Local: 10:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 27, 7, 43, 0, true);            // UTC: 7:43 AM Local: 3:43 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 20, 11, 47, 0, true);           // UTC: 11:47 AM Local: 7:47 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 3, 22, 14, 0, true);            // UTC: 10:14 PM Local: 6:14 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 5, 8, 11, 0, true);             // UTC: 8:11 AM Local: 4:11 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 9, 0, 1, 0, true);              // UTC: 12:01 AM Local: 8:01 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 9, 1, 3, 43, 0, true);             // UTC: 3:43 AM Local: 11:43 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 21, 0, 37, 0, true);           // UTC: 12:37 AM Local: 8:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 13, 18, 17, 0, true);          // UTC: 6:17 PM Local: 2:17 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 4, 2, 44, 0, true);            // UTC: 2:44 AM Local: 10:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 4, 17, 38, 0, true);           // UTC: 5:38 PM Local: 1:38 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 18, 12, 43, 0, true);          // UTC: 12:43 PM Local: 8:43 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 2, 17, 19, 0, true);           // UTC: 5:19 PM Local: 1:19 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 22, 2, 39, 0, true);           // UTC: 2:39 AM Local: 10:39 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 24, 14, 26, 0, true);          // UTC: 2:26 PM Local: 10:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 14, 9, 50, 0, true);           // UTC: 9:50 AM Local: 5:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 21, 19, 13, 0, true);          // UTC: 7:13 PM Local: 3:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 5, 19, 11, 0, true);           // UTC: 7:11 PM Local: 3:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 13, 8, 36, 0, true);           // UTC: 8:36 AM Local: 4:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 26, 12, 29, 0, true);          // UTC: 12:29 PM Local: 8:29 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 12, 13, 25, 0, true);          // UTC: 1:25 PM Local: 9:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 2, 21, 12, 0, true);           // UTC: 9:12 PM Local: 5:12 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 17, 11, 47, 0, true);          // UTC: 11:47 AM Local: 7:47 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 13, 5, 15, 0, true);           // UTC: 5:15 AM Local: 1:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 19, 5, 3, 0, true);            // UTC: 5:03 AM Local: 1:03 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 2, 21, 22, 0, true);           // UTC: 9:22 PM Local: 5:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 6, 22, 22, 0, true);           // UTC: 10:22 PM Local: 6:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 12, 8, 13, 0, true);           // UTC: 8:13 AM Local: 4:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 15, 22, 53, 0, true);          // UTC: 10:53 PM Local: 6:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 13, 4, 10, 0, true);           // UTC: 4:10 AM Local: 12:10 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 3, 2, 12, 0, true);            // UTC: 2:12 AM Local: 10:12 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 10, 23, 8, 31, 0, true);           // UTC: 8:31 AM Local: 4:31 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 7, 18, 41, 0, false);          // UTC: 6:41 PM Local: 1:41 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 7, 20, 55, 0, false);          // UTC: 8:55 PM Local: 3:55 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 2, 6, 36, 0, true);            // UTC: 6:36 AM Local: 2:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 27, 11, 36, 0, false);         // UTC: 11:36 AM Local: 6:36 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 4, 9, 27, 0, false);           // UTC: 9:27 AM Local: 4:27 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 7, 17, 34, 0, false);          // UTC: 5:34 PM Local: 12:34 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 3, 22, 11, 0, true);           // UTC: 10:11 PM Local: 6:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 6, 11, 57, 0, false);          // UTC: 11:57 AM Local: 6:57 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 9, 3, 17, 0, false);           // UTC: 3:17 AM Local: 10:17 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 18, 8, 6, 0, false);           // UTC: 8:06 AM Local: 3:06 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 2, 19, 52, 0, true);           // UTC: 7:52 PM Local: 3:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 15, 18, 6, 0, false);          // UTC: 6:06 PM Local: 1:06 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 19, 21, 5, 0, false);          // UTC: 9:05 PM Local: 4:05 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 13, 9, 4, 0, false);           // UTC: 9:04 AM Local: 4:04 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 17, 12, 28, 0, false);         // UTC: 12:28 PM Local: 7:28 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 8, 7, 46, 0, false);           // UTC: 7:46 AM Local: 2:46 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 20, 19, 22, 0, false);         // UTC: 7:22 PM Local: 2:22 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 17, 16, 20, 0, false);         // UTC: 4:20 PM Local: 11:20 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 10, 1, 17, 0, false);          // UTC: 1:17 AM Local: 8:17 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 20, 21, 42, 0, false);         // UTC: 9:42 PM Local: 4:42 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 18, 9, 56, 0, false);          // UTC: 9:56 AM Local: 4:56 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 14, 21, 36, 0, false);         // UTC: 9:36 PM Local: 4:36 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 20, 14, 35, 0, false);         // UTC: 2:35 PM Local: 9:35 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 10, 13, 46, 0, false);         // UTC: 1:46 PM Local: 8:46 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 11, 14, 14, 35, 0, false);         // UTC: 2:35 PM Local: 9:35 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 4, 13, 57, 0, false);          // UTC: 1:57 PM Local: 8:57 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 14, 0, 49, 0, false);          // UTC: 12:49 AM Local: 7:49 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 14, 21, 28, 0, false);         // UTC: 9:28 PM Local: 4:28 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 20, 9, 8, 0, false);           // UTC: 9:08 AM Local: 4:08 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 15, 4, 43, 0, false);          // UTC: 4:43 AM Local: 11:43 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 22, 22, 0, 0, false);          // UTC: 10:00 PM Local: 5:00 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 10, 18, 57, 0, false);         // UTC: 6:57 PM Local: 1:57 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 4, 2, 37, 0, false);           // UTC: 2:37 AM Local: 9:37 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 24, 13, 41, 0, false);         // UTC: 1:41 PM Local: 8:41 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 5, 8, 17, 0, false);           // UTC: 8:17 AM Local: 3:17 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 16, 2, 4, 0, false);           // UTC: 2:04 AM Local: 9:04 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 21, 5, 28, 0, false);          // UTC: 5:28 AM Local: 12:28 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 9, 4, 54, 0, false);           // UTC: 4:54 AM Local: 11:54 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 24, 2, 29, 0, false);          // UTC: 2:29 AM Local: 9:29 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 13, 18, 28, 0, false);         // UTC: 6:28 PM Local: 1:28 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 13, 3, 25, 0, false);          // UTC: 3:25 AM Local: 10:25 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 24, 12, 35, 0, false);         // UTC: 12:35 PM Local: 7:35 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 22, 3, 48, 0, false);          // UTC: 3:48 AM Local: 10:48 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 17, 22, 28, 0, false);         // UTC: 10:28 PM Local: 5:28 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 10, 14, 25, 0, false);         // UTC: 2:25 PM Local: 9:25 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 4, 7, 33, 0, false);           // UTC: 7:33 AM Local: 2:33 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 5, 3, 17, 0, false);           // UTC: 3:17 AM Local: 10:17 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 2, 18, 56, 0, false);          // UTC: 6:56 PM Local: 1:56 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 8, 11, 43, 0, false);          // UTC: 11:43 AM Local: 6:43 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2018, 12, 3, 10, 41, 0, false);          // UTC: 10:41 AM Local: 5:41 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 14, 15, 17, 0, false);          // UTC: 3:17 PM Local: 10:17 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 4, 8, 24, 0, false);            // UTC: 8:24 AM Local: 3:24 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 8, 7, 48, 0, false);            // UTC: 7:48 AM Local: 2:48 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 19, 18, 58, 0, false);          // UTC: 6:58 PM Local: 1:58 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 7, 2, 13, 0, false);            // UTC: 2:13 AM Local: 9:13 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 27, 22, 33, 0, false);          // UTC: 10:33 PM Local: 5:33 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 14, 17, 46, 0, false);          // UTC: 5:46 PM Local: 12:46 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 26, 6, 38, 0, false);           // UTC: 6:38 AM Local: 1:38 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 6, 9, 22, 0, false);            // UTC: 9:22 AM Local: 4:22 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 13, 13, 3, 0, false);           // UTC: 1:03 PM Local: 8:03 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 24, 15, 38, 0, false);          // UTC: 3:38 PM Local: 10:38 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 4, 3, 19, 0, false);            // UTC: 3:19 AM Local: 10:19 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 5, 4, 14, 0, false);            // UTC: 4:14 AM Local: 11:14 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 1, 19, 0, 0, false);            // UTC: 7:00 PM Local: 2:00 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 21, 11, 19, 0, false);          // UTC: 11:19 AM Local: 6:19 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 9, 18, 39, 0, false);           // UTC: 6:39 PM Local: 1:39 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 20, 6, 29, 0, false);           // UTC: 6:29 AM Local: 1:29 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 5, 13, 42, 0, false);           // UTC: 1:42 PM Local: 8:42 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 25, 12, 22, 0, false);          // UTC: 12:22 PM Local: 7:22 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 18, 21, 57, 0, false);          // UTC: 9:57 PM Local: 4:57 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 1, 18, 42, 0, false);           // UTC: 6:42 PM Local: 1:42 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 21, 19, 6, 0, false);           // UTC: 7:06 PM Local: 2:06 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 10, 3, 58, 0, false);           // UTC: 3:58 AM Local: 10:58 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 25, 18, 46, 0, false);          // UTC: 6:46 PM Local: 1:46 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 1, 9, 11, 53, 0, false);           // UTC: 11:53 AM Local: 6:53 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 22, 4, 46, 0, false);           // UTC: 4:46 AM Local: 11:46 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 9, 20, 36, 0, false);           // UTC: 8:36 PM Local: 3:36 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 20, 17, 19, 0, false);          // UTC: 5:19 PM Local: 12:19 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 16, 15, 6, 0, false);           // UTC: 3:06 PM Local: 10:06 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 26, 4, 34, 0, false);           // UTC: 4:34 AM Local: 11:34 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 26, 12, 14, 0, false);          // UTC: 12:14 PM Local: 7:14 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 8, 22, 2, 0, false);            // UTC: 10:02 PM Local: 5:02 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 8, 22, 39, 0, false);           // UTC: 10:39 PM Local: 5:39 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 6, 22, 38, 0, false);           // UTC: 10:38 PM Local: 5:38 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 19, 18, 26, 0, false);          // UTC: 6:26 PM Local: 1:26 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 20, 19, 5, 0, false);           // UTC: 7:05 PM Local: 2:05 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 23, 3, 21, 0, false);           // UTC: 3:21 AM Local: 10:21 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 16, 7, 4, 0, false);            // UTC: 7:04 AM Local: 2:04 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 10, 7, 4, 0, false);            // UTC: 7:04 AM Local: 2:04 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 11, 4, 7, 0, false);            // UTC: 4:07 AM Local: 11:07 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 27, 9, 55, 0, false);           // UTC: 9:55 AM Local: 4:55 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 11, 21, 16, 0, false);          // UTC: 9:16 PM Local: 4:16 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 15, 0, 29, 0, false);           // UTC: 12:29 AM Local: 7:29 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 24, 11, 11, 0, false);          // UTC: 11:11 AM Local: 6:11 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 4, 2, 54, 0, false);            // UTC: 2:54 AM Local: 9:54 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 26, 0, 54, 0, false);           // UTC: 12:54 AM Local: 7:54 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 24, 19, 49, 0, false);          // UTC: 7:49 PM Local: 2:49 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 1, 2, 3, 0, false);             // UTC: 2:03 AM Local: 9:03 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 7, 8, 12, 0, false);            // UTC: 8:12 AM Local: 3:12 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 2, 5, 21, 39, 0, false);           // UTC: 9:39 PM Local: 4:39 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 27, 20, 45, 0, true);           // UTC: 8:45 PM Local: 4:45 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 15, 4, 32, 0, true);            // UTC: 4:32 AM Local: 12:32 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 20, 6, 50, 0, true);            // UTC: 6:50 AM Local: 2:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 5, 3, 47, 0, false);            // UTC: 3:47 AM Local: 10:47 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 16, 22, 36, 0, true);           // UTC: 10:36 PM Local: 6:36 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 5, 10, 12, 0, false);           // UTC: 10:12 AM Local: 5:12 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 5, 9, 16, 0, false);            // UTC: 9:16 AM Local: 4:16 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 5, 12, 20, 0, false);           // UTC: 12:20 PM Local: 7:20 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 8, 22, 18, 0, false);           // UTC: 10:18 PM Local: 5:18 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 24, 3, 35, 0, true);            // UTC: 3:35 AM Local: 11:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 2, 8, 6, 0, false);             // UTC: 8:06 AM Local: 3:06 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 23, 20, 37, 0, true);           // UTC: 8:37 PM Local: 4:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 12, 13, 52, 0, true);           // UTC: 1:52 PM Local: 9:52 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 10, 5, 44, 0, false);           // UTC: 5:44 AM Local: 12:44 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 2, 16, 40, 0, false);           // UTC: 4:40 PM Local: 11:40 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 2, 9, 7, 0, false);             // UTC: 9:07 AM Local: 4:07 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 13, 1, 52, 0, true);            // UTC: 1:52 AM Local: 9:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 1, 0, 31, 0, false);            // UTC: 12:31 AM Local: 7:31 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 11, 18, 20, 0, true);           // UTC: 6:20 PM Local: 2:20 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 12, 5, 14, 0, true);            // UTC: 5:14 AM Local: 1:14 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 7, 19, 5, 0, false);            // UTC: 7:05 PM Local: 2:05 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 8, 2, 46, 0, false);            // UTC: 2:46 AM Local: 9:46 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 20, 17, 4, 0, true);            // UTC: 5:04 PM Local: 1:04 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 27, 16, 52, 0, true);           // UTC: 4:52 PM Local: 12:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 3, 9, 17, 9, 0, false);            // UTC: 5:09 PM Local: 12:09 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 15, 2, 48, 0, true);            // UTC: 2:48 AM Local: 10:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 18, 5, 31, 0, true);            // UTC: 5:31 AM Local: 1:31 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 5, 9, 6, 0, true);              // UTC: 9:06 AM Local: 5:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 20, 1, 20, 0, true);            // UTC: 1:20 AM Local: 9:20 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 16, 10, 5, 0, true);            // UTC: 10:05 AM Local: 6:05 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 8, 22, 19, 0, true);            // UTC: 10:19 PM Local: 6:19 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 18, 3, 23, 0, true);            // UTC: 3:23 AM Local: 11:23 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 18, 18, 35, 0, true);           // UTC: 6:35 PM Local: 2:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 25, 7, 40, 0, true);            // UTC: 7:40 AM Local: 3:40 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 2, 10, 19, 0, true);            // UTC: 10:19 AM Local: 6:19 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 1, 15, 14, 0, true);            // UTC: 3:14 PM Local: 11:14 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 11, 19, 42, 0, true);           // UTC: 7:42 PM Local: 3:42 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 15, 17, 58, 0, true);           // UTC: 5:58 PM Local: 1:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 19, 1, 24, 0, true);            // UTC: 1:24 AM Local: 9:24 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 27, 12, 1, 0, true);            // UTC: 12:01 PM Local: 8:01 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 13, 3, 17, 0, true);            // UTC: 3:17 AM Local: 11:17 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 27, 16, 43, 0, true);           // UTC: 4:43 PM Local: 12:43 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 15, 15, 38, 0, true);           // UTC: 3:38 PM Local: 11:38 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 21, 19, 18, 0, true);           // UTC: 7:18 PM Local: 3:18 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 6, 17, 54, 0, true);            // UTC: 5:54 PM Local: 1:54 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 24, 2, 57, 0, true);            // UTC: 2:57 AM Local: 10:57 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 21, 16, 22, 0, true);           // UTC: 4:22 PM Local: 12:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 3, 4, 35, 0, true);             // UTC: 4:35 AM Local: 12:35 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 11, 17, 13, 0, true);           // UTC: 5:13 PM Local: 1:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 4, 10, 21, 4, 0, true);            // UTC: 9:04 PM Local: 5:04 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 27, 15, 13, 0, true);           // UTC: 3:13 PM Local: 11:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 16, 10, 11, 0, true);           // UTC: 10:11 AM Local: 6:11 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 11, 1, 44, 0, true);            // UTC: 1:44 AM Local: 9:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 17, 10, 1, 0, true);            // UTC: 10:01 AM Local: 6:01 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 17, 14, 58, 0, true);           // UTC: 2:58 PM Local: 10:58 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 11, 7, 0, 0, true);             // UTC: 7:00 AM Local: 3:00 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 3, 19, 55, 0, true);            // UTC: 7:55 PM Local: 3:55 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 12, 5, 50, 0, true);            // UTC: 5:50 AM Local: 1:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 18, 8, 56, 0, true);            // UTC: 8:56 AM Local: 4:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 19, 13, 55, 0, true);           // UTC: 1:55 PM Local: 9:55 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 14, 4, 41, 0, true);            // UTC: 4:41 AM Local: 12:41 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 16, 17, 11, 0, true);           // UTC: 5:11 PM Local: 1:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 3, 14, 17, 0, true);            // UTC: 2:17 PM Local: 10:17 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 20, 10, 2, 0, true);            // UTC: 10:02 AM Local: 6:02 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 6, 3, 14, 0, true);             // UTC: 3:14 AM Local: 11:14 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 10, 11, 32, 0, true);           // UTC: 11:32 AM Local: 7:32 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 17, 22, 26, 0, true);           // UTC: 10:26 PM Local: 6:26 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 7, 5, 6, 0, true);              // UTC: 5:06 AM Local: 1:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 4, 12, 25, 0, true);            // UTC: 12:25 PM Local: 8:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 11, 21, 6, 0, true);            // UTC: 9:06 PM Local: 5:06 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 7, 16, 27, 0, true);            // UTC: 4:27 PM Local: 12:27 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 23, 2, 14, 0, true);            // UTC: 2:14 AM Local: 10:14 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 9, 0, 50, 0, true);             // UTC: 12:50 AM Local: 8:50 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 22, 7, 39, 0, true);            // UTC: 7:39 AM Local: 3:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 5, 20, 8, 21, 0, true);            // UTC: 8:21 AM Local: 4:21 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 25, 5, 3, 0, true);             // UTC: 5:03 AM Local: 1:03 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 17, 6, 50, 0, true);            // UTC: 6:50 AM Local: 2:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 12, 1, 37, 0, true);            // UTC: 1:37 AM Local: 9:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 14, 6, 56, 0, true);            // UTC: 6:56 AM Local: 2:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 17, 10, 13, 0, true);           // UTC: 10:13 AM Local: 6:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 21, 16, 41, 0, true);           // UTC: 4:41 PM Local: 12:41 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 6, 11, 45, 0, true);            // UTC: 11:45 AM Local: 7:45 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 16, 8, 4, 0, true);             // UTC: 8:04 AM Local: 4:04 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 27, 0, 28, 0, true);            // UTC: 12:28 AM Local: 8:28 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 19, 18, 37, 0, true);           // UTC: 6:37 PM Local: 2:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 22, 11, 52, 0, true);           // UTC: 11:52 AM Local: 7:52 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 21, 5, 17, 0, true);            // UTC: 5:17 AM Local: 1:17 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 11, 17, 37, 0, true);           // UTC: 5:37 PM Local: 1:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 7, 18, 37, 0, true);            // UTC: 6:37 PM Local: 2:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 23, 7, 48, 0, true);            // UTC: 7:48 AM Local: 3:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 9, 16, 34, 0, true);            // UTC: 4:34 PM Local: 12:34 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 17, 0, 37, 0, true);            // UTC: 12:37 AM Local: 8:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 27, 11, 50, 0, true);           // UTC: 11:50 AM Local: 7:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 17, 7, 50, 0, true);            // UTC: 7:50 AM Local: 3:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 27, 13, 16, 0, true);           // UTC: 1:16 PM Local: 9:16 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 11, 16, 14, 0, true);           // UTC: 4:14 PM Local: 12:14 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 27, 16, 44, 0, true);           // UTC: 4:44 PM Local: 12:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 2, 19, 12, 0, true);            // UTC: 7:12 PM Local: 3:12 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 26, 8, 54, 0, true);            // UTC: 8:54 AM Local: 4:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 6, 3, 21, 40, 0, true);            // UTC: 9:40 PM Local: 5:40 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 4, 16, 2, 0, true);             // UTC: 4:02 PM Local: 12:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 8, 16, 17, 0, true);            // UTC: 4:17 PM Local: 12:17 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 25, 1, 45, 0, true);            // UTC: 1:45 AM Local: 9:45 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 1, 18, 0, 0, true);             // UTC: 6:00 PM Local: 2:00 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 1, 3, 52, 0, true);             // UTC: 3:52 AM Local: 11:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 13, 9, 10, 0, true);            // UTC: 9:10 AM Local: 5:10 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 10, 20, 5, 0, true);            // UTC: 8:05 PM Local: 4:05 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 11, 19, 37, 0, true);           // UTC: 7:37 PM Local: 3:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 2, 5, 51, 0, true);             // UTC: 5:51 AM Local: 1:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 11, 15, 39, 0, true);           // UTC: 3:39 PM Local: 11:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 20, 20, 33, 0, true);           // UTC: 8:33 PM Local: 4:33 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 5, 11, 35, 0, true);            // UTC: 11:35 AM Local: 7:35 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 22, 16, 53, 0, true);           // UTC: 4:53 PM Local: 12:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 27, 10, 38, 0, true);           // UTC: 10:38 AM Local: 6:38 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 13, 22, 52, 0, true);           // UTC: 10:52 PM Local: 6:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 21, 0, 42, 0, true);            // UTC: 12:42 AM Local: 8:42 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 9, 10, 56, 0, true);            // UTC: 10:56 AM Local: 6:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 21, 16, 3, 0, true);            // UTC: 4:03 PM Local: 12:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 17, 17, 52, 0, true);           // UTC: 5:52 PM Local: 1:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 12, 4, 26, 0, true);            // UTC: 4:26 AM Local: 12:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 12, 12, 22, 0, true);           // UTC: 12:22 PM Local: 8:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 3, 7, 54, 0, true);             // UTC: 7:54 AM Local: 3:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 12, 19, 38, 0, true);           // UTC: 7:38 PM Local: 3:38 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 8, 15, 41, 0, true);            // UTC: 3:41 PM Local: 11:41 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 7, 8, 8, 23, 0, true);             // UTC: 8:23 AM Local: 4:23 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 12, 20, 50, 0, true);           // UTC: 8:50 PM Local: 4:50 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 21, 7, 13, 0, true);            // UTC: 7:13 AM Local: 3:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 5, 1, 12, 0, true);             // UTC: 1:12 AM Local: 9:12 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 19, 22, 9, 0, true);            // UTC: 10:09 PM Local: 6:09 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 14, 13, 43, 0, true);           // UTC: 1:43 PM Local: 9:43 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 20, 8, 30, 0, true);            // UTC: 8:30 AM Local: 4:30 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 13, 13, 56, 0, true);           // UTC: 1:56 PM Local: 9:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 8, 8, 39, 0, true);             // UTC: 8:39 AM Local: 4:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 26, 7, 9, 0, true);             // UTC: 7:09 AM Local: 3:09 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 2, 0, 48, 0, true);             // UTC: 12:48 AM Local: 8:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 8, 10, 21, 0, true);            // UTC: 10:21 AM Local: 6:21 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 18, 3, 49, 0, true);            // UTC: 3:49 AM Local: 11:49 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 1, 15, 52, 0, true);            // UTC: 3:52 PM Local: 11:52 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 7, 5, 26, 0, true);             // UTC: 5:26 AM Local: 1:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 5, 9, 20, 0, true);             // UTC: 9:20 AM Local: 5:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 21, 21, 15, 0, true);           // UTC: 9:15 PM Local: 5:15 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 25, 13, 15, 0, true);           // UTC: 1:15 PM Local: 9:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 6, 19, 46, 0, true);            // UTC: 7:46 PM Local: 3:46 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 13, 3, 31, 0, true);            // UTC: 3:31 AM Local: 11:31 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 6, 18, 58, 0, true);            // UTC: 6:58 PM Local: 2:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 2, 2, 2, 0, true);              // UTC: 2:02 AM Local: 10:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 11, 9, 28, 0, true);            // UTC: 9:28 AM Local: 5:28 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 22, 19, 25, 0, true);           // UTC: 7:25 PM Local: 3:25 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 25, 15, 43, 0, true);           // UTC: 3:43 PM Local: 11:43 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 8, 17, 4, 18, 0, true);            // UTC: 4:18 AM Local: 12:18 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 14, 2, 56, 0, true);            // UTC: 2:56 AM Local: 10:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 9, 4, 23, 0, true);             // UTC: 4:23 AM Local: 12:23 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 25, 3, 26, 0, true);            // UTC: 3:26 AM Local: 11:26 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 15, 1, 38, 0, true);            // UTC: 1:38 AM Local: 9:38 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 16, 4, 58, 0, true);            // UTC: 4:58 AM Local: 12:58 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 9, 19, 50, 0, true);            // UTC: 7:50 PM Local: 3:50 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 25, 4, 9, 0, true);             // UTC: 4:09 AM Local: 12:09 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 12, 17, 57, 0, true);           // UTC: 5:57 PM Local: 1:57 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 24, 22, 3, 0, true);            // UTC: 10:03 PM Local: 6:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 23, 0, 51, 0, true);            // UTC: 12:51 AM Local: 8:51 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 15, 12, 36, 0, true);           // UTC: 12:36 PM Local: 8:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 13, 21, 2, 0, true);            // UTC: 9:02 PM Local: 5:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 16, 19, 35, 0, true);           // UTC: 7:35 PM Local: 3:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 17, 3, 56, 0, true);            // UTC: 3:56 AM Local: 11:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 17, 19, 20, 0, true);           // UTC: 7:20 PM Local: 3:20 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 23, 5, 38, 0, true);            // UTC: 5:38 AM Local: 1:38 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 12, 13, 50, 0, true);           // UTC: 1:50 PM Local: 9:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 24, 16, 1, 0, true);            // UTC: 4:01 PM Local: 12:01 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 5, 2, 21, 0, true);             // UTC: 2:21 AM Local: 10:21 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 27, 10, 13, 0, true);           // UTC: 10:13 AM Local: 6:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 10, 1, 7, 0, true);             // UTC: 1:07 AM Local: 9:07 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 16, 0, 30, 0, true);            // UTC: 12:30 AM Local: 8:30 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 1, 2, 15, 0, true);             // UTC: 2:15 AM Local: 10:15 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 26, 16, 56, 0, true);           // UTC: 4:56 PM Local: 12:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 9, 7, 6, 1, 0, true);              // UTC: 6:01 AM Local: 2:01 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 6, 18, 52, 0, true);           // UTC: 6:52 PM Local: 2:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 17, 0, 43, 0, true);           // UTC: 12:43 AM Local: 8:43 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 11, 9, 24, 0, true);           // UTC: 9:24 AM Local: 5:24 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 1, 15, 49, 0, true);           // UTC: 3:49 PM Local: 11:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 16, 7, 50, 0, true);           // UTC: 7:50 AM Local: 3:50 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 19, 13, 23, 0, true);          // UTC: 1:23 PM Local: 9:23 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 10, 5, 6, 0, true);            // UTC: 5:06 AM Local: 1:06 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 23, 0, 49, 0, true);           // UTC: 12:49 AM Local: 8:49 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 23, 18, 7, 0, true);           // UTC: 6:07 PM Local: 2:07 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 11, 11, 51, 0, true);          // UTC: 11:51 AM Local: 7:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 25, 14, 25, 0, true);          // UTC: 2:25 PM Local: 10:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 1, 21, 16, 0, true);           // UTC: 9:16 PM Local: 5:16 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 13, 8, 26, 0, true);           // UTC: 8:26 AM Local: 4:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 14, 21, 37, 0, true);          // UTC: 9:37 PM Local: 5:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 19, 12, 21, 0, true);          // UTC: 12:21 PM Local: 8:21 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 19, 9, 44, 0, true);           // UTC: 9:44 AM Local: 5:44 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 11, 6, 7, 0, true);            // UTC: 6:07 AM Local: 2:07 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 16, 20, 2, 0, true);           // UTC: 8:02 PM Local: 4:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 25, 8, 46, 0, true);           // UTC: 8:46 AM Local: 4:46 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 2, 17, 11, 0, true);           // UTC: 5:11 PM Local: 1:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 17, 22, 54, 0, true);          // UTC: 10:54 PM Local: 6:54 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 15, 2, 2, 0, true);            // UTC: 2:02 AM Local: 10:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 11, 13, 22, 0, true);          // UTC: 1:22 PM Local: 9:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 16, 4, 13, 0, true);           // UTC: 4:13 AM Local: 12:13 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 10, 26, 20, 17, 0, true);          // UTC: 8:17 PM Local: 4:17 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 13, 3, 28, 0, false);          // UTC: 3:28 AM Local: 10:28 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 14, 3, 22, 0, false);          // UTC: 3:22 AM Local: 10:22 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 10, 0, 12, 0, false);          // UTC: 12:12 AM Local: 7:12 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 21, 7, 43, 0, false);          // UTC: 7:43 AM Local: 2:43 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 11, 1, 34, 0, false);          // UTC: 1:34 AM Local: 8:34 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 14, 9, 34, 0, false);          // UTC: 9:34 AM Local: 4:34 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 7, 20, 56, 0, false);          // UTC: 8:56 PM Local: 3:56 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 20, 3, 24, 0, false);          // UTC: 3:24 AM Local: 10:24 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 9, 6, 49, 0, false);           // UTC: 6:49 AM Local: 1:49 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 11, 18, 4, 0, false);          // UTC: 6:04 PM Local: 1:04 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 25, 14, 0, 0, false);          // UTC: 2:00 PM Local: 9:00 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 21, 10, 12, 0, false);         // UTC: 10:12 AM Local: 5:12 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 9, 13, 37, 0, false);          // UTC: 1:37 PM Local: 8:37 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 22, 5, 58, 0, false);          // UTC: 5:58 AM Local: 12:58 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 20, 18, 46, 0, false);         // UTC: 6:46 PM Local: 1:46 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 9, 22, 30, 0, false);          // UTC: 10:30 PM Local: 5:30 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 22, 1, 46, 0, false);          // UTC: 1:46 AM Local: 8:46 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 18, 15, 58, 0, false);         // UTC: 3:58 PM Local: 10:58 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 10, 17, 57, 0, false);         // UTC: 5:57 PM Local: 12:57 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 2, 3, 50, 0, true);            // UTC: 3:50 AM Local: 11:50 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 15, 22, 11, 0, false);         // UTC: 10:11 PM Local: 5:11 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 4, 19, 42, 0, false);          // UTC: 7:42 PM Local: 2:42 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 20, 15, 36, 0, false);         // UTC: 3:36 PM Local: 10:36 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 10, 4, 49, 0, false);          // UTC: 4:49 AM Local: 11:49 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 11, 26, 10, 38, 0, false);         // UTC: 10:38 AM Local: 5:38 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 27, 22, 21, 0, false);         // UTC: 10:21 PM Local: 5:21 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 17, 0, 17, 0, false);          // UTC: 12:17 AM Local: 7:17 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 9, 13, 42, 0, false);          // UTC: 1:42 PM Local: 8:42 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 8, 6, 54, 0, false);           // UTC: 6:54 AM Local: 1:54 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 1, 9, 42, 0, false);           // UTC: 9:42 AM Local: 4:42 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 7, 5, 24, 0, false);           // UTC: 5:24 AM Local: 12:24 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 21, 6, 14, 0, false);          // UTC: 6:14 AM Local: 1:14 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 22, 13, 56, 0, false);         // UTC: 1:56 PM Local: 8:56 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 3, 13, 20, 0, false);          // UTC: 1:20 PM Local: 8:20 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 25, 9, 52, 0, false);          // UTC: 9:52 AM Local: 4:52 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 26, 15, 14, 0, false);         // UTC: 3:14 PM Local: 10:14 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 10, 8, 44, 0, false);          // UTC: 8:44 AM Local: 3:44 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 17, 9, 8, 0, false);           // UTC: 9:08 AM Local: 4:08 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 16, 4, 24, 0, false);          // UTC: 4:24 AM Local: 11:24 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 13, 19, 33, 0, false);         // UTC: 7:33 PM Local: 2:33 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 22, 15, 15, 0, false);         // UTC: 3:15 PM Local: 10:15 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 25, 3, 56, 0, false);          // UTC: 3:56 AM Local: 10:56 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 12, 4, 10, 0, false);          // UTC: 4:10 AM Local: 11:10 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 11, 4, 23, 0, false);          // UTC: 4:23 AM Local: 11:23 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 11, 12, 24, 0, false);         // UTC: 12:24 PM Local: 7:24 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 26, 9, 9, 0, false);           // UTC: 9:09 AM Local: 4:09 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 23, 7, 34, 0, false);          // UTC: 7:34 AM Local: 2:34 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 19, 15, 1, 0, false);          // UTC: 3:01 PM Local: 10:01 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 26, 14, 47, 0, false);         // UTC: 2:47 PM Local: 9:47 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2019, 12, 8, 4, 3, 0, false);            // UTC: 4:03 AM Local: 11:03 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 23, 7, 42, 0, false);           // UTC: 7:42 AM Local: 2:42 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 11, 6, 53, 0, false);           // UTC: 6:53 AM Local: 1:53 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 3, 22, 17, 0, false);           // UTC: 10:17 PM Local: 5:17 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 26, 12, 28, 0, false);          // UTC: 12:28 PM Local: 7:28 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 2, 21, 11, 0, false);           // UTC: 9:11 PM Local: 4:11 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 10, 5, 51, 0, false);           // UTC: 5:51 AM Local: 12:51 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 20, 14, 46, 0, false);          // UTC: 2:46 PM Local: 9:46 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 7, 14, 32, 0, false);           // UTC: 2:32 PM Local: 9:32 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 27, 2, 58, 0, false);           // UTC: 2:58 AM Local: 9:58 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 7, 21, 30, 0, false);           // UTC: 9:30 PM Local: 4:30 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 5, 3, 58, 0, false);            // UTC: 3:58 AM Local: 10:58 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 4, 12, 50, 0, false);           // UTC: 12:50 PM Local: 7:50 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 19, 22, 15, 0, false);          // UTC: 10:15 PM Local: 5:15 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 14, 19, 25, 0, false);          // UTC: 7:25 PM Local: 2:25 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 24, 20, 45, 0, false);          // UTC: 8:45 PM Local: 3:45 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 3, 14, 45, 0, false);           // UTC: 2:45 PM Local: 9:45 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 23, 13, 23, 0, false);          // UTC: 1:23 PM Local: 8:23 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 26, 12, 33, 0, false);          // UTC: 12:33 PM Local: 7:33 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 8, 13, 40, 0, false);           // UTC: 1:40 PM Local: 8:40 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 5, 10, 11, 0, false);           // UTC: 10:11 AM Local: 5:11 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 25, 19, 3, 0, false);           // UTC: 7:03 PM Local: 2:03 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 21, 17, 22, 0, false);          // UTC: 5:22 PM Local: 12:22 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 14, 21, 21, 0, false);          // UTC: 9:21 PM Local: 4:21 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 9, 15, 13, 0, false);           // UTC: 3:13 PM Local: 10:13 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 1, 17, 4, 44, 0, false);           // UTC: 4:44 AM Local: 11:44 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 10, 8, 42, 0, false);           // UTC: 8:42 AM Local: 3:42 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 22, 19, 27, 0, false);          // UTC: 7:27 PM Local: 2:27 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 7, 9, 19, 0, false);            // UTC: 9:19 AM Local: 4:19 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 4, 5, 36, 0, false);            // UTC: 5:36 AM Local: 12:36 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 12, 19, 57, 0, false);          // UTC: 7:57 PM Local: 2:57 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 5, 11, 32, 0, false);           // UTC: 11:32 AM Local: 6:32 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 2, 13, 0, 0, false);            // UTC: 1:00 PM Local: 8:00 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 11, 2, 8, 0, false);            // UTC: 2:08 AM Local: 9:08 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 11, 14, 39, 0, false);          // UTC: 2:39 PM Local: 9:39 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 11, 11, 55, 0, false);          // UTC: 11:55 AM Local: 6:55 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 5, 6, 19, 0, false);            // UTC: 6:19 AM Local: 1:19 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 23, 21, 11, 0, false);          // UTC: 9:11 PM Local: 4:11 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 27, 8, 33, 0, false);           // UTC: 8:33 AM Local: 3:33 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 20, 15, 26, 0, false);          // UTC: 3:26 PM Local: 10:26 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 20, 15, 32, 0, false);          // UTC: 3:32 PM Local: 10:32 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 21, 1, 6, 0, false);            // UTC: 1:06 AM Local: 8:06 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 11, 3, 8, 0, false);            // UTC: 3:08 AM Local: 10:08 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 19, 13, 35, 0, false);          // UTC: 1:35 PM Local: 8:35 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 20, 22, 17, 0, false);          // UTC: 10:17 PM Local: 5:17 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 16, 8, 14, 0, false);           // UTC: 8:14 AM Local: 3:14 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 22, 19, 52, 0, false);          // UTC: 7:52 PM Local: 2:52 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 11, 21, 54, 0, false);          // UTC: 9:54 PM Local: 4:54 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 8, 13, 53, 0, false);           // UTC: 1:53 PM Local: 8:53 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 21, 4, 7, 0, false);            // UTC: 4:07 AM Local: 11:07 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 2, 27, 7, 53, 0, false);           // UTC: 7:53 AM Local: 2:53 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 16, 15, 25, 0, true);           // UTC: 3:25 PM Local: 11:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 16, 14, 32, 0, true);           // UTC: 2:32 PM Local: 10:32 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 16, 22, 20, 0, true);           // UTC: 10:20 PM Local: 6:20 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 22, 11, 43, 0, true);           // UTC: 11:43 AM Local: 7:43 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 20, 2, 56, 0, true);            // UTC: 2:56 AM Local: 10:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 25, 8, 58, 0, true);            // UTC: 8:58 AM Local: 4:58 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 9, 21, 50, 0, true);            // UTC: 9:50 PM Local: 5:50 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 16, 7, 41, 0, true);            // UTC: 7:41 AM Local: 3:41 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 17, 11, 27, 0, true);           // UTC: 11:27 AM Local: 7:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 6, 14, 55, 0, false);           // UTC: 2:55 PM Local: 9:55 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 1, 15, 14, 0, false);           // UTC: 3:14 PM Local: 10:14 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 19, 4, 18, 0, true);            // UTC: 4:18 AM Local: 12:18 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 24, 22, 45, 0, true);           // UTC: 10:45 PM Local: 6:45 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 19, 5, 49, 0, true);            // UTC: 5:49 AM Local: 1:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 15, 13, 26, 0, true);           // UTC: 1:26 PM Local: 9:26 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 6, 12, 30, 0, false);           // UTC: 12:30 PM Local: 7:30 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 26, 19, 48, 0, true);           // UTC: 7:48 PM Local: 3:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 4, 15, 23, 0, false);           // UTC: 3:23 PM Local: 10:23 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 2, 22, 19, 0, false);           // UTC: 10:19 PM Local: 5:19 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 20, 22, 7, 0, true);            // UTC: 10:07 PM Local: 6:07 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 3, 8, 22, 0, false);            // UTC: 8:22 AM Local: 3:22 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 11, 17, 48, 0, true);           // UTC: 5:48 PM Local: 1:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 14, 0, 53, 0, true);            // UTC: 12:53 AM Local: 8:53 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 18, 0, 22, 0, true);            // UTC: 12:22 AM Local: 8:22 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 3, 7, 14, 41, 0, false);           // UTC: 2:41 PM Local: 9:41 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 1, 0, 42, 0, true);             // UTC: 12:42 AM Local: 8:42 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 7, 9, 56, 0, true);             // UTC: 9:56 AM Local: 5:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 26, 6, 44, 0, true);            // UTC: 6:44 AM Local: 2:44 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 4, 20, 0, 0, true);             // UTC: 8:00 PM Local: 4:00 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 23, 14, 10, 0, true);           // UTC: 2:10 PM Local: 10:10 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 27, 2, 1, 0, true);             // UTC: 2:01 AM Local: 10:01 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 18, 14, 51, 0, true);           // UTC: 2:51 PM Local: 10:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 13, 3, 48, 0, true);            // UTC: 3:48 AM Local: 11:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 18, 16, 29, 0, true);           // UTC: 4:29 PM Local: 12:29 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 17, 6, 48, 0, true);            // UTC: 6:48 AM Local: 2:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 12, 21, 2, 0, true);            // UTC: 9:02 PM Local: 5:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 19, 0, 57, 0, true);            // UTC: 12:57 AM Local: 8:57 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 17, 11, 32, 0, true);           // UTC: 11:32 AM Local: 7:32 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 5, 2, 5, 0, true);              // UTC: 2:05 AM Local: 10:05 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 17, 6, 53, 0, true);            // UTC: 6:53 AM Local: 2:53 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 22, 15, 24, 0, true);           // UTC: 3:24 PM Local: 11:24 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 20, 14, 54, 0, true);           // UTC: 2:54 PM Local: 10:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 10, 13, 58, 0, true);           // UTC: 1:58 PM Local: 9:58 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 23, 12, 51, 0, true);           // UTC: 12:51 PM Local: 8:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 25, 14, 42, 0, true);           // UTC: 2:42 PM Local: 10:42 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 13, 8, 57, 0, true);            // UTC: 8:57 AM Local: 4:57 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 26, 15, 56, 0, true);           // UTC: 3:56 PM Local: 11:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 27, 3, 34, 0, true);            // UTC: 3:34 AM Local: 11:34 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 6, 9, 37, 0, true);             // UTC: 9:37 AM Local: 5:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 4, 13, 11, 29, 0, true);           // UTC: 11:29 AM Local: 7:29 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 21, 19, 50, 0, true);           // UTC: 7:50 PM Local: 3:50 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 25, 19, 2, 0, true);            // UTC: 7:02 PM Local: 3:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 3, 20, 38, 0, true);            // UTC: 8:38 PM Local: 4:38 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 25, 1, 20, 0, true);            // UTC: 1:20 AM Local: 9:20 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 2, 19, 28, 0, true);            // UTC: 7:28 PM Local: 3:28 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 4, 15, 51, 0, true);            // UTC: 3:51 PM Local: 11:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 23, 16, 44, 0, true);           // UTC: 4:44 PM Local: 12:44 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 4, 15, 36, 0, true);            // UTC: 3:36 PM Local: 11:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 26, 19, 30, 0, true);           // UTC: 7:30 PM Local: 3:30 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 23, 12, 14, 0, true);           // UTC: 12:14 PM Local: 8:14 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 8, 20, 5, 0, true);             // UTC: 8:05 PM Local: 4:05 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 14, 1, 41, 0, true);            // UTC: 1:41 AM Local: 9:41 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 1, 22, 46, 0, true);            // UTC: 10:46 PM Local: 6:46 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 19, 8, 28, 0, true);            // UTC: 8:28 AM Local: 4:28 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 9, 0, 35, 0, true);             // UTC: 12:35 AM Local: 8:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 17, 20, 16, 0, true);           // UTC: 8:16 PM Local: 4:16 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 3, 1, 41, 0, true);             // UTC: 1:41 AM Local: 9:41 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 21, 14, 44, 0, true);           // UTC: 2:44 PM Local: 10:44 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 21, 14, 9, 0, true);            // UTC: 2:09 PM Local: 10:09 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 7, 22, 58, 0, true);            // UTC: 10:58 PM Local: 6:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 15, 6, 20, 0, true);            // UTC: 6:20 AM Local: 2:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 11, 14, 10, 0, true);           // UTC: 2:10 PM Local: 10:10 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 7, 13, 47, 0, true);            // UTC: 1:47 PM Local: 9:47 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 22, 2, 41, 0, true);            // UTC: 2:41 AM Local: 10:41 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 5, 3, 3, 21, 0, true);             // UTC: 3:21 AM Local: 11:21 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 8, 18, 39, 0, true);            // UTC: 6:39 PM Local: 2:39 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 1, 7, 55, 0, true);             // UTC: 7:55 AM Local: 3:55 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 7, 16, 25, 0, true);            // UTC: 4:25 PM Local: 12:25 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 15, 11, 14, 0, true);           // UTC: 11:14 AM Local: 7:14 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 9, 16, 24, 0, true);            // UTC: 4:24 PM Local: 12:24 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 15, 17, 1, 0, true);            // UTC: 5:01 PM Local: 1:01 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 22, 2, 5, 0, true);             // UTC: 2:05 AM Local: 10:05 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 4, 21, 23, 0, true);            // UTC: 9:23 PM Local: 5:23 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 12, 8, 19, 0, true);            // UTC: 8:19 AM Local: 4:19 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 14, 7, 57, 0, true);            // UTC: 7:57 AM Local: 3:57 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 1, 15, 28, 0, true);            // UTC: 3:28 PM Local: 11:28 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 11, 11, 49, 0, true);           // UTC: 11:49 AM Local: 7:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 14, 5, 37, 0, true);            // UTC: 5:37 AM Local: 1:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 2, 7, 31, 0, true);             // UTC: 7:31 AM Local: 3:31 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 25, 19, 6, 0, true);            // UTC: 7:06 PM Local: 3:06 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 26, 21, 49, 0, true);           // UTC: 9:49 PM Local: 5:49 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 11, 5, 20, 0, true);            // UTC: 5:20 AM Local: 1:20 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 19, 6, 1, 0, true);             // UTC: 6:01 AM Local: 2:01 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 8, 2, 52, 0, true);             // UTC: 2:52 AM Local: 10:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 8, 13, 57, 0, true);            // UTC: 1:57 PM Local: 9:57 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 17, 17, 24, 0, true);           // UTC: 5:24 PM Local: 1:24 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 13, 12, 48, 0, true);           // UTC: 12:48 PM Local: 8:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 21, 21, 14, 0, true);           // UTC: 9:14 PM Local: 5:14 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 16, 1, 30, 0, true);            // UTC: 1:30 AM Local: 9:30 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 6, 11, 17, 48, 0, true);           // UTC: 5:48 PM Local: 1:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 15, 5, 3, 0, true);             // UTC: 5:03 AM Local: 1:03 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 8, 11, 25, 0, true);            // UTC: 11:25 AM Local: 7:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 14, 2, 4, 0, true);             // UTC: 2:04 AM Local: 10:04 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 18, 7, 23, 0, true);            // UTC: 7:23 AM Local: 3:23 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 13, 2, 21, 0, true);            // UTC: 2:21 AM Local: 10:21 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 26, 5, 39, 0, true);            // UTC: 5:39 AM Local: 1:39 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 19, 10, 33, 0, true);           // UTC: 10:33 AM Local: 6:33 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 4, 10, 19, 0, true);            // UTC: 10:19 AM Local: 6:19 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 8, 3, 57, 0, true);             // UTC: 3:57 AM Local: 11:57 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 17, 18, 10, 0, true);           // UTC: 6:10 PM Local: 2:10 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 23, 6, 31, 0, true);            // UTC: 6:31 AM Local: 2:31 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 6, 16, 52, 0, true);            // UTC: 4:52 PM Local: 12:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 23, 22, 4, 0, true);            // UTC: 10:04 PM Local: 6:04 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 15, 2, 38, 0, true);            // UTC: 2:38 AM Local: 10:38 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 9, 18, 11, 0, true);            // UTC: 6:11 PM Local: 2:11 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 12, 6, 49, 0, true);            // UTC: 6:49 AM Local: 2:49 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 24, 13, 48, 0, true);           // UTC: 1:48 PM Local: 9:48 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 24, 16, 18, 0, true);           // UTC: 4:18 PM Local: 12:18 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 7, 9, 46, 0, true);             // UTC: 9:46 AM Local: 5:46 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 21, 22, 19, 0, true);           // UTC: 10:19 PM Local: 6:19 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 13, 20, 16, 0, true);           // UTC: 8:16 PM Local: 4:16 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 25, 18, 2, 0, true);            // UTC: 6:02 PM Local: 2:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 24, 5, 21, 0, true);            // UTC: 5:21 AM Local: 1:21 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 14, 3, 13, 0, true);            // UTC: 3:13 AM Local: 11:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 7, 16, 3, 19, 0, true);            // UTC: 3:19 AM Local: 11:19 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 25, 18, 37, 0, true);           // UTC: 6:37 PM Local: 2:37 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 4, 19, 50, 0, true);            // UTC: 7:50 PM Local: 3:50 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 4, 16, 12, 0, true);            // UTC: 4:12 PM Local: 12:12 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 10, 21, 35, 0, true);           // UTC: 9:35 PM Local: 5:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 6, 22, 18, 0, true);            // UTC: 10:18 PM Local: 6:18 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 3, 1, 0, 0, true);              // UTC: 1:00 AM Local: 9:00 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 20, 1, 12, 0, true);            // UTC: 1:12 AM Local: 9:12 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 11, 9, 58, 0, true);            // UTC: 9:58 AM Local: 5:58 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 5, 12, 3, 0, true);             // UTC: 12:03 PM Local: 8:03 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 13, 9, 27, 0, true);            // UTC: 9:27 AM Local: 5:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 17, 6, 32, 0, true);            // UTC: 6:32 AM Local: 2:32 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 27, 7, 36, 0, true);            // UTC: 7:36 AM Local: 3:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 5, 13, 7, 0, true);             // UTC: 1:07 PM Local: 9:07 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 13, 7, 10, 0, true);            // UTC: 7:10 AM Local: 3:10 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 2, 12, 51, 0, true);            // UTC: 12:51 PM Local: 8:51 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 12, 15, 17, 0, true);           // UTC: 3:17 PM Local: 11:17 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 2, 9, 4, 0, true);              // UTC: 9:04 AM Local: 5:04 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 6, 19, 4, 0, true);             // UTC: 7:04 PM Local: 3:04 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 4, 12, 21, 0, true);            // UTC: 12:21 PM Local: 8:21 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 18, 22, 18, 0, true);           // UTC: 10:18 PM Local: 6:18 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 22, 14, 18, 0, true);           // UTC: 2:18 PM Local: 10:18 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 21, 17, 40, 0, true);           // UTC: 5:40 PM Local: 1:40 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 2, 5, 36, 0, true);             // UTC: 5:36 AM Local: 1:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 19, 21, 27, 0, true);           // UTC: 9:27 PM Local: 5:27 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 8, 25, 6, 42, 0, true);            // UTC: 6:42 AM Local: 2:42 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 1, 7, 52, 0, true);             // UTC: 7:52 AM Local: 3:52 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 4, 16, 52, 0, true);            // UTC: 4:52 PM Local: 12:52 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 21, 9, 0, 0, true);             // UTC: 9:00 AM Local: 5:00 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 11, 8, 24, 0, true);            // UTC: 8:24 AM Local: 4:24 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 13, 19, 47, 0, true);           // UTC: 7:47 PM Local: 3:47 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 7, 11, 36, 0, true);            // UTC: 11:36 AM Local: 7:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 22, 15, 40, 0, true);           // UTC: 3:40 PM Local: 11:40 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 24, 7, 45, 0, true);            // UTC: 7:45 AM Local: 3:45 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 6, 9, 24, 0, true);             // UTC: 9:24 AM Local: 5:24 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 19, 8, 27, 0, true);            // UTC: 8:27 AM Local: 4:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 17, 7, 34, 0, true);            // UTC: 7:34 AM Local: 3:34 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 10, 1, 13, 0, true);            // UTC: 1:13 AM Local: 9:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 13, 12, 15, 0, true);           // UTC: 12:15 PM Local: 8:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 12, 0, 13, 0, true);            // UTC: 12:13 AM Local: 8:13 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 9, 8, 22, 0, true);             // UTC: 8:22 AM Local: 4:22 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 8, 13, 23, 0, true);            // UTC: 1:23 PM Local: 9:23 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 23, 9, 24, 0, true);            // UTC: 9:24 AM Local: 5:24 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 23, 1, 35, 0, true);            // UTC: 1:35 AM Local: 9:35 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 2, 3, 0, 0, true);              // UTC: 3:00 AM Local: 11:00 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 4, 21, 18, 0, true);            // UTC: 9:18 PM Local: 5:18 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 13, 2, 2, 0, true);             // UTC: 2:02 AM Local: 10:02 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 15, 18, 3, 0, true);            // UTC: 6:03 PM Local: 2:03 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 23, 2, 45, 0, true);            // UTC: 2:45 AM Local: 10:45 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 16, 17, 58, 0, true);           // UTC: 5:58 PM Local: 1:58 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 9, 10, 8, 36, 0, true);            // UTC: 8:36 AM Local: 4:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 13, 12, 56, 0, true);          // UTC: 12:56 PM Local: 8:56 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 11, 21, 48, 0, true);          // UTC: 9:48 PM Local: 5:48 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 1, 19, 56, 0, true);           // UTC: 7:56 PM Local: 3:56 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 2, 17, 14, 0, true);           // UTC: 5:14 PM Local: 1:14 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 27, 7, 54, 0, true);           // UTC: 7:54 AM Local: 3:54 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 7, 8, 34, 0, true);            // UTC: 8:34 AM Local: 4:34 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 26, 21, 55, 0, true);          // UTC: 9:55 PM Local: 5:55 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 6, 17, 33, 0, true);           // UTC: 5:33 PM Local: 1:33 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 9, 9, 27, 0, true);            // UTC: 9:27 AM Local: 5:27 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 17, 5, 37, 0, true);           // UTC: 5:37 AM Local: 1:37 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 12, 11, 41, 0, true);          // UTC: 11:41 AM Local: 7:41 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 27, 13, 35, 0, true);          // UTC: 1:35 PM Local: 9:35 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 2, 16, 0, 0, true);            // UTC: 4:00 PM Local: 12:00 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 14, 10, 15, 0, true);          // UTC: 10:15 AM Local: 6:15 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 3, 11, 1, 0, true);            // UTC: 11:01 AM Local: 7:01 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 23, 19, 46, 0, true);          // UTC: 7:46 PM Local: 3:46 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 23, 7, 25, 0, true);           // UTC: 7:25 AM Local: 3:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 12, 9, 25, 0, true);           // UTC: 9:25 AM Local: 5:25 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 19, 5, 46, 0, true);           // UTC: 5:46 AM Local: 1:46 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 11, 1, 29, 0, true);           // UTC: 1:29 AM Local: 9:29 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 10, 9, 34, 0, true);           // UTC: 9:34 AM Local: 5:34 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 9, 14, 16, 0, true);           // UTC: 2:16 PM Local: 10:16 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 15, 0, 43, 0, true);           // UTC: 12:43 AM Local: 8:43 PM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 9, 4, 36, 0, true);            // UTC: 4:36 AM Local: 12:36 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 10, 16, 10, 29, 0, true);          // UTC: 10:29 AM Local: 6:29 AM Offset: -04:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 19, 2, 17, 0, false);          // UTC: 2:17 AM Local: 9:17 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 15, 11, 35, 0, false);         // UTC: 11:35 AM Local: 6:35 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 19, 17, 53, 0, false);         // UTC: 5:53 PM Local: 12:53 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 6, 22, 4, 0, false);           // UTC: 10:04 PM Local: 5:04 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 8, 6, 19, 0, false);           // UTC: 6:19 AM Local: 1:19 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 22, 14, 39, 0, false);         // UTC: 2:39 PM Local: 9:39 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 14, 2, 3, 0, false);           // UTC: 2:03 AM Local: 9:03 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 19, 17, 48, 0, false);         // UTC: 5:48 PM Local: 12:48 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 21, 6, 47, 0, false);          // UTC: 6:47 AM Local: 1:47 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 2, 12, 9, 0, false);           // UTC: 12:09 PM Local: 7:09 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 22, 19, 55, 0, false);         // UTC: 7:55 PM Local: 2:55 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 26, 22, 8, 0, false);          // UTC: 10:08 PM Local: 5:08 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 14, 19, 33, 0, false);         // UTC: 7:33 PM Local: 2:33 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 25, 15, 37, 0, false);         // UTC: 3:37 PM Local: 10:37 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 19, 2, 38, 0, false);          // UTC: 2:38 AM Local: 9:38 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 6, 6, 43, 0, false);           // UTC: 6:43 AM Local: 1:43 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 11, 11, 31, 0, false);         // UTC: 11:31 AM Local: 6:31 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 26, 1, 19, 0, false);          // UTC: 1:19 AM Local: 8:19 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 13, 0, 19, 0, false);          // UTC: 12:19 AM Local: 7:19 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 13, 18, 13, 0, false);         // UTC: 6:13 PM Local: 1:13 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 22, 13, 14, 0, false);         // UTC: 1:14 PM Local: 8:14 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 21, 9, 9, 0, false);           // UTC: 9:09 AM Local: 4:09 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 4, 7, 17, 0, false);           // UTC: 7:17 AM Local: 2:17 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 5, 7, 46, 0, false);           // UTC: 7:46 AM Local: 2:46 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 11, 3, 14, 25, 0, false);          // UTC: 2:25 PM Local: 9:25 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 12, 22, 40, 0, false);         // UTC: 10:40 PM Local: 5:40 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 5, 12, 0, 0, false);           // UTC: 12:00 PM Local: 7:00 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 2, 15, 1, 0, false);           // UTC: 3:01 PM Local: 10:01 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 17, 19, 45, 0, false);         // UTC: 7:45 PM Local: 2:45 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 17, 11, 57, 0, false);         // UTC: 11:57 AM Local: 6:57 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 23, 0, 4, 0, false);           // UTC: 12:04 AM Local: 7:04 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 10, 2, 5, 0, false);           // UTC: 2:05 AM Local: 9:05 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 11, 21, 40, 0, false);         // UTC: 9:40 PM Local: 4:40 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 14, 1, 55, 0, false);          // UTC: 1:55 AM Local: 8:55 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 12, 5, 11, 0, false);          // UTC: 5:11 AM Local: 12:11 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 21, 19, 26, 0, false);         // UTC: 7:26 PM Local: 2:26 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 25, 0, 1, 0, false);           // UTC: 12:01 AM Local: 7:01 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 18, 6, 14, 0, false);          // UTC: 6:14 AM Local: 1:14 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 7, 16, 56, 0, false);          // UTC: 4:56 PM Local: 11:56 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 6, 2, 32, 0, false);           // UTC: 2:32 AM Local: 9:32 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 11, 12, 49, 0, false);         // UTC: 12:49 PM Local: 7:49 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 9, 8, 16, 0, false);           // UTC: 8:16 AM Local: 3:16 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 20, 17, 29, 0, false);         // UTC: 5:29 PM Local: 12:29 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 10, 0, 3, 0, false);           // UTC: 12:03 AM Local: 7:03 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 27, 15, 28, 0, false);         // UTC: 3:28 PM Local: 10:28 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 2, 14, 25, 0, false);          // UTC: 2:25 PM Local: 9:25 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 23, 20, 0, 0, false);          // UTC: 8:00 PM Local: 3:00 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 9, 15, 27, 0, false);          // UTC: 3:27 PM Local: 10:27 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 26, 3, 44, 0, false);          // UTC: 3:44 AM Local: 10:44 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 9, 2020, 12, 23, 2, 23, 0, false);          // UTC: 2:23 AM Local: 9:23 PM Offset: -05:00:00

	Serial.println(); Serial.print(failedCount); Serial.print(" of "); Serial.print(testCount); Serial.println(" test(s) failed.");
}
#endif
