#ifndef TEST_TIMEZONEID_8_H
#define TEST_TIMEZONEID_8_H

#include "TimeManager.h"
#include "TestHelper.h"

void run_TimeZoneId_8_Tests(const TimeManager& timeManager)
{
	uint16_t testCount = 0;
	uint16_t failedCount = 0;

	testCount++; failedCount += test(timeManager, 8, 2018, 1, 22, 20, 16, 0, false);          // UTC: 8:16 PM Local: 2:16 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 6, 18, 34, 0, false);           // UTC: 6:34 PM Local: 12:34 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 14, 15, 45, 0, false);          // UTC: 3:45 PM Local: 9:45 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 11, 2, 37, 0, false);           // UTC: 2:37 AM Local: 8:37 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 24, 10, 32, 0, false);          // UTC: 10:32 AM Local: 4:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 3, 18, 39, 0, false);           // UTC: 6:39 PM Local: 12:39 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 25, 19, 24, 0, false);          // UTC: 7:24 PM Local: 1:24 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 13, 2, 27, 0, false);           // UTC: 2:27 AM Local: 8:27 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 2, 21, 26, 0, false);           // UTC: 9:26 PM Local: 3:26 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 12, 4, 48, 0, false);           // UTC: 4:48 AM Local: 10:48 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 20, 6, 9, 0, false);            // UTC: 6:09 AM Local: 12:09 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 22, 13, 39, 0, false);          // UTC: 1:39 PM Local: 7:39 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 27, 2, 32, 0, false);           // UTC: 2:32 AM Local: 8:32 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 11, 11, 51, 0, false);          // UTC: 11:51 AM Local: 5:51 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 19, 0, 13, 0, false);           // UTC: 12:13 AM Local: 6:13 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 2, 12, 38, 0, false);           // UTC: 12:38 PM Local: 6:38 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 2, 10, 20, 0, false);           // UTC: 10:20 AM Local: 4:20 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 18, 10, 54, 0, false);          // UTC: 10:54 AM Local: 4:54 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 3, 7, 45, 0, false);            // UTC: 7:45 AM Local: 1:45 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 22, 3, 51, 0, false);           // UTC: 3:51 AM Local: 9:51 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 4, 2, 29, 0, false);            // UTC: 2:29 AM Local: 8:29 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 26, 14, 50, 0, false);          // UTC: 2:50 PM Local: 8:50 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 14, 1, 51, 0, false);           // UTC: 1:51 AM Local: 7:51 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 24, 1, 42, 0, false);           // UTC: 1:42 AM Local: 7:42 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 1, 3, 12, 19, 0, false);           // UTC: 12:19 PM Local: 6:19 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 15, 18, 4, 0, false);           // UTC: 6:04 PM Local: 12:04 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 7, 0, 25, 0, false);            // UTC: 12:25 AM Local: 6:25 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 22, 8, 43, 0, false);           // UTC: 8:43 AM Local: 2:43 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 13, 1, 48, 0, false);           // UTC: 1:48 AM Local: 7:48 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 7, 16, 14, 0, false);           // UTC: 4:14 PM Local: 10:14 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 24, 4, 55, 0, false);           // UTC: 4:55 AM Local: 10:55 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 19, 5, 24, 0, false);           // UTC: 5:24 AM Local: 11:24 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 11, 16, 23, 0, false);          // UTC: 4:23 PM Local: 10:23 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 11, 13, 27, 0, false);          // UTC: 1:27 PM Local: 7:27 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 22, 3, 21, 0, false);           // UTC: 3:21 AM Local: 9:21 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 18, 12, 53, 0, false);          // UTC: 12:53 PM Local: 6:53 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 16, 12, 31, 0, false);          // UTC: 12:31 PM Local: 6:31 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 20, 13, 8, 0, false);           // UTC: 1:08 PM Local: 7:08 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 12, 7, 42, 0, false);           // UTC: 7:42 AM Local: 1:42 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 21, 11, 33, 0, false);          // UTC: 11:33 AM Local: 5:33 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 2, 5, 19, 0, false);            // UTC: 5:19 AM Local: 11:19 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 17, 22, 53, 0, false);          // UTC: 10:53 PM Local: 4:53 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 21, 9, 17, 0, false);           // UTC: 9:17 AM Local: 3:17 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 25, 3, 3, 0, false);            // UTC: 3:03 AM Local: 9:03 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 19, 19, 25, 0, false);          // UTC: 7:25 PM Local: 1:25 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 27, 0, 12, 0, false);           // UTC: 12:12 AM Local: 6:12 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 11, 19, 32, 0, false);          // UTC: 7:32 PM Local: 1:32 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 25, 14, 10, 0, false);          // UTC: 2:10 PM Local: 8:10 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 20, 3, 35, 0, false);           // UTC: 3:35 AM Local: 9:35 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 2, 22, 5, 53, 0, false);           // UTC: 5:53 AM Local: 11:53 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 19, 14, 14, 0, true);           // UTC: 2:14 PM Local: 9:14 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 23, 7, 18, 0, true);            // UTC: 7:18 AM Local: 2:18 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 4, 3, 10, 0, false);            // UTC: 3:10 AM Local: 9:10 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 13, 19, 6, 0, true);            // UTC: 7:06 PM Local: 2:06 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 17, 15, 24, 0, true);           // UTC: 3:24 PM Local: 10:24 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 13, 0, 42, 0, true);            // UTC: 12:42 AM Local: 7:42 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 19, 11, 19, 0, true);           // UTC: 11:19 AM Local: 6:19 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 14, 8, 38, 0, true);            // UTC: 8:38 AM Local: 3:38 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 1, 2, 35, 0, false);            // UTC: 2:35 AM Local: 8:35 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 5, 20, 48, 0, false);           // UTC: 8:48 PM Local: 2:48 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 9, 22, 10, 0, false);           // UTC: 10:10 PM Local: 4:10 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 11, 5, 30, 0, false);           // UTC: 5:30 AM Local: 11:30 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 23, 19, 30, 0, true);           // UTC: 7:30 PM Local: 2:30 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 4, 19, 49, 0, false);           // UTC: 7:49 PM Local: 1:49 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 2, 21, 57, 0, false);           // UTC: 9:57 PM Local: 3:57 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 13, 7, 58, 0, true);            // UTC: 7:58 AM Local: 2:58 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 21, 5, 8, 0, true);             // UTC: 5:08 AM Local: 12:08 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 24, 2, 45, 0, true);            // UTC: 2:45 AM Local: 9:45 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 16, 4, 14, 0, true);            // UTC: 4:14 AM Local: 11:14 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 16, 18, 12, 0, true);           // UTC: 6:12 PM Local: 1:12 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 20, 22, 15, 0, true);           // UTC: 10:15 PM Local: 5:15 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 10, 3, 53, 0, false);           // UTC: 3:53 AM Local: 9:53 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 26, 4, 25, 0, true);            // UTC: 4:25 AM Local: 11:25 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 25, 14, 11, 0, true);           // UTC: 2:11 PM Local: 9:11 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 3, 6, 13, 37, 0, false);           // UTC: 1:37 PM Local: 7:37 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 14, 10, 27, 0, true);           // UTC: 10:27 AM Local: 5:27 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 19, 12, 48, 0, true);           // UTC: 12:48 PM Local: 7:48 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 17, 9, 38, 0, true);            // UTC: 9:38 AM Local: 4:38 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 19, 9, 50, 0, true);            // UTC: 9:50 AM Local: 4:50 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 12, 19, 1, 0, true);            // UTC: 7:01 PM Local: 2:01 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 8, 5, 1, 0, true);              // UTC: 5:01 AM Local: 12:01 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 9, 9, 51, 0, true);             // UTC: 9:51 AM Local: 4:51 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 16, 15, 44, 0, true);           // UTC: 3:44 PM Local: 10:44 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 2, 11, 6, 0, true);             // UTC: 11:06 AM Local: 6:06 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 15, 20, 35, 0, true);           // UTC: 8:35 PM Local: 3:35 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 26, 15, 31, 0, true);           // UTC: 3:31 PM Local: 10:31 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 4, 1, 43, 0, true);             // UTC: 1:43 AM Local: 8:43 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 22, 20, 15, 0, true);           // UTC: 8:15 PM Local: 3:15 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 11, 1, 33, 0, true);            // UTC: 1:33 AM Local: 8:33 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 17, 15, 43, 0, true);           // UTC: 3:43 PM Local: 10:43 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 2, 11, 21, 0, true);            // UTC: 11:21 AM Local: 6:21 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 12, 14, 24, 0, true);           // UTC: 2:24 PM Local: 9:24 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 5, 20, 9, 0, true);             // UTC: 8:09 PM Local: 3:09 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 21, 21, 45, 0, true);           // UTC: 9:45 PM Local: 4:45 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 20, 14, 2, 0, true);            // UTC: 2:02 PM Local: 9:02 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 19, 1, 31, 0, true);            // UTC: 1:31 AM Local: 8:31 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 2, 16, 44, 0, true);            // UTC: 4:44 PM Local: 11:44 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 9, 6, 45, 0, true);             // UTC: 6:45 AM Local: 1:45 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 9, 11, 19, 0, true);            // UTC: 11:19 AM Local: 6:19 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 4, 21, 21, 19, 0, true);           // UTC: 9:19 PM Local: 4:19 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 8, 21, 1, 0, true);             // UTC: 9:01 PM Local: 4:01 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 1, 0, 0, 0, true);              // UTC: 12:00 AM Local: 7:00 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 21, 3, 14, 0, true);            // UTC: 3:14 AM Local: 10:14 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 6, 17, 44, 0, true);            // UTC: 5:44 PM Local: 12:44 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 10, 7, 7, 0, true);             // UTC: 7:07 AM Local: 2:07 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 26, 1, 16, 0, true);            // UTC: 1:16 AM Local: 8:16 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 7, 15, 0, 0, true);             // UTC: 3:00 PM Local: 10:00 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 2, 13, 54, 0, true);            // UTC: 1:54 PM Local: 8:54 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 27, 16, 13, 0, true);           // UTC: 4:13 PM Local: 11:13 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 17, 2, 8, 0, true);             // UTC: 2:08 AM Local: 9:08 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 3, 9, 57, 0, true);             // UTC: 9:57 AM Local: 4:57 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 23, 11, 58, 0, true);           // UTC: 11:58 AM Local: 6:58 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 20, 16, 34, 0, true);           // UTC: 4:34 PM Local: 11:34 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 1, 21, 55, 0, true);            // UTC: 9:55 PM Local: 4:55 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 8, 19, 56, 0, true);            // UTC: 7:56 PM Local: 2:56 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 1, 22, 55, 0, true);            // UTC: 10:55 PM Local: 5:55 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 18, 7, 24, 0, true);            // UTC: 7:24 AM Local: 2:24 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 2, 12, 13, 0, true);            // UTC: 12:13 PM Local: 7:13 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 9, 5, 21, 0, true);             // UTC: 5:21 AM Local: 12:21 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 3, 0, 18, 0, true);             // UTC: 12:18 AM Local: 7:18 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 22, 3, 1, 0, true);             // UTC: 3:01 AM Local: 10:01 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 3, 2, 21, 0, true);             // UTC: 2:21 AM Local: 9:21 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 21, 11, 51, 0, true);           // UTC: 11:51 AM Local: 6:51 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 4, 5, 21, 0, true);             // UTC: 5:21 AM Local: 12:21 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 5, 19, 4, 43, 0, true);            // UTC: 4:43 AM Local: 11:43 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 2, 17, 42, 0, true);            // UTC: 5:42 PM Local: 12:42 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 27, 22, 43, 0, true);           // UTC: 10:43 PM Local: 5:43 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 8, 22, 45, 0, true);            // UTC: 10:45 PM Local: 5:45 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 20, 0, 52, 0, true);            // UTC: 12:52 AM Local: 7:52 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 21, 11, 13, 0, true);           // UTC: 11:13 AM Local: 6:13 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 17, 14, 39, 0, true);           // UTC: 2:39 PM Local: 9:39 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 8, 5, 46, 0, true);             // UTC: 5:46 AM Local: 12:46 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 25, 4, 44, 0, true);            // UTC: 4:44 AM Local: 11:44 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 16, 5, 26, 0, true);            // UTC: 5:26 AM Local: 12:26 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 3, 11, 7, 0, true);             // UTC: 11:07 AM Local: 6:07 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 2, 8, 19, 0, true);             // UTC: 8:19 AM Local: 3:19 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 14, 5, 28, 0, true);            // UTC: 5:28 AM Local: 12:28 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 18, 3, 3, 0, true);             // UTC: 3:03 AM Local: 10:03 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 16, 11, 11, 0, true);           // UTC: 11:11 AM Local: 6:11 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 8, 8, 5, 0, true);              // UTC: 8:05 AM Local: 3:05 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 14, 0, 0, 0, true);             // UTC: 12:00 AM Local: 7:00 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 18, 11, 34, 0, true);           // UTC: 11:34 AM Local: 6:34 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 19, 9, 55, 0, true);            // UTC: 9:55 AM Local: 4:55 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 26, 3, 34, 0, true);            // UTC: 3:34 AM Local: 10:34 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 27, 8, 44, 0, true);            // UTC: 8:44 AM Local: 3:44 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 8, 4, 27, 0, true);             // UTC: 4:27 AM Local: 11:27 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 18, 15, 38, 0, true);           // UTC: 3:38 PM Local: 10:38 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 15, 6, 15, 0, true);            // UTC: 6:15 AM Local: 1:15 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 20, 22, 29, 0, true);           // UTC: 10:29 PM Local: 5:29 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 6, 17, 15, 44, 0, true);           // UTC: 3:44 PM Local: 10:44 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 17, 15, 47, 0, true);           // UTC: 3:47 PM Local: 10:47 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 18, 2, 11, 0, true);            // UTC: 2:11 AM Local: 9:11 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 13, 10, 58, 0, true);           // UTC: 10:58 AM Local: 5:58 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 15, 8, 55, 0, true);            // UTC: 8:55 AM Local: 3:55 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 11, 12, 6, 0, true);            // UTC: 12:06 PM Local: 7:06 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 25, 15, 43, 0, true);           // UTC: 3:43 PM Local: 10:43 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 9, 6, 17, 0, true);             // UTC: 6:17 AM Local: 1:17 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 20, 14, 41, 0, true);           // UTC: 2:41 PM Local: 9:41 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 12, 21, 44, 0, true);           // UTC: 9:44 PM Local: 4:44 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 20, 20, 31, 0, true);           // UTC: 8:31 PM Local: 3:31 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 3, 1, 43, 0, true);             // UTC: 1:43 AM Local: 8:43 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 6, 7, 29, 0, true);             // UTC: 7:29 AM Local: 2:29 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 21, 7, 16, 0, true);            // UTC: 7:16 AM Local: 2:16 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 15, 19, 45, 0, true);           // UTC: 7:45 PM Local: 2:45 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 13, 2, 18, 0, true);            // UTC: 2:18 AM Local: 9:18 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 20, 3, 43, 0, true);            // UTC: 3:43 AM Local: 10:43 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 5, 19, 17, 0, true);            // UTC: 7:17 PM Local: 2:17 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 21, 7, 24, 0, true);            // UTC: 7:24 AM Local: 2:24 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 12, 20, 2, 0, true);            // UTC: 8:02 PM Local: 3:02 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 3, 5, 9, 0, true);              // UTC: 5:09 AM Local: 12:09 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 13, 16, 31, 0, true);           // UTC: 4:31 PM Local: 11:31 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 13, 10, 16, 0, true);           // UTC: 10:16 AM Local: 5:16 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 6, 4, 11, 0, true);             // UTC: 4:11 AM Local: 11:11 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 17, 3, 21, 0, true);            // UTC: 3:21 AM Local: 10:21 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 7, 13, 17, 25, 0, true);           // UTC: 5:25 PM Local: 12:25 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 15, 6, 30, 0, true);            // UTC: 6:30 AM Local: 1:30 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 11, 16, 46, 0, true);           // UTC: 4:46 PM Local: 11:46 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 1, 13, 4, 0, true);             // UTC: 1:04 PM Local: 8:04 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 7, 7, 45, 0, true);             // UTC: 7:45 AM Local: 2:45 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 9, 17, 27, 0, true);            // UTC: 5:27 PM Local: 12:27 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 13, 15, 5, 0, true);            // UTC: 3:05 PM Local: 10:05 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 4, 2, 8, 0, true);              // UTC: 2:08 AM Local: 9:08 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 7, 0, 37, 0, true);             // UTC: 12:37 AM Local: 7:37 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 2, 11, 56, 0, true);            // UTC: 11:56 AM Local: 6:56 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 15, 12, 40, 0, true);           // UTC: 12:40 PM Local: 7:40 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 25, 6, 32, 0, true);            // UTC: 6:32 AM Local: 1:32 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 27, 20, 35, 0, true);           // UTC: 8:35 PM Local: 3:35 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 14, 16, 29, 0, true);           // UTC: 4:29 PM Local: 11:29 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 11, 10, 7, 0, true);            // UTC: 10:07 AM Local: 5:07 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 13, 5, 8, 0, true);             // UTC: 5:08 AM Local: 12:08 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 14, 20, 26, 0, true);           // UTC: 8:26 PM Local: 3:26 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 20, 3, 27, 0, true);            // UTC: 3:27 AM Local: 10:27 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 8, 7, 38, 0, true);             // UTC: 7:38 AM Local: 2:38 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 9, 7, 14, 0, true);             // UTC: 7:14 AM Local: 2:14 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 24, 7, 12, 0, true);            // UTC: 7:12 AM Local: 2:12 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 23, 10, 2, 0, true);            // UTC: 10:02 AM Local: 5:02 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 11, 7, 1, 0, true);             // UTC: 7:01 AM Local: 2:01 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 7, 7, 49, 0, true);             // UTC: 7:49 AM Local: 2:49 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 24, 21, 55, 0, true);           // UTC: 9:55 PM Local: 4:55 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 8, 16, 17, 39, 0, true);           // UTC: 5:39 PM Local: 12:39 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 1, 17, 46, 0, true);            // UTC: 5:46 PM Local: 12:46 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 14, 12, 36, 0, true);           // UTC: 12:36 PM Local: 7:36 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 14, 19, 22, 0, true);           // UTC: 7:22 PM Local: 2:22 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 7, 14, 56, 0, true);            // UTC: 2:56 PM Local: 9:56 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 25, 15, 35, 0, true);           // UTC: 3:35 PM Local: 10:35 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 10, 14, 22, 0, true);           // UTC: 2:22 PM Local: 9:22 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 9, 12, 57, 0, true);            // UTC: 12:57 PM Local: 7:57 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 3, 1, 54, 0, true);             // UTC: 1:54 AM Local: 8:54 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 4, 6, 32, 0, true);             // UTC: 6:32 AM Local: 1:32 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 17, 19, 12, 0, true);           // UTC: 7:12 PM Local: 2:12 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 15, 16, 34, 0, true);           // UTC: 4:34 PM Local: 11:34 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 27, 6, 31, 0, true);            // UTC: 6:31 AM Local: 1:31 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 13, 9, 46, 0, true);            // UTC: 9:46 AM Local: 4:46 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 16, 7, 37, 0, true);            // UTC: 7:37 AM Local: 2:37 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 18, 3, 39, 0, true);            // UTC: 3:39 AM Local: 10:39 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 2, 7, 39, 0, true);             // UTC: 7:39 AM Local: 2:39 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 7, 11, 18, 0, true);            // UTC: 11:18 AM Local: 6:18 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 16, 6, 12, 0, true);            // UTC: 6:12 AM Local: 1:12 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 19, 21, 40, 0, true);           // UTC: 9:40 PM Local: 4:40 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 24, 8, 16, 0, true);            // UTC: 8:16 AM Local: 3:16 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 2, 20, 58, 0, true);            // UTC: 8:58 PM Local: 3:58 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 5, 16, 55, 0, true);            // UTC: 4:55 PM Local: 11:55 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 10, 20, 23, 0, true);           // UTC: 8:23 PM Local: 3:23 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 2, 20, 13, 0, true);            // UTC: 8:13 PM Local: 3:13 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 9, 17, 16, 11, 0, true);           // UTC: 4:11 PM Local: 11:11 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 10, 9, 54, 0, true);           // UTC: 9:54 AM Local: 4:54 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 7, 1, 55, 0, true);            // UTC: 1:55 AM Local: 8:55 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 25, 8, 20, 0, true);           // UTC: 8:20 AM Local: 3:20 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 25, 22, 24, 0, true);          // UTC: 10:24 PM Local: 5:24 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 11, 6, 21, 0, true);           // UTC: 6:21 AM Local: 1:21 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 23, 13, 2, 0, true);           // UTC: 1:02 PM Local: 8:02 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 14, 12, 25, 0, true);          // UTC: 12:25 PM Local: 7:25 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 18, 10, 27, 0, true);          // UTC: 10:27 AM Local: 5:27 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 20, 15, 24, 0, true);          // UTC: 3:24 PM Local: 10:24 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 8, 4, 35, 0, true);            // UTC: 4:35 AM Local: 11:35 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 3, 22, 33, 0, true);           // UTC: 10:33 PM Local: 5:33 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 1, 7, 29, 0, true);            // UTC: 7:29 AM Local: 2:29 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 21, 14, 17, 0, true);          // UTC: 2:17 PM Local: 9:17 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 10, 4, 32, 0, true);           // UTC: 4:32 AM Local: 11:32 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 18, 6, 42, 0, true);           // UTC: 6:42 AM Local: 1:42 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 14, 22, 35, 0, true);          // UTC: 10:35 PM Local: 5:35 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 1, 4, 17, 0, true);            // UTC: 4:17 AM Local: 11:17 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 5, 2, 11, 0, true);            // UTC: 2:11 AM Local: 9:11 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 21, 16, 56, 0, true);          // UTC: 4:56 PM Local: 11:56 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 13, 11, 22, 0, true);          // UTC: 11:22 AM Local: 6:22 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 15, 14, 9, 0, true);           // UTC: 2:09 PM Local: 9:09 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 20, 18, 0, 0, true);           // UTC: 6:00 PM Local: 1:00 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 23, 8, 56, 0, true);           // UTC: 8:56 AM Local: 3:56 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 24, 2, 57, 0, true);           // UTC: 2:57 AM Local: 9:57 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 10, 21, 3, 20, 0, true);           // UTC: 3:20 AM Local: 10:20 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 24, 0, 10, 0, false);          // UTC: 12:10 AM Local: 6:10 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 20, 5, 41, 0, false);          // UTC: 5:41 AM Local: 11:41 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 22, 5, 57, 0, false);          // UTC: 5:57 AM Local: 11:57 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 9, 21, 51, 0, false);          // UTC: 9:51 PM Local: 3:51 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 11, 5, 38, 0, false);          // UTC: 5:38 AM Local: 11:38 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 15, 6, 6, 0, false);           // UTC: 6:06 AM Local: 12:06 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 25, 18, 32, 0, false);         // UTC: 6:32 PM Local: 12:32 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 11, 20, 29, 0, false);         // UTC: 8:29 PM Local: 2:29 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 20, 15, 36, 0, false);         // UTC: 3:36 PM Local: 9:36 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 18, 4, 7, 0, false);           // UTC: 4:07 AM Local: 10:07 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 10, 9, 54, 0, false);          // UTC: 9:54 AM Local: 3:54 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 23, 20, 40, 0, false);         // UTC: 8:40 PM Local: 2:40 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 22, 16, 17, 0, false);         // UTC: 4:17 PM Local: 10:17 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 19, 16, 22, 0, false);         // UTC: 4:22 PM Local: 10:22 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 6, 9, 51, 0, false);           // UTC: 9:51 AM Local: 3:51 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 4, 10, 7, 0, false);           // UTC: 10:07 AM Local: 4:07 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 9, 7, 47, 0, false);           // UTC: 7:47 AM Local: 1:47 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 24, 19, 21, 0, false);         // UTC: 7:21 PM Local: 1:21 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 22, 11, 6, 0, false);          // UTC: 11:06 AM Local: 5:06 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 19, 0, 32, 0, false);          // UTC: 12:32 AM Local: 6:32 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 3, 3, 3, 0, true);             // UTC: 3:03 AM Local: 10:03 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 24, 22, 29, 0, false);         // UTC: 10:29 PM Local: 4:29 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 26, 12, 21, 0, false);         // UTC: 12:21 PM Local: 6:21 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 26, 17, 32, 0, false);         // UTC: 5:32 PM Local: 11:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 11, 22, 5, 5, 0, false);           // UTC: 5:05 AM Local: 11:05 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 5, 4, 27, 0, false);           // UTC: 4:27 AM Local: 10:27 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 17, 13, 11, 0, false);         // UTC: 1:11 PM Local: 7:11 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 13, 8, 50, 0, false);          // UTC: 8:50 AM Local: 2:50 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 9, 10, 33, 0, false);          // UTC: 10:33 AM Local: 4:33 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 15, 1, 21, 0, false);          // UTC: 1:21 AM Local: 7:21 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 16, 2, 42, 0, false);          // UTC: 2:42 AM Local: 8:42 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 20, 13, 33, 0, false);         // UTC: 1:33 PM Local: 7:33 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 9, 7, 27, 0, false);           // UTC: 7:27 AM Local: 1:27 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 11, 4, 54, 0, false);          // UTC: 4:54 AM Local: 10:54 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 21, 7, 32, 0, false);          // UTC: 7:32 AM Local: 1:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 7, 1, 36, 0, false);           // UTC: 1:36 AM Local: 7:36 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 8, 14, 19, 0, false);          // UTC: 2:19 PM Local: 8:19 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 18, 1, 26, 0, false);          // UTC: 1:26 AM Local: 7:26 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 10, 13, 47, 0, false);         // UTC: 1:47 PM Local: 7:47 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 6, 12, 29, 0, false);          // UTC: 12:29 PM Local: 6:29 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 25, 9, 29, 0, false);          // UTC: 9:29 AM Local: 3:29 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 27, 8, 39, 0, false);          // UTC: 8:39 AM Local: 2:39 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 23, 1, 37, 0, false);          // UTC: 1:37 AM Local: 7:37 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 15, 19, 49, 0, false);         // UTC: 7:49 PM Local: 1:49 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 1, 5, 22, 0, false);           // UTC: 5:22 AM Local: 11:22 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 8, 16, 0, 0, false);           // UTC: 4:00 PM Local: 10:00 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 9, 1, 24, 0, false);           // UTC: 1:24 AM Local: 7:24 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 26, 6, 25, 0, false);          // UTC: 6:25 AM Local: 12:25 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 2, 21, 1, 0, false);           // UTC: 9:01 PM Local: 3:01 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2018, 12, 8, 8, 58, 0, false);           // UTC: 8:58 AM Local: 2:58 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 21, 2, 47, 0, false);           // UTC: 2:47 AM Local: 8:47 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 27, 10, 46, 0, false);          // UTC: 10:46 AM Local: 4:46 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 12, 18, 57, 0, false);          // UTC: 6:57 PM Local: 12:57 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 25, 9, 58, 0, false);           // UTC: 9:58 AM Local: 3:58 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 27, 16, 45, 0, false);          // UTC: 4:45 PM Local: 10:45 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 13, 14, 49, 0, false);          // UTC: 2:49 PM Local: 8:49 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 2, 2, 53, 0, false);            // UTC: 2:53 AM Local: 8:53 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 22, 20, 27, 0, false);          // UTC: 8:27 PM Local: 2:27 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 3, 22, 6, 0, false);            // UTC: 10:06 PM Local: 4:06 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 2, 21, 25, 0, false);           // UTC: 9:25 PM Local: 3:25 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 18, 12, 40, 0, false);          // UTC: 12:40 PM Local: 6:40 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 18, 17, 43, 0, false);          // UTC: 5:43 PM Local: 11:43 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 2, 0, 45, 0, false);            // UTC: 12:45 AM Local: 6:45 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 17, 19, 53, 0, false);          // UTC: 7:53 PM Local: 1:53 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 2, 9, 38, 0, false);            // UTC: 9:38 AM Local: 3:38 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 12, 22, 32, 0, false);          // UTC: 10:32 PM Local: 4:32 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 18, 13, 17, 0, false);          // UTC: 1:17 PM Local: 7:17 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 5, 4, 16, 0, false);            // UTC: 4:16 AM Local: 10:16 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 3, 22, 11, 0, false);           // UTC: 10:11 PM Local: 4:11 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 10, 20, 29, 0, false);          // UTC: 8:29 PM Local: 2:29 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 19, 8, 50, 0, false);           // UTC: 8:50 AM Local: 2:50 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 15, 5, 50, 0, false);           // UTC: 5:50 AM Local: 11:50 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 8, 7, 57, 0, false);            // UTC: 7:57 AM Local: 1:57 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 1, 10, 35, 0, false);           // UTC: 10:35 AM Local: 4:35 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 1, 3, 10, 14, 0, false);           // UTC: 10:14 AM Local: 4:14 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 27, 17, 29, 0, false);          // UTC: 5:29 PM Local: 11:29 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 22, 14, 0, 0, false);           // UTC: 2:00 PM Local: 8:00 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 16, 9, 21, 0, false);           // UTC: 9:21 AM Local: 3:21 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 4, 10, 19, 0, false);           // UTC: 10:19 AM Local: 4:19 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 12, 12, 46, 0, false);          // UTC: 12:46 PM Local: 6:46 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 15, 15, 8, 0, false);           // UTC: 3:08 PM Local: 9:08 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 8, 21, 29, 0, false);           // UTC: 9:29 PM Local: 3:29 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 2, 11, 9, 0, false);            // UTC: 11:09 AM Local: 5:09 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 22, 3, 36, 0, false);           // UTC: 3:36 AM Local: 9:36 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 16, 14, 7, 0, false);           // UTC: 2:07 PM Local: 8:07 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 19, 2, 44, 0, false);           // UTC: 2:44 AM Local: 8:44 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 2, 2, 13, 0, false);            // UTC: 2:13 AM Local: 8:13 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 19, 12, 14, 0, false);          // UTC: 12:14 PM Local: 6:14 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 14, 2, 55, 0, false);           // UTC: 2:55 AM Local: 8:55 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 14, 9, 45, 0, false);           // UTC: 9:45 AM Local: 3:45 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 15, 20, 46, 0, false);          // UTC: 8:46 PM Local: 2:46 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 5, 11, 44, 0, false);           // UTC: 11:44 AM Local: 5:44 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 13, 18, 31, 0, false);          // UTC: 6:31 PM Local: 12:31 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 21, 21, 14, 0, false);          // UTC: 9:14 PM Local: 3:14 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 10, 0, 29, 0, false);           // UTC: 12:29 AM Local: 6:29 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 11, 22, 45, 0, false);          // UTC: 10:45 PM Local: 4:45 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 7, 9, 21, 0, false);            // UTC: 9:21 AM Local: 3:21 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 16, 8, 27, 0, false);           // UTC: 8:27 AM Local: 2:27 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 16, 19, 9, 0, false);           // UTC: 7:09 PM Local: 1:09 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 2, 25, 17, 47, 0, false);          // UTC: 5:47 PM Local: 11:47 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 15, 13, 6, 0, true);            // UTC: 1:06 PM Local: 8:06 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 11, 5, 15, 0, true);            // UTC: 5:15 AM Local: 12:15 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 23, 9, 8, 0, true);             // UTC: 9:08 AM Local: 4:08 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 11, 5, 17, 0, true);            // UTC: 5:17 AM Local: 12:17 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 6, 6, 9, 0, false);             // UTC: 6:09 AM Local: 12:09 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 27, 8, 29, 0, true);            // UTC: 8:29 AM Local: 3:29 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 20, 2, 8, 0, true);             // UTC: 2:08 AM Local: 9:08 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 5, 5, 57, 0, false);            // UTC: 5:57 AM Local: 11:57 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 12, 21, 29, 0, true);           // UTC: 9:29 PM Local: 4:29 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 9, 14, 38, 0, false);           // UTC: 2:38 PM Local: 8:38 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 16, 12, 2, 0, true);            // UTC: 12:02 PM Local: 7:02 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 20, 4, 20, 0, true);            // UTC: 4:20 AM Local: 11:20 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 4, 21, 45, 0, false);           // UTC: 9:45 PM Local: 3:45 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 7, 12, 34, 0, false);           // UTC: 12:34 PM Local: 6:34 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 18, 19, 11, 0, true);           // UTC: 7:11 PM Local: 2:11 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 2, 8, 4, 0, false);             // UTC: 8:04 AM Local: 2:04 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 9, 13, 27, 0, false);           // UTC: 1:27 PM Local: 7:27 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 18, 3, 38, 0, true);            // UTC: 3:38 AM Local: 10:38 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 19, 8, 19, 0, true);            // UTC: 8:19 AM Local: 3:19 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 4, 22, 18, 0, false);           // UTC: 10:18 PM Local: 4:18 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 21, 11, 45, 0, true);           // UTC: 11:45 AM Local: 6:45 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 14, 18, 39, 0, true);           // UTC: 6:39 PM Local: 1:39 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 7, 11, 4, 0, false);            // UTC: 11:04 AM Local: 5:04 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 22, 19, 24, 0, true);           // UTC: 7:24 PM Local: 2:24 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 3, 20, 11, 33, 0, true);           // UTC: 11:33 AM Local: 6:33 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 15, 12, 22, 0, true);           // UTC: 12:22 PM Local: 7:22 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 21, 7, 34, 0, true);            // UTC: 7:34 AM Local: 2:34 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 12, 0, 1, 0, true);             // UTC: 12:01 AM Local: 7:01 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 6, 21, 22, 0, true);            // UTC: 9:22 PM Local: 4:22 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 11, 1, 49, 0, true);            // UTC: 1:49 AM Local: 8:49 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 1, 0, 56, 0, true);             // UTC: 12:56 AM Local: 7:56 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 13, 11, 1, 0, true);            // UTC: 11:01 AM Local: 6:01 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 23, 3, 3, 0, true);             // UTC: 3:03 AM Local: 10:03 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 15, 18, 52, 0, true);           // UTC: 6:52 PM Local: 1:52 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 27, 11, 44, 0, true);           // UTC: 11:44 AM Local: 6:44 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 2, 21, 40, 0, true);            // UTC: 9:40 PM Local: 4:40 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 3, 2, 48, 0, true);             // UTC: 2:48 AM Local: 9:48 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 26, 8, 37, 0, true);            // UTC: 8:37 AM Local: 3:37 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 20, 7, 29, 0, true);            // UTC: 7:29 AM Local: 2:29 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 21, 6, 51, 0, true);            // UTC: 6:51 AM Local: 1:51 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 8, 19, 24, 0, true);            // UTC: 7:24 PM Local: 2:24 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 7, 18, 48, 0, true);            // UTC: 6:48 PM Local: 1:48 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 13, 6, 58, 0, true);            // UTC: 6:58 AM Local: 1:58 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 15, 16, 23, 0, true);           // UTC: 4:23 PM Local: 11:23 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 9, 5, 30, 0, true);             // UTC: 5:30 AM Local: 12:30 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 19, 9, 30, 0, true);            // UTC: 9:30 AM Local: 4:30 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 8, 3, 58, 0, true);             // UTC: 3:58 AM Local: 10:58 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 19, 7, 55, 0, true);            // UTC: 7:55 AM Local: 2:55 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 1, 1, 38, 0, true);             // UTC: 1:38 AM Local: 8:38 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 4, 9, 16, 9, 0, true);             // UTC: 4:09 PM Local: 11:09 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 15, 1, 50, 0, true);            // UTC: 1:50 AM Local: 8:50 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 6, 5, 56, 0, true);             // UTC: 5:56 AM Local: 12:56 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 13, 17, 42, 0, true);           // UTC: 5:42 PM Local: 12:42 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 26, 13, 37, 0, true);           // UTC: 1:37 PM Local: 8:37 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 19, 12, 23, 0, true);           // UTC: 12:23 PM Local: 7:23 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 12, 15, 6, 0, true);            // UTC: 3:06 PM Local: 10:06 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 4, 0, 53, 0, true);             // UTC: 12:53 AM Local: 7:53 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 27, 11, 9, 0, true);            // UTC: 11:09 AM Local: 6:09 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 24, 13, 32, 0, true);           // UTC: 1:32 PM Local: 8:32 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 13, 5, 43, 0, true);            // UTC: 5:43 AM Local: 12:43 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 5, 3, 33, 0, true);             // UTC: 3:33 AM Local: 10:33 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 23, 0, 39, 0, true);            // UTC: 12:39 AM Local: 7:39 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 15, 2, 0, 0, true);             // UTC: 2:00 AM Local: 9:00 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 16, 5, 40, 0, true);            // UTC: 5:40 AM Local: 12:40 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 22, 7, 32, 0, true);            // UTC: 7:32 AM Local: 2:32 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 10, 0, 46, 0, true);            // UTC: 12:46 AM Local: 7:46 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 15, 13, 23, 0, true);           // UTC: 1:23 PM Local: 8:23 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 15, 4, 40, 0, true);            // UTC: 4:40 AM Local: 11:40 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 7, 12, 34, 0, true);            // UTC: 12:34 PM Local: 7:34 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 19, 7, 38, 0, true);            // UTC: 7:38 AM Local: 2:38 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 12, 0, 29, 0, true);            // UTC: 12:29 AM Local: 7:29 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 27, 17, 26, 0, true);           // UTC: 5:26 PM Local: 12:26 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 2, 19, 29, 0, true);            // UTC: 7:29 PM Local: 2:29 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 20, 20, 31, 0, true);           // UTC: 8:31 PM Local: 3:31 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 5, 3, 12, 47, 0, true);            // UTC: 12:47 PM Local: 7:47 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 7, 4, 8, 0, true);              // UTC: 4:08 AM Local: 11:08 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 17, 12, 33, 0, true);           // UTC: 12:33 PM Local: 7:33 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 21, 20, 39, 0, true);           // UTC: 8:39 PM Local: 3:39 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 9, 14, 55, 0, true);            // UTC: 2:55 PM Local: 9:55 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 24, 13, 28, 0, true);           // UTC: 1:28 PM Local: 8:28 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 3, 19, 47, 0, true);            // UTC: 7:47 PM Local: 2:47 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 10, 3, 13, 0, true);            // UTC: 3:13 AM Local: 10:13 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 5, 18, 35, 0, true);            // UTC: 6:35 PM Local: 1:35 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 3, 6, 9, 0, true);              // UTC: 6:09 AM Local: 1:09 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 8, 19, 40, 0, true);            // UTC: 7:40 PM Local: 2:40 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 24, 10, 38, 0, true);           // UTC: 10:38 AM Local: 5:38 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 24, 0, 20, 0, true);            // UTC: 12:20 AM Local: 7:20 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 12, 2, 46, 0, true);            // UTC: 2:46 AM Local: 9:46 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 3, 15, 5, 0, true);             // UTC: 3:05 PM Local: 10:05 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 23, 15, 6, 0, true);            // UTC: 3:06 PM Local: 10:06 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 14, 4, 16, 0, true);            // UTC: 4:16 AM Local: 11:16 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 1, 14, 2, 0, true);             // UTC: 2:02 PM Local: 9:02 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 20, 16, 24, 0, true);           // UTC: 4:24 PM Local: 11:24 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 16, 1, 21, 0, true);            // UTC: 1:21 AM Local: 8:21 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 15, 11, 14, 0, true);           // UTC: 11:14 AM Local: 6:14 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 11, 10, 4, 0, true);            // UTC: 10:04 AM Local: 5:04 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 27, 10, 10, 0, true);           // UTC: 10:10 AM Local: 5:10 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 8, 22, 32, 0, true);            // UTC: 10:32 PM Local: 5:32 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 4, 14, 44, 0, true);            // UTC: 2:44 PM Local: 9:44 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 6, 1, 6, 28, 0, true);             // UTC: 6:28 AM Local: 1:28 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 4, 7, 9, 0, true);              // UTC: 7:09 AM Local: 2:09 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 14, 13, 5, 0, true);            // UTC: 1:05 PM Local: 8:05 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 25, 5, 11, 0, true);            // UTC: 5:11 AM Local: 12:11 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 18, 3, 43, 0, true);            // UTC: 3:43 AM Local: 10:43 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 7, 7, 57, 0, true);             // UTC: 7:57 AM Local: 2:57 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 27, 20, 35, 0, true);           // UTC: 8:35 PM Local: 3:35 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 15, 15, 11, 0, true);           // UTC: 3:11 PM Local: 10:11 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 1, 19, 11, 0, true);            // UTC: 7:11 PM Local: 2:11 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 26, 5, 11, 0, true);            // UTC: 5:11 AM Local: 12:11 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 20, 20, 58, 0, true);           // UTC: 8:58 PM Local: 3:58 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 8, 16, 26, 0, true);            // UTC: 4:26 PM Local: 11:26 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 25, 9, 42, 0, true);            // UTC: 9:42 AM Local: 4:42 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 6, 1, 53, 0, true);             // UTC: 1:53 AM Local: 8:53 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 5, 11, 12, 0, true);            // UTC: 11:12 AM Local: 6:12 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 24, 7, 18, 0, true);            // UTC: 7:18 AM Local: 2:18 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 13, 1, 40, 0, true);            // UTC: 1:40 AM Local: 8:40 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 16, 3, 45, 0, true);            // UTC: 3:45 AM Local: 10:45 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 5, 11, 35, 0, true);            // UTC: 11:35 AM Local: 6:35 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 8, 2, 27, 0, true);             // UTC: 2:27 AM Local: 9:27 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 26, 12, 20, 0, true);           // UTC: 12:20 PM Local: 7:20 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 25, 3, 21, 0, true);            // UTC: 3:21 AM Local: 10:21 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 6, 8, 26, 0, true);             // UTC: 8:26 AM Local: 3:26 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 8, 7, 51, 0, true);             // UTC: 7:51 AM Local: 2:51 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 8, 17, 48, 0, true);            // UTC: 5:48 PM Local: 12:48 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 7, 19, 8, 9, 0, true);             // UTC: 8:09 AM Local: 3:09 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 27, 2, 32, 0, true);            // UTC: 2:32 AM Local: 9:32 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 24, 11, 10, 0, true);           // UTC: 11:10 AM Local: 6:10 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 14, 3, 44, 0, true);            // UTC: 3:44 AM Local: 10:44 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 6, 2, 12, 0, true);             // UTC: 2:12 AM Local: 9:12 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 24, 14, 18, 0, true);           // UTC: 2:18 PM Local: 9:18 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 7, 5, 30, 0, true);             // UTC: 5:30 AM Local: 12:30 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 16, 5, 20, 0, true);            // UTC: 5:20 AM Local: 12:20 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 23, 15, 55, 0, true);           // UTC: 3:55 PM Local: 10:55 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 24, 3, 43, 0, true);            // UTC: 3:43 AM Local: 10:43 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 22, 6, 21, 0, true);            // UTC: 6:21 AM Local: 1:21 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 26, 10, 5, 0, true);            // UTC: 10:05 AM Local: 5:05 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 12, 6, 58, 0, true);            // UTC: 6:58 AM Local: 1:58 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 25, 1, 3, 0, true);             // UTC: 1:03 AM Local: 8:03 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 5, 9, 0, 0, true);              // UTC: 9:00 AM Local: 4:00 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 17, 22, 15, 0, true);           // UTC: 10:15 PM Local: 5:15 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 7, 9, 40, 0, true);             // UTC: 9:40 AM Local: 4:40 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 16, 0, 30, 0, true);            // UTC: 12:30 AM Local: 7:30 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 9, 2, 8, 0, true);              // UTC: 2:08 AM Local: 9:08 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 23, 3, 26, 0, true);            // UTC: 3:26 AM Local: 10:26 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 17, 0, 18, 0, true);            // UTC: 12:18 AM Local: 7:18 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 13, 16, 50, 0, true);           // UTC: 4:50 PM Local: 11:50 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 11, 6, 37, 0, true);            // UTC: 6:37 AM Local: 1:37 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 4, 9, 19, 0, true);             // UTC: 9:19 AM Local: 4:19 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 9, 7, 10, 0, true);             // UTC: 7:10 AM Local: 2:10 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 8, 13, 9, 50, 0, true);            // UTC: 9:50 AM Local: 4:50 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 10, 5, 40, 0, true);            // UTC: 5:40 AM Local: 12:40 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 19, 14, 43, 0, true);           // UTC: 2:43 PM Local: 9:43 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 2, 5, 17, 0, true);             // UTC: 5:17 AM Local: 12:17 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 23, 14, 20, 0, true);           // UTC: 2:20 PM Local: 9:20 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 26, 13, 9, 0, true);            // UTC: 1:09 PM Local: 8:09 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 15, 6, 4, 0, true);             // UTC: 6:04 AM Local: 1:04 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 21, 16, 40, 0, true);           // UTC: 4:40 PM Local: 11:40 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 5, 4, 41, 0, true);             // UTC: 4:41 AM Local: 11:41 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 17, 2, 0, 0, true);             // UTC: 2:00 AM Local: 9:00 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 10, 5, 39, 0, true);            // UTC: 5:39 AM Local: 12:39 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 10, 19, 43, 0, true);           // UTC: 7:43 PM Local: 2:43 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 8, 11, 52, 0, true);            // UTC: 11:52 AM Local: 6:52 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 21, 21, 21, 0, true);           // UTC: 9:21 PM Local: 4:21 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 16, 9, 27, 0, true);            // UTC: 9:27 AM Local: 4:27 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 16, 12, 37, 0, true);           // UTC: 12:37 PM Local: 7:37 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 8, 3, 48, 0, true);             // UTC: 3:48 AM Local: 10:48 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 5, 17, 2, 0, true);             // UTC: 5:02 PM Local: 12:02 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 3, 16, 40, 0, true);            // UTC: 4:40 PM Local: 11:40 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 5, 4, 2, 0, true);              // UTC: 4:02 AM Local: 11:02 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 27, 1, 31, 0, true);            // UTC: 1:31 AM Local: 8:31 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 20, 15, 57, 0, true);           // UTC: 3:57 PM Local: 10:57 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 18, 11, 46, 0, true);           // UTC: 11:46 AM Local: 6:46 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 17, 15, 7, 0, true);            // UTC: 3:07 PM Local: 10:07 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 8, 17, 21, 0, true);            // UTC: 5:21 PM Local: 12:21 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 9, 20, 3, 18, 0, true);            // UTC: 3:18 AM Local: 10:18 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 7, 13, 39, 0, true);           // UTC: 1:39 PM Local: 8:39 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 2, 7, 56, 0, true);            // UTC: 7:56 AM Local: 2:56 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 6, 4, 29, 0, true);            // UTC: 4:29 AM Local: 11:29 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 17, 5, 8, 0, true);            // UTC: 5:08 AM Local: 12:08 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 2, 2, 17, 0, true);            // UTC: 2:17 AM Local: 9:17 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 23, 18, 52, 0, true);          // UTC: 6:52 PM Local: 1:52 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 23, 19, 42, 0, true);          // UTC: 7:42 PM Local: 2:42 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 14, 21, 2, 0, true);           // UTC: 9:02 PM Local: 4:02 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 24, 15, 28, 0, true);          // UTC: 3:28 PM Local: 10:28 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 19, 20, 58, 0, true);          // UTC: 8:58 PM Local: 3:58 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 19, 9, 31, 0, true);           // UTC: 9:31 AM Local: 4:31 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 10, 21, 35, 0, true);          // UTC: 9:35 PM Local: 4:35 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 11, 20, 41, 0, true);          // UTC: 8:41 PM Local: 3:41 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 16, 12, 29, 0, true);          // UTC: 12:29 PM Local: 7:29 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 14, 0, 14, 0, true);           // UTC: 12:14 AM Local: 7:14 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 18, 13, 32, 0, true);          // UTC: 1:32 PM Local: 8:32 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 23, 9, 57, 0, true);           // UTC: 9:57 AM Local: 4:57 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 13, 20, 19, 0, true);          // UTC: 8:19 PM Local: 3:19 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 17, 16, 39, 0, true);          // UTC: 4:39 PM Local: 11:39 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 17, 4, 40, 0, true);           // UTC: 4:40 AM Local: 11:40 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 13, 11, 17, 0, true);          // UTC: 11:17 AM Local: 6:17 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 14, 21, 50, 0, true);          // UTC: 9:50 PM Local: 4:50 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 17, 15, 10, 0, true);          // UTC: 3:10 PM Local: 10:10 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 19, 10, 52, 0, true);          // UTC: 10:52 AM Local: 5:52 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 10, 5, 5, 16, 0, true);            // UTC: 5:16 AM Local: 12:16 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 6, 0, 54, 0, false);           // UTC: 12:54 AM Local: 6:54 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 22, 4, 5, 0, false);           // UTC: 4:05 AM Local: 10:05 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 25, 19, 27, 0, false);         // UTC: 7:27 PM Local: 1:27 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 1, 4, 31, 0, true);            // UTC: 4:31 AM Local: 11:31 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 6, 17, 12, 0, false);          // UTC: 5:12 PM Local: 11:12 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 26, 17, 40, 0, false);         // UTC: 5:40 PM Local: 11:40 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 1, 2, 3, 0, true);             // UTC: 2:03 AM Local: 9:03 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 6, 22, 2, 0, false);           // UTC: 10:02 PM Local: 4:02 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 11, 1, 52, 0, false);          // UTC: 1:52 AM Local: 7:52 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 11, 3, 56, 0, false);          // UTC: 3:56 AM Local: 9:56 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 3, 6, 36, 0, true);            // UTC: 6:36 AM Local: 1:36 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 2, 8, 42, 0, true);            // UTC: 8:42 AM Local: 3:42 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 21, 18, 0, 0, false);          // UTC: 6:00 PM Local: 12:00 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 16, 12, 37, 0, false);         // UTC: 12:37 PM Local: 6:37 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 23, 11, 44, 0, false);         // UTC: 11:44 AM Local: 5:44 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 9, 9, 53, 0, false);           // UTC: 9:53 AM Local: 3:53 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 27, 17, 42, 0, false);         // UTC: 5:42 PM Local: 11:42 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 6, 3, 8, 0, false);            // UTC: 3:08 AM Local: 9:08 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 7, 0, 1, 0, false);            // UTC: 12:01 AM Local: 6:01 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 24, 9, 9, 0, false);           // UTC: 9:09 AM Local: 3:09 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 6, 12, 42, 0, false);          // UTC: 12:42 PM Local: 6:42 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 14, 21, 52, 0, false);         // UTC: 9:52 PM Local: 3:52 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 25, 3, 23, 0, false);          // UTC: 3:23 AM Local: 9:23 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 13, 4, 55, 0, false);          // UTC: 4:55 AM Local: 10:55 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 11, 19, 10, 33, 0, false);         // UTC: 10:33 AM Local: 4:33 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 12, 8, 29, 0, false);          // UTC: 8:29 AM Local: 2:29 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 8, 1, 38, 0, false);           // UTC: 1:38 AM Local: 7:38 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 27, 9, 21, 0, false);          // UTC: 9:21 AM Local: 3:21 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 7, 20, 9, 0, false);           // UTC: 8:09 PM Local: 2:09 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 13, 18, 21, 0, false);         // UTC: 6:21 PM Local: 12:21 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 19, 19, 24, 0, false);         // UTC: 7:24 PM Local: 1:24 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 24, 9, 0, 0, false);           // UTC: 9:00 AM Local: 3:00 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 26, 7, 32, 0, false);          // UTC: 7:32 AM Local: 1:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 24, 9, 14, 0, false);          // UTC: 9:14 AM Local: 3:14 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 14, 11, 34, 0, false);         // UTC: 11:34 AM Local: 5:34 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 21, 12, 41, 0, false);         // UTC: 12:41 PM Local: 6:41 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 16, 18, 38, 0, false);         // UTC: 6:38 PM Local: 12:38 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 15, 13, 18, 0, false);         // UTC: 1:18 PM Local: 7:18 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 14, 5, 8, 0, false);           // UTC: 5:08 AM Local: 11:08 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 10, 6, 3, 0, false);           // UTC: 6:03 AM Local: 12:03 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 20, 10, 19, 0, false);         // UTC: 10:19 AM Local: 4:19 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 1, 18, 18, 0, false);          // UTC: 6:18 PM Local: 12:18 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 14, 18, 2, 0, false);          // UTC: 6:02 PM Local: 12:02 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 16, 11, 2, 0, false);          // UTC: 11:02 AM Local: 5:02 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 26, 9, 39, 0, false);          // UTC: 9:39 AM Local: 3:39 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 11, 10, 53, 0, false);         // UTC: 10:53 AM Local: 4:53 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 22, 10, 19, 0, false);         // UTC: 10:19 AM Local: 4:19 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 13, 20, 58, 0, false);         // UTC: 8:58 PM Local: 2:58 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 20, 3, 16, 0, false);          // UTC: 3:16 AM Local: 9:16 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2019, 12, 3, 7, 10, 0, false);           // UTC: 7:10 AM Local: 1:10 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 24, 13, 2, 0, false);           // UTC: 1:02 PM Local: 7:02 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 13, 3, 57, 0, false);           // UTC: 3:57 AM Local: 9:57 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 25, 11, 41, 0, false);          // UTC: 11:41 AM Local: 5:41 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 8, 5, 42, 0, false);            // UTC: 5:42 AM Local: 11:42 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 18, 0, 19, 0, false);           // UTC: 12:19 AM Local: 6:19 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 17, 13, 9, 0, false);           // UTC: 1:09 PM Local: 7:09 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 18, 2, 44, 0, false);           // UTC: 2:44 AM Local: 8:44 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 7, 12, 48, 0, false);           // UTC: 12:48 PM Local: 6:48 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 20, 6, 32, 0, false);           // UTC: 6:32 AM Local: 12:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 9, 6, 36, 0, false);            // UTC: 6:36 AM Local: 12:36 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 2, 9, 28, 0, false);            // UTC: 9:28 AM Local: 3:28 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 24, 15, 53, 0, false);          // UTC: 3:53 PM Local: 9:53 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 1, 10, 17, 0, false);           // UTC: 10:17 AM Local: 4:17 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 19, 11, 56, 0, false);          // UTC: 11:56 AM Local: 5:56 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 6, 12, 11, 0, false);           // UTC: 12:11 PM Local: 6:11 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 17, 18, 50, 0, false);          // UTC: 6:50 PM Local: 12:50 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 18, 2, 34, 0, false);           // UTC: 2:34 AM Local: 8:34 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 3, 10, 13, 0, false);           // UTC: 10:13 AM Local: 4:13 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 12, 14, 1, 0, false);           // UTC: 2:01 PM Local: 8:01 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 6, 17, 50, 0, false);           // UTC: 5:50 PM Local: 11:50 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 12, 13, 12, 0, false);          // UTC: 1:12 PM Local: 7:12 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 3, 4, 50, 0, false);            // UTC: 4:50 AM Local: 10:50 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 7, 18, 19, 0, false);           // UTC: 6:19 PM Local: 12:19 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 12, 13, 6, 0, false);           // UTC: 1:06 PM Local: 7:06 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 1, 24, 21, 37, 0, false);          // UTC: 9:37 PM Local: 3:37 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 22, 0, 2, 0, false);            // UTC: 12:02 AM Local: 6:02 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 17, 2, 28, 0, false);           // UTC: 2:28 AM Local: 8:28 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 19, 15, 9, 0, false);           // UTC: 3:09 PM Local: 9:09 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 2, 21, 55, 0, false);           // UTC: 9:55 PM Local: 3:55 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 7, 10, 3, 0, false);            // UTC: 10:03 AM Local: 4:03 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 24, 18, 42, 0, false);          // UTC: 6:42 PM Local: 12:42 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 12, 6, 52, 0, false);           // UTC: 6:52 AM Local: 12:52 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 21, 2, 18, 0, false);           // UTC: 2:18 AM Local: 8:18 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 10, 8, 0, 0, false);            // UTC: 8:00 AM Local: 2:00 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 15, 5, 31, 0, false);           // UTC: 5:31 AM Local: 11:31 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 13, 5, 30, 0, false);           // UTC: 5:30 AM Local: 11:30 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 16, 14, 35, 0, false);          // UTC: 2:35 PM Local: 8:35 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 27, 13, 37, 0, false);          // UTC: 1:37 PM Local: 7:37 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 11, 16, 53, 0, false);          // UTC: 4:53 PM Local: 10:53 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 2, 1, 16, 0, false);            // UTC: 1:16 AM Local: 7:16 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 25, 22, 19, 0, false);          // UTC: 10:19 PM Local: 4:19 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 8, 12, 47, 0, false);           // UTC: 12:47 PM Local: 6:47 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 11, 10, 40, 0, false);          // UTC: 10:40 AM Local: 4:40 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 21, 0, 54, 0, false);           // UTC: 12:54 AM Local: 6:54 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 20, 6, 43, 0, false);           // UTC: 6:43 AM Local: 12:43 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 13, 3, 26, 0, false);           // UTC: 3:26 AM Local: 9:26 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 18, 13, 41, 0, false);          // UTC: 1:41 PM Local: 7:41 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 12, 15, 48, 0, false);          // UTC: 3:48 PM Local: 9:48 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 13, 20, 12, 0, false);          // UTC: 8:12 PM Local: 2:12 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 2, 3, 1, 31, 0, false);            // UTC: 1:31 AM Local: 7:31 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 27, 16, 3, 0, true);            // UTC: 4:03 PM Local: 11:03 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 1, 10, 23, 0, false);           // UTC: 10:23 AM Local: 4:23 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 19, 5, 39, 0, true);            // UTC: 5:39 AM Local: 12:39 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 20, 1, 47, 0, true);            // UTC: 1:47 AM Local: 8:47 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 23, 19, 35, 0, true);           // UTC: 7:35 PM Local: 2:35 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 19, 6, 17, 0, true);            // UTC: 6:17 AM Local: 1:17 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 25, 20, 34, 0, true);           // UTC: 8:34 PM Local: 3:34 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 13, 9, 27, 0, true);            // UTC: 9:27 AM Local: 4:27 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 16, 10, 18, 0, true);           // UTC: 10:18 AM Local: 5:18 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 15, 18, 39, 0, true);           // UTC: 6:39 PM Local: 1:39 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 16, 7, 21, 0, true);            // UTC: 7:21 AM Local: 2:21 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 4, 17, 18, 0, false);           // UTC: 5:18 PM Local: 11:18 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 24, 16, 49, 0, true);           // UTC: 4:49 PM Local: 11:49 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 9, 18, 53, 0, true);            // UTC: 6:53 PM Local: 1:53 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 21, 20, 30, 0, true);           // UTC: 8:30 PM Local: 3:30 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 25, 13, 49, 0, true);           // UTC: 1:49 PM Local: 8:49 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 6, 17, 37, 0, false);           // UTC: 5:37 PM Local: 11:37 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 25, 4, 9, 0, true);             // UTC: 4:09 AM Local: 11:09 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 26, 11, 18, 0, true);           // UTC: 11:18 AM Local: 6:18 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 17, 10, 56, 0, true);           // UTC: 10:56 AM Local: 5:56 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 3, 3, 25, 0, false);            // UTC: 3:25 AM Local: 9:25 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 1, 3, 44, 0, false);            // UTC: 3:44 AM Local: 9:44 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 12, 15, 4, 0, true);            // UTC: 3:04 PM Local: 10:04 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 8, 19, 33, 0, true);            // UTC: 7:33 PM Local: 2:33 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 3, 13, 13, 6, 0, true);            // UTC: 1:06 PM Local: 8:06 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 19, 15, 29, 0, true);           // UTC: 3:29 PM Local: 10:29 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 26, 15, 51, 0, true);           // UTC: 3:51 PM Local: 10:51 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 13, 6, 2, 0, true);             // UTC: 6:02 AM Local: 1:02 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 1, 15, 7, 0, true);             // UTC: 3:07 PM Local: 10:07 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 6, 4, 14, 0, true);             // UTC: 4:14 AM Local: 11:14 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 27, 5, 15, 0, true);            // UTC: 5:15 AM Local: 12:15 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 24, 5, 37, 0, true);            // UTC: 5:37 AM Local: 12:37 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 13, 17, 44, 0, true);           // UTC: 5:44 PM Local: 12:44 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 21, 10, 53, 0, true);           // UTC: 10:53 AM Local: 5:53 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 21, 21, 55, 0, true);           // UTC: 9:55 PM Local: 4:55 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 2, 10, 36, 0, true);            // UTC: 10:36 AM Local: 5:36 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 2, 6, 48, 0, true);             // UTC: 6:48 AM Local: 1:48 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 23, 15, 44, 0, true);           // UTC: 3:44 PM Local: 10:44 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 3, 14, 50, 0, true);            // UTC: 2:50 PM Local: 9:50 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 11, 22, 27, 0, true);           // UTC: 10:27 PM Local: 5:27 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 18, 4, 28, 0, true);            // UTC: 4:28 AM Local: 11:28 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 23, 6, 34, 0, true);            // UTC: 6:34 AM Local: 1:34 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 8, 13, 19, 0, true);            // UTC: 1:19 PM Local: 8:19 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 13, 4, 54, 0, true);            // UTC: 4:54 AM Local: 11:54 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 21, 4, 13, 0, true);            // UTC: 4:13 AM Local: 11:13 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 26, 16, 21, 0, true);           // UTC: 4:21 PM Local: 11:21 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 3, 22, 12, 0, true);            // UTC: 10:12 PM Local: 5:12 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 14, 3, 53, 0, true);            // UTC: 3:53 AM Local: 10:53 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 12, 4, 34, 0, true);            // UTC: 4:34 AM Local: 11:34 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 4, 15, 18, 36, 0, true);           // UTC: 6:36 PM Local: 1:36 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 22, 1, 47, 0, true);            // UTC: 1:47 AM Local: 8:47 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 8, 3, 15, 0, true);             // UTC: 3:15 AM Local: 10:15 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 12, 21, 38, 0, true);           // UTC: 9:38 PM Local: 4:38 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 10, 17, 52, 0, true);           // UTC: 5:52 PM Local: 12:52 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 8, 13, 4, 0, true);             // UTC: 1:04 PM Local: 8:04 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 25, 1, 29, 0, true);            // UTC: 1:29 AM Local: 8:29 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 15, 2, 52, 0, true);            // UTC: 2:52 AM Local: 9:52 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 14, 6, 0, 0, true);             // UTC: 6:00 AM Local: 1:00 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 7, 2, 2, 0, true);              // UTC: 2:02 AM Local: 9:02 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 16, 9, 5, 0, true);             // UTC: 9:05 AM Local: 4:05 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 1, 17, 45, 0, true);            // UTC: 5:45 PM Local: 12:45 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 20, 15, 7, 0, true);            // UTC: 3:07 PM Local: 10:07 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 4, 10, 2, 0, true);             // UTC: 10:02 AM Local: 5:02 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 26, 12, 46, 0, true);           // UTC: 12:46 PM Local: 7:46 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 19, 17, 10, 0, true);           // UTC: 5:10 PM Local: 12:10 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 9, 5, 35, 0, true);             // UTC: 5:35 AM Local: 12:35 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 23, 11, 6, 0, true);            // UTC: 11:06 AM Local: 6:06 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 3, 22, 39, 0, true);            // UTC: 10:39 PM Local: 5:39 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 20, 6, 46, 0, true);            // UTC: 6:46 AM Local: 1:46 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 22, 0, 1, 0, true);             // UTC: 12:01 AM Local: 7:01 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 6, 19, 30, 0, true);            // UTC: 7:30 PM Local: 2:30 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 16, 8, 0, 0, true);             // UTC: 8:00 AM Local: 3:00 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 4, 12, 52, 0, true);            // UTC: 12:52 PM Local: 7:52 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 26, 18, 35, 0, true);           // UTC: 6:35 PM Local: 1:35 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 5, 13, 12, 34, 0, true);           // UTC: 12:34 PM Local: 7:34 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 3, 18, 32, 0, true);            // UTC: 6:32 PM Local: 1:32 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 23, 21, 52, 0, true);           // UTC: 9:52 PM Local: 4:52 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 12, 17, 52, 0, true);           // UTC: 5:52 PM Local: 12:52 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 27, 21, 46, 0, true);           // UTC: 9:46 PM Local: 4:46 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 3, 22, 23, 0, true);            // UTC: 10:23 PM Local: 5:23 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 10, 7, 26, 0, true);            // UTC: 7:26 AM Local: 2:26 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 1, 17, 40, 0, true);            // UTC: 5:40 PM Local: 12:40 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 8, 3, 22, 0, true);             // UTC: 3:22 AM Local: 10:22 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 5, 4, 39, 0, true);             // UTC: 4:39 AM Local: 11:39 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 20, 20, 42, 0, true);           // UTC: 8:42 PM Local: 3:42 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 14, 14, 25, 0, true);           // UTC: 2:25 PM Local: 9:25 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 3, 14, 29, 0, true);            // UTC: 2:29 PM Local: 9:29 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 7, 21, 5, 0, true);             // UTC: 9:05 PM Local: 4:05 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 4, 17, 6, 0, true);             // UTC: 5:06 PM Local: 12:06 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 17, 13, 26, 0, true);           // UTC: 1:26 PM Local: 8:26 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 6, 0, 32, 0, true);             // UTC: 12:32 AM Local: 7:32 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 14, 14, 26, 0, true);           // UTC: 2:26 PM Local: 9:26 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 4, 9, 48, 0, true);             // UTC: 9:48 AM Local: 4:48 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 25, 19, 37, 0, true);           // UTC: 7:37 PM Local: 2:37 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 5, 15, 41, 0, true);            // UTC: 3:41 PM Local: 10:41 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 6, 16, 50, 0, true);            // UTC: 4:50 PM Local: 11:50 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 5, 10, 16, 0, true);            // UTC: 10:16 AM Local: 5:16 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 10, 0, 22, 0, true);            // UTC: 12:22 AM Local: 7:22 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 25, 2, 22, 0, true);            // UTC: 2:22 AM Local: 9:22 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 6, 10, 20, 57, 0, true);           // UTC: 8:57 PM Local: 3:57 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 16, 14, 33, 0, true);           // UTC: 2:33 PM Local: 9:33 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 26, 22, 11, 0, true);           // UTC: 10:11 PM Local: 5:11 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 4, 5, 16, 0, true);             // UTC: 5:16 AM Local: 12:16 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 8, 8, 11, 0, true);             // UTC: 8:11 AM Local: 3:11 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 17, 4, 46, 0, true);            // UTC: 4:46 AM Local: 11:46 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 24, 1, 17, 0, true);            // UTC: 1:17 AM Local: 8:17 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 11, 21, 3, 0, true);            // UTC: 9:03 PM Local: 4:03 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 7, 10, 6, 0, true);             // UTC: 10:06 AM Local: 5:06 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 5, 20, 58, 0, true);            // UTC: 8:58 PM Local: 3:58 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 5, 13, 30, 0, true);            // UTC: 1:30 PM Local: 8:30 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 2, 18, 32, 0, true);            // UTC: 6:32 PM Local: 1:32 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 23, 7, 11, 0, true);            // UTC: 7:11 AM Local: 2:11 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 2, 5, 41, 0, true);             // UTC: 5:41 AM Local: 12:41 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 14, 2, 28, 0, true);            // UTC: 2:28 AM Local: 9:28 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 16, 20, 5, 0, true);            // UTC: 8:05 PM Local: 3:05 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 3, 16, 49, 0, true);            // UTC: 4:49 PM Local: 11:49 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 17, 0, 0, 0, true);             // UTC: 12:00 AM Local: 7:00 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 3, 22, 56, 0, true);            // UTC: 10:56 PM Local: 5:56 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 25, 7, 10, 0, true);            // UTC: 7:10 AM Local: 2:10 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 13, 17, 4, 0, true);            // UTC: 5:04 PM Local: 12:04 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 6, 21, 38, 0, true);            // UTC: 9:38 PM Local: 4:38 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 21, 4, 33, 0, true);            // UTC: 4:33 AM Local: 11:33 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 18, 17, 51, 0, true);           // UTC: 5:51 PM Local: 12:51 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 17, 18, 50, 0, true);           // UTC: 6:50 PM Local: 1:50 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 7, 17, 20, 49, 0, true);           // UTC: 8:49 PM Local: 3:49 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 16, 15, 33, 0, true);           // UTC: 3:33 PM Local: 10:33 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 1, 1, 8, 0, true);              // UTC: 1:08 AM Local: 8:08 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 5, 13, 32, 0, true);            // UTC: 1:32 PM Local: 8:32 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 14, 22, 48, 0, true);           // UTC: 10:48 PM Local: 5:48 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 16, 21, 57, 0, true);           // UTC: 9:57 PM Local: 4:57 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 1, 13, 25, 0, true);            // UTC: 1:25 PM Local: 8:25 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 17, 6, 8, 0, true);             // UTC: 6:08 AM Local: 1:08 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 23, 19, 41, 0, true);           // UTC: 7:41 PM Local: 2:41 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 15, 9, 57, 0, true);            // UTC: 9:57 AM Local: 4:57 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 27, 0, 14, 0, true);            // UTC: 12:14 AM Local: 7:14 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 5, 11, 5, 0, true);             // UTC: 11:05 AM Local: 6:05 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 4, 7, 39, 0, true);             // UTC: 7:39 AM Local: 2:39 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 17, 10, 41, 0, true);           // UTC: 10:41 AM Local: 5:41 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 26, 1, 22, 0, true);            // UTC: 1:22 AM Local: 8:22 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 3, 5, 12, 0, true);             // UTC: 5:12 AM Local: 12:12 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 21, 1, 48, 0, true);            // UTC: 1:48 AM Local: 8:48 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 24, 13, 11, 0, true);           // UTC: 1:11 PM Local: 8:11 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 12, 22, 33, 0, true);           // UTC: 10:33 PM Local: 5:33 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 19, 16, 49, 0, true);           // UTC: 4:49 PM Local: 11:49 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 24, 11, 38, 0, true);           // UTC: 11:38 AM Local: 6:38 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 5, 4, 33, 0, true);             // UTC: 4:33 AM Local: 11:33 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 8, 8, 29, 0, true);             // UTC: 8:29 AM Local: 3:29 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 20, 10, 35, 0, true);           // UTC: 10:35 AM Local: 5:35 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 9, 9, 7, 0, true);              // UTC: 9:07 AM Local: 4:07 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 8, 20, 15, 14, 0, true);           // UTC: 3:14 PM Local: 10:14 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 21, 16, 34, 0, true);           // UTC: 4:34 PM Local: 11:34 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 13, 17, 20, 0, true);           // UTC: 5:20 PM Local: 12:20 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 4, 2, 24, 0, true);             // UTC: 2:24 AM Local: 9:24 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 2, 16, 29, 0, true);            // UTC: 4:29 PM Local: 11:29 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 15, 9, 35, 0, true);            // UTC: 9:35 AM Local: 4:35 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 23, 17, 58, 0, true);           // UTC: 5:58 PM Local: 12:58 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 2, 17, 52, 0, true);            // UTC: 5:52 PM Local: 12:52 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 22, 18, 52, 0, true);           // UTC: 6:52 PM Local: 1:52 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 20, 0, 36, 0, true);            // UTC: 12:36 AM Local: 7:36 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 7, 13, 11, 0, true);            // UTC: 1:11 PM Local: 8:11 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 2, 15, 19, 0, true);            // UTC: 3:19 PM Local: 10:19 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 10, 21, 58, 0, true);           // UTC: 9:58 PM Local: 4:58 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 7, 9, 41, 0, true);             // UTC: 9:41 AM Local: 4:41 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 9, 0, 5, 0, true);              // UTC: 12:05 AM Local: 7:05 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 4, 5, 37, 0, true);             // UTC: 5:37 AM Local: 12:37 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 1, 4, 1, 0, true);              // UTC: 4:01 AM Local: 11:01 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 27, 11, 38, 0, true);           // UTC: 11:38 AM Local: 6:38 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 4, 15, 52, 0, true);            // UTC: 3:52 PM Local: 10:52 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 10, 21, 54, 0, true);           // UTC: 9:54 PM Local: 4:54 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 19, 17, 43, 0, true);           // UTC: 5:43 PM Local: 12:43 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 20, 20, 30, 0, true);           // UTC: 8:30 PM Local: 3:30 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 7, 22, 1, 0, true);             // UTC: 10:01 PM Local: 5:01 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 5, 4, 29, 0, true);             // UTC: 4:29 AM Local: 11:29 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 17, 13, 20, 0, true);           // UTC: 1:20 PM Local: 8:20 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 9, 8, 17, 43, 0, true);            // UTC: 5:43 PM Local: 12:43 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 22, 15, 33, 0, true);          // UTC: 3:33 PM Local: 10:33 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 7, 16, 48, 0, true);           // UTC: 4:48 PM Local: 11:48 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 16, 5, 4, 0, true);            // UTC: 5:04 AM Local: 12:04 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 15, 21, 0, 0, true);           // UTC: 9:00 PM Local: 4:00 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 12, 22, 57, 0, true);          // UTC: 10:57 PM Local: 5:57 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 2, 12, 37, 0, true);           // UTC: 12:37 PM Local: 7:37 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 27, 12, 7, 0, true);           // UTC: 12:07 PM Local: 7:07 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 16, 20, 14, 0, true);          // UTC: 8:14 PM Local: 3:14 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 17, 19, 1, 0, true);           // UTC: 7:01 PM Local: 2:01 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 15, 8, 53, 0, true);           // UTC: 8:53 AM Local: 3:53 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 8, 19, 55, 0, true);           // UTC: 7:55 PM Local: 2:55 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 5, 12, 16, 0, true);           // UTC: 12:16 PM Local: 7:16 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 10, 10, 2, 0, true);           // UTC: 10:02 AM Local: 5:02 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 26, 3, 39, 0, true);           // UTC: 3:39 AM Local: 10:39 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 12, 15, 3, 0, true);           // UTC: 3:03 PM Local: 10:03 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 1, 17, 11, 0, true);           // UTC: 5:11 PM Local: 12:11 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 15, 12, 1, 0, true);           // UTC: 12:01 PM Local: 7:01 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 20, 7, 10, 0, true);           // UTC: 7:10 AM Local: 2:10 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 17, 5, 45, 0, true);           // UTC: 5:45 AM Local: 12:45 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 9, 14, 51, 0, true);           // UTC: 2:51 PM Local: 9:51 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 22, 1, 50, 0, true);           // UTC: 1:50 AM Local: 8:50 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 5, 5, 4, 0, true);             // UTC: 5:04 AM Local: 12:04 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 2, 6, 25, 0, true);            // UTC: 6:25 AM Local: 1:25 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 19, 16, 5, 0, true);           // UTC: 4:05 PM Local: 11:05 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 10, 16, 0, 24, 0, true);           // UTC: 12:24 AM Local: 7:24 PM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 13, 3, 13, 0, false);          // UTC: 3:13 AM Local: 9:13 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 6, 13, 5, 0, false);           // UTC: 1:05 PM Local: 7:05 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 23, 22, 50, 0, false);         // UTC: 10:50 PM Local: 4:50 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 24, 13, 32, 0, false);         // UTC: 1:32 PM Local: 7:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 21, 12, 18, 0, false);         // UTC: 12:18 PM Local: 6:18 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 15, 0, 47, 0, false);          // UTC: 12:47 AM Local: 6:47 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 5, 3, 4, 0, false);            // UTC: 3:04 AM Local: 9:04 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 23, 6, 24, 0, false);          // UTC: 6:24 AM Local: 12:24 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 27, 22, 27, 0, false);         // UTC: 10:27 PM Local: 4:27 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 21, 19, 48, 0, false);         // UTC: 7:48 PM Local: 1:48 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 26, 3, 16, 0, false);          // UTC: 3:16 AM Local: 9:16 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 21, 3, 5, 0, false);           // UTC: 3:05 AM Local: 9:05 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 15, 2, 4, 0, false);           // UTC: 2:04 AM Local: 8:04 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 21, 22, 4, 0, false);          // UTC: 10:04 PM Local: 4:04 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 1, 6, 40, 0, true);            // UTC: 6:40 AM Local: 1:40 AM Offset: -05:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 15, 6, 42, 0, false);          // UTC: 6:42 AM Local: 12:42 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 3, 3, 39, 0, false);           // UTC: 3:39 AM Local: 9:39 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 8, 9, 53, 0, false);           // UTC: 9:53 AM Local: 3:53 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 10, 14, 50, 0, false);         // UTC: 2:50 PM Local: 8:50 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 22, 4, 35, 0, false);          // UTC: 4:35 AM Local: 10:35 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 17, 1, 8, 0, false);           // UTC: 1:08 AM Local: 7:08 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 1, 21, 25, 0, false);          // UTC: 9:25 PM Local: 3:25 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 8, 22, 23, 0, false);          // UTC: 10:23 PM Local: 4:23 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 6, 22, 53, 0, false);          // UTC: 10:53 PM Local: 4:53 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 11, 20, 9, 9, 0, false);           // UTC: 9:09 AM Local: 3:09 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 27, 18, 58, 0, false);         // UTC: 6:58 PM Local: 12:58 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 20, 10, 39, 0, false);         // UTC: 10:39 AM Local: 4:39 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 21, 15, 39, 0, false);         // UTC: 3:39 PM Local: 9:39 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 5, 15, 42, 0, false);          // UTC: 3:42 PM Local: 9:42 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 11, 9, 29, 0, false);          // UTC: 9:29 AM Local: 3:29 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 7, 16, 53, 0, false);          // UTC: 4:53 PM Local: 10:53 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 13, 3, 53, 0, false);          // UTC: 3:53 AM Local: 9:53 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 26, 22, 19, 0, false);         // UTC: 10:19 PM Local: 4:19 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 8, 5, 17, 0, false);           // UTC: 5:17 AM Local: 11:17 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 9, 20, 10, 0, false);          // UTC: 8:10 PM Local: 2:10 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 21, 12, 1, 0, false);          // UTC: 12:01 PM Local: 6:01 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 20, 7, 48, 0, false);          // UTC: 7:48 AM Local: 1:48 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 24, 1, 45, 0, false);          // UTC: 1:45 AM Local: 7:45 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 25, 20, 23, 0, false);         // UTC: 8:23 PM Local: 2:23 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 13, 20, 17, 0, false);         // UTC: 8:17 PM Local: 2:17 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 20, 20, 34, 0, false);         // UTC: 8:34 PM Local: 2:34 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 25, 22, 15, 0, false);         // UTC: 10:15 PM Local: 4:15 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 27, 5, 14, 0, false);          // UTC: 5:14 AM Local: 11:14 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 8, 1, 49, 0, false);           // UTC: 1:49 AM Local: 7:49 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 18, 10, 11, 0, false);         // UTC: 10:11 AM Local: 4:11 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 11, 10, 45, 0, false);         // UTC: 10:45 AM Local: 4:45 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 14, 8, 6, 0, false);           // UTC: 8:06 AM Local: 2:06 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 20, 14, 4, 0, false);          // UTC: 2:04 PM Local: 8:04 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 19, 8, 38, 0, false);          // UTC: 8:38 AM Local: 2:38 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 8, 2020, 12, 5, 12, 16, 0, false);          // UTC: 12:16 PM Local: 6:16 AM Offset: -06:00:00

	Serial.println(); Serial.print(failedCount); Serial.print(" of "); Serial.print(testCount); Serial.println(" test(s) failed.");
}
#endif
