#ifndef TEST_TIMEZONEID_7_H
#define TEST_TIMEZONEID_7_H

#include "TimeManager.h"
#include "TestHelper.h"

void run_TimeZoneId_7_Tests(const TimeManager& timeManager)
{
	uint16_t testCount = 0;
	uint16_t failedCount = 0;

	testCount++; failedCount += test(timeManager, 7, 2018, 1, 6, 18, 32, 0, false);           // UTC: 6:32 PM Local: 11:32 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 18, 9, 22, 0, false);           // UTC: 9:22 AM Local: 2:22 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 24, 6, 52, 0, false);           // UTC: 6:52 AM Local: 11:52 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 20, 21, 55, 0, false);          // UTC: 9:55 PM Local: 2:55 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 8, 4, 43, 0, false);            // UTC: 4:43 AM Local: 9:43 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 19, 20, 8, 0, false);           // UTC: 8:08 PM Local: 1:08 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 17, 2, 31, 0, false);           // UTC: 2:31 AM Local: 7:31 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 19, 10, 56, 0, false);          // UTC: 10:56 AM Local: 3:56 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 11, 7, 45, 0, false);           // UTC: 7:45 AM Local: 12:45 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 15, 0, 3, 0, false);            // UTC: 12:03 AM Local: 5:03 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 2, 11, 7, 0, false);            // UTC: 11:07 AM Local: 4:07 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 24, 2, 1, 0, false);            // UTC: 2:01 AM Local: 7:01 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 11, 16, 41, 0, false);          // UTC: 4:41 PM Local: 9:41 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 24, 10, 7, 0, false);           // UTC: 10:07 AM Local: 3:07 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 23, 22, 21, 0, false);          // UTC: 10:21 PM Local: 3:21 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 8, 13, 1, 0, false);            // UTC: 1:01 PM Local: 6:01 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 13, 9, 35, 0, false);           // UTC: 9:35 AM Local: 2:35 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 7, 13, 36, 0, false);           // UTC: 1:36 PM Local: 6:36 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 16, 11, 19, 0, false);          // UTC: 11:19 AM Local: 4:19 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 17, 5, 3, 0, false);            // UTC: 5:03 AM Local: 10:03 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 17, 7, 15, 0, false);           // UTC: 7:15 AM Local: 12:15 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 23, 15, 24, 0, false);          // UTC: 3:24 PM Local: 8:24 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 22, 9, 4, 0, false);            // UTC: 9:04 AM Local: 2:04 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 19, 7, 9, 0, false);            // UTC: 7:09 AM Local: 12:09 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 1, 12, 16, 37, 0, false);          // UTC: 4:37 PM Local: 9:37 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 11, 19, 28, 0, false);          // UTC: 7:28 PM Local: 12:28 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 17, 2, 45, 0, false);           // UTC: 2:45 AM Local: 7:45 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 20, 2, 36, 0, false);           // UTC: 2:36 AM Local: 7:36 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 13, 18, 53, 0, false);          // UTC: 6:53 PM Local: 11:53 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 15, 7, 36, 0, false);           // UTC: 7:36 AM Local: 12:36 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 19, 17, 28, 0, false);          // UTC: 5:28 PM Local: 10:28 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 18, 5, 8, 0, false);            // UTC: 5:08 AM Local: 10:08 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 24, 22, 19, 0, false);          // UTC: 10:19 PM Local: 3:19 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 26, 10, 8, 0, false);           // UTC: 10:08 AM Local: 3:08 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 26, 17, 4, 0, false);           // UTC: 5:04 PM Local: 10:04 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 13, 18, 50, 0, false);          // UTC: 6:50 PM Local: 11:50 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 27, 3, 37, 0, false);           // UTC: 3:37 AM Local: 8:37 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 23, 22, 7, 0, false);           // UTC: 10:07 PM Local: 3:07 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 8, 20, 12, 0, false);           // UTC: 8:12 PM Local: 1:12 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 18, 9, 49, 0, false);           // UTC: 9:49 AM Local: 2:49 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 14, 6, 6, 0, false);            // UTC: 6:06 AM Local: 11:06 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 13, 22, 31, 0, false);          // UTC: 10:31 PM Local: 3:31 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 19, 18, 28, 0, false);          // UTC: 6:28 PM Local: 11:28 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 14, 12, 51, 0, false);          // UTC: 12:51 PM Local: 5:51 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 5, 14, 39, 0, false);           // UTC: 2:39 PM Local: 7:39 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 17, 18, 20, 0, false);          // UTC: 6:20 PM Local: 11:20 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 15, 22, 1, 0, false);           // UTC: 10:01 PM Local: 3:01 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 2, 12, 8, 0, false);            // UTC: 12:08 PM Local: 5:08 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 27, 19, 45, 0, false);          // UTC: 7:45 PM Local: 12:45 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 2, 10, 8, 21, 0, false);           // UTC: 8:21 AM Local: 1:21 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 26, 5, 35, 0, true);            // UTC: 5:35 AM Local: 11:35 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 13, 10, 9, 0, true);            // UTC: 10:09 AM Local: 4:09 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 1, 11, 44, 0, false);           // UTC: 11:44 AM Local: 4:44 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 15, 17, 0, 0, true);            // UTC: 5:00 PM Local: 11:00 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 11, 11, 37, 0, true);           // UTC: 11:37 AM Local: 5:37 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 21, 15, 20, 0, true);           // UTC: 3:20 PM Local: 9:20 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 13, 15, 6, 0, true);            // UTC: 3:06 PM Local: 9:06 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 24, 2, 23, 0, true);            // UTC: 2:23 AM Local: 8:23 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 23, 10, 44, 0, true);           // UTC: 10:44 AM Local: 4:44 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 27, 11, 8, 0, true);            // UTC: 11:08 AM Local: 5:08 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 21, 7, 26, 0, true);            // UTC: 7:26 AM Local: 1:26 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 4, 12, 17, 0, false);           // UTC: 12:17 PM Local: 5:17 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 8, 15, 11, 0, false);           // UTC: 3:11 PM Local: 8:11 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 14, 13, 17, 0, true);           // UTC: 1:17 PM Local: 7:17 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 17, 0, 12, 0, true);            // UTC: 12:12 AM Local: 6:12 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 1, 15, 2, 0, false);            // UTC: 3:02 PM Local: 8:02 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 14, 4, 9, 0, true);             // UTC: 4:09 AM Local: 10:09 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 12, 21, 39, 0, true);           // UTC: 9:39 PM Local: 3:39 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 7, 1, 7, 0, false);             // UTC: 1:07 AM Local: 6:07 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 6, 15, 58, 0, false);           // UTC: 3:58 PM Local: 8:58 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 12, 1, 58, 0, true);            // UTC: 1:58 AM Local: 7:58 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 17, 17, 27, 0, true);           // UTC: 5:27 PM Local: 11:27 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 16, 5, 55, 0, true);            // UTC: 5:55 AM Local: 11:55 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 9, 11, 1, 0, false);            // UTC: 11:01 AM Local: 4:01 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 3, 5, 21, 4, 0, false);            // UTC: 9:04 PM Local: 2:04 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 22, 6, 5, 0, true);             // UTC: 6:05 AM Local: 12:05 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 5, 18, 46, 0, true);            // UTC: 6:46 PM Local: 12:46 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 20, 10, 16, 0, true);           // UTC: 10:16 AM Local: 4:16 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 27, 7, 23, 0, true);            // UTC: 7:23 AM Local: 1:23 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 21, 20, 28, 0, true);           // UTC: 8:28 PM Local: 2:28 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 5, 1, 0, 0, true);              // UTC: 1:00 AM Local: 7:00 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 6, 2, 31, 0, true);             // UTC: 2:31 AM Local: 8:31 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 9, 22, 13, 0, true);            // UTC: 10:13 PM Local: 4:13 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 21, 10, 24, 0, true);           // UTC: 10:24 AM Local: 4:24 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 3, 4, 41, 0, true);             // UTC: 4:41 AM Local: 10:41 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 4, 6, 58, 0, true);             // UTC: 6:58 AM Local: 12:58 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 17, 10, 47, 0, true);           // UTC: 10:47 AM Local: 4:47 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 2, 0, 50, 0, true);             // UTC: 12:50 AM Local: 6:50 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 6, 16, 36, 0, true);            // UTC: 4:36 PM Local: 10:36 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 20, 14, 25, 0, true);           // UTC: 2:25 PM Local: 8:25 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 3, 18, 22, 0, true);            // UTC: 6:22 PM Local: 12:22 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 13, 3, 24, 0, true);            // UTC: 3:24 AM Local: 9:24 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 1, 21, 49, 0, true);            // UTC: 9:49 PM Local: 3:49 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 15, 11, 16, 0, true);           // UTC: 11:16 AM Local: 5:16 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 24, 10, 20, 0, true);           // UTC: 10:20 AM Local: 4:20 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 10, 14, 15, 0, true);           // UTC: 2:15 PM Local: 8:15 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 16, 19, 4, 0, true);            // UTC: 7:04 PM Local: 1:04 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 12, 3, 25, 0, true);            // UTC: 3:25 AM Local: 9:25 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 19, 2, 3, 0, true);             // UTC: 2:03 AM Local: 8:03 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 4, 5, 22, 23, 0, true);            // UTC: 10:23 PM Local: 4:23 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 25, 13, 20, 0, true);           // UTC: 1:20 PM Local: 7:20 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 22, 15, 38, 0, true);           // UTC: 3:38 PM Local: 9:38 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 1, 14, 1, 0, true);             // UTC: 2:01 PM Local: 8:01 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 8, 3, 18, 0, true);             // UTC: 3:18 AM Local: 9:18 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 4, 0, 56, 0, true);             // UTC: 12:56 AM Local: 6:56 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 15, 3, 34, 0, true);            // UTC: 3:34 AM Local: 9:34 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 14, 19, 5, 0, true);            // UTC: 7:05 PM Local: 1:05 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 10, 3, 47, 0, true);            // UTC: 3:47 AM Local: 9:47 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 10, 15, 37, 0, true);           // UTC: 3:37 PM Local: 9:37 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 26, 18, 1, 0, true);            // UTC: 6:01 PM Local: 12:01 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 10, 19, 56, 0, true);           // UTC: 7:56 PM Local: 1:56 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 13, 14, 52, 0, true);           // UTC: 2:52 PM Local: 8:52 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 25, 1, 45, 0, true);            // UTC: 1:45 AM Local: 7:45 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 19, 7, 57, 0, true);            // UTC: 7:57 AM Local: 1:57 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 7, 6, 40, 0, true);             // UTC: 6:40 AM Local: 12:40 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 21, 6, 7, 0, true);             // UTC: 6:07 AM Local: 12:07 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 13, 3, 56, 0, true);            // UTC: 3:56 AM Local: 9:56 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 14, 15, 9, 0, true);            // UTC: 3:09 PM Local: 9:09 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 9, 12, 27, 0, true);            // UTC: 12:27 PM Local: 6:27 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 16, 9, 58, 0, true);            // UTC: 9:58 AM Local: 3:58 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 1, 1, 49, 0, true);             // UTC: 1:49 AM Local: 7:49 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 1, 21, 18, 0, true);            // UTC: 9:18 PM Local: 3:18 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 10, 16, 23, 0, true);           // UTC: 4:23 PM Local: 10:23 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 2, 13, 5, 0, true);             // UTC: 1:05 PM Local: 7:05 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 5, 22, 18, 29, 0, true);           // UTC: 6:29 PM Local: 12:29 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 3, 2, 50, 0, true);             // UTC: 2:50 AM Local: 8:50 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 3, 14, 24, 0, true);            // UTC: 2:24 PM Local: 8:24 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 14, 10, 37, 0, true);           // UTC: 10:37 AM Local: 4:37 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 3, 20, 9, 0, true);             // UTC: 8:09 PM Local: 2:09 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 22, 3, 4, 0, true);             // UTC: 3:04 AM Local: 9:04 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 12, 8, 38, 0, true);            // UTC: 8:38 AM Local: 2:38 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 21, 15, 14, 0, true);           // UTC: 3:14 PM Local: 9:14 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 4, 5, 20, 0, true);             // UTC: 5:20 AM Local: 11:20 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 11, 8, 33, 0, true);            // UTC: 8:33 AM Local: 2:33 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 20, 9, 32, 0, true);            // UTC: 9:32 AM Local: 3:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 24, 15, 51, 0, true);           // UTC: 3:51 PM Local: 9:51 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 18, 4, 25, 0, true);            // UTC: 4:25 AM Local: 10:25 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 17, 10, 48, 0, true);           // UTC: 10:48 AM Local: 4:48 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 16, 12, 36, 0, true);           // UTC: 12:36 PM Local: 6:36 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 6, 21, 3, 0, true);             // UTC: 9:03 PM Local: 3:03 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 4, 13, 32, 0, true);            // UTC: 1:32 PM Local: 7:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 9, 14, 14, 0, true);            // UTC: 2:14 PM Local: 8:14 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 13, 0, 7, 0, true);             // UTC: 12:07 AM Local: 6:07 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 7, 22, 53, 0, true);            // UTC: 10:53 PM Local: 4:53 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 14, 16, 13, 0, true);           // UTC: 4:13 PM Local: 10:13 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 23, 17, 3, 0, true);            // UTC: 5:03 PM Local: 11:03 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 3, 5, 11, 0, true);             // UTC: 5:11 AM Local: 11:11 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 9, 3, 56, 0, true);             // UTC: 3:56 AM Local: 9:56 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 18, 18, 53, 0, true);           // UTC: 6:53 PM Local: 12:53 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 6, 23, 4, 9, 0, true);             // UTC: 4:09 AM Local: 10:09 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 18, 21, 17, 0, true);           // UTC: 9:17 PM Local: 3:17 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 8, 5, 48, 0, true);             // UTC: 5:48 AM Local: 11:48 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 1, 9, 46, 0, true);             // UTC: 9:46 AM Local: 3:46 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 9, 9, 37, 0, true);             // UTC: 9:37 AM Local: 3:37 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 21, 9, 12, 0, true);            // UTC: 9:12 AM Local: 3:12 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 15, 2, 43, 0, true);            // UTC: 2:43 AM Local: 8:43 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 16, 17, 44, 0, true);           // UTC: 5:44 PM Local: 11:44 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 16, 2, 41, 0, true);            // UTC: 2:41 AM Local: 8:41 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 24, 19, 25, 0, true);           // UTC: 7:25 PM Local: 1:25 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 17, 15, 49, 0, true);           // UTC: 3:49 PM Local: 9:49 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 10, 13, 50, 0, true);           // UTC: 1:50 PM Local: 7:50 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 27, 14, 3, 0, true);            // UTC: 2:03 PM Local: 8:03 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 17, 4, 27, 0, true);            // UTC: 4:27 AM Local: 10:27 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 11, 19, 21, 0, true);           // UTC: 7:21 PM Local: 1:21 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 8, 18, 47, 0, true);            // UTC: 6:47 PM Local: 12:47 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 15, 12, 43, 0, true);           // UTC: 12:43 PM Local: 6:43 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 21, 2, 39, 0, true);            // UTC: 2:39 AM Local: 8:39 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 5, 5, 25, 0, true);             // UTC: 5:25 AM Local: 11:25 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 11, 1, 47, 0, true);            // UTC: 1:47 AM Local: 7:47 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 17, 9, 23, 0, true);            // UTC: 9:23 AM Local: 3:23 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 11, 9, 42, 0, true);            // UTC: 9:42 AM Local: 3:42 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 26, 22, 47, 0, true);           // UTC: 10:47 PM Local: 4:47 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 22, 17, 46, 0, true);           // UTC: 5:46 PM Local: 11:46 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 5, 21, 53, 0, true);            // UTC: 9:53 PM Local: 3:53 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 7, 8, 4, 53, 0, true);             // UTC: 4:53 AM Local: 10:53 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 11, 6, 19, 0, true);            // UTC: 6:19 AM Local: 12:19 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 24, 7, 16, 0, true);            // UTC: 7:16 AM Local: 1:16 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 19, 19, 33, 0, true);           // UTC: 7:33 PM Local: 1:33 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 5, 3, 21, 0, true);             // UTC: 3:21 AM Local: 9:21 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 12, 12, 31, 0, true);           // UTC: 12:31 PM Local: 6:31 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 7, 0, 47, 0, true);             // UTC: 12:47 AM Local: 6:47 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 2, 0, 25, 0, true);             // UTC: 12:25 AM Local: 6:25 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 18, 7, 48, 0, true);            // UTC: 7:48 AM Local: 1:48 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 1, 17, 45, 0, true);            // UTC: 5:45 PM Local: 11:45 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 26, 13, 11, 0, true);           // UTC: 1:11 PM Local: 7:11 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 21, 21, 3, 0, true);            // UTC: 9:03 PM Local: 3:03 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 15, 0, 46, 0, true);            // UTC: 12:46 AM Local: 6:46 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 13, 16, 5, 0, true);            // UTC: 4:05 PM Local: 10:05 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 4, 16, 32, 0, true);            // UTC: 4:32 PM Local: 10:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 4, 17, 47, 0, true);            // UTC: 5:47 PM Local: 11:47 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 13, 8, 12, 0, true);            // UTC: 8:12 AM Local: 2:12 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 7, 20, 54, 0, true);            // UTC: 8:54 PM Local: 2:54 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 3, 4, 9, 0, true);              // UTC: 4:09 AM Local: 10:09 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 14, 16, 56, 0, true);           // UTC: 4:56 PM Local: 10:56 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 14, 20, 32, 0, true);           // UTC: 8:32 PM Local: 2:32 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 14, 16, 16, 0, true);           // UTC: 4:16 PM Local: 10:16 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 11, 9, 14, 0, true);            // UTC: 9:14 AM Local: 3:14 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 8, 20, 31, 0, true);            // UTC: 8:31 PM Local: 2:31 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 21, 17, 16, 0, true);           // UTC: 5:16 PM Local: 11:16 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 8, 20, 21, 18, 0, true);           // UTC: 9:18 PM Local: 3:18 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 24, 11, 33, 0, true);           // UTC: 11:33 AM Local: 5:33 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 1, 12, 22, 0, true);            // UTC: 12:22 PM Local: 6:22 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 15, 16, 39, 0, true);           // UTC: 4:39 PM Local: 10:39 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 8, 15, 42, 0, true);            // UTC: 3:42 PM Local: 9:42 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 25, 0, 18, 0, true);            // UTC: 12:18 AM Local: 6:18 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 23, 22, 49, 0, true);           // UTC: 10:49 PM Local: 4:49 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 15, 13, 57, 0, true);           // UTC: 1:57 PM Local: 7:57 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 8, 17, 21, 0, true);            // UTC: 5:21 PM Local: 11:21 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 15, 3, 28, 0, true);            // UTC: 3:28 AM Local: 9:28 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 19, 11, 8, 0, true);            // UTC: 11:08 AM Local: 5:08 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 18, 9, 14, 0, true);            // UTC: 9:14 AM Local: 3:14 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 23, 14, 12, 0, true);           // UTC: 2:12 PM Local: 8:12 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 11, 10, 18, 0, true);           // UTC: 10:18 AM Local: 4:18 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 5, 22, 1, 0, true);             // UTC: 10:01 PM Local: 4:01 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 17, 2, 44, 0, true);            // UTC: 2:44 AM Local: 8:44 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 15, 8, 50, 0, true);            // UTC: 8:50 AM Local: 2:50 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 7, 21, 46, 0, true);            // UTC: 9:46 PM Local: 3:46 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 13, 3, 20, 0, true);            // UTC: 3:20 AM Local: 9:20 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 10, 13, 43, 0, true);           // UTC: 1:43 PM Local: 7:43 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 6, 10, 24, 0, true);            // UTC: 10:24 AM Local: 4:24 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 25, 19, 13, 0, true);           // UTC: 7:13 PM Local: 1:13 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 15, 14, 15, 0, true);           // UTC: 2:15 PM Local: 8:15 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 13, 1, 25, 0, true);            // UTC: 1:25 AM Local: 7:25 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 3, 9, 29, 0, true);             // UTC: 9:29 AM Local: 3:29 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 9, 14, 8, 37, 0, true);            // UTC: 8:37 AM Local: 2:37 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 26, 15, 37, 0, true);          // UTC: 3:37 PM Local: 9:37 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 17, 0, 45, 0, true);           // UTC: 12:45 AM Local: 6:45 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 18, 10, 31, 0, true);          // UTC: 10:31 AM Local: 4:31 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 10, 4, 13, 0, true);           // UTC: 4:13 AM Local: 10:13 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 25, 11, 1, 0, true);           // UTC: 11:01 AM Local: 5:01 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 13, 4, 0, 0, true);            // UTC: 4:00 AM Local: 10:00 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 25, 6, 5, 0, true);            // UTC: 6:05 AM Local: 12:05 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 22, 1, 29, 0, true);           // UTC: 1:29 AM Local: 7:29 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 14, 1, 19, 0, true);           // UTC: 1:19 AM Local: 7:19 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 12, 3, 31, 0, true);           // UTC: 3:31 AM Local: 9:31 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 8, 21, 47, 0, true);           // UTC: 9:47 PM Local: 3:47 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 20, 9, 53, 0, true);           // UTC: 9:53 AM Local: 3:53 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 3, 13, 26, 0, true);           // UTC: 1:26 PM Local: 7:26 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 18, 5, 23, 0, true);           // UTC: 5:23 AM Local: 11:23 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 19, 4, 25, 0, true);           // UTC: 4:25 AM Local: 10:25 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 1, 13, 33, 0, true);           // UTC: 1:33 PM Local: 7:33 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 11, 14, 12, 0, true);          // UTC: 2:12 PM Local: 8:12 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 14, 13, 4, 0, true);           // UTC: 1:04 PM Local: 7:04 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 15, 3, 36, 0, true);           // UTC: 3:36 AM Local: 9:36 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 4, 2, 57, 0, true);            // UTC: 2:57 AM Local: 8:57 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 12, 4, 19, 0, true);           // UTC: 4:19 AM Local: 10:19 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 1, 1, 14, 0, true);            // UTC: 1:14 AM Local: 7:14 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 12, 4, 5, 0, true);            // UTC: 4:05 AM Local: 10:05 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 3, 8, 36, 0, true);            // UTC: 8:36 AM Local: 2:36 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 10, 16, 6, 1, 0, true);            // UTC: 6:01 AM Local: 12:01 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 19, 2, 51, 0, false);          // UTC: 2:51 AM Local: 7:51 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 2, 10, 27, 0, true);           // UTC: 10:27 AM Local: 4:27 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 21, 0, 29, 0, false);          // UTC: 12:29 AM Local: 5:29 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 9, 17, 19, 0, false);          // UTC: 5:19 PM Local: 10:19 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 20, 3, 14, 0, false);          // UTC: 3:14 AM Local: 8:14 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 9, 22, 27, 0, false);          // UTC: 10:27 PM Local: 3:27 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 13, 4, 2, 0, false);           // UTC: 4:02 AM Local: 9:02 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 3, 15, 7, 0, true);            // UTC: 3:07 PM Local: 9:07 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 6, 14, 23, 0, false);          // UTC: 2:23 PM Local: 7:23 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 13, 6, 15, 0, false);          // UTC: 6:15 AM Local: 11:15 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 16, 21, 19, 0, false);         // UTC: 9:19 PM Local: 2:19 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 2, 19, 2, 0, true);            // UTC: 7:02 PM Local: 1:02 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 20, 1, 39, 0, false);          // UTC: 1:39 AM Local: 6:39 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 14, 15, 11, 0, false);         // UTC: 3:11 PM Local: 8:11 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 23, 15, 16, 0, false);         // UTC: 3:16 PM Local: 8:16 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 25, 15, 1, 0, false);          // UTC: 3:01 PM Local: 8:01 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 23, 18, 23, 0, false);         // UTC: 6:23 PM Local: 11:23 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 5, 2, 3, 0, false);            // UTC: 2:03 AM Local: 7:03 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 27, 14, 25, 0, false);         // UTC: 2:25 PM Local: 7:25 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 21, 20, 49, 0, false);         // UTC: 8:49 PM Local: 1:49 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 2, 6, 43, 0, true);            // UTC: 6:43 AM Local: 12:43 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 7, 17, 49, 0, false);          // UTC: 5:49 PM Local: 10:49 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 1, 15, 18, 0, true);           // UTC: 3:18 PM Local: 9:18 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 6, 13, 52, 0, false);          // UTC: 1:52 PM Local: 6:52 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 11, 22, 21, 31, 0, false);         // UTC: 9:31 PM Local: 2:31 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 24, 5, 58, 0, false);          // UTC: 5:58 AM Local: 10:58 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 23, 6, 54, 0, false);          // UTC: 6:54 AM Local: 11:54 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 11, 14, 28, 0, false);         // UTC: 2:28 PM Local: 7:28 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 24, 9, 50, 0, false);          // UTC: 9:50 AM Local: 2:50 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 8, 2, 14, 0, false);           // UTC: 2:14 AM Local: 7:14 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 17, 22, 12, 0, false);         // UTC: 10:12 PM Local: 3:12 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 23, 10, 22, 0, false);         // UTC: 10:22 AM Local: 3:22 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 13, 13, 55, 0, false);         // UTC: 1:55 PM Local: 6:55 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 13, 20, 1, 0, false);          // UTC: 8:01 PM Local: 1:01 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 20, 14, 13, 0, false);         // UTC: 2:13 PM Local: 7:13 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 14, 8, 8, 0, false);           // UTC: 8:08 AM Local: 1:08 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 15, 2, 21, 0, false);          // UTC: 2:21 AM Local: 7:21 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 13, 21, 34, 0, false);         // UTC: 9:34 PM Local: 2:34 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 25, 15, 38, 0, false);         // UTC: 3:38 PM Local: 8:38 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 7, 8, 18, 0, false);           // UTC: 8:18 AM Local: 1:18 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 27, 17, 33, 0, false);         // UTC: 5:33 PM Local: 10:33 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 3, 14, 35, 0, false);          // UTC: 2:35 PM Local: 7:35 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 19, 22, 29, 0, false);         // UTC: 10:29 PM Local: 3:29 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 4, 9, 40, 0, false);           // UTC: 9:40 AM Local: 2:40 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 2, 8, 22, 0, false);           // UTC: 8:22 AM Local: 1:22 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 25, 15, 0, 0, false);          // UTC: 3:00 PM Local: 8:00 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 7, 8, 3, 0, false);            // UTC: 8:03 AM Local: 1:03 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 20, 16, 57, 0, false);         // UTC: 4:57 PM Local: 9:57 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 24, 3, 2, 0, false);           // UTC: 3:02 AM Local: 8:02 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2018, 12, 17, 21, 45, 0, false);         // UTC: 9:45 PM Local: 2:45 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 20, 4, 10, 0, false);           // UTC: 4:10 AM Local: 9:10 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 17, 10, 9, 0, false);           // UTC: 10:09 AM Local: 3:09 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 13, 14, 0, 0, false);           // UTC: 2:00 PM Local: 7:00 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 18, 18, 23, 0, false);          // UTC: 6:23 PM Local: 11:23 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 18, 8, 42, 0, false);           // UTC: 8:42 AM Local: 1:42 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 19, 9, 32, 0, false);           // UTC: 9:32 AM Local: 2:32 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 6, 0, 0, 0, false);             // UTC: 12:00 AM Local: 5:00 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 18, 22, 2, 0, false);           // UTC: 10:02 PM Local: 3:02 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 7, 6, 0, 0, false);             // UTC: 6:00 AM Local: 11:00 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 17, 4, 27, 0, false);           // UTC: 4:27 AM Local: 9:27 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 15, 1, 3, 0, false);            // UTC: 1:03 AM Local: 6:03 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 20, 9, 10, 0, false);           // UTC: 9:10 AM Local: 2:10 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 14, 9, 53, 0, false);           // UTC: 9:53 AM Local: 2:53 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 7, 9, 2, 0, false);             // UTC: 9:02 AM Local: 2:02 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 1, 13, 31, 0, false);           // UTC: 1:31 PM Local: 6:31 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 19, 1, 20, 0, false);           // UTC: 1:20 AM Local: 6:20 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 7, 4, 44, 0, false);            // UTC: 4:44 AM Local: 9:44 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 14, 9, 53, 0, false);           // UTC: 9:53 AM Local: 2:53 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 21, 2, 13, 0, false);           // UTC: 2:13 AM Local: 7:13 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 5, 8, 12, 0, false);            // UTC: 8:12 AM Local: 1:12 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 5, 19, 25, 0, false);           // UTC: 7:25 PM Local: 12:25 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 15, 2, 45, 0, false);           // UTC: 2:45 AM Local: 7:45 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 10, 21, 57, 0, false);          // UTC: 9:57 PM Local: 2:57 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 15, 4, 58, 0, false);           // UTC: 4:58 AM Local: 9:58 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 1, 18, 22, 34, 0, false);          // UTC: 10:34 PM Local: 3:34 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 27, 14, 22, 0, false);          // UTC: 2:22 PM Local: 7:22 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 14, 13, 12, 0, false);          // UTC: 1:12 PM Local: 6:12 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 18, 7, 0, 0, false);            // UTC: 7:00 AM Local: 12:00 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 20, 0, 37, 0, false);           // UTC: 12:37 AM Local: 5:37 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 5, 22, 19, 0, false);           // UTC: 10:19 PM Local: 3:19 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 26, 7, 2, 0, false);            // UTC: 7:02 AM Local: 12:02 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 19, 1, 33, 0, false);           // UTC: 1:33 AM Local: 6:33 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 17, 10, 30, 0, false);          // UTC: 10:30 AM Local: 3:30 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 21, 7, 9, 0, false);            // UTC: 7:09 AM Local: 12:09 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 11, 16, 0, 0, false);           // UTC: 4:00 PM Local: 9:00 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 21, 19, 27, 0, false);          // UTC: 7:27 PM Local: 12:27 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 9, 18, 26, 0, false);           // UTC: 6:26 PM Local: 11:26 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 23, 14, 47, 0, false);          // UTC: 2:47 PM Local: 7:47 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 1, 11, 30, 0, false);           // UTC: 11:30 AM Local: 4:30 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 12, 19, 3, 0, false);           // UTC: 7:03 PM Local: 12:03 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 4, 4, 55, 0, false);            // UTC: 4:55 AM Local: 9:55 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 18, 13, 49, 0, false);          // UTC: 1:49 PM Local: 6:49 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 26, 21, 52, 0, false);          // UTC: 9:52 PM Local: 2:52 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 1, 8, 10, 0, false);            // UTC: 8:10 AM Local: 1:10 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 24, 17, 14, 0, false);          // UTC: 5:14 PM Local: 10:14 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 2, 6, 37, 0, false);            // UTC: 6:37 AM Local: 11:37 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 27, 21, 10, 0, false);          // UTC: 9:10 PM Local: 2:10 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 5, 19, 10, 0, false);           // UTC: 7:10 PM Local: 12:10 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 24, 2, 41, 0, false);           // UTC: 2:41 AM Local: 7:41 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 2, 7, 15, 34, 0, false);           // UTC: 3:34 PM Local: 8:34 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 2, 4, 36, 0, false);            // UTC: 4:36 AM Local: 9:36 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 13, 14, 8, 0, true);            // UTC: 2:08 PM Local: 8:08 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 6, 16, 7, 0, false);            // UTC: 4:07 PM Local: 9:07 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 5, 18, 53, 0, false);           // UTC: 6:53 PM Local: 11:53 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 16, 6, 25, 0, true);            // UTC: 6:25 AM Local: 12:25 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 8, 22, 52, 0, false);           // UTC: 10:52 PM Local: 3:52 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 15, 21, 12, 0, true);           // UTC: 9:12 PM Local: 3:12 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 24, 9, 52, 0, true);            // UTC: 9:52 AM Local: 3:52 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 24, 22, 21, 0, true);           // UTC: 10:21 PM Local: 4:21 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 21, 18, 27, 0, true);           // UTC: 6:27 PM Local: 12:27 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 4, 16, 15, 0, false);           // UTC: 4:15 PM Local: 9:15 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 9, 22, 10, 0, false);           // UTC: 10:10 PM Local: 3:10 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 16, 9, 7, 0, true);             // UTC: 9:07 AM Local: 3:07 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 3, 19, 32, 0, false);           // UTC: 7:32 PM Local: 12:32 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 14, 19, 8, 0, true);            // UTC: 7:08 PM Local: 1:08 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 8, 13, 31, 0, false);           // UTC: 1:31 PM Local: 6:31 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 21, 13, 9, 0, true);            // UTC: 1:09 PM Local: 7:09 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 22, 15, 43, 0, true);           // UTC: 3:43 PM Local: 9:43 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 10, 3, 43, 0, false);           // UTC: 3:43 AM Local: 8:43 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 20, 13, 38, 0, true);           // UTC: 1:38 PM Local: 7:38 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 22, 10, 55, 0, true);           // UTC: 10:55 AM Local: 4:55 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 18, 0, 5, 0, true);             // UTC: 12:05 AM Local: 6:05 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 18, 6, 19, 0, true);            // UTC: 6:19 AM Local: 12:19 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 7, 16, 31, 0, false);           // UTC: 4:31 PM Local: 9:31 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 3, 21, 10, 6, 0, true);            // UTC: 10:06 AM Local: 4:06 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 18, 8, 35, 0, true);            // UTC: 8:35 AM Local: 2:35 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 20, 14, 23, 0, true);           // UTC: 2:23 PM Local: 8:23 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 23, 0, 11, 0, true);            // UTC: 12:11 AM Local: 6:11 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 8, 7, 1, 0, true);              // UTC: 7:01 AM Local: 1:01 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 14, 21, 48, 0, true);           // UTC: 9:48 PM Local: 3:48 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 12, 19, 50, 0, true);           // UTC: 7:50 PM Local: 1:50 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 13, 7, 23, 0, true);            // UTC: 7:23 AM Local: 1:23 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 17, 19, 47, 0, true);           // UTC: 7:47 PM Local: 1:47 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 2, 13, 17, 0, true);            // UTC: 1:17 PM Local: 7:17 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 6, 11, 52, 0, true);            // UTC: 11:52 AM Local: 5:52 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 18, 0, 13, 0, true);            // UTC: 12:13 AM Local: 6:13 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 18, 16, 46, 0, true);           // UTC: 4:46 PM Local: 10:46 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 4, 22, 56, 0, true);            // UTC: 10:56 PM Local: 4:56 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 7, 21, 25, 0, true);            // UTC: 9:25 PM Local: 3:25 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 21, 8, 41, 0, true);            // UTC: 8:41 AM Local: 2:41 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 2, 3, 19, 0, true);             // UTC: 3:19 AM Local: 9:19 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 14, 18, 51, 0, true);           // UTC: 6:51 PM Local: 12:51 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 19, 6, 7, 0, true);             // UTC: 6:07 AM Local: 12:07 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 20, 1, 30, 0, true);            // UTC: 1:30 AM Local: 7:30 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 22, 15, 0, 0, true);            // UTC: 3:00 PM Local: 9:00 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 3, 14, 30, 0, true);            // UTC: 2:30 PM Local: 8:30 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 9, 15, 17, 0, true);            // UTC: 3:17 PM Local: 9:17 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 22, 20, 14, 0, true);           // UTC: 8:14 PM Local: 2:14 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 1, 6, 49, 0, true);             // UTC: 6:49 AM Local: 12:49 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 4, 24, 5, 21, 0, true);            // UTC: 5:21 AM Local: 11:21 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 27, 19, 27, 0, true);           // UTC: 7:27 PM Local: 1:27 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 3, 22, 27, 0, true);            // UTC: 10:27 PM Local: 4:27 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 27, 15, 41, 0, true);           // UTC: 3:41 PM Local: 9:41 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 1, 21, 42, 0, true);            // UTC: 9:42 PM Local: 3:42 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 3, 21, 37, 0, true);            // UTC: 9:37 PM Local: 3:37 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 8, 7, 18, 0, true);             // UTC: 7:18 AM Local: 1:18 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 26, 3, 18, 0, true);            // UTC: 3:18 AM Local: 9:18 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 25, 10, 42, 0, true);           // UTC: 10:42 AM Local: 4:42 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 11, 6, 15, 0, true);            // UTC: 6:15 AM Local: 12:15 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 3, 11, 29, 0, true);            // UTC: 11:29 AM Local: 5:29 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 1, 18, 4, 0, true);             // UTC: 6:04 PM Local: 12:04 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 21, 17, 12, 0, true);           // UTC: 5:12 PM Local: 11:12 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 2, 16, 41, 0, true);            // UTC: 4:41 PM Local: 10:41 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 15, 3, 55, 0, true);            // UTC: 3:55 AM Local: 9:55 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 22, 6, 41, 0, true);            // UTC: 6:41 AM Local: 12:41 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 16, 15, 57, 0, true);           // UTC: 3:57 PM Local: 9:57 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 17, 17, 55, 0, true);           // UTC: 5:55 PM Local: 11:55 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 15, 21, 4, 0, true);            // UTC: 9:04 PM Local: 3:04 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 2, 1, 23, 0, true);             // UTC: 1:23 AM Local: 7:23 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 21, 15, 41, 0, true);           // UTC: 3:41 PM Local: 9:41 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 6, 19, 12, 0, true);            // UTC: 7:12 PM Local: 1:12 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 6, 22, 8, 0, true);             // UTC: 10:08 PM Local: 4:08 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 18, 7, 9, 0, true);             // UTC: 7:09 AM Local: 1:09 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 12, 4, 38, 0, true);            // UTC: 4:38 AM Local: 10:38 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 5, 17, 9, 0, 0, true);             // UTC: 9:00 AM Local: 3:00 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 10, 2, 9, 0, true);             // UTC: 2:09 AM Local: 8:09 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 1, 19, 34, 0, true);            // UTC: 7:34 PM Local: 1:34 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 9, 11, 41, 0, true);            // UTC: 11:41 AM Local: 5:41 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 16, 11, 51, 0, true);           // UTC: 11:51 AM Local: 5:51 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 27, 16, 41, 0, true);           // UTC: 4:41 PM Local: 10:41 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 22, 6, 0, 0, true);             // UTC: 6:00 AM Local: 12:00 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 1, 7, 16, 0, true);             // UTC: 7:16 AM Local: 1:16 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 20, 14, 17, 0, true);           // UTC: 2:17 PM Local: 8:17 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 16, 21, 20, 0, true);           // UTC: 9:20 PM Local: 3:20 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 22, 3, 33, 0, true);            // UTC: 3:33 AM Local: 9:33 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 9, 21, 30, 0, true);            // UTC: 9:30 PM Local: 3:30 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 3, 15, 55, 0, true);            // UTC: 3:55 PM Local: 9:55 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 7, 17, 50, 0, true);            // UTC: 5:50 PM Local: 11:50 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 4, 20, 21, 0, true);            // UTC: 8:21 PM Local: 2:21 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 14, 14, 29, 0, true);           // UTC: 2:29 PM Local: 8:29 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 8, 15, 36, 0, true);            // UTC: 3:36 PM Local: 9:36 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 13, 14, 53, 0, true);           // UTC: 2:53 PM Local: 8:53 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 18, 13, 3, 0, true);            // UTC: 1:03 PM Local: 7:03 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 20, 14, 29, 0, true);           // UTC: 2:29 PM Local: 8:29 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 24, 10, 54, 0, true);           // UTC: 10:54 AM Local: 4:54 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 7, 11, 19, 0, true);            // UTC: 11:19 AM Local: 5:19 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 4, 5, 33, 0, true);             // UTC: 5:33 AM Local: 11:33 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 10, 21, 1, 0, true);            // UTC: 9:01 PM Local: 3:01 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 21, 12, 32, 0, true);           // UTC: 12:32 PM Local: 6:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 6, 4, 20, 26, 0, true);            // UTC: 8:26 PM Local: 2:26 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 25, 5, 57, 0, true);            // UTC: 5:57 AM Local: 11:57 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 22, 6, 15, 0, true);            // UTC: 6:15 AM Local: 12:15 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 20, 7, 31, 0, true);            // UTC: 7:31 AM Local: 1:31 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 18, 14, 20, 0, true);           // UTC: 2:20 PM Local: 8:20 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 13, 7, 3, 0, true);             // UTC: 7:03 AM Local: 1:03 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 12, 8, 17, 0, true);            // UTC: 8:17 AM Local: 2:17 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 26, 20, 23, 0, true);           // UTC: 8:23 PM Local: 2:23 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 2, 8, 22, 0, true);             // UTC: 8:22 AM Local: 2:22 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 26, 21, 43, 0, true);           // UTC: 9:43 PM Local: 3:43 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 17, 16, 3, 0, true);            // UTC: 4:03 PM Local: 10:03 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 10, 11, 40, 0, true);           // UTC: 11:40 AM Local: 5:40 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 17, 19, 22, 0, true);           // UTC: 7:22 PM Local: 1:22 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 15, 1, 9, 0, true);             // UTC: 1:09 AM Local: 7:09 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 18, 11, 10, 0, true);           // UTC: 11:10 AM Local: 5:10 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 22, 11, 36, 0, true);           // UTC: 11:36 AM Local: 5:36 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 6, 20, 33, 0, true);            // UTC: 8:33 PM Local: 2:33 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 27, 7, 11, 0, true);            // UTC: 7:11 AM Local: 1:11 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 7, 4, 0, 0, true);              // UTC: 4:00 AM Local: 10:00 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 2, 19, 51, 0, true);            // UTC: 7:51 PM Local: 1:51 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 16, 20, 20, 0, true);           // UTC: 8:20 PM Local: 2:20 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 14, 3, 36, 0, true);            // UTC: 3:36 AM Local: 9:36 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 13, 6, 8, 0, true);             // UTC: 6:08 AM Local: 12:08 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 19, 19, 30, 0, true);           // UTC: 7:30 PM Local: 1:30 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 18, 20, 18, 0, true);           // UTC: 8:18 PM Local: 2:18 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 7, 4, 6, 22, 0, true);             // UTC: 6:22 AM Local: 12:22 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 7, 5, 51, 0, true);             // UTC: 5:51 AM Local: 11:51 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 21, 16, 1, 0, true);            // UTC: 4:01 PM Local: 10:01 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 5, 14, 22, 0, true);            // UTC: 2:22 PM Local: 8:22 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 24, 2, 17, 0, true);            // UTC: 2:17 AM Local: 8:17 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 19, 13, 57, 0, true);           // UTC: 1:57 PM Local: 7:57 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 14, 21, 11, 0, true);           // UTC: 9:11 PM Local: 3:11 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 22, 3, 21, 0, true);            // UTC: 3:21 AM Local: 9:21 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 15, 7, 11, 0, true);            // UTC: 7:11 AM Local: 1:11 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 13, 12, 4, 0, true);            // UTC: 12:04 PM Local: 6:04 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 2, 7, 25, 0, true);             // UTC: 7:25 AM Local: 1:25 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 24, 2, 55, 0, true);            // UTC: 2:55 AM Local: 8:55 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 18, 18, 36, 0, true);           // UTC: 6:36 PM Local: 12:36 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 1, 18, 9, 0, true);             // UTC: 6:09 PM Local: 12:09 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 9, 7, 30, 0, true);             // UTC: 7:30 AM Local: 1:30 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 7, 13, 9, 0, true);             // UTC: 1:09 PM Local: 7:09 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 24, 22, 15, 0, true);           // UTC: 10:15 PM Local: 4:15 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 15, 3, 56, 0, true);            // UTC: 3:56 AM Local: 9:56 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 4, 7, 7, 0, true);              // UTC: 7:07 AM Local: 1:07 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 1, 15, 54, 0, true);            // UTC: 3:54 PM Local: 9:54 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 18, 7, 10, 0, true);            // UTC: 7:10 AM Local: 1:10 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 26, 2, 18, 0, true);            // UTC: 2:18 AM Local: 8:18 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 26, 22, 1, 0, true);            // UTC: 10:01 PM Local: 4:01 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 10, 0, 44, 0, true);            // UTC: 12:44 AM Local: 6:44 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 10, 11, 6, 0, true);            // UTC: 11:06 AM Local: 5:06 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 8, 2, 10, 47, 0, true);            // UTC: 10:47 AM Local: 4:47 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 24, 6, 42, 0, true);            // UTC: 6:42 AM Local: 12:42 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 2, 13, 32, 0, true);            // UTC: 1:32 PM Local: 7:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 22, 11, 8, 0, true);            // UTC: 11:08 AM Local: 5:08 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 13, 17, 45, 0, true);           // UTC: 5:45 PM Local: 11:45 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 23, 14, 7, 0, true);            // UTC: 2:07 PM Local: 8:07 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 19, 7, 30, 0, true);            // UTC: 7:30 AM Local: 1:30 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 27, 8, 13, 0, true);            // UTC: 8:13 AM Local: 2:13 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 6, 6, 36, 0, true);             // UTC: 6:36 AM Local: 12:36 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 4, 11, 56, 0, true);            // UTC: 11:56 AM Local: 5:56 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 14, 4, 38, 0, true);            // UTC: 4:38 AM Local: 10:38 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 23, 1, 50, 0, true);            // UTC: 1:50 AM Local: 7:50 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 9, 3, 22, 0, true);             // UTC: 3:22 AM Local: 9:22 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 6, 14, 41, 0, true);            // UTC: 2:41 PM Local: 8:41 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 17, 3, 35, 0, true);            // UTC: 3:35 AM Local: 9:35 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 5, 11, 12, 0, true);            // UTC: 11:12 AM Local: 5:12 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 7, 12, 24, 0, true);            // UTC: 12:24 PM Local: 6:24 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 17, 14, 9, 0, true);            // UTC: 2:09 PM Local: 8:09 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 17, 1, 6, 0, true);             // UTC: 1:06 AM Local: 7:06 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 16, 15, 58, 0, true);           // UTC: 3:58 PM Local: 9:58 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 3, 20, 5, 0, true);             // UTC: 8:05 PM Local: 2:05 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 16, 6, 18, 0, true);            // UTC: 6:18 AM Local: 12:18 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 14, 14, 41, 0, true);           // UTC: 2:41 PM Local: 8:41 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 25, 11, 27, 0, true);           // UTC: 11:27 AM Local: 5:27 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 21, 11, 42, 0, true);           // UTC: 11:42 AM Local: 5:42 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 9, 23, 8, 13, 0, true);            // UTC: 8:13 AM Local: 2:13 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 18, 0, 48, 0, true);           // UTC: 12:48 AM Local: 6:48 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 12, 20, 58, 0, true);          // UTC: 8:58 PM Local: 2:58 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 15, 20, 32, 0, true);          // UTC: 8:32 PM Local: 2:32 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 14, 5, 1, 0, true);            // UTC: 5:01 AM Local: 11:01 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 21, 16, 29, 0, true);          // UTC: 4:29 PM Local: 10:29 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 11, 2, 43, 0, true);           // UTC: 2:43 AM Local: 8:43 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 17, 0, 49, 0, true);           // UTC: 12:49 AM Local: 6:49 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 8, 15, 50, 0, true);           // UTC: 3:50 PM Local: 9:50 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 14, 8, 0, 0, true);            // UTC: 8:00 AM Local: 2:00 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 26, 20, 8, 0, true);           // UTC: 8:08 PM Local: 2:08 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 12, 17, 40, 0, true);          // UTC: 5:40 PM Local: 11:40 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 24, 21, 37, 0, true);          // UTC: 9:37 PM Local: 3:37 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 5, 15, 0, 0, true);            // UTC: 3:00 PM Local: 9:00 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 4, 0, 24, 0, true);            // UTC: 12:24 AM Local: 6:24 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 21, 22, 21, 0, true);          // UTC: 10:21 PM Local: 4:21 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 19, 3, 45, 0, true);           // UTC: 3:45 AM Local: 9:45 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 26, 8, 24, 0, true);           // UTC: 8:24 AM Local: 2:24 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 27, 4, 18, 0, true);           // UTC: 4:18 AM Local: 10:18 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 11, 8, 21, 0, true);           // UTC: 8:21 AM Local: 2:21 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 26, 20, 31, 0, true);          // UTC: 8:31 PM Local: 2:31 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 27, 13, 0, 0, true);           // UTC: 1:00 PM Local: 7:00 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 12, 1, 27, 0, true);           // UTC: 1:27 AM Local: 7:27 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 9, 20, 47, 0, true);           // UTC: 8:47 PM Local: 2:47 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 24, 4, 23, 0, true);           // UTC: 4:23 AM Local: 10:23 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 10, 20, 11, 58, 0, true);          // UTC: 11:58 AM Local: 5:58 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 12, 11, 39, 0, false);         // UTC: 11:39 AM Local: 4:39 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 14, 18, 11, 0, false);         // UTC: 6:11 PM Local: 11:11 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 7, 22, 30, 0, false);          // UTC: 10:30 PM Local: 3:30 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 20, 10, 33, 0, false);         // UTC: 10:33 AM Local: 3:33 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 11, 11, 33, 0, false);         // UTC: 11:33 AM Local: 4:33 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 8, 5, 46, 0, false);           // UTC: 5:46 AM Local: 10:46 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 13, 3, 27, 0, false);          // UTC: 3:27 AM Local: 8:27 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 12, 8, 55, 0, false);          // UTC: 8:55 AM Local: 1:55 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 25, 8, 15, 0, false);          // UTC: 8:15 AM Local: 1:15 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 27, 2, 8, 0, false);           // UTC: 2:08 AM Local: 7:08 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 1, 5, 42, 0, true);            // UTC: 5:42 AM Local: 11:42 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 9, 21, 50, 0, false);          // UTC: 9:50 PM Local: 2:50 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 19, 10, 5, 0, false);          // UTC: 10:05 AM Local: 3:05 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 10, 16, 34, 0, false);         // UTC: 4:34 PM Local: 9:34 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 14, 15, 34, 0, false);         // UTC: 3:34 PM Local: 8:34 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 25, 21, 22, 0, false);         // UTC: 9:22 PM Local: 2:22 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 7, 13, 58, 0, false);          // UTC: 1:58 PM Local: 6:58 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 17, 6, 20, 0, false);          // UTC: 6:20 AM Local: 11:20 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 15, 0, 8, 0, false);           // UTC: 12:08 AM Local: 5:08 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 20, 13, 27, 0, false);         // UTC: 1:27 PM Local: 6:27 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 26, 6, 53, 0, false);          // UTC: 6:53 AM Local: 11:53 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 10, 16, 12, 0, false);         // UTC: 4:12 PM Local: 9:12 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 24, 1, 32, 0, false);          // UTC: 1:32 AM Local: 6:32 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 20, 12, 45, 0, false);         // UTC: 12:45 PM Local: 5:45 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 11, 19, 3, 24, 0, false);          // UTC: 3:24 AM Local: 8:24 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 24, 21, 39, 0, false);         // UTC: 9:39 PM Local: 2:39 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 10, 0, 23, 0, false);          // UTC: 12:23 AM Local: 5:23 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 25, 16, 28, 0, false);         // UTC: 4:28 PM Local: 9:28 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 5, 9, 58, 0, false);           // UTC: 9:58 AM Local: 2:58 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 10, 18, 55, 0, false);         // UTC: 6:55 PM Local: 11:55 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 20, 22, 50, 0, false);         // UTC: 10:50 PM Local: 3:50 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 17, 9, 26, 0, false);          // UTC: 9:26 AM Local: 2:26 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 19, 3, 58, 0, false);          // UTC: 3:58 AM Local: 8:58 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 11, 1, 53, 0, false);          // UTC: 1:53 AM Local: 6:53 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 23, 12, 2, 0, false);          // UTC: 12:02 PM Local: 5:02 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 6, 21, 7, 0, false);           // UTC: 9:07 PM Local: 2:07 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 26, 15, 5, 0, false);          // UTC: 3:05 PM Local: 8:05 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 13, 8, 34, 0, false);          // UTC: 8:34 AM Local: 1:34 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 3, 0, 31, 0, false);           // UTC: 12:31 AM Local: 5:31 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 12, 4, 17, 0, false);          // UTC: 4:17 AM Local: 9:17 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 7, 11, 15, 0, false);          // UTC: 11:15 AM Local: 4:15 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 17, 22, 34, 0, false);         // UTC: 10:34 PM Local: 3:34 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 25, 1, 43, 0, false);          // UTC: 1:43 AM Local: 6:43 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 26, 4, 45, 0, false);          // UTC: 4:45 AM Local: 9:45 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 19, 22, 56, 0, false);         // UTC: 10:56 PM Local: 3:56 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 14, 1, 12, 0, false);          // UTC: 1:12 AM Local: 6:12 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 13, 21, 28, 0, false);         // UTC: 9:28 PM Local: 2:28 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 24, 10, 8, 0, false);          // UTC: 10:08 AM Local: 3:08 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 23, 6, 34, 0, false);          // UTC: 6:34 AM Local: 11:34 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2019, 12, 8, 12, 21, 0, false);          // UTC: 12:21 PM Local: 5:21 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 25, 6, 55, 0, false);           // UTC: 6:55 AM Local: 11:55 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 19, 3, 33, 0, false);           // UTC: 3:33 AM Local: 8:33 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 18, 5, 31, 0, false);           // UTC: 5:31 AM Local: 10:31 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 13, 7, 49, 0, false);           // UTC: 7:49 AM Local: 12:49 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 11, 22, 26, 0, false);          // UTC: 10:26 PM Local: 3:26 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 9, 17, 24, 0, false);           // UTC: 5:24 PM Local: 10:24 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 18, 13, 58, 0, false);          // UTC: 1:58 PM Local: 6:58 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 9, 22, 14, 0, false);           // UTC: 10:14 PM Local: 3:14 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 23, 8, 2, 0, false);            // UTC: 8:02 AM Local: 1:02 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 4, 17, 42, 0, false);           // UTC: 5:42 PM Local: 10:42 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 1, 14, 32, 0, false);           // UTC: 2:32 PM Local: 7:32 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 10, 0, 55, 0, false);           // UTC: 12:55 AM Local: 5:55 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 23, 0, 48, 0, false);           // UTC: 12:48 AM Local: 5:48 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 11, 19, 48, 0, false);          // UTC: 7:48 PM Local: 12:48 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 19, 22, 36, 0, false);          // UTC: 10:36 PM Local: 3:36 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 18, 10, 27, 0, false);          // UTC: 10:27 AM Local: 3:27 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 19, 11, 28, 0, false);          // UTC: 11:28 AM Local: 4:28 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 5, 14, 56, 0, false);           // UTC: 2:56 PM Local: 7:56 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 11, 13, 17, 0, false);          // UTC: 1:17 PM Local: 6:17 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 19, 19, 45, 0, false);          // UTC: 7:45 PM Local: 12:45 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 14, 12, 27, 0, false);          // UTC: 12:27 PM Local: 5:27 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 23, 10, 40, 0, false);          // UTC: 10:40 AM Local: 3:40 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 8, 0, 54, 0, false);            // UTC: 12:54 AM Local: 5:54 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 15, 11, 45, 0, false);          // UTC: 11:45 AM Local: 4:45 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 1, 16, 5, 43, 0, false);           // UTC: 5:43 AM Local: 10:43 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 5, 14, 56, 0, false);           // UTC: 2:56 PM Local: 7:56 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 17, 4, 53, 0, false);           // UTC: 4:53 AM Local: 9:53 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 16, 10, 14, 0, false);          // UTC: 10:14 AM Local: 3:14 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 7, 18, 58, 0, false);           // UTC: 6:58 PM Local: 11:58 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 17, 22, 25, 0, false);          // UTC: 10:25 PM Local: 3:25 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 17, 3, 8, 0, false);            // UTC: 3:08 AM Local: 8:08 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 2, 20, 18, 0, false);           // UTC: 8:18 PM Local: 1:18 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 10, 19, 32, 0, false);          // UTC: 7:32 PM Local: 12:32 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 26, 7, 25, 0, false);           // UTC: 7:25 AM Local: 12:25 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 15, 3, 2, 0, false);            // UTC: 3:02 AM Local: 8:02 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 20, 13, 23, 0, false);          // UTC: 1:23 PM Local: 6:23 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 6, 4, 56, 0, false);            // UTC: 4:56 AM Local: 9:56 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 10, 1, 39, 0, false);           // UTC: 1:39 AM Local: 6:39 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 24, 21, 4, 0, false);           // UTC: 9:04 PM Local: 2:04 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 7, 13, 37, 0, false);           // UTC: 1:37 PM Local: 6:37 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 19, 16, 1, 0, false);           // UTC: 4:01 PM Local: 9:01 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 14, 20, 19, 0, false);          // UTC: 8:19 PM Local: 1:19 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 18, 12, 21, 0, false);          // UTC: 12:21 PM Local: 5:21 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 12, 18, 46, 0, false);          // UTC: 6:46 PM Local: 11:46 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 12, 16, 49, 0, false);          // UTC: 4:49 PM Local: 9:49 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 13, 1, 16, 0, false);           // UTC: 1:16 AM Local: 6:16 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 6, 12, 12, 0, false);           // UTC: 12:12 PM Local: 5:12 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 17, 8, 46, 0, false);           // UTC: 8:46 AM Local: 1:46 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 13, 6, 5, 0, false);            // UTC: 6:05 AM Local: 11:05 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 2, 13, 4, 56, 0, false);           // UTC: 4:56 AM Local: 9:56 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 7, 2, 16, 0, false);            // UTC: 2:16 AM Local: 7:16 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 25, 5, 38, 0, true);            // UTC: 5:38 AM Local: 11:38 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 12, 0, 16, 0, true);            // UTC: 12:16 AM Local: 6:16 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 20, 1, 4, 0, true);             // UTC: 1:04 AM Local: 7:04 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 2, 18, 22, 0, false);           // UTC: 6:22 PM Local: 11:22 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 5, 21, 21, 0, false);           // UTC: 9:21 PM Local: 2:21 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 23, 9, 51, 0, true);            // UTC: 9:51 AM Local: 3:51 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 22, 0, 2, 0, true);             // UTC: 12:02 AM Local: 6:02 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 12, 2, 18, 0, true);            // UTC: 2:18 AM Local: 8:18 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 7, 0, 35, 0, false);            // UTC: 12:35 AM Local: 5:35 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 7, 4, 20, 0, false);            // UTC: 4:20 AM Local: 9:20 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 11, 4, 41, 0, true);            // UTC: 4:41 AM Local: 10:41 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 14, 11, 27, 0, true);           // UTC: 11:27 AM Local: 5:27 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 6, 1, 0, 0, false);             // UTC: 1:00 AM Local: 6:00 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 1, 11, 27, 0, false);           // UTC: 11:27 AM Local: 4:27 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 4, 12, 34, 0, false);           // UTC: 12:34 PM Local: 5:34 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 11, 6, 21, 0, true);            // UTC: 6:21 AM Local: 12:21 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 20, 14, 46, 0, true);           // UTC: 2:46 PM Local: 8:46 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 2, 9, 5, 0, false);             // UTC: 9:05 AM Local: 2:05 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 7, 11, 7, 0, false);            // UTC: 11:07 AM Local: 4:07 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 9, 3, 1, 0, true);              // UTC: 3:01 AM Local: 9:01 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 19, 11, 52, 0, true);           // UTC: 11:52 AM Local: 5:52 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 20, 14, 36, 0, true);           // UTC: 2:36 PM Local: 8:36 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 19, 15, 25, 0, true);           // UTC: 3:25 PM Local: 9:25 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 3, 25, 14, 19, 0, true);           // UTC: 2:19 PM Local: 8:19 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 24, 18, 31, 0, true);           // UTC: 6:31 PM Local: 12:31 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 16, 6, 32, 0, true);            // UTC: 6:32 AM Local: 12:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 20, 19, 42, 0, true);           // UTC: 7:42 PM Local: 1:42 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 7, 11, 32, 0, true);            // UTC: 11:32 AM Local: 5:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 15, 7, 44, 0, true);            // UTC: 7:44 AM Local: 1:44 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 17, 6, 58, 0, true);            // UTC: 6:58 AM Local: 12:58 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 10, 19, 52, 0, true);           // UTC: 7:52 PM Local: 1:52 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 27, 7, 0, 0, true);             // UTC: 7:00 AM Local: 1:00 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 16, 9, 54, 0, true);            // UTC: 9:54 AM Local: 3:54 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 27, 16, 37, 0, true);           // UTC: 4:37 PM Local: 10:37 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 26, 19, 58, 0, true);           // UTC: 7:58 PM Local: 1:58 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 13, 4, 36, 0, true);            // UTC: 4:36 AM Local: 10:36 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 16, 14, 13, 0, true);           // UTC: 2:13 PM Local: 8:13 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 16, 13, 19, 0, true);           // UTC: 1:19 PM Local: 7:19 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 9, 10, 57, 0, true);            // UTC: 10:57 AM Local: 4:57 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 10, 4, 17, 0, true);            // UTC: 4:17 AM Local: 10:17 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 24, 1, 22, 0, true);            // UTC: 1:22 AM Local: 7:22 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 12, 12, 45, 0, true);           // UTC: 12:45 PM Local: 6:45 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 12, 20, 28, 0, true);           // UTC: 8:28 PM Local: 2:28 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 14, 0, 51, 0, true);            // UTC: 12:51 AM Local: 6:51 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 18, 17, 6, 0, true);            // UTC: 5:06 PM Local: 11:06 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 3, 6, 38, 0, true);             // UTC: 6:38 AM Local: 12:38 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 16, 1, 8, 0, true);             // UTC: 1:08 AM Local: 7:08 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 4, 0, 37, 0, true);             // UTC: 12:37 AM Local: 6:37 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 4, 21, 17, 15, 0, true);           // UTC: 5:15 PM Local: 11:15 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 15, 15, 51, 0, true);           // UTC: 3:51 PM Local: 9:51 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 1, 5, 12, 0, true);             // UTC: 5:12 AM Local: 11:12 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 17, 2, 38, 0, true);            // UTC: 2:38 AM Local: 8:38 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 7, 11, 16, 0, true);            // UTC: 11:16 AM Local: 5:16 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 6, 0, 18, 0, true);             // UTC: 12:18 AM Local: 6:18 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 4, 1, 37, 0, true);             // UTC: 1:37 AM Local: 7:37 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 10, 21, 50, 0, true);           // UTC: 9:50 PM Local: 3:50 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 7, 4, 9, 0, true);              // UTC: 4:09 AM Local: 10:09 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 9, 17, 6, 0, true);             // UTC: 5:06 PM Local: 11:06 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 5, 16, 1, 0, true);             // UTC: 4:01 PM Local: 10:01 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 21, 15, 45, 0, true);           // UTC: 3:45 PM Local: 9:45 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 15, 20, 12, 0, true);           // UTC: 8:12 PM Local: 2:12 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 17, 10, 45, 0, true);           // UTC: 10:45 AM Local: 4:45 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 18, 0, 38, 0, true);            // UTC: 12:38 AM Local: 6:38 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 13, 19, 46, 0, true);           // UTC: 7:46 PM Local: 1:46 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 11, 8, 3, 0, true);             // UTC: 8:03 AM Local: 2:03 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 23, 0, 58, 0, true);            // UTC: 12:58 AM Local: 6:58 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 1, 9, 50, 0, true);             // UTC: 9:50 AM Local: 3:50 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 12, 7, 27, 0, true);            // UTC: 7:27 AM Local: 1:27 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 20, 16, 28, 0, true);           // UTC: 4:28 PM Local: 10:28 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 4, 10, 22, 0, true);            // UTC: 10:22 AM Local: 4:22 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 17, 11, 49, 0, true);           // UTC: 11:49 AM Local: 5:49 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 14, 15, 7, 0, true);            // UTC: 3:07 PM Local: 9:07 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 3, 12, 34, 0, true);            // UTC: 12:34 PM Local: 6:34 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 5, 24, 16, 53, 0, true);           // UTC: 4:53 PM Local: 10:53 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 6, 17, 21, 0, true);            // UTC: 5:21 PM Local: 11:21 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 11, 21, 23, 0, true);           // UTC: 9:23 PM Local: 3:23 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 1, 7, 42, 0, true);             // UTC: 7:42 AM Local: 1:42 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 2, 17, 15, 0, true);            // UTC: 5:15 PM Local: 11:15 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 25, 2, 32, 0, true);            // UTC: 2:32 AM Local: 8:32 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 21, 20, 44, 0, true);           // UTC: 8:44 PM Local: 2:44 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 8, 12, 33, 0, true);            // UTC: 12:33 PM Local: 6:33 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 8, 19, 21, 0, true);            // UTC: 7:21 PM Local: 1:21 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 26, 19, 40, 0, true);           // UTC: 7:40 PM Local: 1:40 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 26, 16, 27, 0, true);           // UTC: 4:27 PM Local: 10:27 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 12, 3, 40, 0, true);            // UTC: 3:40 AM Local: 9:40 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 26, 4, 33, 0, true);            // UTC: 4:33 AM Local: 10:33 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 3, 8, 45, 0, true);             // UTC: 8:45 AM Local: 2:45 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 2, 1, 6, 0, true);              // UTC: 1:06 AM Local: 7:06 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 18, 13, 43, 0, true);           // UTC: 1:43 PM Local: 7:43 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 16, 13, 33, 0, true);           // UTC: 1:33 PM Local: 7:33 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 16, 7, 38, 0, true);            // UTC: 7:38 AM Local: 1:38 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 23, 13, 10, 0, true);           // UTC: 1:10 PM Local: 7:10 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 9, 21, 53, 0, true);            // UTC: 9:53 PM Local: 3:53 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 1, 9, 4, 0, true);              // UTC: 9:04 AM Local: 3:04 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 20, 2, 35, 0, true);            // UTC: 2:35 AM Local: 8:35 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 7, 14, 36, 0, true);            // UTC: 2:36 PM Local: 8:36 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 16, 22, 53, 0, true);           // UTC: 10:53 PM Local: 4:53 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 27, 15, 30, 0, true);           // UTC: 3:30 PM Local: 9:30 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 6, 27, 5, 26, 0, true);            // UTC: 5:26 AM Local: 11:26 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 13, 13, 16, 0, true);           // UTC: 1:16 PM Local: 7:16 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 17, 8, 16, 0, true);            // UTC: 8:16 AM Local: 2:16 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 3, 8, 22, 0, true);             // UTC: 8:22 AM Local: 2:22 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 22, 13, 32, 0, true);           // UTC: 1:32 PM Local: 7:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 14, 14, 15, 0, true);           // UTC: 2:15 PM Local: 8:15 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 18, 1, 54, 0, true);            // UTC: 1:54 AM Local: 7:54 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 19, 7, 57, 0, true);            // UTC: 7:57 AM Local: 1:57 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 14, 9, 54, 0, true);            // UTC: 9:54 AM Local: 3:54 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 4, 22, 35, 0, true);            // UTC: 10:35 PM Local: 4:35 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 18, 13, 40, 0, true);           // UTC: 1:40 PM Local: 7:40 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 4, 19, 20, 0, true);            // UTC: 7:20 PM Local: 1:20 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 20, 19, 20, 0, true);           // UTC: 7:20 PM Local: 1:20 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 17, 8, 3, 0, true);             // UTC: 8:03 AM Local: 2:03 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 22, 14, 43, 0, true);           // UTC: 2:43 PM Local: 8:43 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 6, 10, 2, 0, true);             // UTC: 10:02 AM Local: 4:02 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 2, 2, 21, 0, true);             // UTC: 2:21 AM Local: 8:21 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 18, 7, 33, 0, true);            // UTC: 7:33 AM Local: 1:33 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 16, 6, 51, 0, true);            // UTC: 6:51 AM Local: 12:51 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 13, 22, 12, 0, true);           // UTC: 10:12 PM Local: 4:12 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 10, 11, 23, 0, true);           // UTC: 11:23 AM Local: 5:23 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 19, 10, 46, 0, true);           // UTC: 10:46 AM Local: 4:46 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 19, 15, 44, 0, true);           // UTC: 3:44 PM Local: 9:44 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 6, 17, 44, 0, true);            // UTC: 5:44 PM Local: 11:44 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 25, 0, 41, 0, true);            // UTC: 12:41 AM Local: 6:41 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 7, 24, 20, 42, 0, true);           // UTC: 8:42 PM Local: 2:42 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 7, 6, 56, 0, true);             // UTC: 6:56 AM Local: 12:56 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 24, 1, 52, 0, true);            // UTC: 1:52 AM Local: 7:52 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 7, 0, 14, 0, true);             // UTC: 12:14 AM Local: 6:14 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 4, 12, 32, 0, true);            // UTC: 12:32 PM Local: 6:32 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 13, 5, 53, 0, true);            // UTC: 5:53 AM Local: 11:53 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 4, 6, 52, 0, true);             // UTC: 6:52 AM Local: 12:52 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 18, 2, 10, 0, true);            // UTC: 2:10 AM Local: 8:10 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 26, 11, 45, 0, true);           // UTC: 11:45 AM Local: 5:45 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 9, 19, 19, 0, true);            // UTC: 7:19 PM Local: 1:19 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 17, 16, 17, 0, true);           // UTC: 4:17 PM Local: 10:17 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 24, 16, 22, 0, true);           // UTC: 4:22 PM Local: 10:22 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 5, 5, 39, 0, true);             // UTC: 5:39 AM Local: 11:39 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 7, 10, 24, 0, true);            // UTC: 10:24 AM Local: 4:24 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 14, 9, 25, 0, true);            // UTC: 9:25 AM Local: 3:25 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 15, 13, 7, 0, true);            // UTC: 1:07 PM Local: 7:07 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 6, 16, 29, 0, true);            // UTC: 4:29 PM Local: 10:29 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 23, 17, 45, 0, true);           // UTC: 5:45 PM Local: 11:45 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 22, 5, 46, 0, true);            // UTC: 5:46 AM Local: 11:46 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 15, 6, 45, 0, true);            // UTC: 6:45 AM Local: 12:45 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 5, 13, 13, 0, true);            // UTC: 1:13 PM Local: 7:13 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 16, 14, 16, 0, true);           // UTC: 2:16 PM Local: 8:16 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 27, 5, 49, 0, true);            // UTC: 5:49 AM Local: 11:49 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 5, 7, 1, 0, true);              // UTC: 7:01 AM Local: 1:01 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 7, 20, 46, 0, true);            // UTC: 8:46 PM Local: 2:46 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 8, 13, 3, 40, 0, true);            // UTC: 3:40 AM Local: 9:40 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 20, 9, 54, 0, true);            // UTC: 9:54 AM Local: 3:54 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 18, 2, 7, 0, true);             // UTC: 2:07 AM Local: 8:07 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 23, 17, 56, 0, true);           // UTC: 5:56 PM Local: 11:56 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 15, 1, 28, 0, true);            // UTC: 1:28 AM Local: 7:28 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 17, 13, 54, 0, true);           // UTC: 1:54 PM Local: 7:54 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 25, 1, 52, 0, true);            // UTC: 1:52 AM Local: 7:52 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 6, 21, 46, 0, true);            // UTC: 9:46 PM Local: 3:46 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 5, 13, 21, 0, true);            // UTC: 1:21 PM Local: 7:21 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 8, 0, 23, 0, true);             // UTC: 12:23 AM Local: 6:23 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 13, 14, 52, 0, true);           // UTC: 2:52 PM Local: 8:52 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 27, 7, 4, 0, true);             // UTC: 7:04 AM Local: 1:04 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 3, 18, 52, 0, true);            // UTC: 6:52 PM Local: 12:52 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 23, 12, 28, 0, true);           // UTC: 12:28 PM Local: 6:28 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 3, 16, 51, 0, true);            // UTC: 4:51 PM Local: 10:51 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 9, 10, 9, 0, true);             // UTC: 10:09 AM Local: 4:09 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 10, 13, 42, 0, true);           // UTC: 1:42 PM Local: 7:42 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 3, 7, 48, 0, true);             // UTC: 7:48 AM Local: 1:48 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 25, 6, 11, 0, true);            // UTC: 6:11 AM Local: 12:11 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 25, 13, 50, 0, true);           // UTC: 1:50 PM Local: 7:50 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 16, 8, 3, 0, true);             // UTC: 8:03 AM Local: 2:03 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 20, 7, 8, 0, true);             // UTC: 7:08 AM Local: 1:08 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 2, 12, 44, 0, true);            // UTC: 12:44 PM Local: 6:44 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 12, 11, 46, 0, true);           // UTC: 11:46 AM Local: 5:46 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 2, 1, 31, 0, true);             // UTC: 1:31 AM Local: 7:31 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 9, 11, 2, 12, 0, true);            // UTC: 2:12 AM Local: 8:12 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 25, 19, 7, 0, true);           // UTC: 7:07 PM Local: 1:07 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 6, 21, 27, 0, true);           // UTC: 9:27 PM Local: 3:27 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 19, 8, 17, 0, true);           // UTC: 8:17 AM Local: 2:17 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 3, 1, 2, 0, true);             // UTC: 1:02 AM Local: 7:02 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 25, 4, 14, 0, true);           // UTC: 4:14 AM Local: 10:14 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 1, 6, 10, 0, true);            // UTC: 6:10 AM Local: 12:10 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 12, 8, 23, 0, true);           // UTC: 8:23 AM Local: 2:23 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 20, 6, 53, 0, true);           // UTC: 6:53 AM Local: 12:53 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 11, 21, 4, 0, true);           // UTC: 9:04 PM Local: 3:04 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 26, 1, 14, 0, true);           // UTC: 1:14 AM Local: 7:14 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 8, 11, 10, 0, true);           // UTC: 11:10 AM Local: 5:10 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 27, 22, 42, 0, true);          // UTC: 10:42 PM Local: 4:42 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 20, 8, 24, 0, true);           // UTC: 8:24 AM Local: 2:24 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 16, 1, 56, 0, true);           // UTC: 1:56 AM Local: 7:56 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 24, 22, 28, 0, true);          // UTC: 10:28 PM Local: 4:28 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 20, 11, 17, 0, true);          // UTC: 11:17 AM Local: 5:17 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 15, 0, 47, 0, true);           // UTC: 12:47 AM Local: 6:47 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 10, 22, 42, 0, true);          // UTC: 10:42 PM Local: 4:42 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 23, 4, 34, 0, true);           // UTC: 4:34 AM Local: 10:34 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 6, 18, 58, 0, true);           // UTC: 6:58 PM Local: 12:58 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 11, 16, 19, 0, true);          // UTC: 4:19 PM Local: 10:19 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 2, 18, 33, 0, true);           // UTC: 6:33 PM Local: 12:33 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 24, 21, 12, 0, true);          // UTC: 9:12 PM Local: 3:12 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 14, 6, 52, 0, true);           // UTC: 6:52 AM Local: 12:52 AM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 10, 21, 19, 18, 0, true);          // UTC: 7:18 PM Local: 1:18 PM Offset: -06:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 12, 19, 16, 0, false);         // UTC: 7:16 PM Local: 12:16 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 12, 15, 25, 0, false);         // UTC: 3:25 PM Local: 8:25 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 21, 9, 1, 0, false);           // UTC: 9:01 AM Local: 2:01 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 12, 21, 32, 0, false);         // UTC: 9:32 PM Local: 2:32 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 13, 3, 47, 0, false);          // UTC: 3:47 AM Local: 8:47 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 4, 11, 33, 0, false);          // UTC: 11:33 AM Local: 4:33 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 12, 4, 19, 0, false);          // UTC: 4:19 AM Local: 9:19 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 18, 18, 11, 0, false);         // UTC: 6:11 PM Local: 11:11 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 25, 19, 35, 0, false);         // UTC: 7:35 PM Local: 12:35 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 3, 0, 42, 0, false);           // UTC: 12:42 AM Local: 5:42 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 25, 13, 6, 0, false);          // UTC: 1:06 PM Local: 6:06 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 11, 9, 18, 0, false);          // UTC: 9:18 AM Local: 2:18 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 9, 18, 7, 0, false);           // UTC: 6:07 PM Local: 11:07 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 16, 14, 19, 0, false);         // UTC: 2:19 PM Local: 7:19 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 8, 14, 49, 0, false);          // UTC: 2:49 PM Local: 7:49 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 1, 9, 45, 0, false);           // UTC: 9:45 AM Local: 2:45 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 11, 8, 46, 0, false);          // UTC: 8:46 AM Local: 1:46 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 10, 7, 39, 0, false);          // UTC: 7:39 AM Local: 12:39 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 27, 18, 2, 0, false);          // UTC: 6:02 PM Local: 11:02 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 3, 11, 48, 0, false);          // UTC: 11:48 AM Local: 4:48 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 23, 15, 22, 0, false);         // UTC: 3:22 PM Local: 8:22 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 9, 11, 21, 0, false);          // UTC: 11:21 AM Local: 4:21 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 12, 1, 44, 0, false);          // UTC: 1:44 AM Local: 6:44 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 14, 19, 42, 0, false);         // UTC: 7:42 PM Local: 12:42 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 11, 12, 19, 32, 0, false);         // UTC: 7:32 PM Local: 12:32 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 27, 7, 12, 0, false);          // UTC: 7:12 AM Local: 12:12 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 10, 20, 26, 0, false);         // UTC: 8:26 PM Local: 1:26 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 23, 15, 38, 0, false);         // UTC: 3:38 PM Local: 8:38 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 26, 13, 14, 0, false);         // UTC: 1:14 PM Local: 6:14 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 12, 9, 35, 0, false);          // UTC: 9:35 AM Local: 2:35 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 8, 4, 17, 0, false);           // UTC: 4:17 AM Local: 9:17 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 9, 17, 55, 0, false);          // UTC: 5:55 PM Local: 10:55 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 26, 22, 5, 0, false);          // UTC: 10:05 PM Local: 3:05 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 14, 13, 21, 0, false);         // UTC: 1:21 PM Local: 6:21 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 1, 20, 30, 0, false);          // UTC: 8:30 PM Local: 1:30 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 2, 20, 29, 0, false);          // UTC: 8:29 PM Local: 1:29 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 4, 0, 26, 0, false);           // UTC: 12:26 AM Local: 5:26 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 23, 17, 35, 0, false);         // UTC: 5:35 PM Local: 10:35 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 11, 22, 58, 0, false);         // UTC: 10:58 PM Local: 3:58 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 20, 8, 55, 0, false);          // UTC: 8:55 AM Local: 1:55 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 4, 22, 37, 0, false);          // UTC: 10:37 PM Local: 3:37 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 5, 4, 38, 0, false);           // UTC: 4:38 AM Local: 9:38 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 12, 3, 5, 0, false);           // UTC: 3:05 AM Local: 8:05 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 17, 1, 21, 0, false);          // UTC: 1:21 AM Local: 6:21 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 4, 19, 18, 0, false);          // UTC: 7:18 PM Local: 12:18 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 3, 19, 46, 0, false);          // UTC: 7:46 PM Local: 12:46 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 4, 19, 40, 0, false);          // UTC: 7:40 PM Local: 12:40 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 21, 7, 23, 0, false);          // UTC: 7:23 AM Local: 12:23 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 5, 10, 26, 0, false);          // UTC: 10:26 AM Local: 3:26 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 7, 2020, 12, 19, 21, 44, 0, false);         // UTC: 9:44 PM Local: 2:44 PM Offset: -07:00:00

	Serial.println(); Serial.print(failedCount); Serial.print(" of "); Serial.print(testCount); Serial.println(" test(s) failed.");
}
#endif
