#ifndef TEST_TIMEZONEID_6_H
#define TEST_TIMEZONEID_6_H

#include "TimeManager.h"
#include "TestHelper.h"

void run_TimeZoneId_6_Tests(const TimeManager& timeManager)
{
	uint16_t testCount = 0;
	uint16_t failedCount = 0;

	testCount++; failedCount += test(timeManager, 6, 2018, 1, 8, 9, 11, 0, false);            // UTC: 9:11 AM Local: 1:11 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 15, 20, 11, 0, false);          // UTC: 8:11 PM Local: 12:11 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 13, 3, 11, 0, false);           // UTC: 3:11 AM Local: 7:11 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 4, 2, 38, 0, false);            // UTC: 2:38 AM Local: 6:38 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 9, 21, 33, 0, false);           // UTC: 9:33 PM Local: 1:33 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 25, 7, 15, 0, false);           // UTC: 7:15 AM Local: 11:15 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 1, 2, 15, 0, false);            // UTC: 2:15 AM Local: 6:15 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 19, 6, 25, 0, false);           // UTC: 6:25 AM Local: 10:25 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 24, 10, 31, 0, false);          // UTC: 10:31 AM Local: 2:31 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 27, 15, 17, 0, false);          // UTC: 3:17 PM Local: 7:17 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 18, 2, 31, 0, false);           // UTC: 2:31 AM Local: 6:31 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 13, 0, 26, 0, false);           // UTC: 12:26 AM Local: 4:26 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 13, 19, 5, 0, false);           // UTC: 7:05 PM Local: 11:05 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 7, 9, 2, 0, false);             // UTC: 9:02 AM Local: 1:02 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 11, 6, 55, 0, false);           // UTC: 6:55 AM Local: 10:55 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 13, 20, 57, 0, false);          // UTC: 8:57 PM Local: 12:57 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 21, 22, 24, 0, false);          // UTC: 10:24 PM Local: 2:24 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 4, 16, 35, 0, false);           // UTC: 4:35 PM Local: 8:35 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 17, 13, 7, 0, false);           // UTC: 1:07 PM Local: 5:07 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 21, 16, 25, 0, false);          // UTC: 4:25 PM Local: 8:25 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 18, 11, 28, 0, false);          // UTC: 11:28 AM Local: 3:28 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 24, 11, 58, 0, false);          // UTC: 11:58 AM Local: 3:58 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 4, 19, 54, 0, false);           // UTC: 7:54 PM Local: 11:54 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 4, 10, 28, 0, false);           // UTC: 10:28 AM Local: 2:28 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 1, 5, 18, 40, 0, false);           // UTC: 6:40 PM Local: 10:40 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 7, 7, 0, 0, false);             // UTC: 7:00 AM Local: 11:00 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 14, 9, 33, 0, false);           // UTC: 9:33 AM Local: 1:33 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 16, 5, 39, 0, false);           // UTC: 5:39 AM Local: 9:39 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 24, 11, 24, 0, false);          // UTC: 11:24 AM Local: 3:24 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 26, 19, 24, 0, false);          // UTC: 7:24 PM Local: 11:24 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 9, 15, 9, 0, false);            // UTC: 3:09 PM Local: 7:09 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 19, 13, 55, 0, false);          // UTC: 1:55 PM Local: 5:55 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 15, 11, 45, 0, false);          // UTC: 11:45 AM Local: 3:45 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 26, 7, 2, 0, false);            // UTC: 7:02 AM Local: 11:02 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 2, 14, 31, 0, false);           // UTC: 2:31 PM Local: 6:31 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 26, 21, 53, 0, false);          // UTC: 9:53 PM Local: 1:53 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 25, 8, 16, 0, false);           // UTC: 8:16 AM Local: 12:16 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 3, 6, 17, 0, false);            // UTC: 6:17 AM Local: 10:17 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 23, 1, 15, 0, false);           // UTC: 1:15 AM Local: 5:15 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 23, 0, 58, 0, false);           // UTC: 12:58 AM Local: 4:58 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 16, 4, 58, 0, false);           // UTC: 4:58 AM Local: 8:58 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 14, 18, 45, 0, false);          // UTC: 6:45 PM Local: 10:45 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 9, 11, 11, 0, false);           // UTC: 11:11 AM Local: 3:11 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 21, 15, 49, 0, false);          // UTC: 3:49 PM Local: 7:49 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 7, 12, 3, 0, false);            // UTC: 12:03 PM Local: 4:03 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 15, 12, 33, 0, false);          // UTC: 12:33 PM Local: 4:33 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 4, 21, 33, 0, false);           // UTC: 9:33 PM Local: 1:33 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 14, 0, 28, 0, false);           // UTC: 12:28 AM Local: 4:28 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 4, 5, 24, 0, false);            // UTC: 5:24 AM Local: 9:24 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 2, 24, 18, 30, 0, false);          // UTC: 6:30 PM Local: 10:30 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 19, 16, 28, 0, true);           // UTC: 4:28 PM Local: 9:28 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 21, 8, 9, 0, true);             // UTC: 8:09 AM Local: 1:09 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 2, 12, 50, 0, false);           // UTC: 12:50 PM Local: 4:50 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 21, 13, 27, 0, true);           // UTC: 1:27 PM Local: 6:27 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 19, 3, 41, 0, true);            // UTC: 3:41 AM Local: 8:41 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 12, 19, 44, 0, true);           // UTC: 7:44 PM Local: 12:44 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 7, 7, 32, 0, false);            // UTC: 7:32 AM Local: 11:32 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 19, 16, 3, 0, true);            // UTC: 4:03 PM Local: 9:03 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 12, 1, 8, 0, true);             // UTC: 1:08 AM Local: 6:08 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 14, 8, 33, 0, true);            // UTC: 8:33 AM Local: 1:33 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 10, 10, 39, 0, false);          // UTC: 10:39 AM Local: 2:39 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 19, 1, 57, 0, true);            // UTC: 1:57 AM Local: 6:57 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 10, 10, 7, 0, false);           // UTC: 10:07 AM Local: 2:07 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 25, 10, 57, 0, true);           // UTC: 10:57 AM Local: 3:57 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 20, 8, 19, 0, true);            // UTC: 8:19 AM Local: 1:19 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 3, 18, 51, 0, false);           // UTC: 6:51 PM Local: 10:51 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 22, 16, 21, 0, true);           // UTC: 4:21 PM Local: 9:21 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 19, 14, 29, 0, true);           // UTC: 2:29 PM Local: 7:29 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 27, 0, 0, 0, true);             // UTC: 12:00 AM Local: 5:00 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 12, 8, 19, 0, true);            // UTC: 8:19 AM Local: 1:19 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 1, 12, 11, 0, false);           // UTC: 12:11 PM Local: 4:11 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 8, 9, 8, 0, false);             // UTC: 9:08 AM Local: 1:08 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 22, 0, 5, 0, true);             // UTC: 12:05 AM Local: 5:05 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 20, 1, 22, 0, true);            // UTC: 1:22 AM Local: 6:22 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 3, 17, 8, 49, 0, true);            // UTC: 8:49 AM Local: 1:49 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 16, 22, 21, 0, true);           // UTC: 10:21 PM Local: 3:21 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 20, 7, 14, 0, true);            // UTC: 7:14 AM Local: 12:14 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 8, 16, 38, 0, true);            // UTC: 4:38 PM Local: 9:38 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 6, 15, 49, 0, true);            // UTC: 3:49 PM Local: 8:49 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 5, 16, 3, 0, true);             // UTC: 4:03 PM Local: 9:03 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 26, 21, 7, 0, true);            // UTC: 9:07 PM Local: 2:07 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 22, 20, 55, 0, true);           // UTC: 8:55 PM Local: 1:55 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 22, 9, 54, 0, true);            // UTC: 9:54 AM Local: 2:54 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 6, 7, 47, 0, true);             // UTC: 7:47 AM Local: 12:47 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 21, 1, 37, 0, true);            // UTC: 1:37 AM Local: 6:37 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 27, 1, 15, 0, true);            // UTC: 1:15 AM Local: 6:15 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 18, 8, 2, 0, true);             // UTC: 8:02 AM Local: 1:02 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 18, 15, 1, 0, true);            // UTC: 3:01 PM Local: 8:01 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 3, 17, 47, 0, true);            // UTC: 5:47 PM Local: 10:47 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 15, 1, 43, 0, true);            // UTC: 1:43 AM Local: 6:43 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 9, 14, 16, 0, true);            // UTC: 2:16 PM Local: 7:16 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 2, 17, 7, 0, true);             // UTC: 5:07 PM Local: 10:07 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 8, 18, 28, 0, true);            // UTC: 6:28 PM Local: 11:28 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 25, 18, 31, 0, true);           // UTC: 6:31 PM Local: 11:31 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 12, 12, 1, 0, true);            // UTC: 12:01 PM Local: 5:01 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 13, 11, 39, 0, true);           // UTC: 11:39 AM Local: 4:39 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 1, 5, 36, 0, true);             // UTC: 5:36 AM Local: 10:36 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 16, 11, 19, 0, true);           // UTC: 11:19 AM Local: 4:19 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 1, 7, 15, 0, true);             // UTC: 7:15 AM Local: 12:15 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 4, 3, 16, 7, 0, true);             // UTC: 4:07 PM Local: 9:07 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 4, 5, 20, 0, true);             // UTC: 5:20 AM Local: 10:20 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 6, 20, 40, 0, true);            // UTC: 8:40 PM Local: 1:40 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 14, 16, 17, 0, true);           // UTC: 4:17 PM Local: 9:17 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 14, 16, 14, 0, true);           // UTC: 4:14 PM Local: 9:14 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 22, 17, 34, 0, true);           // UTC: 5:34 PM Local: 10:34 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 14, 5, 9, 0, true);             // UTC: 5:09 AM Local: 10:09 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 1, 14, 13, 0, true);            // UTC: 2:13 PM Local: 7:13 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 4, 12, 50, 0, true);            // UTC: 12:50 PM Local: 5:50 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 4, 16, 6, 0, true);             // UTC: 4:06 PM Local: 9:06 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 26, 0, 26, 0, true);            // UTC: 12:26 AM Local: 5:26 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 24, 3, 4, 0, true);             // UTC: 3:04 AM Local: 8:04 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 10, 17, 33, 0, true);           // UTC: 5:33 PM Local: 10:33 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 6, 5, 37, 0, true);             // UTC: 5:37 AM Local: 10:37 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 10, 21, 45, 0, true);           // UTC: 9:45 PM Local: 2:45 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 11, 11, 30, 0, true);           // UTC: 11:30 AM Local: 4:30 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 11, 17, 45, 0, true);           // UTC: 5:45 PM Local: 10:45 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 21, 11, 5, 0, true);            // UTC: 11:05 AM Local: 4:05 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 3, 2, 6, 0, true);              // UTC: 2:06 AM Local: 7:06 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 25, 22, 40, 0, true);           // UTC: 10:40 PM Local: 3:40 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 14, 1, 9, 0, true);             // UTC: 1:09 AM Local: 6:09 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 16, 12, 42, 0, true);           // UTC: 12:42 PM Local: 5:42 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 23, 14, 31, 0, true);           // UTC: 2:31 PM Local: 7:31 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 5, 10, 57, 0, true);            // UTC: 10:57 AM Local: 3:57 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 1, 7, 58, 0, true);             // UTC: 7:58 AM Local: 12:58 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 5, 14, 15, 40, 0, true);           // UTC: 3:40 PM Local: 8:40 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 13, 17, 1, 0, true);            // UTC: 5:01 PM Local: 10:01 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 9, 17, 55, 0, true);            // UTC: 5:55 PM Local: 10:55 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 10, 4, 29, 0, true);            // UTC: 4:29 AM Local: 9:29 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 10, 17, 4, 0, true);            // UTC: 5:04 PM Local: 10:04 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 26, 10, 46, 0, true);           // UTC: 10:46 AM Local: 3:46 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 24, 16, 9, 0, true);            // UTC: 4:09 PM Local: 9:09 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 13, 17, 22, 0, true);           // UTC: 5:22 PM Local: 10:22 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 2, 12, 51, 0, true);            // UTC: 12:51 PM Local: 5:51 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 27, 4, 19, 0, true);            // UTC: 4:19 AM Local: 9:19 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 22, 16, 12, 0, true);           // UTC: 4:12 PM Local: 9:12 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 3, 13, 24, 0, true);            // UTC: 1:24 PM Local: 6:24 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 12, 10, 13, 0, true);           // UTC: 10:13 AM Local: 3:13 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 18, 3, 19, 0, true);            // UTC: 3:19 AM Local: 8:19 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 7, 4, 20, 0, true);             // UTC: 4:20 AM Local: 9:20 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 6, 10, 51, 0, true);            // UTC: 10:51 AM Local: 3:51 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 13, 5, 58, 0, true);            // UTC: 5:58 AM Local: 10:58 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 5, 3, 36, 0, true);             // UTC: 3:36 AM Local: 8:36 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 23, 1, 53, 0, true);            // UTC: 1:53 AM Local: 6:53 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 9, 9, 13, 0, true);             // UTC: 9:13 AM Local: 2:13 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 5, 7, 32, 0, true);             // UTC: 7:32 AM Local: 12:32 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 17, 12, 28, 0, true);           // UTC: 12:28 PM Local: 5:28 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 9, 6, 10, 0, true);             // UTC: 6:10 AM Local: 11:10 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 18, 12, 1, 0, true);            // UTC: 12:01 PM Local: 5:01 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 16, 5, 31, 0, true);            // UTC: 5:31 AM Local: 10:31 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 6, 23, 5, 32, 0, true);            // UTC: 5:32 AM Local: 10:32 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 1, 19, 4, 0, true);             // UTC: 7:04 PM Local: 12:04 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 1, 12, 57, 0, true);            // UTC: 12:57 PM Local: 5:57 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 10, 14, 34, 0, true);           // UTC: 2:34 PM Local: 7:34 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 16, 6, 31, 0, true);            // UTC: 6:31 AM Local: 11:31 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 15, 2, 2, 0, true);             // UTC: 2:02 AM Local: 7:02 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 27, 11, 48, 0, true);           // UTC: 11:48 AM Local: 4:48 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 21, 14, 38, 0, true);           // UTC: 2:38 PM Local: 7:38 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 24, 20, 12, 0, true);           // UTC: 8:12 PM Local: 1:12 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 19, 18, 40, 0, true);           // UTC: 6:40 PM Local: 11:40 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 27, 14, 54, 0, true);           // UTC: 2:54 PM Local: 7:54 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 3, 22, 47, 0, true);            // UTC: 10:47 PM Local: 3:47 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 10, 6, 32, 0, true);            // UTC: 6:32 AM Local: 11:32 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 5, 3, 47, 0, true);             // UTC: 3:47 AM Local: 8:47 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 16, 6, 55, 0, true);            // UTC: 6:55 AM Local: 11:55 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 25, 16, 57, 0, true);           // UTC: 4:57 PM Local: 9:57 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 18, 3, 24, 0, true);            // UTC: 3:24 AM Local: 8:24 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 27, 13, 41, 0, true);           // UTC: 1:41 PM Local: 6:41 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 20, 1, 37, 0, true);            // UTC: 1:37 AM Local: 6:37 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 25, 3, 55, 0, true);            // UTC: 3:55 AM Local: 8:55 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 24, 6, 44, 0, true);            // UTC: 6:44 AM Local: 11:44 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 8, 8, 58, 0, true);             // UTC: 8:58 AM Local: 1:58 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 18, 11, 17, 0, true);           // UTC: 11:17 AM Local: 4:17 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 20, 4, 48, 0, true);            // UTC: 4:48 AM Local: 9:48 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 14, 19, 21, 0, true);           // UTC: 7:21 PM Local: 12:21 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 7, 1, 4, 20, 0, true);             // UTC: 4:20 AM Local: 9:20 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 20, 22, 11, 0, true);           // UTC: 10:11 PM Local: 3:11 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 6, 1, 37, 0, true);             // UTC: 1:37 AM Local: 6:37 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 8, 22, 3, 0, true);             // UTC: 10:03 PM Local: 3:03 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 6, 8, 54, 0, true);             // UTC: 8:54 AM Local: 1:54 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 5, 10, 8, 0, true);             // UTC: 10:08 AM Local: 3:08 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 17, 6, 49, 0, true);            // UTC: 6:49 AM Local: 11:49 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 2, 7, 53, 0, true);             // UTC: 7:53 AM Local: 12:53 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 26, 5, 11, 0, true);            // UTC: 5:11 AM Local: 10:11 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 19, 20, 57, 0, true);           // UTC: 8:57 PM Local: 1:57 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 16, 11, 42, 0, true);           // UTC: 11:42 AM Local: 4:42 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 10, 15, 51, 0, true);           // UTC: 3:51 PM Local: 8:51 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 8, 4, 11, 0, true);             // UTC: 4:11 AM Local: 9:11 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 20, 14, 13, 0, true);           // UTC: 2:13 PM Local: 7:13 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 3, 22, 22, 0, true);            // UTC: 10:22 PM Local: 3:22 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 26, 9, 8, 0, true);             // UTC: 9:08 AM Local: 2:08 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 11, 12, 43, 0, true);           // UTC: 12:43 PM Local: 5:43 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 19, 20, 32, 0, true);           // UTC: 8:32 PM Local: 1:32 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 15, 22, 52, 0, true);           // UTC: 10:52 PM Local: 3:52 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 12, 17, 41, 0, true);           // UTC: 5:41 PM Local: 10:41 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 1, 12, 10, 0, true);            // UTC: 12:10 PM Local: 5:10 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 19, 15, 29, 0, true);           // UTC: 3:29 PM Local: 8:29 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 9, 20, 39, 0, true);            // UTC: 8:39 PM Local: 1:39 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 2, 20, 14, 0, true);            // UTC: 8:14 PM Local: 1:14 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 26, 19, 38, 0, true);           // UTC: 7:38 PM Local: 12:38 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 8, 17, 21, 18, 0, true);           // UTC: 9:18 PM Local: 2:18 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 15, 0, 48, 0, true);            // UTC: 12:48 AM Local: 5:48 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 2, 6, 19, 0, true);             // UTC: 6:19 AM Local: 11:19 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 7, 20, 35, 0, true);            // UTC: 8:35 PM Local: 1:35 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 5, 18, 42, 0, true);            // UTC: 6:42 PM Local: 11:42 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 27, 19, 25, 0, true);           // UTC: 7:25 PM Local: 12:25 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 14, 16, 6, 0, true);            // UTC: 4:06 PM Local: 9:06 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 2, 10, 18, 0, true);            // UTC: 10:18 AM Local: 3:18 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 24, 14, 33, 0, true);           // UTC: 2:33 PM Local: 7:33 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 14, 7, 40, 0, true);            // UTC: 7:40 AM Local: 12:40 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 14, 17, 1, 0, true);            // UTC: 5:01 PM Local: 10:01 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 25, 20, 1, 0, true);            // UTC: 8:01 PM Local: 1:01 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 16, 21, 44, 0, true);           // UTC: 9:44 PM Local: 2:44 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 24, 22, 14, 0, true);           // UTC: 10:14 PM Local: 3:14 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 23, 10, 46, 0, true);           // UTC: 10:46 AM Local: 3:46 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 25, 3, 3, 0, true);             // UTC: 3:03 AM Local: 8:03 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 26, 1, 1, 0, true);             // UTC: 1:01 AM Local: 6:01 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 23, 10, 8, 0, true);            // UTC: 10:08 AM Local: 3:08 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 15, 13, 29, 0, true);           // UTC: 1:29 PM Local: 6:29 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 1, 14, 22, 0, true);            // UTC: 2:22 PM Local: 7:22 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 8, 12, 56, 0, true);            // UTC: 12:56 PM Local: 5:56 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 18, 16, 9, 0, true);            // UTC: 4:09 PM Local: 9:09 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 16, 6, 54, 0, true);            // UTC: 6:54 AM Local: 11:54 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 19, 9, 54, 0, true);            // UTC: 9:54 AM Local: 2:54 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 18, 13, 44, 0, true);           // UTC: 1:44 PM Local: 6:44 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 9, 24, 4, 58, 0, true);            // UTC: 4:58 AM Local: 9:58 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 14, 22, 27, 0, true);          // UTC: 10:27 PM Local: 3:27 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 14, 12, 15, 0, true);          // UTC: 12:15 PM Local: 5:15 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 18, 15, 16, 0, true);          // UTC: 3:16 PM Local: 8:16 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 24, 8, 19, 0, true);           // UTC: 8:19 AM Local: 1:19 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 14, 12, 15, 0, true);          // UTC: 12:15 PM Local: 5:15 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 11, 14, 24, 0, true);          // UTC: 2:24 PM Local: 7:24 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 8, 4, 42, 0, true);            // UTC: 4:42 AM Local: 9:42 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 17, 7, 52, 0, true);           // UTC: 7:52 AM Local: 12:52 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 4, 5, 38, 0, true);            // UTC: 5:38 AM Local: 10:38 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 3, 3, 50, 0, true);            // UTC: 3:50 AM Local: 8:50 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 11, 15, 20, 0, true);          // UTC: 3:20 PM Local: 8:20 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 15, 11, 39, 0, true);          // UTC: 11:39 AM Local: 4:39 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 26, 17, 0, 0, true);           // UTC: 5:00 PM Local: 10:00 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 19, 0, 3, 0, true);            // UTC: 12:03 AM Local: 5:03 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 24, 16, 53, 0, true);          // UTC: 4:53 PM Local: 9:53 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 16, 4, 50, 0, true);           // UTC: 4:50 AM Local: 9:50 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 18, 6, 58, 0, true);           // UTC: 6:58 AM Local: 11:58 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 10, 13, 1, 0, true);           // UTC: 1:01 PM Local: 6:01 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 8, 20, 39, 0, true);           // UTC: 8:39 PM Local: 1:39 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 16, 8, 18, 0, true);           // UTC: 8:18 AM Local: 1:18 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 17, 12, 30, 0, true);          // UTC: 12:30 PM Local: 5:30 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 12, 11, 39, 0, true);          // UTC: 11:39 AM Local: 4:39 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 27, 22, 4, 0, true);           // UTC: 10:04 PM Local: 3:04 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 17, 10, 50, 0, true);          // UTC: 10:50 AM Local: 3:50 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 10, 11, 13, 11, 0, true);          // UTC: 1:11 PM Local: 6:11 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 18, 17, 35, 0, false);         // UTC: 5:35 PM Local: 9:35 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 27, 12, 2, 0, false);          // UTC: 12:02 PM Local: 4:02 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 22, 10, 51, 0, false);         // UTC: 10:51 AM Local: 2:51 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 24, 0, 6, 0, false);           // UTC: 12:06 AM Local: 4:06 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 10, 5, 35, 0, false);          // UTC: 5:35 AM Local: 9:35 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 27, 8, 22, 0, false);          // UTC: 8:22 AM Local: 12:22 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 20, 2, 26, 0, false);          // UTC: 2:26 AM Local: 6:26 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 15, 10, 12, 0, false);         // UTC: 10:12 AM Local: 2:12 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 7, 13, 11, 0, false);          // UTC: 1:11 PM Local: 5:11 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 21, 1, 49, 0, false);          // UTC: 1:49 AM Local: 5:49 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 4, 21, 0, 0, false);           // UTC: 9:00 PM Local: 1:00 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 23, 14, 8, 0, false);          // UTC: 2:08 PM Local: 6:08 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 3, 13, 49, 0, true);           // UTC: 1:49 PM Local: 6:49 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 7, 18, 6, 0, false);           // UTC: 6:06 PM Local: 10:06 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 18, 13, 28, 0, false);         // UTC: 1:28 PM Local: 5:28 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 16, 14, 43, 0, false);         // UTC: 2:43 PM Local: 6:43 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 13, 13, 5, 0, false);          // UTC: 1:05 PM Local: 5:05 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 13, 15, 28, 0, false);         // UTC: 3:28 PM Local: 7:28 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 20, 2, 17, 0, false);          // UTC: 2:17 AM Local: 6:17 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 11, 17, 55, 0, false);         // UTC: 5:55 PM Local: 9:55 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 24, 0, 21, 0, false);          // UTC: 12:21 AM Local: 4:21 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 1, 16, 3, 0, true);            // UTC: 4:03 PM Local: 9:03 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 3, 11, 37, 0, true);           // UTC: 11:37 AM Local: 4:37 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 13, 21, 45, 0, false);         // UTC: 9:45 PM Local: 1:45 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 11, 15, 10, 16, 0, false);         // UTC: 10:16 AM Local: 2:16 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 9, 20, 52, 0, false);          // UTC: 8:52 PM Local: 12:52 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 20, 15, 56, 0, false);         // UTC: 3:56 PM Local: 7:56 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 13, 6, 27, 0, false);          // UTC: 6:27 AM Local: 10:27 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 21, 15, 15, 0, false);         // UTC: 3:15 PM Local: 7:15 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 15, 2, 29, 0, false);          // UTC: 2:29 AM Local: 6:29 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 23, 15, 48, 0, false);         // UTC: 3:48 PM Local: 7:48 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 24, 9, 45, 0, false);          // UTC: 9:45 AM Local: 1:45 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 21, 14, 49, 0, false);         // UTC: 2:49 PM Local: 6:49 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 12, 10, 8, 0, false);          // UTC: 10:08 AM Local: 2:08 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 3, 0, 39, 0, false);           // UTC: 12:39 AM Local: 4:39 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 9, 21, 13, 0, false);          // UTC: 9:13 PM Local: 1:13 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 6, 9, 12, 0, false);           // UTC: 9:12 AM Local: 1:12 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 12, 15, 5, 0, false);          // UTC: 3:05 PM Local: 7:05 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 27, 9, 43, 0, false);          // UTC: 9:43 AM Local: 1:43 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 25, 6, 4, 0, false);           // UTC: 6:04 AM Local: 10:04 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 22, 13, 23, 0, false);         // UTC: 1:23 PM Local: 5:23 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 4, 14, 13, 0, false);          // UTC: 2:13 PM Local: 6:13 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 26, 15, 3, 0, false);          // UTC: 3:03 PM Local: 7:03 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 14, 13, 16, 0, false);         // UTC: 1:16 PM Local: 5:16 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 2, 7, 12, 0, false);           // UTC: 7:12 AM Local: 11:12 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 22, 8, 16, 0, false);          // UTC: 8:16 AM Local: 12:16 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 22, 10, 42, 0, false);         // UTC: 10:42 AM Local: 2:42 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 1, 7, 40, 0, false);           // UTC: 7:40 AM Local: 11:40 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 9, 9, 1, 0, false);            // UTC: 9:01 AM Local: 1:01 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2018, 12, 21, 20, 58, 0, false);         // UTC: 8:58 PM Local: 12:58 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 2, 19, 21, 0, false);           // UTC: 7:21 PM Local: 11:21 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 21, 14, 51, 0, false);          // UTC: 2:51 PM Local: 6:51 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 21, 22, 23, 0, false);          // UTC: 10:23 PM Local: 2:23 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 13, 8, 15, 0, false);           // UTC: 8:15 AM Local: 12:15 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 5, 15, 48, 0, false);           // UTC: 3:48 PM Local: 7:48 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 26, 8, 20, 0, false);           // UTC: 8:20 AM Local: 12:20 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 24, 4, 3, 0, false);            // UTC: 4:03 AM Local: 8:03 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 12, 2, 48, 0, false);           // UTC: 2:48 AM Local: 6:48 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 10, 17, 15, 0, false);          // UTC: 5:15 PM Local: 9:15 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 20, 19, 11, 0, false);          // UTC: 7:11 PM Local: 11:11 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 6, 4, 44, 0, false);            // UTC: 4:44 AM Local: 8:44 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 2, 10, 42, 0, false);           // UTC: 10:42 AM Local: 2:42 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 25, 6, 41, 0, false);           // UTC: 6:41 AM Local: 10:41 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 9, 1, 22, 0, false);            // UTC: 1:22 AM Local: 5:22 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 25, 8, 4, 0, false);            // UTC: 8:04 AM Local: 12:04 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 13, 19, 37, 0, false);          // UTC: 7:37 PM Local: 11:37 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 24, 8, 4, 0, false);            // UTC: 8:04 AM Local: 12:04 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 19, 19, 42, 0, false);          // UTC: 7:42 PM Local: 11:42 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 26, 13, 44, 0, false);          // UTC: 1:44 PM Local: 5:44 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 15, 9, 50, 0, false);           // UTC: 9:50 AM Local: 1:50 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 17, 0, 7, 0, false);            // UTC: 12:07 AM Local: 4:07 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 6, 5, 9, 0, false);             // UTC: 5:09 AM Local: 9:09 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 14, 2, 13, 0, false);           // UTC: 2:13 AM Local: 6:13 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 3, 0, 4, 0, false);             // UTC: 12:04 AM Local: 4:04 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 1, 18, 12, 6, 0, false);           // UTC: 12:06 PM Local: 4:06 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 19, 12, 44, 0, false);          // UTC: 12:44 PM Local: 4:44 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 21, 20, 53, 0, false);          // UTC: 8:53 PM Local: 12:53 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 18, 19, 27, 0, false);          // UTC: 7:27 PM Local: 11:27 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 4, 12, 19, 0, false);           // UTC: 12:19 PM Local: 4:19 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 1, 2, 50, 0, false);            // UTC: 2:50 AM Local: 6:50 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 27, 8, 51, 0, false);           // UTC: 8:51 AM Local: 12:51 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 23, 16, 1, 0, false);           // UTC: 4:01 PM Local: 8:01 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 7, 15, 6, 0, false);            // UTC: 3:06 PM Local: 7:06 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 25, 21, 43, 0, false);          // UTC: 9:43 PM Local: 1:43 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 11, 17, 21, 0, false);          // UTC: 5:21 PM Local: 9:21 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 27, 0, 18, 0, false);           // UTC: 12:18 AM Local: 4:18 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 17, 6, 3, 0, false);            // UTC: 6:03 AM Local: 10:03 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 27, 18, 29, 0, false);          // UTC: 6:29 PM Local: 10:29 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 26, 22, 10, 0, false);          // UTC: 10:10 PM Local: 2:10 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 19, 1, 41, 0, false);           // UTC: 1:41 AM Local: 5:41 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 23, 11, 58, 0, false);          // UTC: 11:58 AM Local: 3:58 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 10, 2, 37, 0, false);           // UTC: 2:37 AM Local: 6:37 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 6, 18, 50, 0, false);           // UTC: 6:50 PM Local: 10:50 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 3, 9, 50, 0, false);            // UTC: 9:50 AM Local: 1:50 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 18, 18, 57, 0, false);          // UTC: 6:57 PM Local: 10:57 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 5, 5, 5, 0, false);             // UTC: 5:05 AM Local: 9:05 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 3, 2, 31, 0, false);            // UTC: 2:31 AM Local: 6:31 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 1, 9, 50, 0, false);            // UTC: 9:50 AM Local: 1:50 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 22, 22, 33, 0, false);          // UTC: 10:33 PM Local: 2:33 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 2, 11, 20, 42, 0, false);          // UTC: 8:42 PM Local: 12:42 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 23, 13, 36, 0, true);           // UTC: 1:36 PM Local: 6:36 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 12, 2, 26, 0, true);            // UTC: 2:26 AM Local: 7:26 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 21, 0, 37, 0, true);            // UTC: 12:37 AM Local: 5:37 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 20, 18, 12, 0, true);           // UTC: 6:12 PM Local: 11:12 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 13, 12, 49, 0, true);           // UTC: 12:49 PM Local: 5:49 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 6, 8, 57, 0, false);            // UTC: 8:57 AM Local: 12:57 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 15, 17, 44, 0, true);           // UTC: 5:44 PM Local: 10:44 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 3, 13, 56, 0, false);           // UTC: 1:56 PM Local: 5:56 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 5, 18, 3, 0, false);            // UTC: 6:03 PM Local: 10:03 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 4, 13, 8, 0, false);            // UTC: 1:08 PM Local: 5:08 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 2, 18, 53, 0, false);           // UTC: 6:53 PM Local: 10:53 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 4, 5, 49, 0, false);            // UTC: 5:49 AM Local: 9:49 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 7, 5, 43, 0, false);            // UTC: 5:43 AM Local: 9:43 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 14, 9, 11, 0, true);            // UTC: 9:11 AM Local: 2:11 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 12, 8, 19, 0, true);            // UTC: 8:19 AM Local: 1:19 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 9, 13, 52, 0, false);           // UTC: 1:52 PM Local: 5:52 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 1, 13, 37, 0, false);           // UTC: 1:37 PM Local: 5:37 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 17, 19, 8, 0, true);            // UTC: 7:08 PM Local: 12:08 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 26, 17, 58, 0, true);           // UTC: 5:58 PM Local: 10:58 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 18, 5, 17, 0, true);            // UTC: 5:17 AM Local: 10:17 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 11, 14, 27, 0, true);           // UTC: 2:27 PM Local: 7:27 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 14, 15, 57, 0, true);           // UTC: 3:57 PM Local: 8:57 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 9, 7, 16, 0, false);            // UTC: 7:16 AM Local: 11:16 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 27, 22, 7, 0, true);            // UTC: 10:07 PM Local: 3:07 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 3, 7, 0, 19, 0, false);            // UTC: 12:19 AM Local: 4:19 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 16, 14, 11, 0, true);           // UTC: 2:11 PM Local: 7:11 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 17, 19, 12, 0, true);           // UTC: 7:12 PM Local: 12:12 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 5, 2, 58, 0, true);             // UTC: 2:58 AM Local: 7:58 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 14, 10, 58, 0, true);           // UTC: 10:58 AM Local: 3:58 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 21, 4, 29, 0, true);            // UTC: 4:29 AM Local: 9:29 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 23, 13, 57, 0, true);           // UTC: 1:57 PM Local: 6:57 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 12, 2, 48, 0, true);            // UTC: 2:48 AM Local: 7:48 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 20, 21, 41, 0, true);           // UTC: 9:41 PM Local: 2:41 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 10, 0, 15, 0, true);            // UTC: 12:15 AM Local: 5:15 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 17, 0, 36, 0, true);            // UTC: 12:36 AM Local: 5:36 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 14, 8, 48, 0, true);            // UTC: 8:48 AM Local: 1:48 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 22, 9, 5, 0, true);             // UTC: 9:05 AM Local: 2:05 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 22, 0, 23, 0, true);            // UTC: 12:23 AM Local: 5:23 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 3, 4, 29, 0, true);             // UTC: 4:29 AM Local: 9:29 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 13, 22, 11, 0, true);           // UTC: 10:11 PM Local: 3:11 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 27, 12, 8, 0, true);            // UTC: 12:08 PM Local: 5:08 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 22, 3, 23, 0, true);            // UTC: 3:23 AM Local: 8:23 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 4, 18, 52, 0, true);            // UTC: 6:52 PM Local: 11:52 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 14, 18, 42, 0, true);           // UTC: 6:42 PM Local: 11:42 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 14, 6, 48, 0, true);            // UTC: 6:48 AM Local: 11:48 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 26, 12, 5, 0, true);            // UTC: 12:05 PM Local: 5:05 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 11, 22, 5, 0, true);            // UTC: 10:05 PM Local: 3:05 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 5, 21, 45, 0, true);            // UTC: 9:45 PM Local: 2:45 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 11, 1, 32, 0, true);            // UTC: 1:32 AM Local: 6:32 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 4, 16, 8, 53, 0, true);            // UTC: 8:53 AM Local: 1:53 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 9, 6, 55, 0, true);             // UTC: 6:55 AM Local: 11:55 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 14, 8, 28, 0, true);            // UTC: 8:28 AM Local: 1:28 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 4, 19, 51, 0, true);            // UTC: 7:51 PM Local: 12:51 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 6, 8, 33, 0, true);             // UTC: 8:33 AM Local: 1:33 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 26, 6, 33, 0, true);            // UTC: 6:33 AM Local: 11:33 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 11, 6, 44, 0, true);            // UTC: 6:44 AM Local: 11:44 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 16, 2, 39, 0, true);            // UTC: 2:39 AM Local: 7:39 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 12, 2, 58, 0, true);            // UTC: 2:58 AM Local: 7:58 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 3, 18, 34, 0, true);            // UTC: 6:34 PM Local: 11:34 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 11, 8, 5, 0, true);             // UTC: 8:05 AM Local: 1:05 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 23, 12, 25, 0, true);           // UTC: 12:25 PM Local: 5:25 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 27, 4, 33, 0, true);            // UTC: 4:33 AM Local: 9:33 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 21, 22, 53, 0, true);           // UTC: 10:53 PM Local: 3:53 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 10, 19, 41, 0, true);           // UTC: 7:41 PM Local: 12:41 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 6, 3, 37, 0, true);             // UTC: 3:37 AM Local: 8:37 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 15, 5, 38, 0, true);            // UTC: 5:38 AM Local: 10:38 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 6, 0, 44, 0, true);             // UTC: 12:44 AM Local: 5:44 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 22, 0, 14, 0, true);            // UTC: 12:14 AM Local: 5:14 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 7, 21, 9, 0, true);             // UTC: 9:09 PM Local: 2:09 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 26, 9, 32, 0, true);            // UTC: 9:32 AM Local: 2:32 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 25, 17, 27, 0, true);           // UTC: 5:27 PM Local: 10:27 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 22, 8, 47, 0, true);            // UTC: 8:47 AM Local: 1:47 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 4, 21, 7, 0, true);             // UTC: 9:07 PM Local: 2:07 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 1, 14, 18, 0, true);            // UTC: 2:18 PM Local: 7:18 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 5, 23, 5, 15, 0, true);            // UTC: 5:15 AM Local: 10:15 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 26, 4, 55, 0, true);            // UTC: 4:55 AM Local: 9:55 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 10, 13, 33, 0, true);           // UTC: 1:33 PM Local: 6:33 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 26, 3, 20, 0, true);            // UTC: 3:20 AM Local: 8:20 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 10, 1, 32, 0, true);            // UTC: 1:32 AM Local: 6:32 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 5, 16, 15, 0, true);            // UTC: 4:15 PM Local: 9:15 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 11, 19, 34, 0, true);           // UTC: 7:34 PM Local: 12:34 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 10, 10, 6, 0, true);            // UTC: 10:06 AM Local: 3:06 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 7, 9, 47, 0, true);             // UTC: 9:47 AM Local: 2:47 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 23, 9, 17, 0, true);            // UTC: 9:17 AM Local: 2:17 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 15, 4, 24, 0, true);            // UTC: 4:24 AM Local: 9:24 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 12, 21, 46, 0, true);           // UTC: 9:46 PM Local: 2:46 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 27, 6, 42, 0, true);            // UTC: 6:42 AM Local: 11:42 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 7, 13, 48, 0, true);            // UTC: 1:48 PM Local: 6:48 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 27, 22, 33, 0, true);           // UTC: 10:33 PM Local: 3:33 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 3, 10, 18, 0, true);            // UTC: 10:18 AM Local: 3:18 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 7, 22, 12, 0, true);            // UTC: 10:12 PM Local: 3:12 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 24, 14, 46, 0, true);           // UTC: 2:46 PM Local: 7:46 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 20, 10, 45, 0, true);           // UTC: 10:45 AM Local: 3:45 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 5, 16, 46, 0, true);            // UTC: 4:46 PM Local: 9:46 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 4, 11, 10, 0, true);            // UTC: 11:10 AM Local: 4:10 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 8, 9, 58, 0, true);             // UTC: 9:58 AM Local: 2:58 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 26, 20, 6, 0, true);            // UTC: 8:06 PM Local: 1:06 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 21, 4, 26, 0, true);            // UTC: 4:26 AM Local: 9:26 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 15, 3, 14, 0, true);            // UTC: 3:14 AM Local: 8:14 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 6, 21, 9, 29, 0, true);            // UTC: 9:29 AM Local: 2:29 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 15, 3, 57, 0, true);            // UTC: 3:57 AM Local: 8:57 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 14, 13, 25, 0, true);           // UTC: 1:25 PM Local: 6:25 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 3, 15, 33, 0, true);            // UTC: 3:33 PM Local: 8:33 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 18, 15, 28, 0, true);           // UTC: 3:28 PM Local: 8:28 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 1, 18, 33, 0, true);            // UTC: 6:33 PM Local: 11:33 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 26, 2, 3, 0, true);             // UTC: 2:03 AM Local: 7:03 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 18, 15, 32, 0, true);           // UTC: 3:32 PM Local: 8:32 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 16, 3, 31, 0, true);            // UTC: 3:31 AM Local: 8:31 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 6, 11, 45, 0, true);            // UTC: 11:45 AM Local: 4:45 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 21, 7, 27, 0, true);            // UTC: 7:27 AM Local: 12:27 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 15, 22, 4, 0, true);            // UTC: 10:04 PM Local: 3:04 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 8, 14, 34, 0, true);            // UTC: 2:34 PM Local: 7:34 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 23, 14, 54, 0, true);           // UTC: 2:54 PM Local: 7:54 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 21, 4, 43, 0, true);            // UTC: 4:43 AM Local: 9:43 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 12, 7, 12, 0, true);            // UTC: 7:12 AM Local: 12:12 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 17, 16, 21, 0, true);           // UTC: 4:21 PM Local: 9:21 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 24, 14, 3, 0, true);            // UTC: 2:03 PM Local: 7:03 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 5, 2, 41, 0, true);             // UTC: 2:41 AM Local: 7:41 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 26, 21, 57, 0, true);           // UTC: 9:57 PM Local: 2:57 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 12, 6, 6, 0, true);             // UTC: 6:06 AM Local: 11:06 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 19, 7, 20, 0, true);            // UTC: 7:20 AM Local: 12:20 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 3, 2, 42, 0, true);             // UTC: 2:42 AM Local: 7:42 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 11, 17, 11, 0, true);           // UTC: 5:11 PM Local: 10:11 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 27, 2, 27, 0, true);            // UTC: 2:27 AM Local: 7:27 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 7, 4, 20, 28, 0, true);            // UTC: 8:28 PM Local: 1:28 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 22, 3, 50, 0, true);            // UTC: 3:50 AM Local: 8:50 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 9, 13, 43, 0, true);            // UTC: 1:43 PM Local: 6:43 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 11, 20, 40, 0, true);           // UTC: 8:40 PM Local: 1:40 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 12, 7, 50, 0, true);            // UTC: 7:50 AM Local: 12:50 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 11, 7, 39, 0, true);            // UTC: 7:39 AM Local: 12:39 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 17, 8, 21, 0, true);            // UTC: 8:21 AM Local: 1:21 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 22, 1, 53, 0, true);            // UTC: 1:53 AM Local: 6:53 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 11, 7, 12, 0, true);            // UTC: 7:12 AM Local: 12:12 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 14, 5, 57, 0, true);            // UTC: 5:57 AM Local: 10:57 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 5, 20, 30, 0, true);            // UTC: 8:30 PM Local: 1:30 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 17, 0, 13, 0, true);            // UTC: 12:13 AM Local: 5:13 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 6, 3, 46, 0, true);             // UTC: 3:46 AM Local: 8:46 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 4, 2, 41, 0, true);             // UTC: 2:41 AM Local: 7:41 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 11, 6, 23, 0, true);            // UTC: 6:23 AM Local: 11:23 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 18, 15, 44, 0, true);           // UTC: 3:44 PM Local: 8:44 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 24, 0, 26, 0, true);            // UTC: 12:26 AM Local: 5:26 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 15, 8, 42, 0, true);            // UTC: 8:42 AM Local: 1:42 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 3, 7, 47, 0, true);             // UTC: 7:47 AM Local: 12:47 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 16, 9, 49, 0, true);            // UTC: 9:49 AM Local: 2:49 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 18, 19, 20, 0, true);           // UTC: 7:20 PM Local: 12:20 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 21, 5, 1, 0, true);             // UTC: 5:01 AM Local: 10:01 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 5, 18, 18, 0, true);            // UTC: 6:18 PM Local: 11:18 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 17, 3, 10, 0, true);            // UTC: 3:10 AM Local: 8:10 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 25, 11, 16, 0, true);           // UTC: 11:16 AM Local: 4:16 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 8, 18, 9, 47, 0, true);            // UTC: 9:47 AM Local: 2:47 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 14, 16, 37, 0, true);           // UTC: 4:37 PM Local: 9:37 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 13, 14, 11, 0, true);           // UTC: 2:11 PM Local: 7:11 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 15, 14, 29, 0, true);           // UTC: 2:29 PM Local: 7:29 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 22, 11, 40, 0, true);           // UTC: 11:40 AM Local: 4:40 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 12, 14, 41, 0, true);           // UTC: 2:41 PM Local: 7:41 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 26, 11, 16, 0, true);           // UTC: 11:16 AM Local: 4:16 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 10, 13, 2, 0, true);            // UTC: 1:02 PM Local: 6:02 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 11, 11, 51, 0, true);           // UTC: 11:51 AM Local: 4:51 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 13, 5, 51, 0, true);            // UTC: 5:51 AM Local: 10:51 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 8, 14, 53, 0, true);            // UTC: 2:53 PM Local: 7:53 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 13, 10, 54, 0, true);           // UTC: 10:54 AM Local: 3:54 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 1, 2, 41, 0, true);             // UTC: 2:41 AM Local: 7:41 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 6, 3, 11, 0, true);             // UTC: 3:11 AM Local: 8:11 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 5, 5, 34, 0, true);             // UTC: 5:34 AM Local: 10:34 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 15, 9, 18, 0, true);            // UTC: 9:18 AM Local: 2:18 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 17, 4, 30, 0, true);            // UTC: 4:30 AM Local: 9:30 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 13, 21, 58, 0, true);           // UTC: 9:58 PM Local: 2:58 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 27, 6, 48, 0, true);            // UTC: 6:48 AM Local: 11:48 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 21, 2, 14, 0, true);            // UTC: 2:14 AM Local: 7:14 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 21, 0, 22, 0, true);            // UTC: 12:22 AM Local: 5:22 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 9, 6, 1, 0, true);              // UTC: 6:01 AM Local: 11:01 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 16, 7, 2, 0, true);             // UTC: 7:02 AM Local: 12:02 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 21, 9, 31, 0, true);            // UTC: 9:31 AM Local: 2:31 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 1, 17, 18, 0, true);            // UTC: 5:18 PM Local: 10:18 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 9, 3, 4, 21, 0, true);             // UTC: 4:21 AM Local: 9:21 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 13, 19, 4, 0, true);           // UTC: 7:04 PM Local: 12:04 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 16, 19, 2, 0, true);           // UTC: 7:02 PM Local: 12:02 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 10, 18, 40, 0, true);          // UTC: 6:40 PM Local: 11:40 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 25, 10, 8, 0, true);           // UTC: 10:08 AM Local: 3:08 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 3, 5, 58, 0, true);            // UTC: 5:58 AM Local: 10:58 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 13, 9, 9, 0, true);            // UTC: 9:09 AM Local: 2:09 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 22, 18, 56, 0, true);          // UTC: 6:56 PM Local: 11:56 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 16, 21, 4, 0, true);           // UTC: 9:04 PM Local: 2:04 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 8, 19, 45, 0, true);           // UTC: 7:45 PM Local: 12:45 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 27, 10, 10, 0, true);          // UTC: 10:10 AM Local: 3:10 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 19, 20, 6, 0, true);           // UTC: 8:06 PM Local: 1:06 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 13, 6, 14, 0, true);           // UTC: 6:14 AM Local: 11:14 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 5, 4, 10, 0, true);            // UTC: 4:10 AM Local: 9:10 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 10, 22, 28, 0, true);          // UTC: 10:28 PM Local: 3:28 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 9, 15, 51, 0, true);           // UTC: 3:51 PM Local: 8:51 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 25, 15, 11, 0, true);          // UTC: 3:11 PM Local: 8:11 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 15, 12, 19, 0, true);          // UTC: 12:19 PM Local: 5:19 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 5, 6, 21, 0, true);            // UTC: 6:21 AM Local: 11:21 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 11, 20, 54, 0, true);          // UTC: 8:54 PM Local: 1:54 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 1, 6, 58, 0, true);            // UTC: 6:58 AM Local: 11:58 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 8, 8, 19, 0, true);            // UTC: 8:19 AM Local: 1:19 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 14, 5, 32, 0, true);           // UTC: 5:32 AM Local: 10:32 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 2, 14, 55, 0, true);           // UTC: 2:55 PM Local: 7:55 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 21, 7, 12, 0, true);           // UTC: 7:12 AM Local: 12:12 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 10, 27, 10, 49, 0, true);          // UTC: 10:49 AM Local: 3:49 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 14, 5, 15, 0, false);          // UTC: 5:15 AM Local: 9:15 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 6, 8, 9, 0, false);            // UTC: 8:09 AM Local: 12:09 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 16, 10, 54, 0, false);         // UTC: 10:54 AM Local: 2:54 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 23, 11, 37, 0, false);         // UTC: 11:37 AM Local: 3:37 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 20, 1, 23, 0, false);          // UTC: 1:23 AM Local: 5:23 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 9, 3, 54, 0, false);           // UTC: 3:54 AM Local: 7:54 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 5, 1, 37, 0, false);           // UTC: 1:37 AM Local: 5:37 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 4, 18, 26, 0, false);          // UTC: 6:26 PM Local: 10:26 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 9, 19, 1, 0, false);           // UTC: 7:01 PM Local: 11:01 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 7, 18, 13, 0, false);          // UTC: 6:13 PM Local: 10:13 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 4, 4, 47, 0, false);           // UTC: 4:47 AM Local: 8:47 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 15, 21, 39, 0, false);         // UTC: 9:39 PM Local: 1:39 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 19, 18, 53, 0, false);         // UTC: 6:53 PM Local: 10:53 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 23, 15, 54, 0, false);         // UTC: 3:54 PM Local: 7:54 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 12, 15, 42, 0, false);         // UTC: 3:42 PM Local: 7:42 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 25, 7, 35, 0, false);          // UTC: 7:35 AM Local: 11:35 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 15, 9, 9, 0, false);           // UTC: 9:09 AM Local: 1:09 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 8, 18, 23, 0, false);          // UTC: 6:23 PM Local: 10:23 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 6, 7, 23, 0, false);           // UTC: 7:23 AM Local: 11:23 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 22, 20, 30, 0, false);         // UTC: 8:30 PM Local: 12:30 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 4, 7, 37, 0, false);           // UTC: 7:37 AM Local: 11:37 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 19, 16, 19, 0, false);         // UTC: 4:19 PM Local: 8:19 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 23, 4, 7, 0, false);           // UTC: 4:07 AM Local: 8:07 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 20, 14, 19, 0, false);         // UTC: 2:19 PM Local: 6:19 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 11, 1, 7, 22, 0, true);            // UTC: 7:22 AM Local: 12:22 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 20, 16, 9, 0, false);          // UTC: 4:09 PM Local: 8:09 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 20, 9, 32, 0, false);          // UTC: 9:32 AM Local: 1:32 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 12, 16, 22, 0, false);         // UTC: 4:22 PM Local: 8:22 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 2, 18, 22, 0, false);          // UTC: 6:22 PM Local: 10:22 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 11, 7, 33, 0, false);          // UTC: 7:33 AM Local: 11:33 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 8, 19, 54, 0, false);          // UTC: 7:54 PM Local: 11:54 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 11, 16, 20, 0, false);         // UTC: 4:20 PM Local: 8:20 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 8, 16, 54, 0, false);          // UTC: 4:54 PM Local: 8:54 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 11, 1, 6, 0, false);           // UTC: 1:06 AM Local: 5:06 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 13, 18, 46, 0, false);         // UTC: 6:46 PM Local: 10:46 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 23, 6, 27, 0, false);          // UTC: 6:27 AM Local: 10:27 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 1, 11, 36, 0, false);          // UTC: 11:36 AM Local: 3:36 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 7, 2, 28, 0, false);           // UTC: 2:28 AM Local: 6:28 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 27, 15, 36, 0, false);         // UTC: 3:36 PM Local: 7:36 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 8, 14, 53, 0, false);          // UTC: 2:53 PM Local: 6:53 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 27, 10, 50, 0, false);         // UTC: 10:50 AM Local: 2:50 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 16, 10, 46, 0, false);         // UTC: 10:46 AM Local: 2:46 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 11, 14, 36, 0, false);         // UTC: 2:36 PM Local: 6:36 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 1, 9, 58, 0, false);           // UTC: 9:58 AM Local: 1:58 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 7, 7, 19, 0, false);           // UTC: 7:19 AM Local: 11:19 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 12, 22, 53, 0, false);         // UTC: 10:53 PM Local: 2:53 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 16, 5, 31, 0, false);          // UTC: 5:31 AM Local: 9:31 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 25, 8, 50, 0, false);          // UTC: 8:50 AM Local: 12:50 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 26, 0, 45, 0, false);          // UTC: 12:45 AM Local: 4:45 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2019, 12, 12, 9, 1, 0, false);           // UTC: 9:01 AM Local: 1:01 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 21, 0, 6, 0, false);            // UTC: 12:06 AM Local: 4:06 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 1, 9, 37, 0, false);            // UTC: 9:37 AM Local: 1:37 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 7, 20, 21, 0, false);           // UTC: 8:21 PM Local: 12:21 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 27, 9, 38, 0, false);           // UTC: 9:38 AM Local: 1:38 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 23, 22, 2, 0, false);           // UTC: 10:02 PM Local: 2:02 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 17, 22, 44, 0, false);          // UTC: 10:44 PM Local: 2:44 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 5, 12, 42, 0, false);           // UTC: 12:42 PM Local: 4:42 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 20, 15, 22, 0, false);          // UTC: 3:22 PM Local: 7:22 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 11, 1, 3, 0, false);            // UTC: 1:03 AM Local: 5:03 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 27, 13, 24, 0, false);          // UTC: 1:24 PM Local: 5:24 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 1, 22, 12, 0, false);           // UTC: 10:12 PM Local: 2:12 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 16, 6, 24, 0, false);           // UTC: 6:24 AM Local: 10:24 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 24, 5, 54, 0, false);           // UTC: 5:54 AM Local: 9:54 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 19, 4, 4, 0, false);            // UTC: 4:04 AM Local: 8:04 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 15, 13, 46, 0, false);          // UTC: 1:46 PM Local: 5:46 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 24, 1, 23, 0, false);           // UTC: 1:23 AM Local: 5:23 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 22, 7, 3, 0, false);            // UTC: 7:03 AM Local: 11:03 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 1, 6, 51, 0, false);            // UTC: 6:51 AM Local: 10:51 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 9, 0, 20, 0, false);            // UTC: 12:20 AM Local: 4:20 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 20, 14, 21, 0, false);          // UTC: 2:21 PM Local: 6:21 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 16, 6, 17, 0, false);           // UTC: 6:17 AM Local: 10:17 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 26, 22, 27, 0, false);          // UTC: 10:27 PM Local: 2:27 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 13, 5, 40, 0, false);           // UTC: 5:40 AM Local: 9:40 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 18, 16, 44, 0, false);          // UTC: 4:44 PM Local: 8:44 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 1, 23, 10, 21, 0, false);          // UTC: 10:21 AM Local: 2:21 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 18, 3, 4, 0, false);            // UTC: 3:04 AM Local: 7:04 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 16, 11, 0, 0, false);           // UTC: 11:00 AM Local: 3:00 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 18, 4, 15, 0, false);           // UTC: 4:15 AM Local: 8:15 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 10, 0, 40, 0, false);           // UTC: 12:40 AM Local: 4:40 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 9, 6, 15, 0, false);            // UTC: 6:15 AM Local: 10:15 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 2, 3, 35, 0, false);            // UTC: 3:35 AM Local: 7:35 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 16, 2, 53, 0, false);           // UTC: 2:53 AM Local: 6:53 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 22, 13, 37, 0, false);          // UTC: 1:37 PM Local: 5:37 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 9, 9, 46, 0, false);            // UTC: 9:46 AM Local: 1:46 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 20, 3, 36, 0, false);           // UTC: 3:36 AM Local: 7:36 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 9, 4, 47, 0, false);            // UTC: 4:47 AM Local: 8:47 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 15, 15, 51, 0, false);          // UTC: 3:51 PM Local: 7:51 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 8, 3, 8, 0, false);             // UTC: 3:08 AM Local: 7:08 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 10, 21, 4, 0, false);           // UTC: 9:04 PM Local: 1:04 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 1, 13, 56, 0, false);           // UTC: 1:56 PM Local: 5:56 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 21, 3, 57, 0, false);           // UTC: 3:57 AM Local: 7:57 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 12, 13, 33, 0, false);          // UTC: 1:33 PM Local: 5:33 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 4, 5, 21, 0, false);            // UTC: 5:21 AM Local: 9:21 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 13, 19, 34, 0, false);          // UTC: 7:34 PM Local: 11:34 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 12, 6, 4, 0, false);            // UTC: 6:04 AM Local: 10:04 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 6, 21, 0, 0, false);            // UTC: 9:00 PM Local: 1:00 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 18, 1, 47, 0, false);           // UTC: 1:47 AM Local: 5:47 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 24, 18, 36, 0, false);          // UTC: 6:36 PM Local: 10:36 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 11, 17, 1, 0, false);           // UTC: 5:01 PM Local: 9:01 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 2, 13, 4, 10, 0, false);           // UTC: 4:10 AM Local: 8:10 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 23, 17, 57, 0, true);           // UTC: 5:57 PM Local: 10:57 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 18, 12, 17, 0, true);           // UTC: 12:17 PM Local: 5:17 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 23, 6, 34, 0, true);            // UTC: 6:34 AM Local: 11:34 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 1, 3, 55, 0, false);            // UTC: 3:55 AM Local: 7:55 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 13, 1, 47, 0, true);            // UTC: 1:47 AM Local: 6:47 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 8, 19, 51, 0, true);            // UTC: 7:51 PM Local: 12:51 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 2, 3, 58, 0, false);            // UTC: 3:58 AM Local: 7:58 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 2, 8, 32, 0, false);            // UTC: 8:32 AM Local: 12:32 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 5, 20, 19, 0, false);           // UTC: 8:19 PM Local: 12:19 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 10, 0, 47, 0, true);            // UTC: 12:47 AM Local: 5:47 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 15, 15, 2, 0, true);            // UTC: 3:02 PM Local: 8:02 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 5, 14, 6, 0, false);            // UTC: 2:06 PM Local: 6:06 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 17, 17, 41, 0, true);           // UTC: 5:41 PM Local: 10:41 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 22, 9, 39, 0, true);            // UTC: 9:39 AM Local: 2:39 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 12, 14, 53, 0, true);           // UTC: 2:53 PM Local: 7:53 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 24, 10, 42, 0, true);           // UTC: 10:42 AM Local: 3:42 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 22, 2, 55, 0, true);            // UTC: 2:55 AM Local: 7:55 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 5, 9, 3, 0, false);             // UTC: 9:03 AM Local: 1:03 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 6, 17, 22, 0, false);           // UTC: 5:22 PM Local: 9:22 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 12, 11, 38, 0, true);           // UTC: 11:38 AM Local: 4:38 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 26, 10, 13, 0, true);           // UTC: 10:13 AM Local: 3:13 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 22, 11, 27, 0, true);           // UTC: 11:27 AM Local: 4:27 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 25, 6, 27, 0, true);            // UTC: 6:27 AM Local: 11:27 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 19, 15, 4, 0, true);            // UTC: 3:04 PM Local: 8:04 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 3, 5, 6, 44, 0, false);            // UTC: 6:44 AM Local: 10:44 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 9, 14, 44, 0, true);            // UTC: 2:44 PM Local: 7:44 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 18, 7, 26, 0, true);            // UTC: 7:26 AM Local: 12:26 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 17, 12, 54, 0, true);           // UTC: 12:54 PM Local: 5:54 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 24, 9, 17, 0, true);            // UTC: 9:17 AM Local: 2:17 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 27, 22, 50, 0, true);           // UTC: 10:50 PM Local: 3:50 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 20, 4, 15, 0, true);            // UTC: 4:15 AM Local: 9:15 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 2, 19, 55, 0, true);            // UTC: 7:55 PM Local: 12:55 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 12, 14, 7, 0, true);            // UTC: 2:07 PM Local: 7:07 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 12, 21, 9, 0, true);            // UTC: 9:09 PM Local: 2:09 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 8, 2, 26, 0, true);             // UTC: 2:26 AM Local: 7:26 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 24, 22, 6, 0, true);            // UTC: 10:06 PM Local: 3:06 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 9, 20, 6, 0, true);             // UTC: 8:06 PM Local: 1:06 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 18, 18, 11, 0, true);           // UTC: 6:11 PM Local: 11:11 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 6, 8, 52, 0, true);             // UTC: 8:52 AM Local: 1:52 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 9, 21, 4, 0, true);             // UTC: 9:04 PM Local: 2:04 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 5, 21, 16, 0, true);            // UTC: 9:16 PM Local: 2:16 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 17, 22, 28, 0, true);           // UTC: 10:28 PM Local: 3:28 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 22, 2, 26, 0, true);            // UTC: 2:26 AM Local: 7:26 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 22, 20, 1, 0, true);            // UTC: 8:01 PM Local: 1:01 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 17, 4, 21, 0, true);            // UTC: 4:21 AM Local: 9:21 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 8, 7, 26, 0, true);             // UTC: 7:26 AM Local: 12:26 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 14, 0, 24, 0, true);            // UTC: 12:24 AM Local: 5:24 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 5, 15, 6, 0, true);             // UTC: 3:06 PM Local: 8:06 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 20, 2, 22, 0, true);            // UTC: 2:22 AM Local: 7:22 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 4, 3, 19, 27, 0, true);            // UTC: 7:27 PM Local: 12:27 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 2, 2, 42, 0, true);             // UTC: 2:42 AM Local: 7:42 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 2, 5, 0, 0, true);              // UTC: 5:00 AM Local: 10:00 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 24, 15, 8, 0, true);            // UTC: 3:08 PM Local: 8:08 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 26, 1, 51, 0, true);            // UTC: 1:51 AM Local: 6:51 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 18, 11, 57, 0, true);           // UTC: 11:57 AM Local: 4:57 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 3, 0, 34, 0, true);             // UTC: 12:34 AM Local: 5:34 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 23, 20, 1, 0, true);            // UTC: 8:01 PM Local: 1:01 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 13, 18, 53, 0, true);           // UTC: 6:53 PM Local: 11:53 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 18, 22, 16, 0, true);           // UTC: 10:16 PM Local: 3:16 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 5, 20, 51, 0, true);            // UTC: 8:51 PM Local: 1:51 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 3, 16, 15, 0, true);            // UTC: 4:15 PM Local: 9:15 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 27, 17, 45, 0, true);           // UTC: 5:45 PM Local: 10:45 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 9, 13, 55, 0, true);            // UTC: 1:55 PM Local: 6:55 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 10, 9, 40, 0, true);            // UTC: 9:40 AM Local: 2:40 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 8, 12, 55, 0, true);            // UTC: 12:55 PM Local: 5:55 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 15, 12, 8, 0, true);            // UTC: 12:08 PM Local: 5:08 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 4, 14, 4, 0, true);             // UTC: 2:04 PM Local: 7:04 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 22, 5, 55, 0, true);            // UTC: 5:55 AM Local: 10:55 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 13, 13, 17, 0, true);           // UTC: 1:17 PM Local: 6:17 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 22, 8, 15, 0, true);            // UTC: 8:15 AM Local: 1:15 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 20, 16, 45, 0, true);           // UTC: 4:45 PM Local: 9:45 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 8, 19, 20, 0, true);            // UTC: 7:20 PM Local: 12:20 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 17, 15, 44, 0, true);           // UTC: 3:44 PM Local: 8:44 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 6, 18, 26, 0, true);            // UTC: 6:26 PM Local: 11:26 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 5, 18, 11, 29, 0, true);           // UTC: 11:29 AM Local: 4:29 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 10, 3, 17, 0, true);            // UTC: 3:17 AM Local: 8:17 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 26, 2, 27, 0, true);            // UTC: 2:27 AM Local: 7:27 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 4, 0, 14, 0, true);             // UTC: 12:14 AM Local: 5:14 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 22, 6, 28, 0, true);            // UTC: 6:28 AM Local: 11:28 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 9, 12, 8, 0, true);             // UTC: 12:08 PM Local: 5:08 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 13, 11, 10, 0, true);           // UTC: 11:10 AM Local: 4:10 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 19, 13, 41, 0, true);           // UTC: 1:41 PM Local: 6:41 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 25, 0, 39, 0, true);            // UTC: 12:39 AM Local: 5:39 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 17, 21, 50, 0, true);           // UTC: 9:50 PM Local: 2:50 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 11, 21, 49, 0, true);           // UTC: 9:49 PM Local: 2:49 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 18, 3, 44, 0, true);            // UTC: 3:44 AM Local: 8:44 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 12, 2, 26, 0, true);            // UTC: 2:26 AM Local: 7:26 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 1, 19, 15, 0, true);            // UTC: 7:15 PM Local: 12:15 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 22, 14, 39, 0, true);           // UTC: 2:39 PM Local: 7:39 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 15, 11, 32, 0, true);           // UTC: 11:32 AM Local: 4:32 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 24, 6, 8, 0, true);             // UTC: 6:08 AM Local: 11:08 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 17, 16, 17, 0, true);           // UTC: 4:17 PM Local: 9:17 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 8, 21, 52, 0, true);            // UTC: 9:52 PM Local: 2:52 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 22, 9, 8, 0, true);             // UTC: 9:08 AM Local: 2:08 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 17, 8, 11, 0, true);            // UTC: 8:11 AM Local: 1:11 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 17, 17, 6, 0, true);            // UTC: 5:06 PM Local: 10:06 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 12, 3, 7, 0, true);             // UTC: 3:07 AM Local: 8:07 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 20, 20, 25, 0, true);           // UTC: 8:25 PM Local: 1:25 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 19, 10, 38, 0, true);           // UTC: 10:38 AM Local: 3:38 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 6, 25, 20, 58, 0, true);           // UTC: 8:58 PM Local: 1:58 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 2, 8, 31, 0, true);             // UTC: 8:31 AM Local: 1:31 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 4, 17, 38, 0, true);            // UTC: 5:38 PM Local: 10:38 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 20, 17, 12, 0, true);           // UTC: 5:12 PM Local: 10:12 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 15, 8, 12, 0, true);            // UTC: 8:12 AM Local: 1:12 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 24, 14, 40, 0, true);           // UTC: 2:40 PM Local: 7:40 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 9, 8, 28, 0, true);             // UTC: 8:28 AM Local: 1:28 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 3, 4, 51, 0, true);             // UTC: 4:51 AM Local: 9:51 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 16, 2, 19, 0, true);            // UTC: 2:19 AM Local: 7:19 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 12, 2, 22, 0, true);            // UTC: 2:22 AM Local: 7:22 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 20, 21, 14, 0, true);           // UTC: 9:14 PM Local: 2:14 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 18, 8, 3, 0, true);             // UTC: 8:03 AM Local: 1:03 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 25, 17, 2, 0, true);            // UTC: 5:02 PM Local: 10:02 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 17, 11, 35, 0, true);           // UTC: 11:35 AM Local: 4:35 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 15, 20, 57, 0, true);           // UTC: 8:57 PM Local: 1:57 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 25, 19, 46, 0, true);           // UTC: 7:46 PM Local: 12:46 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 25, 20, 16, 0, true);           // UTC: 8:16 PM Local: 1:16 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 21, 8, 5, 0, true);             // UTC: 8:05 AM Local: 1:05 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 5, 19, 41, 0, true);            // UTC: 7:41 PM Local: 12:41 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 4, 11, 15, 0, true);            // UTC: 11:15 AM Local: 4:15 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 6, 16, 36, 0, true);            // UTC: 4:36 PM Local: 9:36 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 8, 0, 49, 0, true);             // UTC: 12:49 AM Local: 5:49 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 27, 20, 0, 0, true);            // UTC: 8:00 PM Local: 1:00 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 5, 22, 51, 0, true);            // UTC: 10:51 PM Local: 3:51 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 18, 16, 52, 0, true);           // UTC: 4:52 PM Local: 9:52 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 7, 24, 12, 16, 0, true);           // UTC: 12:16 PM Local: 5:16 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 25, 15, 14, 0, true);           // UTC: 3:14 PM Local: 8:14 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 15, 11, 14, 0, true);           // UTC: 11:14 AM Local: 4:14 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 3, 22, 31, 0, true);            // UTC: 10:31 PM Local: 3:31 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 5, 10, 30, 0, true);            // UTC: 10:30 AM Local: 3:30 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 10, 17, 16, 0, true);           // UTC: 5:16 PM Local: 10:16 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 21, 9, 46, 0, true);            // UTC: 9:46 AM Local: 2:46 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 27, 5, 52, 0, true);            // UTC: 5:52 AM Local: 10:52 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 4, 21, 56, 0, true);            // UTC: 9:56 PM Local: 2:56 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 21, 17, 54, 0, true);           // UTC: 5:54 PM Local: 10:54 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 11, 2, 40, 0, true);            // UTC: 2:40 AM Local: 7:40 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 6, 6, 17, 0, true);             // UTC: 6:17 AM Local: 11:17 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 12, 5, 48, 0, true);            // UTC: 5:48 AM Local: 10:48 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 1, 15, 11, 0, true);            // UTC: 3:11 PM Local: 8:11 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 11, 4, 2, 0, true);             // UTC: 4:02 AM Local: 9:02 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 9, 18, 25, 0, true);            // UTC: 6:25 PM Local: 11:25 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 14, 18, 10, 0, true);           // UTC: 6:10 PM Local: 11:10 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 16, 19, 18, 0, true);           // UTC: 7:18 PM Local: 12:18 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 3, 20, 17, 0, true);            // UTC: 8:17 PM Local: 1:17 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 11, 17, 43, 0, true);           // UTC: 5:43 PM Local: 10:43 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 8, 17, 44, 0, true);            // UTC: 5:44 PM Local: 10:44 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 10, 16, 50, 0, true);           // UTC: 4:50 PM Local: 9:50 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 24, 21, 10, 0, true);           // UTC: 9:10 PM Local: 2:10 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 7, 21, 32, 0, true);            // UTC: 9:32 PM Local: 2:32 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 13, 17, 43, 0, true);           // UTC: 5:43 PM Local: 10:43 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 8, 16, 13, 3, 0, true);            // UTC: 1:03 PM Local: 6:03 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 23, 18, 6, 0, true);            // UTC: 6:06 PM Local: 11:06 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 15, 6, 57, 0, true);            // UTC: 6:57 AM Local: 11:57 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 20, 18, 15, 0, true);           // UTC: 6:15 PM Local: 11:15 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 11, 2, 22, 0, true);            // UTC: 2:22 AM Local: 7:22 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 27, 0, 27, 0, true);            // UTC: 12:27 AM Local: 5:27 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 3, 16, 52, 0, true);            // UTC: 4:52 PM Local: 9:52 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 13, 0, 28, 0, true);            // UTC: 12:28 AM Local: 5:28 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 6, 10, 51, 0, true);            // UTC: 10:51 AM Local: 3:51 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 8, 6, 49, 0, true);             // UTC: 6:49 AM Local: 11:49 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 18, 2, 5, 0, true);             // UTC: 2:05 AM Local: 7:05 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 16, 11, 17, 0, true);           // UTC: 11:17 AM Local: 4:17 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 7, 12, 55, 0, true);            // UTC: 12:55 PM Local: 5:55 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 17, 17, 28, 0, true);           // UTC: 5:28 PM Local: 10:28 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 21, 13, 51, 0, true);           // UTC: 1:51 PM Local: 6:51 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 16, 11, 49, 0, true);           // UTC: 11:49 AM Local: 4:49 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 22, 5, 53, 0, true);            // UTC: 5:53 AM Local: 10:53 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 3, 8, 1, 0, true);              // UTC: 8:01 AM Local: 1:01 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 24, 3, 33, 0, true);            // UTC: 3:33 AM Local: 8:33 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 16, 15, 21, 0, true);           // UTC: 3:21 PM Local: 8:21 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 7, 5, 1, 0, true);              // UTC: 5:01 AM Local: 10:01 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 4, 2, 41, 0, true);             // UTC: 2:41 AM Local: 7:41 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 5, 18, 35, 0, true);            // UTC: 6:35 PM Local: 11:35 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 3, 17, 28, 0, true);            // UTC: 5:28 PM Local: 10:28 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 15, 10, 57, 0, true);           // UTC: 10:57 AM Local: 3:57 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 9, 11, 15, 26, 0, true);           // UTC: 3:26 PM Local: 8:26 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 17, 13, 56, 0, true);          // UTC: 1:56 PM Local: 6:56 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 2, 10, 1, 0, true);            // UTC: 10:01 AM Local: 3:01 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 26, 12, 43, 0, true);          // UTC: 12:43 PM Local: 5:43 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 3, 16, 22, 0, true);           // UTC: 4:22 PM Local: 9:22 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 20, 15, 52, 0, true);          // UTC: 3:52 PM Local: 8:52 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 16, 8, 29, 0, true);           // UTC: 8:29 AM Local: 1:29 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 13, 14, 29, 0, true);          // UTC: 2:29 PM Local: 7:29 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 5, 9, 40, 0, true);            // UTC: 9:40 AM Local: 2:40 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 7, 16, 28, 0, true);           // UTC: 4:28 PM Local: 9:28 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 12, 12, 53, 0, true);          // UTC: 12:53 PM Local: 5:53 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 2, 10, 26, 0, true);           // UTC: 10:26 AM Local: 3:26 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 4, 22, 2, 0, true);            // UTC: 10:02 PM Local: 3:02 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 11, 4, 46, 0, true);           // UTC: 4:46 AM Local: 9:46 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 27, 4, 31, 0, true);           // UTC: 4:31 AM Local: 9:31 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 27, 2, 5, 0, true);            // UTC: 2:05 AM Local: 7:05 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 6, 8, 5, 0, true);             // UTC: 8:05 AM Local: 1:05 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 17, 21, 5, 0, true);           // UTC: 9:05 PM Local: 2:05 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 13, 21, 1, 0, true);           // UTC: 9:01 PM Local: 2:01 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 26, 9, 10, 0, true);           // UTC: 9:10 AM Local: 2:10 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 8, 18, 45, 0, true);           // UTC: 6:45 PM Local: 11:45 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 15, 11, 0, 0, true);           // UTC: 11:00 AM Local: 4:00 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 23, 0, 15, 0, true);           // UTC: 12:15 AM Local: 5:15 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 26, 14, 40, 0, true);          // UTC: 2:40 PM Local: 7:40 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 23, 4, 10, 0, true);           // UTC: 4:10 AM Local: 9:10 PM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 10, 20, 10, 26, 0, true);          // UTC: 10:26 AM Local: 3:26 AM Offset: -07:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 27, 4, 19, 0, false);          // UTC: 4:19 AM Local: 8:19 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 16, 0, 20, 0, false);          // UTC: 12:20 AM Local: 4:20 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 11, 18, 36, 0, false);         // UTC: 6:36 PM Local: 10:36 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 23, 13, 30, 0, false);         // UTC: 1:30 PM Local: 5:30 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 12, 4, 32, 0, false);          // UTC: 4:32 AM Local: 8:32 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 24, 2, 23, 0, false);          // UTC: 2:23 AM Local: 6:23 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 1, 10, 40, 0, false);          // UTC: 10:40 AM Local: 2:40 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 15, 3, 3, 0, false);           // UTC: 3:03 AM Local: 7:03 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 23, 6, 43, 0, false);          // UTC: 6:43 AM Local: 10:43 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 12, 17, 45, 0, false);         // UTC: 5:45 PM Local: 9:45 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 25, 17, 27, 0, false);         // UTC: 5:27 PM Local: 9:27 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 16, 22, 12, 0, false);         // UTC: 10:12 PM Local: 2:12 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 24, 16, 46, 0, false);         // UTC: 4:46 PM Local: 8:46 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 12, 3, 40, 0, false);          // UTC: 3:40 AM Local: 7:40 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 11, 0, 25, 0, false);          // UTC: 12:25 AM Local: 4:25 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 20, 11, 25, 0, false);         // UTC: 11:25 AM Local: 3:25 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 4, 22, 3, 0, false);           // UTC: 10:03 PM Local: 2:03 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 22, 16, 0, 0, false);          // UTC: 4:00 PM Local: 8:00 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 21, 9, 3, 0, false);           // UTC: 9:03 AM Local: 1:03 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 8, 16, 43, 0, false);          // UTC: 4:43 PM Local: 8:43 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 17, 22, 2, 0, false);          // UTC: 10:02 PM Local: 2:02 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 23, 20, 50, 0, false);         // UTC: 8:50 PM Local: 12:50 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 2, 19, 12, 0, false);          // UTC: 7:12 PM Local: 11:12 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 10, 0, 24, 0, false);          // UTC: 12:24 AM Local: 4:24 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 11, 17, 13, 16, 0, false);         // UTC: 1:16 PM Local: 5:16 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 27, 3, 8, 0, false);           // UTC: 3:08 AM Local: 7:08 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 18, 2, 46, 0, false);          // UTC: 2:46 AM Local: 6:46 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 9, 6, 47, 0, false);           // UTC: 6:47 AM Local: 10:47 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 20, 3, 1, 0, false);           // UTC: 3:01 AM Local: 7:01 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 13, 18, 31, 0, false);         // UTC: 6:31 PM Local: 10:31 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 5, 13, 57, 0, false);          // UTC: 1:57 PM Local: 5:57 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 2, 18, 12, 0, false);          // UTC: 6:12 PM Local: 10:12 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 18, 12, 6, 0, false);          // UTC: 12:06 PM Local: 4:06 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 16, 15, 38, 0, false);         // UTC: 3:38 PM Local: 7:38 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 6, 18, 56, 0, false);          // UTC: 6:56 PM Local: 10:56 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 18, 4, 7, 0, false);           // UTC: 4:07 AM Local: 8:07 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 20, 18, 17, 0, false);         // UTC: 6:17 PM Local: 10:17 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 25, 14, 36, 0, false);         // UTC: 2:36 PM Local: 6:36 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 26, 6, 40, 0, false);          // UTC: 6:40 AM Local: 10:40 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 7, 3, 44, 0, false);           // UTC: 3:44 AM Local: 7:44 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 23, 13, 2, 0, false);          // UTC: 1:02 PM Local: 5:02 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 19, 4, 25, 0, false);          // UTC: 4:25 AM Local: 8:25 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 12, 12, 45, 0, false);         // UTC: 12:45 PM Local: 4:45 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 3, 7, 35, 0, false);           // UTC: 7:35 AM Local: 11:35 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 2, 1, 25, 0, false);           // UTC: 1:25 AM Local: 5:25 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 4, 2, 28, 0, false);           // UTC: 2:28 AM Local: 6:28 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 23, 1, 56, 0, false);          // UTC: 1:56 AM Local: 5:56 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 25, 16, 0, 0, false);          // UTC: 4:00 PM Local: 8:00 AM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 7, 5, 56, 0, false);           // UTC: 5:56 AM Local: 9:56 PM Offset: -08:00:00
	testCount++; failedCount += test(timeManager, 6, 2020, 12, 10, 2, 31, 0, false);          // UTC: 2:31 AM Local: 6:31 PM Offset: -08:00:00

	Serial.println(); Serial.print(failedCount); Serial.print(" of "); Serial.print(testCount); Serial.println(" test(s) failed.");
}
#endif
