#ifndef TEST_TIMEZONEID_5_H
#define TEST_TIMEZONEID_5_H

#include "TimeManager.h"
#include "TestHelper.h"

void run_TimeZoneId_5_Tests(const TimeManager& timeManager)
{
	uint16_t testCount = 0;
	uint16_t failedCount = 0;

	testCount++; failedCount += test(timeManager, 5, 2018, 1, 21, 19, 48, 0, false);          // UTC: 7:48 PM Local: 5:48 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 14, 14, 11, 0, false);          // UTC: 2:11 PM Local: 12:11 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 23, 19, 3, 0, false);           // UTC: 7:03 PM Local: 5:03 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 18, 16, 17, 0, false);          // UTC: 4:17 PM Local: 2:17 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 19, 8, 35, 0, false);           // UTC: 8:35 AM Local: 6:35 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 23, 17, 11, 0, false);          // UTC: 5:11 PM Local: 3:11 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 20, 5, 58, 0, false);           // UTC: 5:58 AM Local: 3:58 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 1, 1, 40, 0, false);            // UTC: 1:40 AM Local: 11:40 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 23, 20, 53, 0, false);          // UTC: 8:53 PM Local: 6:53 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 14, 7, 38, 0, false);           // UTC: 7:38 AM Local: 5:38 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 6, 8, 54, 0, false);            // UTC: 8:54 AM Local: 6:54 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 9, 0, 55, 0, false);            // UTC: 12:55 AM Local: 10:55 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 5, 5, 20, 0, false);            // UTC: 5:20 AM Local: 3:20 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 7, 15, 35, 0, false);           // UTC: 3:35 PM Local: 1:35 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 20, 5, 31, 0, false);           // UTC: 5:31 AM Local: 3:31 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 3, 12, 1, 0, false);            // UTC: 12:01 PM Local: 10:01 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 22, 19, 23, 0, false);          // UTC: 7:23 PM Local: 5:23 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 8, 15, 58, 0, false);           // UTC: 3:58 PM Local: 1:58 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 9, 17, 45, 0, false);           // UTC: 5:45 PM Local: 3:45 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 4, 15, 43, 0, false);           // UTC: 3:43 PM Local: 1:43 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 8, 7, 31, 0, false);            // UTC: 7:31 AM Local: 5:31 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 11, 9, 22, 0, false);           // UTC: 9:22 AM Local: 7:22 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 11, 9, 20, 0, false);           // UTC: 9:20 AM Local: 7:20 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 19, 15, 29, 0, false);          // UTC: 3:29 PM Local: 1:29 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 1, 23, 10, 33, 0, false);          // UTC: 10:33 AM Local: 8:33 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 11, 6, 49, 0, false);           // UTC: 6:49 AM Local: 4:49 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 5, 17, 19, 0, false);           // UTC: 5:19 PM Local: 3:19 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 24, 16, 27, 0, false);          // UTC: 4:27 PM Local: 2:27 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 7, 21, 39, 0, false);           // UTC: 9:39 PM Local: 7:39 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 25, 22, 14, 0, false);          // UTC: 10:14 PM Local: 8:14 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 5, 0, 34, 0, false);            // UTC: 12:34 AM Local: 10:34 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 17, 21, 20, 0, false);          // UTC: 9:20 PM Local: 7:20 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 3, 7, 46, 0, false);            // UTC: 7:46 AM Local: 5:46 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 5, 16, 10, 0, false);           // UTC: 4:10 PM Local: 2:10 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 19, 2, 10, 0, false);           // UTC: 2:10 AM Local: 12:10 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 25, 10, 12, 0, false);          // UTC: 10:12 AM Local: 8:12 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 12, 21, 28, 0, false);          // UTC: 9:28 PM Local: 7:28 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 26, 22, 54, 0, false);          // UTC: 10:54 PM Local: 8:54 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 11, 9, 35, 0, false);           // UTC: 9:35 AM Local: 7:35 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 2, 3, 29, 0, false);            // UTC: 3:29 AM Local: 1:29 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 19, 10, 24, 0, false);          // UTC: 10:24 AM Local: 8:24 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 3, 11, 37, 0, false);           // UTC: 11:37 AM Local: 9:37 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 26, 4, 30, 0, false);           // UTC: 4:30 AM Local: 2:30 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 7, 6, 56, 0, false);            // UTC: 6:56 AM Local: 4:56 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 2, 22, 1, 0, false);            // UTC: 10:01 PM Local: 8:01 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 5, 5, 35, 0, false);            // UTC: 5:35 AM Local: 3:35 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 8, 7, 28, 0, false);            // UTC: 7:28 AM Local: 5:28 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 13, 11, 2, 0, false);           // UTC: 11:02 AM Local: 9:02 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 21, 5, 2, 0, false);            // UTC: 5:02 AM Local: 3:02 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 2, 18, 5, 32, 0, false);           // UTC: 5:32 AM Local: 3:32 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 20, 0, 9, 0, false);            // UTC: 12:09 AM Local: 10:09 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 8, 10, 15, 0, false);           // UTC: 10:15 AM Local: 8:15 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 21, 13, 35, 0, false);          // UTC: 1:35 PM Local: 11:35 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 15, 22, 13, 0, false);          // UTC: 10:13 PM Local: 8:13 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 19, 4, 38, 0, false);           // UTC: 4:38 AM Local: 2:38 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 15, 20, 58, 0, false);          // UTC: 8:58 PM Local: 6:58 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 24, 5, 10, 0, false);           // UTC: 5:10 AM Local: 3:10 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 1, 17, 47, 0, false);           // UTC: 5:47 PM Local: 3:47 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 1, 5, 56, 0, false);            // UTC: 5:56 AM Local: 3:56 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 11, 7, 16, 0, false);           // UTC: 7:16 AM Local: 5:16 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 16, 6, 58, 0, false);           // UTC: 6:58 AM Local: 4:58 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 27, 11, 16, 0, false);          // UTC: 11:16 AM Local: 9:16 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 22, 17, 31, 0, false);          // UTC: 5:31 PM Local: 3:31 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 21, 9, 38, 0, false);           // UTC: 9:38 AM Local: 7:38 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 1, 17, 21, 0, false);           // UTC: 5:21 PM Local: 3:21 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 8, 18, 17, 0, false);           // UTC: 6:17 PM Local: 4:17 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 11, 5, 21, 0, false);           // UTC: 5:21 AM Local: 3:21 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 2, 17, 0, 0, false);            // UTC: 5:00 PM Local: 3:00 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 11, 16, 15, 0, false);          // UTC: 4:15 PM Local: 2:15 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 10, 6, 13, 0, false);           // UTC: 6:13 AM Local: 4:13 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 9, 8, 13, 0, false);            // UTC: 8:13 AM Local: 6:13 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 9, 22, 41, 0, false);           // UTC: 10:41 PM Local: 8:41 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 7, 16, 41, 0, false);           // UTC: 4:41 PM Local: 2:41 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 11, 16, 7, 0, false);           // UTC: 4:07 PM Local: 2:07 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 3, 13, 2, 48, 0, false);           // UTC: 2:48 AM Local: 12:48 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 15, 22, 1, 0, false);           // UTC: 10:01 PM Local: 8:01 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 12, 17, 26, 0, false);          // UTC: 5:26 PM Local: 3:26 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 18, 22, 5, 0, false);           // UTC: 10:05 PM Local: 8:05 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 25, 12, 28, 0, false);          // UTC: 12:28 PM Local: 10:28 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 27, 13, 44, 0, false);          // UTC: 1:44 PM Local: 11:44 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 1, 10, 28, 0, false);           // UTC: 10:28 AM Local: 8:28 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 9, 10, 2, 0, false);            // UTC: 10:02 AM Local: 8:02 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 12, 15, 46, 0, false);          // UTC: 3:46 PM Local: 1:46 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 18, 0, 4, 0, false);            // UTC: 12:04 AM Local: 10:04 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 16, 0, 30, 0, false);           // UTC: 12:30 AM Local: 10:30 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 7, 13, 39, 0, false);           // UTC: 1:39 PM Local: 11:39 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 6, 19, 43, 0, false);           // UTC: 7:43 PM Local: 5:43 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 7, 20, 31, 0, false);           // UTC: 8:31 PM Local: 6:31 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 21, 14, 22, 0, false);          // UTC: 2:22 PM Local: 12:22 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 4, 9, 25, 0, false);            // UTC: 9:25 AM Local: 7:25 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 7, 5, 7, 0, false);             // UTC: 5:07 AM Local: 3:07 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 26, 8, 16, 0, false);           // UTC: 8:16 AM Local: 6:16 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 18, 3, 38, 0, false);           // UTC: 3:38 AM Local: 1:38 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 21, 2, 18, 0, false);           // UTC: 2:18 AM Local: 12:18 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 7, 17, 41, 0, false);           // UTC: 5:41 PM Local: 3:41 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 11, 1, 57, 0, false);           // UTC: 1:57 AM Local: 11:57 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 16, 15, 54, 0, false);          // UTC: 3:54 PM Local: 1:54 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 23, 18, 43, 0, false);          // UTC: 6:43 PM Local: 4:43 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 1, 18, 31, 0, false);           // UTC: 6:31 PM Local: 4:31 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 4, 26, 12, 48, 0, false);          // UTC: 12:48 PM Local: 10:48 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 18, 6, 15, 0, false);           // UTC: 6:15 AM Local: 4:15 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 10, 10, 45, 0, false);          // UTC: 10:45 AM Local: 8:45 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 26, 14, 39, 0, false);          // UTC: 2:39 PM Local: 12:39 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 7, 13, 27, 0, false);           // UTC: 1:27 PM Local: 11:27 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 1, 9, 43, 0, false);            // UTC: 9:43 AM Local: 7:43 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 12, 0, 7, 0, false);            // UTC: 12:07 AM Local: 10:07 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 23, 9, 33, 0, false);           // UTC: 9:33 AM Local: 7:33 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 12, 13, 43, 0, false);          // UTC: 1:43 PM Local: 11:43 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 14, 9, 27, 0, false);           // UTC: 9:27 AM Local: 7:27 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 11, 21, 33, 0, false);          // UTC: 9:33 PM Local: 7:33 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 20, 16, 35, 0, false);          // UTC: 4:35 PM Local: 2:35 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 23, 2, 49, 0, false);           // UTC: 2:49 AM Local: 12:49 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 2, 20, 19, 0, false);           // UTC: 8:19 PM Local: 6:19 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 26, 10, 26, 0, false);          // UTC: 10:26 AM Local: 8:26 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 9, 7, 5, 0, false);             // UTC: 7:05 AM Local: 5:05 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 13, 18, 22, 0, false);          // UTC: 6:22 PM Local: 4:22 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 1, 13, 46, 0, false);           // UTC: 1:46 PM Local: 11:46 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 11, 2, 8, 0, false);            // UTC: 2:08 AM Local: 12:08 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 7, 5, 41, 0, false);            // UTC: 5:41 AM Local: 3:41 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 15, 19, 2, 0, false);           // UTC: 7:02 PM Local: 5:02 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 9, 12, 40, 0, false);           // UTC: 12:40 PM Local: 10:40 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 3, 11, 51, 0, false);           // UTC: 11:51 AM Local: 9:51 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 24, 4, 17, 0, false);           // UTC: 4:17 AM Local: 2:17 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 25, 8, 7, 0, false);            // UTC: 8:07 AM Local: 6:07 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 5, 22, 20, 56, 0, false);          // UTC: 8:56 PM Local: 6:56 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 4, 2, 14, 0, false);            // UTC: 2:14 AM Local: 12:14 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 18, 1, 35, 0, false);           // UTC: 1:35 AM Local: 11:35 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 3, 8, 19, 0, false);            // UTC: 8:19 AM Local: 6:19 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 22, 7, 35, 0, false);           // UTC: 7:35 AM Local: 5:35 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 13, 13, 51, 0, false);          // UTC: 1:51 PM Local: 11:51 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 4, 12, 0, 0, false);            // UTC: 12:00 PM Local: 10:00 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 9, 14, 52, 0, false);           // UTC: 2:52 PM Local: 12:52 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 21, 4, 47, 0, false);           // UTC: 4:47 AM Local: 2:47 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 7, 13, 36, 0, false);           // UTC: 1:36 PM Local: 11:36 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 3, 2, 14, 0, false);            // UTC: 2:14 AM Local: 12:14 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 18, 14, 13, 0, false);          // UTC: 2:13 PM Local: 12:13 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 6, 2, 8, 0, false);             // UTC: 2:08 AM Local: 12:08 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 13, 20, 46, 0, false);          // UTC: 8:46 PM Local: 6:46 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 12, 5, 9, 0, false);            // UTC: 5:09 AM Local: 3:09 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 10, 7, 11, 0, false);           // UTC: 7:11 AM Local: 5:11 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 8, 9, 35, 0, false);            // UTC: 9:35 AM Local: 7:35 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 12, 17, 49, 0, false);          // UTC: 5:49 PM Local: 3:49 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 4, 11, 15, 0, false);           // UTC: 11:15 AM Local: 9:15 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 2, 8, 52, 0, false);            // UTC: 8:52 AM Local: 6:52 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 12, 9, 29, 0, false);           // UTC: 9:29 AM Local: 7:29 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 27, 0, 16, 0, false);           // UTC: 12:16 AM Local: 10:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 3, 3, 42, 0, false);            // UTC: 3:42 AM Local: 1:42 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 10, 5, 27, 0, false);           // UTC: 5:27 AM Local: 3:27 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 20, 15, 36, 0, false);          // UTC: 3:36 PM Local: 1:36 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 6, 7, 19, 24, 0, false);           // UTC: 7:24 PM Local: 5:24 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 20, 9, 52, 0, false);           // UTC: 9:52 AM Local: 7:52 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 17, 21, 8, 0, false);           // UTC: 9:08 PM Local: 7:08 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 1, 15, 19, 0, false);           // UTC: 3:19 PM Local: 1:19 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 12, 12, 6, 0, false);           // UTC: 12:06 PM Local: 10:06 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 27, 2, 45, 0, false);           // UTC: 2:45 AM Local: 12:45 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 7, 0, 29, 0, false);            // UTC: 12:29 AM Local: 10:29 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 9, 10, 12, 0, false);           // UTC: 10:12 AM Local: 8:12 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 24, 6, 10, 0, false);           // UTC: 6:10 AM Local: 4:10 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 13, 21, 10, 0, false);          // UTC: 9:10 PM Local: 7:10 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 4, 15, 6, 0, false);            // UTC: 3:06 PM Local: 1:06 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 6, 20, 37, 0, false);           // UTC: 8:37 PM Local: 6:37 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 23, 8, 55, 0, false);           // UTC: 8:55 AM Local: 6:55 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 1, 18, 27, 0, false);           // UTC: 6:27 PM Local: 4:27 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 10, 22, 19, 0, false);          // UTC: 10:19 PM Local: 8:19 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 26, 15, 35, 0, false);          // UTC: 3:35 PM Local: 1:35 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 17, 9, 8, 0, false);            // UTC: 9:08 AM Local: 7:08 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 19, 11, 36, 0, false);          // UTC: 11:36 AM Local: 9:36 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 4, 21, 24, 0, false);           // UTC: 9:24 PM Local: 7:24 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 6, 19, 8, 0, false);            // UTC: 7:08 PM Local: 5:08 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 20, 3, 1, 0, false);            // UTC: 3:01 AM Local: 1:01 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 27, 20, 58, 0, false);          // UTC: 8:58 PM Local: 6:58 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 6, 4, 37, 0, false);            // UTC: 4:37 AM Local: 2:37 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 13, 2, 45, 0, false);           // UTC: 2:45 AM Local: 12:45 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 23, 5, 13, 0, false);           // UTC: 5:13 AM Local: 3:13 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 7, 1, 21, 28, 0, false);           // UTC: 9:28 PM Local: 7:28 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 24, 21, 34, 0, false);          // UTC: 9:34 PM Local: 7:34 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 16, 20, 30, 0, false);          // UTC: 8:30 PM Local: 6:30 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 1, 10, 10, 0, false);           // UTC: 10:10 AM Local: 8:10 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 14, 2, 57, 0, false);           // UTC: 2:57 AM Local: 12:57 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 6, 15, 30, 0, false);           // UTC: 3:30 PM Local: 1:30 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 22, 6, 39, 0, false);           // UTC: 6:39 AM Local: 4:39 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 12, 8, 5, 0, false);            // UTC: 8:05 AM Local: 6:05 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 10, 17, 28, 0, false);          // UTC: 5:28 PM Local: 3:28 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 27, 2, 16, 0, false);           // UTC: 2:16 AM Local: 12:16 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 10, 19, 15, 0, false);          // UTC: 7:15 PM Local: 5:15 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 11, 2, 57, 0, false);           // UTC: 2:57 AM Local: 12:57 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 26, 7, 53, 0, false);           // UTC: 7:53 AM Local: 5:53 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 15, 3, 16, 0, false);           // UTC: 3:16 AM Local: 1:16 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 14, 21, 24, 0, false);          // UTC: 9:24 PM Local: 7:24 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 23, 16, 5, 0, false);           // UTC: 4:05 PM Local: 2:05 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 18, 6, 27, 0, false);           // UTC: 6:27 AM Local: 4:27 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 8, 0, 55, 0, false);            // UTC: 12:55 AM Local: 10:55 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 16, 13, 33, 0, false);          // UTC: 1:33 PM Local: 11:33 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 11, 12, 11, 0, false);          // UTC: 12:11 PM Local: 10:11 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 3, 13, 43, 0, false);           // UTC: 1:43 PM Local: 11:43 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 7, 15, 35, 0, false);           // UTC: 3:35 PM Local: 1:35 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 25, 2, 0, 0, false);            // UTC: 2:00 AM Local: 12:00 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 27, 6, 20, 0, false);           // UTC: 6:20 AM Local: 4:20 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 17, 5, 9, 0, false);            // UTC: 5:09 AM Local: 3:09 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 8, 11, 21, 26, 0, false);          // UTC: 9:26 PM Local: 7:26 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 19, 11, 1, 0, false);           // UTC: 11:01 AM Local: 9:01 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 11, 7, 51, 0, false);           // UTC: 7:51 AM Local: 5:51 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 23, 2, 48, 0, false);           // UTC: 2:48 AM Local: 12:48 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 9, 18, 29, 0, false);           // UTC: 6:29 PM Local: 4:29 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 12, 12, 45, 0, false);          // UTC: 12:45 PM Local: 10:45 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 20, 10, 31, 0, false);          // UTC: 10:31 AM Local: 8:31 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 15, 6, 16, 0, false);           // UTC: 6:16 AM Local: 4:16 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 22, 20, 34, 0, false);          // UTC: 8:34 PM Local: 6:34 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 3, 15, 58, 0, false);           // UTC: 3:58 PM Local: 1:58 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 4, 15, 46, 0, false);           // UTC: 3:46 PM Local: 1:46 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 21, 3, 39, 0, false);           // UTC: 3:39 AM Local: 1:39 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 4, 16, 1, 0, false);            // UTC: 4:01 PM Local: 2:01 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 5, 16, 17, 0, false);           // UTC: 4:17 PM Local: 2:17 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 24, 9, 32, 0, false);           // UTC: 9:32 AM Local: 7:32 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 22, 13, 18, 0, false);          // UTC: 1:18 PM Local: 11:18 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 14, 13, 42, 0, false);          // UTC: 1:42 PM Local: 11:42 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 16, 20, 46, 0, false);          // UTC: 8:46 PM Local: 6:46 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 18, 19, 38, 0, false);          // UTC: 7:38 PM Local: 5:38 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 5, 19, 36, 0, false);           // UTC: 7:36 PM Local: 5:36 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 13, 6, 37, 0, false);           // UTC: 6:37 AM Local: 4:37 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 24, 16, 26, 0, false);          // UTC: 4:26 PM Local: 2:26 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 1, 12, 38, 0, false);           // UTC: 12:38 PM Local: 10:38 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 23, 6, 49, 0, false);           // UTC: 6:49 AM Local: 4:49 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 21, 12, 43, 0, false);          // UTC: 12:43 PM Local: 10:43 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 9, 7, 15, 50, 0, false);           // UTC: 3:50 PM Local: 1:50 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 20, 0, 19, 0, false);          // UTC: 12:19 AM Local: 10:19 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 8, 13, 5, 0, false);           // UTC: 1:05 PM Local: 11:05 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 8, 12, 45, 0, false);          // UTC: 12:45 PM Local: 10:45 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 27, 2, 17, 0, false);          // UTC: 2:17 AM Local: 12:17 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 1, 21, 50, 0, false);          // UTC: 9:50 PM Local: 7:50 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 12, 16, 24, 0, false);         // UTC: 4:24 PM Local: 2:24 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 18, 22, 42, 0, false);         // UTC: 10:42 PM Local: 8:42 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 3, 17, 1, 0, false);           // UTC: 5:01 PM Local: 3:01 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 18, 15, 16, 0, false);         // UTC: 3:16 PM Local: 1:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 24, 18, 18, 0, false);         // UTC: 6:18 PM Local: 4:18 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 2, 9, 12, 0, false);           // UTC: 9:12 AM Local: 7:12 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 22, 10, 49, 0, false);         // UTC: 10:49 AM Local: 8:49 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 8, 3, 41, 0, false);           // UTC: 3:41 AM Local: 1:41 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 15, 14, 8, 0, false);          // UTC: 2:08 PM Local: 12:08 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 19, 0, 25, 0, false);          // UTC: 12:25 AM Local: 10:25 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 10, 18, 21, 0, false);         // UTC: 6:21 PM Local: 4:21 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 27, 7, 50, 0, false);          // UTC: 7:50 AM Local: 5:50 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 9, 12, 38, 0, false);          // UTC: 12:38 PM Local: 10:38 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 4, 14, 15, 0, false);          // UTC: 2:15 PM Local: 12:15 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 9, 14, 53, 0, false);          // UTC: 2:53 PM Local: 12:53 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 23, 8, 43, 0, false);          // UTC: 8:43 AM Local: 6:43 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 13, 21, 42, 0, false);         // UTC: 9:42 PM Local: 7:42 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 3, 5, 29, 0, false);           // UTC: 5:29 AM Local: 3:29 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 1, 2, 32, 0, false);           // UTC: 2:32 AM Local: 12:32 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 10, 20, 2, 22, 0, false);          // UTC: 2:22 AM Local: 12:22 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 16, 9, 42, 0, false);          // UTC: 9:42 AM Local: 7:42 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 16, 7, 51, 0, false);          // UTC: 7:51 AM Local: 5:51 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 25, 21, 28, 0, false);         // UTC: 9:28 PM Local: 7:28 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 13, 16, 49, 0, false);         // UTC: 4:49 PM Local: 2:49 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 16, 15, 48, 0, false);         // UTC: 3:48 PM Local: 1:48 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 16, 22, 33, 0, false);         // UTC: 10:33 PM Local: 8:33 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 22, 16, 14, 0, false);         // UTC: 4:14 PM Local: 2:14 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 11, 4, 6, 0, false);           // UTC: 4:06 AM Local: 2:06 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 20, 5, 33, 0, false);          // UTC: 5:33 AM Local: 3:33 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 24, 21, 12, 0, false);         // UTC: 9:12 PM Local: 7:12 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 9, 13, 25, 0, false);          // UTC: 1:25 PM Local: 11:25 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 8, 12, 11, 0, false);          // UTC: 12:11 PM Local: 10:11 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 15, 16, 16, 0, false);         // UTC: 4:16 PM Local: 2:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 1, 20, 27, 0, false);          // UTC: 8:27 PM Local: 6:27 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 7, 22, 11, 0, false);          // UTC: 10:11 PM Local: 8:11 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 24, 12, 33, 0, false);         // UTC: 12:33 PM Local: 10:33 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 19, 10, 8, 0, false);          // UTC: 10:08 AM Local: 8:08 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 27, 21, 23, 0, false);         // UTC: 9:23 PM Local: 7:23 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 4, 4, 12, 0, false);           // UTC: 4:12 AM Local: 2:12 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 17, 20, 4, 0, false);          // UTC: 8:04 PM Local: 6:04 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 9, 1, 56, 0, false);           // UTC: 1:56 AM Local: 11:56 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 8, 3, 7, 0, false);            // UTC: 3:07 AM Local: 1:07 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 11, 6, 6, 0, false);           // UTC: 6:06 AM Local: 4:06 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 18, 1, 16, 0, false);          // UTC: 1:16 AM Local: 11:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 11, 8, 17, 48, 0, false);          // UTC: 5:48 PM Local: 3:48 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 22, 3, 13, 0, false);          // UTC: 3:13 AM Local: 1:13 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 25, 19, 42, 0, false);         // UTC: 7:42 PM Local: 5:42 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 1, 4, 30, 0, false);           // UTC: 4:30 AM Local: 2:30 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 2, 7, 39, 0, false);           // UTC: 7:39 AM Local: 5:39 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 2, 3, 22, 0, false);           // UTC: 3:22 AM Local: 1:22 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 27, 21, 49, 0, false);         // UTC: 9:49 PM Local: 7:49 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 6, 16, 49, 0, false);          // UTC: 4:49 PM Local: 2:49 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 14, 22, 48, 0, false);         // UTC: 10:48 PM Local: 8:48 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 2, 10, 14, 0, false);          // UTC: 10:14 AM Local: 8:14 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 13, 0, 23, 0, false);          // UTC: 12:23 AM Local: 10:23 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 24, 16, 10, 0, false);         // UTC: 4:10 PM Local: 2:10 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 16, 8, 2, 0, false);           // UTC: 8:02 AM Local: 6:02 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 27, 16, 2, 0, false);          // UTC: 4:02 PM Local: 2:02 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 10, 6, 51, 0, false);          // UTC: 6:51 AM Local: 4:51 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 13, 4, 49, 0, false);          // UTC: 4:49 AM Local: 2:49 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 13, 8, 8, 0, false);           // UTC: 8:08 AM Local: 6:08 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 20, 15, 7, 0, false);          // UTC: 3:07 PM Local: 1:07 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 12, 1, 1, 0, false);           // UTC: 1:01 AM Local: 11:01 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 27, 6, 9, 0, false);           // UTC: 6:09 AM Local: 4:09 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 12, 19, 21, 0, false);         // UTC: 7:21 PM Local: 5:21 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 13, 12, 8, 0, false);          // UTC: 12:08 PM Local: 10:08 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 4, 4, 36, 0, false);           // UTC: 4:36 AM Local: 2:36 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 14, 10, 45, 0, false);         // UTC: 10:45 AM Local: 8:45 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 10, 22, 11, 0, false);         // UTC: 10:11 PM Local: 8:11 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2018, 12, 22, 19, 25, 0, false);         // UTC: 7:25 PM Local: 5:25 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 27, 1, 46, 0, false);           // UTC: 1:46 AM Local: 11:46 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 27, 13, 6, 0, false);           // UTC: 1:06 PM Local: 11:06 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 3, 16, 21, 0, false);           // UTC: 4:21 PM Local: 2:21 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 8, 9, 38, 0, false);            // UTC: 9:38 AM Local: 7:38 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 5, 13, 4, 0, false);            // UTC: 1:04 PM Local: 11:04 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 24, 13, 52, 0, false);          // UTC: 1:52 PM Local: 11:52 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 19, 20, 43, 0, false);          // UTC: 8:43 PM Local: 6:43 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 20, 7, 0, 0, false);            // UTC: 7:00 AM Local: 5:00 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 7, 22, 52, 0, false);           // UTC: 10:52 PM Local: 8:52 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 11, 9, 40, 0, false);           // UTC: 9:40 AM Local: 7:40 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 26, 14, 11, 0, false);          // UTC: 2:11 PM Local: 12:11 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 16, 0, 14, 0, false);           // UTC: 12:14 AM Local: 10:14 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 11, 9, 13, 0, false);           // UTC: 9:13 AM Local: 7:13 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 8, 8, 49, 0, false);            // UTC: 8:49 AM Local: 6:49 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 21, 19, 45, 0, false);          // UTC: 7:45 PM Local: 5:45 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 26, 7, 52, 0, false);           // UTC: 7:52 AM Local: 5:52 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 19, 10, 23, 0, false);          // UTC: 10:23 AM Local: 8:23 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 9, 2, 58, 0, false);            // UTC: 2:58 AM Local: 12:58 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 19, 5, 41, 0, false);           // UTC: 5:41 AM Local: 3:41 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 21, 17, 37, 0, false);          // UTC: 5:37 PM Local: 3:37 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 6, 16, 18, 0, false);           // UTC: 4:18 PM Local: 2:18 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 19, 7, 46, 0, false);           // UTC: 7:46 AM Local: 5:46 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 13, 13, 33, 0, false);          // UTC: 1:33 PM Local: 11:33 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 23, 11, 8, 0, false);           // UTC: 11:08 AM Local: 9:08 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 1, 18, 9, 29, 0, false);           // UTC: 9:29 AM Local: 7:29 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 25, 22, 29, 0, false);          // UTC: 10:29 PM Local: 8:29 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 7, 6, 37, 0, false);            // UTC: 6:37 AM Local: 4:37 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 1, 16, 55, 0, false);           // UTC: 4:55 PM Local: 2:55 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 8, 14, 30, 0, false);           // UTC: 2:30 PM Local: 12:30 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 6, 20, 46, 0, false);           // UTC: 8:46 PM Local: 6:46 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 15, 13, 40, 0, false);          // UTC: 1:40 PM Local: 11:40 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 17, 1, 38, 0, false);           // UTC: 1:38 AM Local: 11:38 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 15, 2, 29, 0, false);           // UTC: 2:29 AM Local: 12:29 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 27, 11, 44, 0, false);          // UTC: 11:44 AM Local: 9:44 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 9, 19, 56, 0, false);           // UTC: 7:56 PM Local: 5:56 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 7, 15, 42, 0, false);           // UTC: 3:42 PM Local: 1:42 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 14, 18, 15, 0, false);          // UTC: 6:15 PM Local: 4:15 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 6, 12, 27, 0, false);           // UTC: 12:27 PM Local: 10:27 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 27, 4, 0, 0, false);            // UTC: 4:00 AM Local: 2:00 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 11, 8, 43, 0, false);           // UTC: 8:43 AM Local: 6:43 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 8, 6, 41, 0, false);            // UTC: 6:41 AM Local: 4:41 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 22, 7, 53, 0, false);           // UTC: 7:53 AM Local: 5:53 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 13, 1, 20, 0, false);           // UTC: 1:20 AM Local: 11:20 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 23, 8, 51, 0, false);           // UTC: 8:51 AM Local: 6:51 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 27, 5, 46, 0, false);           // UTC: 5:46 AM Local: 3:46 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 24, 15, 50, 0, false);          // UTC: 3:50 PM Local: 1:50 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 27, 1, 55, 0, false);           // UTC: 1:55 AM Local: 11:55 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 22, 16, 4, 0, false);           // UTC: 4:04 PM Local: 2:04 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 14, 7, 3, 0, false);            // UTC: 7:03 AM Local: 5:03 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 2, 6, 14, 49, 0, false);           // UTC: 2:49 PM Local: 12:49 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 18, 3, 41, 0, false);           // UTC: 3:41 AM Local: 1:41 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 21, 16, 13, 0, false);          // UTC: 4:13 PM Local: 2:13 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 2, 12, 31, 0, false);           // UTC: 12:31 PM Local: 10:31 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 2, 18, 36, 0, false);           // UTC: 6:36 PM Local: 4:36 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 11, 14, 25, 0, false);          // UTC: 2:25 PM Local: 12:25 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 11, 4, 17, 0, false);           // UTC: 4:17 AM Local: 2:17 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 19, 2, 31, 0, false);           // UTC: 2:31 AM Local: 12:31 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 5, 9, 19, 0, false);            // UTC: 9:19 AM Local: 7:19 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 22, 11, 32, 0, false);          // UTC: 11:32 AM Local: 9:32 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 17, 6, 57, 0, false);           // UTC: 6:57 AM Local: 4:57 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 23, 5, 25, 0, false);           // UTC: 5:25 AM Local: 3:25 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 14, 4, 13, 0, false);           // UTC: 4:13 AM Local: 2:13 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 5, 5, 30, 0, false);            // UTC: 5:30 AM Local: 3:30 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 16, 19, 9, 0, false);           // UTC: 7:09 PM Local: 5:09 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 9, 21, 15, 0, false);           // UTC: 9:15 PM Local: 7:15 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 9, 9, 4, 0, false);             // UTC: 9:04 AM Local: 7:04 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 18, 2, 6, 0, false);            // UTC: 2:06 AM Local: 12:06 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 21, 12, 30, 0, false);          // UTC: 12:30 PM Local: 10:30 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 9, 11, 44, 0, false);           // UTC: 11:44 AM Local: 9:44 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 11, 22, 14, 0, false);          // UTC: 10:14 PM Local: 8:14 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 19, 9, 15, 0, false);           // UTC: 9:15 AM Local: 7:15 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 15, 4, 31, 0, false);           // UTC: 4:31 AM Local: 2:31 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 6, 20, 25, 0, false);           // UTC: 8:25 PM Local: 6:25 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 6, 5, 58, 0, false);            // UTC: 5:58 AM Local: 3:58 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 3, 22, 2, 15, 0, false);           // UTC: 2:15 AM Local: 12:15 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 11, 19, 27, 0, false);          // UTC: 7:27 PM Local: 5:27 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 2, 10, 4, 0, false);            // UTC: 10:04 AM Local: 8:04 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 13, 22, 9, 0, false);           // UTC: 10:09 PM Local: 8:09 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 24, 2, 41, 0, false);           // UTC: 2:41 AM Local: 12:41 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 25, 4, 42, 0, false);           // UTC: 4:42 AM Local: 2:42 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 13, 18, 14, 0, false);          // UTC: 6:14 PM Local: 4:14 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 8, 20, 24, 0, false);           // UTC: 8:24 PM Local: 6:24 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 25, 17, 42, 0, false);          // UTC: 5:42 PM Local: 3:42 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 20, 2, 30, 0, false);           // UTC: 2:30 AM Local: 12:30 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 18, 10, 51, 0, false);          // UTC: 10:51 AM Local: 8:51 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 4, 22, 24, 0, false);           // UTC: 10:24 PM Local: 8:24 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 7, 21, 38, 0, false);           // UTC: 9:38 PM Local: 7:38 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 8, 7, 30, 0, false);            // UTC: 7:30 AM Local: 5:30 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 5, 4, 25, 0, false);            // UTC: 4:25 AM Local: 2:25 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 3, 15, 6, 0, false);            // UTC: 3:06 PM Local: 1:06 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 23, 6, 41, 0, false);           // UTC: 6:41 AM Local: 4:41 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 20, 16, 26, 0, false);          // UTC: 4:26 PM Local: 2:26 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 21, 11, 13, 0, false);          // UTC: 11:13 AM Local: 9:13 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 24, 10, 2, 0, false);           // UTC: 10:02 AM Local: 8:02 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 21, 7, 19, 0, false);           // UTC: 7:19 AM Local: 5:19 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 16, 19, 31, 0, false);          // UTC: 7:31 PM Local: 5:31 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 8, 16, 7, 0, false);            // UTC: 4:07 PM Local: 2:07 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 8, 15, 14, 0, false);           // UTC: 3:14 PM Local: 1:14 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 2, 4, 28, 0, false);            // UTC: 4:28 AM Local: 2:28 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 4, 20, 2, 40, 0, false);           // UTC: 2:40 AM Local: 12:40 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 27, 18, 5, 0, false);           // UTC: 6:05 PM Local: 4:05 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 17, 20, 49, 0, false);          // UTC: 8:49 PM Local: 6:49 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 23, 21, 42, 0, false);          // UTC: 9:42 PM Local: 7:42 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 12, 8, 28, 0, false);           // UTC: 8:28 AM Local: 6:28 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 6, 8, 27, 0, false);            // UTC: 8:27 AM Local: 6:27 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 17, 12, 56, 0, false);          // UTC: 12:56 PM Local: 10:56 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 6, 13, 22, 0, false);           // UTC: 1:22 PM Local: 11:22 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 25, 18, 55, 0, false);          // UTC: 6:55 PM Local: 4:55 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 27, 12, 36, 0, false);          // UTC: 12:36 PM Local: 10:36 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 13, 14, 31, 0, false);          // UTC: 2:31 PM Local: 12:31 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 27, 0, 22, 0, false);           // UTC: 12:22 AM Local: 10:22 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 15, 20, 39, 0, false);          // UTC: 8:39 PM Local: 6:39 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 26, 2, 26, 0, false);           // UTC: 2:26 AM Local: 12:26 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 14, 16, 53, 0, false);          // UTC: 4:53 PM Local: 2:53 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 22, 19, 20, 0, false);          // UTC: 7:20 PM Local: 5:20 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 18, 2, 16, 0, false);           // UTC: 2:16 AM Local: 12:16 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 21, 10, 37, 0, false);          // UTC: 10:37 AM Local: 8:37 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 15, 12, 30, 0, false);          // UTC: 12:30 PM Local: 10:30 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 9, 1, 57, 0, false);            // UTC: 1:57 AM Local: 11:57 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 5, 14, 20, 0, false);           // UTC: 2:20 PM Local: 12:20 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 6, 8, 16, 0, false);            // UTC: 8:16 AM Local: 6:16 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 5, 10, 21, 0, false);           // UTC: 10:21 AM Local: 8:21 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 3, 15, 29, 0, false);           // UTC: 3:29 PM Local: 1:29 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 22, 15, 24, 0, false);          // UTC: 3:24 PM Local: 1:24 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 5, 14, 15, 51, 0, false);          // UTC: 3:51 PM Local: 1:51 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 13, 2, 56, 0, false);           // UTC: 2:56 AM Local: 12:56 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 17, 7, 26, 0, false);           // UTC: 7:26 AM Local: 5:26 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 10, 15, 11, 0, false);          // UTC: 3:11 PM Local: 1:11 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 25, 10, 28, 0, false);          // UTC: 10:28 AM Local: 8:28 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 24, 4, 48, 0, false);           // UTC: 4:48 AM Local: 2:48 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 19, 18, 28, 0, false);          // UTC: 6:28 PM Local: 4:28 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 3, 6, 21, 0, false);            // UTC: 6:21 AM Local: 4:21 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 17, 14, 24, 0, false);          // UTC: 2:24 PM Local: 12:24 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 27, 12, 25, 0, false);          // UTC: 12:25 PM Local: 10:25 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 21, 22, 47, 0, false);          // UTC: 10:47 PM Local: 8:47 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 7, 0, 49, 0, false);            // UTC: 12:49 AM Local: 10:49 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 18, 19, 57, 0, false);          // UTC: 7:57 PM Local: 5:57 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 1, 12, 18, 0, false);           // UTC: 12:18 PM Local: 10:18 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 25, 20, 39, 0, false);          // UTC: 8:39 PM Local: 6:39 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 3, 6, 58, 0, false);            // UTC: 6:58 AM Local: 4:58 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 24, 5, 26, 0, false);           // UTC: 5:26 AM Local: 3:26 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 19, 2, 50, 0, false);           // UTC: 2:50 AM Local: 12:50 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 26, 9, 24, 0, false);           // UTC: 9:24 AM Local: 7:24 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 14, 19, 27, 0, false);          // UTC: 7:27 PM Local: 5:27 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 15, 14, 46, 0, false);          // UTC: 2:46 PM Local: 12:46 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 1, 13, 42, 0, false);           // UTC: 1:42 PM Local: 11:42 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 11, 15, 25, 0, false);          // UTC: 3:25 PM Local: 1:25 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 18, 5, 21, 0, false);           // UTC: 5:21 AM Local: 3:21 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 23, 15, 14, 0, false);          // UTC: 3:14 PM Local: 1:14 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 6, 5, 4, 23, 0, false);            // UTC: 4:23 AM Local: 2:23 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 20, 12, 20, 0, false);          // UTC: 12:20 PM Local: 10:20 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 12, 2, 17, 0, false);           // UTC: 2:17 AM Local: 12:17 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 27, 1, 51, 0, false);           // UTC: 1:51 AM Local: 11:51 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 26, 6, 36, 0, false);           // UTC: 6:36 AM Local: 4:36 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 12, 3, 58, 0, false);           // UTC: 3:58 AM Local: 1:58 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 14, 11, 54, 0, false);          // UTC: 11:54 AM Local: 9:54 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 15, 20, 17, 0, false);          // UTC: 8:17 PM Local: 6:17 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 26, 16, 36, 0, false);          // UTC: 4:36 PM Local: 2:36 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 15, 5, 1, 0, false);            // UTC: 5:01 AM Local: 3:01 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 3, 19, 26, 0, false);           // UTC: 7:26 PM Local: 5:26 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 17, 17, 12, 0, false);          // UTC: 5:12 PM Local: 3:12 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 1, 18, 18, 0, false);           // UTC: 6:18 PM Local: 4:18 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 4, 2, 31, 0, false);            // UTC: 2:31 AM Local: 12:31 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 13, 0, 29, 0, false);           // UTC: 12:29 AM Local: 10:29 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 24, 10, 22, 0, false);          // UTC: 10:22 AM Local: 8:22 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 23, 5, 4, 0, false);            // UTC: 5:04 AM Local: 3:04 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 11, 7, 9, 0, false);            // UTC: 7:09 AM Local: 5:09 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 9, 14, 16, 0, false);           // UTC: 2:16 PM Local: 12:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 3, 17, 49, 0, false);           // UTC: 5:49 PM Local: 3:49 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 20, 20, 50, 0, false);          // UTC: 8:50 PM Local: 6:50 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 8, 20, 14, 0, false);           // UTC: 8:14 PM Local: 6:14 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 12, 7, 31, 0, false);           // UTC: 7:31 AM Local: 5:31 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 11, 9, 19, 0, false);           // UTC: 9:19 AM Local: 7:19 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 19, 8, 24, 0, false);           // UTC: 8:24 AM Local: 6:24 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 7, 11, 1, 52, 0, false);           // UTC: 1:52 AM Local: 11:52 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 22, 1, 15, 0, false);           // UTC: 1:15 AM Local: 11:15 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 7, 16, 0, 0, false);            // UTC: 4:00 PM Local: 2:00 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 26, 15, 29, 0, false);          // UTC: 3:29 PM Local: 1:29 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 8, 6, 6, 0, false);             // UTC: 6:06 AM Local: 4:06 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 26, 21, 2, 0, false);           // UTC: 9:02 PM Local: 7:02 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 13, 9, 11, 0, false);           // UTC: 9:11 AM Local: 7:11 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 18, 4, 6, 0, false);            // UTC: 4:06 AM Local: 2:06 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 7, 10, 6, 0, false);            // UTC: 10:06 AM Local: 8:06 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 23, 10, 48, 0, false);          // UTC: 10:48 AM Local: 8:48 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 21, 16, 57, 0, false);          // UTC: 4:57 PM Local: 2:57 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 21, 21, 34, 0, false);          // UTC: 9:34 PM Local: 7:34 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 11, 6, 40, 0, false);           // UTC: 6:40 AM Local: 4:40 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 16, 11, 10, 0, false);          // UTC: 11:10 AM Local: 9:10 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 24, 7, 12, 0, false);           // UTC: 7:12 AM Local: 5:12 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 21, 3, 1, 0, false);            // UTC: 3:01 AM Local: 1:01 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 12, 10, 28, 0, false);          // UTC: 10:28 AM Local: 8:28 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 9, 4, 56, 0, false);            // UTC: 4:56 AM Local: 2:56 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 6, 16, 49, 0, false);           // UTC: 4:49 PM Local: 2:49 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 21, 12, 37, 0, false);          // UTC: 12:37 PM Local: 10:37 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 4, 9, 16, 0, false);            // UTC: 9:16 AM Local: 7:16 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 5, 4, 58, 0, false);            // UTC: 4:58 AM Local: 2:58 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 14, 12, 22, 0, false);          // UTC: 12:22 PM Local: 10:22 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 15, 12, 36, 0, false);          // UTC: 12:36 PM Local: 10:36 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 10, 20, 54, 0, false);          // UTC: 8:54 PM Local: 6:54 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 8, 1, 18, 51, 0, false);           // UTC: 6:51 PM Local: 4:51 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 25, 11, 18, 0, false);          // UTC: 11:18 AM Local: 9:18 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 3, 9, 58, 0, false);            // UTC: 9:58 AM Local: 7:58 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 10, 10, 30, 0, false);          // UTC: 10:30 AM Local: 8:30 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 1, 12, 11, 0, false);           // UTC: 12:11 PM Local: 10:11 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 21, 14, 44, 0, false);          // UTC: 2:44 PM Local: 12:44 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 2, 10, 5, 0, false);            // UTC: 10:05 AM Local: 8:05 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 25, 15, 8, 0, false);           // UTC: 3:08 PM Local: 1:08 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 7, 5, 35, 0, false);            // UTC: 5:35 AM Local: 3:35 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 18, 20, 53, 0, false);          // UTC: 8:53 PM Local: 6:53 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 24, 21, 17, 0, false);          // UTC: 9:17 PM Local: 7:17 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 2, 4, 54, 0, false);            // UTC: 4:54 AM Local: 2:54 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 27, 20, 2, 0, false);           // UTC: 8:02 PM Local: 6:02 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 9, 1, 57, 0, false);            // UTC: 1:57 AM Local: 11:57 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 8, 19, 44, 0, false);           // UTC: 7:44 PM Local: 5:44 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 13, 11, 58, 0, false);          // UTC: 11:58 AM Local: 9:58 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 6, 17, 55, 0, false);           // UTC: 5:55 PM Local: 3:55 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 24, 6, 26, 0, false);           // UTC: 6:26 AM Local: 4:26 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 23, 3, 8, 0, false);            // UTC: 3:08 AM Local: 1:08 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 20, 15, 16, 0, false);          // UTC: 3:16 PM Local: 1:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 20, 10, 30, 0, false);          // UTC: 10:30 AM Local: 8:30 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 3, 10, 28, 0, false);           // UTC: 10:28 AM Local: 8:28 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 6, 22, 21, 0, false);           // UTC: 10:21 PM Local: 8:21 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 8, 17, 43, 0, false);           // UTC: 5:43 PM Local: 3:43 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 20, 16, 22, 0, false);          // UTC: 4:22 PM Local: 2:22 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 9, 4, 13, 48, 0, false);           // UTC: 1:48 PM Local: 11:48 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 11, 17, 43, 0, false);         // UTC: 5:43 PM Local: 3:43 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 17, 10, 7, 0, false);          // UTC: 10:07 AM Local: 8:07 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 27, 22, 38, 0, false);         // UTC: 10:38 PM Local: 8:38 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 23, 5, 2, 0, false);           // UTC: 5:02 AM Local: 3:02 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 22, 5, 13, 0, false);          // UTC: 5:13 AM Local: 3:13 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 21, 14, 36, 0, false);         // UTC: 2:36 PM Local: 12:36 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 13, 4, 21, 0, false);          // UTC: 4:21 AM Local: 2:21 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 8, 6, 31, 0, false);           // UTC: 6:31 AM Local: 4:31 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 18, 21, 0, 0, false);          // UTC: 9:00 PM Local: 7:00 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 6, 3, 34, 0, false);           // UTC: 3:34 AM Local: 1:34 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 2, 16, 31, 0, false);          // UTC: 4:31 PM Local: 2:31 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 9, 8, 53, 0, false);           // UTC: 8:53 AM Local: 6:53 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 15, 2, 58, 0, false);          // UTC: 2:58 AM Local: 12:58 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 11, 2, 28, 0, false);          // UTC: 2:28 AM Local: 12:28 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 23, 8, 43, 0, false);          // UTC: 8:43 AM Local: 6:43 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 9, 11, 30, 0, false);          // UTC: 11:30 AM Local: 9:30 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 14, 21, 5, 0, false);          // UTC: 9:05 PM Local: 7:05 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 21, 15, 23, 0, false);         // UTC: 3:23 PM Local: 1:23 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 13, 2, 29, 0, false);          // UTC: 2:29 AM Local: 12:29 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 6, 22, 31, 0, false);          // UTC: 10:31 PM Local: 8:31 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 4, 17, 49, 0, false);          // UTC: 5:49 PM Local: 3:49 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 2, 17, 31, 0, false);          // UTC: 5:31 PM Local: 3:31 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 14, 10, 53, 0, false);         // UTC: 10:53 AM Local: 8:53 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 9, 5, 30, 0, false);           // UTC: 5:30 AM Local: 3:30 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 10, 17, 1, 4, 0, false);           // UTC: 1:04 AM Local: 11:04 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 24, 9, 53, 0, false);          // UTC: 9:53 AM Local: 7:53 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 22, 7, 25, 0, false);          // UTC: 7:25 AM Local: 5:25 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 14, 15, 11, 0, false);         // UTC: 3:11 PM Local: 1:11 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 14, 6, 1, 0, false);           // UTC: 6:01 AM Local: 4:01 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 4, 19, 13, 0, false);          // UTC: 7:13 PM Local: 5:13 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 12, 8, 8, 0, false);           // UTC: 8:08 AM Local: 6:08 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 13, 6, 20, 0, false);          // UTC: 6:20 AM Local: 4:20 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 18, 17, 34, 0, false);         // UTC: 5:34 PM Local: 3:34 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 6, 18, 0, 0, false);           // UTC: 6:00 PM Local: 4:00 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 17, 4, 43, 0, false);          // UTC: 4:43 AM Local: 2:43 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 16, 3, 35, 0, false);          // UTC: 3:35 AM Local: 1:35 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 9, 13, 39, 0, false);          // UTC: 1:39 PM Local: 11:39 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 17, 9, 37, 0, false);          // UTC: 9:37 AM Local: 7:37 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 3, 14, 4, 0, false);           // UTC: 2:04 PM Local: 12:04 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 18, 12, 28, 0, false);         // UTC: 12:28 PM Local: 10:28 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 14, 8, 36, 0, false);          // UTC: 8:36 AM Local: 6:36 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 18, 20, 51, 0, false);         // UTC: 8:51 PM Local: 6:51 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 10, 4, 46, 0, false);          // UTC: 4:46 AM Local: 2:46 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 20, 5, 38, 0, false);          // UTC: 5:38 AM Local: 3:38 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 9, 13, 30, 0, false);          // UTC: 1:30 PM Local: 11:30 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 12, 20, 29, 0, false);         // UTC: 8:29 PM Local: 6:29 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 13, 21, 8, 0, false);          // UTC: 9:08 PM Local: 7:08 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 12, 18, 16, 0, false);         // UTC: 6:16 PM Local: 4:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 16, 18, 56, 0, false);         // UTC: 6:56 PM Local: 4:56 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 11, 14, 8, 38, 0, false);          // UTC: 8:38 AM Local: 6:38 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 8, 22, 12, 0, false);          // UTC: 10:12 PM Local: 8:12 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 3, 16, 24, 0, false);          // UTC: 4:24 PM Local: 2:24 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 11, 21, 16, 0, false);         // UTC: 9:16 PM Local: 7:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 24, 4, 57, 0, false);          // UTC: 4:57 AM Local: 2:57 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 23, 13, 19, 0, false);         // UTC: 1:19 PM Local: 11:19 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 1, 6, 47, 0, false);           // UTC: 6:47 AM Local: 4:47 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 4, 15, 43, 0, false);          // UTC: 3:43 PM Local: 1:43 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 16, 4, 37, 0, false);          // UTC: 4:37 AM Local: 2:37 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 10, 1, 33, 0, false);          // UTC: 1:33 AM Local: 11:33 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 10, 2, 5, 0, false);           // UTC: 2:05 AM Local: 12:05 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 25, 19, 48, 0, false);         // UTC: 7:48 PM Local: 5:48 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 4, 10, 15, 0, false);          // UTC: 10:15 AM Local: 8:15 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 12, 4, 52, 0, false);          // UTC: 4:52 AM Local: 2:52 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 3, 0, 54, 0, false);           // UTC: 12:54 AM Local: 10:54 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 6, 13, 42, 0, false);          // UTC: 1:42 PM Local: 11:42 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 5, 13, 13, 0, false);          // UTC: 1:13 PM Local: 11:13 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 26, 12, 31, 0, false);         // UTC: 12:31 PM Local: 10:31 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 5, 9, 40, 0, false);           // UTC: 9:40 AM Local: 7:40 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 25, 16, 47, 0, false);         // UTC: 4:47 PM Local: 2:47 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 16, 17, 37, 0, false);         // UTC: 5:37 PM Local: 3:37 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 24, 0, 50, 0, false);          // UTC: 12:50 AM Local: 10:50 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 6, 22, 21, 0, false);          // UTC: 10:21 PM Local: 8:21 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 5, 16, 8, 0, false);           // UTC: 4:08 PM Local: 2:08 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 2, 13, 4, 0, false);           // UTC: 1:04 PM Local: 11:04 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2019, 12, 25, 0, 36, 0, false);          // UTC: 12:36 AM Local: 10:36 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 23, 8, 34, 0, false);           // UTC: 8:34 AM Local: 6:34 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 25, 3, 27, 0, false);           // UTC: 3:27 AM Local: 1:27 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 10, 9, 33, 0, false);           // UTC: 9:33 AM Local: 7:33 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 15, 17, 26, 0, false);          // UTC: 5:26 PM Local: 3:26 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 4, 4, 43, 0, false);            // UTC: 4:43 AM Local: 2:43 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 13, 19, 25, 0, false);          // UTC: 7:25 PM Local: 5:25 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 7, 5, 58, 0, false);            // UTC: 5:58 AM Local: 3:58 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 2, 0, 37, 0, false);            // UTC: 12:37 AM Local: 10:37 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 10, 0, 52, 0, false);           // UTC: 12:52 AM Local: 10:52 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 3, 20, 56, 0, false);           // UTC: 8:56 PM Local: 6:56 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 13, 5, 22, 0, false);           // UTC: 5:22 AM Local: 3:22 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 2, 2, 20, 0, false);            // UTC: 2:20 AM Local: 12:20 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 6, 15, 36, 0, false);           // UTC: 3:36 PM Local: 1:36 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 5, 11, 38, 0, false);           // UTC: 11:38 AM Local: 9:38 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 8, 14, 13, 0, false);           // UTC: 2:13 PM Local: 12:13 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 25, 0, 29, 0, false);           // UTC: 12:29 AM Local: 10:29 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 11, 13, 43, 0, false);          // UTC: 1:43 PM Local: 11:43 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 18, 15, 45, 0, false);          // UTC: 3:45 PM Local: 1:45 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 17, 17, 19, 0, false);          // UTC: 5:19 PM Local: 3:19 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 26, 12, 7, 0, false);           // UTC: 12:07 PM Local: 10:07 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 16, 6, 29, 0, false);           // UTC: 6:29 AM Local: 4:29 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 17, 2, 29, 0, false);           // UTC: 2:29 AM Local: 12:29 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 2, 1, 6, 0, false);             // UTC: 1:06 AM Local: 11:06 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 11, 5, 10, 0, false);           // UTC: 5:10 AM Local: 3:10 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 1, 23, 1, 42, 0, false);           // UTC: 1:42 AM Local: 11:42 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 10, 18, 22, 0, false);          // UTC: 6:22 PM Local: 4:22 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 11, 10, 0, 0, false);           // UTC: 10:00 AM Local: 8:00 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 11, 15, 17, 0, false);          // UTC: 3:17 PM Local: 1:17 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 6, 18, 34, 0, false);           // UTC: 6:34 PM Local: 4:34 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 17, 10, 20, 0, false);          // UTC: 10:20 AM Local: 8:20 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 1, 5, 7, 0, false);             // UTC: 5:07 AM Local: 3:07 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 14, 13, 14, 0, false);          // UTC: 1:14 PM Local: 11:14 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 4, 15, 31, 0, false);           // UTC: 3:31 PM Local: 1:31 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 20, 19, 56, 0, false);          // UTC: 7:56 PM Local: 5:56 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 11, 22, 20, 0, false);          // UTC: 10:20 PM Local: 8:20 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 16, 19, 34, 0, false);          // UTC: 7:34 PM Local: 5:34 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 2, 6, 56, 0, false);            // UTC: 6:56 AM Local: 4:56 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 26, 12, 6, 0, false);           // UTC: 12:06 PM Local: 10:06 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 4, 4, 34, 0, false);            // UTC: 4:34 AM Local: 2:34 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 6, 8, 16, 0, false);            // UTC: 8:16 AM Local: 6:16 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 25, 10, 36, 0, false);          // UTC: 10:36 AM Local: 8:36 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 21, 8, 58, 0, false);           // UTC: 8:58 AM Local: 6:58 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 2, 7, 29, 0, false);            // UTC: 7:29 AM Local: 5:29 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 13, 4, 6, 0, false);            // UTC: 4:06 AM Local: 2:06 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 23, 15, 36, 0, false);          // UTC: 3:36 PM Local: 1:36 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 2, 22, 39, 0, false);           // UTC: 10:39 PM Local: 8:39 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 26, 15, 57, 0, false);          // UTC: 3:57 PM Local: 1:57 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 1, 12, 9, 0, false);            // UTC: 12:09 PM Local: 10:09 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 11, 1, 40, 0, false);           // UTC: 1:40 AM Local: 11:40 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 2, 1, 8, 23, 0, false);            // UTC: 8:23 AM Local: 6:23 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 18, 21, 16, 0, false);          // UTC: 9:16 PM Local: 7:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 8, 18, 21, 0, false);           // UTC: 6:21 PM Local: 4:21 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 9, 14, 35, 0, false);           // UTC: 2:35 PM Local: 12:35 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 10, 11, 29, 0, false);          // UTC: 11:29 AM Local: 9:29 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 3, 13, 3, 0, false);            // UTC: 1:03 PM Local: 11:03 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 23, 2, 51, 0, false);           // UTC: 2:51 AM Local: 12:51 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 14, 1, 10, 0, false);           // UTC: 1:10 AM Local: 11:10 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 25, 6, 43, 0, false);           // UTC: 6:43 AM Local: 4:43 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 9, 20, 54, 0, false);           // UTC: 8:54 PM Local: 6:54 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 13, 8, 19, 0, false);           // UTC: 8:19 AM Local: 6:19 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 9, 0, 56, 0, false);            // UTC: 12:56 AM Local: 10:56 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 3, 18, 16, 0, false);           // UTC: 6:16 PM Local: 4:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 23, 13, 50, 0, false);          // UTC: 1:50 PM Local: 11:50 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 7, 16, 21, 0, false);           // UTC: 4:21 PM Local: 2:21 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 2, 13, 8, 0, false);            // UTC: 1:08 PM Local: 11:08 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 13, 21, 57, 0, false);          // UTC: 9:57 PM Local: 7:57 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 3, 12, 57, 0, false);           // UTC: 12:57 PM Local: 10:57 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 22, 11, 17, 0, false);          // UTC: 11:17 AM Local: 9:17 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 7, 17, 39, 0, false);           // UTC: 5:39 PM Local: 3:39 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 15, 22, 54, 0, false);          // UTC: 10:54 PM Local: 8:54 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 12, 20, 14, 0, false);          // UTC: 8:14 PM Local: 6:14 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 8, 1, 28, 0, false);            // UTC: 1:28 AM Local: 11:28 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 15, 22, 44, 0, false);          // UTC: 10:44 PM Local: 8:44 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 22, 0, 30, 0, false);           // UTC: 12:30 AM Local: 10:30 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 3, 1, 5, 20, 0, false);            // UTC: 5:20 AM Local: 3:20 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 22, 19, 40, 0, false);          // UTC: 7:40 PM Local: 5:40 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 16, 18, 57, 0, false);          // UTC: 6:57 PM Local: 4:57 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 26, 8, 49, 0, false);           // UTC: 8:49 AM Local: 6:49 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 10, 11, 30, 0, false);          // UTC: 11:30 AM Local: 9:30 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 18, 19, 4, 0, false);           // UTC: 7:04 PM Local: 5:04 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 17, 6, 37, 0, false);           // UTC: 6:37 AM Local: 4:37 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 26, 18, 49, 0, false);          // UTC: 6:49 PM Local: 4:49 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 4, 18, 31, 0, false);           // UTC: 6:31 PM Local: 4:31 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 19, 21, 55, 0, false);          // UTC: 9:55 PM Local: 7:55 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 7, 7, 31, 0, false);            // UTC: 7:31 AM Local: 5:31 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 13, 18, 16, 0, false);          // UTC: 6:16 PM Local: 4:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 26, 9, 52, 0, false);           // UTC: 9:52 AM Local: 7:52 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 27, 22, 8, 0, false);           // UTC: 10:08 PM Local: 8:08 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 26, 11, 30, 0, false);          // UTC: 11:30 AM Local: 9:30 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 12, 21, 32, 0, false);          // UTC: 9:32 PM Local: 7:32 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 26, 20, 7, 0, false);           // UTC: 8:07 PM Local: 6:07 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 19, 4, 42, 0, false);           // UTC: 4:42 AM Local: 2:42 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 24, 2, 25, 0, false);           // UTC: 2:25 AM Local: 12:25 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 14, 15, 3, 0, false);           // UTC: 3:03 PM Local: 1:03 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 4, 21, 52, 0, false);           // UTC: 9:52 PM Local: 7:52 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 2, 16, 2, 0, false);            // UTC: 4:02 PM Local: 2:02 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 8, 20, 41, 0, false);           // UTC: 8:41 PM Local: 6:41 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 7, 15, 27, 0, false);           // UTC: 3:27 PM Local: 1:27 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 6, 14, 18, 0, false);           // UTC: 2:18 PM Local: 12:18 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 4, 14, 22, 18, 0, false);          // UTC: 10:18 PM Local: 8:18 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 9, 16, 50, 0, false);           // UTC: 4:50 PM Local: 2:50 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 27, 16, 1, 0, false);           // UTC: 4:01 PM Local: 2:01 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 22, 12, 8, 0, false);           // UTC: 12:08 PM Local: 10:08 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 23, 13, 40, 0, false);          // UTC: 1:40 PM Local: 11:40 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 23, 10, 42, 0, false);          // UTC: 10:42 AM Local: 8:42 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 23, 19, 2, 0, false);           // UTC: 7:02 PM Local: 5:02 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 7, 20, 45, 0, false);           // UTC: 8:45 PM Local: 6:45 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 14, 2, 1, 0, false);            // UTC: 2:01 AM Local: 12:01 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 23, 16, 12, 0, false);          // UTC: 4:12 PM Local: 2:12 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 19, 11, 33, 0, false);          // UTC: 11:33 AM Local: 9:33 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 12, 9, 7, 0, false);            // UTC: 9:07 AM Local: 7:07 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 4, 4, 58, 0, false);            // UTC: 4:58 AM Local: 2:58 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 6, 3, 12, 0, false);            // UTC: 3:12 AM Local: 1:12 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 24, 5, 9, 0, false);            // UTC: 5:09 AM Local: 3:09 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 25, 10, 19, 0, false);          // UTC: 10:19 AM Local: 8:19 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 1, 9, 14, 0, false);            // UTC: 9:14 AM Local: 7:14 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 21, 8, 45, 0, false);           // UTC: 8:45 AM Local: 6:45 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 8, 5, 3, 0, false);             // UTC: 5:03 AM Local: 3:03 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 15, 19, 33, 0, false);          // UTC: 7:33 PM Local: 5:33 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 23, 3, 0, 0, false);            // UTC: 3:00 AM Local: 1:00 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 23, 3, 4, 0, false);            // UTC: 3:04 AM Local: 1:04 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 16, 9, 10, 0, false);           // UTC: 9:10 AM Local: 7:10 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 16, 16, 16, 0, false);          // UTC: 4:16 PM Local: 2:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 20, 14, 40, 0, false);          // UTC: 2:40 PM Local: 12:40 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 5, 23, 8, 40, 0, false);           // UTC: 8:40 AM Local: 6:40 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 17, 13, 38, 0, false);          // UTC: 1:38 PM Local: 11:38 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 19, 18, 17, 0, false);          // UTC: 6:17 PM Local: 4:17 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 27, 21, 7, 0, false);           // UTC: 9:07 PM Local: 7:07 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 22, 3, 8, 0, false);            // UTC: 3:08 AM Local: 1:08 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 2, 13, 20, 0, false);           // UTC: 1:20 PM Local: 11:20 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 12, 8, 1, 0, false);            // UTC: 8:01 AM Local: 6:01 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 6, 1, 5, 0, false);             // UTC: 1:05 AM Local: 11:05 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 3, 7, 3, 0, false);             // UTC: 7:03 AM Local: 5:03 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 5, 10, 39, 0, false);           // UTC: 10:39 AM Local: 8:39 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 27, 0, 42, 0, false);           // UTC: 12:42 AM Local: 10:42 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 3, 10, 51, 0, false);           // UTC: 10:51 AM Local: 8:51 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 11, 21, 14, 0, false);          // UTC: 9:14 PM Local: 7:14 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 25, 3, 18, 0, false);           // UTC: 3:18 AM Local: 1:18 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 19, 19, 12, 0, false);          // UTC: 7:12 PM Local: 5:12 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 26, 17, 16, 0, false);          // UTC: 5:16 PM Local: 3:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 1, 11, 9, 0, false);            // UTC: 11:09 AM Local: 9:09 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 26, 6, 15, 0, false);           // UTC: 6:15 AM Local: 4:15 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 18, 14, 19, 0, false);          // UTC: 2:19 PM Local: 12:19 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 16, 11, 15, 0, false);          // UTC: 11:15 AM Local: 9:15 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 16, 12, 21, 0, false);          // UTC: 12:21 PM Local: 10:21 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 17, 0, 52, 0, false);           // UTC: 12:52 AM Local: 10:52 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 11, 16, 41, 0, false);          // UTC: 4:41 PM Local: 2:41 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 8, 15, 37, 0, false);           // UTC: 3:37 PM Local: 1:37 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 3, 11, 12, 0, false);           // UTC: 11:12 AM Local: 9:12 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 6, 20, 11, 12, 0, false);          // UTC: 11:12 AM Local: 9:12 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 24, 3, 32, 0, false);           // UTC: 3:32 AM Local: 1:32 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 22, 3, 55, 0, false);           // UTC: 3:55 AM Local: 1:55 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 14, 0, 43, 0, false);           // UTC: 12:43 AM Local: 10:43 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 13, 9, 47, 0, false);           // UTC: 9:47 AM Local: 7:47 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 15, 18, 25, 0, false);          // UTC: 6:25 PM Local: 4:25 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 27, 7, 36, 0, false);           // UTC: 7:36 AM Local: 5:36 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 26, 1, 49, 0, false);           // UTC: 1:49 AM Local: 11:49 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 9, 12, 4, 0, false);            // UTC: 12:04 PM Local: 10:04 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 16, 17, 49, 0, false);          // UTC: 5:49 PM Local: 3:49 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 15, 18, 46, 0, false);          // UTC: 6:46 PM Local: 4:46 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 2, 21, 7, 0, false);            // UTC: 9:07 PM Local: 7:07 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 4, 15, 21, 0, false);           // UTC: 3:21 PM Local: 1:21 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 20, 18, 23, 0, false);          // UTC: 6:23 PM Local: 4:23 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 12, 2, 57, 0, false);           // UTC: 2:57 AM Local: 12:57 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 5, 21, 16, 0, false);           // UTC: 9:16 PM Local: 7:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 25, 16, 50, 0, false);          // UTC: 4:50 PM Local: 2:50 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 6, 2, 10, 0, false);            // UTC: 2:10 AM Local: 12:10 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 16, 17, 25, 0, false);          // UTC: 5:25 PM Local: 3:25 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 10, 13, 34, 0, false);          // UTC: 1:34 PM Local: 11:34 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 13, 5, 22, 0, false);           // UTC: 5:22 AM Local: 3:22 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 3, 22, 12, 0, false);           // UTC: 10:12 PM Local: 8:12 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 26, 9, 28, 0, false);           // UTC: 9:28 AM Local: 7:28 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 19, 9, 6, 0, false);            // UTC: 9:06 AM Local: 7:06 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 2, 5, 31, 0, false);            // UTC: 5:31 AM Local: 3:31 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 7, 7, 12, 56, 0, false);           // UTC: 12:56 PM Local: 10:56 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 24, 3, 36, 0, false);           // UTC: 3:36 AM Local: 1:36 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 22, 15, 0, 0, false);           // UTC: 3:00 PM Local: 1:00 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 27, 7, 41, 0, false);           // UTC: 7:41 AM Local: 5:41 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 17, 10, 9, 0, false);           // UTC: 10:09 AM Local: 8:09 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 20, 17, 7, 0, false);           // UTC: 5:07 PM Local: 3:07 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 21, 5, 34, 0, false);           // UTC: 5:34 AM Local: 3:34 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 1, 7, 7, 0, false);             // UTC: 7:07 AM Local: 5:07 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 21, 5, 31, 0, false);           // UTC: 5:31 AM Local: 3:31 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 22, 5, 18, 0, false);           // UTC: 5:18 AM Local: 3:18 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 21, 3, 51, 0, false);           // UTC: 3:51 AM Local: 1:51 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 18, 8, 14, 0, false);           // UTC: 8:14 AM Local: 6:14 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 13, 11, 24, 0, false);          // UTC: 11:24 AM Local: 9:24 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 27, 15, 31, 0, false);          // UTC: 3:31 PM Local: 1:31 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 11, 2, 39, 0, false);           // UTC: 2:39 AM Local: 12:39 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 14, 7, 55, 0, false);           // UTC: 7:55 AM Local: 5:55 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 9, 22, 39, 0, false);           // UTC: 10:39 PM Local: 8:39 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 27, 6, 0, 0, false);            // UTC: 6:00 AM Local: 4:00 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 26, 5, 12, 0, false);           // UTC: 5:12 AM Local: 3:12 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 23, 2, 55, 0, false);           // UTC: 2:55 AM Local: 12:55 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 3, 22, 27, 0, false);           // UTC: 10:27 PM Local: 8:27 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 20, 5, 10, 0, false);           // UTC: 5:10 AM Local: 3:10 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 23, 22, 6, 0, false);           // UTC: 10:06 PM Local: 8:06 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 25, 5, 14, 0, false);           // UTC: 5:14 AM Local: 3:14 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 20, 18, 33, 0, false);          // UTC: 6:33 PM Local: 4:33 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 8, 2, 14, 10, 0, false);           // UTC: 2:10 PM Local: 12:10 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 13, 5, 52, 0, false);           // UTC: 5:52 AM Local: 3:52 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 17, 11, 14, 0, false);          // UTC: 11:14 AM Local: 9:14 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 18, 17, 51, 0, false);          // UTC: 5:51 PM Local: 3:51 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 24, 16, 7, 0, false);           // UTC: 4:07 PM Local: 2:07 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 2, 14, 23, 0, false);           // UTC: 2:23 PM Local: 12:23 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 13, 20, 40, 0, false);          // UTC: 8:40 PM Local: 6:40 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 3, 15, 53, 0, false);           // UTC: 3:53 PM Local: 1:53 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 14, 15, 22, 0, false);          // UTC: 3:22 PM Local: 1:22 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 23, 9, 42, 0, false);           // UTC: 9:42 AM Local: 7:42 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 12, 6, 28, 0, false);           // UTC: 6:28 AM Local: 4:28 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 12, 20, 35, 0, false);          // UTC: 8:35 PM Local: 6:35 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 1, 8, 50, 0, false);            // UTC: 8:50 AM Local: 6:50 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 2, 11, 29, 0, false);           // UTC: 11:29 AM Local: 9:29 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 6, 1, 27, 0, false);            // UTC: 1:27 AM Local: 11:27 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 9, 22, 15, 0, false);           // UTC: 10:15 PM Local: 8:15 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 27, 19, 37, 0, false);          // UTC: 7:37 PM Local: 5:37 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 24, 5, 52, 0, false);           // UTC: 5:52 AM Local: 3:52 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 24, 22, 56, 0, false);          // UTC: 10:56 PM Local: 8:56 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 8, 22, 33, 0, false);           // UTC: 10:33 PM Local: 8:33 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 14, 17, 5, 0, false);           // UTC: 5:05 PM Local: 3:05 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 15, 5, 29, 0, false);           // UTC: 5:29 AM Local: 3:29 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 11, 10, 46, 0, false);          // UTC: 10:46 AM Local: 8:46 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 15, 0, 13, 0, false);           // UTC: 12:13 AM Local: 10:13 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 15, 9, 24, 0, false);           // UTC: 9:24 AM Local: 7:24 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 9, 6, 19, 35, 0, false);           // UTC: 7:35 PM Local: 5:35 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 12, 4, 42, 0, false);          // UTC: 4:42 AM Local: 2:42 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 4, 19, 31, 0, false);          // UTC: 7:31 PM Local: 5:31 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 3, 12, 0, 0, false);           // UTC: 12:00 PM Local: 10:00 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 16, 12, 55, 0, false);         // UTC: 12:55 PM Local: 10:55 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 18, 17, 25, 0, false);         // UTC: 5:25 PM Local: 3:25 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 8, 12, 42, 0, false);          // UTC: 12:42 PM Local: 10:42 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 12, 15, 48, 0, false);         // UTC: 3:48 PM Local: 1:48 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 26, 21, 30, 0, false);         // UTC: 9:30 PM Local: 7:30 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 13, 10, 50, 0, false);         // UTC: 10:50 AM Local: 8:50 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 11, 6, 49, 0, false);          // UTC: 6:49 AM Local: 4:49 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 13, 16, 6, 0, false);          // UTC: 4:06 PM Local: 2:06 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 10, 19, 45, 0, false);         // UTC: 7:45 PM Local: 5:45 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 24, 9, 54, 0, false);          // UTC: 9:54 AM Local: 7:54 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 15, 9, 39, 0, false);          // UTC: 9:39 AM Local: 7:39 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 14, 18, 53, 0, false);         // UTC: 6:53 PM Local: 4:53 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 23, 20, 16, 0, false);         // UTC: 8:16 PM Local: 6:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 22, 6, 51, 0, false);          // UTC: 6:51 AM Local: 4:51 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 19, 17, 10, 0, false);         // UTC: 5:10 PM Local: 3:10 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 22, 10, 15, 0, false);         // UTC: 10:15 AM Local: 8:15 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 6, 14, 22, 0, false);          // UTC: 2:22 PM Local: 12:22 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 19, 15, 15, 0, false);         // UTC: 3:15 PM Local: 1:15 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 5, 2, 49, 0, false);           // UTC: 2:49 AM Local: 12:49 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 23, 6, 52, 0, false);          // UTC: 6:52 AM Local: 4:52 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 18, 9, 9, 0, false);           // UTC: 9:09 AM Local: 7:09 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 10, 22, 19, 14, 0, false);         // UTC: 7:14 PM Local: 5:14 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 5, 10, 6, 0, false);           // UTC: 10:06 AM Local: 8:06 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 17, 14, 33, 0, false);         // UTC: 2:33 PM Local: 12:33 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 16, 13, 1, 0, false);          // UTC: 1:01 PM Local: 11:01 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 27, 18, 55, 0, false);         // UTC: 6:55 PM Local: 4:55 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 26, 13, 22, 0, false);         // UTC: 1:22 PM Local: 11:22 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 14, 14, 44, 0, false);         // UTC: 2:44 PM Local: 12:44 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 15, 20, 43, 0, false);         // UTC: 8:43 PM Local: 6:43 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 12, 7, 40, 0, false);          // UTC: 7:40 AM Local: 5:40 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 2, 22, 35, 0, false);          // UTC: 10:35 PM Local: 8:35 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 11, 3, 50, 0, false);          // UTC: 3:50 AM Local: 1:50 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 20, 20, 53, 0, false);         // UTC: 8:53 PM Local: 6:53 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 25, 14, 0, 0, false);          // UTC: 2:00 PM Local: 12:00 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 5, 13, 0, 0, false);           // UTC: 1:00 PM Local: 11:00 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 22, 2, 5, 0, false);           // UTC: 2:05 AM Local: 12:05 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 7, 4, 18, 0, false);           // UTC: 4:18 AM Local: 2:18 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 25, 21, 41, 0, false);         // UTC: 9:41 PM Local: 7:41 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 14, 3, 45, 0, false);          // UTC: 3:45 AM Local: 1:45 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 11, 5, 58, 0, false);          // UTC: 5:58 AM Local: 3:58 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 14, 17, 8, 0, false);          // UTC: 5:08 PM Local: 3:08 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 12, 12, 37, 0, false);         // UTC: 12:37 PM Local: 10:37 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 26, 4, 26, 0, false);          // UTC: 4:26 AM Local: 2:26 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 5, 6, 52, 0, false);           // UTC: 6:52 AM Local: 4:52 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 1, 0, 56, 0, false);           // UTC: 12:56 AM Local: 10:56 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 10, 8, 2, 0, false);           // UTC: 8:02 AM Local: 6:02 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 11, 21, 16, 45, 0, false);         // UTC: 4:45 PM Local: 2:45 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 18, 4, 7, 0, false);           // UTC: 4:07 AM Local: 2:07 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 10, 3, 4, 0, false);           // UTC: 3:04 AM Local: 1:04 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 25, 20, 1, 0, false);          // UTC: 8:01 PM Local: 6:01 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 3, 7, 39, 0, false);           // UTC: 7:39 AM Local: 5:39 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 25, 9, 51, 0, false);          // UTC: 9:51 AM Local: 7:51 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 24, 16, 3, 0, false);          // UTC: 4:03 PM Local: 2:03 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 10, 19, 54, 0, false);         // UTC: 7:54 PM Local: 5:54 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 18, 1, 54, 0, false);          // UTC: 1:54 AM Local: 11:54 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 12, 20, 53, 0, false);         // UTC: 8:53 PM Local: 6:53 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 21, 3, 46, 0, false);          // UTC: 3:46 AM Local: 1:46 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 20, 14, 29, 0, false);         // UTC: 2:29 PM Local: 12:29 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 7, 19, 33, 0, false);          // UTC: 7:33 PM Local: 5:33 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 1, 1, 22, 0, false);           // UTC: 1:22 AM Local: 11:22 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 16, 1, 18, 0, false);          // UTC: 1:18 AM Local: 11:18 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 12, 2, 56, 0, false);          // UTC: 2:56 AM Local: 12:56 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 6, 2, 34, 0, false);           // UTC: 2:34 AM Local: 12:34 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 3, 11, 37, 0, false);          // UTC: 11:37 AM Local: 9:37 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 27, 9, 52, 0, false);          // UTC: 9:52 AM Local: 7:52 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 23, 22, 6, 0, false);          // UTC: 10:06 PM Local: 8:06 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 6, 21, 16, 0, false);          // UTC: 9:16 PM Local: 7:16 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 5, 3, 42, 0, false);           // UTC: 3:42 AM Local: 1:42 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 7, 8, 38, 0, false);           // UTC: 8:38 AM Local: 6:38 PM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 5, 15, 32, 0, false);          // UTC: 3:32 PM Local: 1:32 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 8, 19, 39, 0, false);          // UTC: 7:39 PM Local: 5:39 AM Offset: 10:00:00
	testCount++; failedCount += test(timeManager, 5, 2020, 12, 19, 18, 46, 0, false);         // UTC: 6:46 PM Local: 4:46 AM Offset: 10:00:00

	Serial.println(); Serial.print(failedCount); Serial.print(" of "); Serial.print(testCount); Serial.println(" test(s) failed.");
}
#endif
