#ifndef TEST_TIMEZONEID_4_H
#define TEST_TIMEZONEID_4_H

#include "TimeManager.h"
#include "TestHelper.h"

void run_TimeZoneId_4_Tests(const TimeManager& timeManager)
{
	uint16_t testCount = 0;
	uint16_t failedCount = 0;

	testCount++; failedCount += test(timeManager, 4, 2018, 1, 23, 17, 33, 0, false);          // UTC: 5:33 PM Local: 6:33 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 21, 10, 10, 0, false);          // UTC: 10:10 AM Local: 11:10 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 25, 6, 1, 0, false);            // UTC: 6:01 AM Local: 7:01 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 26, 9, 52, 0, false);           // UTC: 9:52 AM Local: 10:52 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 1, 4, 40, 0, false);            // UTC: 4:40 AM Local: 5:40 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 1, 18, 37, 0, false);           // UTC: 6:37 PM Local: 7:37 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 22, 4, 42, 0, false);           // UTC: 4:42 AM Local: 5:42 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 20, 13, 37, 0, false);          // UTC: 1:37 PM Local: 2:37 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 14, 1, 5, 0, false);            // UTC: 1:05 AM Local: 2:05 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 13, 14, 16, 0, false);          // UTC: 2:16 PM Local: 3:16 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 1, 13, 49, 0, false);           // UTC: 1:49 PM Local: 2:49 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 22, 8, 39, 0, false);           // UTC: 8:39 AM Local: 9:39 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 10, 21, 41, 0, false);          // UTC: 9:41 PM Local: 10:41 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 21, 21, 16, 0, false);          // UTC: 9:16 PM Local: 10:16 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 1, 22, 6, 0, false);            // UTC: 10:06 PM Local: 11:06 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 19, 19, 49, 0, false);          // UTC: 7:49 PM Local: 8:49 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 17, 18, 31, 0, false);          // UTC: 6:31 PM Local: 7:31 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 19, 0, 16, 0, false);           // UTC: 12:16 AM Local: 1:16 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 26, 2, 9, 0, false);            // UTC: 2:09 AM Local: 3:09 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 26, 5, 22, 0, false);           // UTC: 5:22 AM Local: 6:22 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 3, 10, 36, 0, false);           // UTC: 10:36 AM Local: 11:36 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 21, 21, 47, 0, false);          // UTC: 9:47 PM Local: 10:47 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 2, 5, 48, 0, false);            // UTC: 5:48 AM Local: 6:48 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 1, 16, 50, 0, false);           // UTC: 4:50 PM Local: 5:50 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 1, 25, 1, 13, 0, false);           // UTC: 1:13 AM Local: 2:13 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 12, 16, 37, 0, false);          // UTC: 4:37 PM Local: 5:37 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 14, 19, 13, 0, false);          // UTC: 7:13 PM Local: 8:13 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 7, 19, 48, 0, false);           // UTC: 7:48 PM Local: 8:48 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 21, 7, 32, 0, false);           // UTC: 7:32 AM Local: 8:32 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 16, 19, 16, 0, false);          // UTC: 7:16 PM Local: 8:16 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 14, 9, 41, 0, false);           // UTC: 9:41 AM Local: 10:41 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 9, 15, 29, 0, false);           // UTC: 3:29 PM Local: 4:29 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 18, 6, 0, 0, false);            // UTC: 6:00 AM Local: 7:00 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 9, 14, 37, 0, false);           // UTC: 2:37 PM Local: 3:37 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 1, 13, 6, 0, false);            // UTC: 1:06 PM Local: 2:06 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 19, 17, 58, 0, false);          // UTC: 5:58 PM Local: 6:58 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 2, 11, 23, 0, false);           // UTC: 11:23 AM Local: 12:23 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 15, 9, 23, 0, false);           // UTC: 9:23 AM Local: 10:23 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 5, 18, 36, 0, false);           // UTC: 6:36 PM Local: 7:36 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 22, 22, 36, 0, false);          // UTC: 10:36 PM Local: 11:36 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 7, 11, 21, 0, false);           // UTC: 11:21 AM Local: 12:21 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 15, 12, 17, 0, false);          // UTC: 12:17 PM Local: 1:17 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 5, 13, 22, 0, false);           // UTC: 1:22 PM Local: 2:22 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 21, 17, 25, 0, false);          // UTC: 5:25 PM Local: 6:25 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 17, 4, 13, 0, false);           // UTC: 4:13 AM Local: 5:13 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 17, 5, 14, 0, false);           // UTC: 5:14 AM Local: 6:14 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 19, 1, 33, 0, false);           // UTC: 1:33 AM Local: 2:33 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 16, 11, 20, 0, false);          // UTC: 11:20 AM Local: 12:20 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 24, 22, 57, 0, false);          // UTC: 10:57 PM Local: 11:57 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 2, 8, 3, 50, 0, false);            // UTC: 3:50 AM Local: 4:50 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 24, 19, 16, 0, false);          // UTC: 7:16 PM Local: 8:16 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 11, 1, 6, 0, false);            // UTC: 1:06 AM Local: 2:06 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 8, 10, 4, 0, false);            // UTC: 10:04 AM Local: 11:04 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 23, 12, 9, 0, false);           // UTC: 12:09 PM Local: 1:09 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 17, 6, 43, 0, false);           // UTC: 6:43 AM Local: 7:43 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 26, 20, 13, 0, false);          // UTC: 8:13 PM Local: 9:13 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 5, 12, 34, 0, false);           // UTC: 12:34 PM Local: 1:34 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 11, 2, 54, 0, false);           // UTC: 2:54 AM Local: 3:54 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 2, 15, 57, 0, false);           // UTC: 3:57 PM Local: 4:57 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 1, 15, 32, 0, false);           // UTC: 3:32 PM Local: 4:32 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 9, 19, 24, 0, false);           // UTC: 7:24 PM Local: 8:24 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 15, 19, 54, 0, false);          // UTC: 7:54 PM Local: 8:54 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 5, 5, 7, 0, false);             // UTC: 5:07 AM Local: 6:07 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 4, 7, 45, 0, false);            // UTC: 7:45 AM Local: 8:45 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 5, 20, 32, 0, false);           // UTC: 8:32 PM Local: 9:32 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 11, 22, 12, 0, false);          // UTC: 10:12 PM Local: 11:12 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 17, 21, 3, 0, false);           // UTC: 9:03 PM Local: 10:03 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 21, 2, 35, 0, false);           // UTC: 2:35 AM Local: 3:35 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 8, 11, 44, 0, false);           // UTC: 11:44 AM Local: 12:44 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 10, 7, 23, 0, false);           // UTC: 7:23 AM Local: 8:23 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 4, 6, 47, 0, false);            // UTC: 6:47 AM Local: 7:47 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 14, 11, 39, 0, false);          // UTC: 11:39 AM Local: 12:39 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 21, 1, 25, 0, false);           // UTC: 1:25 AM Local: 2:25 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 22, 18, 40, 0, false);          // UTC: 6:40 PM Local: 7:40 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 3, 3, 1, 14, 0, false);            // UTC: 1:14 AM Local: 2:14 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 23, 4, 13, 0, false);           // UTC: 4:13 AM Local: 5:13 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 11, 14, 41, 0, false);          // UTC: 2:41 PM Local: 3:41 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 21, 8, 43, 0, false);           // UTC: 8:43 AM Local: 9:43 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 14, 12, 43, 0, false);          // UTC: 12:43 PM Local: 1:43 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 23, 6, 21, 0, false);           // UTC: 6:21 AM Local: 7:21 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 5, 18, 52, 0, false);           // UTC: 6:52 PM Local: 7:52 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 20, 22, 3, 0, false);           // UTC: 10:03 PM Local: 11:03 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 26, 15, 21, 0, false);          // UTC: 3:21 PM Local: 4:21 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 24, 15, 53, 0, false);          // UTC: 3:53 PM Local: 4:53 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 22, 18, 8, 0, false);           // UTC: 6:08 PM Local: 7:08 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 11, 15, 3, 0, false);           // UTC: 3:03 PM Local: 4:03 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 10, 9, 17, 0, false);           // UTC: 9:17 AM Local: 10:17 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 15, 22, 41, 0, false);          // UTC: 10:41 PM Local: 11:41 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 19, 8, 51, 0, false);           // UTC: 8:51 AM Local: 9:51 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 3, 0, 56, 0, false);            // UTC: 12:56 AM Local: 1:56 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 26, 21, 47, 0, false);          // UTC: 9:47 PM Local: 10:47 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 2, 14, 57, 0, false);           // UTC: 2:57 PM Local: 3:57 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 22, 8, 5, 0, false);            // UTC: 8:05 AM Local: 9:05 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 5, 20, 31, 0, false);           // UTC: 8:31 PM Local: 9:31 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 24, 11, 58, 0, false);          // UTC: 11:58 AM Local: 12:58 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 22, 22, 33, 0, false);          // UTC: 10:33 PM Local: 11:33 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 16, 2, 51, 0, false);           // UTC: 2:51 AM Local: 3:51 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 19, 10, 49, 0, false);          // UTC: 10:49 AM Local: 11:49 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 2, 14, 48, 0, false);           // UTC: 2:48 PM Local: 3:48 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 4, 5, 1, 36, 0, false);            // UTC: 1:36 AM Local: 2:36 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 5, 20, 38, 0, false);           // UTC: 8:38 PM Local: 9:38 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 11, 21, 43, 0, false);          // UTC: 9:43 PM Local: 10:43 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 3, 16, 9, 0, false);            // UTC: 4:09 PM Local: 5:09 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 5, 13, 18, 0, false);           // UTC: 1:18 PM Local: 2:18 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 27, 4, 33, 0, false);           // UTC: 4:33 AM Local: 5:33 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 21, 15, 29, 0, false);          // UTC: 3:29 PM Local: 4:29 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 20, 20, 23, 0, false);          // UTC: 8:23 PM Local: 9:23 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 9, 11, 52, 0, false);           // UTC: 11:52 AM Local: 12:52 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 3, 5, 28, 0, false);            // UTC: 5:28 AM Local: 6:28 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 26, 22, 1, 0, false);           // UTC: 10:01 PM Local: 11:01 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 5, 14, 18, 0, false);           // UTC: 2:18 PM Local: 3:18 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 13, 22, 58, 0, false);          // UTC: 10:58 PM Local: 11:58 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 25, 10, 32, 0, false);          // UTC: 10:32 AM Local: 11:32 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 8, 16, 14, 0, false);           // UTC: 4:14 PM Local: 5:14 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 12, 9, 32, 0, false);           // UTC: 9:32 AM Local: 10:32 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 16, 16, 15, 0, false);          // UTC: 4:15 PM Local: 5:15 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 8, 7, 55, 0, false);            // UTC: 7:55 AM Local: 8:55 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 9, 10, 8, 0, false);            // UTC: 10:08 AM Local: 11:08 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 6, 20, 22, 0, false);           // UTC: 8:22 PM Local: 9:22 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 21, 7, 41, 0, false);           // UTC: 7:41 AM Local: 8:41 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 7, 3, 43, 0, false);            // UTC: 3:43 AM Local: 4:43 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 4, 22, 56, 0, false);           // UTC: 10:56 PM Local: 11:56 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 1, 11, 11, 0, false);           // UTC: 11:11 AM Local: 12:11 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 16, 20, 12, 0, false);          // UTC: 8:12 PM Local: 9:12 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 5, 26, 10, 11, 0, false);          // UTC: 10:11 AM Local: 11:11 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 4, 20, 4, 0, false);            // UTC: 8:04 PM Local: 9:04 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 10, 12, 31, 0, false);          // UTC: 12:31 PM Local: 1:31 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 6, 15, 40, 0, false);           // UTC: 3:40 PM Local: 4:40 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 3, 19, 8, 0, false);            // UTC: 7:08 PM Local: 8:08 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 5, 5, 6, 0, false);             // UTC: 5:06 AM Local: 6:06 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 17, 3, 8, 0, false);            // UTC: 3:08 AM Local: 4:08 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 23, 0, 32, 0, false);           // UTC: 12:32 AM Local: 1:32 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 14, 6, 24, 0, false);           // UTC: 6:24 AM Local: 7:24 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 16, 12, 12, 0, false);          // UTC: 12:12 PM Local: 1:12 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 2, 16, 25, 0, false);           // UTC: 4:25 PM Local: 5:25 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 20, 8, 1, 0, false);            // UTC: 8:01 AM Local: 9:01 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 26, 1, 57, 0, false);           // UTC: 1:57 AM Local: 2:57 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 9, 9, 46, 0, false);            // UTC: 9:46 AM Local: 10:46 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 5, 0, 27, 0, false);            // UTC: 12:27 AM Local: 1:27 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 2, 1, 9, 0, false);             // UTC: 1:09 AM Local: 2:09 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 22, 19, 13, 0, false);          // UTC: 7:13 PM Local: 8:13 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 3, 22, 43, 0, false);           // UTC: 10:43 PM Local: 11:43 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 2, 2, 26, 0, false);            // UTC: 2:26 AM Local: 3:26 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 18, 14, 36, 0, false);          // UTC: 2:36 PM Local: 3:36 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 18, 17, 57, 0, false);          // UTC: 5:57 PM Local: 6:57 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 9, 3, 57, 0, false);            // UTC: 3:57 AM Local: 4:57 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 7, 8, 27, 0, false);            // UTC: 8:27 AM Local: 9:27 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 4, 4, 11, 0, false);            // UTC: 4:11 AM Local: 5:11 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 4, 6, 42, 0, false);            // UTC: 6:42 AM Local: 7:42 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 6, 10, 15, 57, 0, false);          // UTC: 3:57 PM Local: 4:57 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 3, 10, 13, 0, false);           // UTC: 10:13 AM Local: 11:13 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 8, 17, 40, 0, false);           // UTC: 5:40 PM Local: 6:40 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 27, 22, 44, 0, false);          // UTC: 10:44 PM Local: 11:44 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 19, 15, 16, 0, false);          // UTC: 3:16 PM Local: 4:16 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 16, 7, 25, 0, false);           // UTC: 7:25 AM Local: 8:25 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 10, 14, 38, 0, false);          // UTC: 2:38 PM Local: 3:38 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 22, 19, 52, 0, false);          // UTC: 7:52 PM Local: 8:52 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 14, 18, 40, 0, false);          // UTC: 6:40 PM Local: 7:40 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 19, 15, 38, 0, false);          // UTC: 3:38 PM Local: 4:38 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 2, 21, 38, 0, false);           // UTC: 9:38 PM Local: 10:38 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 1, 16, 24, 0, false);           // UTC: 4:24 PM Local: 5:24 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 13, 12, 9, 0, false);           // UTC: 12:09 PM Local: 1:09 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 11, 8, 58, 0, false);           // UTC: 8:58 AM Local: 9:58 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 8, 7, 9, 0, false);             // UTC: 7:09 AM Local: 8:09 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 6, 12, 41, 0, false);           // UTC: 12:41 PM Local: 1:41 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 6, 12, 52, 0, false);           // UTC: 12:52 PM Local: 1:52 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 21, 18, 38, 0, false);          // UTC: 6:38 PM Local: 7:38 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 2, 13, 49, 0, false);           // UTC: 1:49 PM Local: 2:49 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 3, 13, 40, 0, false);           // UTC: 1:40 PM Local: 2:40 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 15, 13, 4, 0, false);           // UTC: 1:04 PM Local: 2:04 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 2, 21, 3, 0, false);            // UTC: 9:03 PM Local: 10:03 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 3, 15, 56, 0, false);           // UTC: 3:56 PM Local: 4:56 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 24, 2, 44, 0, false);           // UTC: 2:44 AM Local: 3:44 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 8, 22, 15, 0, false);           // UTC: 10:15 PM Local: 11:15 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 7, 18, 11, 30, 0, false);          // UTC: 11:30 AM Local: 12:30 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 20, 6, 13, 0, false);           // UTC: 6:13 AM Local: 7:13 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 27, 11, 8, 0, false);           // UTC: 11:08 AM Local: 12:08 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 21, 6, 8, 0, false);            // UTC: 6:08 AM Local: 7:08 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 27, 21, 7, 0, false);           // UTC: 9:07 PM Local: 10:07 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 16, 8, 56, 0, false);           // UTC: 8:56 AM Local: 9:56 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 14, 19, 47, 0, false);          // UTC: 7:47 PM Local: 8:47 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 25, 5, 23, 0, false);           // UTC: 5:23 AM Local: 6:23 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 3, 2, 52, 0, false);            // UTC: 2:52 AM Local: 3:52 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 21, 7, 25, 0, false);           // UTC: 7:25 AM Local: 8:25 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 4, 10, 48, 0, false);           // UTC: 10:48 AM Local: 11:48 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 11, 9, 3, 0, false);            // UTC: 9:03 AM Local: 10:03 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 9, 7, 18, 0, false);            // UTC: 7:18 AM Local: 8:18 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 13, 13, 5, 0, false);           // UTC: 1:05 PM Local: 2:05 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 26, 6, 38, 0, false);           // UTC: 6:38 AM Local: 7:38 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 25, 2, 42, 0, false);           // UTC: 2:42 AM Local: 3:42 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 23, 7, 42, 0, false);           // UTC: 7:42 AM Local: 8:42 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 22, 18, 6, 0, false);           // UTC: 6:06 PM Local: 7:06 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 13, 17, 14, 0, false);          // UTC: 5:14 PM Local: 6:14 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 4, 14, 9, 0, false);            // UTC: 2:09 PM Local: 3:09 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 10, 4, 10, 0, false);           // UTC: 4:10 AM Local: 5:10 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 20, 14, 48, 0, false);          // UTC: 2:48 PM Local: 3:48 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 9, 13, 31, 0, false);           // UTC: 1:31 PM Local: 2:31 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 2, 5, 2, 0, false);             // UTC: 5:02 AM Local: 6:02 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 18, 0, 15, 0, false);           // UTC: 12:15 AM Local: 1:15 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 8, 20, 22, 57, 0, false);          // UTC: 10:57 PM Local: 11:57 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 21, 4, 0, 0, false);            // UTC: 4:00 AM Local: 5:00 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 5, 21, 0, 0, false);            // UTC: 9:00 PM Local: 10:00 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 19, 7, 40, 0, false);           // UTC: 7:40 AM Local: 8:40 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 20, 21, 37, 0, false);          // UTC: 9:37 PM Local: 10:37 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 22, 4, 41, 0, false);           // UTC: 4:41 AM Local: 5:41 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 5, 2, 21, 0, false);            // UTC: 2:21 AM Local: 3:21 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 25, 5, 38, 0, false);           // UTC: 5:38 AM Local: 6:38 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 23, 13, 29, 0, false);          // UTC: 1:29 PM Local: 2:29 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 5, 17, 4, 0, false);            // UTC: 5:04 PM Local: 6:04 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 19, 3, 45, 0, false);           // UTC: 3:45 AM Local: 4:45 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 23, 16, 47, 0, false);          // UTC: 4:47 PM Local: 5:47 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 8, 8, 26, 0, false);            // UTC: 8:26 AM Local: 9:26 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 5, 4, 16, 0, false);            // UTC: 4:16 AM Local: 5:16 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 5, 0, 18, 0, false);            // UTC: 12:18 AM Local: 1:18 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 4, 13, 39, 0, false);           // UTC: 1:39 PM Local: 2:39 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 25, 5, 1, 0, false);            // UTC: 5:01 AM Local: 6:01 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 9, 11, 54, 0, false);           // UTC: 11:54 AM Local: 12:54 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 25, 18, 43, 0, false);          // UTC: 6:43 PM Local: 7:43 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 9, 21, 35, 0, false);           // UTC: 9:35 PM Local: 10:35 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 14, 22, 10, 0, false);          // UTC: 10:10 PM Local: 11:10 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 26, 0, 8, 0, false);            // UTC: 12:08 AM Local: 1:08 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 25, 19, 12, 0, false);          // UTC: 7:12 PM Local: 8:12 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 23, 12, 49, 0, false);          // UTC: 12:49 PM Local: 1:49 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 7, 22, 55, 0, false);           // UTC: 10:55 PM Local: 11:55 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 9, 3, 17, 12, 0, false);           // UTC: 5:12 PM Local: 6:12 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 10, 15, 57, 0, false);         // UTC: 3:57 PM Local: 4:57 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 23, 6, 29, 0, false);          // UTC: 6:29 AM Local: 7:29 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 2, 8, 40, 0, false);           // UTC: 8:40 AM Local: 9:40 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 23, 21, 54, 0, false);         // UTC: 9:54 PM Local: 10:54 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 2, 21, 26, 0, false);          // UTC: 9:26 PM Local: 10:26 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 24, 14, 11, 0, false);         // UTC: 2:11 PM Local: 3:11 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 3, 4, 0, 0, false);            // UTC: 4:00 AM Local: 5:00 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 5, 5, 43, 0, false);           // UTC: 5:43 AM Local: 6:43 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 13, 1, 42, 0, false);          // UTC: 1:42 AM Local: 2:42 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 6, 1, 29, 0, false);           // UTC: 1:29 AM Local: 2:29 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 27, 18, 2, 0, false);          // UTC: 6:02 PM Local: 7:02 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 15, 22, 13, 0, false);         // UTC: 10:13 PM Local: 11:13 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 17, 15, 40, 0, false);         // UTC: 3:40 PM Local: 4:40 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 19, 20, 38, 0, false);         // UTC: 8:38 PM Local: 9:38 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 13, 1, 54, 0, false);          // UTC: 1:54 AM Local: 2:54 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 8, 18, 34, 0, false);          // UTC: 6:34 PM Local: 7:34 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 11, 9, 19, 0, false);          // UTC: 9:19 AM Local: 10:19 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 20, 0, 32, 0, false);          // UTC: 12:32 AM Local: 1:32 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 6, 4, 27, 0, false);           // UTC: 4:27 AM Local: 5:27 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 7, 8, 13, 0, false);           // UTC: 8:13 AM Local: 9:13 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 21, 19, 17, 0, false);         // UTC: 7:17 PM Local: 8:17 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 6, 19, 7, 0, false);           // UTC: 7:07 PM Local: 8:07 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 24, 12, 56, 0, false);         // UTC: 12:56 PM Local: 1:56 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 6, 5, 57, 0, false);           // UTC: 5:57 AM Local: 6:57 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 10, 14, 9, 18, 0, false);          // UTC: 9:18 AM Local: 10:18 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 10, 15, 8, 0, false);          // UTC: 3:08 PM Local: 4:08 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 23, 3, 15, 0, false);          // UTC: 3:15 AM Local: 4:15 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 4, 18, 39, 0, false);          // UTC: 6:39 PM Local: 7:39 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 5, 5, 47, 0, false);           // UTC: 5:47 AM Local: 6:47 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 14, 7, 47, 0, false);          // UTC: 7:47 AM Local: 8:47 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 21, 8, 17, 0, false);          // UTC: 8:17 AM Local: 9:17 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 13, 21, 2, 0, false);          // UTC: 9:02 PM Local: 10:02 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 10, 6, 12, 0, false);          // UTC: 6:12 AM Local: 7:12 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 22, 9, 14, 0, false);          // UTC: 9:14 AM Local: 10:14 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 18, 4, 9, 0, false);           // UTC: 4:09 AM Local: 5:09 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 10, 5, 35, 0, false);          // UTC: 5:35 AM Local: 6:35 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 7, 19, 29, 0, false);          // UTC: 7:29 PM Local: 8:29 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 9, 9, 12, 0, false);           // UTC: 9:12 AM Local: 10:12 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 27, 14, 3, 0, false);          // UTC: 2:03 PM Local: 3:03 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 17, 0, 36, 0, false);          // UTC: 12:36 AM Local: 1:36 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 9, 8, 13, 0, false);           // UTC: 8:13 AM Local: 9:13 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 4, 10, 50, 0, false);          // UTC: 10:50 AM Local: 11:50 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 19, 1, 27, 0, false);          // UTC: 1:27 AM Local: 2:27 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 8, 0, 24, 0, false);           // UTC: 12:24 AM Local: 1:24 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 26, 0, 44, 0, false);          // UTC: 12:44 AM Local: 1:44 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 1, 11, 36, 0, false);          // UTC: 11:36 AM Local: 12:36 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 14, 18, 0, 0, false);          // UTC: 6:00 PM Local: 7:00 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 6, 5, 26, 0, false);           // UTC: 5:26 AM Local: 6:26 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 9, 10, 57, 0, false);          // UTC: 10:57 AM Local: 11:57 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 11, 3, 11, 17, 0, false);          // UTC: 11:17 AM Local: 12:17 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 27, 16, 14, 0, false);         // UTC: 4:14 PM Local: 5:14 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 17, 10, 2, 0, false);          // UTC: 10:02 AM Local: 11:02 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 1, 11, 42, 0, false);          // UTC: 11:42 AM Local: 12:42 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 9, 15, 11, 0, false);          // UTC: 3:11 PM Local: 4:11 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 4, 22, 50, 0, false);          // UTC: 10:50 PM Local: 11:50 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 3, 9, 22, 0, false);           // UTC: 9:22 AM Local: 10:22 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 13, 21, 8, 0, false);          // UTC: 9:08 PM Local: 10:08 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 12, 2, 13, 0, false);          // UTC: 2:13 AM Local: 3:13 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 17, 2, 6, 0, false);           // UTC: 2:06 AM Local: 3:06 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 22, 19, 0, 0, false);          // UTC: 7:00 PM Local: 8:00 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 24, 13, 32, 0, false);         // UTC: 1:32 PM Local: 2:32 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 5, 6, 15, 0, false);           // UTC: 6:15 AM Local: 7:15 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 5, 7, 34, 0, false);           // UTC: 7:34 AM Local: 8:34 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 20, 0, 58, 0, false);          // UTC: 12:58 AM Local: 1:58 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 25, 4, 6, 0, false);           // UTC: 4:06 AM Local: 5:06 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 23, 1, 16, 0, false);          // UTC: 1:16 AM Local: 2:16 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 16, 5, 2, 0, false);           // UTC: 5:02 AM Local: 6:02 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 16, 14, 32, 0, false);         // UTC: 2:32 PM Local: 3:32 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 5, 12, 36, 0, false);          // UTC: 12:36 PM Local: 1:36 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 1, 0, 20, 0, false);           // UTC: 12:20 AM Local: 1:20 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 26, 5, 39, 0, false);          // UTC: 5:39 AM Local: 6:39 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 20, 9, 5, 0, false);           // UTC: 9:05 AM Local: 10:05 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 18, 22, 41, 0, false);         // UTC: 10:41 PM Local: 11:41 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 16, 21, 3, 0, false);          // UTC: 9:03 PM Local: 10:03 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2018, 12, 22, 17, 55, 0, false);         // UTC: 5:55 PM Local: 6:55 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 5, 12, 55, 0, false);           // UTC: 12:55 PM Local: 1:55 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 4, 17, 2, 0, false);            // UTC: 5:02 PM Local: 6:02 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 23, 4, 35, 0, false);           // UTC: 4:35 AM Local: 5:35 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 26, 6, 57, 0, false);           // UTC: 6:57 AM Local: 7:57 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 1, 0, 43, 0, false);            // UTC: 12:43 AM Local: 1:43 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 18, 3, 19, 0, false);           // UTC: 3:19 AM Local: 4:19 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 7, 17, 45, 0, false);           // UTC: 5:45 PM Local: 6:45 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 9, 4, 44, 0, false);            // UTC: 4:44 AM Local: 5:44 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 1, 4, 6, 0, false);             // UTC: 4:06 AM Local: 5:06 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 16, 0, 17, 0, false);           // UTC: 12:17 AM Local: 1:17 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 27, 18, 50, 0, false);          // UTC: 6:50 PM Local: 7:50 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 17, 0, 58, 0, false);           // UTC: 12:58 AM Local: 1:58 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 19, 20, 13, 0, false);          // UTC: 8:13 PM Local: 9:13 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 8, 2, 2, 0, false);             // UTC: 2:02 AM Local: 3:02 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 2, 17, 7, 0, false);            // UTC: 5:07 PM Local: 6:07 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 4, 14, 55, 0, false);           // UTC: 2:55 PM Local: 3:55 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 26, 21, 46, 0, false);          // UTC: 9:46 PM Local: 10:46 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 20, 12, 57, 0, false);          // UTC: 12:57 PM Local: 1:57 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 5, 18, 21, 0, false);           // UTC: 6:21 PM Local: 7:21 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 5, 2, 34, 0, false);            // UTC: 2:34 AM Local: 3:34 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 26, 5, 11, 0, false);           // UTC: 5:11 AM Local: 6:11 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 9, 22, 29, 0, false);           // UTC: 10:29 PM Local: 11:29 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 4, 9, 1, 0, false);             // UTC: 9:01 AM Local: 10:01 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 20, 22, 13, 0, false);          // UTC: 10:13 PM Local: 11:13 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 1, 3, 21, 40, 0, false);           // UTC: 9:40 PM Local: 10:40 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 20, 6, 25, 0, false);           // UTC: 6:25 AM Local: 7:25 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 18, 20, 33, 0, false);          // UTC: 8:33 PM Local: 9:33 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 5, 14, 4, 0, false);            // UTC: 2:04 PM Local: 3:04 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 14, 5, 14, 0, false);           // UTC: 5:14 AM Local: 6:14 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 24, 9, 10, 0, false);           // UTC: 9:10 AM Local: 10:10 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 18, 11, 46, 0, false);          // UTC: 11:46 AM Local: 12:46 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 18, 8, 50, 0, false);           // UTC: 8:50 AM Local: 9:50 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 24, 17, 45, 0, false);          // UTC: 5:45 PM Local: 6:45 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 18, 22, 13, 0, false);          // UTC: 10:13 PM Local: 11:13 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 25, 5, 55, 0, false);           // UTC: 5:55 AM Local: 6:55 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 15, 14, 35, 0, false);          // UTC: 2:35 PM Local: 3:35 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 9, 10, 33, 0, false);           // UTC: 10:33 AM Local: 11:33 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 26, 12, 11, 0, false);          // UTC: 12:11 PM Local: 1:11 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 1, 17, 36, 0, false);           // UTC: 5:36 PM Local: 6:36 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 4, 18, 43, 0, false);           // UTC: 6:43 PM Local: 7:43 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 7, 5, 57, 0, false);            // UTC: 5:57 AM Local: 6:57 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 23, 2, 28, 0, false);           // UTC: 2:28 AM Local: 3:28 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 12, 10, 35, 0, false);          // UTC: 10:35 AM Local: 11:35 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 23, 19, 29, 0, false);          // UTC: 7:29 PM Local: 8:29 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 18, 22, 54, 0, false);          // UTC: 10:54 PM Local: 11:54 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 9, 6, 24, 0, false);            // UTC: 6:24 AM Local: 7:24 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 4, 22, 35, 0, false);           // UTC: 10:35 PM Local: 11:35 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 18, 13, 56, 0, false);          // UTC: 1:56 PM Local: 2:56 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 17, 16, 57, 0, false);          // UTC: 4:57 PM Local: 5:57 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 2, 17, 14, 35, 0, false);          // UTC: 2:35 PM Local: 3:35 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 7, 17, 57, 0, false);           // UTC: 5:57 PM Local: 6:57 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 2, 9, 43, 0, false);            // UTC: 9:43 AM Local: 10:43 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 8, 1, 6, 0, false);             // UTC: 1:06 AM Local: 2:06 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 13, 2, 10, 0, false);           // UTC: 2:10 AM Local: 3:10 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 1, 10, 35, 0, false);           // UTC: 10:35 AM Local: 11:35 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 2, 6, 32, 0, false);            // UTC: 6:32 AM Local: 7:32 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 8, 15, 28, 0, false);           // UTC: 3:28 PM Local: 4:28 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 6, 22, 48, 0, false);           // UTC: 10:48 PM Local: 11:48 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 4, 13, 40, 0, false);           // UTC: 1:40 PM Local: 2:40 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 1, 5, 24, 0, false);            // UTC: 5:24 AM Local: 6:24 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 14, 19, 50, 0, false);          // UTC: 7:50 PM Local: 8:50 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 27, 13, 6, 0, false);           // UTC: 1:06 PM Local: 2:06 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 15, 14, 35, 0, false);          // UTC: 2:35 PM Local: 3:35 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 5, 1, 12, 0, false);            // UTC: 1:12 AM Local: 2:12 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 8, 15, 50, 0, false);           // UTC: 3:50 PM Local: 4:50 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 12, 15, 5, 0, false);           // UTC: 3:05 PM Local: 4:05 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 10, 12, 24, 0, false);          // UTC: 12:24 PM Local: 1:24 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 12, 7, 54, 0, false);           // UTC: 7:54 AM Local: 8:54 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 4, 1, 44, 0, false);            // UTC: 1:44 AM Local: 2:44 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 5, 20, 47, 0, false);           // UTC: 8:47 PM Local: 9:47 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 2, 5, 48, 0, false);            // UTC: 5:48 AM Local: 6:48 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 20, 22, 15, 0, false);          // UTC: 10:15 PM Local: 11:15 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 9, 0, 52, 0, false);            // UTC: 12:52 AM Local: 1:52 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 14, 12, 40, 0, false);          // UTC: 12:40 PM Local: 1:40 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 3, 26, 2, 36, 0, false);           // UTC: 2:36 AM Local: 3:36 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 8, 20, 20, 0, false);           // UTC: 8:20 PM Local: 9:20 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 26, 16, 55, 0, false);          // UTC: 4:55 PM Local: 5:55 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 16, 15, 39, 0, false);          // UTC: 3:39 PM Local: 4:39 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 27, 2, 31, 0, false);           // UTC: 2:31 AM Local: 3:31 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 26, 20, 31, 0, false);          // UTC: 8:31 PM Local: 9:31 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 10, 8, 41, 0, false);           // UTC: 8:41 AM Local: 9:41 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 22, 3, 48, 0, false);           // UTC: 3:48 AM Local: 4:48 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 11, 13, 40, 0, false);          // UTC: 1:40 PM Local: 2:40 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 16, 2, 38, 0, false);           // UTC: 2:38 AM Local: 3:38 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 6, 19, 1, 0, false);            // UTC: 7:01 PM Local: 8:01 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 20, 11, 12, 0, false);          // UTC: 11:12 AM Local: 12:12 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 8, 19, 7, 0, false);            // UTC: 7:07 PM Local: 8:07 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 12, 4, 12, 0, false);           // UTC: 4:12 AM Local: 5:12 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 24, 10, 35, 0, false);          // UTC: 10:35 AM Local: 11:35 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 4, 16, 51, 0, false);           // UTC: 4:51 PM Local: 5:51 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 20, 8, 7, 0, false);            // UTC: 8:07 AM Local: 9:07 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 10, 3, 9, 0, false);            // UTC: 3:09 AM Local: 4:09 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 27, 3, 57, 0, false);           // UTC: 3:57 AM Local: 4:57 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 22, 20, 19, 0, false);          // UTC: 8:19 PM Local: 9:19 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 18, 8, 34, 0, false);           // UTC: 8:34 AM Local: 9:34 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 8, 8, 47, 0, false);            // UTC: 8:47 AM Local: 9:47 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 18, 6, 35, 0, false);           // UTC: 6:35 AM Local: 7:35 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 10, 14, 1, 0, false);           // UTC: 2:01 PM Local: 3:01 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 11, 21, 10, 0, false);          // UTC: 9:10 PM Local: 10:10 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 4, 14, 21, 38, 0, false);          // UTC: 9:38 PM Local: 10:38 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 7, 5, 51, 0, false);            // UTC: 5:51 AM Local: 6:51 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 22, 19, 42, 0, false);          // UTC: 7:42 PM Local: 8:42 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 14, 19, 42, 0, false);          // UTC: 7:42 PM Local: 8:42 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 24, 17, 20, 0, false);          // UTC: 5:20 PM Local: 6:20 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 7, 11, 57, 0, false);           // UTC: 11:57 AM Local: 12:57 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 22, 17, 48, 0, false);          // UTC: 5:48 PM Local: 6:48 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 17, 13, 5, 0, false);           // UTC: 1:05 PM Local: 2:05 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 22, 11, 25, 0, false);          // UTC: 11:25 AM Local: 12:25 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 8, 8, 44, 0, false);            // UTC: 8:44 AM Local: 9:44 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 3, 22, 11, 0, false);           // UTC: 10:11 PM Local: 11:11 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 27, 11, 11, 0, false);          // UTC: 11:11 AM Local: 12:11 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 9, 13, 37, 0, false);           // UTC: 1:37 PM Local: 2:37 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 13, 19, 29, 0, false);          // UTC: 7:29 PM Local: 8:29 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 24, 17, 31, 0, false);          // UTC: 5:31 PM Local: 6:31 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 3, 17, 30, 0, false);           // UTC: 5:30 PM Local: 6:30 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 8, 2, 8, 0, false);             // UTC: 2:08 AM Local: 3:08 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 2, 13, 11, 0, false);           // UTC: 1:11 PM Local: 2:11 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 10, 19, 21, 0, false);          // UTC: 7:21 PM Local: 8:21 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 16, 9, 44, 0, false);           // UTC: 9:44 AM Local: 10:44 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 12, 12, 28, 0, false);          // UTC: 12:28 PM Local: 1:28 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 27, 9, 52, 0, false);           // UTC: 9:52 AM Local: 10:52 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 15, 20, 14, 0, false);          // UTC: 8:14 PM Local: 9:14 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 4, 21, 53, 0, false);           // UTC: 9:53 PM Local: 10:53 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 10, 8, 54, 0, false);           // UTC: 8:54 AM Local: 9:54 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 5, 9, 17, 46, 0, false);           // UTC: 5:46 PM Local: 6:46 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 16, 16, 42, 0, false);          // UTC: 4:42 PM Local: 5:42 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 25, 0, 17, 0, false);           // UTC: 12:17 AM Local: 1:17 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 17, 1, 21, 0, false);           // UTC: 1:21 AM Local: 2:21 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 1, 14, 37, 0, false);           // UTC: 2:37 PM Local: 3:37 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 23, 17, 9, 0, false);           // UTC: 5:09 PM Local: 6:09 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 24, 0, 17, 0, false);           // UTC: 12:17 AM Local: 1:17 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 1, 20, 21, 0, false);           // UTC: 8:21 PM Local: 9:21 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 18, 12, 52, 0, false);          // UTC: 12:52 PM Local: 1:52 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 8, 2, 10, 0, false);            // UTC: 2:10 AM Local: 3:10 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 7, 16, 13, 0, false);           // UTC: 4:13 PM Local: 5:13 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 8, 0, 6, 0, false);             // UTC: 12:06 AM Local: 1:06 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 16, 22, 42, 0, false);          // UTC: 10:42 PM Local: 11:42 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 1, 11, 31, 0, false);           // UTC: 11:31 AM Local: 12:31 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 6, 8, 21, 0, false);            // UTC: 8:21 AM Local: 9:21 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 14, 12, 14, 0, false);          // UTC: 12:14 PM Local: 1:14 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 17, 6, 9, 0, false);            // UTC: 6:09 AM Local: 7:09 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 21, 10, 20, 0, false);          // UTC: 10:20 AM Local: 11:20 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 17, 6, 50, 0, false);           // UTC: 6:50 AM Local: 7:50 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 12, 21, 9, 0, false);           // UTC: 9:09 PM Local: 10:09 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 23, 15, 51, 0, false);          // UTC: 3:51 PM Local: 4:51 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 3, 8, 19, 0, false);            // UTC: 8:19 AM Local: 9:19 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 4, 16, 36, 0, false);           // UTC: 4:36 PM Local: 5:36 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 15, 6, 44, 0, false);           // UTC: 6:44 AM Local: 7:44 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 12, 19, 29, 0, false);          // UTC: 7:29 PM Local: 8:29 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 6, 21, 19, 30, 0, false);          // UTC: 7:30 PM Local: 8:30 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 1, 3, 1, 0, false);             // UTC: 3:01 AM Local: 4:01 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 18, 15, 48, 0, false);          // UTC: 3:48 PM Local: 4:48 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 1, 11, 15, 0, false);           // UTC: 11:15 AM Local: 12:15 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 24, 14, 42, 0, false);          // UTC: 2:42 PM Local: 3:42 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 7, 3, 4, 0, false);             // UTC: 3:04 AM Local: 4:04 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 15, 4, 50, 0, false);           // UTC: 4:50 AM Local: 5:50 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 18, 1, 1, 0, false);            // UTC: 1:01 AM Local: 2:01 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 1, 8, 46, 0, false);            // UTC: 8:46 AM Local: 9:46 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 18, 1, 1, 0, false);            // UTC: 1:01 AM Local: 2:01 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 12, 7, 35, 0, false);           // UTC: 7:35 AM Local: 8:35 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 23, 19, 27, 0, false);          // UTC: 7:27 PM Local: 8:27 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 9, 9, 46, 0, false);            // UTC: 9:46 AM Local: 10:46 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 4, 3, 58, 0, false);            // UTC: 3:58 AM Local: 4:58 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 2, 2, 51, 0, false);            // UTC: 2:51 AM Local: 3:51 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 2, 6, 5, 0, false);             // UTC: 6:05 AM Local: 7:05 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 24, 6, 7, 0, false);            // UTC: 6:07 AM Local: 7:07 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 19, 20, 38, 0, false);          // UTC: 8:38 PM Local: 9:38 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 18, 2, 44, 0, false);           // UTC: 2:44 AM Local: 3:44 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 14, 22, 45, 0, false);          // UTC: 10:45 PM Local: 11:45 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 7, 0, 33, 0, false);            // UTC: 12:33 AM Local: 1:33 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 22, 13, 10, 0, false);          // UTC: 1:10 PM Local: 2:10 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 19, 0, 45, 0, false);           // UTC: 12:45 AM Local: 1:45 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 8, 21, 43, 0, false);           // UTC: 9:43 PM Local: 10:43 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 9, 9, 2, 0, false);             // UTC: 9:02 AM Local: 10:02 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 7, 24, 14, 58, 0, false);          // UTC: 2:58 PM Local: 3:58 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 5, 21, 5, 0, false);            // UTC: 9:05 PM Local: 10:05 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 19, 17, 47, 0, false);          // UTC: 5:47 PM Local: 6:47 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 25, 17, 24, 0, false);          // UTC: 5:24 PM Local: 6:24 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 26, 4, 45, 0, false);           // UTC: 4:45 AM Local: 5:45 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 19, 19, 25, 0, false);          // UTC: 7:25 PM Local: 8:25 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 1, 20, 8, 0, false);            // UTC: 8:08 PM Local: 9:08 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 12, 5, 29, 0, false);           // UTC: 5:29 AM Local: 6:29 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 19, 9, 14, 0, false);           // UTC: 9:14 AM Local: 10:14 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 9, 14, 20, 0, false);           // UTC: 2:20 PM Local: 3:20 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 11, 8, 27, 0, false);           // UTC: 8:27 AM Local: 9:27 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 17, 17, 28, 0, false);          // UTC: 5:28 PM Local: 6:28 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 21, 7, 1, 0, false);            // UTC: 7:01 AM Local: 8:01 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 19, 12, 16, 0, false);          // UTC: 12:16 PM Local: 1:16 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 21, 20, 50, 0, false);          // UTC: 8:50 PM Local: 9:50 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 21, 16, 48, 0, false);          // UTC: 4:48 PM Local: 5:48 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 1, 13, 5, 0, false);            // UTC: 1:05 PM Local: 2:05 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 9, 6, 31, 0, false);            // UTC: 6:31 AM Local: 7:31 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 24, 10, 21, 0, false);          // UTC: 10:21 AM Local: 11:21 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 14, 10, 32, 0, false);          // UTC: 10:32 AM Local: 11:32 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 24, 8, 7, 0, false);            // UTC: 8:07 AM Local: 9:07 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 13, 12, 21, 0, false);          // UTC: 12:21 PM Local: 1:21 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 26, 7, 25, 0, false);           // UTC: 7:25 AM Local: 8:25 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 8, 21, 28, 0, false);           // UTC: 9:28 PM Local: 10:28 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 11, 7, 20, 0, false);           // UTC: 7:20 AM Local: 8:20 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 8, 24, 15, 21, 0, false);          // UTC: 3:21 PM Local: 4:21 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 18, 21, 40, 0, false);          // UTC: 9:40 PM Local: 10:40 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 12, 7, 2, 0, false);            // UTC: 7:02 AM Local: 8:02 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 7, 1, 5, 0, false);             // UTC: 1:05 AM Local: 2:05 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 26, 16, 19, 0, false);          // UTC: 4:19 PM Local: 5:19 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 4, 6, 51, 0, false);            // UTC: 6:51 AM Local: 7:51 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 14, 18, 10, 0, false);          // UTC: 6:10 PM Local: 7:10 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 4, 6, 21, 0, false);            // UTC: 6:21 AM Local: 7:21 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 14, 18, 23, 0, false);          // UTC: 6:23 PM Local: 7:23 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 11, 16, 37, 0, false);          // UTC: 4:37 PM Local: 5:37 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 17, 21, 55, 0, false);          // UTC: 9:55 PM Local: 10:55 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 5, 0, 45, 0, false);            // UTC: 12:45 AM Local: 1:45 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 1, 19, 31, 0, false);           // UTC: 7:31 PM Local: 8:31 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 24, 10, 1, 0, false);           // UTC: 10:01 AM Local: 11:01 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 3, 4, 26, 0, false);            // UTC: 4:26 AM Local: 5:26 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 8, 0, 34, 0, false);            // UTC: 12:34 AM Local: 1:34 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 3, 3, 39, 0, false);            // UTC: 3:39 AM Local: 4:39 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 17, 20, 32, 0, false);          // UTC: 8:32 PM Local: 9:32 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 5, 17, 21, 0, false);           // UTC: 5:21 PM Local: 6:21 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 27, 3, 8, 0, false);            // UTC: 3:08 AM Local: 4:08 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 8, 0, 35, 0, false);            // UTC: 12:35 AM Local: 1:35 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 12, 14, 8, 0, false);           // UTC: 2:08 PM Local: 3:08 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 5, 17, 42, 0, false);           // UTC: 5:42 PM Local: 6:42 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 16, 2, 23, 0, false);           // UTC: 2:23 AM Local: 3:23 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 10, 14, 21, 0, false);          // UTC: 2:21 PM Local: 3:21 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 9, 5, 1, 5, 0, false);             // UTC: 1:05 AM Local: 2:05 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 25, 5, 46, 0, false);          // UTC: 5:46 AM Local: 6:46 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 23, 6, 33, 0, false);          // UTC: 6:33 AM Local: 7:33 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 27, 22, 0, 0, false);          // UTC: 10:00 PM Local: 11:00 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 11, 0, 15, 0, false);          // UTC: 12:15 AM Local: 1:15 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 12, 0, 43, 0, false);          // UTC: 12:43 AM Local: 1:43 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 11, 13, 23, 0, false);         // UTC: 1:23 PM Local: 2:23 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 12, 15, 32, 0, false);         // UTC: 3:32 PM Local: 4:32 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 9, 2, 14, 0, false);           // UTC: 2:14 AM Local: 3:14 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 24, 12, 1, 0, false);          // UTC: 12:01 PM Local: 1:01 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 8, 6, 17, 0, false);           // UTC: 6:17 AM Local: 7:17 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 5, 0, 40, 0, false);           // UTC: 12:40 AM Local: 1:40 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 7, 1, 53, 0, false);           // UTC: 1:53 AM Local: 2:53 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 10, 10, 45, 0, false);         // UTC: 10:45 AM Local: 11:45 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 2, 10, 39, 0, false);          // UTC: 10:39 AM Local: 11:39 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 4, 17, 44, 0, false);          // UTC: 5:44 PM Local: 6:44 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 13, 3, 6, 0, false);           // UTC: 3:06 AM Local: 4:06 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 19, 21, 0, 0, false);          // UTC: 9:00 PM Local: 10:00 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 26, 16, 21, 0, false);         // UTC: 4:21 PM Local: 5:21 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 15, 14, 7, 0, false);          // UTC: 2:07 PM Local: 3:07 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 15, 21, 43, 0, false);         // UTC: 9:43 PM Local: 10:43 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 15, 16, 41, 0, false);         // UTC: 4:41 PM Local: 5:41 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 20, 4, 0, 0, false);           // UTC: 4:00 AM Local: 5:00 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 16, 3, 55, 0, false);          // UTC: 3:55 AM Local: 4:55 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 23, 0, 8, 0, false);           // UTC: 12:08 AM Local: 1:08 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 10, 18, 8, 14, 0, false);          // UTC: 8:14 AM Local: 9:14 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 25, 3, 19, 0, false);          // UTC: 3:19 AM Local: 4:19 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 14, 9, 23, 0, false);          // UTC: 9:23 AM Local: 10:23 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 25, 13, 20, 0, false);         // UTC: 1:20 PM Local: 2:20 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 8, 5, 16, 0, false);           // UTC: 5:16 AM Local: 6:16 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 9, 16, 26, 0, false);          // UTC: 4:26 PM Local: 5:26 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 21, 19, 29, 0, false);         // UTC: 7:29 PM Local: 8:29 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 1, 11, 43, 0, false);          // UTC: 11:43 AM Local: 12:43 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 26, 9, 33, 0, false);          // UTC: 9:33 AM Local: 10:33 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 21, 20, 58, 0, false);         // UTC: 8:58 PM Local: 9:58 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 5, 19, 52, 0, false);          // UTC: 7:52 PM Local: 8:52 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 24, 7, 20, 0, false);          // UTC: 7:20 AM Local: 8:20 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 4, 15, 27, 0, false);          // UTC: 3:27 PM Local: 4:27 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 22, 0, 32, 0, false);          // UTC: 12:32 AM Local: 1:32 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 10, 14, 6, 0, false);          // UTC: 2:06 PM Local: 3:06 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 10, 10, 57, 0, false);         // UTC: 10:57 AM Local: 11:57 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 20, 5, 26, 0, false);          // UTC: 5:26 AM Local: 6:26 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 14, 1, 12, 0, false);          // UTC: 1:12 AM Local: 2:12 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 18, 13, 52, 0, false);         // UTC: 1:52 PM Local: 2:52 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 14, 21, 43, 0, false);         // UTC: 9:43 PM Local: 10:43 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 21, 17, 30, 0, false);         // UTC: 5:30 PM Local: 6:30 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 11, 17, 44, 0, false);         // UTC: 5:44 PM Local: 6:44 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 13, 9, 53, 0, false);          // UTC: 9:53 AM Local: 10:53 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 25, 4, 3, 0, false);           // UTC: 4:03 AM Local: 5:03 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 27, 22, 47, 0, false);         // UTC: 10:47 PM Local: 11:47 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 11, 26, 15, 51, 0, false);         // UTC: 3:51 PM Local: 4:51 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 18, 13, 58, 0, false);         // UTC: 1:58 PM Local: 2:58 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 16, 0, 37, 0, false);          // UTC: 12:37 AM Local: 1:37 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 15, 15, 45, 0, false);         // UTC: 3:45 PM Local: 4:45 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 19, 5, 42, 0, false);          // UTC: 5:42 AM Local: 6:42 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 13, 14, 42, 0, false);         // UTC: 2:42 PM Local: 3:42 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 20, 0, 16, 0, false);          // UTC: 12:16 AM Local: 1:16 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 1, 21, 50, 0, false);          // UTC: 9:50 PM Local: 10:50 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 10, 20, 1, 0, false);          // UTC: 8:01 PM Local: 9:01 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 2, 18, 2, 0, false);           // UTC: 6:02 PM Local: 7:02 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 11, 11, 4, 0, false);          // UTC: 11:04 AM Local: 12:04 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 12, 15, 54, 0, false);         // UTC: 3:54 PM Local: 4:54 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 1, 20, 19, 0, false);          // UTC: 8:19 PM Local: 9:19 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 21, 4, 42, 0, false);          // UTC: 4:42 AM Local: 5:42 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 24, 19, 5, 0, false);          // UTC: 7:05 PM Local: 8:05 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 27, 17, 9, 0, false);          // UTC: 5:09 PM Local: 6:09 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 6, 10, 34, 0, false);          // UTC: 10:34 AM Local: 11:34 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 10, 6, 56, 0, false);          // UTC: 6:56 AM Local: 7:56 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 15, 21, 44, 0, false);         // UTC: 9:44 PM Local: 10:44 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 1, 6, 40, 0, false);           // UTC: 6:40 AM Local: 7:40 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 26, 11, 13, 0, false);         // UTC: 11:13 AM Local: 12:13 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 17, 3, 8, 0, false);           // UTC: 3:08 AM Local: 4:08 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 19, 6, 33, 0, false);          // UTC: 6:33 AM Local: 7:33 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 22, 10, 44, 0, false);         // UTC: 10:44 AM Local: 11:44 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 11, 22, 49, 0, false);         // UTC: 10:49 PM Local: 11:49 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2019, 12, 16, 3, 4, 0, false);           // UTC: 3:04 AM Local: 4:04 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 21, 8, 8, 0, false);            // UTC: 8:08 AM Local: 9:08 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 24, 20, 20, 0, false);          // UTC: 8:20 PM Local: 9:20 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 13, 1, 14, 0, false);           // UTC: 1:14 AM Local: 2:14 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 4, 20, 45, 0, false);           // UTC: 8:45 PM Local: 9:45 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 5, 22, 34, 0, false);           // UTC: 10:34 PM Local: 11:34 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 18, 18, 39, 0, false);          // UTC: 6:39 PM Local: 7:39 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 14, 6, 40, 0, false);           // UTC: 6:40 AM Local: 7:40 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 26, 6, 29, 0, false);           // UTC: 6:29 AM Local: 7:29 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 17, 9, 0, 0, false);            // UTC: 9:00 AM Local: 10:00 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 23, 21, 17, 0, false);          // UTC: 9:17 PM Local: 10:17 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 3, 22, 44, 0, false);           // UTC: 10:44 PM Local: 11:44 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 19, 5, 54, 0, false);           // UTC: 5:54 AM Local: 6:54 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 15, 1, 37, 0, false);           // UTC: 1:37 AM Local: 2:37 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 25, 3, 6, 0, false);            // UTC: 3:06 AM Local: 4:06 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 25, 13, 22, 0, false);          // UTC: 1:22 PM Local: 2:22 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 22, 14, 26, 0, false);          // UTC: 2:26 PM Local: 3:26 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 5, 16, 10, 0, false);           // UTC: 4:10 PM Local: 5:10 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 5, 1, 52, 0, false);            // UTC: 1:52 AM Local: 2:52 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 11, 18, 4, 0, false);           // UTC: 6:04 PM Local: 7:04 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 18, 6, 28, 0, false);           // UTC: 6:28 AM Local: 7:28 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 10, 14, 5, 0, false);           // UTC: 2:05 PM Local: 3:05 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 27, 0, 54, 0, false);           // UTC: 12:54 AM Local: 1:54 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 1, 11, 44, 0, false);           // UTC: 11:44 AM Local: 12:44 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 18, 2, 42, 0, false);           // UTC: 2:42 AM Local: 3:42 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 1, 2, 13, 7, 0, false);            // UTC: 1:07 PM Local: 2:07 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 16, 1, 42, 0, false);           // UTC: 1:42 AM Local: 2:42 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 3, 18, 45, 0, false);           // UTC: 6:45 PM Local: 7:45 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 15, 15, 12, 0, false);          // UTC: 3:12 PM Local: 4:12 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 3, 21, 52, 0, false);           // UTC: 9:52 PM Local: 10:52 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 24, 6, 26, 0, false);           // UTC: 6:26 AM Local: 7:26 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 24, 20, 47, 0, false);          // UTC: 8:47 PM Local: 9:47 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 4, 12, 31, 0, false);           // UTC: 12:31 PM Local: 1:31 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 1, 21, 32, 0, false);           // UTC: 9:32 PM Local: 10:32 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 13, 17, 7, 0, false);           // UTC: 5:07 PM Local: 6:07 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 20, 11, 37, 0, false);          // UTC: 11:37 AM Local: 12:37 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 13, 3, 27, 0, false);           // UTC: 3:27 AM Local: 4:27 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 21, 18, 43, 0, false);          // UTC: 6:43 PM Local: 7:43 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 10, 12, 27, 0, false);          // UTC: 12:27 PM Local: 1:27 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 20, 18, 55, 0, false);          // UTC: 6:55 PM Local: 7:55 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 24, 19, 4, 0, false);           // UTC: 7:04 PM Local: 8:04 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 2, 3, 13, 0, false);            // UTC: 3:13 AM Local: 4:13 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 9, 18, 12, 0, false);           // UTC: 6:12 PM Local: 7:12 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 25, 20, 2, 0, false);           // UTC: 8:02 PM Local: 9:02 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 17, 13, 8, 0, false);           // UTC: 1:08 PM Local: 2:08 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 5, 15, 2, 0, false);            // UTC: 3:02 PM Local: 4:02 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 18, 19, 10, 0, false);          // UTC: 7:10 PM Local: 8:10 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 16, 14, 47, 0, false);          // UTC: 2:47 PM Local: 3:47 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 12, 2, 27, 0, false);           // UTC: 2:27 AM Local: 3:27 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 20, 11, 20, 0, false);          // UTC: 11:20 AM Local: 12:20 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 2, 10, 9, 44, 0, false);           // UTC: 9:44 AM Local: 10:44 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 16, 2, 4, 0, false);            // UTC: 2:04 AM Local: 3:04 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 13, 9, 37, 0, false);           // UTC: 9:37 AM Local: 10:37 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 25, 9, 40, 0, false);           // UTC: 9:40 AM Local: 10:40 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 12, 12, 14, 0, false);          // UTC: 12:14 PM Local: 1:14 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 12, 3, 14, 0, false);           // UTC: 3:14 AM Local: 4:14 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 17, 4, 52, 0, false);           // UTC: 4:52 AM Local: 5:52 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 12, 2, 56, 0, false);           // UTC: 2:56 AM Local: 3:56 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 21, 7, 12, 0, false);           // UTC: 7:12 AM Local: 8:12 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 8, 14, 1, 0, false);            // UTC: 2:01 PM Local: 3:01 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 21, 13, 18, 0, false);          // UTC: 1:18 PM Local: 2:18 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 24, 13, 28, 0, false);          // UTC: 1:28 PM Local: 2:28 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 8, 0, 26, 0, false);            // UTC: 12:26 AM Local: 1:26 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 2, 15, 14, 0, false);           // UTC: 3:14 PM Local: 4:14 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 11, 16, 25, 0, false);          // UTC: 4:25 PM Local: 5:25 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 14, 3, 5, 0, false);            // UTC: 3:05 AM Local: 4:05 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 16, 22, 55, 0, false);          // UTC: 10:55 PM Local: 11:55 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 7, 2, 17, 0, false);            // UTC: 2:17 AM Local: 3:17 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 13, 20, 19, 0, false);          // UTC: 8:19 PM Local: 9:19 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 22, 19, 47, 0, false);          // UTC: 7:47 PM Local: 8:47 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 24, 4, 46, 0, false);           // UTC: 4:46 AM Local: 5:46 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 17, 3, 47, 0, false);           // UTC: 3:47 AM Local: 4:47 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 11, 13, 57, 0, false);          // UTC: 1:57 PM Local: 2:57 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 21, 3, 9, 0, false);            // UTC: 3:09 AM Local: 4:09 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 22, 12, 30, 0, false);          // UTC: 12:30 PM Local: 1:30 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 3, 18, 0, 21, 0, false);           // UTC: 12:21 AM Local: 1:21 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 15, 6, 10, 0, false);           // UTC: 6:10 AM Local: 7:10 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 3, 16, 37, 0, false);           // UTC: 4:37 PM Local: 5:37 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 3, 12, 29, 0, false);           // UTC: 12:29 PM Local: 1:29 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 1, 8, 39, 0, false);            // UTC: 8:39 AM Local: 9:39 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 5, 11, 10, 0, false);           // UTC: 11:10 AM Local: 12:10 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 18, 4, 27, 0, false);           // UTC: 4:27 AM Local: 5:27 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 13, 18, 34, 0, false);          // UTC: 6:34 PM Local: 7:34 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 17, 2, 33, 0, false);           // UTC: 2:33 AM Local: 3:33 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 4, 18, 50, 0, false);           // UTC: 6:50 PM Local: 7:50 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 22, 9, 33, 0, false);           // UTC: 9:33 AM Local: 10:33 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 21, 19, 51, 0, false);          // UTC: 7:51 PM Local: 8:51 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 26, 6, 32, 0, false);           // UTC: 6:32 AM Local: 7:32 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 18, 17, 29, 0, false);          // UTC: 5:29 PM Local: 6:29 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 4, 11, 36, 0, false);           // UTC: 11:36 AM Local: 12:36 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 9, 8, 11, 0, false);            // UTC: 8:11 AM Local: 9:11 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 8, 13, 37, 0, false);           // UTC: 1:37 PM Local: 2:37 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 27, 3, 20, 0, false);           // UTC: 3:20 AM Local: 4:20 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 2, 3, 13, 0, false);            // UTC: 3:13 AM Local: 4:13 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 22, 20, 10, 0, false);          // UTC: 8:10 PM Local: 9:10 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 17, 22, 53, 0, false);          // UTC: 10:53 PM Local: 11:53 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 21, 6, 5, 0, false);            // UTC: 6:05 AM Local: 7:05 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 26, 5, 32, 0, false);           // UTC: 5:32 AM Local: 6:32 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 22, 4, 12, 0, false);           // UTC: 4:12 AM Local: 5:12 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 18, 22, 25, 0, false);          // UTC: 10:25 PM Local: 11:25 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 4, 27, 7, 17, 0, false);           // UTC: 7:17 AM Local: 8:17 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 26, 7, 43, 0, false);           // UTC: 7:43 AM Local: 8:43 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 10, 19, 11, 0, false);          // UTC: 7:11 PM Local: 8:11 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 6, 18, 16, 0, false);           // UTC: 6:16 PM Local: 7:16 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 6, 16, 39, 0, false);           // UTC: 4:39 PM Local: 5:39 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 18, 4, 22, 0, false);           // UTC: 4:22 AM Local: 5:22 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 10, 0, 46, 0, false);           // UTC: 12:46 AM Local: 1:46 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 16, 8, 12, 0, false);           // UTC: 8:12 AM Local: 9:12 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 15, 8, 6, 0, false);            // UTC: 8:06 AM Local: 9:06 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 18, 11, 24, 0, false);          // UTC: 11:24 AM Local: 12:24 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 12, 8, 9, 0, false);            // UTC: 8:09 AM Local: 9:09 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 25, 1, 49, 0, false);           // UTC: 1:49 AM Local: 2:49 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 25, 19, 34, 0, false);          // UTC: 7:34 PM Local: 8:34 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 12, 5, 7, 0, false);            // UTC: 5:07 AM Local: 6:07 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 20, 12, 28, 0, false);          // UTC: 12:28 PM Local: 1:28 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 23, 16, 31, 0, false);          // UTC: 4:31 PM Local: 5:31 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 24, 3, 0, 0, false);            // UTC: 3:00 AM Local: 4:00 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 23, 6, 57, 0, false);           // UTC: 6:57 AM Local: 7:57 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 18, 9, 56, 0, false);           // UTC: 9:56 AM Local: 10:56 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 3, 9, 55, 0, false);            // UTC: 9:55 AM Local: 10:55 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 17, 16, 21, 0, false);          // UTC: 4:21 PM Local: 5:21 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 21, 18, 26, 0, false);          // UTC: 6:26 PM Local: 7:26 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 3, 6, 37, 0, false);            // UTC: 6:37 AM Local: 7:37 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 23, 16, 20, 0, false);          // UTC: 4:20 PM Local: 5:20 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 22, 21, 45, 0, false);          // UTC: 9:45 PM Local: 10:45 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 5, 18, 19, 48, 0, false);          // UTC: 7:48 PM Local: 8:48 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 20, 16, 38, 0, false);          // UTC: 4:38 PM Local: 5:38 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 16, 17, 19, 0, false);          // UTC: 5:19 PM Local: 6:19 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 11, 13, 4, 0, false);           // UTC: 1:04 PM Local: 2:04 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 6, 6, 39, 0, false);            // UTC: 6:39 AM Local: 7:39 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 24, 19, 23, 0, false);          // UTC: 7:23 PM Local: 8:23 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 18, 18, 31, 0, false);          // UTC: 6:31 PM Local: 7:31 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 21, 21, 44, 0, false);          // UTC: 9:44 PM Local: 10:44 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 1, 16, 25, 0, false);           // UTC: 4:25 PM Local: 5:25 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 25, 0, 25, 0, false);           // UTC: 12:25 AM Local: 1:25 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 19, 0, 20, 0, false);           // UTC: 12:20 AM Local: 1:20 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 6, 22, 31, 0, false);           // UTC: 10:31 PM Local: 11:31 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 4, 8, 42, 0, false);            // UTC: 8:42 AM Local: 9:42 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 9, 1, 55, 0, false);            // UTC: 1:55 AM Local: 2:55 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 1, 8, 11, 0, false);            // UTC: 8:11 AM Local: 9:11 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 11, 20, 0, 0, false);           // UTC: 8:00 PM Local: 9:00 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 27, 21, 52, 0, false);          // UTC: 9:52 PM Local: 10:52 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 26, 3, 6, 0, false);            // UTC: 3:06 AM Local: 4:06 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 7, 20, 54, 0, false);           // UTC: 8:54 PM Local: 9:54 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 2, 15, 58, 0, false);           // UTC: 3:58 PM Local: 4:58 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 6, 15, 43, 0, false);           // UTC: 3:43 PM Local: 4:43 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 25, 16, 32, 0, false);          // UTC: 4:32 PM Local: 5:32 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 21, 0, 18, 0, false);           // UTC: 12:18 AM Local: 1:18 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 4, 17, 28, 0, false);           // UTC: 5:28 PM Local: 6:28 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 19, 7, 45, 0, false);           // UTC: 7:45 AM Local: 8:45 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 6, 17, 17, 33, 0, false);          // UTC: 5:33 PM Local: 6:33 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 16, 15, 47, 0, false);          // UTC: 3:47 PM Local: 4:47 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 12, 21, 5, 0, false);           // UTC: 9:05 PM Local: 10:05 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 15, 16, 51, 0, false);          // UTC: 4:51 PM Local: 5:51 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 7, 21, 4, 0, false);            // UTC: 9:04 PM Local: 10:04 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 17, 1, 39, 0, false);           // UTC: 1:39 AM Local: 2:39 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 20, 2, 20, 0, false);           // UTC: 2:20 AM Local: 3:20 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 6, 2, 38, 0, false);            // UTC: 2:38 AM Local: 3:38 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 18, 14, 53, 0, false);          // UTC: 2:53 PM Local: 3:53 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 19, 18, 10, 0, false);          // UTC: 6:10 PM Local: 7:10 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 11, 5, 48, 0, false);           // UTC: 5:48 AM Local: 6:48 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 10, 14, 8, 0, false);           // UTC: 2:08 PM Local: 3:08 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 10, 11, 1, 0, false);           // UTC: 11:01 AM Local: 12:01 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 5, 17, 45, 0, false);           // UTC: 5:45 PM Local: 6:45 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 18, 8, 58, 0, false);           // UTC: 8:58 AM Local: 9:58 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 19, 11, 3, 0, false);           // UTC: 11:03 AM Local: 12:03 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 7, 12, 40, 0, false);           // UTC: 12:40 PM Local: 1:40 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 23, 21, 14, 0, false);          // UTC: 9:14 PM Local: 10:14 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 12, 9, 37, 0, false);           // UTC: 9:37 AM Local: 10:37 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 25, 21, 1, 0, false);           // UTC: 9:01 PM Local: 10:01 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 25, 17, 6, 0, false);           // UTC: 5:06 PM Local: 6:06 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 25, 3, 28, 0, false);           // UTC: 3:28 AM Local: 4:28 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 2, 20, 18, 0, false);           // UTC: 8:18 PM Local: 9:18 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 26, 5, 34, 0, false);           // UTC: 5:34 AM Local: 6:34 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 18, 13, 18, 0, false);          // UTC: 1:18 PM Local: 2:18 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 7, 16, 12, 44, 0, false);          // UTC: 12:44 PM Local: 1:44 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 18, 22, 6, 0, false);           // UTC: 10:06 PM Local: 11:06 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 23, 10, 17, 0, false);          // UTC: 10:17 AM Local: 11:17 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 14, 13, 18, 0, false);          // UTC: 1:18 PM Local: 2:18 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 16, 21, 14, 0, false);          // UTC: 9:14 PM Local: 10:14 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 14, 9, 33, 0, false);           // UTC: 9:33 AM Local: 10:33 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 27, 6, 1, 0, false);            // UTC: 6:01 AM Local: 7:01 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 18, 16, 12, 0, false);          // UTC: 4:12 PM Local: 5:12 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 14, 14, 37, 0, false);          // UTC: 2:37 PM Local: 3:37 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 21, 7, 15, 0, false);           // UTC: 7:15 AM Local: 8:15 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 3, 4, 22, 0, false);            // UTC: 4:22 AM Local: 5:22 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 26, 18, 49, 0, false);          // UTC: 6:49 PM Local: 7:49 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 24, 5, 56, 0, false);           // UTC: 5:56 AM Local: 6:56 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 25, 1, 17, 0, false);           // UTC: 1:17 AM Local: 2:17 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 22, 9, 34, 0, false);           // UTC: 9:34 AM Local: 10:34 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 5, 10, 56, 0, false);           // UTC: 10:56 AM Local: 11:56 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 2, 9, 48, 0, false);            // UTC: 9:48 AM Local: 10:48 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 1, 14, 18, 0, false);           // UTC: 2:18 PM Local: 3:18 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 8, 21, 49, 0, false);           // UTC: 9:49 PM Local: 10:49 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 15, 3, 20, 0, false);           // UTC: 3:20 AM Local: 4:20 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 14, 1, 8, 0, false);            // UTC: 1:08 AM Local: 2:08 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 1, 9, 23, 0, false);            // UTC: 9:23 AM Local: 10:23 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 26, 15, 6, 0, false);           // UTC: 3:06 PM Local: 4:06 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 11, 14, 10, 0, false);          // UTC: 2:10 PM Local: 3:10 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 17, 1, 11, 0, false);           // UTC: 1:11 AM Local: 2:11 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 8, 20, 19, 18, 0, false);          // UTC: 7:18 PM Local: 8:18 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 18, 7, 8, 0, false);            // UTC: 7:08 AM Local: 8:08 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 19, 15, 51, 0, false);          // UTC: 3:51 PM Local: 4:51 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 12, 2, 31, 0, false);           // UTC: 2:31 AM Local: 3:31 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 2, 14, 52, 0, false);           // UTC: 2:52 PM Local: 3:52 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 27, 7, 6, 0, false);            // UTC: 7:06 AM Local: 8:06 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 17, 9, 58, 0, false);           // UTC: 9:58 AM Local: 10:58 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 5, 18, 0, 0, false);            // UTC: 6:00 PM Local: 7:00 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 6, 5, 48, 0, false);            // UTC: 5:48 AM Local: 6:48 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 23, 15, 47, 0, false);          // UTC: 3:47 PM Local: 4:47 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 18, 9, 33, 0, false);           // UTC: 9:33 AM Local: 10:33 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 4, 12, 4, 0, false);            // UTC: 12:04 PM Local: 1:04 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 15, 20, 48, 0, false);          // UTC: 8:48 PM Local: 9:48 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 6, 18, 23, 0, false);           // UTC: 6:23 PM Local: 7:23 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 8, 13, 18, 0, false);           // UTC: 1:18 PM Local: 2:18 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 23, 20, 0, 0, false);           // UTC: 8:00 PM Local: 9:00 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 6, 9, 16, 0, false);            // UTC: 9:16 AM Local: 10:16 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 2, 0, 38, 0, false);            // UTC: 12:38 AM Local: 1:38 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 6, 13, 3, 0, false);            // UTC: 1:03 PM Local: 2:03 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 8, 10, 6, 0, false);            // UTC: 10:06 AM Local: 11:06 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 9, 19, 1, 0, false);            // UTC: 7:01 PM Local: 8:01 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 2, 18, 41, 0, false);           // UTC: 6:41 PM Local: 7:41 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 27, 21, 4, 0, false);           // UTC: 9:04 PM Local: 10:04 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 23, 10, 26, 0, false);          // UTC: 10:26 AM Local: 11:26 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 8, 9, 36, 0, false);            // UTC: 9:36 AM Local: 10:36 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 9, 16, 20, 11, 0, false);          // UTC: 8:11 PM Local: 9:11 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 20, 7, 21, 0, false);          // UTC: 7:21 AM Local: 8:21 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 22, 14, 14, 0, false);         // UTC: 2:14 PM Local: 3:14 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 15, 13, 22, 0, false);         // UTC: 1:22 PM Local: 2:22 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 25, 20, 58, 0, false);         // UTC: 8:58 PM Local: 9:58 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 1, 5, 26, 0, false);           // UTC: 5:26 AM Local: 6:26 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 20, 20, 58, 0, false);         // UTC: 8:58 PM Local: 9:58 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 10, 4, 46, 0, false);          // UTC: 4:46 AM Local: 5:46 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 17, 20, 54, 0, false);         // UTC: 8:54 PM Local: 9:54 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 26, 9, 55, 0, false);          // UTC: 9:55 AM Local: 10:55 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 23, 18, 36, 0, false);         // UTC: 6:36 PM Local: 7:36 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 2, 14, 40, 0, false);          // UTC: 2:40 PM Local: 3:40 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 24, 13, 6, 0, false);          // UTC: 1:06 PM Local: 2:06 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 21, 11, 11, 0, false);         // UTC: 11:11 AM Local: 12:11 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 22, 12, 12, 0, false);         // UTC: 12:12 PM Local: 1:12 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 9, 1, 2, 0, false);            // UTC: 1:02 AM Local: 2:02 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 3, 18, 13, 0, false);          // UTC: 6:13 PM Local: 7:13 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 27, 13, 30, 0, false);         // UTC: 1:30 PM Local: 2:30 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 17, 5, 40, 0, false);          // UTC: 5:40 AM Local: 6:40 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 12, 2, 27, 0, false);          // UTC: 2:27 AM Local: 3:27 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 12, 20, 14, 0, false);         // UTC: 8:14 PM Local: 9:14 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 9, 16, 46, 0, false);          // UTC: 4:46 PM Local: 5:46 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 21, 19, 17, 0, false);         // UTC: 7:17 PM Local: 8:17 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 9, 3, 38, 0, false);           // UTC: 3:38 AM Local: 4:38 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 10, 22, 21, 0, false);         // UTC: 10:21 PM Local: 11:21 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 10, 22, 13, 39, 0, false);         // UTC: 1:39 PM Local: 2:39 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 16, 6, 47, 0, false);          // UTC: 6:47 AM Local: 7:47 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 24, 19, 34, 0, false);         // UTC: 7:34 PM Local: 8:34 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 20, 19, 12, 0, false);         // UTC: 7:12 PM Local: 8:12 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 3, 9, 23, 0, false);           // UTC: 9:23 AM Local: 10:23 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 27, 10, 28, 0, false);         // UTC: 10:28 AM Local: 11:28 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 18, 7, 37, 0, false);          // UTC: 7:37 AM Local: 8:37 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 26, 11, 48, 0, false);         // UTC: 11:48 AM Local: 12:48 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 12, 12, 12, 0, false);         // UTC: 12:12 PM Local: 1:12 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 21, 18, 38, 0, false);         // UTC: 6:38 PM Local: 7:38 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 16, 14, 36, 0, false);         // UTC: 2:36 PM Local: 3:36 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 5, 19, 37, 0, false);          // UTC: 7:37 PM Local: 8:37 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 1, 19, 48, 0, false);          // UTC: 7:48 PM Local: 8:48 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 19, 13, 2, 0, false);          // UTC: 1:02 PM Local: 2:02 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 18, 13, 50, 0, false);         // UTC: 1:50 PM Local: 2:50 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 16, 15, 26, 0, false);         // UTC: 3:26 PM Local: 4:26 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 25, 7, 41, 0, false);          // UTC: 7:41 AM Local: 8:41 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 5, 16, 38, 0, false);          // UTC: 4:38 PM Local: 5:38 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 20, 19, 6, 0, false);          // UTC: 7:06 PM Local: 8:06 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 23, 3, 42, 0, false);          // UTC: 3:42 AM Local: 4:42 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 17, 2, 1, 0, false);           // UTC: 2:01 AM Local: 3:01 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 25, 3, 12, 0, false);          // UTC: 3:12 AM Local: 4:12 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 17, 21, 34, 0, false);         // UTC: 9:34 PM Local: 10:34 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 21, 22, 36, 0, false);         // UTC: 10:36 PM Local: 11:36 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 19, 22, 43, 0, false);         // UTC: 10:43 PM Local: 11:43 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 11, 16, 6, 53, 0, false);          // UTC: 6:53 AM Local: 7:53 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 27, 19, 52, 0, false);         // UTC: 7:52 PM Local: 8:52 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 21, 19, 28, 0, false);         // UTC: 7:28 PM Local: 8:28 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 26, 9, 54, 0, false);          // UTC: 9:54 AM Local: 10:54 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 27, 9, 58, 0, false);          // UTC: 9:58 AM Local: 10:58 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 15, 4, 39, 0, false);          // UTC: 4:39 AM Local: 5:39 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 3, 1, 26, 0, false);           // UTC: 1:26 AM Local: 2:26 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 1, 16, 25, 0, false);          // UTC: 4:25 PM Local: 5:25 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 18, 22, 42, 0, false);         // UTC: 10:42 PM Local: 11:42 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 24, 2, 19, 0, false);          // UTC: 2:19 AM Local: 3:19 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 3, 11, 43, 0, false);          // UTC: 11:43 AM Local: 12:43 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 25, 3, 31, 0, false);          // UTC: 3:31 AM Local: 4:31 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 6, 20, 19, 0, false);          // UTC: 8:19 PM Local: 9:19 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 23, 19, 15, 0, false);         // UTC: 7:15 PM Local: 8:15 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 15, 22, 42, 0, false);         // UTC: 10:42 PM Local: 11:42 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 8, 14, 30, 0, false);          // UTC: 2:30 PM Local: 3:30 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 16, 5, 46, 0, false);          // UTC: 5:46 AM Local: 6:46 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 26, 13, 52, 0, false);         // UTC: 1:52 PM Local: 2:52 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 8, 13, 33, 0, false);          // UTC: 1:33 PM Local: 2:33 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 13, 7, 50, 0, false);          // UTC: 7:50 AM Local: 8:50 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 5, 20, 43, 0, false);          // UTC: 8:43 PM Local: 9:43 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 5, 20, 55, 0, false);          // UTC: 8:55 PM Local: 9:55 AM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 6, 1, 17, 0, false);           // UTC: 1:17 AM Local: 2:17 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 13, 7, 18, 0, false);          // UTC: 7:18 AM Local: 8:18 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 10, 5, 14, 0, false);          // UTC: 5:14 AM Local: 6:14 PM Offset: -11:00:00
	testCount++; failedCount += test(timeManager, 4, 2020, 12, 6, 10, 45, 0, false);          // UTC: 10:45 AM Local: 11:45 PM Offset: -11:00:00

	Serial.println(); Serial.print(failedCount); Serial.print(" of "); Serial.print(testCount); Serial.println(" test(s) failed.");
}
#endif
