#ifndef TEST_TIMEZONEID_3_H
#define TEST_TIMEZONEID_3_H

#include "TimeManager.h"
#include "TestHelper.h"

void run_TimeZoneId_3_Tests(const TimeManager& timeManager)
{
	uint16_t testCount = 0;
	uint16_t failedCount = 0;

	testCount++; failedCount += test(timeManager, 3, 2018, 1, 12, 0, 6, 0, false);            // UTC: 12:06 AM Local: 2:06 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 13, 15, 52, 0, false);          // UTC: 3:52 PM Local: 5:52 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 23, 3, 38, 0, false);           // UTC: 3:38 AM Local: 5:38 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 11, 9, 8, 0, false);            // UTC: 9:08 AM Local: 11:08 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 2, 14, 44, 0, false);           // UTC: 2:44 PM Local: 4:44 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 11, 7, 23, 0, false);           // UTC: 7:23 AM Local: 9:23 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 27, 20, 38, 0, false);          // UTC: 8:38 PM Local: 10:38 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 1, 13, 26, 0, false);           // UTC: 1:26 PM Local: 3:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 9, 9, 12, 0, false);            // UTC: 9:12 AM Local: 11:12 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 18, 2, 20, 0, false);           // UTC: 2:20 AM Local: 4:20 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 15, 3, 13, 0, false);           // UTC: 3:13 AM Local: 5:13 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 3, 19, 9, 0, false);            // UTC: 7:09 PM Local: 9:09 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 11, 20, 19, 0, false);          // UTC: 8:19 PM Local: 10:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 27, 16, 21, 0, false);          // UTC: 4:21 PM Local: 6:21 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 20, 9, 16, 0, false);           // UTC: 9:16 AM Local: 11:16 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 26, 16, 16, 0, false);          // UTC: 4:16 PM Local: 6:16 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 23, 4, 18, 0, false);           // UTC: 4:18 AM Local: 6:18 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 22, 5, 29, 0, false);           // UTC: 5:29 AM Local: 7:29 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 3, 9, 27, 0, false);            // UTC: 9:27 AM Local: 11:27 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 18, 3, 15, 0, false);           // UTC: 3:15 AM Local: 5:15 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 19, 3, 1, 0, false);            // UTC: 3:01 AM Local: 5:01 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 9, 19, 15, 0, false);           // UTC: 7:15 PM Local: 9:15 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 25, 22, 47, 0, false);          // UTC: 10:47 PM Local: 12:47 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 17, 0, 25, 0, false);           // UTC: 12:25 AM Local: 2:25 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 1, 2, 22, 10, 0, false);           // UTC: 10:10 PM Local: 12:10 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 8, 6, 8, 0, false);             // UTC: 6:08 AM Local: 8:08 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 5, 9, 39, 0, false);            // UTC: 9:39 AM Local: 11:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 26, 18, 55, 0, false);          // UTC: 6:55 PM Local: 8:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 1, 16, 52, 0, false);           // UTC: 4:52 PM Local: 6:52 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 20, 0, 25, 0, false);           // UTC: 12:25 AM Local: 2:25 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 19, 16, 44, 0, false);          // UTC: 4:44 PM Local: 6:44 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 2, 7, 33, 0, false);            // UTC: 7:33 AM Local: 9:33 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 10, 9, 34, 0, false);           // UTC: 9:34 AM Local: 11:34 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 1, 0, 43, 0, false);            // UTC: 12:43 AM Local: 2:43 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 13, 5, 9, 0, false);            // UTC: 5:09 AM Local: 7:09 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 24, 17, 15, 0, false);          // UTC: 5:15 PM Local: 7:15 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 9, 18, 6, 0, false);            // UTC: 6:06 PM Local: 8:06 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 9, 11, 43, 0, false);           // UTC: 11:43 AM Local: 1:43 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 16, 17, 20, 0, false);          // UTC: 5:20 PM Local: 7:20 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 3, 6, 7, 0, false);             // UTC: 6:07 AM Local: 8:07 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 11, 4, 57, 0, false);           // UTC: 4:57 AM Local: 6:57 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 10, 20, 17, 0, false);          // UTC: 8:17 PM Local: 10:17 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 19, 22, 39, 0, false);          // UTC: 10:39 PM Local: 12:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 17, 21, 50, 0, false);          // UTC: 9:50 PM Local: 11:50 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 16, 3, 23, 0, false);           // UTC: 3:23 AM Local: 5:23 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 26, 10, 33, 0, false);          // UTC: 10:33 AM Local: 12:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 21, 3, 57, 0, false);           // UTC: 3:57 AM Local: 5:57 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 17, 9, 12, 0, false);           // UTC: 9:12 AM Local: 11:12 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 9, 8, 12, 0, false);            // UTC: 8:12 AM Local: 10:12 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 2, 1, 11, 33, 0, false);           // UTC: 11:33 AM Local: 1:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 6, 6, 8, 0, false);             // UTC: 6:08 AM Local: 8:08 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 12, 15, 47, 0, false);          // UTC: 3:47 PM Local: 5:47 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 21, 2, 21, 0, false);           // UTC: 2:21 AM Local: 4:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 24, 4, 45, 0, false);           // UTC: 4:45 AM Local: 6:45 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 17, 16, 50, 0, false);          // UTC: 4:50 PM Local: 6:50 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 8, 17, 21, 0, false);           // UTC: 5:21 PM Local: 7:21 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 10, 15, 17, 0, false);          // UTC: 3:17 PM Local: 5:17 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 22, 7, 7, 0, false);            // UTC: 7:07 AM Local: 9:07 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 5, 17, 47, 0, false);           // UTC: 5:47 PM Local: 7:47 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 21, 0, 30, 0, false);           // UTC: 12:30 AM Local: 2:30 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 3, 15, 29, 0, false);           // UTC: 3:29 PM Local: 5:29 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 3, 9, 39, 0, false);            // UTC: 9:39 AM Local: 11:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 20, 2, 28, 0, false);           // UTC: 2:28 AM Local: 4:28 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 17, 3, 20, 0, false);           // UTC: 3:20 AM Local: 5:20 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 6, 20, 56, 0, false);           // UTC: 8:56 PM Local: 10:56 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 6, 0, 39, 0, false);            // UTC: 12:39 AM Local: 2:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 10, 1, 37, 0, false);           // UTC: 1:37 AM Local: 3:37 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 24, 15, 48, 0, false);          // UTC: 3:48 PM Local: 5:48 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 8, 9, 56, 0, false);            // UTC: 9:56 AM Local: 11:56 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 1, 6, 52, 0, false);            // UTC: 6:52 AM Local: 8:52 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 27, 22, 4, 0, false);           // UTC: 10:04 PM Local: 12:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 23, 18, 30, 0, false);          // UTC: 6:30 PM Local: 8:30 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 8, 11, 19, 0, false);           // UTC: 11:19 AM Local: 1:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 5, 12, 37, 0, false);           // UTC: 12:37 PM Local: 2:37 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 3, 24, 17, 28, 0, false);          // UTC: 5:28 PM Local: 7:28 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 26, 13, 23, 0, false);          // UTC: 1:23 PM Local: 3:23 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 5, 22, 44, 0, false);           // UTC: 10:44 PM Local: 12:44 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 4, 9, 57, 0, false);            // UTC: 9:57 AM Local: 11:57 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 24, 5, 0, 0, false);            // UTC: 5:00 AM Local: 7:00 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 19, 18, 57, 0, false);          // UTC: 6:57 PM Local: 8:57 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 20, 15, 49, 0, false);          // UTC: 3:49 PM Local: 5:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 16, 13, 10, 0, false);          // UTC: 1:10 PM Local: 3:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 8, 8, 6, 0, false);             // UTC: 8:06 AM Local: 10:06 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 13, 21, 30, 0, false);          // UTC: 9:30 PM Local: 11:30 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 10, 4, 29, 0, false);           // UTC: 4:29 AM Local: 6:29 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 27, 22, 53, 0, false);          // UTC: 10:53 PM Local: 12:53 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 9, 7, 49, 0, false);            // UTC: 7:49 AM Local: 9:49 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 16, 20, 18, 0, false);          // UTC: 8:18 PM Local: 10:18 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 4, 19, 34, 0, false);           // UTC: 7:34 PM Local: 9:34 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 3, 22, 33, 0, false);           // UTC: 10:33 PM Local: 12:33 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 14, 13, 39, 0, false);          // UTC: 1:39 PM Local: 3:39 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 10, 10, 52, 0, false);          // UTC: 10:52 AM Local: 12:52 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 22, 6, 9, 0, false);            // UTC: 6:09 AM Local: 8:09 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 9, 15, 13, 0, false);           // UTC: 3:13 PM Local: 5:13 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 8, 16, 1, 0, false);            // UTC: 4:01 PM Local: 6:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 7, 17, 12, 0, false);           // UTC: 5:12 PM Local: 7:12 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 13, 20, 14, 0, false);          // UTC: 8:14 PM Local: 10:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 3, 8, 29, 0, false);            // UTC: 8:29 AM Local: 10:29 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 4, 3, 47, 0, false);            // UTC: 3:47 AM Local: 5:47 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 4, 15, 10, 43, 0, false);          // UTC: 10:43 AM Local: 12:43 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 17, 3, 23, 0, false);           // UTC: 3:23 AM Local: 5:23 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 15, 21, 21, 0, false);          // UTC: 9:21 PM Local: 11:21 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 24, 22, 43, 0, false);          // UTC: 10:43 PM Local: 12:43 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 17, 4, 40, 0, false);           // UTC: 4:40 AM Local: 6:40 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 21, 0, 38, 0, false);           // UTC: 12:38 AM Local: 2:38 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 17, 6, 9, 0, false);            // UTC: 6:09 AM Local: 8:09 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 8, 21, 5, 0, false);            // UTC: 9:05 PM Local: 11:05 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 10, 14, 4, 0, false);           // UTC: 2:04 PM Local: 4:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 9, 9, 13, 0, false);            // UTC: 9:13 AM Local: 11:13 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 5, 5, 17, 0, false);            // UTC: 5:17 AM Local: 7:17 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 3, 6, 49, 0, false);            // UTC: 6:49 AM Local: 8:49 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 12, 16, 30, 0, false);          // UTC: 4:30 PM Local: 6:30 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 23, 17, 45, 0, false);          // UTC: 5:45 PM Local: 7:45 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 18, 8, 46, 0, false);           // UTC: 8:46 AM Local: 10:46 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 13, 19, 40, 0, false);          // UTC: 7:40 PM Local: 9:40 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 15, 7, 18, 0, false);           // UTC: 7:18 AM Local: 9:18 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 23, 11, 52, 0, false);          // UTC: 11:52 AM Local: 1:52 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 18, 5, 30, 0, false);           // UTC: 5:30 AM Local: 7:30 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 18, 5, 32, 0, false);           // UTC: 5:32 AM Local: 7:32 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 9, 4, 31, 0, false);            // UTC: 4:31 AM Local: 6:31 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 4, 15, 44, 0, false);           // UTC: 3:44 PM Local: 5:44 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 12, 12, 55, 0, false);          // UTC: 12:55 PM Local: 2:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 23, 7, 19, 0, false);           // UTC: 7:19 AM Local: 9:19 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 4, 18, 31, 0, false);           // UTC: 6:31 PM Local: 8:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 5, 11, 14, 32, 0, false);          // UTC: 2:32 PM Local: 4:32 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 9, 20, 45, 0, false);           // UTC: 8:45 PM Local: 10:45 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 11, 18, 3, 0, false);           // UTC: 6:03 PM Local: 8:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 25, 7, 42, 0, false);           // UTC: 7:42 AM Local: 9:42 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 12, 10, 1, 0, false);           // UTC: 10:01 AM Local: 12:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 9, 18, 27, 0, false);           // UTC: 6:27 PM Local: 8:27 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 27, 11, 31, 0, false);          // UTC: 11:31 AM Local: 1:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 7, 12, 40, 0, false);           // UTC: 12:40 PM Local: 2:40 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 1, 1, 18, 0, false);            // UTC: 1:18 AM Local: 3:18 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 21, 15, 1, 0, false);           // UTC: 3:01 PM Local: 5:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 27, 16, 42, 0, false);          // UTC: 4:42 PM Local: 6:42 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 10, 5, 35, 0, false);           // UTC: 5:35 AM Local: 7:35 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 27, 7, 20, 0, false);           // UTC: 7:20 AM Local: 9:20 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 21, 21, 25, 0, false);          // UTC: 9:25 PM Local: 11:25 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 13, 4, 21, 0, false);           // UTC: 4:21 AM Local: 6:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 1, 0, 5, 0, false);             // UTC: 12:05 AM Local: 2:05 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 25, 12, 31, 0, false);          // UTC: 12:31 PM Local: 2:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 24, 3, 16, 0, false);           // UTC: 3:16 AM Local: 5:16 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 1, 3, 4, 0, false);             // UTC: 3:04 AM Local: 5:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 24, 6, 49, 0, false);           // UTC: 6:49 AM Local: 8:49 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 13, 14, 5, 0, false);           // UTC: 2:05 PM Local: 4:05 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 2, 21, 36, 0, false);           // UTC: 9:36 PM Local: 11:36 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 27, 1, 11, 0, false);           // UTC: 1:11 AM Local: 3:11 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 12, 8, 26, 0, false);           // UTC: 8:26 AM Local: 10:26 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 4, 4, 33, 0, false);            // UTC: 4:33 AM Local: 6:33 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 6, 3, 17, 19, 0, false);           // UTC: 5:19 PM Local: 7:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 9, 0, 1, 0, false);             // UTC: 12:01 AM Local: 2:01 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 6, 19, 9, 0, false);            // UTC: 7:09 PM Local: 9:09 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 13, 2, 31, 0, false);           // UTC: 2:31 AM Local: 4:31 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 13, 8, 4, 0, false);            // UTC: 8:04 AM Local: 10:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 15, 2, 4, 0, false);            // UTC: 2:04 AM Local: 4:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 14, 7, 17, 0, false);           // UTC: 7:17 AM Local: 9:17 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 10, 9, 16, 0, false);           // UTC: 9:16 AM Local: 11:16 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 20, 0, 56, 0, false);           // UTC: 12:56 AM Local: 2:56 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 25, 10, 10, 0, false);          // UTC: 10:10 AM Local: 12:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 3, 17, 57, 0, false);           // UTC: 5:57 PM Local: 7:57 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 19, 20, 23, 0, false);          // UTC: 8:23 PM Local: 10:23 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 21, 12, 15, 0, false);          // UTC: 12:15 PM Local: 2:15 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 22, 5, 46, 0, false);           // UTC: 5:46 AM Local: 7:46 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 25, 13, 47, 0, false);          // UTC: 1:47 PM Local: 3:47 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 3, 12, 41, 0, false);           // UTC: 12:41 PM Local: 2:41 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 4, 20, 14, 0, false);           // UTC: 8:14 PM Local: 10:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 11, 14, 51, 0, false);          // UTC: 2:51 PM Local: 4:51 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 8, 17, 20, 0, false);           // UTC: 5:20 PM Local: 7:20 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 2, 13, 56, 0, false);           // UTC: 1:56 PM Local: 3:56 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 2, 7, 21, 0, false);            // UTC: 7:21 AM Local: 9:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 27, 8, 22, 0, false);           // UTC: 8:22 AM Local: 10:22 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 16, 17, 26, 0, false);          // UTC: 5:26 PM Local: 7:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 19, 17, 33, 0, false);          // UTC: 5:33 PM Local: 7:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 22, 15, 3, 0, false);           // UTC: 3:03 PM Local: 5:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 7, 14, 9, 50, 0, false);           // UTC: 9:50 AM Local: 11:50 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 13, 15, 29, 0, false);          // UTC: 3:29 PM Local: 5:29 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 8, 17, 33, 0, false);           // UTC: 5:33 PM Local: 7:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 26, 16, 7, 0, false);           // UTC: 4:07 PM Local: 6:07 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 3, 9, 8, 0, false);             // UTC: 9:08 AM Local: 11:08 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 2, 15, 55, 0, false);           // UTC: 3:55 PM Local: 5:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 9, 17, 55, 0, false);           // UTC: 5:55 PM Local: 7:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 12, 21, 10, 0, false);          // UTC: 9:10 PM Local: 11:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 12, 11, 46, 0, false);          // UTC: 11:46 AM Local: 1:46 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 7, 10, 7, 0, false);            // UTC: 10:07 AM Local: 12:07 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 18, 13, 54, 0, false);          // UTC: 1:54 PM Local: 3:54 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 22, 17, 19, 0, false);          // UTC: 5:19 PM Local: 7:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 14, 13, 54, 0, false);          // UTC: 1:54 PM Local: 3:54 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 13, 18, 31, 0, false);          // UTC: 6:31 PM Local: 8:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 22, 1, 38, 0, false);           // UTC: 1:38 AM Local: 3:38 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 7, 10, 20, 0, false);           // UTC: 10:20 AM Local: 12:20 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 9, 14, 4, 0, false);            // UTC: 2:04 PM Local: 4:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 18, 11, 55, 0, false);          // UTC: 11:55 AM Local: 1:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 4, 2, 28, 0, false);            // UTC: 2:28 AM Local: 4:28 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 19, 0, 9, 0, false);            // UTC: 12:09 AM Local: 2:09 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 20, 0, 19, 0, false);           // UTC: 12:19 AM Local: 2:19 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 12, 6, 9, 0, false);            // UTC: 6:09 AM Local: 8:09 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 6, 6, 39, 0, false);            // UTC: 6:39 AM Local: 8:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 23, 12, 6, 0, false);           // UTC: 12:06 PM Local: 2:06 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 1, 19, 55, 0, false);           // UTC: 7:55 PM Local: 9:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 8, 11, 14, 51, 0, false);          // UTC: 2:51 PM Local: 4:51 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 15, 4, 2, 0, false);            // UTC: 4:02 AM Local: 6:02 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 12, 21, 46, 0, false);          // UTC: 9:46 PM Local: 11:46 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 2, 0, 3, 0, false);             // UTC: 12:03 AM Local: 2:03 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 27, 15, 38, 0, false);          // UTC: 3:38 PM Local: 5:38 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 23, 18, 32, 0, false);          // UTC: 6:32 PM Local: 8:32 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 21, 17, 46, 0, false);          // UTC: 5:46 PM Local: 7:46 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 6, 8, 46, 0, false);            // UTC: 8:46 AM Local: 10:46 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 14, 1, 10, 0, false);           // UTC: 1:10 AM Local: 3:10 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 19, 11, 5, 0, false);           // UTC: 11:05 AM Local: 1:05 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 27, 14, 39, 0, false);          // UTC: 2:39 PM Local: 4:39 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 1, 16, 28, 0, false);           // UTC: 4:28 PM Local: 6:28 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 17, 3, 50, 0, false);           // UTC: 3:50 AM Local: 5:50 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 3, 6, 4, 0, false);             // UTC: 6:04 AM Local: 8:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 15, 8, 14, 0, false);           // UTC: 8:14 AM Local: 10:14 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 3, 4, 36, 0, false);            // UTC: 4:36 AM Local: 6:36 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 1, 22, 42, 0, false);           // UTC: 10:42 PM Local: 12:42 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 16, 5, 4, 0, false);            // UTC: 5:04 AM Local: 7:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 5, 4, 14, 0, false);            // UTC: 4:14 AM Local: 6:14 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 3, 0, 6, 0, false);             // UTC: 12:06 AM Local: 2:06 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 24, 17, 27, 0, false);          // UTC: 5:27 PM Local: 7:27 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 19, 1, 23, 0, false);           // UTC: 1:23 AM Local: 3:23 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 11, 22, 56, 0, false);          // UTC: 10:56 PM Local: 12:56 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 5, 5, 39, 0, false);            // UTC: 5:39 AM Local: 7:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 19, 15, 28, 0, false);          // UTC: 3:28 PM Local: 5:28 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 9, 20, 15, 57, 0, false);          // UTC: 3:57 PM Local: 5:57 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 15, 9, 50, 0, false);          // UTC: 9:50 AM Local: 11:50 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 16, 15, 29, 0, false);         // UTC: 3:29 PM Local: 5:29 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 11, 9, 23, 0, false);          // UTC: 9:23 AM Local: 11:23 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 16, 19, 31, 0, false);         // UTC: 7:31 PM Local: 9:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 7, 11, 7, 0, false);           // UTC: 11:07 AM Local: 1:07 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 20, 5, 30, 0, false);          // UTC: 5:30 AM Local: 7:30 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 17, 19, 17, 0, false);         // UTC: 7:17 PM Local: 9:17 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 23, 16, 12, 0, false);         // UTC: 4:12 PM Local: 6:12 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 18, 19, 43, 0, false);         // UTC: 7:43 PM Local: 9:43 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 2, 19, 33, 0, false);          // UTC: 7:33 PM Local: 9:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 17, 10, 31, 0, false);         // UTC: 10:31 AM Local: 12:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 8, 12, 36, 0, false);          // UTC: 12:36 PM Local: 2:36 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 8, 7, 5, 0, false);            // UTC: 7:05 AM Local: 9:05 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 26, 7, 39, 0, false);          // UTC: 7:39 AM Local: 9:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 1, 18, 8, 0, false);           // UTC: 6:08 PM Local: 8:08 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 12, 21, 41, 0, false);         // UTC: 9:41 PM Local: 11:41 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 15, 21, 25, 0, false);         // UTC: 9:25 PM Local: 11:25 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 27, 2, 47, 0, false);          // UTC: 2:47 AM Local: 4:47 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 19, 16, 41, 0, false);         // UTC: 4:41 PM Local: 6:41 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 18, 20, 49, 0, false);         // UTC: 8:49 PM Local: 10:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 21, 7, 32, 0, false);          // UTC: 7:32 AM Local: 9:32 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 23, 22, 24, 0, false);         // UTC: 10:24 PM Local: 12:24 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 27, 22, 57, 0, false);         // UTC: 10:57 PM Local: 12:57 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 14, 10, 54, 0, false);         // UTC: 10:54 AM Local: 12:54 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 10, 12, 14, 31, 0, false);         // UTC: 2:31 PM Local: 4:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 17, 19, 53, 0, false);         // UTC: 7:53 PM Local: 9:53 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 3, 5, 53, 0, false);           // UTC: 5:53 AM Local: 7:53 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 1, 11, 54, 0, false);          // UTC: 11:54 AM Local: 1:54 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 4, 14, 18, 0, false);          // UTC: 2:18 PM Local: 4:18 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 20, 13, 50, 0, false);         // UTC: 1:50 PM Local: 3:50 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 25, 14, 24, 0, false);         // UTC: 2:24 PM Local: 4:24 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 7, 4, 0, 0, false);            // UTC: 4:00 AM Local: 6:00 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 4, 4, 47, 0, false);           // UTC: 4:47 AM Local: 6:47 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 20, 10, 57, 0, false);         // UTC: 10:57 AM Local: 12:57 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 21, 0, 28, 0, false);          // UTC: 12:28 AM Local: 2:28 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 14, 12, 28, 0, false);         // UTC: 12:28 PM Local: 2:28 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 8, 1, 51, 0, false);           // UTC: 1:51 AM Local: 3:51 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 22, 12, 39, 0, false);         // UTC: 12:39 PM Local: 2:39 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 26, 16, 47, 0, false);         // UTC: 4:47 PM Local: 6:47 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 17, 16, 21, 0, false);         // UTC: 4:21 PM Local: 6:21 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 3, 6, 22, 0, false);           // UTC: 6:22 AM Local: 8:22 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 4, 13, 50, 0, false);          // UTC: 1:50 PM Local: 3:50 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 14, 3, 26, 0, false);          // UTC: 3:26 AM Local: 5:26 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 15, 11, 37, 0, false);         // UTC: 11:37 AM Local: 1:37 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 3, 7, 46, 0, false);           // UTC: 7:46 AM Local: 9:46 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 26, 6, 29, 0, false);          // UTC: 6:29 AM Local: 8:29 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 12, 14, 4, 0, false);          // UTC: 2:04 PM Local: 4:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 23, 10, 31, 0, false);         // UTC: 10:31 AM Local: 12:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 27, 2, 3, 0, false);           // UTC: 2:03 AM Local: 4:03 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 11, 21, 7, 27, 0, false);          // UTC: 7:27 AM Local: 9:27 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 6, 11, 28, 0, false);          // UTC: 11:28 AM Local: 1:28 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 13, 14, 10, 0, false);         // UTC: 2:10 PM Local: 4:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 16, 14, 24, 0, false);         // UTC: 2:24 PM Local: 4:24 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 17, 0, 22, 0, false);          // UTC: 12:22 AM Local: 2:22 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 2, 17, 33, 0, false);          // UTC: 5:33 PM Local: 7:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 7, 16, 13, 0, false);          // UTC: 4:13 PM Local: 6:13 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 24, 22, 26, 0, false);         // UTC: 10:26 PM Local: 12:26 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 9, 4, 4, 0, false);            // UTC: 4:04 AM Local: 6:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 8, 5, 48, 0, false);           // UTC: 5:48 AM Local: 7:48 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 23, 3, 29, 0, false);          // UTC: 3:29 AM Local: 5:29 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 22, 17, 50, 0, false);         // UTC: 5:50 PM Local: 7:50 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 27, 7, 58, 0, false);          // UTC: 7:58 AM Local: 9:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 5, 14, 40, 0, false);          // UTC: 2:40 PM Local: 4:40 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 17, 7, 39, 0, false);          // UTC: 7:39 AM Local: 9:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 3, 18, 35, 0, false);          // UTC: 6:35 PM Local: 8:35 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 19, 18, 41, 0, false);         // UTC: 6:41 PM Local: 8:41 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 26, 17, 22, 0, false);         // UTC: 5:22 PM Local: 7:22 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 23, 19, 18, 0, false);         // UTC: 7:18 PM Local: 9:18 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 1, 20, 19, 0, false);          // UTC: 8:19 PM Local: 10:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 11, 3, 23, 0, false);          // UTC: 3:23 AM Local: 5:23 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 10, 17, 28, 0, false);         // UTC: 5:28 PM Local: 7:28 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 25, 19, 14, 0, false);         // UTC: 7:14 PM Local: 9:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 15, 1, 24, 0, false);          // UTC: 1:24 AM Local: 3:24 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 16, 1, 4, 0, false);           // UTC: 1:04 AM Local: 3:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2018, 12, 15, 6, 38, 0, false);          // UTC: 6:38 AM Local: 8:38 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 22, 5, 21, 0, false);           // UTC: 5:21 AM Local: 7:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 13, 13, 26, 0, false);          // UTC: 1:26 PM Local: 3:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 4, 20, 22, 0, false);           // UTC: 8:22 PM Local: 10:22 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 4, 21, 52, 0, false);           // UTC: 9:52 PM Local: 11:52 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 15, 21, 26, 0, false);          // UTC: 9:26 PM Local: 11:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 18, 17, 27, 0, false);          // UTC: 5:27 PM Local: 7:27 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 9, 5, 35, 0, false);            // UTC: 5:35 AM Local: 7:35 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 5, 3, 58, 0, false);            // UTC: 3:58 AM Local: 5:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 10, 3, 43, 0, false);           // UTC: 3:43 AM Local: 5:43 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 8, 8, 39, 0, false);            // UTC: 8:39 AM Local: 10:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 9, 7, 35, 0, false);            // UTC: 7:35 AM Local: 9:35 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 18, 5, 38, 0, false);           // UTC: 5:38 AM Local: 7:38 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 26, 21, 34, 0, false);          // UTC: 9:34 PM Local: 11:34 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 26, 5, 49, 0, false);           // UTC: 5:49 AM Local: 7:49 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 3, 18, 51, 0, false);           // UTC: 6:51 PM Local: 8:51 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 10, 22, 6, 0, false);           // UTC: 10:06 PM Local: 12:06 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 27, 21, 19, 0, false);          // UTC: 9:19 PM Local: 11:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 17, 5, 0, 0, false);            // UTC: 5:00 AM Local: 7:00 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 2, 13, 3, 0, false);            // UTC: 1:03 PM Local: 3:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 11, 2, 24, 0, false);           // UTC: 2:24 AM Local: 4:24 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 20, 19, 31, 0, false);          // UTC: 7:31 PM Local: 9:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 20, 18, 37, 0, false);          // UTC: 6:37 PM Local: 8:37 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 8, 19, 41, 0, false);           // UTC: 7:41 PM Local: 9:41 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 22, 16, 48, 0, false);          // UTC: 4:48 PM Local: 6:48 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 1, 25, 8, 1, 0, false);            // UTC: 8:01 AM Local: 10:01 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 21, 1, 21, 0, false);           // UTC: 1:21 AM Local: 3:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 3, 0, 10, 0, false);            // UTC: 12:10 AM Local: 2:10 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 18, 7, 25, 0, false);           // UTC: 7:25 AM Local: 9:25 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 10, 15, 4, 0, false);           // UTC: 3:04 PM Local: 5:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 17, 14, 37, 0, false);          // UTC: 2:37 PM Local: 4:37 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 17, 13, 48, 0, false);          // UTC: 1:48 PM Local: 3:48 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 5, 5, 23, 0, false);            // UTC: 5:23 AM Local: 7:23 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 9, 9, 58, 0, false);            // UTC: 9:58 AM Local: 11:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 7, 1, 7, 0, false);             // UTC: 1:07 AM Local: 3:07 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 11, 4, 13, 0, false);           // UTC: 4:13 AM Local: 6:13 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 14, 16, 51, 0, false);          // UTC: 4:51 PM Local: 6:51 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 27, 6, 31, 0, false);           // UTC: 6:31 AM Local: 8:31 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 19, 6, 6, 0, false);            // UTC: 6:06 AM Local: 8:06 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 7, 1, 31, 0, false);            // UTC: 1:31 AM Local: 3:31 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 3, 8, 6, 0, false);             // UTC: 8:06 AM Local: 10:06 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 16, 16, 14, 0, false);          // UTC: 4:14 PM Local: 6:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 2, 4, 6, 0, false);             // UTC: 4:06 AM Local: 6:06 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 1, 16, 6, 0, false);            // UTC: 4:06 PM Local: 6:06 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 17, 10, 39, 0, false);          // UTC: 10:39 AM Local: 12:39 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 11, 20, 55, 0, false);          // UTC: 8:55 PM Local: 10:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 2, 5, 7, 0, false);             // UTC: 5:07 AM Local: 7:07 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 6, 19, 57, 0, false);           // UTC: 7:57 PM Local: 9:57 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 6, 14, 19, 0, false);           // UTC: 2:19 PM Local: 4:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 3, 20, 18, 0, false);           // UTC: 8:18 PM Local: 10:18 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 2, 19, 21, 10, 0, false);          // UTC: 9:10 PM Local: 11:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 24, 4, 2, 0, false);            // UTC: 4:02 AM Local: 6:02 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 24, 15, 21, 0, false);          // UTC: 3:21 PM Local: 5:21 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 24, 7, 58, 0, false);           // UTC: 7:58 AM Local: 9:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 3, 11, 58, 0, false);           // UTC: 11:58 AM Local: 1:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 21, 8, 49, 0, false);           // UTC: 8:49 AM Local: 10:49 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 24, 7, 23, 0, false);           // UTC: 7:23 AM Local: 9:23 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 5, 4, 48, 0, false);            // UTC: 4:48 AM Local: 6:48 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 11, 20, 29, 0, false);          // UTC: 8:29 PM Local: 10:29 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 4, 8, 4, 0, false);             // UTC: 8:04 AM Local: 10:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 25, 22, 17, 0, false);          // UTC: 10:17 PM Local: 12:17 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 22, 6, 48, 0, false);           // UTC: 6:48 AM Local: 8:48 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 26, 17, 13, 0, false);          // UTC: 5:13 PM Local: 7:13 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 18, 11, 11, 0, false);          // UTC: 11:11 AM Local: 1:11 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 16, 3, 54, 0, false);           // UTC: 3:54 AM Local: 5:54 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 4, 2, 20, 0, false);            // UTC: 2:20 AM Local: 4:20 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 27, 10, 15, 0, false);          // UTC: 10:15 AM Local: 12:15 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 14, 5, 34, 0, false);           // UTC: 5:34 AM Local: 7:34 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 25, 12, 42, 0, false);          // UTC: 12:42 PM Local: 2:42 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 10, 10, 19, 0, false);          // UTC: 10:19 AM Local: 12:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 15, 17, 19, 0, false);          // UTC: 5:19 PM Local: 7:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 8, 22, 20, 0, false);           // UTC: 10:20 PM Local: 12:20 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 19, 7, 12, 0, false);           // UTC: 7:12 AM Local: 9:12 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 5, 19, 35, 0, false);           // UTC: 7:35 PM Local: 9:35 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 17, 5, 48, 0, false);           // UTC: 5:48 AM Local: 7:48 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 3, 6, 13, 2, 0, false);            // UTC: 1:02 PM Local: 3:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 24, 6, 46, 0, false);           // UTC: 6:46 AM Local: 8:46 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 5, 3, 53, 0, false);            // UTC: 3:53 AM Local: 5:53 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 23, 9, 42, 0, false);           // UTC: 9:42 AM Local: 11:42 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 20, 20, 45, 0, false);          // UTC: 8:45 PM Local: 10:45 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 3, 13, 17, 0, false);           // UTC: 1:17 PM Local: 3:17 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 25, 2, 43, 0, false);           // UTC: 2:43 AM Local: 4:43 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 24, 6, 12, 0, false);           // UTC: 6:12 AM Local: 8:12 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 16, 9, 46, 0, false);           // UTC: 9:46 AM Local: 11:46 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 4, 18, 36, 0, false);           // UTC: 6:36 PM Local: 8:36 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 18, 20, 1, 0, false);           // UTC: 8:01 PM Local: 10:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 21, 16, 55, 0, false);          // UTC: 4:55 PM Local: 6:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 19, 10, 11, 0, false);          // UTC: 10:11 AM Local: 12:11 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 15, 8, 34, 0, false);           // UTC: 8:34 AM Local: 10:34 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 12, 10, 31, 0, false);          // UTC: 10:31 AM Local: 12:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 18, 22, 25, 0, false);          // UTC: 10:25 PM Local: 12:25 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 12, 1, 14, 0, false);           // UTC: 1:14 AM Local: 3:14 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 9, 16, 6, 0, false);            // UTC: 4:06 PM Local: 6:06 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 3, 7, 17, 0, false);            // UTC: 7:17 AM Local: 9:17 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 23, 7, 49, 0, false);           // UTC: 7:49 AM Local: 9:49 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 27, 0, 20, 0, false);           // UTC: 12:20 AM Local: 2:20 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 9, 3, 32, 0, false);            // UTC: 3:32 AM Local: 5:32 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 19, 21, 9, 0, false);           // UTC: 9:09 PM Local: 11:09 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 23, 9, 6, 0, false);            // UTC: 9:06 AM Local: 11:06 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 3, 8, 43, 0, false);            // UTC: 8:43 AM Local: 10:43 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 4, 5, 10, 48, 0, false);           // UTC: 10:48 AM Local: 12:48 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 19, 21, 25, 0, false);          // UTC: 9:25 PM Local: 11:25 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 10, 15, 42, 0, false);          // UTC: 3:42 PM Local: 5:42 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 10, 8, 10, 0, false);           // UTC: 8:10 AM Local: 10:10 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 25, 15, 22, 0, false);          // UTC: 3:22 PM Local: 5:22 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 18, 19, 9, 0, false);           // UTC: 7:09 PM Local: 9:09 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 10, 12, 20, 0, false);          // UTC: 12:20 PM Local: 2:20 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 7, 2, 18, 0, false);            // UTC: 2:18 AM Local: 4:18 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 27, 21, 2, 0, false);           // UTC: 9:02 PM Local: 11:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 8, 14, 38, 0, false);           // UTC: 2:38 PM Local: 4:38 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 5, 4, 20, 0, false);            // UTC: 4:20 AM Local: 6:20 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 11, 21, 52, 0, false);          // UTC: 9:52 PM Local: 11:52 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 13, 3, 21, 0, false);           // UTC: 3:21 AM Local: 5:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 11, 14, 20, 0, false);          // UTC: 2:20 PM Local: 4:20 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 17, 21, 46, 0, false);          // UTC: 9:46 PM Local: 11:46 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 11, 17, 16, 0, false);          // UTC: 5:16 PM Local: 7:16 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 22, 3, 34, 0, false);           // UTC: 3:34 AM Local: 5:34 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 26, 17, 47, 0, false);          // UTC: 5:47 PM Local: 7:47 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 11, 21, 20, 0, false);          // UTC: 9:20 PM Local: 11:20 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 14, 15, 58, 0, false);          // UTC: 3:58 PM Local: 5:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 11, 2, 3, 0, false);            // UTC: 2:03 AM Local: 4:03 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 2, 4, 9, 0, false);             // UTC: 4:09 AM Local: 6:09 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 23, 12, 43, 0, false);          // UTC: 12:43 PM Local: 2:43 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 14, 4, 40, 0, false);           // UTC: 4:40 AM Local: 6:40 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 22, 22, 54, 0, false);          // UTC: 10:54 PM Local: 12:54 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 5, 27, 13, 9, 0, false);           // UTC: 1:09 PM Local: 3:09 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 15, 14, 10, 0, false);          // UTC: 2:10 PM Local: 4:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 21, 11, 26, 0, false);          // UTC: 11:26 AM Local: 1:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 2, 4, 26, 0, false);            // UTC: 4:26 AM Local: 6:26 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 15, 22, 1, 0, false);           // UTC: 10:01 PM Local: 12:01 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 15, 21, 27, 0, false);          // UTC: 9:27 PM Local: 11:27 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 11, 0, 30, 0, false);           // UTC: 12:30 AM Local: 2:30 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 8, 12, 43, 0, false);           // UTC: 12:43 PM Local: 2:43 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 17, 12, 14, 0, false);          // UTC: 12:14 PM Local: 2:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 15, 6, 58, 0, false);           // UTC: 6:58 AM Local: 8:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 25, 3, 45, 0, false);           // UTC: 3:45 AM Local: 5:45 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 25, 9, 18, 0, false);           // UTC: 9:18 AM Local: 11:18 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 5, 22, 4, 0, false);            // UTC: 10:04 PM Local: 12:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 22, 14, 36, 0, false);          // UTC: 2:36 PM Local: 4:36 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 17, 0, 58, 0, false);           // UTC: 12:58 AM Local: 2:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 20, 6, 31, 0, false);           // UTC: 6:31 AM Local: 8:31 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 20, 21, 13, 0, false);          // UTC: 9:13 PM Local: 11:13 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 6, 9, 56, 0, false);            // UTC: 9:56 AM Local: 11:56 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 11, 16, 2, 0, false);           // UTC: 4:02 PM Local: 6:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 12, 20, 4, 0, false);           // UTC: 8:04 PM Local: 10:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 25, 4, 10, 0, false);           // UTC: 4:10 AM Local: 6:10 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 13, 3, 4, 0, false);            // UTC: 3:04 AM Local: 5:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 19, 14, 35, 0, false);          // UTC: 2:35 PM Local: 4:35 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 20, 8, 56, 0, false);           // UTC: 8:56 AM Local: 10:56 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 11, 13, 22, 0, false);          // UTC: 1:22 PM Local: 3:22 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 6, 25, 15, 32, 0, false);          // UTC: 3:32 PM Local: 5:32 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 21, 21, 14, 0, false);          // UTC: 9:14 PM Local: 11:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 20, 19, 20, 0, false);          // UTC: 7:20 PM Local: 9:20 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 21, 16, 43, 0, false);          // UTC: 4:43 PM Local: 6:43 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 23, 11, 39, 0, false);          // UTC: 11:39 AM Local: 1:39 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 7, 17, 5, 0, false);            // UTC: 5:05 PM Local: 7:05 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 1, 20, 24, 0, false);           // UTC: 8:24 PM Local: 10:24 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 12, 3, 50, 0, false);           // UTC: 3:50 AM Local: 5:50 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 25, 0, 38, 0, false);           // UTC: 12:38 AM Local: 2:38 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 26, 0, 33, 0, false);           // UTC: 12:33 AM Local: 2:33 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 8, 18, 49, 0, false);           // UTC: 6:49 PM Local: 8:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 16, 11, 3, 0, false);           // UTC: 11:03 AM Local: 1:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 14, 15, 57, 0, false);          // UTC: 3:57 PM Local: 5:57 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 23, 4, 22, 0, false);           // UTC: 4:22 AM Local: 6:22 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 23, 16, 26, 0, false);          // UTC: 4:26 PM Local: 6:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 10, 19, 9, 0, false);           // UTC: 7:09 PM Local: 9:09 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 26, 10, 37, 0, false);          // UTC: 10:37 AM Local: 12:37 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 24, 8, 39, 0, false);           // UTC: 8:39 AM Local: 10:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 27, 10, 30, 0, false);          // UTC: 10:30 AM Local: 12:30 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 19, 18, 51, 0, false);          // UTC: 6:51 PM Local: 8:51 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 17, 18, 49, 0, false);          // UTC: 6:49 PM Local: 8:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 22, 10, 51, 0, false);          // UTC: 10:51 AM Local: 12:51 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 25, 5, 58, 0, false);           // UTC: 5:58 AM Local: 7:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 17, 17, 3, 0, false);           // UTC: 5:03 PM Local: 7:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 4, 4, 41, 0, false);            // UTC: 4:41 AM Local: 6:41 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 7, 1, 14, 25, 0, false);           // UTC: 2:25 PM Local: 4:25 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 11, 13, 10, 0, false);          // UTC: 1:10 PM Local: 3:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 14, 0, 32, 0, false);           // UTC: 12:32 AM Local: 2:32 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 26, 9, 26, 0, false);           // UTC: 9:26 AM Local: 11:26 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 5, 13, 2, 0, false);            // UTC: 1:02 PM Local: 3:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 15, 18, 51, 0, false);          // UTC: 6:51 PM Local: 8:51 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 3, 5, 23, 0, false);            // UTC: 5:23 AM Local: 7:23 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 15, 1, 14, 0, false);           // UTC: 1:14 AM Local: 3:14 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 16, 10, 35, 0, false);          // UTC: 10:35 AM Local: 12:35 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 5, 7, 41, 0, false);            // UTC: 7:41 AM Local: 9:41 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 16, 16, 10, 0, false);          // UTC: 4:10 PM Local: 6:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 27, 21, 50, 0, false);          // UTC: 9:50 PM Local: 11:50 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 3, 6, 14, 0, false);            // UTC: 6:14 AM Local: 8:14 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 19, 2, 46, 0, false);           // UTC: 2:46 AM Local: 4:46 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 8, 19, 2, 0, false);            // UTC: 7:02 PM Local: 9:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 12, 16, 37, 0, false);          // UTC: 4:37 PM Local: 6:37 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 26, 1, 56, 0, false);           // UTC: 1:56 AM Local: 3:56 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 5, 0, 56, 0, false);            // UTC: 12:56 AM Local: 2:56 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 9, 11, 33, 0, false);           // UTC: 11:33 AM Local: 1:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 6, 18, 7, 0, false);            // UTC: 6:07 PM Local: 8:07 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 16, 7, 40, 0, false);           // UTC: 7:40 AM Local: 9:40 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 23, 8, 41, 0, false);           // UTC: 8:41 AM Local: 10:41 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 8, 4, 39, 0, false);            // UTC: 4:39 AM Local: 6:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 6, 10, 29, 0, false);           // UTC: 10:29 AM Local: 12:29 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 18, 9, 7, 0, false);            // UTC: 9:07 AM Local: 11:07 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 8, 17, 5, 11, 0, false);           // UTC: 5:11 AM Local: 7:11 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 6, 3, 42, 0, false);            // UTC: 3:42 AM Local: 5:42 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 27, 4, 14, 0, false);           // UTC: 4:14 AM Local: 6:14 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 21, 9, 41, 0, false);           // UTC: 9:41 AM Local: 11:41 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 6, 15, 25, 0, false);           // UTC: 3:25 PM Local: 5:25 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 8, 20, 28, 0, false);           // UTC: 8:28 PM Local: 10:28 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 3, 2, 45, 0, false);            // UTC: 2:45 AM Local: 4:45 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 3, 10, 29, 0, false);           // UTC: 10:29 AM Local: 12:29 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 10, 3, 31, 0, false);           // UTC: 3:31 AM Local: 5:31 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 27, 17, 36, 0, false);          // UTC: 5:36 PM Local: 7:36 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 13, 12, 36, 0, false);          // UTC: 12:36 PM Local: 2:36 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 23, 15, 14, 0, false);          // UTC: 3:14 PM Local: 5:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 11, 22, 39, 0, false);          // UTC: 10:39 PM Local: 12:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 11, 14, 7, 0, false);           // UTC: 2:07 PM Local: 4:07 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 12, 2, 55, 0, false);           // UTC: 2:55 AM Local: 4:55 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 27, 1, 30, 0, false);           // UTC: 1:30 AM Local: 3:30 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 7, 20, 32, 0, false);           // UTC: 8:32 PM Local: 10:32 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 1, 12, 17, 0, false);           // UTC: 12:17 PM Local: 2:17 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 10, 11, 48, 0, false);          // UTC: 11:48 AM Local: 1:48 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 19, 19, 58, 0, false);          // UTC: 7:58 PM Local: 9:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 6, 22, 26, 0, false);           // UTC: 10:26 PM Local: 12:26 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 17, 6, 50, 0, false);           // UTC: 6:50 AM Local: 8:50 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 3, 8, 58, 0, false);            // UTC: 8:58 AM Local: 10:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 6, 21, 54, 0, false);           // UTC: 9:54 PM Local: 11:54 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 23, 16, 29, 0, false);          // UTC: 4:29 PM Local: 6:29 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 9, 18, 15, 19, 0, false);          // UTC: 3:19 PM Local: 5:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 16, 8, 7, 0, false);           // UTC: 8:07 AM Local: 10:07 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 1, 16, 51, 0, false);          // UTC: 4:51 PM Local: 6:51 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 2, 9, 1, 0, false);            // UTC: 9:01 AM Local: 11:01 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 9, 10, 10, 0, false);          // UTC: 10:10 AM Local: 12:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 12, 15, 8, 0, false);          // UTC: 3:08 PM Local: 5:08 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 19, 4, 36, 0, false);          // UTC: 4:36 AM Local: 6:36 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 19, 18, 47, 0, false);         // UTC: 6:47 PM Local: 8:47 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 3, 20, 39, 0, false);          // UTC: 8:39 PM Local: 10:39 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 15, 0, 57, 0, false);          // UTC: 12:57 AM Local: 2:57 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 18, 4, 48, 0, false);          // UTC: 4:48 AM Local: 6:48 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 22, 16, 49, 0, false);         // UTC: 4:49 PM Local: 6:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 14, 3, 28, 0, false);          // UTC: 3:28 AM Local: 5:28 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 24, 4, 15, 0, false);          // UTC: 4:15 AM Local: 6:15 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 16, 12, 51, 0, false);         // UTC: 12:51 PM Local: 2:51 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 23, 17, 53, 0, false);         // UTC: 5:53 PM Local: 7:53 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 22, 18, 13, 0, false);         // UTC: 6:13 PM Local: 8:13 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 22, 3, 28, 0, false);          // UTC: 3:28 AM Local: 5:28 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 24, 21, 49, 0, false);         // UTC: 9:49 PM Local: 11:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 15, 10, 26, 0, false);         // UTC: 10:26 AM Local: 12:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 13, 11, 41, 0, false);         // UTC: 11:41 AM Local: 1:41 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 24, 10, 13, 0, false);         // UTC: 10:13 AM Local: 12:13 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 6, 12, 44, 0, false);          // UTC: 12:44 PM Local: 2:44 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 10, 21, 32, 0, false);         // UTC: 9:32 PM Local: 11:32 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 18, 18, 1, 0, false);          // UTC: 6:01 PM Local: 8:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 10, 10, 2, 16, 0, false);          // UTC: 2:16 AM Local: 4:16 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 26, 6, 8, 0, false);           // UTC: 6:08 AM Local: 8:08 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 21, 16, 14, 0, false);         // UTC: 4:14 PM Local: 6:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 21, 19, 3, 0, false);          // UTC: 7:03 PM Local: 9:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 10, 21, 45, 0, false);         // UTC: 9:45 PM Local: 11:45 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 27, 22, 39, 0, false);         // UTC: 10:39 PM Local: 12:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 2, 9, 40, 0, false);           // UTC: 9:40 AM Local: 11:40 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 16, 15, 6, 0, false);          // UTC: 3:06 PM Local: 5:06 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 18, 14, 12, 0, false);         // UTC: 2:12 PM Local: 4:12 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 5, 10, 50, 0, false);          // UTC: 10:50 AM Local: 12:50 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 19, 2, 19, 0, false);          // UTC: 2:19 AM Local: 4:19 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 13, 12, 49, 0, false);         // UTC: 12:49 PM Local: 2:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 16, 13, 10, 0, false);         // UTC: 1:10 PM Local: 3:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 9, 16, 45, 0, false);          // UTC: 4:45 PM Local: 6:45 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 13, 3, 34, 0, false);          // UTC: 3:34 AM Local: 5:34 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 5, 19, 36, 0, false);          // UTC: 7:36 PM Local: 9:36 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 27, 7, 57, 0, false);          // UTC: 7:57 AM Local: 9:57 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 24, 14, 23, 0, false);         // UTC: 2:23 PM Local: 4:23 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 10, 18, 24, 0, false);         // UTC: 6:24 PM Local: 8:24 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 5, 6, 38, 0, false);           // UTC: 6:38 AM Local: 8:38 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 26, 13, 14, 0, false);         // UTC: 1:14 PM Local: 3:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 11, 1, 42, 0, false);          // UTC: 1:42 AM Local: 3:42 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 20, 20, 22, 0, false);         // UTC: 8:22 PM Local: 10:22 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 25, 9, 21, 0, false);          // UTC: 9:21 AM Local: 11:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 14, 16, 41, 0, false);         // UTC: 4:41 PM Local: 6:41 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 11, 25, 2, 32, 0, false);          // UTC: 2:32 AM Local: 4:32 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 14, 11, 45, 0, false);         // UTC: 11:45 AM Local: 1:45 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 17, 3, 6, 0, false);           // UTC: 3:06 AM Local: 5:06 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 24, 18, 30, 0, false);         // UTC: 6:30 PM Local: 8:30 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 25, 2, 43, 0, false);          // UTC: 2:43 AM Local: 4:43 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 12, 9, 18, 0, false);          // UTC: 9:18 AM Local: 11:18 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 15, 8, 5, 0, false);           // UTC: 8:05 AM Local: 10:05 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 15, 1, 3, 0, false);           // UTC: 1:03 AM Local: 3:03 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 24, 9, 58, 0, false);          // UTC: 9:58 AM Local: 11:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 7, 1, 54, 0, false);           // UTC: 1:54 AM Local: 3:54 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 17, 8, 51, 0, false);          // UTC: 8:51 AM Local: 10:51 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 19, 9, 39, 0, false);          // UTC: 9:39 AM Local: 11:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 24, 14, 46, 0, false);         // UTC: 2:46 PM Local: 4:46 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 24, 7, 26, 0, false);          // UTC: 7:26 AM Local: 9:26 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 4, 11, 15, 0, false);          // UTC: 11:15 AM Local: 1:15 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 6, 18, 43, 0, false);          // UTC: 6:43 PM Local: 8:43 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 18, 11, 1, 0, false);          // UTC: 11:01 AM Local: 1:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 2, 21, 22, 0, false);          // UTC: 9:22 PM Local: 11:22 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 17, 8, 3, 0, false);           // UTC: 8:03 AM Local: 10:03 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 14, 14, 4, 0, false);          // UTC: 2:04 PM Local: 4:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 22, 8, 5, 0, false);           // UTC: 8:05 AM Local: 10:05 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 6, 6, 24, 0, false);           // UTC: 6:24 AM Local: 8:24 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 18, 5, 41, 0, false);          // UTC: 5:41 AM Local: 7:41 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 3, 12, 44, 0, false);          // UTC: 12:44 PM Local: 2:44 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 14, 15, 1, 0, false);          // UTC: 3:01 PM Local: 5:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2019, 12, 18, 8, 31, 0, false);          // UTC: 8:31 AM Local: 10:31 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 22, 15, 35, 0, false);          // UTC: 3:35 PM Local: 5:35 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 7, 13, 33, 0, false);           // UTC: 1:33 PM Local: 3:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 25, 12, 25, 0, false);          // UTC: 12:25 PM Local: 2:25 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 14, 1, 2, 0, false);            // UTC: 1:02 AM Local: 3:02 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 17, 8, 58, 0, false);           // UTC: 8:58 AM Local: 10:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 20, 2, 57, 0, false);           // UTC: 2:57 AM Local: 4:57 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 10, 21, 14, 0, false);          // UTC: 9:14 PM Local: 11:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 24, 12, 34, 0, false);          // UTC: 12:34 PM Local: 2:34 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 1, 12, 55, 0, false);           // UTC: 12:55 PM Local: 2:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 8, 12, 17, 0, false);           // UTC: 12:17 PM Local: 2:17 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 10, 22, 58, 0, false);          // UTC: 10:58 PM Local: 12:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 15, 15, 58, 0, false);          // UTC: 3:58 PM Local: 5:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 13, 12, 45, 0, false);          // UTC: 12:45 PM Local: 2:45 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 15, 7, 42, 0, false);           // UTC: 7:42 AM Local: 9:42 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 27, 3, 9, 0, false);            // UTC: 3:09 AM Local: 5:09 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 18, 11, 10, 0, false);          // UTC: 11:10 AM Local: 1:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 21, 18, 32, 0, false);          // UTC: 6:32 PM Local: 8:32 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 2, 6, 26, 0, false);            // UTC: 6:26 AM Local: 8:26 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 9, 21, 6, 0, false);            // UTC: 9:06 PM Local: 11:06 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 1, 4, 1, 0, false);             // UTC: 4:01 AM Local: 6:01 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 18, 14, 1, 0, false);           // UTC: 2:01 PM Local: 4:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 4, 3, 5, 0, false);             // UTC: 3:05 AM Local: 5:05 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 2, 1, 40, 0, false);            // UTC: 1:40 AM Local: 3:40 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 1, 6, 33, 0, false);            // UTC: 6:33 AM Local: 8:33 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 1, 6, 19, 37, 0, false);           // UTC: 7:37 PM Local: 9:37 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 14, 20, 23, 0, false);          // UTC: 8:23 PM Local: 10:23 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 12, 8, 4, 0, false);            // UTC: 8:04 AM Local: 10:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 21, 12, 43, 0, false);          // UTC: 12:43 PM Local: 2:43 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 20, 6, 40, 0, false);           // UTC: 6:40 AM Local: 8:40 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 15, 5, 43, 0, false);           // UTC: 5:43 AM Local: 7:43 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 24, 10, 18, 0, false);          // UTC: 10:18 AM Local: 12:18 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 21, 20, 40, 0, false);          // UTC: 8:40 PM Local: 10:40 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 20, 19, 58, 0, false);          // UTC: 7:58 PM Local: 9:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 2, 14, 24, 0, false);           // UTC: 2:24 PM Local: 4:24 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 14, 17, 31, 0, false);          // UTC: 5:31 PM Local: 7:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 27, 20, 26, 0, false);          // UTC: 8:26 PM Local: 10:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 23, 17, 3, 0, false);           // UTC: 5:03 PM Local: 7:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 20, 13, 49, 0, false);          // UTC: 1:49 PM Local: 3:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 26, 20, 5, 0, false);           // UTC: 8:05 PM Local: 10:05 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 8, 9, 51, 0, false);            // UTC: 9:51 AM Local: 11:51 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 11, 11, 49, 0, false);          // UTC: 11:49 AM Local: 1:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 26, 3, 48, 0, false);           // UTC: 3:48 AM Local: 5:48 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 7, 10, 55, 0, false);           // UTC: 10:55 AM Local: 12:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 26, 18, 3, 0, false);           // UTC: 6:03 PM Local: 8:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 12, 8, 44, 0, false);           // UTC: 8:44 AM Local: 10:44 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 18, 5, 46, 0, false);           // UTC: 5:46 AM Local: 7:46 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 6, 17, 24, 0, false);           // UTC: 5:24 PM Local: 7:24 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 7, 16, 26, 0, false);           // UTC: 4:26 PM Local: 6:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 19, 4, 49, 0, false);           // UTC: 4:49 AM Local: 6:49 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 2, 14, 18, 0, 0, false);           // UTC: 6:00 PM Local: 8:00 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 17, 9, 25, 0, false);           // UTC: 9:25 AM Local: 11:25 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 4, 15, 7, 0, false);            // UTC: 3:07 PM Local: 5:07 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 16, 12, 36, 0, false);          // UTC: 12:36 PM Local: 2:36 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 19, 17, 25, 0, false);          // UTC: 5:25 PM Local: 7:25 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 14, 20, 56, 0, false);          // UTC: 8:56 PM Local: 10:56 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 1, 6, 14, 0, false);            // UTC: 6:14 AM Local: 8:14 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 3, 6, 37, 0, false);            // UTC: 6:37 AM Local: 8:37 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 9, 1, 39, 0, false);            // UTC: 1:39 AM Local: 3:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 13, 3, 44, 0, false);           // UTC: 3:44 AM Local: 5:44 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 11, 5, 56, 0, false);           // UTC: 5:56 AM Local: 7:56 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 27, 17, 37, 0, false);          // UTC: 5:37 PM Local: 7:37 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 26, 7, 22, 0, false);           // UTC: 7:22 AM Local: 9:22 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 18, 6, 40, 0, false);           // UTC: 6:40 AM Local: 8:40 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 17, 2, 41, 0, false);           // UTC: 2:41 AM Local: 4:41 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 5, 11, 58, 0, false);           // UTC: 11:58 AM Local: 1:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 27, 17, 50, 0, false);          // UTC: 5:50 PM Local: 7:50 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 14, 15, 51, 0, false);          // UTC: 3:51 PM Local: 5:51 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 17, 9, 30, 0, false);           // UTC: 9:30 AM Local: 11:30 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 11, 6, 21, 0, false);           // UTC: 6:21 AM Local: 8:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 21, 14, 30, 0, false);          // UTC: 2:30 PM Local: 4:30 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 10, 4, 17, 0, false);           // UTC: 4:17 AM Local: 6:17 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 18, 16, 58, 0, false);          // UTC: 4:58 PM Local: 6:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 22, 12, 31, 0, false);          // UTC: 12:31 PM Local: 2:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 16, 8, 58, 0, false);           // UTC: 8:58 AM Local: 10:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 3, 15, 10, 11, 0, false);          // UTC: 10:11 AM Local: 12:11 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 26, 3, 32, 0, false);           // UTC: 3:32 AM Local: 5:32 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 18, 11, 24, 0, false);          // UTC: 11:24 AM Local: 1:24 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 25, 20, 33, 0, false);          // UTC: 8:33 PM Local: 10:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 3, 8, 21, 0, false);            // UTC: 8:21 AM Local: 10:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 4, 13, 3, 0, false);            // UTC: 1:03 PM Local: 3:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 1, 19, 38, 0, false);           // UTC: 7:38 PM Local: 9:38 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 5, 6, 53, 0, false);            // UTC: 6:53 AM Local: 8:53 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 11, 11, 46, 0, false);          // UTC: 11:46 AM Local: 1:46 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 1, 4, 11, 0, false);            // UTC: 4:11 AM Local: 6:11 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 9, 20, 18, 0, false);           // UTC: 8:18 PM Local: 10:18 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 24, 1, 54, 0, false);           // UTC: 1:54 AM Local: 3:54 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 9, 10, 8, 0, false);            // UTC: 10:08 AM Local: 12:08 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 22, 2, 9, 0, false);            // UTC: 2:09 AM Local: 4:09 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 3, 10, 17, 0, false);           // UTC: 10:17 AM Local: 12:17 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 20, 13, 19, 0, false);          // UTC: 1:19 PM Local: 3:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 17, 15, 58, 0, false);          // UTC: 3:58 PM Local: 5:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 13, 12, 29, 0, false);          // UTC: 12:29 PM Local: 2:29 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 10, 8, 11, 0, false);           // UTC: 8:11 AM Local: 10:11 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 8, 12, 37, 0, false);           // UTC: 12:37 PM Local: 2:37 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 21, 15, 17, 0, false);          // UTC: 3:17 PM Local: 5:17 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 6, 13, 58, 0, false);           // UTC: 1:58 PM Local: 3:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 8, 4, 20, 0, false);            // UTC: 4:20 AM Local: 6:20 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 12, 18, 7, 0, false);           // UTC: 6:07 PM Local: 8:07 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 25, 4, 45, 0, false);           // UTC: 4:45 AM Local: 6:45 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 4, 14, 1, 47, 0, false);           // UTC: 1:47 AM Local: 3:47 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 17, 15, 54, 0, false);          // UTC: 3:54 PM Local: 5:54 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 13, 9, 31, 0, false);           // UTC: 9:31 AM Local: 11:31 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 6, 19, 20, 0, false);           // UTC: 7:20 PM Local: 9:20 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 22, 12, 39, 0, false);          // UTC: 12:39 PM Local: 2:39 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 20, 0, 53, 0, false);           // UTC: 12:53 AM Local: 2:53 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 14, 1, 26, 0, false);           // UTC: 1:26 AM Local: 3:26 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 24, 20, 52, 0, false);          // UTC: 8:52 PM Local: 10:52 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 9, 10, 22, 0, false);           // UTC: 10:22 AM Local: 12:22 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 27, 4, 50, 0, false);           // UTC: 4:50 AM Local: 6:50 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 24, 13, 20, 0, false);          // UTC: 1:20 PM Local: 3:20 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 20, 19, 18, 0, false);          // UTC: 7:18 PM Local: 9:18 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 11, 15, 50, 0, false);          // UTC: 3:50 PM Local: 5:50 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 19, 6, 15, 0, false);           // UTC: 6:15 AM Local: 8:15 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 21, 0, 42, 0, false);           // UTC: 12:42 AM Local: 2:42 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 18, 10, 39, 0, false);          // UTC: 10:39 AM Local: 12:39 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 19, 16, 45, 0, false);          // UTC: 4:45 PM Local: 6:45 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 6, 9, 9, 0, false);             // UTC: 9:09 AM Local: 11:09 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 9, 14, 10, 0, false);           // UTC: 2:10 PM Local: 4:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 25, 7, 12, 0, false);           // UTC: 7:12 AM Local: 9:12 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 15, 11, 12, 0, false);          // UTC: 11:12 AM Local: 1:12 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 19, 7, 16, 0, false);           // UTC: 7:16 AM Local: 9:16 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 1, 1, 39, 0, false);            // UTC: 1:39 AM Local: 3:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 10, 7, 20, 0, false);           // UTC: 7:20 AM Local: 9:20 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 2, 18, 44, 0, false);           // UTC: 6:44 PM Local: 8:44 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 5, 5, 2, 51, 0, false);            // UTC: 2:51 AM Local: 4:51 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 5, 15, 0, 0, false);            // UTC: 3:00 PM Local: 5:00 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 20, 6, 27, 0, false);           // UTC: 6:27 AM Local: 8:27 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 3, 14, 10, 0, false);           // UTC: 2:10 PM Local: 4:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 5, 9, 14, 0, false);            // UTC: 9:14 AM Local: 11:14 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 4, 11, 22, 0, false);           // UTC: 11:22 AM Local: 1:22 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 18, 3, 47, 0, false);           // UTC: 3:47 AM Local: 5:47 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 2, 1, 39, 0, false);            // UTC: 1:39 AM Local: 3:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 13, 14, 21, 0, false);          // UTC: 2:21 PM Local: 4:21 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 1, 7, 21, 0, false);            // UTC: 7:21 AM Local: 9:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 12, 3, 34, 0, false);           // UTC: 3:34 AM Local: 5:34 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 12, 3, 29, 0, false);           // UTC: 3:29 AM Local: 5:29 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 9, 17, 38, 0, false);           // UTC: 5:38 PM Local: 7:38 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 6, 19, 11, 0, false);           // UTC: 7:11 PM Local: 9:11 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 21, 13, 40, 0, false);          // UTC: 1:40 PM Local: 3:40 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 3, 19, 40, 0, false);           // UTC: 7:40 PM Local: 9:40 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 12, 5, 50, 0, false);           // UTC: 5:50 AM Local: 7:50 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 27, 9, 38, 0, false);           // UTC: 9:38 AM Local: 11:38 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 26, 3, 3, 0, false);            // UTC: 3:03 AM Local: 5:03 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 6, 16, 1, 0, false);            // UTC: 4:01 PM Local: 6:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 18, 16, 57, 0, false);          // UTC: 4:57 PM Local: 6:57 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 3, 15, 29, 0, false);           // UTC: 3:29 PM Local: 5:29 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 16, 17, 14, 0, false);          // UTC: 5:14 PM Local: 7:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 21, 18, 42, 0, false);          // UTC: 6:42 PM Local: 8:42 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 20, 10, 18, 0, false);          // UTC: 10:18 AM Local: 12:18 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 6, 17, 6, 27, 0, false);           // UTC: 6:27 AM Local: 8:27 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 27, 8, 46, 0, false);           // UTC: 8:46 AM Local: 10:46 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 19, 13, 4, 0, false);           // UTC: 1:04 PM Local: 3:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 14, 10, 43, 0, false);          // UTC: 10:43 AM Local: 12:43 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 26, 10, 1, 0, false);           // UTC: 10:01 AM Local: 12:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 12, 2, 3, 0, false);            // UTC: 2:03 AM Local: 4:03 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 17, 12, 7, 0, false);           // UTC: 12:07 PM Local: 2:07 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 6, 14, 55, 0, false);           // UTC: 2:55 PM Local: 4:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 6, 11, 4, 0, false);            // UTC: 11:04 AM Local: 1:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 12, 15, 25, 0, false);          // UTC: 3:25 PM Local: 5:25 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 4, 5, 57, 0, false);            // UTC: 5:57 AM Local: 7:57 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 10, 7, 49, 0, false);           // UTC: 7:49 AM Local: 9:49 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 16, 4, 21, 0, false);           // UTC: 4:21 AM Local: 6:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 7, 22, 7, 0, false);            // UTC: 10:07 PM Local: 12:07 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 25, 13, 12, 0, false);          // UTC: 1:12 PM Local: 3:12 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 21, 15, 16, 0, false);          // UTC: 3:16 PM Local: 5:16 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 7, 7, 40, 0, false);            // UTC: 7:40 AM Local: 9:40 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 18, 2, 52, 0, false);           // UTC: 2:52 AM Local: 4:52 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 6, 9, 39, 0, false);            // UTC: 9:39 AM Local: 11:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 15, 18, 49, 0, false);          // UTC: 6:49 PM Local: 8:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 19, 5, 54, 0, false);           // UTC: 5:54 AM Local: 7:54 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 18, 8, 12, 0, false);           // UTC: 8:12 AM Local: 10:12 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 21, 13, 8, 0, false);           // UTC: 1:08 PM Local: 3:08 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 6, 19, 53, 0, false);           // UTC: 7:53 PM Local: 9:53 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 19, 8, 35, 0, false);           // UTC: 8:35 AM Local: 10:35 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 7, 27, 7, 2, 0, false);            // UTC: 7:02 AM Local: 9:02 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 20, 10, 50, 0, false);          // UTC: 10:50 AM Local: 12:50 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 22, 4, 21, 0, false);           // UTC: 4:21 AM Local: 6:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 20, 11, 7, 0, false);           // UTC: 11:07 AM Local: 1:07 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 3, 3, 54, 0, false);            // UTC: 3:54 AM Local: 5:54 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 5, 1, 25, 0, false);            // UTC: 1:25 AM Local: 3:25 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 15, 12, 41, 0, false);          // UTC: 12:41 PM Local: 2:41 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 6, 5, 12, 0, false);            // UTC: 5:12 AM Local: 7:12 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 27, 0, 4, 0, false);            // UTC: 12:04 AM Local: 2:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 4, 0, 26, 0, false);            // UTC: 12:26 AM Local: 2:26 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 22, 22, 43, 0, false);          // UTC: 10:43 PM Local: 12:43 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 8, 4, 5, 0, false);             // UTC: 4:05 AM Local: 6:05 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 17, 18, 20, 0, false);          // UTC: 6:20 PM Local: 8:20 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 27, 20, 2, 0, false);           // UTC: 8:02 PM Local: 10:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 16, 21, 52, 0, false);          // UTC: 9:52 PM Local: 11:52 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 3, 15, 26, 0, false);           // UTC: 3:26 PM Local: 5:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 6, 0, 47, 0, false);            // UTC: 12:47 AM Local: 2:47 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 14, 4, 48, 0, false);           // UTC: 4:48 AM Local: 6:48 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 24, 18, 3, 0, false);           // UTC: 6:03 PM Local: 8:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 23, 16, 25, 0, false);          // UTC: 4:25 PM Local: 6:25 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 22, 15, 9, 0, false);           // UTC: 3:09 PM Local: 5:09 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 25, 21, 30, 0, false);          // UTC: 9:30 PM Local: 11:30 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 11, 18, 54, 0, false);          // UTC: 6:54 PM Local: 8:54 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 23, 12, 14, 0, false);          // UTC: 12:14 PM Local: 2:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 3, 12, 37, 0, false);           // UTC: 12:37 PM Local: 2:37 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 8, 18, 14, 20, 0, false);          // UTC: 2:20 PM Local: 4:20 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 9, 21, 19, 0, false);           // UTC: 9:19 PM Local: 11:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 17, 21, 1, 0, false);           // UTC: 9:01 PM Local: 11:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 18, 6, 46, 0, false);           // UTC: 6:46 AM Local: 8:46 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 25, 9, 24, 0, false);           // UTC: 9:24 AM Local: 11:24 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 2, 18, 4, 0, false);            // UTC: 6:04 PM Local: 8:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 25, 4, 14, 0, false);           // UTC: 4:14 AM Local: 6:14 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 24, 14, 57, 0, false);          // UTC: 2:57 PM Local: 4:57 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 11, 15, 51, 0, false);          // UTC: 3:51 PM Local: 5:51 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 15, 9, 27, 0, false);           // UTC: 9:27 AM Local: 11:27 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 16, 9, 37, 0, false);           // UTC: 9:37 AM Local: 11:37 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 6, 5, 7, 0, false);             // UTC: 5:07 AM Local: 7:07 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 20, 11, 47, 0, false);          // UTC: 11:47 AM Local: 1:47 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 3, 4, 42, 0, false);            // UTC: 4:42 AM Local: 6:42 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 5, 6, 38, 0, false);            // UTC: 6:38 AM Local: 8:38 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 20, 11, 23, 0, false);          // UTC: 11:23 AM Local: 1:23 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 14, 17, 44, 0, false);          // UTC: 5:44 PM Local: 7:44 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 5, 4, 20, 0, false);            // UTC: 4:20 AM Local: 6:20 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 11, 18, 0, 0, false);           // UTC: 6:00 PM Local: 8:00 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 11, 21, 14, 0, false);          // UTC: 9:14 PM Local: 11:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 13, 1, 31, 0, false);           // UTC: 1:31 AM Local: 3:31 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 15, 1, 53, 0, false);           // UTC: 1:53 AM Local: 3:53 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 4, 16, 10, 0, false);           // UTC: 4:10 PM Local: 6:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 8, 7, 16, 0, false);            // UTC: 7:16 AM Local: 9:16 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 8, 18, 1, 0, false);            // UTC: 6:01 PM Local: 8:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 9, 15, 16, 22, 0, false);          // UTC: 4:22 PM Local: 6:22 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 9, 14, 11, 0, false);          // UTC: 2:11 PM Local: 4:11 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 13, 0, 36, 0, false);          // UTC: 12:36 AM Local: 2:36 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 20, 9, 13, 0, false);          // UTC: 9:13 AM Local: 11:13 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 8, 18, 25, 0, false);          // UTC: 6:25 PM Local: 8:25 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 4, 7, 32, 0, false);           // UTC: 7:32 AM Local: 9:32 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 16, 14, 5, 0, false);          // UTC: 2:05 PM Local: 4:05 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 6, 13, 11, 0, false);          // UTC: 1:11 PM Local: 3:11 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 21, 13, 45, 0, false);         // UTC: 1:45 PM Local: 3:45 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 6, 5, 25, 0, false);           // UTC: 5:25 AM Local: 7:25 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 13, 20, 22, 0, false);         // UTC: 8:22 PM Local: 10:22 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 9, 20, 4, 0, false);           // UTC: 8:04 PM Local: 10:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 18, 1, 18, 0, false);          // UTC: 1:18 AM Local: 3:18 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 2, 22, 4, 0, false);           // UTC: 10:04 PM Local: 12:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 25, 19, 38, 0, false);         // UTC: 7:38 PM Local: 9:38 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 19, 19, 54, 0, false);         // UTC: 7:54 PM Local: 9:54 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 21, 3, 58, 0, false);          // UTC: 3:58 AM Local: 5:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 20, 16, 8, 0, false);          // UTC: 4:08 PM Local: 6:08 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 26, 7, 7, 0, false);           // UTC: 7:07 AM Local: 9:07 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 5, 13, 2, 0, false);           // UTC: 1:02 PM Local: 3:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 12, 6, 46, 0, false);          // UTC: 6:46 AM Local: 8:46 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 5, 5, 31, 0, false);           // UTC: 5:31 AM Local: 7:31 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 23, 22, 54, 0, false);         // UTC: 10:54 PM Local: 12:54 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 10, 11, 16, 0, false);         // UTC: 11:16 AM Local: 1:16 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 7, 11, 39, 0, false);          // UTC: 11:39 AM Local: 1:39 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 10, 1, 6, 44, 0, false);           // UTC: 6:44 AM Local: 8:44 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 15, 1, 43, 0, false);          // UTC: 1:43 AM Local: 3:43 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 23, 10, 4, 0, false);          // UTC: 10:04 AM Local: 12:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 12, 16, 9, 0, false);          // UTC: 4:09 PM Local: 6:09 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 7, 9, 32, 0, false);           // UTC: 9:32 AM Local: 11:32 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 26, 10, 27, 0, false);         // UTC: 10:27 AM Local: 12:27 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 8, 14, 42, 0, false);          // UTC: 2:42 PM Local: 4:42 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 8, 16, 35, 0, false);          // UTC: 4:35 PM Local: 6:35 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 4, 19, 52, 0, false);          // UTC: 7:52 PM Local: 9:52 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 1, 8, 39, 0, false);           // UTC: 8:39 AM Local: 10:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 20, 11, 12, 0, false);         // UTC: 11:12 AM Local: 1:12 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 14, 21, 2, 0, false);          // UTC: 9:02 PM Local: 11:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 10, 14, 30, 0, false);         // UTC: 2:30 PM Local: 4:30 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 9, 13, 47, 0, false);          // UTC: 1:47 PM Local: 3:47 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 20, 17, 29, 0, false);         // UTC: 5:29 PM Local: 7:29 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 11, 14, 33, 0, false);         // UTC: 2:33 PM Local: 4:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 11, 9, 1, 0, false);           // UTC: 9:01 AM Local: 11:01 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 23, 22, 51, 0, false);         // UTC: 10:51 PM Local: 12:51 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 26, 17, 32, 0, false);         // UTC: 5:32 PM Local: 7:32 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 5, 9, 13, 0, false);           // UTC: 9:13 AM Local: 11:13 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 23, 19, 4, 0, false);          // UTC: 7:04 PM Local: 9:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 12, 16, 13, 0, false);         // UTC: 4:13 PM Local: 6:13 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 26, 17, 28, 0, false);         // UTC: 5:28 PM Local: 7:28 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 14, 13, 49, 0, false);         // UTC: 1:49 PM Local: 3:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 26, 21, 2, 0, false);          // UTC: 9:02 PM Local: 11:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 11, 25, 12, 58, 0, false);         // UTC: 12:58 PM Local: 2:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 4, 16, 12, 0, false);          // UTC: 4:12 PM Local: 6:12 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 10, 14, 57, 0, false);         // UTC: 2:57 PM Local: 4:57 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 18, 20, 31, 0, false);         // UTC: 8:31 PM Local: 10:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 9, 12, 10, 0, false);          // UTC: 12:10 PM Local: 2:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 14, 4, 11, 0, false);          // UTC: 4:11 AM Local: 6:11 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 8, 11, 44, 0, false);          // UTC: 11:44 AM Local: 1:44 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 20, 7, 1, 0, false);           // UTC: 7:01 AM Local: 9:01 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 8, 9, 51, 0, false);           // UTC: 9:51 AM Local: 11:51 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 3, 20, 49, 0, false);          // UTC: 8:49 PM Local: 10:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 6, 19, 0, 0, false);           // UTC: 7:00 PM Local: 9:00 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 23, 0, 10, 0, false);          // UTC: 12:10 AM Local: 2:10 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 16, 0, 41, 0, false);          // UTC: 12:41 AM Local: 2:41 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 1, 11, 12, 0, false);          // UTC: 11:12 AM Local: 1:12 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 3, 17, 48, 0, false);          // UTC: 5:48 PM Local: 7:48 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 19, 14, 11, 0, false);         // UTC: 2:11 PM Local: 4:11 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 9, 22, 21, 0, false);          // UTC: 10:21 PM Local: 12:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 18, 15, 27, 0, false);         // UTC: 3:27 PM Local: 5:27 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 8, 4, 14, 0, false);           // UTC: 4:14 AM Local: 6:14 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 27, 19, 17, 0, false);         // UTC: 7:17 PM Local: 9:17 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 10, 5, 44, 0, false);          // UTC: 5:44 AM Local: 7:44 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 4, 10, 2, 0, false);           // UTC: 10:02 AM Local: 12:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 15, 11, 29, 0, false);         // UTC: 11:29 AM Local: 1:29 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 27, 21, 10, 0, false);         // UTC: 9:10 PM Local: 11:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 14, 5, 57, 0, false);          // UTC: 5:57 AM Local: 7:57 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 3, 2020, 12, 15, 14, 31, 0, false);         // UTC: 2:31 PM Local: 4:31 AM Offset: -10:00:00

	Serial.println(); Serial.print(failedCount); Serial.print(" of "); Serial.print(testCount); Serial.println(" test(s) failed.");
}
#endif
