#ifndef TEST_TIMEZONEID_1_H
#define TEST_TIMEZONEID_1_H

#include "TimeManager.h"
#include "TestHelper.h"

void run_TimeZoneId_1_Tests(const TimeManager& timeManager)
{
	uint16_t testCount = 0;
	uint16_t failedCount = 0;

	testCount++; failedCount += test(timeManager, 1, 2018, 1, 14, 19, 4, 0, false);           // UTC: 7:04 PM Local: 9:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 22, 8, 20, 0, false);           // UTC: 8:20 AM Local: 10:20 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 24, 1, 35, 0, false);           // UTC: 1:35 AM Local: 3:35 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 22, 21, 38, 0, false);          // UTC: 9:38 PM Local: 11:38 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 18, 6, 41, 0, false);           // UTC: 6:41 AM Local: 8:41 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 18, 18, 43, 0, false);          // UTC: 6:43 PM Local: 8:43 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 5, 5, 10, 0, false);            // UTC: 5:10 AM Local: 7:10 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 22, 16, 51, 0, false);          // UTC: 4:51 PM Local: 6:51 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 25, 17, 53, 0, false);          // UTC: 5:53 PM Local: 7:53 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 11, 7, 30, 0, false);           // UTC: 7:30 AM Local: 9:30 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 25, 7, 21, 0, false);           // UTC: 7:21 AM Local: 9:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 11, 15, 37, 0, false);          // UTC: 3:37 PM Local: 5:37 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 22, 5, 1, 0, false);            // UTC: 5:01 AM Local: 7:01 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 3, 14, 38, 0, false);           // UTC: 2:38 PM Local: 4:38 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 8, 20, 2, 0, false);            // UTC: 8:02 PM Local: 10:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 19, 7, 34, 0, false);           // UTC: 7:34 AM Local: 9:34 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 9, 18, 20, 0, false);           // UTC: 6:20 PM Local: 8:20 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 20, 10, 13, 0, false);          // UTC: 10:13 AM Local: 12:13 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 6, 16, 7, 0, false);            // UTC: 4:07 PM Local: 6:07 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 6, 20, 34, 0, false);           // UTC: 8:34 PM Local: 10:34 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 12, 11, 43, 0, false);          // UTC: 11:43 AM Local: 1:43 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 3, 20, 36, 0, false);           // UTC: 8:36 PM Local: 10:36 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 9, 5, 34, 0, false);            // UTC: 5:34 AM Local: 7:34 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 2, 19, 33, 0, false);           // UTC: 7:33 PM Local: 9:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 1, 20, 1, 36, 0, false);           // UTC: 1:36 AM Local: 3:36 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 15, 12, 47, 0, false);          // UTC: 12:47 PM Local: 2:47 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 23, 4, 26, 0, false);           // UTC: 4:26 AM Local: 6:26 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 9, 1, 29, 0, false);            // UTC: 1:29 AM Local: 3:29 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 5, 4, 49, 0, false);            // UTC: 4:49 AM Local: 6:49 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 4, 4, 58, 0, false);            // UTC: 4:58 AM Local: 6:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 14, 13, 19, 0, false);          // UTC: 1:19 PM Local: 3:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 12, 15, 8, 0, false);           // UTC: 3:08 PM Local: 5:08 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 25, 4, 0, 0, false);            // UTC: 4:00 AM Local: 6:00 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 12, 9, 4, 0, false);            // UTC: 9:04 AM Local: 11:04 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 1, 5, 57, 0, false);            // UTC: 5:57 AM Local: 7:57 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 22, 22, 24, 0, false);          // UTC: 10:24 PM Local: 12:24 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 17, 15, 10, 0, false);          // UTC: 3:10 PM Local: 5:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 9, 8, 41, 0, false);            // UTC: 8:41 AM Local: 10:41 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 4, 2, 24, 0, false);            // UTC: 2:24 AM Local: 4:24 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 7, 21, 40, 0, false);           // UTC: 9:40 PM Local: 11:40 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 22, 3, 1, 0, false);            // UTC: 3:01 AM Local: 5:01 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 16, 12, 14, 0, false);          // UTC: 12:14 PM Local: 2:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 7, 6, 22, 0, false);            // UTC: 6:22 AM Local: 8:22 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 14, 14, 19, 0, false);          // UTC: 2:19 PM Local: 4:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 22, 9, 46, 0, false);           // UTC: 9:46 AM Local: 11:46 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 11, 7, 49, 0, false);           // UTC: 7:49 AM Local: 9:49 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 15, 8, 11, 0, false);           // UTC: 8:11 AM Local: 10:11 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 12, 12, 32, 0, false);          // UTC: 12:32 PM Local: 2:32 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 22, 4, 13, 0, false);           // UTC: 4:13 AM Local: 6:13 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 2, 18, 7, 32, 0, false);           // UTC: 7:32 AM Local: 9:32 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 20, 15, 14, 0, true);           // UTC: 3:14 PM Local: 6:14 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 9, 14, 13, 0, false);           // UTC: 2:13 PM Local: 4:13 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 2, 9, 40, 0, false);            // UTC: 9:40 AM Local: 11:40 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 20, 12, 42, 0, true);           // UTC: 12:42 PM Local: 3:42 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 1, 2, 2, 0, false);             // UTC: 2:02 AM Local: 4:02 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 23, 12, 55, 0, true);           // UTC: 12:55 PM Local: 3:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 25, 17, 46, 0, true);           // UTC: 5:46 PM Local: 8:46 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 16, 16, 32, 0, true);           // UTC: 4:32 PM Local: 7:32 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 14, 7, 37, 0, true);            // UTC: 7:37 AM Local: 10:37 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 13, 17, 22, 0, true);           // UTC: 5:22 PM Local: 8:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 1, 13, 56, 0, false);           // UTC: 1:56 PM Local: 3:56 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 23, 17, 56, 0, true);           // UTC: 5:56 PM Local: 8:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 3, 11, 47, 0, false);           // UTC: 11:47 AM Local: 1:47 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 16, 7, 52, 0, true);            // UTC: 7:52 AM Local: 10:52 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 5, 18, 49, 0, false);           // UTC: 6:49 PM Local: 8:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 14, 9, 25, 0, true);            // UTC: 9:25 AM Local: 12:25 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 14, 22, 38, 0, true);           // UTC: 10:38 PM Local: 1:38 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 8, 16, 33, 0, false);           // UTC: 4:33 PM Local: 6:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 21, 3, 55, 0, true);            // UTC: 3:55 AM Local: 6:55 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 20, 19, 16, 0, true);           // UTC: 7:16 PM Local: 10:16 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 17, 13, 37, 0, true);           // UTC: 1:37 PM Local: 4:37 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 9, 16, 55, 0, false);           // UTC: 4:55 PM Local: 6:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 21, 4, 20, 0, true);            // UTC: 4:20 AM Local: 7:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 3, 17, 2, 0, false);            // UTC: 5:02 PM Local: 7:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 3, 4, 7, 25, 0, false);            // UTC: 7:25 AM Local: 9:25 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 25, 9, 54, 0, true);            // UTC: 9:54 AM Local: 12:54 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 20, 0, 54, 0, true);            // UTC: 12:54 AM Local: 3:54 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 6, 22, 48, 0, true);            // UTC: 10:48 PM Local: 1:48 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 20, 16, 50, 0, true);           // UTC: 4:50 PM Local: 7:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 11, 1, 34, 0, true);            // UTC: 1:34 AM Local: 4:34 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 1, 8, 38, 0, true);             // UTC: 8:38 AM Local: 11:38 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 14, 21, 43, 0, true);           // UTC: 9:43 PM Local: 12:43 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 7, 19, 6, 0, true);             // UTC: 7:06 PM Local: 10:06 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 25, 16, 13, 0, true);           // UTC: 4:13 PM Local: 7:13 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 3, 9, 12, 0, true);             // UTC: 9:12 AM Local: 12:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 17, 3, 23, 0, true);            // UTC: 3:23 AM Local: 6:23 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 4, 19, 45, 0, true);            // UTC: 7:45 PM Local: 10:45 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 1, 22, 48, 0, true);            // UTC: 10:48 PM Local: 1:48 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 10, 9, 36, 0, true);            // UTC: 9:36 AM Local: 12:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 23, 13, 57, 0, true);           // UTC: 1:57 PM Local: 4:57 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 3, 8, 5, 0, true);              // UTC: 8:05 AM Local: 11:05 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 21, 1, 22, 0, true);            // UTC: 1:22 AM Local: 4:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 11, 14, 22, 0, true);           // UTC: 2:22 PM Local: 5:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 20, 14, 31, 0, true);           // UTC: 2:31 PM Local: 5:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 23, 18, 16, 0, true);           // UTC: 6:16 PM Local: 9:16 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 19, 2, 32, 0, true);            // UTC: 2:32 AM Local: 5:32 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 17, 2, 33, 0, true);            // UTC: 2:33 AM Local: 5:33 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 13, 6, 13, 0, true);            // UTC: 6:13 AM Local: 9:13 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 23, 0, 22, 0, true);            // UTC: 12:22 AM Local: 3:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 4, 23, 3, 32, 0, true);            // UTC: 3:32 AM Local: 6:32 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 3, 9, 16, 0, true);             // UTC: 9:16 AM Local: 12:16 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 4, 18, 22, 0, true);            // UTC: 6:22 PM Local: 9:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 4, 7, 20, 0, true);             // UTC: 7:20 AM Local: 10:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 23, 5, 31, 0, true);            // UTC: 5:31 AM Local: 8:31 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 1, 9, 12, 0, true);             // UTC: 9:12 AM Local: 12:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 7, 4, 10, 0, true);             // UTC: 4:10 AM Local: 7:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 15, 15, 17, 0, true);           // UTC: 3:17 PM Local: 6:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 3, 4, 28, 0, true);             // UTC: 4:28 AM Local: 7:28 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 11, 13, 4, 0, true);            // UTC: 1:04 PM Local: 4:04 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 24, 21, 3, 0, true);            // UTC: 9:03 PM Local: 12:03 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 1, 13, 27, 0, true);            // UTC: 1:27 PM Local: 4:27 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 23, 13, 12, 0, true);           // UTC: 1:12 PM Local: 4:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 7, 15, 58, 0, true);            // UTC: 3:58 PM Local: 6:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 25, 12, 47, 0, true);           // UTC: 12:47 PM Local: 3:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 6, 18, 51, 0, true);            // UTC: 6:51 PM Local: 9:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 1, 10, 50, 0, true);            // UTC: 10:50 AM Local: 1:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 1, 13, 49, 0, true);            // UTC: 1:49 PM Local: 4:49 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 6, 6, 28, 0, true);             // UTC: 6:28 AM Local: 9:28 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 7, 0, 12, 0, true);             // UTC: 12:12 AM Local: 3:12 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 22, 16, 12, 0, true);           // UTC: 4:12 PM Local: 7:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 9, 5, 21, 0, true);             // UTC: 5:21 AM Local: 8:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 8, 18, 38, 0, true);            // UTC: 6:38 PM Local: 9:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 3, 3, 48, 0, true);             // UTC: 3:48 AM Local: 6:48 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 1, 22, 28, 0, true);            // UTC: 10:28 PM Local: 1:28 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 5, 6, 15, 6, 0, true);             // UTC: 3:06 PM Local: 6:06 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 14, 20, 25, 0, true);           // UTC: 8:25 PM Local: 11:25 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 17, 8, 8, 0, true);             // UTC: 8:08 AM Local: 11:08 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 6, 20, 21, 0, true);            // UTC: 8:21 PM Local: 11:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 7, 18, 17, 0, true);            // UTC: 6:17 PM Local: 9:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 27, 13, 33, 0, true);           // UTC: 1:33 PM Local: 4:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 1, 10, 56, 0, true);            // UTC: 10:56 AM Local: 1:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 22, 13, 17, 0, true);           // UTC: 1:17 PM Local: 4:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 13, 21, 57, 0, true);           // UTC: 9:57 PM Local: 12:57 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 7, 21, 18, 0, true);            // UTC: 9:18 PM Local: 12:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 1, 0, 36, 0, true);             // UTC: 12:36 AM Local: 3:36 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 10, 0, 36, 0, true);            // UTC: 12:36 AM Local: 3:36 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 11, 17, 9, 0, true);            // UTC: 5:09 PM Local: 8:09 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 22, 4, 21, 0, true);            // UTC: 4:21 AM Local: 7:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 2, 1, 23, 0, true);             // UTC: 1:23 AM Local: 4:23 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 1, 1, 1, 0, true);              // UTC: 1:01 AM Local: 4:01 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 10, 2, 33, 0, true);            // UTC: 2:33 AM Local: 5:33 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 7, 0, 30, 0, true);             // UTC: 12:30 AM Local: 3:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 15, 9, 3, 0, true);             // UTC: 9:03 AM Local: 12:03 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 23, 0, 56, 0, true);            // UTC: 12:56 AM Local: 3:56 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 13, 8, 24, 0, true);            // UTC: 8:24 AM Local: 11:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 23, 4, 51, 0, true);            // UTC: 4:51 AM Local: 7:51 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 21, 20, 46, 0, true);           // UTC: 8:46 PM Local: 11:46 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 19, 13, 48, 0, true);           // UTC: 1:48 PM Local: 4:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 12, 4, 14, 0, true);            // UTC: 4:14 AM Local: 7:14 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 6, 17, 16, 29, 0, true);           // UTC: 4:29 PM Local: 7:29 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 25, 10, 51, 0, true);           // UTC: 10:51 AM Local: 1:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 26, 20, 50, 0, true);           // UTC: 8:50 PM Local: 11:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 20, 17, 58, 0, true);           // UTC: 5:58 PM Local: 8:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 3, 18, 36, 0, true);            // UTC: 6:36 PM Local: 9:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 15, 12, 43, 0, true);           // UTC: 12:43 PM Local: 3:43 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 6, 7, 48, 0, true);             // UTC: 7:48 AM Local: 10:48 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 26, 5, 52, 0, true);            // UTC: 5:52 AM Local: 8:52 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 15, 5, 9, 0, true);             // UTC: 5:09 AM Local: 8:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 7, 15, 29, 0, true);            // UTC: 3:29 PM Local: 6:29 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 21, 19, 46, 0, true);           // UTC: 7:46 PM Local: 10:46 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 8, 21, 40, 0, true);            // UTC: 9:40 PM Local: 12:40 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 16, 20, 35, 0, true);           // UTC: 8:35 PM Local: 11:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 3, 11, 29, 0, true);            // UTC: 11:29 AM Local: 2:29 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 16, 2, 24, 0, true);            // UTC: 2:24 AM Local: 5:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 24, 15, 4, 0, true);            // UTC: 3:04 PM Local: 6:04 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 5, 2, 2, 0, true);              // UTC: 2:02 AM Local: 5:02 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 3, 5, 52, 0, true);             // UTC: 5:52 AM Local: 8:52 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 12, 15, 28, 0, true);           // UTC: 3:28 PM Local: 6:28 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 17, 8, 10, 0, true);            // UTC: 8:10 AM Local: 11:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 20, 16, 11, 0, true);           // UTC: 4:11 PM Local: 7:11 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 10, 22, 55, 0, true);           // UTC: 10:55 PM Local: 1:55 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 6, 18, 52, 0, true);            // UTC: 6:52 PM Local: 9:52 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 26, 22, 38, 0, true);           // UTC: 10:38 PM Local: 1:38 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 4, 2, 48, 0, true);             // UTC: 2:48 AM Local: 5:48 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 7, 9, 8, 8, 0, true);              // UTC: 8:08 AM Local: 11:08 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 13, 15, 35, 0, true);           // UTC: 3:35 PM Local: 6:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 3, 0, 32, 0, true);             // UTC: 12:32 AM Local: 3:32 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 13, 15, 36, 0, true);           // UTC: 3:36 PM Local: 6:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 25, 19, 14, 0, true);           // UTC: 7:14 PM Local: 10:14 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 6, 21, 31, 0, true);            // UTC: 9:31 PM Local: 12:31 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 12, 8, 46, 0, true);            // UTC: 8:46 AM Local: 11:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 9, 4, 6, 0, true);              // UTC: 4:06 AM Local: 7:06 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 14, 15, 48, 0, true);           // UTC: 3:48 PM Local: 6:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 5, 5, 7, 0, true);              // UTC: 5:07 AM Local: 8:07 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 11, 22, 7, 0, true);            // UTC: 10:07 PM Local: 1:07 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 2, 2, 17, 0, true);             // UTC: 2:17 AM Local: 5:17 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 10, 3, 42, 0, true);            // UTC: 3:42 AM Local: 6:42 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 16, 14, 40, 0, true);           // UTC: 2:40 PM Local: 5:40 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 18, 20, 19, 0, true);           // UTC: 8:19 PM Local: 11:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 9, 7, 58, 0, true);             // UTC: 7:58 AM Local: 10:58 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 18, 16, 3, 0, true);            // UTC: 4:03 PM Local: 7:03 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 4, 16, 41, 0, true);            // UTC: 4:41 PM Local: 7:41 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 1, 0, 9, 0, true);              // UTC: 12:09 AM Local: 3:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 1, 22, 58, 0, true);            // UTC: 10:58 PM Local: 1:58 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 22, 21, 46, 0, true);           // UTC: 9:46 PM Local: 12:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 12, 1, 40, 0, true);            // UTC: 1:40 AM Local: 4:40 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 14, 18, 43, 0, true);           // UTC: 6:43 PM Local: 9:43 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 26, 19, 46, 0, true);           // UTC: 7:46 PM Local: 10:46 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 22, 19, 45, 0, true);           // UTC: 7:45 PM Local: 10:45 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 8, 3, 15, 17, 0, true);            // UTC: 3:17 PM Local: 6:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 22, 3, 20, 0, true);            // UTC: 3:20 AM Local: 6:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 23, 12, 30, 0, true);           // UTC: 12:30 PM Local: 3:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 2, 6, 14, 0, true);             // UTC: 6:14 AM Local: 9:14 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 12, 0, 4, 0, true);             // UTC: 12:04 AM Local: 3:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 4, 7, 9, 0, true);              // UTC: 7:09 AM Local: 10:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 20, 18, 41, 0, true);           // UTC: 6:41 PM Local: 9:41 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 25, 5, 49, 0, true);            // UTC: 5:49 AM Local: 8:49 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 18, 18, 28, 0, true);           // UTC: 6:28 PM Local: 9:28 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 7, 15, 52, 0, true);            // UTC: 3:52 PM Local: 6:52 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 8, 7, 52, 0, true);             // UTC: 7:52 AM Local: 10:52 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 26, 21, 21, 0, true);           // UTC: 9:21 PM Local: 12:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 24, 5, 47, 0, true);            // UTC: 5:47 AM Local: 8:47 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 18, 21, 22, 0, true);           // UTC: 9:22 PM Local: 12:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 8, 8, 46, 0, true);             // UTC: 8:46 AM Local: 11:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 13, 1, 46, 0, true);            // UTC: 1:46 AM Local: 4:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 19, 18, 30, 0, true);           // UTC: 6:30 PM Local: 9:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 18, 1, 2, 0, true);             // UTC: 1:02 AM Local: 4:02 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 3, 4, 25, 0, true);             // UTC: 4:25 AM Local: 7:25 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 13, 3, 21, 0, true);            // UTC: 3:21 AM Local: 6:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 24, 13, 49, 0, true);           // UTC: 1:49 PM Local: 4:49 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 17, 18, 56, 0, true);           // UTC: 6:56 PM Local: 9:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 10, 10, 5, 0, true);            // UTC: 10:05 AM Local: 1:05 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 19, 6, 4, 0, true);             // UTC: 6:04 AM Local: 9:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 10, 1, 50, 0, true);            // UTC: 1:50 AM Local: 4:50 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 9, 9, 14, 50, 0, true);            // UTC: 2:50 PM Local: 5:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 2, 4, 43, 0, true);            // UTC: 4:43 AM Local: 7:43 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 20, 13, 52, 0, true);          // UTC: 1:52 PM Local: 4:52 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 10, 14, 14, 0, true);          // UTC: 2:14 PM Local: 5:14 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 23, 19, 43, 0, true);          // UTC: 7:43 PM Local: 10:43 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 26, 9, 6, 0, true);            // UTC: 9:06 AM Local: 12:06 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 13, 18, 19, 0, true);          // UTC: 6:19 PM Local: 9:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 15, 15, 33, 0, true);          // UTC: 3:33 PM Local: 6:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 23, 2, 35, 0, true);           // UTC: 2:35 AM Local: 5:35 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 19, 22, 30, 0, true);          // UTC: 10:30 PM Local: 1:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 13, 6, 58, 0, true);           // UTC: 6:58 AM Local: 9:58 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 5, 17, 34, 0, true);           // UTC: 5:34 PM Local: 8:34 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 16, 9, 56, 0, true);           // UTC: 9:56 AM Local: 12:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 17, 3, 2, 0, true);            // UTC: 3:02 AM Local: 6:02 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 26, 5, 9, 0, true);            // UTC: 5:09 AM Local: 8:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 20, 11, 36, 0, true);          // UTC: 11:36 AM Local: 2:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 10, 17, 52, 0, true);          // UTC: 5:52 PM Local: 8:52 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 27, 20, 16, 0, true);          // UTC: 8:16 PM Local: 11:16 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 15, 17, 56, 0, true);          // UTC: 5:56 PM Local: 8:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 9, 5, 6, 0, true);             // UTC: 5:06 AM Local: 8:06 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 4, 0, 34, 0, true);            // UTC: 12:34 AM Local: 3:34 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 11, 21, 20, 0, true);          // UTC: 9:20 PM Local: 12:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 7, 15, 5, 0, true);            // UTC: 3:05 PM Local: 6:05 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 5, 8, 57, 0, true);            // UTC: 8:57 AM Local: 11:57 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 5, 18, 38, 0, true);           // UTC: 6:38 PM Local: 9:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 10, 8, 13, 23, 0, true);           // UTC: 1:23 PM Local: 4:23 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 11, 2, 33, 0, false);          // UTC: 2:33 AM Local: 4:33 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 27, 7, 12, 0, false);          // UTC: 7:12 AM Local: 9:12 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 17, 11, 22, 0, false);         // UTC: 11:22 AM Local: 1:22 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 20, 14, 58, 0, false);         // UTC: 2:58 PM Local: 4:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 17, 6, 11, 0, false);          // UTC: 6:11 AM Local: 8:11 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 23, 11, 7, 0, false);          // UTC: 11:07 AM Local: 1:07 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 13, 13, 19, 0, false);         // UTC: 1:19 PM Local: 3:19 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 22, 10, 49, 0, false);         // UTC: 10:49 AM Local: 12:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 14, 4, 22, 0, false);          // UTC: 4:22 AM Local: 6:22 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 25, 18, 4, 0, false);          // UTC: 6:04 PM Local: 8:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 18, 5, 10, 0, false);          // UTC: 5:10 AM Local: 7:10 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 15, 20, 5, 0, false);          // UTC: 8:05 PM Local: 10:05 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 15, 3, 40, 0, false);          // UTC: 3:40 AM Local: 5:40 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 11, 17, 26, 0, false);         // UTC: 5:26 PM Local: 7:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 27, 12, 1, 0, false);          // UTC: 12:01 PM Local: 2:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 4, 12, 6, 0, false);           // UTC: 12:06 PM Local: 2:06 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 22, 7, 18, 0, false);          // UTC: 7:18 AM Local: 9:18 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 14, 19, 1, 0, false);          // UTC: 7:01 PM Local: 9:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 3, 13, 38, 0, true);           // UTC: 1:38 PM Local: 4:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 20, 10, 7, 0, false);          // UTC: 10:07 AM Local: 12:07 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 23, 16, 39, 0, false);         // UTC: 4:39 PM Local: 6:39 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 9, 1, 23, 0, false);           // UTC: 1:23 AM Local: 3:23 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 22, 1, 21, 0, false);          // UTC: 1:21 AM Local: 3:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 3, 7, 21, 0, true);            // UTC: 7:21 AM Local: 10:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 11, 13, 1, 48, 0, false);          // UTC: 1:48 AM Local: 3:48 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 24, 19, 55, 0, false);         // UTC: 7:55 PM Local: 9:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 23, 9, 40, 0, false);          // UTC: 9:40 AM Local: 11:40 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 8, 2, 29, 0, false);           // UTC: 2:29 AM Local: 4:29 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 21, 2, 23, 0, false);          // UTC: 2:23 AM Local: 4:23 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 4, 11, 18, 0, false);          // UTC: 11:18 AM Local: 1:18 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 13, 18, 39, 0, false);         // UTC: 6:39 PM Local: 8:39 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 16, 12, 2, 0, false);          // UTC: 12:02 PM Local: 2:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 21, 14, 26, 0, false);         // UTC: 2:26 PM Local: 4:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 18, 6, 26, 0, false);          // UTC: 6:26 AM Local: 8:26 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 21, 16, 58, 0, false);         // UTC: 4:58 PM Local: 6:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 26, 1, 45, 0, false);          // UTC: 1:45 AM Local: 3:45 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 6, 4, 44, 0, false);           // UTC: 4:44 AM Local: 6:44 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 20, 20, 3, 0, false);          // UTC: 8:03 PM Local: 10:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 12, 12, 34, 0, false);         // UTC: 12:34 PM Local: 2:34 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 5, 13, 57, 0, false);          // UTC: 1:57 PM Local: 3:57 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 1, 15, 35, 0, false);          // UTC: 3:35 PM Local: 5:35 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 2, 14, 30, 0, false);          // UTC: 2:30 PM Local: 4:30 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 20, 20, 30, 0, false);         // UTC: 8:30 PM Local: 10:30 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 21, 2, 11, 0, false);          // UTC: 2:11 AM Local: 4:11 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 14, 4, 5, 0, false);           // UTC: 4:05 AM Local: 6:05 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 7, 12, 24, 0, false);          // UTC: 12:24 PM Local: 2:24 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 14, 18, 3, 0, false);          // UTC: 6:03 PM Local: 8:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 17, 21, 17, 0, false);         // UTC: 9:17 PM Local: 11:17 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 16, 16, 53, 0, false);         // UTC: 4:53 PM Local: 6:53 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2018, 12, 17, 3, 58, 0, false);          // UTC: 3:58 AM Local: 5:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 13, 13, 4, 0, false);           // UTC: 1:04 PM Local: 3:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 13, 14, 37, 0, false);          // UTC: 2:37 PM Local: 4:37 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 24, 15, 3, 0, false);           // UTC: 3:03 PM Local: 5:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 14, 5, 10, 0, false);           // UTC: 5:10 AM Local: 7:10 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 7, 10, 4, 0, false);            // UTC: 10:04 AM Local: 12:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 15, 4, 42, 0, false);           // UTC: 4:42 AM Local: 6:42 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 27, 4, 1, 0, false);            // UTC: 4:01 AM Local: 6:01 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 5, 15, 45, 0, false);           // UTC: 3:45 PM Local: 5:45 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 25, 8, 43, 0, false);           // UTC: 8:43 AM Local: 10:43 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 9, 11, 53, 0, false);           // UTC: 11:53 AM Local: 1:53 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 17, 2, 44, 0, false);           // UTC: 2:44 AM Local: 4:44 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 15, 7, 30, 0, false);           // UTC: 7:30 AM Local: 9:30 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 4, 0, 32, 0, false);            // UTC: 12:32 AM Local: 2:32 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 13, 8, 49, 0, false);           // UTC: 8:49 AM Local: 10:49 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 10, 0, 32, 0, false);           // UTC: 12:32 AM Local: 2:32 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 24, 8, 29, 0, false);           // UTC: 8:29 AM Local: 10:29 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 6, 0, 30, 0, false);            // UTC: 12:30 AM Local: 2:30 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 5, 14, 55, 0, false);           // UTC: 2:55 PM Local: 4:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 27, 6, 54, 0, false);           // UTC: 6:54 AM Local: 8:54 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 9, 12, 14, 0, false);           // UTC: 12:14 PM Local: 2:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 25, 12, 11, 0, false);          // UTC: 12:11 PM Local: 2:11 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 4, 20, 8, 0, false);            // UTC: 8:08 PM Local: 10:08 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 12, 16, 6, 0, false);           // UTC: 4:06 PM Local: 6:06 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 15, 10, 11, 0, false);          // UTC: 10:11 AM Local: 12:11 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 1, 5, 11, 47, 0, false);           // UTC: 11:47 AM Local: 1:47 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 5, 18, 38, 0, false);           // UTC: 6:38 PM Local: 8:38 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 6, 0, 0, 0, false);             // UTC: 12:00 AM Local: 2:00 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 7, 2, 28, 0, false);            // UTC: 2:28 AM Local: 4:28 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 11, 10, 27, 0, false);          // UTC: 10:27 AM Local: 12:27 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 22, 13, 1, 0, false);           // UTC: 1:01 PM Local: 3:01 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 16, 18, 26, 0, false);          // UTC: 6:26 PM Local: 8:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 9, 12, 49, 0, false);           // UTC: 12:49 PM Local: 2:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 18, 5, 8, 0, false);            // UTC: 5:08 AM Local: 7:08 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 12, 9, 38, 0, false);           // UTC: 9:38 AM Local: 11:38 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 11, 15, 33, 0, false);          // UTC: 3:33 PM Local: 5:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 9, 22, 7, 0, false);            // UTC: 10:07 PM Local: 12:07 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 4, 18, 29, 0, false);           // UTC: 6:29 PM Local: 8:29 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 8, 2, 30, 0, false);            // UTC: 2:30 AM Local: 4:30 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 7, 15, 27, 0, false);           // UTC: 3:27 PM Local: 5:27 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 19, 17, 25, 0, false);          // UTC: 5:25 PM Local: 7:25 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 19, 14, 8, 0, false);           // UTC: 2:08 PM Local: 4:08 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 3, 22, 37, 0, false);           // UTC: 10:37 PM Local: 12:37 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 21, 20, 55, 0, false);          // UTC: 8:55 PM Local: 10:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 27, 12, 33, 0, false);          // UTC: 12:33 PM Local: 2:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 14, 18, 36, 0, false);          // UTC: 6:36 PM Local: 8:36 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 10, 19, 24, 0, false);          // UTC: 7:24 PM Local: 9:24 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 25, 1, 25, 0, false);           // UTC: 1:25 AM Local: 3:25 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 10, 15, 45, 0, false);          // UTC: 3:45 PM Local: 5:45 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 15, 7, 40, 0, false);           // UTC: 7:40 AM Local: 9:40 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 2, 26, 1, 51, 0, false);           // UTC: 1:51 AM Local: 3:51 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 11, 21, 27, 0, true);           // UTC: 9:27 PM Local: 12:27 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 20, 17, 47, 0, true);           // UTC: 5:47 PM Local: 8:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 14, 6, 41, 0, true);            // UTC: 6:41 AM Local: 9:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 26, 13, 7, 0, true);            // UTC: 1:07 PM Local: 4:07 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 5, 3, 15, 0, false);            // UTC: 3:15 AM Local: 5:15 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 25, 17, 19, 0, true);           // UTC: 5:19 PM Local: 8:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 25, 20, 49, 0, true);           // UTC: 8:49 PM Local: 11:49 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 2, 18, 40, 0, false);           // UTC: 6:40 PM Local: 8:40 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 27, 7, 56, 0, true);            // UTC: 7:56 AM Local: 10:56 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 11, 12, 38, 0, true);           // UTC: 12:38 PM Local: 3:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 26, 18, 48, 0, true);           // UTC: 6:48 PM Local: 9:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 2, 13, 33, 0, false);           // UTC: 1:33 PM Local: 3:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 3, 18, 2, 0, false);            // UTC: 6:02 PM Local: 8:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 22, 19, 31, 0, true);           // UTC: 7:31 PM Local: 10:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 20, 22, 29, 0, true);           // UTC: 10:29 PM Local: 1:29 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 9, 3, 30, 0, false);            // UTC: 3:30 AM Local: 5:30 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 14, 14, 31, 0, true);           // UTC: 2:31 PM Local: 5:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 10, 0, 9, 0, false);            // UTC: 12:09 AM Local: 2:09 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 2, 7, 9, 0, false);             // UTC: 7:09 AM Local: 9:09 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 21, 16, 24, 0, true);           // UTC: 4:24 PM Local: 7:24 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 23, 2, 44, 0, true);            // UTC: 2:44 AM Local: 5:44 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 2, 22, 44, 0, false);           // UTC: 10:44 PM Local: 12:44 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 9, 2, 33, 0, false);            // UTC: 2:33 AM Local: 4:33 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 19, 18, 58, 0, true);           // UTC: 6:58 PM Local: 9:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 3, 8, 2, 2, 0, false);             // UTC: 2:02 AM Local: 4:02 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 9, 7, 47, 0, true);             // UTC: 7:47 AM Local: 10:47 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 6, 15, 10, 0, true);            // UTC: 3:10 PM Local: 6:10 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 12, 19, 55, 0, true);           // UTC: 7:55 PM Local: 10:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 4, 13, 46, 0, true);            // UTC: 1:46 PM Local: 4:46 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 18, 0, 14, 0, true);            // UTC: 12:14 AM Local: 3:14 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 11, 7, 4, 0, true);             // UTC: 7:04 AM Local: 10:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 17, 22, 42, 0, true);           // UTC: 10:42 PM Local: 1:42 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 22, 15, 0, 0, true);            // UTC: 3:00 PM Local: 6:00 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 20, 0, 2, 0, true);             // UTC: 12:02 AM Local: 3:02 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 26, 18, 47, 0, true);           // UTC: 6:47 PM Local: 9:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 15, 1, 54, 0, true);            // UTC: 1:54 AM Local: 4:54 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 4, 17, 1, 0, true);             // UTC: 5:01 PM Local: 8:01 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 10, 13, 1, 0, true);            // UTC: 1:01 PM Local: 4:01 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 7, 9, 15, 0, true);             // UTC: 9:15 AM Local: 12:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 22, 21, 22, 0, true);           // UTC: 9:22 PM Local: 12:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 26, 15, 4, 0, true);            // UTC: 3:04 PM Local: 6:04 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 9, 6, 27, 0, true);             // UTC: 6:27 AM Local: 9:27 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 25, 15, 8, 0, true);            // UTC: 3:08 PM Local: 6:08 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 9, 11, 39, 0, true);            // UTC: 11:39 AM Local: 2:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 22, 10, 39, 0, true);           // UTC: 10:39 AM Local: 1:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 4, 11, 2, 0, true);             // UTC: 11:02 AM Local: 2:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 4, 13, 31, 0, true);            // UTC: 1:31 PM Local: 4:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 24, 12, 17, 0, true);           // UTC: 12:17 PM Local: 3:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 7, 0, 45, 0, true);             // UTC: 12:45 AM Local: 3:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 4, 2, 8, 32, 0, true);             // UTC: 8:32 AM Local: 11:32 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 13, 22, 42, 0, true);           // UTC: 10:42 PM Local: 1:42 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 17, 17, 20, 0, true);           // UTC: 5:20 PM Local: 8:20 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 26, 13, 31, 0, true);           // UTC: 1:31 PM Local: 4:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 9, 14, 23, 0, true);            // UTC: 2:23 PM Local: 5:23 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 22, 18, 13, 0, true);           // UTC: 6:13 PM Local: 9:13 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 10, 13, 6, 0, true);            // UTC: 1:06 PM Local: 4:06 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 10, 2, 53, 0, true);            // UTC: 2:53 AM Local: 5:53 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 7, 15, 22, 0, true);            // UTC: 3:22 PM Local: 6:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 24, 1, 7, 0, true);             // UTC: 1:07 AM Local: 4:07 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 22, 2, 14, 0, true);            // UTC: 2:14 AM Local: 5:14 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 19, 19, 17, 0, true);           // UTC: 7:17 PM Local: 10:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 16, 19, 31, 0, true);           // UTC: 7:31 PM Local: 10:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 26, 4, 40, 0, true);            // UTC: 4:40 AM Local: 7:40 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 9, 3, 52, 0, true);             // UTC: 3:52 AM Local: 6:52 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 14, 18, 54, 0, true);           // UTC: 6:54 PM Local: 9:54 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 4, 2, 42, 0, true);             // UTC: 2:42 AM Local: 5:42 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 2, 20, 27, 0, true);            // UTC: 8:27 PM Local: 11:27 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 18, 15, 15, 0, true);           // UTC: 3:15 PM Local: 6:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 18, 5, 17, 0, true);            // UTC: 5:17 AM Local: 8:17 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 10, 17, 41, 0, true);           // UTC: 5:41 PM Local: 8:41 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 6, 3, 29, 0, true);             // UTC: 3:29 AM Local: 6:29 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 8, 14, 47, 0, true);            // UTC: 2:47 PM Local: 5:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 3, 4, 55, 0, true);             // UTC: 4:55 AM Local: 7:55 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 20, 9, 23, 0, true);            // UTC: 9:23 AM Local: 12:23 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 5, 12, 1, 55, 0, true);            // UTC: 1:55 AM Local: 4:55 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 1, 16, 51, 0, true);            // UTC: 4:51 PM Local: 7:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 13, 16, 58, 0, true);           // UTC: 4:58 PM Local: 7:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 12, 16, 13, 0, true);           // UTC: 4:13 PM Local: 7:13 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 21, 0, 9, 0, true);             // UTC: 12:09 AM Local: 3:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 1, 22, 37, 0, true);            // UTC: 10:37 PM Local: 1:37 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 7, 14, 24, 0, true);            // UTC: 2:24 PM Local: 5:24 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 27, 2, 0, 0, true);             // UTC: 2:00 AM Local: 5:00 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 11, 4, 9, 0, true);             // UTC: 4:09 AM Local: 7:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 4, 0, 53, 0, true);             // UTC: 12:53 AM Local: 3:53 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 21, 8, 28, 0, true);            // UTC: 8:28 AM Local: 11:28 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 3, 5, 38, 0, true);             // UTC: 5:38 AM Local: 8:38 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 9, 14, 29, 0, true);            // UTC: 2:29 PM Local: 5:29 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 12, 20, 2, 0, true);            // UTC: 8:02 PM Local: 11:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 20, 18, 25, 0, true);           // UTC: 6:25 PM Local: 9:25 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 8, 11, 35, 0, true);            // UTC: 11:35 AM Local: 2:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 18, 1, 13, 0, true);            // UTC: 1:13 AM Local: 4:13 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 8, 10, 46, 0, true);            // UTC: 10:46 AM Local: 1:46 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 27, 10, 55, 0, true);           // UTC: 10:55 AM Local: 1:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 26, 14, 29, 0, true);           // UTC: 2:29 PM Local: 5:29 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 20, 7, 41, 0, true);            // UTC: 7:41 AM Local: 10:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 3, 14, 22, 0, true);            // UTC: 2:22 PM Local: 5:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 21, 15, 46, 0, true);           // UTC: 3:46 PM Local: 6:46 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 14, 16, 20, 0, true);           // UTC: 4:20 PM Local: 7:20 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 4, 18, 42, 0, true);            // UTC: 6:42 PM Local: 9:42 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 6, 11, 6, 17, 0, true);            // UTC: 6:17 AM Local: 9:17 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 16, 2, 41, 0, true);            // UTC: 2:41 AM Local: 5:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 16, 11, 56, 0, true);           // UTC: 11:56 AM Local: 2:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 19, 10, 51, 0, true);           // UTC: 10:51 AM Local: 1:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 19, 2, 46, 0, true);            // UTC: 2:46 AM Local: 5:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 19, 9, 57, 0, true);            // UTC: 9:57 AM Local: 12:57 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 1, 16, 32, 0, true);            // UTC: 4:32 PM Local: 7:32 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 10, 14, 8, 0, true);            // UTC: 2:08 PM Local: 5:08 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 2, 12, 49, 0, true);            // UTC: 12:49 PM Local: 3:49 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 22, 2, 20, 0, true);            // UTC: 2:20 AM Local: 5:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 24, 3, 39, 0, true);            // UTC: 3:39 AM Local: 6:39 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 2, 13, 9, 0, true);             // UTC: 1:09 PM Local: 4:09 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 18, 8, 30, 0, true);            // UTC: 8:30 AM Local: 11:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 22, 3, 50, 0, true);            // UTC: 3:50 AM Local: 6:50 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 20, 9, 9, 0, true);             // UTC: 9:09 AM Local: 12:09 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 14, 1, 34, 0, true);            // UTC: 1:34 AM Local: 4:34 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 1, 18, 18, 0, true);            // UTC: 6:18 PM Local: 9:18 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 11, 3, 4, 0, true);             // UTC: 3:04 AM Local: 6:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 5, 1, 39, 0, true);             // UTC: 1:39 AM Local: 4:39 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 4, 12, 34, 0, true);            // UTC: 12:34 PM Local: 3:34 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 24, 17, 20, 0, true);           // UTC: 5:20 PM Local: 8:20 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 17, 18, 18, 0, true);           // UTC: 6:18 PM Local: 9:18 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 6, 14, 29, 0, true);            // UTC: 2:29 PM Local: 5:29 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 17, 1, 2, 0, true);             // UTC: 1:02 AM Local: 4:02 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 13, 4, 33, 0, true);            // UTC: 4:33 AM Local: 7:33 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 7, 19, 13, 11, 0, true);           // UTC: 1:11 PM Local: 4:11 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 27, 12, 28, 0, true);           // UTC: 12:28 PM Local: 3:28 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 7, 18, 18, 0, true);            // UTC: 6:18 PM Local: 9:18 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 2, 11, 1, 0, true);             // UTC: 11:01 AM Local: 2:01 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 17, 20, 33, 0, true);           // UTC: 8:33 PM Local: 11:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 14, 11, 48, 0, true);           // UTC: 11:48 AM Local: 2:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 26, 21, 23, 0, true);           // UTC: 9:23 PM Local: 12:23 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 14, 2, 37, 0, true);            // UTC: 2:37 AM Local: 5:37 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 23, 7, 24, 0, true);            // UTC: 7:24 AM Local: 10:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 3, 8, 44, 0, true);             // UTC: 8:44 AM Local: 11:44 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 8, 21, 55, 0, true);            // UTC: 9:55 PM Local: 12:55 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 14, 11, 26, 0, true);           // UTC: 11:26 AM Local: 2:26 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 13, 3, 0, 0, true);             // UTC: 3:00 AM Local: 6:00 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 3, 14, 55, 0, true);            // UTC: 2:55 PM Local: 5:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 2, 13, 16, 0, true);            // UTC: 1:16 PM Local: 4:16 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 9, 13, 44, 0, true);            // UTC: 1:44 PM Local: 4:44 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 26, 2, 32, 0, true);            // UTC: 2:32 AM Local: 5:32 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 7, 11, 15, 0, true);            // UTC: 11:15 AM Local: 2:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 5, 4, 27, 0, true);             // UTC: 4:27 AM Local: 7:27 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 16, 3, 12, 0, true);            // UTC: 3:12 AM Local: 6:12 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 2, 3, 25, 0, true);             // UTC: 3:25 AM Local: 6:25 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 16, 17, 34, 0, true);           // UTC: 5:34 PM Local: 8:34 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 3, 2, 23, 0, true);             // UTC: 2:23 AM Local: 5:23 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 4, 0, 19, 0, true);             // UTC: 12:19 AM Local: 3:19 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 22, 19, 19, 0, true);           // UTC: 7:19 PM Local: 10:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 8, 13, 10, 32, 0, true);           // UTC: 10:32 AM Local: 1:32 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 10, 12, 42, 0, true);           // UTC: 12:42 PM Local: 3:42 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 18, 3, 14, 0, true);            // UTC: 3:14 AM Local: 6:14 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 6, 1, 23, 0, true);             // UTC: 1:23 AM Local: 4:23 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 19, 7, 16, 0, true);            // UTC: 7:16 AM Local: 10:16 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 27, 20, 1, 0, true);            // UTC: 8:01 PM Local: 11:01 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 22, 0, 27, 0, true);            // UTC: 12:27 AM Local: 3:27 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 14, 11, 47, 0, true);           // UTC: 11:47 AM Local: 2:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 19, 4, 29, 0, true);            // UTC: 4:29 AM Local: 7:29 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 10, 18, 5, 0, true);            // UTC: 6:05 PM Local: 9:05 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 6, 9, 40, 0, true);             // UTC: 9:40 AM Local: 12:40 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 26, 16, 43, 0, true);           // UTC: 4:43 PM Local: 7:43 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 25, 4, 34, 0, true);            // UTC: 4:34 AM Local: 7:34 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 14, 9, 0, 0, true);             // UTC: 9:00 AM Local: 12:00 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 5, 8, 41, 0, true);             // UTC: 8:41 AM Local: 11:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 6, 9, 45, 0, true);             // UTC: 9:45 AM Local: 12:45 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 4, 3, 7, 0, true);              // UTC: 3:07 AM Local: 6:07 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 9, 22, 47, 0, true);            // UTC: 10:47 PM Local: 1:47 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 24, 21, 57, 0, true);           // UTC: 9:57 PM Local: 12:57 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 21, 15, 19, 0, true);           // UTC: 3:19 PM Local: 6:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 6, 6, 19, 0, true);             // UTC: 6:19 AM Local: 9:19 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 5, 22, 37, 0, true);            // UTC: 10:37 PM Local: 1:37 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 20, 17, 36, 0, true);           // UTC: 5:36 PM Local: 8:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 15, 1, 40, 0, true);            // UTC: 1:40 AM Local: 4:40 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 13, 7, 35, 0, true);            // UTC: 7:35 AM Local: 10:35 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 9, 13, 7, 7, 0, true);             // UTC: 7:07 AM Local: 10:07 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 3, 11, 48, 0, true);           // UTC: 11:48 AM Local: 2:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 21, 5, 40, 0, true);           // UTC: 5:40 AM Local: 8:40 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 27, 21, 25, 0, true);          // UTC: 9:25 PM Local: 12:25 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 25, 1, 45, 0, true);           // UTC: 1:45 AM Local: 4:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 21, 3, 32, 0, true);           // UTC: 3:32 AM Local: 6:32 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 7, 6, 7, 0, true);             // UTC: 6:07 AM Local: 9:07 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 19, 0, 21, 0, true);           // UTC: 12:21 AM Local: 3:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 3, 10, 38, 0, true);           // UTC: 10:38 AM Local: 1:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 5, 13, 4, 0, true);            // UTC: 1:04 PM Local: 4:04 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 12, 19, 39, 0, true);          // UTC: 7:39 PM Local: 10:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 6, 9, 36, 0, true);            // UTC: 9:36 AM Local: 12:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 23, 14, 9, 0, true);           // UTC: 2:09 PM Local: 5:09 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 15, 10, 3, 0, true);           // UTC: 10:03 AM Local: 1:03 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 18, 4, 4, 0, true);            // UTC: 4:04 AM Local: 7:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 6, 18, 40, 0, true);           // UTC: 6:40 PM Local: 9:40 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 24, 18, 52, 0, true);          // UTC: 6:52 PM Local: 9:52 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 4, 4, 2, 0, true);             // UTC: 4:02 AM Local: 7:02 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 13, 18, 18, 0, true);          // UTC: 6:18 PM Local: 9:18 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 21, 0, 1, 0, true);            // UTC: 12:01 AM Local: 3:01 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 5, 13, 39, 0, true);           // UTC: 1:39 PM Local: 4:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 17, 12, 3, 0, true);           // UTC: 12:03 PM Local: 3:03 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 21, 16, 39, 0, true);          // UTC: 4:39 PM Local: 7:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 5, 20, 31, 0, true);           // UTC: 8:31 PM Local: 11:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 11, 16, 47, 0, true);          // UTC: 4:47 PM Local: 7:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 10, 2, 0, 49, 0, true);            // UTC: 12:49 AM Local: 3:49 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 8, 20, 38, 0, false);          // UTC: 8:38 PM Local: 10:38 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 27, 6, 46, 0, false);          // UTC: 6:46 AM Local: 8:46 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 6, 6, 38, 0, false);           // UTC: 6:38 AM Local: 8:38 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 18, 16, 35, 0, false);         // UTC: 4:35 PM Local: 6:35 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 9, 1, 36, 0, false);           // UTC: 1:36 AM Local: 3:36 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 4, 8, 51, 0, false);           // UTC: 8:51 AM Local: 10:51 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 11, 0, 38, 0, false);          // UTC: 12:38 AM Local: 2:38 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 1, 10, 7, 0, true);            // UTC: 10:07 AM Local: 1:07 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 1, 16, 51, 0, true);           // UTC: 4:51 PM Local: 7:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 10, 17, 28, 0, false);         // UTC: 5:28 PM Local: 7:28 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 7, 9, 45, 0, false);           // UTC: 9:45 AM Local: 11:45 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 13, 11, 9, 0, false);          // UTC: 11:09 AM Local: 1:09 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 11, 4, 17, 0, false);          // UTC: 4:17 AM Local: 6:17 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 24, 9, 13, 0, false);          // UTC: 9:13 AM Local: 11:13 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 12, 2, 58, 0, false);          // UTC: 2:58 AM Local: 4:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 3, 19, 49, 0, false);          // UTC: 7:49 PM Local: 9:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 25, 5, 22, 0, false);          // UTC: 5:22 AM Local: 7:22 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 26, 15, 58, 0, false);         // UTC: 3:58 PM Local: 5:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 5, 6, 24, 0, false);           // UTC: 6:24 AM Local: 8:24 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 15, 22, 34, 0, false);         // UTC: 10:34 PM Local: 12:34 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 25, 19, 31, 0, false);         // UTC: 7:31 PM Local: 9:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 5, 9, 18, 0, false);           // UTC: 9:18 AM Local: 11:18 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 23, 18, 34, 0, false);         // UTC: 6:34 PM Local: 8:34 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 13, 17, 8, 0, false);          // UTC: 5:08 PM Local: 7:08 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 11, 16, 11, 36, 0, false);         // UTC: 11:36 AM Local: 1:36 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 12, 13, 20, 0, false);         // UTC: 1:20 PM Local: 3:20 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 4, 21, 50, 0, false);          // UTC: 9:50 PM Local: 11:50 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 1, 10, 30, 0, false);          // UTC: 10:30 AM Local: 12:30 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 3, 6, 42, 0, false);           // UTC: 6:42 AM Local: 8:42 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 22, 6, 12, 0, false);          // UTC: 6:12 AM Local: 8:12 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 20, 19, 14, 0, false);         // UTC: 7:14 PM Local: 9:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 20, 22, 35, 0, false);         // UTC: 10:35 PM Local: 12:35 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 19, 5, 41, 0, false);          // UTC: 5:41 AM Local: 7:41 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 19, 5, 1, 0, false);           // UTC: 5:01 AM Local: 7:01 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 8, 10, 27, 0, false);          // UTC: 10:27 AM Local: 12:27 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 7, 8, 9, 0, false);            // UTC: 8:09 AM Local: 10:09 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 11, 16, 39, 0, false);         // UTC: 4:39 PM Local: 6:39 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 2, 8, 2, 0, false);            // UTC: 8:02 AM Local: 10:02 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 20, 20, 22, 0, false);         // UTC: 8:22 PM Local: 10:22 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 1, 1, 6, 0, false);            // UTC: 1:06 AM Local: 3:06 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 16, 0, 30, 0, false);          // UTC: 12:30 AM Local: 2:30 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 10, 16, 54, 0, false);         // UTC: 4:54 PM Local: 6:54 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 25, 20, 32, 0, false);         // UTC: 8:32 PM Local: 10:32 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 1, 17, 20, 0, false);          // UTC: 5:20 PM Local: 7:20 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 18, 10, 40, 0, false);         // UTC: 10:40 AM Local: 12:40 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 23, 17, 57, 0, false);         // UTC: 5:57 PM Local: 7:57 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 2, 20, 55, 0, false);          // UTC: 8:55 PM Local: 10:55 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 16, 9, 33, 0, false);          // UTC: 9:33 AM Local: 11:33 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 15, 15, 26, 0, false);         // UTC: 3:26 PM Local: 5:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2019, 12, 6, 22, 5, 0, false);           // UTC: 10:05 PM Local: 12:05 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 6, 15, 10, 0, false);           // UTC: 3:10 PM Local: 5:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 16, 1, 12, 0, false);           // UTC: 1:12 AM Local: 3:12 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 14, 20, 43, 0, false);          // UTC: 8:43 PM Local: 10:43 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 15, 7, 28, 0, false);           // UTC: 7:28 AM Local: 9:28 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 17, 8, 58, 0, false);           // UTC: 8:58 AM Local: 10:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 9, 9, 54, 0, false);            // UTC: 9:54 AM Local: 11:54 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 10, 20, 6, 0, false);           // UTC: 8:06 PM Local: 10:06 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 11, 22, 11, 0, false);          // UTC: 10:11 PM Local: 12:11 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 5, 0, 36, 0, false);            // UTC: 12:36 AM Local: 2:36 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 26, 18, 3, 0, false);           // UTC: 6:03 PM Local: 8:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 13, 16, 53, 0, false);          // UTC: 4:53 PM Local: 6:53 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 13, 18, 5, 0, false);           // UTC: 6:05 PM Local: 8:05 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 5, 1, 22, 0, false);            // UTC: 1:22 AM Local: 3:22 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 13, 7, 50, 0, false);           // UTC: 7:50 AM Local: 9:50 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 7, 11, 32, 0, false);           // UTC: 11:32 AM Local: 1:32 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 13, 21, 3, 0, false);           // UTC: 9:03 PM Local: 11:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 16, 4, 13, 0, false);           // UTC: 4:13 AM Local: 6:13 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 15, 19, 4, 0, false);           // UTC: 7:04 PM Local: 9:04 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 27, 18, 40, 0, false);          // UTC: 6:40 PM Local: 8:40 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 27, 9, 3, 0, false);            // UTC: 9:03 AM Local: 11:03 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 16, 12, 5, 0, false);           // UTC: 12:05 PM Local: 2:05 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 19, 1, 35, 0, false);           // UTC: 1:35 AM Local: 3:35 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 16, 3, 32, 0, false);           // UTC: 3:32 AM Local: 5:32 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 25, 3, 22, 0, false);           // UTC: 3:22 AM Local: 5:22 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 1, 15, 20, 33, 0, false);          // UTC: 8:33 PM Local: 10:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 7, 3, 27, 0, false);            // UTC: 3:27 AM Local: 5:27 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 18, 16, 5, 0, false);           // UTC: 4:05 PM Local: 6:05 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 16, 8, 35, 0, false);           // UTC: 8:35 AM Local: 10:35 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 23, 21, 50, 0, false);          // UTC: 9:50 PM Local: 11:50 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 23, 10, 0, 0, false);           // UTC: 10:00 AM Local: 12:00 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 11, 4, 36, 0, false);           // UTC: 4:36 AM Local: 6:36 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 10, 20, 47, 0, false);          // UTC: 8:47 PM Local: 10:47 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 21, 12, 26, 0, false);          // UTC: 12:26 PM Local: 2:26 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 26, 20, 45, 0, false);          // UTC: 8:45 PM Local: 10:45 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 15, 15, 2, 0, false);           // UTC: 3:02 PM Local: 5:02 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 23, 22, 57, 0, false);          // UTC: 10:57 PM Local: 12:57 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 14, 17, 37, 0, false);          // UTC: 5:37 PM Local: 7:37 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 7, 8, 43, 0, false);            // UTC: 8:43 AM Local: 10:43 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 26, 0, 8, 0, false);            // UTC: 12:08 AM Local: 2:08 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 14, 20, 6, 0, false);           // UTC: 8:06 PM Local: 10:06 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 21, 17, 41, 0, false);          // UTC: 5:41 PM Local: 7:41 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 15, 11, 58, 0, false);          // UTC: 11:58 AM Local: 1:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 21, 4, 58, 0, false);           // UTC: 4:58 AM Local: 6:58 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 21, 10, 36, 0, false);          // UTC: 10:36 AM Local: 12:36 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 1, 15, 47, 0, false);           // UTC: 3:47 PM Local: 5:47 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 9, 0, 41, 0, false);            // UTC: 12:41 AM Local: 2:41 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 16, 22, 56, 0, false);          // UTC: 10:56 PM Local: 12:56 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 25, 7, 42, 0, false);           // UTC: 7:42 AM Local: 9:42 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 10, 3, 48, 0, false);           // UTC: 3:48 AM Local: 5:48 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 2, 24, 8, 50, 0, false);           // UTC: 8:50 AM Local: 10:50 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 18, 6, 39, 0, true);            // UTC: 6:39 AM Local: 9:39 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 9, 4, 8, 0, true);              // UTC: 4:08 AM Local: 7:08 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 2, 22, 10, 0, false);           // UTC: 10:10 PM Local: 12:10 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 2, 1, 46, 0, false);            // UTC: 1:46 AM Local: 3:46 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 27, 17, 15, 0, true);           // UTC: 5:15 PM Local: 8:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 1, 4, 39, 0, false);            // UTC: 4:39 AM Local: 6:39 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 26, 14, 58, 0, true);           // UTC: 2:58 PM Local: 5:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 12, 21, 53, 0, true);           // UTC: 9:53 PM Local: 12:53 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 5, 19, 25, 0, false);           // UTC: 7:25 PM Local: 9:25 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 27, 4, 19, 0, true);            // UTC: 4:19 AM Local: 7:19 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 5, 20, 48, 0, false);           // UTC: 8:48 PM Local: 10:48 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 4, 2, 10, 0, false);            // UTC: 2:10 AM Local: 4:10 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 26, 15, 27, 0, true);           // UTC: 3:27 PM Local: 6:27 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 18, 6, 3, 0, true);             // UTC: 6:03 AM Local: 9:03 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 15, 11, 52, 0, true);           // UTC: 11:52 AM Local: 2:52 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 5, 20, 34, 0, false);           // UTC: 8:34 PM Local: 10:34 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 13, 7, 57, 0, true);            // UTC: 7:57 AM Local: 10:57 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 5, 22, 44, 0, false);           // UTC: 10:44 PM Local: 12:44 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 24, 4, 21, 0, true);            // UTC: 4:21 AM Local: 7:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 21, 3, 20, 0, true);            // UTC: 3:20 AM Local: 6:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 20, 1, 46, 0, true);            // UTC: 1:46 AM Local: 4:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 24, 20, 12, 0, true);           // UTC: 8:12 PM Local: 11:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 27, 19, 36, 0, true);           // UTC: 7:36 PM Local: 10:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 3, 1, 30, 0, false);            // UTC: 1:30 AM Local: 3:30 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 3, 6, 6, 20, 0, false);            // UTC: 6:20 AM Local: 8:20 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 25, 21, 25, 0, true);           // UTC: 9:25 PM Local: 12:25 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 1, 22, 56, 0, true);            // UTC: 10:56 PM Local: 1:56 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 23, 12, 49, 0, true);           // UTC: 12:49 PM Local: 3:49 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 10, 22, 54, 0, true);           // UTC: 10:54 PM Local: 1:54 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 2, 5, 54, 0, true);             // UTC: 5:54 AM Local: 8:54 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 23, 3, 30, 0, true);            // UTC: 3:30 AM Local: 6:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 4, 21, 12, 0, true);            // UTC: 9:12 PM Local: 12:12 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 8, 15, 34, 0, true);            // UTC: 3:34 PM Local: 6:34 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 19, 4, 2, 0, true);             // UTC: 4:02 AM Local: 7:02 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 27, 8, 16, 0, true);            // UTC: 8:16 AM Local: 11:16 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 13, 22, 40, 0, true);           // UTC: 10:40 PM Local: 1:40 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 11, 21, 16, 0, true);           // UTC: 9:16 PM Local: 12:16 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 25, 17, 10, 0, true);           // UTC: 5:10 PM Local: 8:10 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 11, 20, 30, 0, true);           // UTC: 8:30 PM Local: 11:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 26, 11, 54, 0, true);           // UTC: 11:54 AM Local: 2:54 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 8, 20, 36, 0, true);            // UTC: 8:36 PM Local: 11:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 19, 6, 53, 0, true);            // UTC: 6:53 AM Local: 9:53 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 27, 1, 19, 0, true);            // UTC: 1:19 AM Local: 4:19 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 4, 15, 14, 0, true);            // UTC: 3:14 PM Local: 6:14 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 23, 7, 47, 0, true);            // UTC: 7:47 AM Local: 10:47 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 25, 20, 10, 0, true);           // UTC: 8:10 PM Local: 11:10 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 16, 20, 1, 0, true);            // UTC: 8:01 PM Local: 11:01 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 7, 15, 17, 0, true);            // UTC: 3:17 PM Local: 6:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 18, 20, 24, 0, true);           // UTC: 8:24 PM Local: 11:24 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 4, 10, 16, 3, 0, true);            // UTC: 4:03 PM Local: 7:03 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 19, 7, 9, 0, true);             // UTC: 7:09 AM Local: 10:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 18, 9, 17, 0, true);            // UTC: 9:17 AM Local: 12:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 12, 6, 6, 0, true);             // UTC: 6:06 AM Local: 9:06 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 11, 10, 52, 0, true);           // UTC: 10:52 AM Local: 1:52 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 10, 6, 17, 0, true);            // UTC: 6:17 AM Local: 9:17 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 1, 1, 25, 0, true);             // UTC: 1:25 AM Local: 4:25 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 10, 11, 0, 0, true);            // UTC: 11:00 AM Local: 2:00 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 10, 8, 35, 0, true);            // UTC: 8:35 AM Local: 11:35 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 25, 1, 13, 0, true);            // UTC: 1:13 AM Local: 4:13 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 9, 1, 21, 0, true);             // UTC: 1:21 AM Local: 4:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 14, 14, 21, 0, true);           // UTC: 2:21 PM Local: 5:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 8, 9, 19, 0, true);             // UTC: 9:19 AM Local: 12:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 3, 4, 54, 0, true);             // UTC: 4:54 AM Local: 7:54 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 14, 10, 35, 0, true);           // UTC: 10:35 AM Local: 1:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 3, 4, 26, 0, true);             // UTC: 4:26 AM Local: 7:26 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 4, 20, 22, 0, true);            // UTC: 8:22 PM Local: 11:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 1, 13, 48, 0, true);            // UTC: 1:48 PM Local: 4:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 27, 22, 12, 0, true);           // UTC: 10:12 PM Local: 1:12 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 2, 8, 54, 0, true);             // UTC: 8:54 AM Local: 11:54 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 16, 17, 20, 0, true);           // UTC: 5:20 PM Local: 8:20 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 2, 2, 12, 0, true);             // UTC: 2:12 AM Local: 5:12 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 20, 20, 47, 0, true);           // UTC: 8:47 PM Local: 11:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 15, 1, 50, 0, true);            // UTC: 1:50 AM Local: 4:50 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 26, 21, 52, 0, true);           // UTC: 9:52 PM Local: 12:52 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 5, 14, 19, 1, 0, true);            // UTC: 7:01 PM Local: 10:01 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 11, 6, 11, 0, true);            // UTC: 6:11 AM Local: 9:11 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 5, 17, 10, 0, true);            // UTC: 5:10 PM Local: 8:10 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 24, 7, 27, 0, true);            // UTC: 7:27 AM Local: 10:27 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 15, 12, 39, 0, true);           // UTC: 12:39 PM Local: 3:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 4, 5, 4, 0, true);              // UTC: 5:04 AM Local: 8:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 12, 12, 24, 0, true);           // UTC: 12:24 PM Local: 3:24 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 16, 10, 21, 0, true);           // UTC: 10:21 AM Local: 1:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 11, 7, 18, 0, true);            // UTC: 7:18 AM Local: 10:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 18, 14, 47, 0, true);           // UTC: 2:47 PM Local: 5:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 15, 1, 38, 0, true);            // UTC: 1:38 AM Local: 4:38 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 26, 10, 7, 0, true);            // UTC: 10:07 AM Local: 1:07 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 6, 15, 5, 0, true);             // UTC: 3:05 PM Local: 6:05 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 20, 9, 0, 0, true);             // UTC: 9:00 AM Local: 12:00 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 5, 4, 47, 0, true);             // UTC: 4:47 AM Local: 7:47 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 21, 4, 21, 0, true);            // UTC: 4:21 AM Local: 7:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 4, 8, 49, 0, true);             // UTC: 8:49 AM Local: 11:49 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 22, 12, 24, 0, true);           // UTC: 12:24 PM Local: 3:24 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 13, 21, 22, 0, true);           // UTC: 9:22 PM Local: 12:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 18, 22, 54, 0, true);           // UTC: 10:54 PM Local: 1:54 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 24, 12, 8, 0, true);            // UTC: 12:08 PM Local: 3:08 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 10, 7, 15, 0, true);            // UTC: 7:15 AM Local: 10:15 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 22, 13, 3, 0, true);            // UTC: 1:03 PM Local: 4:03 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 15, 21, 33, 0, true);           // UTC: 9:33 PM Local: 12:33 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 27, 15, 7, 0, true);            // UTC: 3:07 PM Local: 6:07 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 6, 11, 9, 15, 0, true);            // UTC: 9:15 AM Local: 12:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 16, 14, 8, 0, true);            // UTC: 2:08 PM Local: 5:08 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 26, 11, 13, 0, true);           // UTC: 11:13 AM Local: 2:13 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 27, 16, 29, 0, true);           // UTC: 4:29 PM Local: 7:29 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 7, 10, 31, 0, true);            // UTC: 10:31 AM Local: 1:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 20, 12, 38, 0, true);           // UTC: 12:38 PM Local: 3:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 5, 19, 51, 0, true);            // UTC: 7:51 PM Local: 10:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 24, 18, 51, 0, true);           // UTC: 6:51 PM Local: 9:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 15, 21, 35, 0, true);           // UTC: 9:35 PM Local: 12:35 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 8, 13, 25, 0, true);            // UTC: 1:25 PM Local: 4:25 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 8, 18, 51, 0, true);            // UTC: 6:51 PM Local: 9:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 8, 1, 30, 0, true);             // UTC: 1:30 AM Local: 4:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 4, 2, 20, 0, true);             // UTC: 2:20 AM Local: 5:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 22, 21, 1, 0, true);            // UTC: 9:01 PM Local: 12:01 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 25, 9, 35, 0, true);            // UTC: 9:35 AM Local: 12:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 21, 12, 7, 0, true);            // UTC: 12:07 PM Local: 3:07 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 15, 18, 23, 0, true);           // UTC: 6:23 PM Local: 9:23 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 25, 18, 48, 0, true);           // UTC: 6:48 PM Local: 9:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 7, 12, 35, 0, true);            // UTC: 12:35 PM Local: 3:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 11, 0, 41, 0, true);            // UTC: 12:41 AM Local: 3:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 15, 15, 53, 0, true);           // UTC: 3:53 PM Local: 6:53 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 22, 15, 54, 0, true);           // UTC: 3:54 PM Local: 6:54 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 18, 21, 24, 0, true);           // UTC: 9:24 PM Local: 12:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 1, 14, 26, 0, true);            // UTC: 2:26 PM Local: 5:26 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 9, 8, 54, 0, true);             // UTC: 8:54 AM Local: 11:54 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 7, 23, 22, 24, 0, true);           // UTC: 10:24 PM Local: 1:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 8, 18, 22, 0, true);            // UTC: 6:22 PM Local: 9:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 13, 17, 46, 0, true);           // UTC: 5:46 PM Local: 8:46 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 1, 8, 58, 0, true);             // UTC: 8:58 AM Local: 11:58 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 2, 0, 31, 0, true);             // UTC: 12:31 AM Local: 3:31 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 26, 16, 5, 0, true);            // UTC: 4:05 PM Local: 7:05 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 18, 5, 15, 0, true);            // UTC: 5:15 AM Local: 8:15 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 4, 2, 41, 0, true);             // UTC: 2:41 AM Local: 5:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 19, 2, 36, 0, true);            // UTC: 2:36 AM Local: 5:36 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 20, 12, 11, 0, true);           // UTC: 12:11 PM Local: 3:11 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 27, 13, 27, 0, true);           // UTC: 1:27 PM Local: 4:27 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 25, 9, 32, 0, true);            // UTC: 9:32 AM Local: 12:32 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 5, 2, 13, 0, true);             // UTC: 2:13 AM Local: 5:13 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 9, 1, 53, 0, true);             // UTC: 1:53 AM Local: 4:53 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 3, 18, 19, 0, true);            // UTC: 6:19 PM Local: 9:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 26, 13, 53, 0, true);           // UTC: 1:53 PM Local: 4:53 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 24, 1, 52, 0, true);            // UTC: 1:52 AM Local: 4:52 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 10, 15, 6, 0, true);            // UTC: 3:06 PM Local: 6:06 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 18, 16, 51, 0, true);           // UTC: 4:51 PM Local: 7:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 20, 13, 39, 0, true);           // UTC: 1:39 PM Local: 4:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 21, 17, 13, 0, true);           // UTC: 5:13 PM Local: 8:13 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 17, 1, 45, 0, true);            // UTC: 1:45 AM Local: 4:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 15, 3, 37, 0, true);            // UTC: 3:37 AM Local: 6:37 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 27, 17, 35, 0, true);           // UTC: 5:35 PM Local: 8:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 24, 7, 10, 0, true);            // UTC: 7:10 AM Local: 10:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 8, 10, 0, 18, 0, true);            // UTC: 12:18 AM Local: 3:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 11, 16, 30, 0, true);           // UTC: 4:30 PM Local: 7:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 20, 19, 27, 0, true);           // UTC: 7:27 PM Local: 10:27 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 9, 14, 54, 0, true);            // UTC: 2:54 PM Local: 5:54 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 10, 5, 40, 0, true);            // UTC: 5:40 AM Local: 8:40 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 19, 10, 30, 0, true);           // UTC: 10:30 AM Local: 1:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 15, 12, 18, 0, true);           // UTC: 12:18 PM Local: 3:18 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 19, 11, 42, 0, true);           // UTC: 11:42 AM Local: 2:42 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 16, 9, 27, 0, true);            // UTC: 9:27 AM Local: 12:27 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 8, 20, 19, 0, true);            // UTC: 8:19 PM Local: 11:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 8, 11, 20, 0, true);            // UTC: 11:20 AM Local: 2:20 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 25, 7, 41, 0, true);            // UTC: 7:41 AM Local: 10:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 16, 7, 51, 0, true);            // UTC: 7:51 AM Local: 10:51 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 5, 1, 53, 0, true);             // UTC: 1:53 AM Local: 4:53 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 21, 6, 26, 0, true);            // UTC: 6:26 AM Local: 9:26 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 23, 3, 52, 0, true);            // UTC: 3:52 AM Local: 6:52 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 26, 7, 15, 0, true);            // UTC: 7:15 AM Local: 10:15 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 3, 7, 46, 0, true);             // UTC: 7:46 AM Local: 10:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 24, 15, 30, 0, true);           // UTC: 3:30 PM Local: 6:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 16, 18, 17, 0, true);           // UTC: 6:17 PM Local: 9:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 2, 10, 56, 0, true);            // UTC: 10:56 AM Local: 1:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 4, 0, 7, 0, true);              // UTC: 12:07 AM Local: 3:07 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 16, 9, 55, 0, true);            // UTC: 9:55 AM Local: 12:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 27, 2, 8, 0, true);             // UTC: 2:08 AM Local: 5:08 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 18, 9, 28, 0, true);            // UTC: 9:28 AM Local: 12:28 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 9, 12, 21, 12, 0, true);           // UTC: 9:12 PM Local: 12:12 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 8, 16, 15, 0, true);           // UTC: 4:15 PM Local: 7:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 16, 7, 34, 0, true);           // UTC: 7:34 AM Local: 10:34 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 2, 4, 10, 0, true);            // UTC: 4:10 AM Local: 7:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 16, 1, 37, 0, true);           // UTC: 1:37 AM Local: 4:37 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 6, 22, 31, 0, true);           // UTC: 10:31 PM Local: 1:31 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 16, 2, 35, 0, true);           // UTC: 2:35 AM Local: 5:35 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 26, 14, 15, 0, true);          // UTC: 2:15 PM Local: 5:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 9, 5, 43, 0, true);            // UTC: 5:43 AM Local: 8:43 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 26, 22, 11, 0, true);          // UTC: 10:11 PM Local: 1:11 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 4, 10, 53, 0, true);           // UTC: 10:53 AM Local: 1:53 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 8, 10, 44, 0, true);           // UTC: 10:44 AM Local: 1:44 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 8, 6, 4, 0, true);             // UTC: 6:04 AM Local: 9:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 2, 11, 8, 0, true);            // UTC: 11:08 AM Local: 2:08 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 11, 1, 49, 0, true);           // UTC: 1:49 AM Local: 4:49 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 26, 0, 22, 0, true);           // UTC: 12:22 AM Local: 3:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 9, 18, 7, 0, true);            // UTC: 6:07 PM Local: 9:07 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 17, 1, 18, 0, true);           // UTC: 1:18 AM Local: 4:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 24, 11, 17, 0, true);          // UTC: 11:17 AM Local: 2:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 26, 22, 28, 0, true);          // UTC: 10:28 PM Local: 1:28 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 15, 13, 20, 0, true);          // UTC: 1:20 PM Local: 4:20 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 11, 21, 44, 0, true);          // UTC: 9:44 PM Local: 12:44 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 8, 5, 36, 0, true);            // UTC: 5:36 AM Local: 8:36 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 24, 20, 40, 0, true);          // UTC: 8:40 PM Local: 11:40 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 13, 12, 35, 0, true);          // UTC: 12:35 PM Local: 3:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 10, 13, 12, 33, 0, true);          // UTC: 12:33 PM Local: 3:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 12, 8, 12, 0, false);          // UTC: 8:12 AM Local: 10:12 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 10, 15, 9, 0, false);          // UTC: 3:09 PM Local: 5:09 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 2, 12, 22, 0, false);          // UTC: 12:22 PM Local: 2:22 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 16, 9, 56, 0, false);          // UTC: 9:56 AM Local: 11:56 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 13, 7, 20, 0, false);          // UTC: 7:20 AM Local: 9:20 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 16, 12, 52, 0, false);         // UTC: 12:52 PM Local: 2:52 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 22, 22, 8, 0, false);          // UTC: 10:08 PM Local: 12:08 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 3, 15, 45, 0, false);          // UTC: 3:45 PM Local: 5:45 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 21, 9, 53, 0, false);          // UTC: 9:53 AM Local: 11:53 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 13, 3, 31, 0, false);          // UTC: 3:31 AM Local: 5:31 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 20, 9, 55, 0, false);          // UTC: 9:55 AM Local: 11:55 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 20, 12, 34, 0, false);         // UTC: 12:34 PM Local: 2:34 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 8, 3, 55, 0, false);           // UTC: 3:55 AM Local: 5:55 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 5, 7, 23, 0, false);           // UTC: 7:23 AM Local: 9:23 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 11, 15, 49, 0, false);         // UTC: 3:49 PM Local: 5:49 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 18, 10, 32, 0, false);         // UTC: 10:32 AM Local: 12:32 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 10, 20, 0, 0, false);          // UTC: 8:00 PM Local: 10:00 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 20, 15, 32, 0, false);         // UTC: 3:32 PM Local: 5:32 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 12, 7, 41, 0, false);          // UTC: 7:41 AM Local: 9:41 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 12, 13, 14, 0, false);         // UTC: 1:14 PM Local: 3:14 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 8, 14, 22, 0, false);          // UTC: 2:22 PM Local: 4:22 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 23, 20, 0, 0, false);          // UTC: 8:00 PM Local: 10:00 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 1, 16, 46, 0, false);          // UTC: 4:46 PM Local: 6:46 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 21, 7, 21, 0, false);          // UTC: 7:21 AM Local: 9:21 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 11, 26, 14, 40, 0, false);         // UTC: 2:40 PM Local: 4:40 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 20, 16, 58, 0, false);         // UTC: 4:58 PM Local: 6:58 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 26, 2, 57, 0, false);          // UTC: 2:57 AM Local: 4:57 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 10, 2, 15, 0, false);          // UTC: 2:15 AM Local: 4:15 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 15, 22, 43, 0, false);         // UTC: 10:43 PM Local: 12:43 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 11, 7, 12, 0, false);          // UTC: 7:12 AM Local: 9:12 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 24, 19, 33, 0, false);         // UTC: 7:33 PM Local: 9:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 19, 21, 40, 0, false);         // UTC: 9:40 PM Local: 11:40 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 1, 12, 47, 0, false);          // UTC: 12:47 PM Local: 2:47 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 23, 14, 42, 0, false);         // UTC: 2:42 PM Local: 4:42 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 21, 13, 33, 0, false);         // UTC: 1:33 PM Local: 3:33 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 18, 18, 3, 0, false);          // UTC: 6:03 PM Local: 8:03 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 24, 15, 36, 0, false);         // UTC: 3:36 PM Local: 5:36 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 20, 11, 28, 0, false);         // UTC: 11:28 AM Local: 1:28 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 8, 21, 30, 0, false);          // UTC: 9:30 PM Local: 11:30 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 4, 7, 52, 0, false);           // UTC: 7:52 AM Local: 9:52 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 8, 14, 23, 0, false);          // UTC: 2:23 PM Local: 4:23 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 16, 20, 28, 0, false);         // UTC: 8:28 PM Local: 10:28 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 22, 5, 41, 0, false);          // UTC: 5:41 AM Local: 7:41 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 27, 16, 10, 0, false);         // UTC: 4:10 PM Local: 6:10 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 6, 2, 28, 0, false);           // UTC: 2:28 AM Local: 4:28 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 7, 13, 31, 0, false);          // UTC: 1:31 PM Local: 3:31 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 20, 20, 12, 0, false);         // UTC: 8:12 PM Local: 10:12 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 18, 11, 37, 0, false);         // UTC: 11:37 AM Local: 1:37 AM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 17, 3, 18, 0, false);          // UTC: 3:18 AM Local: 5:18 PM Offset: -10:00:00
	testCount++; failedCount += test(timeManager, 1, 2020, 12, 3, 9, 0, 0, false);            // UTC: 9:00 AM Local: 11:00 PM Offset: -10:00:00

	Serial.println(); Serial.print(failedCount); Serial.print(" of "); Serial.print(testCount); Serial.println(" test(s) failed.");
}
#endif
