#ifndef TEST_TIMEZONEID_0_H
#define TEST_TIMEZONEID_0_H

#include "TimeManager.h"
#include "TestHelper.h"

void run_TimeZoneId_0_Tests(const TimeManager& timeManager)
{
	uint16_t testCount = 0;
	uint16_t failedCount = 0;

	testCount++; failedCount += test(timeManager, 0, 2018, 1, 1, 1, 31, 0, false);            // UTC: 1:31 AM Local: 4:31 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 5, 19, 37, 0, false);           // UTC: 7:37 PM Local: 10:37 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 14, 21, 12, 0, false);          // UTC: 9:12 PM Local: 12:12 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 13, 12, 44, 0, false);          // UTC: 12:44 PM Local: 3:44 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 16, 15, 53, 0, false);          // UTC: 3:53 PM Local: 6:53 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 4, 11, 15, 0, false);           // UTC: 11:15 AM Local: 2:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 1, 5, 20, 0, false);            // UTC: 5:20 AM Local: 8:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 20, 20, 12, 0, false);          // UTC: 8:12 PM Local: 11:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 7, 21, 25, 0, false);           // UTC: 9:25 PM Local: 12:25 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 15, 3, 18, 0, false);           // UTC: 3:18 AM Local: 6:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 7, 21, 24, 0, false);           // UTC: 9:24 PM Local: 12:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 25, 14, 39, 0, false);          // UTC: 2:39 PM Local: 5:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 13, 1, 18, 0, false);           // UTC: 1:18 AM Local: 4:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 8, 15, 43, 0, false);           // UTC: 3:43 PM Local: 6:43 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 19, 8, 2, 0, false);            // UTC: 8:02 AM Local: 11:02 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 10, 16, 36, 0, false);          // UTC: 4:36 PM Local: 7:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 27, 0, 24, 0, false);           // UTC: 12:24 AM Local: 3:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 9, 22, 32, 0, false);           // UTC: 10:32 PM Local: 1:32 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 12, 6, 11, 0, false);           // UTC: 6:11 AM Local: 9:11 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 9, 21, 53, 0, false);           // UTC: 9:53 PM Local: 12:53 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 6, 22, 44, 0, false);           // UTC: 10:44 PM Local: 1:44 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 25, 5, 37, 0, false);           // UTC: 5:37 AM Local: 8:37 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 10, 14, 3, 0, false);           // UTC: 2:03 PM Local: 5:03 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 7, 15, 26, 0, false);           // UTC: 3:26 PM Local: 6:26 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 1, 26, 16, 33, 0, false);          // UTC: 4:33 PM Local: 7:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 17, 1, 30, 0, false);           // UTC: 1:30 AM Local: 4:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 5, 20, 14, 0, false);           // UTC: 8:14 PM Local: 11:14 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 22, 12, 7, 0, false);           // UTC: 12:07 PM Local: 3:07 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 25, 20, 55, 0, false);          // UTC: 8:55 PM Local: 11:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 24, 11, 21, 0, false);          // UTC: 11:21 AM Local: 2:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 13, 3, 7, 0, false);            // UTC: 3:07 AM Local: 6:07 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 12, 1, 41, 0, false);           // UTC: 1:41 AM Local: 4:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 27, 17, 8, 0, false);           // UTC: 5:08 PM Local: 8:08 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 11, 0, 3, 0, false);            // UTC: 12:03 AM Local: 3:03 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 16, 17, 21, 0, false);          // UTC: 5:21 PM Local: 8:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 27, 8, 15, 0, false);           // UTC: 8:15 AM Local: 11:15 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 27, 18, 12, 0, false);          // UTC: 6:12 PM Local: 9:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 19, 3, 3, 0, false);            // UTC: 3:03 AM Local: 6:03 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 18, 9, 25, 0, false);           // UTC: 9:25 AM Local: 12:25 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 17, 0, 18, 0, false);           // UTC: 12:18 AM Local: 3:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 19, 10, 8, 0, false);           // UTC: 10:08 AM Local: 1:08 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 19, 17, 31, 0, false);          // UTC: 5:31 PM Local: 8:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 9, 12, 37, 0, false);           // UTC: 12:37 PM Local: 3:37 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 24, 14, 17, 0, false);          // UTC: 2:17 PM Local: 5:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 11, 17, 50, 0, false);          // UTC: 5:50 PM Local: 8:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 5, 5, 46, 0, false);            // UTC: 5:46 AM Local: 8:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 21, 21, 31, 0, false);          // UTC: 9:31 PM Local: 12:31 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 18, 20, 40, 0, false);          // UTC: 8:40 PM Local: 11:40 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 5, 17, 58, 0, false);           // UTC: 5:58 PM Local: 8:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 2, 2, 17, 40, 0, false);           // UTC: 5:40 PM Local: 8:40 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 8, 8, 45, 0, false);            // UTC: 8:45 AM Local: 11:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 23, 16, 33, 0, false);          // UTC: 4:33 PM Local: 7:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 26, 20, 58, 0, false);          // UTC: 8:58 PM Local: 11:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 23, 15, 49, 0, false);          // UTC: 3:49 PM Local: 6:49 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 18, 2, 10, 0, false);           // UTC: 2:10 AM Local: 5:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 25, 7, 22, 0, false);           // UTC: 7:22 AM Local: 10:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 6, 11, 9, 0, false);            // UTC: 11:09 AM Local: 2:09 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 18, 19, 5, 0, false);           // UTC: 7:05 PM Local: 10:05 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 22, 0, 34, 0, false);           // UTC: 12:34 AM Local: 3:34 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 13, 12, 58, 0, false);          // UTC: 12:58 PM Local: 3:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 15, 5, 46, 0, false);           // UTC: 5:46 AM Local: 8:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 26, 13, 15, 0, false);          // UTC: 1:15 PM Local: 4:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 15, 12, 4, 0, false);           // UTC: 12:04 PM Local: 3:04 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 8, 5, 21, 0, false);            // UTC: 5:21 AM Local: 8:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 22, 21, 15, 0, false);          // UTC: 9:15 PM Local: 12:15 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 19, 0, 44, 0, false);           // UTC: 12:44 AM Local: 3:44 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 14, 5, 26, 0, false);           // UTC: 5:26 AM Local: 8:26 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 17, 19, 15, 0, false);          // UTC: 7:15 PM Local: 10:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 15, 14, 30, 0, false);          // UTC: 2:30 PM Local: 5:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 19, 0, 39, 0, false);           // UTC: 12:39 AM Local: 3:39 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 27, 10, 19, 0, false);          // UTC: 10:19 AM Local: 1:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 27, 6, 24, 0, false);           // UTC: 6:24 AM Local: 9:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 2, 15, 31, 0, false);           // UTC: 3:31 PM Local: 6:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 25, 8, 45, 0, false);           // UTC: 8:45 AM Local: 11:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 3, 9, 20, 13, 0, false);           // UTC: 8:13 PM Local: 11:13 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 22, 19, 52, 0, false);          // UTC: 7:52 PM Local: 10:52 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 23, 1, 0, 0, false);            // UTC: 1:00 AM Local: 4:00 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 23, 21, 18, 0, false);          // UTC: 9:18 PM Local: 12:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 15, 21, 22, 0, false);          // UTC: 9:22 PM Local: 12:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 15, 9, 58, 0, false);           // UTC: 9:58 AM Local: 12:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 21, 19, 30, 0, false);          // UTC: 7:30 PM Local: 10:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 11, 7, 46, 0, false);           // UTC: 7:46 AM Local: 10:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 1, 18, 39, 0, false);           // UTC: 6:39 PM Local: 9:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 23, 15, 20, 0, false);          // UTC: 3:20 PM Local: 6:20 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 7, 13, 50, 0, false);           // UTC: 1:50 PM Local: 4:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 19, 7, 56, 0, false);           // UTC: 7:56 AM Local: 10:56 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 2, 16, 45, 0, false);           // UTC: 4:45 PM Local: 7:45 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 17, 19, 56, 0, false);          // UTC: 7:56 PM Local: 10:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 18, 3, 30, 0, false);           // UTC: 3:30 AM Local: 6:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 1, 10, 21, 0, false);           // UTC: 10:21 AM Local: 1:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 1, 12, 14, 0, false);           // UTC: 12:14 PM Local: 3:14 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 15, 3, 31, 0, false);           // UTC: 3:31 AM Local: 6:31 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 7, 20, 34, 0, false);           // UTC: 8:34 PM Local: 11:34 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 12, 17, 2, 0, false);           // UTC: 5:02 PM Local: 8:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 7, 22, 25, 0, false);           // UTC: 10:25 PM Local: 1:25 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 18, 14, 21, 0, false);          // UTC: 2:21 PM Local: 5:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 13, 19, 35, 0, false);          // UTC: 7:35 PM Local: 10:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 12, 11, 41, 0, false);          // UTC: 11:41 AM Local: 2:41 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 6, 2, 0, 0, false);             // UTC: 2:00 AM Local: 5:00 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 4, 16, 17, 11, 0, false);          // UTC: 5:11 PM Local: 8:11 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 8, 22, 19, 0, false);           // UTC: 10:19 PM Local: 1:19 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 9, 18, 7, 0, false);            // UTC: 6:07 PM Local: 9:07 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 3, 15, 24, 0, false);           // UTC: 3:24 PM Local: 6:24 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 9, 10, 24, 0, false);           // UTC: 10:24 AM Local: 1:24 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 10, 13, 55, 0, false);          // UTC: 1:55 PM Local: 4:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 20, 9, 50, 0, false);           // UTC: 9:50 AM Local: 12:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 15, 22, 30, 0, false);          // UTC: 10:30 PM Local: 1:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 5, 13, 37, 0, false);           // UTC: 1:37 PM Local: 4:37 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 21, 13, 2, 0, false);           // UTC: 1:02 PM Local: 4:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 15, 7, 2, 0, false);            // UTC: 7:02 AM Local: 10:02 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 14, 15, 9, 0, false);           // UTC: 3:09 PM Local: 6:09 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 11, 4, 45, 0, false);           // UTC: 4:45 AM Local: 7:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 20, 21, 10, 0, false);          // UTC: 9:10 PM Local: 12:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 9, 13, 54, 0, false);           // UTC: 1:54 PM Local: 4:54 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 26, 3, 23, 0, false);           // UTC: 3:23 AM Local: 6:23 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 6, 1, 52, 0, false);            // UTC: 1:52 AM Local: 4:52 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 21, 11, 43, 0, false);          // UTC: 11:43 AM Local: 2:43 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 5, 0, 44, 0, false);            // UTC: 12:44 AM Local: 3:44 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 18, 2, 24, 0, false);           // UTC: 2:24 AM Local: 5:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 20, 12, 11, 0, false);          // UTC: 12:11 PM Local: 3:11 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 3, 12, 21, 0, false);           // UTC: 12:21 PM Local: 3:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 11, 18, 45, 0, false);          // UTC: 6:45 PM Local: 9:45 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 7, 21, 24, 0, false);           // UTC: 9:24 PM Local: 12:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 5, 0, 27, 0, false);            // UTC: 12:27 AM Local: 3:27 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 5, 19, 5, 24, 0, false);           // UTC: 5:24 AM Local: 8:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 17, 4, 25, 0, false);           // UTC: 4:25 AM Local: 7:25 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 7, 13, 31, 0, false);           // UTC: 1:31 PM Local: 4:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 5, 17, 49, 0, false);           // UTC: 5:49 PM Local: 8:49 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 9, 8, 37, 0, false);            // UTC: 8:37 AM Local: 11:37 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 11, 17, 3, 0, false);           // UTC: 5:03 PM Local: 8:03 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 10, 0, 23, 0, false);           // UTC: 12:23 AM Local: 3:23 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 27, 5, 0, 0, false);            // UTC: 5:00 AM Local: 8:00 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 16, 13, 19, 0, false);          // UTC: 1:19 PM Local: 4:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 17, 21, 6, 0, false);           // UTC: 9:06 PM Local: 12:06 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 13, 13, 28, 0, false);          // UTC: 1:28 PM Local: 4:28 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 8, 11, 48, 0, false);           // UTC: 11:48 AM Local: 2:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 10, 1, 54, 0, false);           // UTC: 1:54 AM Local: 4:54 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 27, 10, 56, 0, false);          // UTC: 10:56 AM Local: 1:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 18, 21, 46, 0, false);          // UTC: 9:46 PM Local: 12:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 15, 1, 26, 0, false);           // UTC: 1:26 AM Local: 4:26 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 4, 19, 12, 0, false);           // UTC: 7:12 PM Local: 10:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 10, 18, 58, 0, false);          // UTC: 6:58 PM Local: 9:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 2, 15, 58, 0, false);           // UTC: 3:58 PM Local: 6:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 12, 0, 36, 0, false);           // UTC: 12:36 AM Local: 3:36 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 3, 14, 38, 0, false);           // UTC: 2:38 PM Local: 5:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 12, 16, 10, 0, false);          // UTC: 4:10 PM Local: 7:10 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 10, 0, 50, 0, false);           // UTC: 12:50 AM Local: 3:50 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 22, 1, 40, 0, false);           // UTC: 1:40 AM Local: 4:40 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 4, 8, 31, 0, false);            // UTC: 8:31 AM Local: 11:31 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 6, 13, 7, 18, 0, false);           // UTC: 7:18 AM Local: 10:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 6, 0, 30, 0, false);            // UTC: 12:30 AM Local: 3:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 24, 11, 3, 0, false);           // UTC: 11:03 AM Local: 2:03 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 25, 2, 45, 0, false);           // UTC: 2:45 AM Local: 5:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 14, 4, 46, 0, false);           // UTC: 4:46 AM Local: 7:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 23, 21, 1, 0, false);           // UTC: 9:01 PM Local: 12:01 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 9, 20, 50, 0, false);           // UTC: 8:50 PM Local: 11:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 9, 5, 12, 0, false);            // UTC: 5:12 AM Local: 8:12 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 17, 4, 2, 0, false);            // UTC: 4:02 AM Local: 7:02 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 16, 7, 48, 0, false);           // UTC: 7:48 AM Local: 10:48 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 15, 5, 26, 0, false);           // UTC: 5:26 AM Local: 8:26 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 13, 14, 22, 0, false);          // UTC: 2:22 PM Local: 5:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 19, 4, 58, 0, false);           // UTC: 4:58 AM Local: 7:58 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 3, 5, 7, 0, false);             // UTC: 5:07 AM Local: 8:07 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 16, 12, 35, 0, false);          // UTC: 12:35 PM Local: 3:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 11, 19, 48, 0, false);          // UTC: 7:48 PM Local: 10:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 2, 22, 7, 0, false);            // UTC: 10:07 PM Local: 1:07 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 18, 19, 28, 0, false);          // UTC: 7:28 PM Local: 10:28 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 19, 3, 5, 0, false);            // UTC: 3:05 AM Local: 6:05 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 3, 13, 50, 0, false);           // UTC: 1:50 PM Local: 4:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 13, 6, 9, 0, false);            // UTC: 6:09 AM Local: 9:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 7, 8, 51, 0, false);            // UTC: 8:51 AM Local: 11:51 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 9, 0, 34, 0, false);            // UTC: 12:34 AM Local: 3:34 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 12, 3, 41, 0, false);           // UTC: 3:41 AM Local: 6:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 1, 4, 38, 0, false);            // UTC: 4:38 AM Local: 7:38 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 7, 20, 16, 41, 0, false);          // UTC: 4:41 PM Local: 7:41 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 17, 4, 18, 0, false);           // UTC: 4:18 AM Local: 7:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 6, 12, 19, 0, false);           // UTC: 12:19 PM Local: 3:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 19, 19, 22, 0, false);          // UTC: 7:22 PM Local: 10:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 27, 17, 28, 0, false);          // UTC: 5:28 PM Local: 8:28 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 8, 13, 35, 0, false);           // UTC: 1:35 PM Local: 4:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 4, 14, 55, 0, false);           // UTC: 2:55 PM Local: 5:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 26, 7, 9, 0, false);            // UTC: 7:09 AM Local: 10:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 20, 1, 48, 0, false);           // UTC: 1:48 AM Local: 4:48 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 7, 14, 50, 0, false);           // UTC: 2:50 PM Local: 5:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 12, 14, 37, 0, false);          // UTC: 2:37 PM Local: 5:37 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 23, 21, 23, 0, false);          // UTC: 9:23 PM Local: 12:23 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 11, 11, 23, 0, false);          // UTC: 11:23 AM Local: 2:23 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 15, 6, 45, 0, false);           // UTC: 6:45 AM Local: 9:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 23, 13, 30, 0, false);          // UTC: 1:30 PM Local: 4:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 14, 8, 14, 0, false);           // UTC: 8:14 AM Local: 11:14 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 4, 3, 31, 0, false);            // UTC: 3:31 AM Local: 6:31 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 3, 20, 33, 0, false);           // UTC: 8:33 PM Local: 11:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 20, 17, 23, 0, false);          // UTC: 5:23 PM Local: 8:23 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 15, 20, 7, 0, false);           // UTC: 8:07 PM Local: 11:07 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 14, 22, 51, 0, false);          // UTC: 10:51 PM Local: 1:51 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 14, 5, 13, 0, false);           // UTC: 5:13 AM Local: 8:13 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 21, 3, 49, 0, false);           // UTC: 3:49 AM Local: 6:49 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 2, 20, 6, 0, false);            // UTC: 8:06 PM Local: 11:06 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 6, 13, 21, 0, false);           // UTC: 1:21 PM Local: 4:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 8, 5, 2, 45, 0, false);            // UTC: 2:45 AM Local: 5:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 18, 5, 42, 0, false);           // UTC: 5:42 AM Local: 8:42 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 16, 2, 30, 0, false);           // UTC: 2:30 AM Local: 5:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 9, 7, 44, 0, false);            // UTC: 7:44 AM Local: 10:44 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 2, 2, 9, 0, false);             // UTC: 2:09 AM Local: 5:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 1, 19, 35, 0, false);           // UTC: 7:35 PM Local: 10:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 8, 1, 17, 0, false);            // UTC: 1:17 AM Local: 4:17 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 25, 7, 18, 0, false);           // UTC: 7:18 AM Local: 10:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 8, 17, 12, 0, false);           // UTC: 5:12 PM Local: 8:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 12, 0, 13, 0, false);           // UTC: 12:13 AM Local: 3:13 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 12, 20, 16, 0, false);          // UTC: 8:16 PM Local: 11:16 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 6, 12, 38, 0, false);           // UTC: 12:38 PM Local: 3:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 18, 20, 38, 0, false);          // UTC: 8:38 PM Local: 11:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 11, 20, 50, 0, false);          // UTC: 8:50 PM Local: 11:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 10, 4, 55, 0, false);           // UTC: 4:55 AM Local: 7:55 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 13, 15, 2, 0, false);           // UTC: 3:02 PM Local: 6:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 18, 1, 3, 0, false);            // UTC: 1:03 AM Local: 4:03 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 14, 21, 32, 0, false);          // UTC: 9:32 PM Local: 12:32 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 2, 6, 45, 0, false);            // UTC: 6:45 AM Local: 9:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 13, 8, 28, 0, false);           // UTC: 8:28 AM Local: 11:28 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 14, 3, 4, 0, false);            // UTC: 3:04 AM Local: 6:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 8, 20, 25, 0, false);           // UTC: 8:25 PM Local: 11:25 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 13, 19, 31, 0, false);          // UTC: 7:31 PM Local: 10:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 14, 8, 55, 0, false);           // UTC: 8:55 AM Local: 11:55 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 26, 20, 8, 0, false);           // UTC: 8:08 PM Local: 11:08 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 9, 12, 12, 9, 0, false);           // UTC: 12:09 PM Local: 3:09 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 11, 18, 4, 0, false);          // UTC: 6:04 PM Local: 9:04 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 5, 17, 57, 0, false);          // UTC: 5:57 PM Local: 8:57 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 5, 21, 57, 0, false);          // UTC: 9:57 PM Local: 12:57 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 21, 3, 16, 0, false);          // UTC: 3:16 AM Local: 6:16 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 24, 4, 31, 0, false);          // UTC: 4:31 AM Local: 7:31 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 5, 20, 44, 0, false);          // UTC: 8:44 PM Local: 11:44 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 21, 1, 18, 0, false);          // UTC: 1:18 AM Local: 4:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 14, 0, 48, 0, false);          // UTC: 12:48 AM Local: 3:48 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 14, 3, 40, 0, false);          // UTC: 3:40 AM Local: 6:40 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 3, 12, 2, 0, false);           // UTC: 12:02 PM Local: 3:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 11, 14, 43, 0, false);         // UTC: 2:43 PM Local: 5:43 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 17, 2, 32, 0, false);          // UTC: 2:32 AM Local: 5:32 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 12, 7, 23, 0, false);          // UTC: 7:23 AM Local: 10:23 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 3, 2, 56, 0, false);           // UTC: 2:56 AM Local: 5:56 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 13, 16, 42, 0, false);         // UTC: 4:42 PM Local: 7:42 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 7, 14, 11, 0, false);          // UTC: 2:11 PM Local: 5:11 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 12, 17, 58, 0, false);         // UTC: 5:58 PM Local: 8:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 11, 15, 26, 0, false);         // UTC: 3:26 PM Local: 6:26 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 24, 19, 47, 0, false);         // UTC: 7:47 PM Local: 10:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 7, 15, 35, 0, false);          // UTC: 3:35 PM Local: 6:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 8, 1, 21, 0, false);           // UTC: 1:21 AM Local: 4:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 25, 7, 29, 0, false);          // UTC: 7:29 AM Local: 10:29 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 15, 6, 5, 0, false);           // UTC: 6:05 AM Local: 9:05 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 27, 17, 33, 0, false);         // UTC: 5:33 PM Local: 8:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 10, 10, 15, 56, 0, false);         // UTC: 3:56 PM Local: 6:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 10, 1, 16, 0, false);          // UTC: 1:16 AM Local: 4:16 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 4, 5, 30, 0, false);           // UTC: 5:30 AM Local: 8:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 14, 15, 45, 0, false);         // UTC: 3:45 PM Local: 6:45 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 2, 0, 57, 0, false);           // UTC: 12:57 AM Local: 3:57 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 8, 17, 13, 0, false);          // UTC: 5:13 PM Local: 8:13 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 21, 3, 39, 0, false);          // UTC: 3:39 AM Local: 6:39 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 22, 19, 2, 0, false);          // UTC: 7:02 PM Local: 10:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 16, 12, 22, 0, false);         // UTC: 12:22 PM Local: 3:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 6, 16, 21, 0, false);          // UTC: 4:21 PM Local: 7:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 3, 10, 1, 0, false);           // UTC: 10:01 AM Local: 1:01 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 12, 0, 58, 0, false);          // UTC: 12:58 AM Local: 3:58 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 14, 11, 47, 0, false);         // UTC: 11:47 AM Local: 2:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 14, 2, 23, 0, false);          // UTC: 2:23 AM Local: 5:23 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 3, 17, 22, 0, false);          // UTC: 5:22 PM Local: 8:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 16, 19, 18, 0, false);         // UTC: 7:18 PM Local: 10:18 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 15, 5, 29, 0, false);          // UTC: 5:29 AM Local: 8:29 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 24, 4, 34, 0, false);          // UTC: 4:34 AM Local: 7:34 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 24, 12, 49, 0, false);         // UTC: 12:49 PM Local: 3:49 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 25, 17, 30, 0, false);         // UTC: 5:30 PM Local: 8:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 25, 20, 32, 0, false);         // UTC: 8:32 PM Local: 11:32 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 5, 9, 14, 0, false);           // UTC: 9:14 AM Local: 12:14 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 21, 14, 58, 0, false);         // UTC: 2:58 PM Local: 5:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 27, 18, 15, 0, false);         // UTC: 6:15 PM Local: 9:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 12, 5, 2, 0, false);           // UTC: 5:02 AM Local: 8:02 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 11, 8, 16, 2, 0, false);           // UTC: 4:02 PM Local: 7:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 19, 0, 39, 0, false);          // UTC: 12:39 AM Local: 3:39 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 2, 15, 26, 0, false);          // UTC: 3:26 PM Local: 6:26 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 24, 5, 13, 0, false);          // UTC: 5:13 AM Local: 8:13 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 12, 12, 28, 0, false);         // UTC: 12:28 PM Local: 3:28 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 5, 13, 43, 0, false);          // UTC: 1:43 PM Local: 4:43 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 8, 14, 12, 0, false);          // UTC: 2:12 PM Local: 5:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 24, 21, 22, 0, false);         // UTC: 9:22 PM Local: 12:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 4, 19, 13, 0, false);          // UTC: 7:13 PM Local: 10:13 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 9, 12, 27, 0, false);          // UTC: 12:27 PM Local: 3:27 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 7, 10, 57, 0, false);          // UTC: 10:57 AM Local: 1:57 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 15, 13, 48, 0, false);         // UTC: 1:48 PM Local: 4:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 22, 5, 44, 0, false);          // UTC: 5:44 AM Local: 8:44 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 23, 18, 13, 0, false);         // UTC: 6:13 PM Local: 9:13 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 3, 6, 9, 0, false);            // UTC: 6:09 AM Local: 9:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 1, 7, 5, 0, false);            // UTC: 7:05 AM Local: 10:05 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 14, 18, 12, 0, false);         // UTC: 6:12 PM Local: 9:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 15, 2, 36, 0, false);          // UTC: 2:36 AM Local: 5:36 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 23, 9, 47, 0, false);          // UTC: 9:47 AM Local: 12:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 19, 12, 10, 0, false);         // UTC: 12:10 PM Local: 3:10 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 13, 17, 7, 0, false);          // UTC: 5:07 PM Local: 8:07 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 27, 14, 46, 0, false);         // UTC: 2:46 PM Local: 5:46 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 8, 20, 55, 0, false);          // UTC: 8:55 PM Local: 11:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 18, 8, 19, 0, false);          // UTC: 8:19 AM Local: 11:19 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 27, 10, 47, 0, false);         // UTC: 10:47 AM Local: 1:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2018, 12, 27, 17, 36, 0, false);         // UTC: 5:36 PM Local: 8:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 7, 3, 30, 0, false);            // UTC: 3:30 AM Local: 6:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 4, 19, 42, 0, false);           // UTC: 7:42 PM Local: 10:42 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 7, 16, 19, 0, false);           // UTC: 4:19 PM Local: 7:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 10, 16, 11, 0, false);          // UTC: 4:11 PM Local: 7:11 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 1, 2, 41, 0, false);            // UTC: 2:41 AM Local: 5:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 16, 9, 4, 0, false);            // UTC: 9:04 AM Local: 12:04 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 3, 2, 39, 0, false);            // UTC: 2:39 AM Local: 5:39 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 10, 17, 25, 0, false);          // UTC: 5:25 PM Local: 8:25 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 5, 19, 26, 0, false);           // UTC: 7:26 PM Local: 10:26 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 24, 12, 40, 0, false);          // UTC: 12:40 PM Local: 3:40 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 23, 19, 38, 0, false);          // UTC: 7:38 PM Local: 10:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 5, 10, 23, 0, false);           // UTC: 10:23 AM Local: 1:23 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 18, 7, 53, 0, false);           // UTC: 7:53 AM Local: 10:53 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 12, 17, 53, 0, false);          // UTC: 5:53 PM Local: 8:53 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 13, 20, 11, 0, false);          // UTC: 8:11 PM Local: 11:11 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 20, 14, 14, 0, false);          // UTC: 2:14 PM Local: 5:14 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 17, 9, 2, 0, false);            // UTC: 9:02 AM Local: 12:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 20, 20, 39, 0, false);          // UTC: 8:39 PM Local: 11:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 26, 19, 22, 0, false);          // UTC: 7:22 PM Local: 10:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 3, 22, 57, 0, false);           // UTC: 10:57 PM Local: 1:57 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 8, 8, 10, 0, false);            // UTC: 8:10 AM Local: 11:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 18, 12, 51, 0, false);          // UTC: 12:51 PM Local: 3:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 15, 19, 39, 0, false);          // UTC: 7:39 PM Local: 10:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 9, 21, 4, 0, false);            // UTC: 9:04 PM Local: 12:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 1, 5, 15, 20, 0, false);           // UTC: 3:20 PM Local: 6:20 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 21, 20, 49, 0, false);          // UTC: 8:49 PM Local: 11:49 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 7, 9, 13, 0, false);            // UTC: 9:13 AM Local: 12:13 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 6, 6, 7, 0, false);             // UTC: 6:07 AM Local: 9:07 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 17, 2, 55, 0, false);           // UTC: 2:55 AM Local: 5:55 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 27, 5, 34, 0, false);           // UTC: 5:34 AM Local: 8:34 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 1, 13, 21, 0, false);           // UTC: 1:21 PM Local: 4:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 26, 3, 22, 0, false);           // UTC: 3:22 AM Local: 6:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 20, 18, 21, 0, false);          // UTC: 6:21 PM Local: 9:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 9, 4, 46, 0, false);            // UTC: 4:46 AM Local: 7:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 16, 7, 28, 0, false);           // UTC: 7:28 AM Local: 10:28 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 27, 12, 12, 0, false);          // UTC: 12:12 PM Local: 3:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 9, 4, 56, 0, false);            // UTC: 4:56 AM Local: 7:56 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 15, 19, 31, 0, false);          // UTC: 7:31 PM Local: 10:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 21, 1, 5, 0, false);            // UTC: 1:05 AM Local: 4:05 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 2, 0, 25, 0, false);            // UTC: 12:25 AM Local: 3:25 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 25, 13, 36, 0, false);          // UTC: 1:36 PM Local: 4:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 3, 6, 20, 0, false);            // UTC: 6:20 AM Local: 9:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 19, 5, 32, 0, false);           // UTC: 5:32 AM Local: 8:32 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 26, 0, 4, 0, false);            // UTC: 12:04 AM Local: 3:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 13, 21, 13, 0, false);          // UTC: 9:13 PM Local: 12:13 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 12, 14, 55, 0, false);          // UTC: 2:55 PM Local: 5:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 18, 14, 33, 0, false);          // UTC: 2:33 PM Local: 5:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 20, 14, 1, 0, false);           // UTC: 2:01 PM Local: 5:01 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 18, 10, 42, 0, false);          // UTC: 10:42 AM Local: 1:42 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 2, 23, 4, 3, 0, false);            // UTC: 4:03 AM Local: 7:03 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 8, 15, 47, 0, false);           // UTC: 3:47 PM Local: 6:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 26, 9, 36, 0, false);           // UTC: 9:36 AM Local: 12:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 5, 11, 1, 0, false);            // UTC: 11:01 AM Local: 2:01 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 4, 6, 18, 0, false);            // UTC: 6:18 AM Local: 9:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 18, 8, 9, 0, false);            // UTC: 8:09 AM Local: 11:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 24, 1, 55, 0, false);           // UTC: 1:55 AM Local: 4:55 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 8, 7, 27, 0, false);            // UTC: 7:27 AM Local: 10:27 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 5, 9, 21, 0, false);            // UTC: 9:21 AM Local: 12:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 24, 4, 55, 0, false);           // UTC: 4:55 AM Local: 7:55 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 17, 10, 48, 0, false);          // UTC: 10:48 AM Local: 1:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 17, 19, 3, 0, false);           // UTC: 7:03 PM Local: 10:03 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 14, 15, 22, 0, false);          // UTC: 3:22 PM Local: 6:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 8, 12, 30, 0, false);           // UTC: 12:30 PM Local: 3:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 17, 6, 6, 0, false);            // UTC: 6:06 AM Local: 9:06 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 25, 11, 21, 0, false);          // UTC: 11:21 AM Local: 2:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 8, 1, 15, 0, false);            // UTC: 1:15 AM Local: 4:15 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 24, 17, 22, 0, false);          // UTC: 5:22 PM Local: 8:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 22, 12, 50, 0, false);          // UTC: 12:50 PM Local: 3:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 16, 3, 15, 0, false);           // UTC: 3:15 AM Local: 6:15 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 12, 2, 11, 0, false);           // UTC: 2:11 AM Local: 5:11 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 19, 12, 2, 0, false);           // UTC: 12:02 PM Local: 3:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 6, 12, 24, 0, false);           // UTC: 12:24 PM Local: 3:24 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 7, 3, 41, 0, false);            // UTC: 3:41 AM Local: 6:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 22, 13, 32, 0, false);          // UTC: 1:32 PM Local: 4:32 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 3, 12, 15, 2, 0, false);           // UTC: 3:02 PM Local: 6:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 10, 5, 53, 0, false);           // UTC: 5:53 AM Local: 8:53 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 1, 13, 7, 0, false);            // UTC: 1:07 PM Local: 4:07 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 19, 17, 41, 0, false);          // UTC: 5:41 PM Local: 8:41 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 12, 19, 18, 0, false);          // UTC: 7:18 PM Local: 10:18 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 6, 20, 31, 0, false);           // UTC: 8:31 PM Local: 11:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 4, 19, 25, 0, false);           // UTC: 7:25 PM Local: 10:25 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 9, 21, 42, 0, false);           // UTC: 9:42 PM Local: 12:42 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 3, 16, 57, 0, false);           // UTC: 4:57 PM Local: 7:57 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 26, 0, 53, 0, false);           // UTC: 12:53 AM Local: 3:53 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 16, 1, 9, 0, false);            // UTC: 1:09 AM Local: 4:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 23, 8, 51, 0, false);           // UTC: 8:51 AM Local: 11:51 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 23, 5, 53, 0, false);           // UTC: 5:53 AM Local: 8:53 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 10, 9, 28, 0, false);           // UTC: 9:28 AM Local: 12:28 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 3, 22, 47, 0, false);           // UTC: 10:47 PM Local: 1:47 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 10, 17, 41, 0, false);          // UTC: 5:41 PM Local: 8:41 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 3, 1, 14, 0, false);            // UTC: 1:14 AM Local: 4:14 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 5, 15, 44, 0, false);           // UTC: 3:44 PM Local: 6:44 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 4, 2, 42, 0, false);            // UTC: 2:42 AM Local: 5:42 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 9, 6, 30, 0, false);            // UTC: 6:30 AM Local: 9:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 25, 1, 34, 0, false);           // UTC: 1:34 AM Local: 4:34 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 6, 2, 38, 0, false);            // UTC: 2:38 AM Local: 5:38 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 15, 13, 26, 0, false);          // UTC: 1:26 PM Local: 4:26 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 12, 8, 39, 0, false);           // UTC: 8:39 AM Local: 11:39 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 18, 17, 24, 0, false);          // UTC: 5:24 PM Local: 8:24 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 4, 26, 5, 56, 0, false);           // UTC: 5:56 AM Local: 8:56 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 25, 16, 56, 0, false);          // UTC: 4:56 PM Local: 7:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 8, 19, 57, 0, false);           // UTC: 7:57 PM Local: 10:57 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 18, 8, 24, 0, false);           // UTC: 8:24 AM Local: 11:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 12, 16, 16, 0, false);          // UTC: 4:16 PM Local: 7:16 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 5, 11, 57, 0, false);           // UTC: 11:57 AM Local: 2:57 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 11, 9, 21, 0, false);           // UTC: 9:21 AM Local: 12:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 25, 20, 51, 0, false);          // UTC: 8:51 PM Local: 11:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 5, 18, 9, 0, false);            // UTC: 6:09 PM Local: 9:09 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 7, 15, 39, 0, false);           // UTC: 3:39 PM Local: 6:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 16, 12, 53, 0, false);          // UTC: 12:53 PM Local: 3:53 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 9, 3, 51, 0, false);            // UTC: 3:51 AM Local: 6:51 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 21, 9, 32, 0, false);           // UTC: 9:32 AM Local: 12:32 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 16, 14, 13, 0, false);          // UTC: 2:13 PM Local: 5:13 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 17, 12, 43, 0, false);          // UTC: 12:43 PM Local: 3:43 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 7, 2, 52, 0, false);            // UTC: 2:52 AM Local: 5:52 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 5, 6, 51, 0, false);            // UTC: 6:51 AM Local: 9:51 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 19, 5, 19, 0, false);           // UTC: 5:19 AM Local: 8:19 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 2, 0, 20, 0, false);            // UTC: 12:20 AM Local: 3:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 3, 17, 53, 0, false);           // UTC: 5:53 PM Local: 8:53 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 22, 0, 9, 0, false);            // UTC: 12:09 AM Local: 3:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 9, 1, 49, 0, false);            // UTC: 1:49 AM Local: 4:49 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 14, 1, 32, 0, false);           // UTC: 1:32 AM Local: 4:32 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 12, 8, 5, 0, false);            // UTC: 8:05 AM Local: 11:05 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 12, 18, 46, 0, false);          // UTC: 6:46 PM Local: 9:46 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 5, 4, 6, 20, 0, false);            // UTC: 6:20 AM Local: 9:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 5, 21, 40, 0, false);           // UTC: 9:40 PM Local: 12:40 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 8, 1, 22, 0, false);            // UTC: 1:22 AM Local: 4:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 22, 20, 17, 0, false);          // UTC: 8:17 PM Local: 11:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 16, 6, 7, 0, false);            // UTC: 6:07 AM Local: 9:07 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 14, 15, 38, 0, false);          // UTC: 3:38 PM Local: 6:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 18, 17, 36, 0, false);          // UTC: 5:36 PM Local: 8:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 2, 7, 26, 0, false);            // UTC: 7:26 AM Local: 10:26 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 25, 16, 2, 0, false);           // UTC: 4:02 PM Local: 7:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 10, 17, 53, 0, false);          // UTC: 5:53 PM Local: 8:53 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 22, 5, 25, 0, false);           // UTC: 5:25 AM Local: 8:25 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 15, 21, 43, 0, false);          // UTC: 9:43 PM Local: 12:43 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 1, 21, 49, 0, false);           // UTC: 9:49 PM Local: 12:49 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 6, 12, 56, 0, false);           // UTC: 12:56 PM Local: 3:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 22, 11, 10, 0, false);          // UTC: 11:10 AM Local: 2:10 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 15, 21, 48, 0, false);          // UTC: 9:48 PM Local: 12:48 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 12, 20, 41, 0, false);          // UTC: 8:41 PM Local: 11:41 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 13, 18, 4, 0, false);           // UTC: 6:04 PM Local: 9:04 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 5, 1, 58, 0, false);            // UTC: 1:58 AM Local: 4:58 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 24, 5, 10, 0, false);           // UTC: 5:10 AM Local: 8:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 18, 21, 17, 0, false);          // UTC: 9:17 PM Local: 12:17 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 13, 0, 37, 0, false);           // UTC: 12:37 AM Local: 3:37 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 24, 1, 20, 0, false);           // UTC: 1:20 AM Local: 4:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 11, 11, 45, 0, false);          // UTC: 11:45 AM Local: 2:45 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 22, 9, 12, 0, false);           // UTC: 9:12 AM Local: 12:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 6, 18, 6, 47, 0, false);           // UTC: 6:47 AM Local: 9:47 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 8, 8, 47, 0, false);            // UTC: 8:47 AM Local: 11:47 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 6, 21, 51, 0, false);           // UTC: 9:51 PM Local: 12:51 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 6, 7, 27, 0, false);            // UTC: 7:27 AM Local: 10:27 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 10, 8, 50, 0, false);           // UTC: 8:50 AM Local: 11:50 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 21, 2, 39, 0, false);           // UTC: 2:39 AM Local: 5:39 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 18, 12, 36, 0, false);          // UTC: 12:36 PM Local: 3:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 19, 6, 29, 0, false);           // UTC: 6:29 AM Local: 9:29 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 15, 15, 51, 0, false);          // UTC: 3:51 PM Local: 6:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 13, 0, 22, 0, false);           // UTC: 12:22 AM Local: 3:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 26, 14, 22, 0, false);          // UTC: 2:22 PM Local: 5:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 24, 11, 45, 0, false);          // UTC: 11:45 AM Local: 2:45 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 6, 14, 53, 0, false);           // UTC: 2:53 PM Local: 5:53 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 11, 9, 0, 0, false);            // UTC: 9:00 AM Local: 12:00 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 12, 6, 39, 0, false);           // UTC: 6:39 AM Local: 9:39 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 5, 11, 39, 0, false);           // UTC: 11:39 AM Local: 2:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 13, 14, 22, 0, false);          // UTC: 2:22 PM Local: 5:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 3, 3, 50, 0, false);            // UTC: 3:50 AM Local: 6:50 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 17, 22, 58, 0, false);          // UTC: 10:58 PM Local: 1:58 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 8, 16, 39, 0, false);           // UTC: 4:39 PM Local: 7:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 26, 17, 53, 0, false);          // UTC: 5:53 PM Local: 8:53 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 14, 6, 41, 0, false);           // UTC: 6:41 AM Local: 9:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 3, 11, 50, 0, false);           // UTC: 11:50 AM Local: 2:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 3, 12, 30, 0, false);           // UTC: 12:30 PM Local: 3:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 21, 6, 7, 0, false);            // UTC: 6:07 AM Local: 9:07 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 7, 17, 5, 1, 0, false);            // UTC: 5:01 AM Local: 8:01 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 23, 8, 10, 0, false);           // UTC: 8:10 AM Local: 11:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 6, 22, 22, 0, false);           // UTC: 10:22 PM Local: 1:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 1, 19, 28, 0, false);           // UTC: 7:28 PM Local: 10:28 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 15, 5, 31, 0, false);           // UTC: 5:31 AM Local: 8:31 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 22, 20, 52, 0, false);          // UTC: 8:52 PM Local: 11:52 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 7, 10, 40, 0, false);           // UTC: 10:40 AM Local: 1:40 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 3, 21, 0, 0, false);            // UTC: 9:00 PM Local: 12:00 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 27, 1, 58, 0, false);           // UTC: 1:58 AM Local: 4:58 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 23, 9, 4, 0, false);            // UTC: 9:04 AM Local: 12:04 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 24, 7, 51, 0, false);           // UTC: 7:51 AM Local: 10:51 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 20, 22, 43, 0, false);          // UTC: 10:43 PM Local: 1:43 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 26, 10, 20, 0, false);          // UTC: 10:20 AM Local: 1:20 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 14, 16, 44, 0, false);          // UTC: 4:44 PM Local: 7:44 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 15, 11, 25, 0, false);          // UTC: 11:25 AM Local: 2:25 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 6, 13, 14, 0, false);           // UTC: 1:14 PM Local: 4:14 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 9, 6, 39, 0, false);            // UTC: 6:39 AM Local: 9:39 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 17, 12, 48, 0, false);          // UTC: 12:48 PM Local: 3:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 13, 11, 18, 0, false);          // UTC: 11:18 AM Local: 2:18 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 1, 19, 17, 0, false);           // UTC: 7:17 PM Local: 10:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 5, 8, 35, 0, false);            // UTC: 8:35 AM Local: 11:35 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 8, 3, 30, 0, false);            // UTC: 3:30 AM Local: 6:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 17, 18, 15, 0, false);          // UTC: 6:15 PM Local: 9:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 22, 19, 25, 0, false);          // UTC: 7:25 PM Local: 10:25 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 15, 16, 42, 0, false);          // UTC: 4:42 PM Local: 7:42 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 8, 26, 12, 26, 0, false);          // UTC: 12:26 PM Local: 3:26 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 16, 17, 30, 0, false);          // UTC: 5:30 PM Local: 8:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 21, 11, 6, 0, false);           // UTC: 11:06 AM Local: 2:06 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 12, 5, 45, 0, false);           // UTC: 5:45 AM Local: 8:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 2, 6, 28, 0, false);            // UTC: 6:28 AM Local: 9:28 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 12, 21, 36, 0, false);          // UTC: 9:36 PM Local: 12:36 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 2, 7, 21, 0, false);            // UTC: 7:21 AM Local: 10:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 5, 5, 19, 0, false);            // UTC: 5:19 AM Local: 8:19 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 25, 14, 45, 0, false);          // UTC: 2:45 PM Local: 5:45 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 27, 12, 26, 0, false);          // UTC: 12:26 PM Local: 3:26 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 7, 1, 48, 0, false);            // UTC: 1:48 AM Local: 4:48 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 4, 11, 55, 0, false);           // UTC: 11:55 AM Local: 2:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 24, 10, 4, 0, false);           // UTC: 10:04 AM Local: 1:04 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 22, 10, 51, 0, false);          // UTC: 10:51 AM Local: 1:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 14, 20, 53, 0, false);          // UTC: 8:53 PM Local: 11:53 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 21, 12, 30, 0, false);          // UTC: 12:30 PM Local: 3:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 21, 8, 53, 0, false);           // UTC: 8:53 AM Local: 11:53 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 22, 11, 24, 0, false);          // UTC: 11:24 AM Local: 2:24 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 10, 17, 19, 0, false);          // UTC: 5:19 PM Local: 8:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 4, 14, 8, 0, false);            // UTC: 2:08 PM Local: 5:08 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 20, 17, 56, 0, false);          // UTC: 5:56 PM Local: 8:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 18, 3, 9, 0, false);            // UTC: 3:09 AM Local: 6:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 26, 21, 45, 0, false);          // UTC: 9:45 PM Local: 12:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 15, 13, 27, 0, false);          // UTC: 1:27 PM Local: 4:27 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 15, 5, 51, 0, false);           // UTC: 5:51 AM Local: 8:51 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 9, 13, 15, 21, 0, false);          // UTC: 3:21 PM Local: 6:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 12, 3, 4, 0, false);           // UTC: 3:04 AM Local: 6:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 7, 4, 10, 0, false);           // UTC: 4:10 AM Local: 7:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 15, 9, 34, 0, false);          // UTC: 9:34 AM Local: 12:34 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 11, 17, 43, 0, false);         // UTC: 5:43 PM Local: 8:43 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 17, 17, 48, 0, false);         // UTC: 5:48 PM Local: 8:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 26, 1, 40, 0, false);          // UTC: 1:40 AM Local: 4:40 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 25, 19, 41, 0, false);         // UTC: 7:41 PM Local: 10:41 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 20, 18, 35, 0, false);         // UTC: 6:35 PM Local: 9:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 21, 5, 46, 0, false);          // UTC: 5:46 AM Local: 8:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 13, 6, 14, 0, false);          // UTC: 6:14 AM Local: 9:14 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 15, 20, 7, 0, false);          // UTC: 8:07 PM Local: 11:07 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 26, 15, 28, 0, false);         // UTC: 3:28 PM Local: 6:28 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 2, 11, 32, 0, false);          // UTC: 11:32 AM Local: 2:32 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 21, 2, 43, 0, false);          // UTC: 2:43 AM Local: 5:43 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 16, 12, 11, 0, false);         // UTC: 12:11 PM Local: 3:11 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 1, 21, 48, 0, false);          // UTC: 9:48 PM Local: 12:48 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 18, 14, 11, 0, false);         // UTC: 2:11 PM Local: 5:11 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 5, 12, 48, 0, false);          // UTC: 12:48 PM Local: 3:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 18, 16, 22, 0, false);         // UTC: 4:22 PM Local: 7:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 13, 11, 57, 0, false);         // UTC: 11:57 AM Local: 2:57 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 11, 2, 10, 0, false);          // UTC: 2:10 AM Local: 5:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 10, 19, 51, 0, false);         // UTC: 7:51 PM Local: 10:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 17, 15, 3, 0, false);          // UTC: 3:03 PM Local: 6:03 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 10, 19, 33, 0, false);         // UTC: 7:33 PM Local: 10:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 10, 4, 3, 41, 0, false);           // UTC: 3:41 AM Local: 6:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 27, 3, 13, 0, false);          // UTC: 3:13 AM Local: 6:13 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 12, 16, 18, 0, false);         // UTC: 4:18 PM Local: 7:18 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 27, 18, 38, 0, false);         // UTC: 6:38 PM Local: 9:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 2, 8, 19, 0, false);           // UTC: 8:19 AM Local: 11:19 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 8, 7, 57, 0, false);           // UTC: 7:57 AM Local: 10:57 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 3, 13, 58, 0, false);          // UTC: 1:58 PM Local: 4:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 16, 9, 2, 0, false);           // UTC: 9:02 AM Local: 12:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 16, 5, 42, 0, false);          // UTC: 5:42 AM Local: 8:42 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 9, 9, 14, 0, false);           // UTC: 9:14 AM Local: 12:14 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 21, 7, 44, 0, false);          // UTC: 7:44 AM Local: 10:44 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 17, 0, 23, 0, false);          // UTC: 12:23 AM Local: 3:23 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 4, 15, 31, 0, false);          // UTC: 3:31 PM Local: 6:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 4, 1, 45, 0, false);           // UTC: 1:45 AM Local: 4:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 18, 9, 17, 0, false);          // UTC: 9:17 AM Local: 12:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 15, 7, 28, 0, false);          // UTC: 7:28 AM Local: 10:28 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 15, 7, 20, 0, false);          // UTC: 7:20 AM Local: 10:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 3, 5, 15, 0, false);           // UTC: 5:15 AM Local: 8:15 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 16, 13, 44, 0, false);         // UTC: 1:44 PM Local: 4:44 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 19, 9, 55, 0, false);          // UTC: 9:55 AM Local: 12:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 14, 2, 18, 0, false);          // UTC: 2:18 AM Local: 5:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 2, 4, 28, 0, false);           // UTC: 4:28 AM Local: 7:28 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 25, 9, 19, 0, false);          // UTC: 9:19 AM Local: 12:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 26, 3, 37, 0, false);          // UTC: 3:37 AM Local: 6:37 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 13, 21, 32, 0, false);         // UTC: 9:32 PM Local: 12:32 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 11, 6, 21, 57, 0, false);          // UTC: 9:57 PM Local: 12:57 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 21, 1, 54, 0, false);          // UTC: 1:54 AM Local: 4:54 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 7, 18, 5, 0, false);           // UTC: 6:05 PM Local: 9:05 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 25, 15, 4, 0, false);          // UTC: 3:04 PM Local: 6:04 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 14, 0, 27, 0, false);          // UTC: 12:27 AM Local: 3:27 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 18, 10, 16, 0, false);         // UTC: 10:16 AM Local: 1:16 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 16, 14, 56, 0, false);         // UTC: 2:56 PM Local: 5:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 13, 13, 12, 0, false);         // UTC: 1:12 PM Local: 4:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 22, 14, 52, 0, false);         // UTC: 2:52 PM Local: 5:52 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 5, 13, 9, 0, false);           // UTC: 1:09 PM Local: 4:09 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 20, 14, 16, 0, false);         // UTC: 2:16 PM Local: 5:16 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 20, 8, 39, 0, false);          // UTC: 8:39 AM Local: 11:39 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 21, 21, 21, 0, false);         // UTC: 9:21 PM Local: 12:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 1, 6, 18, 0, false);           // UTC: 6:18 AM Local: 9:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 7, 3, 30, 0, false);           // UTC: 3:30 AM Local: 6:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 11, 9, 21, 0, false);          // UTC: 9:21 AM Local: 12:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 24, 6, 42, 0, false);          // UTC: 6:42 AM Local: 9:42 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 10, 19, 18, 0, false);         // UTC: 7:18 PM Local: 10:18 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 16, 17, 19, 0, false);         // UTC: 5:19 PM Local: 8:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 21, 21, 25, 0, false);         // UTC: 9:25 PM Local: 12:25 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 1, 1, 10, 0, false);           // UTC: 1:10 AM Local: 4:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 26, 4, 3, 0, false);           // UTC: 4:03 AM Local: 7:03 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 22, 17, 39, 0, false);         // UTC: 5:39 PM Local: 8:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 22, 20, 30, 0, false);         // UTC: 8:30 PM Local: 11:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 25, 13, 20, 0, false);         // UTC: 1:20 PM Local: 4:20 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2019, 12, 18, 5, 24, 0, false);          // UTC: 5:24 AM Local: 8:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 19, 9, 11, 0, false);           // UTC: 9:11 AM Local: 12:11 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 15, 6, 19, 0, false);           // UTC: 6:19 AM Local: 9:19 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 12, 8, 45, 0, false);           // UTC: 8:45 AM Local: 11:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 27, 2, 36, 0, false);           // UTC: 2:36 AM Local: 5:36 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 10, 22, 0, 0, false);           // UTC: 10:00 PM Local: 1:00 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 26, 22, 11, 0, false);          // UTC: 10:11 PM Local: 1:11 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 4, 6, 57, 0, false);            // UTC: 6:57 AM Local: 9:57 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 13, 14, 37, 0, false);          // UTC: 2:37 PM Local: 5:37 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 19, 1, 23, 0, false);           // UTC: 1:23 AM Local: 4:23 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 6, 10, 17, 0, false);           // UTC: 10:17 AM Local: 1:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 27, 21, 30, 0, false);          // UTC: 9:30 PM Local: 12:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 25, 2, 30, 0, false);           // UTC: 2:30 AM Local: 5:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 7, 11, 46, 0, false);           // UTC: 11:46 AM Local: 2:46 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 24, 11, 48, 0, false);          // UTC: 11:48 AM Local: 2:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 8, 18, 38, 0, false);           // UTC: 6:38 PM Local: 9:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 2, 10, 52, 0, false);           // UTC: 10:52 AM Local: 1:52 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 14, 22, 34, 0, false);          // UTC: 10:34 PM Local: 1:34 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 5, 11, 55, 0, false);           // UTC: 11:55 AM Local: 2:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 12, 5, 46, 0, false);           // UTC: 5:46 AM Local: 8:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 16, 18, 14, 0, false);          // UTC: 6:14 PM Local: 9:14 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 25, 5, 54, 0, false);           // UTC: 5:54 AM Local: 8:54 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 13, 0, 10, 0, false);           // UTC: 12:10 AM Local: 3:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 3, 9, 53, 0, false);            // UTC: 9:53 AM Local: 12:53 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 14, 15, 28, 0, false);          // UTC: 3:28 PM Local: 6:28 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 1, 11, 6, 46, 0, false);           // UTC: 6:46 AM Local: 9:46 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 5, 3, 47, 0, false);            // UTC: 3:47 AM Local: 6:47 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 27, 14, 34, 0, false);          // UTC: 2:34 PM Local: 5:34 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 14, 15, 26, 0, false);          // UTC: 3:26 PM Local: 6:26 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 20, 18, 25, 0, false);          // UTC: 6:25 PM Local: 9:25 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 16, 10, 51, 0, false);          // UTC: 10:51 AM Local: 1:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 20, 15, 40, 0, false);          // UTC: 3:40 PM Local: 6:40 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 15, 21, 15, 0, false);          // UTC: 9:15 PM Local: 12:15 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 25, 18, 48, 0, false);          // UTC: 6:48 PM Local: 9:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 14, 21, 2, 0, false);           // UTC: 9:02 PM Local: 12:02 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 27, 0, 17, 0, false);           // UTC: 12:17 AM Local: 3:17 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 3, 17, 13, 0, false);           // UTC: 5:13 PM Local: 8:13 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 5, 6, 2, 0, false);             // UTC: 6:02 AM Local: 9:02 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 27, 13, 10, 0, false);          // UTC: 1:10 PM Local: 4:10 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 19, 9, 33, 0, false);           // UTC: 9:33 AM Local: 12:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 13, 17, 11, 0, false);          // UTC: 5:11 PM Local: 8:11 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 20, 12, 57, 0, false);          // UTC: 12:57 PM Local: 3:57 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 1, 17, 1, 0, false);            // UTC: 5:01 PM Local: 8:01 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 22, 19, 20, 0, false);          // UTC: 7:20 PM Local: 10:20 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 15, 6, 20, 0, false);           // UTC: 6:20 AM Local: 9:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 27, 11, 40, 0, false);          // UTC: 11:40 AM Local: 2:40 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 15, 12, 38, 0, false);          // UTC: 12:38 PM Local: 3:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 5, 14, 2, 0, false);            // UTC: 2:02 PM Local: 5:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 6, 9, 10, 0, false);            // UTC: 9:10 AM Local: 12:10 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 23, 16, 5, 0, false);           // UTC: 4:05 PM Local: 7:05 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 2, 14, 20, 30, 0, false);          // UTC: 8:30 PM Local: 11:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 19, 9, 4, 0, false);            // UTC: 9:04 AM Local: 12:04 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 17, 17, 24, 0, false);          // UTC: 5:24 PM Local: 8:24 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 2, 22, 16, 0, false);           // UTC: 10:16 PM Local: 1:16 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 8, 6, 52, 0, false);            // UTC: 6:52 AM Local: 9:52 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 24, 14, 0, 0, false);           // UTC: 2:00 PM Local: 5:00 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 19, 0, 5, 0, false);            // UTC: 12:05 AM Local: 3:05 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 14, 2, 51, 0, false);           // UTC: 2:51 AM Local: 5:51 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 25, 7, 8, 0, false);            // UTC: 7:08 AM Local: 10:08 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 5, 12, 6, 0, false);            // UTC: 12:06 PM Local: 3:06 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 22, 4, 1, 0, false);            // UTC: 4:01 AM Local: 7:01 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 26, 6, 58, 0, false);           // UTC: 6:58 AM Local: 9:58 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 23, 19, 50, 0, false);          // UTC: 7:50 PM Local: 10:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 8, 8, 43, 0, false);            // UTC: 8:43 AM Local: 11:43 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 8, 10, 33, 0, false);           // UTC: 10:33 AM Local: 1:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 11, 20, 18, 0, false);          // UTC: 8:18 PM Local: 11:18 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 5, 7, 47, 0, false);            // UTC: 7:47 AM Local: 10:47 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 5, 2, 42, 0, false);            // UTC: 2:42 AM Local: 5:42 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 27, 0, 44, 0, false);           // UTC: 12:44 AM Local: 3:44 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 18, 17, 5, 0, false);           // UTC: 5:05 PM Local: 8:05 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 26, 10, 13, 0, false);          // UTC: 10:13 AM Local: 1:13 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 9, 6, 44, 0, false);            // UTC: 6:44 AM Local: 9:44 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 7, 7, 0, 0, false);             // UTC: 7:00 AM Local: 10:00 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 25, 1, 45, 0, false);           // UTC: 1:45 AM Local: 4:45 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 5, 9, 38, 0, false);            // UTC: 9:38 AM Local: 12:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 3, 10, 4, 38, 0, false);           // UTC: 4:38 AM Local: 7:38 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 9, 12, 26, 0, false);           // UTC: 12:26 PM Local: 3:26 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 23, 0, 11, 0, false);           // UTC: 12:11 AM Local: 3:11 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 9, 14, 4, 0, false);            // UTC: 2:04 PM Local: 5:04 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 9, 21, 16, 0, false);           // UTC: 9:16 PM Local: 12:16 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 7, 4, 4, 0, false);             // UTC: 4:04 AM Local: 7:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 21, 8, 53, 0, false);           // UTC: 8:53 AM Local: 11:53 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 14, 22, 11, 0, false);          // UTC: 10:11 PM Local: 1:11 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 22, 3, 32, 0, false);           // UTC: 3:32 AM Local: 6:32 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 9, 5, 16, 0, false);            // UTC: 5:16 AM Local: 8:16 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 1, 0, 41, 0, false);            // UTC: 12:41 AM Local: 3:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 2, 14, 47, 0, false);           // UTC: 2:47 PM Local: 5:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 3, 7, 13, 0, false);            // UTC: 7:13 AM Local: 10:13 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 18, 2, 27, 0, false);           // UTC: 2:27 AM Local: 5:27 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 1, 22, 38, 0, false);           // UTC: 10:38 PM Local: 1:38 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 19, 21, 23, 0, false);          // UTC: 9:23 PM Local: 12:23 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 20, 15, 51, 0, false);          // UTC: 3:51 PM Local: 6:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 19, 8, 4, 0, false);            // UTC: 8:04 AM Local: 11:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 21, 19, 13, 0, false);          // UTC: 7:13 PM Local: 10:13 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 13, 11, 24, 0, false);          // UTC: 11:24 AM Local: 2:24 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 25, 11, 45, 0, false);          // UTC: 11:45 AM Local: 2:45 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 25, 6, 35, 0, false);           // UTC: 6:35 AM Local: 9:35 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 11, 5, 17, 0, false);           // UTC: 5:17 AM Local: 8:17 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 13, 3, 49, 0, false);           // UTC: 3:49 AM Local: 6:49 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 23, 2, 14, 0, false);           // UTC: 2:14 AM Local: 5:14 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 4, 12, 11, 58, 0, false);          // UTC: 11:58 AM Local: 2:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 15, 2, 11, 0, false);           // UTC: 2:11 AM Local: 5:11 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 4, 13, 32, 0, false);           // UTC: 1:32 PM Local: 4:32 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 12, 7, 37, 0, false);           // UTC: 7:37 AM Local: 10:37 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 17, 7, 47, 0, false);           // UTC: 7:47 AM Local: 10:47 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 16, 14, 50, 0, false);          // UTC: 2:50 PM Local: 5:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 23, 17, 35, 0, false);          // UTC: 5:35 PM Local: 8:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 19, 2, 41, 0, false);           // UTC: 2:41 AM Local: 5:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 2, 7, 40, 0, false);            // UTC: 7:40 AM Local: 10:40 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 3, 5, 31, 0, false);            // UTC: 5:31 AM Local: 8:31 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 2, 19, 15, 0, false);           // UTC: 7:15 PM Local: 10:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 23, 7, 21, 0, false);           // UTC: 7:21 AM Local: 10:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 7, 21, 21, 0, false);           // UTC: 9:21 PM Local: 12:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 6, 17, 54, 0, false);           // UTC: 5:54 PM Local: 8:54 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 6, 11, 55, 0, false);           // UTC: 11:55 AM Local: 2:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 27, 17, 54, 0, false);          // UTC: 5:54 PM Local: 8:54 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 14, 20, 30, 0, false);          // UTC: 8:30 PM Local: 11:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 27, 0, 21, 0, false);           // UTC: 12:21 AM Local: 3:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 18, 16, 21, 0, false);          // UTC: 4:21 PM Local: 7:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 8, 10, 48, 0, false);           // UTC: 10:48 AM Local: 1:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 14, 0, 19, 0, false);           // UTC: 12:19 AM Local: 3:19 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 1, 8, 28, 0, false);            // UTC: 8:28 AM Local: 11:28 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 10, 18, 0, 0, false);           // UTC: 6:00 PM Local: 9:00 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 13, 7, 40, 0, false);           // UTC: 7:40 AM Local: 10:40 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 14, 14, 58, 0, false);          // UTC: 2:58 PM Local: 5:58 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 5, 19, 11, 37, 0, false);          // UTC: 11:37 AM Local: 2:37 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 21, 1, 32, 0, false);           // UTC: 1:32 AM Local: 4:32 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 21, 14, 21, 0, false);          // UTC: 2:21 PM Local: 5:21 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 1, 1, 49, 0, false);            // UTC: 1:49 AM Local: 4:49 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 25, 4, 34, 0, false);           // UTC: 4:34 AM Local: 7:34 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 27, 22, 27, 0, false);          // UTC: 10:27 PM Local: 1:27 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 15, 15, 42, 0, false);          // UTC: 3:42 PM Local: 6:42 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 16, 4, 7, 0, false);            // UTC: 4:07 AM Local: 7:07 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 13, 14, 57, 0, false);          // UTC: 2:57 PM Local: 5:57 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 25, 1, 33, 0, false);           // UTC: 1:33 AM Local: 4:33 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 23, 11, 23, 0, false);          // UTC: 11:23 AM Local: 2:23 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 11, 22, 14, 0, false);          // UTC: 10:14 PM Local: 1:14 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 20, 12, 22, 0, false);          // UTC: 12:22 PM Local: 3:22 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 8, 17, 24, 0, false);           // UTC: 5:24 PM Local: 8:24 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 26, 0, 18, 0, false);           // UTC: 12:18 AM Local: 3:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 18, 10, 35, 0, false);          // UTC: 10:35 AM Local: 1:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 12, 10, 20, 0, false);          // UTC: 10:20 AM Local: 1:20 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 6, 21, 54, 0, false);           // UTC: 9:54 PM Local: 12:54 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 8, 2, 18, 0, false);            // UTC: 2:18 AM Local: 5:18 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 14, 6, 27, 0, false);           // UTC: 6:27 AM Local: 9:27 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 16, 19, 33, 0, false);          // UTC: 7:33 PM Local: 10:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 22, 3, 33, 0, false);           // UTC: 3:33 AM Local: 6:33 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 13, 12, 12, 0, false);          // UTC: 12:12 PM Local: 3:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 10, 6, 26, 0, false);           // UTC: 6:26 AM Local: 9:26 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 3, 6, 55, 0, false);            // UTC: 6:55 AM Local: 9:55 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 6, 9, 14, 9, 0, false);            // UTC: 2:09 PM Local: 5:09 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 22, 19, 9, 0, false);           // UTC: 7:09 PM Local: 10:09 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 10, 11, 35, 0, false);          // UTC: 11:35 AM Local: 2:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 6, 14, 32, 0, false);           // UTC: 2:32 PM Local: 5:32 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 13, 2, 51, 0, false);           // UTC: 2:51 AM Local: 5:51 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 26, 5, 14, 0, false);           // UTC: 5:14 AM Local: 8:14 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 25, 15, 52, 0, false);          // UTC: 3:52 PM Local: 6:52 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 24, 3, 50, 0, false);           // UTC: 3:50 AM Local: 6:50 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 21, 4, 55, 0, false);           // UTC: 4:55 AM Local: 7:55 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 11, 2, 10, 0, false);           // UTC: 2:10 AM Local: 5:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 25, 2, 38, 0, false);           // UTC: 2:38 AM Local: 5:38 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 27, 22, 27, 0, false);          // UTC: 10:27 PM Local: 1:27 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 4, 16, 26, 0, false);           // UTC: 4:26 PM Local: 7:26 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 9, 4, 22, 0, false);            // UTC: 4:22 AM Local: 7:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 27, 13, 30, 0, false);          // UTC: 1:30 PM Local: 4:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 1, 22, 24, 0, false);           // UTC: 10:24 PM Local: 1:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 10, 9, 3, 0, false);            // UTC: 9:03 AM Local: 12:03 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 6, 4, 35, 0, false);            // UTC: 4:35 AM Local: 7:35 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 2, 10, 27, 0, false);           // UTC: 10:27 AM Local: 1:27 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 9, 1, 38, 0, false);            // UTC: 1:38 AM Local: 4:38 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 7, 22, 22, 0, false);           // UTC: 10:22 PM Local: 1:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 12, 7, 30, 0, false);           // UTC: 7:30 AM Local: 10:30 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 25, 11, 7, 0, false);           // UTC: 11:07 AM Local: 2:07 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 12, 18, 30, 0, false);          // UTC: 6:30 PM Local: 9:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 22, 13, 28, 0, false);          // UTC: 1:28 PM Local: 4:28 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 7, 14, 20, 33, 0, false);          // UTC: 8:33 PM Local: 11:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 9, 16, 11, 0, false);           // UTC: 4:11 PM Local: 7:11 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 14, 1, 41, 0, false);           // UTC: 1:41 AM Local: 4:41 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 4, 16, 55, 0, false);           // UTC: 4:55 PM Local: 7:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 2, 21, 31, 0, false);           // UTC: 9:31 PM Local: 12:31 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 27, 19, 37, 0, false);          // UTC: 7:37 PM Local: 10:37 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 22, 2, 13, 0, false);           // UTC: 2:13 AM Local: 5:13 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 1, 12, 15, 0, false);           // UTC: 12:15 PM Local: 3:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 1, 2, 29, 0, false);            // UTC: 2:29 AM Local: 5:29 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 8, 21, 35, 0, false);           // UTC: 9:35 PM Local: 12:35 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 15, 9, 34, 0, false);           // UTC: 9:34 AM Local: 12:34 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 4, 12, 33, 0, false);           // UTC: 12:33 PM Local: 3:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 25, 22, 19, 0, false);          // UTC: 10:19 PM Local: 1:19 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 13, 16, 55, 0, false);          // UTC: 4:55 PM Local: 7:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 19, 6, 36, 0, false);           // UTC: 6:36 AM Local: 9:36 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 16, 19, 33, 0, false);          // UTC: 7:33 PM Local: 10:33 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 17, 9, 56, 0, false);           // UTC: 9:56 AM Local: 12:56 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 24, 22, 29, 0, false);          // UTC: 10:29 PM Local: 1:29 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 7, 11, 19, 0, false);           // UTC: 11:19 AM Local: 2:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 9, 7, 37, 0, false);            // UTC: 7:37 AM Local: 10:37 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 19, 5, 6, 0, false);            // UTC: 5:06 AM Local: 8:06 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 3, 13, 17, 0, false);           // UTC: 1:17 PM Local: 4:17 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 10, 21, 21, 0, false);          // UTC: 9:21 PM Local: 12:21 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 27, 2, 50, 0, false);           // UTC: 2:50 AM Local: 5:50 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 9, 7, 22, 0, false);            // UTC: 7:22 AM Local: 10:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 8, 8, 7, 14, 0, false);            // UTC: 7:14 AM Local: 10:14 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 18, 9, 15, 0, false);           // UTC: 9:15 AM Local: 12:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 26, 15, 30, 0, false);          // UTC: 3:30 PM Local: 6:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 18, 14, 24, 0, false);          // UTC: 2:24 PM Local: 5:24 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 3, 19, 3, 0, false);            // UTC: 7:03 PM Local: 10:03 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 7, 13, 38, 0, false);           // UTC: 1:38 PM Local: 4:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 19, 17, 28, 0, false);          // UTC: 5:28 PM Local: 8:28 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 23, 13, 41, 0, false);          // UTC: 1:41 PM Local: 4:41 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 9, 4, 52, 0, false);            // UTC: 4:52 AM Local: 7:52 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 6, 14, 18, 0, false);           // UTC: 2:18 PM Local: 5:18 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 3, 13, 38, 0, false);           // UTC: 1:38 PM Local: 4:38 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 4, 22, 10, 0, false);           // UTC: 10:10 PM Local: 1:10 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 3, 14, 52, 0, false);           // UTC: 2:52 PM Local: 5:52 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 10, 17, 32, 0, false);          // UTC: 5:32 PM Local: 8:32 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 17, 9, 55, 0, false);           // UTC: 9:55 AM Local: 12:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 24, 6, 4, 0, false);            // UTC: 6:04 AM Local: 9:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 9, 17, 30, 0, false);           // UTC: 5:30 PM Local: 8:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 6, 13, 35, 0, false);           // UTC: 1:35 PM Local: 4:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 25, 10, 42, 0, false);          // UTC: 10:42 AM Local: 1:42 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 15, 7, 12, 0, false);           // UTC: 7:12 AM Local: 10:12 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 10, 17, 2, 0, false);           // UTC: 5:02 PM Local: 8:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 6, 12, 3, 0, false);            // UTC: 12:03 PM Local: 3:03 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 21, 22, 52, 0, false);          // UTC: 10:52 PM Local: 1:52 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 24, 3, 55, 0, false);           // UTC: 3:55 AM Local: 6:55 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 21, 7, 57, 0, false);           // UTC: 7:57 AM Local: 10:57 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 9, 26, 5, 9, 0, false);            // UTC: 5:09 AM Local: 8:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 21, 10, 54, 0, false);         // UTC: 10:54 AM Local: 1:54 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 22, 20, 52, 0, false);         // UTC: 8:52 PM Local: 11:52 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 22, 20, 57, 0, false);         // UTC: 8:57 PM Local: 11:57 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 2, 5, 29, 0, false);           // UTC: 5:29 AM Local: 8:29 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 13, 12, 18, 0, false);         // UTC: 12:18 PM Local: 3:18 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 19, 22, 1, 0, false);          // UTC: 10:01 PM Local: 1:01 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 14, 9, 51, 0, false);          // UTC: 9:51 AM Local: 12:51 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 24, 2, 19, 0, false);          // UTC: 2:19 AM Local: 5:19 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 5, 10, 35, 0, false);          // UTC: 10:35 AM Local: 1:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 16, 10, 15, 0, false);         // UTC: 10:15 AM Local: 1:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 17, 22, 14, 0, false);         // UTC: 10:14 PM Local: 1:14 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 16, 17, 53, 0, false);         // UTC: 5:53 PM Local: 8:53 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 8, 12, 50, 0, false);          // UTC: 12:50 PM Local: 3:50 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 4, 9, 39, 0, false);           // UTC: 9:39 AM Local: 12:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 3, 16, 43, 0, false);          // UTC: 4:43 PM Local: 7:43 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 11, 9, 35, 0, false);          // UTC: 9:35 AM Local: 12:35 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 18, 1, 20, 0, false);          // UTC: 1:20 AM Local: 4:20 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 26, 9, 48, 0, false);          // UTC: 9:48 AM Local: 12:48 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 8, 20, 18, 0, false);          // UTC: 8:18 PM Local: 11:18 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 17, 14, 26, 0, false);         // UTC: 2:26 PM Local: 5:26 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 9, 4, 25, 0, false);           // UTC: 4:25 AM Local: 7:25 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 20, 9, 14, 0, false);          // UTC: 9:14 AM Local: 12:14 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 7, 20, 45, 0, false);          // UTC: 8:45 PM Local: 11:45 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 11, 8, 25, 0, false);          // UTC: 8:25 AM Local: 11:25 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 10, 5, 8, 57, 0, false);           // UTC: 8:57 AM Local: 11:57 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 6, 18, 23, 0, false);          // UTC: 6:23 PM Local: 9:23 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 16, 18, 2, 0, false);          // UTC: 6:02 PM Local: 9:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 27, 21, 22, 0, false);         // UTC: 9:22 PM Local: 12:22 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 26, 15, 31, 0, false);         // UTC: 3:31 PM Local: 6:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 12, 6, 53, 0, false);          // UTC: 6:53 AM Local: 9:53 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 16, 15, 54, 0, false);         // UTC: 3:54 PM Local: 6:54 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 12, 19, 12, 0, false);         // UTC: 7:12 PM Local: 10:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 7, 8, 16, 0, false);           // UTC: 8:16 AM Local: 11:16 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 14, 3, 29, 0, false);          // UTC: 3:29 AM Local: 6:29 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 23, 5, 40, 0, false);          // UTC: 5:40 AM Local: 8:40 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 25, 18, 4, 0, false);          // UTC: 6:04 PM Local: 9:04 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 23, 1, 4, 0, false);           // UTC: 1:04 AM Local: 4:04 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 25, 0, 49, 0, false);          // UTC: 12:49 AM Local: 3:49 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 11, 7, 15, 0, false);          // UTC: 7:15 AM Local: 10:15 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 2, 17, 45, 0, false);          // UTC: 5:45 PM Local: 8:45 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 20, 18, 37, 0, false);         // UTC: 6:37 PM Local: 9:37 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 24, 18, 41, 0, false);         // UTC: 6:41 PM Local: 9:41 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 14, 17, 30, 0, false);         // UTC: 5:30 PM Local: 8:30 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 21, 22, 24, 0, false);         // UTC: 10:24 PM Local: 1:24 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 4, 2, 37, 0, false);           // UTC: 2:37 AM Local: 5:37 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 15, 3, 42, 0, false);          // UTC: 3:42 AM Local: 6:42 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 19, 0, 50, 0, false);          // UTC: 12:50 AM Local: 3:50 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 13, 13, 11, 0, false);         // UTC: 1:11 PM Local: 4:11 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 23, 15, 39, 0, false);         // UTC: 3:39 PM Local: 6:39 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 11, 3, 0, 31, 0, false);           // UTC: 12:31 AM Local: 3:31 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 26, 3, 35, 0, false);          // UTC: 3:35 AM Local: 6:35 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 14, 17, 19, 0, false);         // UTC: 5:19 PM Local: 8:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 24, 22, 23, 0, false);         // UTC: 10:23 PM Local: 1:23 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 27, 9, 2, 0, false);           // UTC: 9:02 AM Local: 12:02 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 16, 1, 5, 0, false);           // UTC: 1:05 AM Local: 4:05 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 18, 18, 54, 0, false);         // UTC: 6:54 PM Local: 9:54 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 6, 19, 9, 0, false);           // UTC: 7:09 PM Local: 10:09 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 15, 8, 44, 0, false);          // UTC: 8:44 AM Local: 11:44 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 25, 5, 14, 0, false);          // UTC: 5:14 AM Local: 8:14 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 12, 0, 9, 0, false);           // UTC: 12:09 AM Local: 3:09 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 2, 9, 43, 0, false);           // UTC: 9:43 AM Local: 12:43 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 27, 18, 47, 0, false);         // UTC: 6:47 PM Local: 9:47 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 23, 13, 19, 0, false);         // UTC: 1:19 PM Local: 4:19 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 8, 15, 9, 0, false);           // UTC: 3:09 PM Local: 6:09 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 9, 16, 36, 0, false);          // UTC: 4:36 PM Local: 7:36 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 22, 21, 29, 0, false);         // UTC: 9:29 PM Local: 12:29 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 3, 3, 50, 0, false);           // UTC: 3:50 AM Local: 6:50 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 20, 19, 8, 0, false);          // UTC: 7:08 PM Local: 10:08 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 10, 9, 46, 0, false);          // UTC: 9:46 AM Local: 12:46 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 23, 14, 31, 0, false);         // UTC: 2:31 PM Local: 5:31 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 3, 9, 55, 0, false);           // UTC: 9:55 AM Local: 12:55 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 7, 21, 56, 0, false);          // UTC: 9:56 PM Local: 12:56 PM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 9, 13, 15, 0, false);          // UTC: 1:15 PM Local: 4:15 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 8, 19, 12, 0, false);          // UTC: 7:12 PM Local: 10:12 AM Offset: -09:00:00
	testCount++; failedCount += test(timeManager, 0, 2020, 12, 17, 21, 11, 0, false);         // UTC: 9:11 PM Local: 12:11 PM Offset: -09:00:00

	Serial.println(); Serial.print(failedCount); Serial.print(" of "); Serial.print(testCount); Serial.println(" test(s) failed.");
}
#endif
