// ***
// *** Copyright(C) 2020, Daniel M. Porrey. All rights reserved.
// *** 
// *** This program is free software: you can redistribute it and/or modify
// *** it under the terms of the GNU Lesser General Public License as published
// *** by the Free Software Foundation, either version 3 of the License, or
// *** (at your option) any later version.
// *** 
// *** This program is distributed in the hope that it will be useful,
// *** but WITHOUT ANY WARRANTY; without even the implied warranty of
// *** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// *** GNU Lesser General Public License for more details.
// *** 
// *** You should have received a copy of the GNU Lesser General Public License
// *** along with this program. If not, see http://www.gnu.org/licenses/.
// ***

/*

This font was generated from GFX Font Editor.

Font Name:      ClockFont
Date Created:   Tuesday, March 17, 2020 10:45 PM
Last Modified:  Sunday, March 22, 2020 9:15 AM
Version:        1.19
License:        LGPL-3.0

https://github.com/porrey/Clock3


This font is designed to work with the Adafruit_GFX library.
See https://learn.adafruit.com/creating-custom-symbol-font-for-adafruit-gfx-library/overview
for information on creating fonts. The library source code can be found at
https://github.com/adafruit/Adafruit-GFX-Library.

This is a 7 point font created for the Spikenzie Labs Solder:Time Desk Clock
designed to be used with the new rewritten firmware called Clock3. See the
source at https://github.com/porrey/Clock3

*/

#define CLOCKFONT_USE_EXTENDED 0

const uint8_t ClockFontBitmaps[] PROGMEM =
{
	0x00,                          /* 0x20  Space */
	0x80, 0x80, 0x80, 0x00, 0x80,  /* 0x21 ! */
	0xa0, 0xa0,                    /* 0x22 " */
	0x50, 0xf8, 0x50, 0xf8, 0x50,  /* 0x23 # */
	0x40, 0xe0, 0x40, 0xe0, 0x40,  /* 0x24 $ */
	0x80, 0x20, 0x40, 0x80, 0x20,  /* 0x25 % */
	0x40, 0xa0, 0x40, 0xa0, 0x50,  /* 0x26 & */
	0x80, 0x80,                    /* 0x27 ' */
	0x40, 0x80, 0x80, 0x80, 0x40,  /* 0x28 ( */
	0x80, 0x40, 0x40, 0x40, 0x80,  /* 0x29 ) */
	0xa0, 0x40, 0xa0,              /* 0x2a * */
	0x40, 0xe0, 0x40,              /* 0x2b + */
	0x40, 0x80,                    /* 0x2c , */
	0xc0,                          /* 0x2d - */
	0x80,                          /* 0x2e . */
	0x08, 0x10, 0x20, 0x40, 0x80,  /* 0x2f / */
	0xe0, 0xa0, 0xa0, 0xa0, 0xe0,  /* 0x30 0 */
	0x80, 0x80, 0x80, 0x80, 0x80,  /* 0x31 1 */
	0xe0, 0x20, 0xe0, 0x80, 0xe0,  /* 0x32 2 */
	0xe0, 0x20, 0xe0, 0x20, 0xe0,  /* 0x33 3 */
	0xa0, 0xa0, 0xe0, 0x20, 0x20,  /* 0x34 4 */
	0xe0, 0x80, 0xe0, 0x20, 0xe0,  /* 0x35 5 */
	0xe0, 0x80, 0xe0, 0xa0, 0xe0,  /* 0x36 6 */
	0xe0, 0x20, 0x20, 0x20, 0x20,  /* 0x37 7 */
	0xe0, 0xa0, 0xe0, 0xa0, 0xe0,  /* 0x38 8 */
	0xe0, 0xa0, 0xe0, 0x20, 0xe0,  /* 0x39 9 */
	0x80, 0x00, 0x80,              /* 0x3a : */
	0x40, 0x00, 0x40, 0x80,        /* 0x3b ; */
	0x20, 0x40, 0x80, 0x40, 0x20,  /* 0x3c < */
	0xc0, 0x00, 0xc0,              /* 0x3d = */
	0x80, 0x40, 0x20, 0x40, 0x80,  /* 0x3e > */
	0xe0, 0x20, 0x60, 0x00, 0x40,  /* 0x3f ? */
	0xc0, 0xa0, 0xe0, 0x80, 0x60,  /* 0x40 @ */
	0xe0, 0xa0, 0xe0, 0xa0, 0xa0,  /* 0x41 A */
	0xe0, 0xa0, 0xc0, 0xa0, 0xe0,  /* 0x42 B */
	0xe0, 0x80, 0x80, 0x80, 0xe0,  /* 0x43 C */
	0xc0, 0xa0, 0xa0, 0xa0, 0xc0,  /* 0x44 D */
	0xe0, 0x80, 0xc0, 0x80, 0xe0,  /* 0x45 E */
	0xe0, 0x80, 0xc0, 0x80, 0x80,  /* 0x46 F */
	0x60, 0x80, 0xe0, 0xa0, 0x60,  /* 0x47 G */
	0xa0, 0xa0, 0xe0, 0xa0, 0xa0,  /* 0x48 H */
	0xe0, 0x40, 0x40, 0x40, 0xe0,  /* 0x49 I */
	0x60, 0x20, 0x20, 0xa0, 0xc0,  /* 0x4a J */
	0xa0, 0xa0, 0xc0, 0xa0, 0xa0,  /* 0x4b K */
	0x80, 0x80, 0x80, 0x80, 0xe0,  /* 0x4c L */
	0x88, 0x88, 0xd8, 0xa8, 0xa8,  /* 0x4d M */
	0x90, 0xd0, 0xb0, 0x90, 0x90,  /* 0x4e N */
	0xe0, 0xa0, 0xa0, 0xa0, 0xe0,  /* 0x4f O */
	0xe0, 0xa0, 0xe0, 0x80, 0x80,  /* 0x50 P */
	0xe0, 0xa0, 0xa0, 0xa0, 0xd0,  /* 0x51 Q */
	0xe0, 0xa0, 0xc0, 0xa0, 0xa0,  /* 0x52 R */
	0xe0, 0x80, 0xe0, 0x20, 0xe0,  /* 0x53 S */
	0xe0, 0x40, 0x40, 0x40, 0x40,  /* 0x54 T */
	0xa0, 0xa0, 0xa0, 0xa0, 0xe0,  /* 0x55 U */
	0xa0, 0xa0, 0xa0, 0xa0, 0x40,  /* 0x56 V */
	0x88, 0x88, 0xa8, 0x70, 0x20,  /* 0x57 W */
	0x88, 0x50, 0x20, 0x50, 0x88,  /* 0x58 X */
	0xa0, 0xa0, 0x40, 0x40, 0x40,  /* 0x59 Y */
	0xe0, 0x20, 0x40, 0x80, 0xe0,  /* 0x5a Z */
	0xc0, 0x80, 0x80, 0x80, 0xc0,  /* 0x5b [ */
	0x80, 0x40, 0x20, 0x10, 0x08,  /* 0x5c \ */
	0xc0, 0x40, 0x40, 0x40, 0xc0,  /* 0x5d ] */
	0x40, 0xa0,                    /* 0x5e ^ */
	0xe0,                          /* 0x5f _ */
	0x80, 0x40,                    /* 0x60 ` */
	0x40, 0xa0, 0x60, 0xa0, 0xe0,  /* 0x61 a */
	0x80, 0x80, 0xe0, 0xa0, 0xe0,  /* 0x62 b */
	0x60, 0x80, 0x60,              /* 0x63 c */
	0x20, 0x20, 0xe0, 0xa0, 0xe0,  /* 0x64 d */
	0x40, 0xa0, 0xc0, 0x80, 0xe0,  /* 0x65 e */
	0x40, 0xa0, 0xc0, 0x80, 0x80,  /* 0x66 f */
	0x40, 0xa0, 0x40, 0x20, 0xe0,  /* 0x67 g */
	0x80, 0x80, 0xe0, 0xa0, 0xa0,  /* 0x68 h */
	0x40, 0x00, 0x40, 0x40, 0x40,  /* 0x69 i */
	0x40, 0x00, 0x40, 0x40, 0xc0,  /* 0x6a j */
	0x80, 0x80, 0xa0, 0xc0, 0xa0,  /* 0x6b k */
	0xc0, 0x40, 0x40, 0x40, 0xe0,  /* 0x6c l */
	0x88, 0xd8, 0xa8, 0x88,        /* 0x6d m */
	0x40, 0xa0, 0xa0, 0xa0,        /* 0x6e n */
	0x40, 0xa0, 0x40,              /* 0x6f o */
	0x40, 0xa0, 0xe0, 0x80, 0x80,  /* 0x70 p */
	0xc0, 0xa0, 0x60, 0x20, 0x20,  /* 0x71 q */
	0x40, 0xa0, 0x80, 0x80,        /* 0x72 r */
	0xc0, 0x80, 0x40, 0xc0,        /* 0x73 s */
	0x40, 0xe0, 0x40, 0x40, 0x60,  /* 0x74 t */
	0xa0, 0xa0, 0xc0,              /* 0x75 u */
	0xa0, 0xa0, 0x40,              /* 0x76 v */
	0xa8, 0x70, 0x20,              /* 0x77 w */
	0xa0, 0x40, 0xa0,              /* 0x78 x */
	0xa0, 0xe0, 0x20, 0xe0,        /* 0x79 y */
	0xe0, 0x40, 0x20, 0xe0,        /* 0x7a z */
	0x60, 0x40, 0x80, 0x40, 0x60,  /* 0x7b { */
	0x80, 0x80, 0x80, 0x80, 0x80,  /* 0x7c | */
	0xc0, 0x40, 0x20, 0x40, 0xc0,  /* 0x7d } */
	0xa0, 0x50                     /* 0x7e ~ */
#if (CLOCKFONT_USE_EXTENDED)
#endif
};

/* {offset, width, height, advance cursor, x offset, y offset} */
const GFXglyph ClockFontGlyphs[] PROGMEM =
{
	{ 0, 8, 1, 2, 0, 0 },     /* 0x20  Space */
	{ 1, 8, 5, 2, 0, -5 },    /* 0x21 ! */
	{ 6, 8, 2, 4, 0, -5 },    /* 0x22 " */
	{ 8, 8, 5, 6, 0, -5 },    /* 0x23 # */
	{ 13, 8, 5, 4, 0, -5 },   /* 0x24 $ */
	{ 18, 8, 5, 4, 0, -5 },   /* 0x25 % */
	{ 23, 8, 5, 5, 0, -5 },   /* 0x26 & */
	{ 28, 8, 2, 2, 0, -5 },   /* 0x27 ' */
	{ 30, 8, 5, 3, 0, -5 },   /* 0x28 ( */
	{ 35, 8, 5, 3, 0, -5 },   /* 0x29 ) */
	{ 40, 8, 3, 4, 0, -4 },   /* 0x2a * */
	{ 43, 8, 3, 4, 0, -4 },   /* 0x2b + */
	{ 46, 8, 2, 3, 0, -2 },   /* 0x2c , */
	{ 48, 8, 1, 3, 0, -3 },   /* 0x2d - */
	{ 49, 8, 1, 2, 0, -1 },   /* 0x2e . */
	{ 50, 8, 5, 6, 0, -5 },   /* 0x2f / */
	{ 55, 8, 5, 4, 0, -5 },   /* 0x30 0 */
	{ 60, 8, 5, 2, 0, -5 },   /* 0x31 1 */
	{ 65, 8, 5, 4, 0, -5 },   /* 0x32 2 */
	{ 70, 8, 5, 4, 0, -5 },   /* 0x33 3 */
	{ 75, 8, 5, 4, 0, -5 },   /* 0x34 4 */
	{ 80, 8, 5, 4, 0, -5 },   /* 0x35 5 */
	{ 85, 8, 5, 4, 0, -5 },   /* 0x36 6 */
	{ 90, 8, 5, 4, 0, -5 },   /* 0x37 7 */
	{ 95, 8, 5, 4, 0, -5 },   /* 0x38 8 */
	{ 100, 8, 5, 4, 0, -5 },  /* 0x39 9 */
	{ 105, 8, 3, 2, 0, -4 },  /* 0x3a : */
	{ 108, 8, 4, 3, 0, -4 },  /* 0x3b ; */
	{ 112, 8, 5, 4, 0, -5 },  /* 0x3c < */
	{ 117, 8, 3, 3, 0, -4 },  /* 0x3d = */
	{ 120, 8, 5, 4, 0, -5 },  /* 0x3e > */
	{ 125, 8, 5, 4, 0, -5 },  /* 0x3f ? */
	{ 130, 8, 5, 4, 0, -5 },  /* 0x40 @ */
	{ 135, 8, 5, 4, 0, -5 },  /* 0x41 A */
	{ 140, 8, 5, 4, 0, -5 },  /* 0x42 B */
	{ 145, 8, 5, 4, 0, -5 },  /* 0x43 C */
	{ 150, 8, 5, 4, 0, -5 },  /* 0x44 D */
	{ 155, 8, 5, 4, 0, -5 },  /* 0x45 E */
	{ 160, 8, 5, 4, 0, -5 },  /* 0x46 F */
	{ 165, 8, 5, 4, 0, -5 },  /* 0x47 G */
	{ 170, 8, 5, 4, 0, -5 },  /* 0x48 H */
	{ 175, 8, 5, 4, 0, -5 },  /* 0x49 I */
	{ 180, 8, 5, 4, 0, -5 },  /* 0x4a J */
	{ 185, 8, 5, 4, 0, -5 },  /* 0x4b K */
	{ 190, 8, 5, 4, 0, -5 },  /* 0x4c L */
	{ 195, 8, 5, 6, 0, -5 },  /* 0x4d M */
	{ 200, 8, 5, 5, 0, -5 },  /* 0x4e N */
	{ 205, 8, 5, 4, 0, -5 },  /* 0x4f O */
	{ 210, 8, 5, 4, 0, -5 },  /* 0x50 P */
	{ 215, 8, 5, 5, 0, -5 },  /* 0x51 Q */
	{ 220, 8, 5, 4, 0, -5 },  /* 0x52 R */
	{ 225, 8, 5, 4, 0, -5 },  /* 0x53 S */
	{ 230, 8, 5, 4, 0, -5 },  /* 0x54 T */
	{ 235, 8, 5, 4, 0, -5 },  /* 0x55 U */
	{ 240, 8, 5, 4, 0, -5 },  /* 0x56 V */
	{ 245, 8, 5, 5, 0, -5 },  /* 0x57 W */
	{ 250, 8, 5, 6, 0, -5 },  /* 0x58 X */
	{ 255, 8, 5, 4, 0, -5 },  /* 0x59 Y */
	{ 260, 8, 5, 4, 0, -5 },  /* 0x5a Z */
	{ 265, 8, 5, 3, 0, -5 },  /* 0x5b [ */
	{ 270, 8, 5, 6, 0, -5 },  /* 0x5c \ */
	{ 275, 8, 5, 3, 0, -5 },  /* 0x5d ] */
	{ 280, 8, 2, 4, 0, -5 },  /* 0x5e ^ */
	{ 282, 8, 1, 3, 0, -1 },  /* 0x5f _ */
	{ 283, 8, 2, 3, 0, -5 },  /* 0x60 ` */
	{ 285, 8, 5, 4, 0, -5 },  /* 0x61 a */
	{ 290, 8, 5, 4, 0, -5 },  /* 0x62 b */
	{ 295, 8, 3, 4, 0, -3 },  /* 0x63 c */
	{ 298, 8, 5, 4, 0, -5 },  /* 0x64 d */
	{ 303, 8, 5, 4, 0, -5 },  /* 0x65 e */
	{ 308, 8, 5, 4, 0, -5 },  /* 0x66 f */
	{ 313, 8, 5, 4, 0, -4 },  /* 0x67 g */
	{ 318, 8, 5, 4, 0, -5 },  /* 0x68 h */
	{ 323, 8, 5, 3, 0, -5 },  /* 0x69 i */
	{ 328, 8, 5, 3, 0, -4 },  /* 0x6a j */
	{ 333, 8, 5, 4, 0, -5 },  /* 0x6b k */
	{ 338, 8, 5, 4, 0, -5 },  /* 0x6c l */
	{ 343, 8, 4, 6, 0, -4 },  /* 0x6d m */
	{ 347, 8, 4, 4, 0, -4 },  /* 0x6e n */
	{ 351, 8, 3, 4, 0, -3 },  /* 0x6f o */
	{ 354, 8, 5, 4, 0, -5 },  /* 0x70 p */
	{ 359, 8, 5, 4, 0, -5 },  /* 0x71 q */
	{ 364, 8, 4, 4, 0, -4 },  /* 0x72 r */
	{ 368, 8, 4, 3, 0, -4 },  /* 0x73 s */
	{ 372, 8, 5, 4, 0, -5 },  /* 0x74 t */
	{ 377, 8, 3, 4, 0, -3 },  /* 0x75 u */
	{ 380, 8, 3, 4, 0, -3 },  /* 0x76 v */
	{ 383, 8, 3, 6, 0, -3 },  /* 0x77 w */
	{ 386, 8, 3, 4, 0, -3 },  /* 0x78 x */
	{ 389, 8, 4, 4, 0, -3 },  /* 0x79 y */
	{ 393, 8, 4, 4, 0, -4 },  /* 0x7a z */
	{ 397, 8, 5, 4, 0, -5 },  /* 0x7b { */
	{ 402, 8, 5, 2, 0, -5 },  /* 0x7c | */
	{ 407, 8, 5, 4, 0, -5 },  /* 0x7d } */
	{ 412, 8, 2, 5, 0, -4 }   /* 0x7e ~ */
#if (CLOCKFONT_USE_EXTENDED)
#endif
};

const GFXfont ClockFont PROGMEM =
{
	(uint8_t*)ClockFontBitmaps,
	(GFXglyph*)ClockFontGlyphs,
	0x20, /* First ASCII Character */
	0x7e, /* Last ASCII Character */
	0x07  /* Vertical Spacing */
};
