# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2016-01-19 03:21
from __future__ import unicode_literals

from django.conf import settings
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Remind',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('time', models.DateTimeField(db_index=True, verbose_name='\u63d0\u9192\u65f6\u95f4')),
                ('create_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='\u8bbe\u7f6e\u65f6\u95f4')),
                ('desc', models.TextField(blank=True, default='', null=True, verbose_name='\u539f\u59cb\u63cf\u8ff0')),
                ('event', models.TextField(blank=True, default='', null=True, verbose_name='\u63d0\u9192\u4e8b\u4ef6')),
                ('media_url', models.URLField(blank=True, max_length=320, null=True, verbose_name='\u8bed\u97f3')),
                ('repeat', models.CharField(blank=True, max_length=128, null=True, verbose_name='\u91cd\u590d')),
                ('participants', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=40), default=list, size=None, verbose_name='\u8ba2\u9605\u8005')),
                ('status', models.CharField(choices=[('pending', 'pending'), ('running', 'running'), ('done', 'done')], default='pending', max_length=10, verbose_name='\u72b6\u6001')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='time_reminds_created', to=settings.AUTH_USER_MODEL, verbose_name='\u521b\u5efa\u8005')),
            ],
            options={
                'ordering': ['-time'],
                'db_table': 'time_remind',
            },
        ),
        migrations.RunSQL(['CREATE INDEX ON time_remind USING GIN (participants);']),
    ]
