---
sidebar_position: 30
title: Containers
description: Working with container workloads
tags: [podman-desktop, containers]
keywords: [podman desktop, podman, containers]
hide_table_of_contents: false
---

# Working with containers

With Podman Desktop, you can manage your container engine workloads.

#### Prerequisites

- A container engine.

#### Procedure

[![Working with containers flow](https://mermaid.ink/img/pako:eNptkt2OmzAQhV_FchVxw0ZAQvi5201VqequtOpWrVpxY_BArDV2ZA_t0ijvXgNNINLe4PGcb47HZk600hxoTlerU6EIEUpgTsaQEE_q5hF-g_Ry4nEou8bz_yt4gBaGdMks3Ga_MyNYKcF6VyMnHY1omen3Wmoz1H1Iy7iqd5fSmfgGbzhTVVUtEAuVVvzWpk5DvlkwCAbFDcKTKKzr92wetOFgZjIIggVWa4WfWCtkP4iWKXtnwYjam4jzsLjPebUqFIoWpFAwRCiB_NDmVaiG_BF4IO40ZE40tlBfoREWjQA7ueTkuSulqC67-849ojOpGLr6Qn1uWTOzD52QfPCtjW7J_uJbCwmznT0MBGrCiJlO62dRymv5Ut4vWpzQF2QGZ1YRMXRSqGfNr8zeAFswxAISXd_c9z3wS1eCUYBgyc_7p0fq0xZMywR3czhOTEHHSSpo7kL3o14L6t7ZcaxD_dKriuZoOvBpd-QM4aNgjWEtzWsmrcsCF6jN0zTY43z79MgUzU_0jeZ3m816k8RRHMfpNgl3qU97mm-y7TrI0iTepmmUhlF89ulfrZ1puA6SLA6iNNplWZJkyWj2a9SGLs7_AF26CAk?type=png)](https://mermaid.live/edit#pako:eNptkt2OmzAQhV_FchVxw0ZAQvi5201VqequtOpWrVpxY_BArDV2ZA_t0ijvXgNNINLe4PGcb47HZk600hxoTlerU6EIEUpgTsaQEE_q5hF-g_Ry4nEou8bz_yt4gBaGdMks3Ga_MyNYKcF6VyMnHY1omen3Wmoz1H1Iy7iqd5fSmfgGbzhTVVUtEAuVVvzWpk5DvlkwCAbFDcKTKKzr92wetOFgZjIIggVWa4WfWCtkP4iWKXtnwYjam4jzsLjPebUqFIoWpFAwRCiB_NDmVaiG_BF4IO40ZE40tlBfoREWjQA7ueTkuSulqC67-849ojOpGLr6Qn1uWTOzD52QfPCtjW7J_uJbCwmznT0MBGrCiJlO62dRymv5Ut4vWpzQF2QGZ1YRMXRSqGfNr8zeAFswxAISXd_c9z3wS1eCUYBgyc_7p0fq0xZMywR3czhOTEHHSSpo7kL3o14L6t7ZcaxD_dKriuZoOvBpd-QM4aNgjWEtzWsmrcsCF6jN0zTY43z79MgUzU_0jeZ3m816k8RRHMfpNgl3qU97mm-y7TrI0iTepmmUhlF89ulfrZ1puA6SLA6iNNplWZJkyWj2a9SGLs7_AF26CAk)

1. [Work with registries](/docs/containers/registries).

   1. [Authenticate to pre-configured registries](/docs/containers/registries).
   1. [Add an insecure registry](/docs/containers/registries).

1. [Work with images](/docs/containers/images).
   1. [Build an image from Containerfile](/docs/containers/images/building-an-image).
   1. [Push an image](/docs/containers/images/pushing-an-image-to-a-registry).
   1. [Pull an image](/docs/containers/images/pulling-an-image).
1. [Start a container from an image](/docs/containers/starting-a-container).
1. [Create a pod from selected containers](/docs/containers/creating-a-pod).
