---
title: Podman Desktop 1.15 Release
description: Podman Desktop 1.15 has been released!
slug: podman-desktop-release-1.15
authors: [axel7083]
tags: [podman-desktop, release, kubernetes]
hide_table_of_contents: false
image: /img/blog/podman-desktop-release-1.15/banner.png
---

import ReactPlayer from 'react-player'
import useBaseUrl from '@docusaurus/useBaseUrl';
import ThemedImage from '@theme/ThemedImage';

Podman Desktop 1.15 Release! 🎉

![podman-desktop-hero-1.15](/img/blog/podman-desktop-release-1.15/banner.png)

Podman Desktop 1.15 is now available! [Click here to download it](/downloads)!

This release brings exciting new features and improvements:

- **Improved Feedback Form**: Redesigned for seamless issue reporting to GitHub 🪲.
- **New Experimental Task Manager**: A revamped task manager is now available for testing 🔔.
- **Enhanced Kubernetes Events**: Added support for events on resources like Nodes, Services, and Pods 📜.
- **SSH Access to Podman Machine**: Directly connect to your Podman machine from Podman Desktop.

---

## Release Details 🔍

### Improved Feedback Form 📝

In the 1.15 release, we introduced a redesigned feedback form to streamline issue reporting. With our growing user base,
it’s vital to provide a convenient way to submit feedback directly to GitHub via our main repository: [podman-desktop/podman-desktop/issues](https://github.com/podman-desktop/podman-desktop/issues).

While retaining our internal anonymous feedback system, this update also enables users to preview their issues on GitHub, ensuring better communication.

<ThemedImage
alt="Feedback Form"
sources={{
    light: require('./img/podman-desktop-release-1.15/feedback-form-light.png').default,
    dark: require('./img/podman-desktop-release-1.15/feedback-form-dark.png').default,
  }}
/>

#### Feedback Categories

We now offer three distinct feedback categories:

- **Direct your words to the developers**: Keeps feedback anonymous, visible only to our team.
- **Feature Request**: Redirects users to GitHub to suggest new features.
- **Bug**: Allows users to report bugs directly on GitHub.

<ThemedImage
alt="Feedback categories"
sources={{
    light: require('./img/podman-desktop-release-1.15/feedback-categories-light.png').default,
    dark: require('./img/podman-desktop-release-1.15/feedback-categories-dark.png').default,
  }}
/>

### Experimental Task Manager 🔔

Back in the [0.13 release](/blog/podman-desktop-release-0.13#new-task-manager-1724), we introduced the Task Manager. With an increasing number of long-running tasks, we’ve revamped it to improve usability. This updated version is available as an experimental feature!

#### Enabling the Experimental Task Manager

To try it out, go to `Settings > Preferences > Tasks` and enable the `Manager` option.

<ThemedImage
alt="task manager experimental preference"
sources={{
    light: require('./img/podman-desktop-release-1.15/experimental-task-manager-preference-light.png').default,
    dark: require('./img/podman-desktop-release-1.15/experimental-task-manager-preference-dark.png').default,
  }}
/>

#### What’s New?

Key changes include:

- Enhanced usage of available screen width.
- Improved consistency across the application.
- Additional capabilities for managing individual tasks.

<ThemedImage
alt="task manager experimental preference"
sources={{
    light: require('./img/podman-desktop-release-1.15/experimental-task-manager-opened-light.png').default,
    dark: require('./img/podman-desktop-release-1.15/experimental-task-manager-opened-dark.png').default,
  }}
/>

### Kubernetes Events 📜

This year, we’ve been steadily adding Kubernetes capabilities to Podman Desktop. While this effort is ongoing,
version 1.15 introduces support for [Kubernetes Events](https://kubernetes.io/docs/reference/kubernetes-api/cluster-resources/event-v1/).
These events are now available for resources like Nodes, Services, and Pods.

<ThemedImage
alt="task manager experimental preference"
sources={{
    light: require('./img/podman-desktop-release-1.15/kubernetes-node-events-light.png').default,
    dark: require('./img/podman-desktop-release-1.15/kubernetes-node-events-dark.png').default,
  }}
/>

### SSH Access to Podman Machine

A frequent user request has been the ability to establish an SSH connection to a Podman machine for debugging or configuration purposes.
In this release, you can now directly connect to your Podman machine from its details page.

<ThemedImage
alt="task manager experimental preference"
sources={{
    light: require('./img/podman-desktop-release-1.15/podman-machine-ssh-light.png').default,
    dark: require('./img/podman-desktop-release-1.15/podman-machine-ssh-dark.png').default,
  }}
/>

## Community thank you

🎉 We’d like to say a big thank you to everyone who helped to make Podman Desktop even better. In this
release, we received pull requests from the following people:

- [@Blaimi](https://github.com/Blaimi) made their first contribution in [#9925](https://github.com/podman-desktop/podman-desktop/pull/9925)
- [@Firewall](https://github.com/Firewall) made their first contribution in [#10055](https://github.com/podman-desktop/podman-desktop/pull/10055)
- [@sozercan](https://github.com/sozercan) made their first contribution in [#10082](https://github.com/podman-desktop/podman-desktop/pull/10082)
- [@mhdawson](https://github.com/mhdawson) made their first contribution in [#10178](https://github.com/podman-desktop/podman-desktop/pull/10178)

---

## Final notes

### Fixed issues

The complete list of issues fixed in this release is available [here](https://github.com/podman-desktop/podman-desktop/issues?q=is%3Aclosed+milestone%3A1.15.0).

### Where to download

Get the latest release from the [Downloads](/downloads) section of the website and boost your development journey with Podman Desktop. Additionally, visit the [GitHub repository](https://github.com/podman-desktop/podman-desktop) and see how you can help us make Podman Desktop better.

---

## Detailed release changelog

#### Documentations 📚

- docs(website): edited the doc to provide clarity in using the libkrun… by @shipsing in [#10111](https://github.com/podman-desktop/podman-desktop/pull/10111)
- docs(website): edited the managing objects section by @shipsing in [#9845](https://github.com/podman-desktop/podman-desktop/pull/9845)
- docs(website): fix mac gpu container base by @sozercan in [#10082](https://github.com/podman-desktop/podman-desktop/pull/10082)
- docs(website): highlighted port forwarding through UI by @shipsing in [#10006](https://github.com/podman-desktop/podman-desktop/pull/10006)
- docs(website): presented the info in procedural format by @shipsing in [#9972](https://github.com/podman-desktop/podman-desktop/pull/9972)
- docs(website): updated the docker compatibility section by @shipsing in [#9408](https://github.com/podman-desktop/podman-desktop/pull/9408)
- docs(website): updated the troubleshooting section by @shipsing in [#9918](https://github.com/podman-desktop/podman-desktop/pull/9918)
- docs(website): updates the outdated procedure by @shipsing in [#10090](https://github.com/podman-desktop/podman-desktop/pull/10090)
- docs(website):Added a reference section for PD extensions by @shipsing in [#9607](https://github.com/podman-desktop/podman-desktop/pull/9607)
- docs(website):Added a troubleshooting section for setting up PD on Wi… by @shipsing in [#9894](https://github.com/podman-desktop/podman-desktop/pull/9894)
- docs(website):added a blog about building a kubernetes application by @shipsing in [#9780](https://github.com/podman-desktop/podman-desktop/pull/9780)
- docs: 1.14.0 release notes by @gastoner in [#9628](https://github.com/podman-desktop/podman-desktop/pull/9628)
- docs: add microshift podman desktop example blog by @cdrage in [#9031](https://github.com/podman-desktop/podman-desktop/pull/9031)
- docs: add section about draft PR by @benoitf in [#9965](https://github.com/podman-desktop/podman-desktop/pull/9965)
- docs: blog post on AI Lab recipes by @feloy in [#9856](https://github.com/podman-desktop/podman-desktop/pull/9856)
- docs: fix syntax in CONTRIBUTING by @Blaimi in [#9925](https://github.com/podman-desktop/podman-desktop/pull/9925)
- docs: update extension landing page on index by @cdrage in [#9812](https://github.com/podman-desktop/podman-desktop/pull/9812)
- docs: update release template lowercase headers by @cdrage in [#9703](https://github.com/podman-desktop/podman-desktop/pull/9703)

### Feature 💡

- feat(extensions/kind): update projectcontour to v1.30.1 by @Blaimi in [#9927](https://github.com/podman-desktop/podman-desktop/pull/9927)
- feat(feedback): add enabled extensions in additional-context by @axel7083 in [#10276](https://github.com/podman-desktop/podman-desktop/pull/10276)
- feat(feedback): adding frontend checkbox to include system info by @axel7083 in [#10116](https://github.com/podman-desktop/podman-desktop/pull/10116)
- feat(feedback): adding support to get sys info by @axel7083 in [#10098](https://github.com/podman-desktop/podman-desktop/pull/10098)
- feat: add a bug report feedback form by @SoniaSandler in [#9833](https://github.com/podman-desktop/podman-desktop/pull/9833)
- feat: add a feature request feedback form by @SoniaSandler in [#9955](https://github.com/podman-desktop/podman-desktop/pull/9955)
- feat: add a way to clean logs in container's log page by @benoitf in [#9528](https://github.com/podman-desktop/podman-desktop/pull/9528)
- feat: add category field to feedback by @feloy in [#9761](https://github.com/podman-desktop/podman-desktop/pull/9761)
- feat: add error visual indicator in typeahead component by @gastoner in [#9782](https://github.com/podman-desktop/podman-desktop/pull/9782)
- feat: add error visual indicator pull image input by @gastoner in [#9899](https://github.com/podman-desktop/podman-desktop/pull/9899)
- feat: add new task manager by @benoitf in [#10206](https://github.com/podman-desktop/podman-desktop/pull/10206)
- feat: allow for extensions to navigate to an onboarding screen by @benoitf in [#9759](https://github.com/podman-desktop/podman-desktop/pull/9759)
- feat: allow to cancel a task from the status bar by @benoitf in [#10209](https://github.com/podman-desktop/podman-desktop/pull/10209)
- feat: allow to cancel a task that is cancellable by @benoitf in [#10100](https://github.com/podman-desktop/podman-desktop/pull/10100)
- feat: check connectivity with health check by @feloy in [#10076](https://github.com/podman-desktop/podman-desktop/pull/10076)
- feat: check permissions on resources by @feloy in [#10133](https://github.com/podman-desktop/podman-desktop/pull/10133)
- feat: collect Service events by @feloy in [#9692](https://github.com/podman-desktop/podman-desktop/pull/9692)
- feat: display 3rd party contribution to Docker Compatibility page by @benoitf in [#9777](https://github.com/podman-desktop/podman-desktop/pull/9777)
- feat: display a warning when there is no latest tag for image to pull by @feloy in [#9757](https://github.com/podman-desktop/podman-desktop/pull/9757)
- feat: display nodes events by @feloy in [#9691](https://github.com/podman-desktop/podman-desktop/pull/9691)
- feat: display services events by @feloy in [#9733](https://github.com/podman-desktop/podman-desktop/pull/9733)
- feat: force use of libPod if nvidia device requested by @mhdawson in [#10251](https://github.com/podman-desktop/podman-desktop/pull/10251)
- feat: implement dropdown menu for status bar help button by @dgolovin in [#9867](https://github.com/podman-desktop/podman-desktop/pull/9867)
- feat: improve libpod API support - translate selinux_opts by @mhdawson in [#10178](https://github.com/podman-desktop/podman-desktop/pull/10178)
- feat: improve libpod support - translate devices by @mhdawson in [#10180](https://github.com/podman-desktop/podman-desktop/pull/10180)
- feat: introduce an hidden option kubernetes.statesExperimental by @feloy in [#10018](https://github.com/podman-desktop/podman-desktop/pull/10018)
- feat: move NumberInput to svelte-ui by @feloy in [#9872](https://github.com/podman-desktop/podman-desktop/pull/9872)
- feat: port-forward on deployments by @feloy in [#9946](https://github.com/podman-desktop/podman-desktop/pull/9946)
- feat: provide ability to easily get a shell in a machine - render part by @gastoner in [#9381](https://github.com/podman-desktop/podman-desktop/pull/9381)
- feat: publish the catalog to the website in /extensions directory by @benoitf in [#9804](https://github.com/podman-desktop/podman-desktop/pull/9804)
- feat: show message box on close of feedback form by @gastoner in [#9975](https://github.com/podman-desktop/podman-desktop/pull/9975)
- feat: update to podman v5.3.1 by @benoitf in [#9882](https://github.com/podman-desktop/podman-desktop/pull/9882)

### Fixes 🔨

- fix(CliToolRegistry): notify on register install or update by @axel7083 in [#9813](https://github.com/podman-desktop/podman-desktop/pull/9813)
- fix(ci): exclude podman-remote e2e tests from running as part all tests suite by @odockal in [#9982](https://github.com/podman-desktop/podman-desktop/pull/9982)
- fix(extensions/kind): adjust contour download script for new octokit version by @Blaimi in [#9926](https://github.com/podman-desktop/podman-desktop/pull/9926)
- fix(k8s-port-forward): delete config if start fails by @axel7083 in [#9874](https://github.com/podman-desktop/podman-desktop/pull/9874)
- fix(k8s-port-forward): delete config if start fails by @axel7083 in [#9888](https://github.com/podman-desktop/podman-desktop/pull/9888)
- fix(monaco): make vscode focus border transparent by @axel7083 in [#10053](https://github.com/podman-desktop/podman-desktop/pull/10053)
- fix(status-bar): progress should be indeterminate when task is indeterminate by @axel7083 in [#9941](https://github.com/podman-desktop/podman-desktop/pull/9941)
- fix(ui): better handle errors on `KubePort` component by @axel7083 in [#9876](https://github.com/podman-desktop/podman-desktop/pull/9876)
- fix(ui): round display progress value by @axel7083 in [#10031](https://github.com/podman-desktop/podman-desktop/pull/10031)
- fix: a containerfile outside context can be used when building image by @feloy in [#9910](https://github.com/podman-desktop/podman-desktop/pull/9910)
- fix: add light mode color to toast text by @SoniaSandler in [#9915](https://github.com/podman-desktop/podman-desktop/pull/9915)
- fix: added questionmark by @gastoner in [#9814](https://github.com/podman-desktop/podman-desktop/pull/9814)
- fix: apply 0/0 as uid/gid when sending the tar as build context by @benoitf in [#10282](https://github.com/podman-desktop/podman-desktop/pull/10282)
- fix: cache pod exec websockets by @jeffmaury in [#10165](https://github.com/podman-desktop/podman-desktop/pull/10165)
- fix: compose installation via onboarding and cli tools by @dgolovin in [#10148](https://github.com/podman-desktop/podman-desktop/pull/10148)
- fix: create new connection form dropdown FormData by @SoniaSandler in [#9708](https://github.com/podman-desktop/podman-desktop/pull/9708)
- fix: creating hyperv machine in airgap now does not try to use wsl image by @gastoner in [#9715](https://github.com/podman-desktop/podman-desktop/pull/9715)
- fix: do console logging only if app is not quitting by @SoniaSandler in [#10064](https://github.com/podman-desktop/podman-desktop/pull/10064)
- fix: do not try to monitor machine when autostarting it by @benoitf in [#10308](https://github.com/podman-desktop/podman-desktop/pull/10308)
- fix: ensure system path is created and show notification if not in PATH by @jeffmaury in [#10176](https://github.com/podman-desktop/podman-desktop/pull/10176)
- fix: flaky test waitForPodsDeletion by @feloy in [#9875](https://github.com/podman-desktop/podman-desktop/pull/9875)
- fix: handle promise result by @jeffmaury in [#9700](https://github.com/podman-desktop/podman-desktop/pull/9700)
- fix: improve libpod API translation - extension by @mhdawson in [#10179](https://github.com/podman-desktop/podman-desktop/pull/10179)
- fix: navigation url to use summary by @axel7083 in [#9696](https://github.com/podman-desktop/podman-desktop/pull/9696)
- fix: proxy settings do not take effect when switched to system or disabled by @jeffmaury in [#10062](https://github.com/podman-desktop/podman-desktop/pull/10062)
- fix: rely on configurationValues if it has the key value by @lstocchi in [#9951](https://github.com/podman-desktop/podman-desktop/pull/9951)
- fix: remove extra border in details page by @axel7083 in [#10050](https://github.com/podman-desktop/podman-desktop/pull/10050)
- fix: remove nullable detailsPage binding by @axel7083 in [#9788](https://github.com/podman-desktop/podman-desktop/pull/9788)
- fix: restart container on terminal page by @feloy in [#9796](https://github.com/podman-desktop/podman-desktop/pull/9796)
- fix: skip filesystem flaky test by @axel7083 in [#10075](https://github.com/podman-desktop/podman-desktop/pull/10075)
- fix: sort array of image names, move matches on top by @dgolovin in [#9831](https://github.com/podman-desktop/podman-desktop/pull/9831)
- fix: start secondary informers for current context only by @feloy in [#9735](https://github.com/podman-desktop/podman-desktop/pull/9735)
- fix: status bar progress bar percentage display by @axel7083 in [#9791](https://github.com/podman-desktop/podman-desktop/pull/9791)
- fix: stub every missing function in renderer package tests by @dgolovin in [#9773](https://github.com/podman-desktop/podman-desktop/pull/9773)
- fix: table component should be scoped when searching items by @benoitf in [#10211](https://github.com/podman-desktop/podman-desktop/pull/10211)
- fix: terminal is not restarted if container if not running + state management by @feloy in [#9793](https://github.com/podman-desktop/podman-desktop/pull/9793)
- fix: test:renderer test failure by @jeffmaury in [#10264](https://github.com/podman-desktop/podman-desktop/pull/10264)
- fix: tty when container run with it options by @feloy in [#9745](https://github.com/podman-desktop/podman-desktop/pull/9745)
- fix: update Kubernetes context watchers messages by @jeffmaury in [#10017](https://github.com/podman-desktop/podman-desktop/pull/10017)
- fix: use `utf16le` ecoding in powershell call for Virtual Machine Platform detection by @dgolovin in [#9594](https://github.com/podman-desktop/podman-desktop/pull/9594)
- fix: use correct header for play kube operation by @benoitf in [#10036](https://github.com/podman-desktop/podman-desktop/pull/10036)
- fix: visibility of docker compatibility settings by @gastoner in [#10241](https://github.com/podman-desktop/podman-desktop/pull/10241)
- fix: watch /var/run/docker.sock on macOS by @dgolovin in [#9714](https://github.com/podman-desktop/podman-desktop/pull/9714)
- fix: workaround of LIMA_HOME usage by @tony-sol in [#10086](https://github.com/podman-desktop/podman-desktop/pull/10086)
- fix: wrong pnpm-lock file by @feloy in [#9754](https://github.com/podman-desktop/podman-desktop/pull/9754)
