---
title: Podman Desktop + CNCF - Community Driven Move
description: Today, we're thrilled to announce our application for Podman Desktop to join the Cloud Native Computing Foundation (CNCF) as a Sandbox project.
authors: [meisele, slemeur]
tags: [podman-desktop, podman, cncf, container]
hide_table_of_contents: false
---

import Tabs from '@theme/Tabs';
import TabItem from '@theme/TabItem';

![banner](img/podman-desktop-cncf/cncf_rocket.png)

Today, we're thrilled to announce our application for Podman Desktop to join the Cloud Native Computing Foundation (CNCF) as a Sandbox project.This is a huge milestone for our project and our community, and we're incredibly excited for what the future holds.

### About Podman Desktop

Podman Desktop builds upon the innovations brought by Podman, offering a powerful yet user-friendly environment for containerized development. Podman provides a daemonless, rootless container engine that enhances security and flexibility, while Podman Desktop delivers an intuitive graphical interface for managing containers and interacting with Kubernetes. Enhanced by a plug-in system that allows developers to customize their inner loop container workflows to their needs and offers flexible extension points for other projects as well as other container engines.

### Why the CNCF?

The CNCF is a vital organization for the cloud-native world, supporting collaboration and driving innovation for critical projects like Kubernetes, Prometheus, and Envoy. As a CNCF project, Podman Desktop will benefit from increased visibility, a neutral home for open governance, and access to a wealth of resources and expertise. CNCF projects will take a renewed interest in collaborating with us. This move will help us grow our community, ensure the project's long-term sustainability, and accelerate its development.

### How Podman Desktop simplifies containers and Kubernetes

Developing with containers can be complex. Podman Desktop simplifies this by providing an intuitive interface and powerful tools for building, managing, and running containers. This allows developers to focus on writing code, not wrestling with infrastructure. Why is this important? Because in today's complex world, developer productivity is paramount. By removing friction and simplifying workflows, Podman Desktop empowers developers to deliver value faster.
Podman Desktop enables developers to run Kubernetes locally, mirroring their production environment. This eliminates the "works on my machine" problem and allows for early detection of configuration issues. By closing the gap between development and production, Podman Desktop reduces deployment risks and accelerates the feedback loop. This leads to higher quality software and faster release cycles.

### Open source and the CNCF: A perfect match for developer tools

We believe in the power of open source. Open source software fosters transparency, encourages collaboration, and drives innovation. By donating Podman Desktop to the CNCF, we're ensuring it remains open and accessible to all, fostering a vibrant community around it. The CNCF is the perfect home for Podman Desktop because it champions open source values and provides a neutral ground for collaborative development. This ensures that Podman Desktop remains vendor-neutral and driven by the needs of its users, keeping options open and avoiding vendor lock-in.

Furthermore, while the CNCF has fostered incredible innovation and many developers profit from the number of projects available through the CNCF, there's a recognized need for more developer-focused tooling. Podman Desktop fills this gap perfectly by providing a developer-centric, streamlined, and intuitive experience for containerizing, managing, and deploying cloud-native applications.
Podman Desktop has a natural affinity to Kubernetes due to its design and features that seamlessly bridge the gap between local container development and Kubernetes deployments. This close relationship aligns perfectly with the CNCF's mission to drive the adoption of cloud-native technologies.

### Join the growing Podman Desktop community

As a CNCF project, we have the opportunity to open our doors to a wider community of contributors and users. We believe that open source thrives on collaboration and diverse perspectives. By broadening our contributor base, we can accelerate innovation, improve the quality of Podman Desktop, and ensure it meets the needs of a diverse range of users.

### You can contribute in various ways

- Reporting issues: If you encounter bugs or have suggestions for improvements, you can report them on the [GitHub issue tracker](https://github.com/podman-desktop/podman-desktop/issues). Be sure to provide detailed information and steps to reproduce the issue.

- Working on issues: You can browse the [issue tracker](https://github.com/podman-desktop/podman-desktop/issues) and contribute by fixing bugs or implementing new features. This involves forking the repository, making changes, and submitting pull requests.

- Contributing code: Beyond addressing existing issues, you can propose and contribute entirely new features or enhancements to Podman Desktop's functionality, user interface, or integrations with other tools. Learn more about [how to contribute](https://github.com/podman-desktop/podman-desktop/blob/main/CONTRIBUTING.md).

- Contributing plug-ins: Feel like there is an integration missing? You can contribute your own plug-in functionality for Podman Desktop. [Check out the guide](https://podman-desktop.io/blog/extensions-introduction).

- Improving documentation: Clear and comprehensive documentation is essential. You can contribute by improving existing documentation, adding new guides, or creating tutorials.

- Providing website contributions: The [Podman Desktop website](https://podman-desktop.io/) is also open source. You can contribute to its content, design, or translations.

- Becoming an Adopter: If you are a happy user, we’d love to know and share the word. Consider adding yourself or your organization to [the list of adopters](https://github.com/podman-desktop/podman-desktop/blob/main/ADOPTERS.md) with a pull request.

Before you start contributing, it's helpful to familiarize yourself with the [project's contribution guidelines](https://github.com/podman-desktop/podman-desktop/blob/main/CONTRIBUTING.md) and code architecture. These resources provide valuable information on coding style, testing procedures, and the overall development process. You can also join #podman-desktop on the Kubernetes Slack to connect with other contributors and get help.

### KubeCon 2024 and beyond

We are at KubeCon NA 2024 in Salt Lake, to officially announce this exciting news and share more about Podman Desktop and our roadmap. Stop by the Red Hat booth to say hello, contribute to the project, and help us shape the future of cloud-native development.

### Get involved and learn more

We're incredibly excited about this new chapter for Podman Desktop and can't wait to see what we can achieve together with the CNCF community.

- Visit our website: [https://podman-desktop.io/](https://podman-desktop.io/)

- Join our community: #podman-desktop on the Kubernetes Slack

- Contribute to the project: [https://github.com/podman-desktop/podman-desktop/](https://github.com/podman-desktop/podman-desktop/)

- Read [10 Reasons Why Developers Should Consider Podman Desktop](https://developers.redhat.com/e-books/infographic-10-reasons-why-developer-should-consider-podman-desktop)
