---
title: Podman Desktop 1.4 Release
description: Podman Desktop 1.4 has been released!
slug: podman-desktop-release-1.4
authors: [jeffmaury]
tags: [podman-desktop, release, kubernetes, openshift]
hide_table_of_contents: false
image: /img/blog/podman-desktop-release-1.4/juggling.png
---

import ReactPlayer from 'react-player'

Podman Desktop 1.4 Release! 🎉

This is essentially a bug-fix release to fix various issues in UI, but as usual we also added a few new features.

- **Podman 4.6.2**: Podman 4.6.2 included with Podman Desktop 1.4
- **Windows Arm64**: Native Windows on Arm64 installers and binaries
- **Port range mapping**: Start containers and map a range of ports
- **Terminal UX Improvement**: Persistent terminal sessions when SSH'ing in a container
- **Volume Creation**: Create volume from the `Volumes` page
- **Bash support**: Terminals are now using `bash` if available.

Podman Desktop 1.4 is now available. [Click here to download it](/downloads)!

![Podman-desktop-1-4-juggling](img/podman-desktop-release-1.4/juggling.png)

---

## Release Details

### Port range mapping [#3654](https://github.com/containers/podman-desktop/pull/3654)

When starting a new container, you can now map a port range between host and container. If the range is not valid between host and container, an error is raised.

![Range mapping](https://user-images.githubusercontent.com/49404737/262927546-da66b67a-0884-40b1-85bd-a9c3ea2f3f9e.gif)

### Terminal lifetime [#3725](https://github.com/containers/podman-desktop/pull/3725)

When a terminal is opened for a container, it can now be reused after you switched to another part of the Podman Desktop UI.

![terminal lifetime](img/podman-desktop-release-1.4/terminal.gif)

### Create volume [#3742](https://github.com/containers/podman-desktop/pull/3742)

The Volumes tab now has a Create volume button. The Create volume UI has a single field for the volume name.

![create volume](img/podman-desktop-release-1.4/create-volume.gif)

### bash support [#3750](https://github.com/containers/podman-desktop/pull/3750)

When a terminal is opened for a container, if bash is available within the container, it will be used. Otherwise, sh will be used.

![bash sh](img/podman-desktop-release-1.4/bash-sh.gif)

### Notable Bug Fixes

- Reduce API calls when listing containers by @benoitf [#3489](https://github.com/containers/podman-desktop/pull/3489)
- Removing a connection(podman machine) should redirect to previous page by @benoitf [#3576](https://github.com/containers/podman-desktop/pull/3576)
- Enhance error message when image is not there by @benoitf [#3587](https://github.com/containers/podman-desktop/pull/3587)
- Dispose kind install button when extension is deactivated (#3586) by @lstocchi [#3610](https://github.com/containers/podman-desktop/pull/3610)
- Replace backslash/slash on windows when building image (#3465) by @lstocchi [#3618](https://github.com/containers/podman-desktop/pull/3618)
- Handle null value in container command (#3620) by @lstocchi [#3625](https://github.com/containers/podman-desktop/pull/3625)
- Add maximum activation time for extensions by @benoitf [#3446](https://github.com/containers/podman-desktop/pull/3446)
- Handle single non-spread arguments by @benoitf [#3641](https://github.com/containers/podman-desktop/pull/3641)
- Grab usage data of volumes only on-demand by @benoitf [#3635](https://github.com/containers/podman-desktop/pull/3635)
- Add arm64 binaries for Windows by @benoitf [#3643](https://github.com/containers/podman-desktop/pull/3643)
- Include right airgap file for Windows and arm64 by @benoitf [#3651](https://github.com/containers/podman-desktop/pull/3651)
- Redirect to previous page when removing a kubernetes connection by @benoitf [#3650](https://github.com/containers/podman-desktop/pull/3650)
- Support port ranges when starting a container (#3204) by @lstocchi [#3654](https://github.com/containers/podman-desktop/pull/3654)
- Add a strict undefined check to messagebox result (#3692) by @lstocchi [#3699](https://github.com/containers/podman-desktop/pull/3699)
- Only restart if a machine is running by @cdrage [#3491](https://github.com/containers/podman-desktop/pull/3491)
- Session to the terminal is reused by @benoitf [#3725](https://github.com/containers/podman-desktop/pull/3725)
- Disable next button and show try again when onboarding failed (#3616) by @lstocchi [#3711](https://github.com/containers/podman-desktop/pull/3711)
- Add podman in PATH after updating process environment PATH (#3729) by @lstocchi [#3730](https://github.com/containers/podman-desktop/pull/3730)
- Allow to create a volume by @benoitf [#3742](https://github.com/containers/podman-desktop/pull/3742)
- Using bash if available otherwise sh in terminal by @axel7083 [#3750](https://github.com/containers/podman-desktop/pull/3750)
- Allow to embed existing component to onboarding (#3755) by @lstocchi [#3763](https://github.com/containers/podman-desktop/pull/3763)
- Some containers never return logs, do not wait for them by @dgolovin [#3784](https://github.com/containers/podman-desktop/pull/3784)
- Remove cancel button when on final onboarding step (#3771) by @lstocchi [#3802](https://github.com/containers/podman-desktop/pull/3802)
- Onboarding add link micromark for commands by @cdrage [#3747](https://github.com/containers/podman-desktop/pull/3747)
- Mounts can be null when using older podman by @afbjorklund [#3806](https://github.com/containers/podman-desktop/pull/3806)
- Remove redundant step completion check when onboarding gets started by @lstocchi [#3798](https://github.com/containers/podman-desktop/pull/3798)
- Ability to click enter in pull image name input by @deboer-tim [#3850](https://github.com/containers/podman-desktop/pull/3850)
- Set proxy environment variable when launching process by @jeffmaury [#3838](https://github.com/containers/podman-desktop/pull/3838)
- The socket location was moved for new podman by @afbjorklund [#3853](https://github.com/containers/podman-desktop/pull/3853)
- Don't log console errors when activating lima extension by @afbjorklund [#3852](https://github.com/containers/podman-desktop/pull/3852)

### Community Thank You

🎉 We’d like to say a big thank you to everyone who helped to make Podman Desktop even better.

A warm welcome to [@tomgoren](https://github.com/tomgoren), [@Julian](https://github.com/Julian), [@Gelob](https://github.com/Gelob) and [@cedricclyburn](https://github.com/cedricclyburn) who made their first contribution to the project in this release.

### Final Notes

The complete list of issues fixed in this release is available [here](https://github.com/containers/podman-desktop/issues?q=is%3Aclosed+milestone%3A1.4.0).

Get the latest release from the [Downloads](/downloads) section of the website and boost your development journey with Podman Desktop. Additionally, visit the [GitHub repository](https://github.com/containers/podman-desktop) and see how you can help us make Podman Desktop better.
