---
title: Podman Desktop 1.3 Release
description: Podman Desktop 1.3 has been released!
slug: podman-desktop-release-1.3
authors: [dgolovin]
tags: [podman-desktop, release, kubernetes, openshift]
hide_table_of_contents: false
image: /img/blog/podman-desktop-release-1.3.webp
---

import ReactPlayer from 'react-player'

Podman Desktop 1.3 Release! 🎉

This is essentially a bug-fix release to fix various issues in UI, extension engine and featured extensions, but as usual we also added a few new features.

- **Podman 4.6.1**: Podman 4.6.1 included in Windows and Mac installers
- **Podman user-mode networking support to Windows/WSL**: A new switch `User mode networking' is available when creating Podman machine on Windows for Podman 4.6.0+ to configure podman to work in certain VPN setups and other specialized networking configurations
- **Compose group new UI elements**: You can now see summary, inspect, deploy to kubernetes, generate kube yaml and view logs
- **Extension packs and extension dependencies**: Install group of extensions in one click
- **Resource details page update**: See summary and log for resource
- **Create Kind cluster form update**: A new `Node's container image` field can be used to specify the Kubernetes version used for the control-planed
- **Support Docker Desktop extensions using a backend**: When loading Docker Desktop extension the containers are created in the backend as described in the vm section of extension's descriptor
- **Podman Initial Onboarding (preview)**: Install and configure podman using included installer

Podman Desktop 1.3 is now available. [Click here to download it](/downloads)!

![Podman-desktop-1-3-bug-swatting](img/podman-desktop-release-1.3/title-bug-swatting.png)

---

## Release Details

### Compose group Logs tab [#3176](https://github.com/containers/podman-desktop/pull/3176)

When clicking on the group of containers, you can now view the logs of the entire group of compose containers and don't need to open
log for every component individually.

![Screenshot 2023-07-11 at 12 48 47 PM](https://github.com/containers/podman-desktop/assets/6422176/743a4ffc-e291-4697-8ac5-8052cc921946)

### Podman user-mode networking support to Windows/WSL [#3251](https://github.com/containers/podman-desktop/pull/3251)

Certain VPN setups or other specialized networking configs will block traffic from the virtual WSL networking device, resulting in the podman WSL backend from being unable to contact systems on the VPN, and potentially losing internet access altogether. The new switch allows you to create a podman VM machine configured to work correctly in mentioned above networking environments.

![user](https://github.com/containers/podman-desktop/assets/620330/2f521576-b6a6-42b5-b24d-08df5b432608)

### Compose group Summary tab [#3317](https://github.com/containers/podman-desktop/pull/3317)

Compose group Summary tab shows all containers in the group and let you navigate to Details page for specific container.

<ReactPlayer playing playsinline controls url="https://github.com/containers/podman-desktop/assets/620330/6dd6dacd-a0d8-478d-b11e-2b414108bd20" width='100%' height='100%' />

### Compose group Inspect tab [#3316](https://github.com/containers/podman-desktop/pull/3316)

Compose group Inspect tab shows an array of "container inspect" from docker / podman.

<ReactPlayer playing playsinline controls url="https://user-images.githubusercontent.com/6422176/255658081-4a2ce4ce-bdc7-435d-9114-1071ab1ec3c5.mov" width='100%' height='100%' />

### `Deploy to kubernetes` in compose actions [#3299](https://github.com/containers/podman-desktop/pull/3295)

A button to deploy to kubernetes added to Compose group.

<ReactPlayer playing playsinline controls url="https://user-images.githubusercontent.com/6422176/254973806-1ce57225-3422-4d36-8d09-b70a2825869f.mov" width='100%' height='100%' />

### `Generate Kube` in Compose actions and `Kube` tab in compose details [#3253](https://github.com/containers/podman-desktop/pull/3253)

`Generate Kube` item added to Compose actions and "Kube" tab is now available in Compose details view.

<ReactPlayer playing playsinline controls url="https://user-images.githubusercontent.com/6422176/254337805-98268722-4dde-4c0e-afdf-4873fa4f43fe.mov" width='100%' height='100%' />

### Install multiple extensions using extension pack [#3150](https://github.com/containers/podman-desktop/pull/3150)

An Extension pack introduced in Extension engine is a way to declare set of extensions to install them all at once.

<ReactPlayer playing playsinline controls url="https://user-images.githubusercontent.com/436777/251741571-0cd4a199-06f4-4890-8414-4e93ca9178bc.mp4" width='100%' height='100%' />

### Customize icons from extension [#3131](https://github.com/containers/podman-desktop/pull/3131)

Extensions now can customize icons for list elements using `when` clause.

![image](https://github.com/containers/podman-desktop/assets/49404737/7aae5347-4f07-4854-ba11-1f629b5ccf22)

### Resource details page update [#1923](https://github.com/containers/podman-desktop/pull/1923)

If you click on the arrow icon next to a resource name it will open up a details page (similarly to how clicking on a container in the container list opens up a details page).

![image](https://user-images.githubusercontent.com/49404737/229542404-bae44f89-5cd3-4baf-8b08-e934e4462697.gif)

### `Node's container image` field added to `Create a Kind cluster` form [#3508](https://github.com/containers/podman-desktop/pull/3508)

The new `Node's container image` field can be used to specify the Kubernetes version used for the control-planed.

![image](https://github.com/containers/podman-desktop/assets/42176370/b2a63faf-629f-436d-8496-7c0cd8158679)

### Support Docker Desktop extensions using a backend [#3435](https://github.com/containers/podman-desktop/pull/3435)

Podman Desktop now loads the containers in the backend as described in the vm section of extension descriptor the same way as Docker Desktop does.

### Initial onboarding implementation for podman (experimental) [#3308](https://github.com/containers/podman-desktop/pull/3308)

This is the initial implementation for the onboarding feature. It only covers a simple onboarding for podman. Check system requirements -> install podman -> yay! Done!

### Notable Bug Fixes

- Updating videos to be adaptive for mobile by @mairin [#3229](https://github.com/containers/podman-desktop/pull/3229)
- Consistent max width and padding in settings by @deboer-tim [#3232](https://github.com/containers/podman-desktop/pull/3232)
- Settings navigation bar resizing by @deboer-tim in [#3231](https://github.com/containers/podman-desktop/pull/3231)
- Move new registry button to header by @deboer-tim [#3245](https://github.com/containers/podman-desktop/pull/3245)
- Bigger lima logo by @afbjorklund [#3248](https://github.com/containers/podman-desktop/pull/3248)
- Horizontal docker logo by @afbjorklund [#3236](https://github.com/containers/podman-desktop/pull/3236)
- Respect LIMA_HOME environment variable by @afbjorklund [#3254](https://github.com/containers/podman-desktop/pull/3254)
- Add check before writing to terminal by @lstocchi [#3263](https://github.com/containers/podman-desktop/pull/3263)
- Wait until remote side has fully initialized the extensions by @benoitf [#3257](https://github.com/containers/podman-desktop/pull/3257)
- Fix loader not centered horizontally by @benoitf [#3270](https://github.com/containers/podman-desktop/pull/3270)
- Troubleshooting still waiting after failure by @deboer-tim [#3354](https://github.com/containers/podman-desktop/pull/3354)
- Store error for build by @cdrage [#3365](https://github.com/containers/podman-desktop/pull/3365)
- Missing checkbox tooltips by @deboer-tim [#3380](https://github.com/containers/podman-desktop/pull/3380)
- Load compose logs async not await by @cdrage [#3377](https://github.com/containers/podman-desktop/pull/3377)
- Set rootful connection when starting rootful machine by @lstocchi [#3364](https://github.com/containers/podman-desktop/pull/3364)
- Default last page by @deboer-tim [#3388](https://github.com/containers/podman-desktop/pull/3388)
- Avoid dashboard displaying providers starting while they don't by @benoitf [#3451](https://github.com/containers/podman-desktop/pull/3451)
- Do not use extensionInfo until it is defined by @benoitf [#V](https://github.com/containers/podman-desktop/pull/3450)
- Allow BASIC authentication (all caps) by @cdrage [#3471](https://github.com/containers/podman-desktop/pull/3471)
- Allow single domain registry such as localhost:5000 by @cdrage [#3468](https://github.com/containers/podman-desktop/pull/3468)
- Create /usr/local/bin directory if it does not exist on binary install by @cdrage [#3425](https://github.com/containers/podman-desktop/pull/3425)
- Only delete selected pods by @deboer-tim [#](https://github.com/containers/podman-desktop/pull/3378)
- Add back 'Done' text on the button by @benoitf [#3487](https://github.com/containers/podman-desktop/pull/3487)
- Do not wait for more than 5s when checking for podman ping by @benoitf [#3497](https://github.com/containers/podman-desktop/pull/3497)
- Add proxy support for extension using patching get and request approach by @dgolovin [#2825](https://github.com/containers/podman-desktop/pull/2825)
- Refresh component when field is updated by @benoitf [#3525](https://github.com/containers/podman-desktop/pull/3525)
- Higher-res icons for featured extensions list by @mairin [#3511](https://github.com/containers/podman-desktop/pull/3511)
- Main nav selection by @deboer-tim [#3510](https://github.com/containers/podman-desktop/pull/3510)
- kube event error when switching context by @jeffmaury [#3494](https://github.com/containers/podman-desktop/pull/3494)
- Reset error message each time we pull image by @benoitf [#3550](https://github.com/containers/podman-desktop/pull/3550)

### Community Thank You

🎉 We’d like to say a big thank you to everyone who helped to make Podman Desktop even better.

A warm welcome to [@rostalan](https://github.com/rostalan) and [@axel7083](https://github.com/axel7083) who made their first contribution to the project in this release.

### Final Notes

The complete list of issues fixed in this release is available [here](https://github.com/containers/podman-desktop/issues?q=is%3Aclosed+milestone%3A1.3.0).

Get the latest release from the [Downloads](/downloads) section of the website and boost your development journey with Podman Desktop. Additionally, visit the [GitHub repository](https://github.com/containers/podman-desktop) and see how you can help us make Podman Desktop better.
