---
title: Podman Desktop 1.2 Release
description: Podman Desktop 1.2 has been released!
slug: podman-desktop-release-1.2
authors: [cdrage]
tags: [podman-desktop, release, kubernetes, openshift]
hide_table_of_contents: false
image: /img/blog/podman-desktop-release-1.2.webp
---

import ReactPlayer from 'react-player'

Podman Desktop 1.2 Release! 🎉

We're excited to announce the release of Podman Desktop version 1.2.0! This release includes many new features (Kubernetes, Compose and extension support!), bug fixes, and improvements to enhance your container management experience. Here's a summary of the key changes in this release:

- **Added start/stop/delete/restart buttons for Compose**: You can now make changes to an entire Compose group of containers
- **Kubernetes context on the status bar**: Choose from multiple Kubernetes contexts more easily all from the status bar
- **Rename images**: Rename an image with a click of a button
- **Protocol handler support**: Added support for protocol handlers such as `open podman-desktop:extension/redhat.openshift-local`
- **Troubleshooting page**: A troubleshooting page for helping diagnose Podman Desktop related development issues

Podman Desktop 1.2 is now available. [Click here to download it](/downloads)!

![Podman-desktop-1-2-hero](img/podman-desktop-release-1.2/podman-desktop-release-1.2.png)

---

## Release Details

### Added start/stop/delete/restart buttons for Compose

In the last month we've been addind support for more Compose features. Before you were only able to control a group of containers if they were in a Pod. Now we have added the ability to control a group of Compose containers. You can now start, stop, delete and restart a group of containers launched by either `docker-compose` or `podman-compose`.

Stay tuned as we add even more features to Compose! If you have any feedback or feature requests, feel free to open an issue or start a discussion on GitHub.

<ReactPlayer playing playsinline controls url="https://user-images.githubusercontent.com/6422176/253331226-d80e7637-c223-4bb8-8675-1dcb8d48818f.mov" width='100%' height='100%' />

### Kubernetes context on the status bar

With Kubernetes context on the status bar, you can switch from one context to another in just a couple of clicks. Easily switch to a different cluster all together. If there are multiple contexts available, you can now click and pick which one to use.

<ReactPlayer playing playsinline controls url="https://user-images.githubusercontent.com/19958075/243804525-242b02b4-fc3c-415b-be08-24eb1933adc5.mov" width='100%' height='100%' />

### Rename images

Deployed an image but now you need to rename it / add a new tag? Podman Desktop allows you to edit an image now. Thanks to an awesome contributor [@tuckerrc](https://github.com/tuckerrc) who added the new feature.

<ReactPlayer playing playsinline controls url="https://user-images.githubusercontent.com/436777/251759557-bd15a631-93ee-4383-a81c-8ef3934dfb59.mp4" width='100%' height='100%' />

### Troubleshooting page

Developing an extension for Podman Desktop? Want to view the logs of Podman Desktop as well as ping your container connection? We now have a troubleshooting page!

Click on the lightbulb button on the bottom right to access the page.

<ReactPlayer playing playsinline controls url="https://user-images.githubusercontent.com/436777/248210601-e0a5deb0-44ad-4eea-9b24-134754fede80.mp4" width='100%' height='100%' />

### Protocol handler support

Podman Desktop now supports protocol handling when using the terminal! Want to access your favourite extension directly from a script or the terminal? If you type in `open podman-desktop:extension/redhat.openshift-local` in the terminal, Podman Desktop will automatically load up to the correct extension.

<ReactPlayer playing playsinline controls url="https://user-images.githubusercontent.com/436777/243304511-b11ad1e4-4c2f-455c-957a-01653d2a93c8.mp4" width='100%' height='100%' />

---

## Other Notable Features

- Background colors and FormPage ([PR #2977](https://github.com/containers/podman-desktop/pull/2977))
- Add ability to add insecure registry / skipping cert verify ([PR #2896](https://github.com/containers/podman-desktop/pull/2896))
- Add support for icon contribution ([PR #2984](https://github.com/containers/podman-desktop/pull/2984))
- Add warning dialog message that virtual machine has low memory limit ([PR #2822](https://github.com/containers/podman-desktop/pull/2822))
- Propose indexed name for new pod ([PR #3028](https://github.com/containers/podman-desktop/pull/3028))
- Add restart button after enabling / disabling mac os compatibility ([PR #2841](https://github.com/containers/podman-desktop/pull/2841))
- Add environment related helper constants ([PR #3079](https://github.com/containers/podman-desktop/pull/3079))
- Allow entrypoint and cmd when starting container ([PR #3031](https://github.com/containers/podman-desktop/pull/3031))
- Add a way to debug stores in troubleshooting page ([PR #3121](https://github.com/containers/podman-desktop/pull/3121))
- Add custompick component (#2855) ([PR #3012](https://github.com/containers/podman-desktop/pull/3012))
- Dynamic breadcrumbs ([PR #3119](https://github.com/containers/podman-desktop/pull/3119))
- Icons on form pages ([PR #3155](https://github.com/containers/podman-desktop/pull/3155))
- Switch more pages to formpage ([PR #3162](https://github.com/containers/podman-desktop/pull/3162))
- Add rename image button ([PR #2588](https://github.com/containers/podman-desktop/pull/2588))
- Fixed headers, improved scrollbars ([PR #2863](https://github.com/containers/podman-desktop/pull/2863))
- Reports warnings on failed kube deploy, fixes error out ([PR #3050](https://github.com/containers/podman-desktop/pull/3050))
- Kube context on statusbar ([PR #2755](https://github.com/containers/podman-desktop/pull/2755))
- Install provider if not installed when clicking on create new button (#2706) ([PR #2817](https://github.com/containers/podman-desktop/pull/2817))
- Add tag and authenticated push capacity to the extension API ([PR #2876](https://github.com/containers/podman-desktop/pull/2876))
- Add navigation bar e2e tests ([PR #2950](https://github.com/containers/podman-desktop/pull/2950))

---

## Documentation Updates

- Fix documentation for building image of extensions ([PR #2873](https://github.com/containers/podman-desktop/pull/2873))
- Add Minikube install docs ([PR #2824](https://github.com/containers/podman-desktop/pull/2824))
- Add Minikube documentation ([PR #2694](https://github.com/containers/podman-desktop/pull/2694))
- Updated Building an image procedure ([PR #2964](https://github.com/containers/podman-desktop/pull/2964))
- Starting a container ([PR #2958](https://github.com/containers/podman-desktop/pull/2958))
- Pulling an image ([PR #2956](https://github.com/containers/podman-desktop/pull/2956))
- Updated selecting containers to run in a pod ([PR #2970](https://github.com/containers/podman-desktop/pull/2970))
- Pushing an image to a registry ([PR #2969](https://github.com/containers/podman-desktop/pull/2969))
- How to add an insecure registry ([PR #2953](https://github.com/containers/podman-desktop/pull/2953))
- Add documentation for lima ([PR #2995](https://github.com/containers/podman-desktop/pull/2995))
- Replace broken link to podman.io ([PR #2994](https://github.com/containers/podman-desktop/pull/2994))
- Authenticating to a pre-configured registry ([PR #2965](https://github.com/containers/podman-desktop/pull/2965))
- Lima is not a container engine ([PR #3051](https://github.com/containers/podman-desktop/pull/3051))
- Using the Troubleshooting page ([PR #3083](https://github.com/containers/podman-desktop/pull/3083))
- View and select your current Kubernetes context in the status bar ([PR #3090](https://github.com/containers/podman-desktop/pull/3090))

---

## Notable Bug Fixes

- Deleting a running pod generates an error ([PR #2827](https://github.com/containers/podman-desktop/pull/2827))
- If kubeconfig is empty, does not try to do things, cancel ([PR #2874](https://github.com/containers/podman-desktop/pull/2874))
- Async telemetry startup ([PR #2885](https://github.com/containers/podman-desktop/pull/2885))
- Do not block startup while waiting for kube resource refresh ([PR #2884](https://github.com/containers/podman-desktop/pull/2884))
- Images list too wide ([PR #2918](https://github.com/containers/podman-desktop/pull/2918))
- Compose deactivate function never called ([PR #2922](https://github.com/containers/podman-desktop/pull/2922))
- Auto-scrolling on form pages, layout issues ([PR #2927](https://github.com/containers/podman-desktop/pull/2927))
- Show current context in quick pick ([PR #2920](https://github.com/containers/podman-desktop/pull/2920))
- Remove sticky position of loader in dashboard UI (#2535) ([PR #2959](https://github.com/containers/podman-desktop/pull/2959))
- Undo change that broke the website ([PR #2992](https://github.com/containers/podman-desktop/pull/2992))
- Detailspage, resizing & consistency ([PR #2987](https://github.com/containers/podman-desktop/pull/2987))
- Quick pick click to close and over nav bar ([PR #2758](https://github.com/containers/podman-desktop/pull/2758))
- Only show empty screen when no pods ([PR #2929](https://github.com/containers/podman-desktop/pull/2929))
- Do not redirect to /pods when deleting pod in containerlist ([PR #2963](https://github.com/containers/podman-desktop/pull/2963))
- Bulk delete on pods should call the pod deletion ([PR #2979](https://github.com/containers/podman-desktop/pull/2979))
- Update nodejs version to 18 in .nvmrc to fix yarn install failure ([PR #2989](https://github.com/containers/podman-desktop/pull/2989))
- Website check targets ([PR #2996](https://github.com/containers/podman-desktop/pull/2996))
- Don't show exception to user ([PR #3034](https://github.com/containers/podman-desktop/pull/3034))
- Interpret arguments given to info command for example ([PR #3015](https://github.com/containers/podman-desktop/pull/3015))
- Change defaults for Podman machine ([PR #3061](https://github.com/containers/podman-desktop/pull/3061))
- Normalize development/production folders path ([PR #3113](https://github.com/containers/podman-desktop/pull/3113))
- Calculate machine socket path for linux ([PR #3070](https://github.com/containers/podman-desktop/pull/3070))
- Replace backslash with slash so to support rendering on Windows (#3120) ([PR #3122](https://github.com/containers/podman-desktop/pull/3122))
- Keep stdout and stderr in the error object for Docker Desktop extensions ([PR #3014](https://github.com/containers/podman-desktop/pull/3014))
- Mark task completed if there's a failure ([PR #3016](https://github.com/containers/podman-desktop/pull/3016))
- Handle invalid kubeconfig file ([PR #3129](https://github.com/containers/podman-desktop/pull/3129))
- Do not remove registries when podman extension is stopping ([PR #3136](https://github.com/containers/podman-desktop/pull/3136))
- Warning should be amber ([PR #3153](https://github.com/containers/podman-desktop/pull/3153))
- Load user extensions from plugins as removable ([PR #3152](https://github.com/containers/podman-desktop/pull/3152))
- Images with spaces in entrypoints or commands fail to start ([PR #3161](https://github.com/containers/podman-desktop/pull/3161))
- Scrolling offscreen when clicking checkbox ([PR #3178](https://github.com/containers/podman-desktop/pull/3178))
- Avoid messagebox expanding offscreen ([PR #2778](https://github.com/containers/podman-desktop/pull/2778))
- Release-notes-generator run failure ([PR #2752](https://github.com/containers/podman-desktop/pull/2752))
- Unable to do a new build if the previous one failed ([PR #2721](https://github.com/containers/podman-desktop/pull/2721))

---

## Community Thank You

🎉 We’d like to say a big thank you to everyone who helped to make Podman Desktop even better.

A big shoutout to [@afbjorklund](https://github.com/afbjorklund), [@tuckerrc](https://github.com/tuckerrc) and [@evanshortiss](https://github.com/evanshortiss) who contributed to this release!

---

## Final notes

The complete list of issues fixed in this release is available [here](https://github.com/containers/podman-desktop/issues?q=is%3Aclosed+milestone%3A1.2.0) and [here](https://github.com/containers/podman-desktop/issues?q=is%3Aclosed+milestone%3A1.2.0).

Get the latest release from the [Downloads](/downloads) section of the website and boost your development journey with Podman Desktop. Additionally, visit the [GitHub repository](https://github.com/containers/podman-desktop) and see how you can help us make Podman Desktop better.
