---
title: Podman Desktop 1.1 Release
description: Podman Desktop 1.1 has been released!
slug: podman-desktop-release-1.1
authors: [deboer]
tags: [podman-desktop, release, kubernetes, openshift]
hide_table_of_contents: false
image: /img/blog/podman-desktop-release-1.1.webp
---

import ReactPlayer from 'react-player'

Podman Desktop 1.1 Release! 🎉

This is primarily a bug-fix release to fix a few important issues, but we've managed to squeeze in a few enhancements
along the way.

<!--Main Features-->

- **Podman 4.5.1**: Podman 4.5.1 now included in Windows and Mac installers.
- **Extensions**: Update extensions from within Podman Desktop.
- **Lima Support**: Choose engine type and override its name from the settings.
- **UX and UI Improvements**: New loading screen.

Podman Desktop 1.1 is now available. [Click here to download it](/downloads)!

![Podman-desktop-1-1-hero](img/podman-desktop-release-1.1/podman-desktop-release-1.1.png)

<!--truncate-->

---

## Release Details

### Podman v4.5.1

Podman Desktop 1.1 moves up to [Podman 4.5.1](https://github.com/containers/podman/releases/tag/v4.5.1).

### Extensions

Optional extensions will follow their own lifecycle and update independently from Podman Desktop. As of
this release you'll be able to see when there is an update available and install from within
Podman Desktop [#2655](https://github.com/containers/podman-desktop/pull/2655).

We've also added options in **<Icon icon="fa-solid fa-cog" size="lg" />Settings > Preferences** to
automatically check for and install extension updates.

<ReactPlayer playing playsinline controls url="https://user-images.githubusercontent.com/436777/241246481-305d215f-2a5c-46e8-9cc3-ecd90a6bd2bc.mp4" width='100%' height='100%' />

![Update extensions](img/podman-desktop-release-1.1/update-extensions.png)

### Lima Support

Thanks to contributor [Anders Björklund](https://github.com/afbjorklund), we have some improvements to the
Lima extension! In **<Icon icon="fa-solid fa-cog" size="lg" />Settings > Preferences** you can select which
engine type Lima runs on and override the instance name [#2674](https://github.com/containers/podman-desktop/pull/2674).

![Lima preferences](https://user-images.githubusercontent.com/10364051/241755966-0a6a293b-b18e-4222-9c40-abd6c114d464.png)

### Other UI and UX Improvements

#### New Loading Screen

We have a new loading screen, Podman Desktop style! [#2743](https://github.com/containers/podman-desktop/pull/2743).

<ReactPlayer playing playsinline controls url="https://user-images.githubusercontent.com/436777/243706137-324b5870-f6a0-4bc1-ac91-e8b45c374c90.mp4" width='100%' height='100%' />

---

## Other Notable Enhancements

- Docker-compose can be installed system-wide [#2718](https://github.com/containers/podman-desktop/pull/2718).
- Show warning when creating a pod with two containers that use the same port [#2671](https://github.com/containers/podman-desktop/pull/2671).
- Display Kubernetes context name in pod label [#2634](https://github.com/containers/podman-desktop/pull/2634).
- Add Docker compatibility button using flatpak-spawn [#1925](https://github.com/containers/podman-desktop/pull/1925).
- Improve UI consistency of Pull Image page [#2604](https://github.com/containers/podman-desktop/pull/2604).

---

## Notable Bug Fixes

- Could not install extensions on Windows 10 [#2762](https://github.com/containers/podman-desktop/pull/2762).
- Could not use locally built images on Kubernetes [#2710](https://github.com/containers/podman-desktop/pull/2710).
- Dashboard still suggests update after installation [#2648](https://github.com/containers/podman-desktop/pull/2648).
- Could not Play Kubernetes YAML to Podman on Windows [#2594](https://github.com/containers/podman-desktop/pull/2594).
- Pod label wasn't always shown in list [#2614](https://github.com/containers/podman-desktop/pull/2614).
- Dashboard button state was resetting [#2584](https://github.com/containers/podman-desktop/pull/2584).
- Change checkbox style so they don't look like stop buttons [#2723](https://github.com/containers/podman-desktop/pull/2723).

---

## Community Thank You

🎉 We’d like to say a big thank you to everyone who helped to make Podman Desktop even better. In this
sprint we received pull requests from the following people:

- [wangxiaolei](https://github.com/fatelei) in [#2602 - Add meaningful tooltips to build, pull, prune buttons](https://github.com/containers/podman-desktop/pull/2602)
- [AsciiWolf](https://github.com/AsciiWolf) in [#2607 - fix typing error in Flathub name](https://github.com/containers/podman-desktop/pull/2607) and [#2609 - fix Flatpak install instructions](https://github.com/containers/podman-desktop/pull/2609)
- [Anders Björklund](https://github.com/afbjorklund) in [#2674 - Select engine for Lima provider](https://github.com/containers/podman-desktop/pull/2674)

---

## Final notes

The complete list of issues fixed in this release is available [here](https://github.com/containers/podman-desktop/issues?q=is%3Aclosed+milestone%3A1.1.0) and [here](https://github.com/containers/podman-desktop/issues?q=is%3Aclosed+milestone%3A1.1.0).

Get the latest release from the [Downloads](/downloads) section of the website and boost your development journey with Podman Desktop. Additionally, visit the [GitHub repository](https://github.com/containers/podman-desktop) and see how you can help us make Podman Desktop better.
