---
title: Release Notes - Podman Desktop 0.14
description: Podman Desktop 0.14 has been released!
slug: podman-desktop-release-0.14
authors: [deboer]
tags: [podman-desktop, release, kubernetes, kind]
hide_table_of_contents: false
---

import ReactPlayer from 'react-player'

Podman Desktop 0.14 - Our Kind-est release yet!

We have been working on a Kind extension for a while now, and decided it is time to promote it
into a release just in time for KubeCon and CloudNativeCon Europe!

We're especially excited about releasing Kind because it finally shows the full purpose
of Podman Desktop: not just local container engines, but Kubernetes too. More importantly,
providing tools that allow you to manage both environments and seamlessly move between them.

Some of these features were available in development mode over the last few releases,
but since they are now in the release build, we will do a full roundup and talk about
all the Kind features.

<!--Main Features-->

- **Kind Installation**: Install Kind from the status bar
- **Manage Kind Clusters**: Create and manage Kind clusters from **<Icon icon="fa-solid fa-cog" size="lg" /> Settings > Resources**
- **Using Kind**: Deploying YAML and sharing images to a cluster
- **Kind Ingress**: Install a Contour ingress controller
- **UX and UI Improvements**: Updated preferences and telemetry prompt

Podman Desktop 0.14 is now available. [Click here to download it](/downloads)!

![Podman-desktop-0-14-hero](img/podman-desktop-release-0.14/podman-desktop-release-0.14.png)

<!--truncate-->

---

## Release details

### Kind Installation

Get Kind up and running in seconds! The Kind extension is now bundled as part of Podman Desktop
[1421](https://github.com/containers/podman-desktop/issues/1421)
and allows you to easily [install Kind directly from the status bar](/docs/kind/installing)
[1257](https://github.com/containers/podman-desktop/issues/1257).

The installed `kind` CLI is available from the system shell [1516](https://github.com/containers/podman-desktop/issues/1516),
allowing you to open a terminal window to `kind get clusters` or work with other tools.

### Manage Kind Clusters

Once Kind is installed (or if you already had it), you can manage your clusters in **<Icon icon="fa-solid fa-cog" size="lg" /> Settings > Resources**.
From here you can [create Kind clusters](/docs/kind/creating-a-kind-cluster),
start/stop [1953](https://github.com/containers/podman-desktop/issues/1953)
or delete [1977](https://github.com/containers/podman-desktop/issues/1977) them.

![kind-clusters](img/podman-desktop-release-0.14/kind-clusters.png)

The Kind control plane runs as a container. You will see this container
in the **Container** list and can also start or stop it from there.

### Using Kind

Now that you have Kind installed and running, what can you do with it?
If you like terminals, you can always open one up and use the Kind CLI to
[interact with your cluster](https://kind.sigs.k8s.io/docs/user/quick-start/#interacting-with-your-cluster).

Within Podman Desktop we have started with two ways to interact with the cluster.
The first is the ability to play local YAML files on your Kind (or any other Kubernetes!) cluster [1261](https://github.com/containers/podman-desktop/issues/1261). This allows you to take existing Kubernetes YAML definitions -
your deployments, services, or other objects - and deploy it to the cluster.

<ReactPlayer playing playsinline controls url="https://user-images.githubusercontent.com/436777/231812563-ece0a56a-b347-48f8-a3a7-400eb9449037.mp4" width='100%' height='100%' />

As you deploy pods, they will automatically appear in the list of **Pods** [1263](https://github.com/containers/podman-desktop/issues/1263), allowing you to start, stop, and interact them just like pods running on Podman.

One of the most common uses is to deploy a container that you have been running on Podman, and this will fail
if the image is not available in Kind. To solve this we have made it easy to push images from
Podman to Kind [1448](https://github.com/containers/podman-desktop/issues/1448).

![push-image-kind](img/podman-desktop-release-0.14/push-image-kind.png)

### Kind Ingress

If you deploy a pod to Kind, you are also going to want to reach it! To do this you will need to install a load balancer or
ingress controller so that the pod is accessible from outside the cluster. We made it easy to install the Contour ingress
controller while creating a Kind cluster [1675](https://github.com/containers/podman-desktop/issues/1675),
so if you created your cluster with Podman Desktop it is already there!

![kind-ingress](img/podman-desktop-release-0.14/kind-ingress.png)

We have several other Kind and Kubernetes features planned to expand the supported scenarios, but hopefully this
makes it easy to get started with Kind and shows where we're headed. As always, feedback is appreciated!

### UI and UX improvements

#### Updated Preferences

The **<Icon icon="fa-solid fa-cog" size="lg" /> Settings > Preferences** page has been updated with a new design [1913](https://github.com/containers/podman-desktop/pull/1913),
making it easier to see and change preferences. Changes are live, no more Update button.

![preferences](https://user-images.githubusercontent.com/49404737/229498507-e754b55c-dcbd-486d-9ee3-a1fe3bed7271.gif)

#### Telemetry Prompt

The prompt to enable or disable telemetry has been moved from its own dialog into the **Welcome** screen.
[1927](https://github.com/containers/podman-desktop/pull/1927)
This is more usable, one less prompt, and solves a window-layering issue for some users!

![telemetry prompt](https://user-images.githubusercontent.com/19958075/229577331-365a9a01-0426-4482-a95d-f5dfe39af90a.png)

---

## Other notable enhancements

- Extension support for opening an external URL [2028](https://github.com/containers/podman-desktop/pull/2028) and
  accessing the clipboard [2023](https://github.com/containers/podman-desktop/pull/2023)

---

## Documentation

Naturally, we have a section in the documentation just for [Kind](https://podman-desktop.io/docs/kind).

---

## Notable bug fixes

- Avoid a dialog box if unable to check for updates [2062](https://github.com/containers/podman-desktop/pull/2062)
- Unable to get to the Dashboard if Kind (or Kubernetes) cluster was not running [2052](https://github.com/containers/podman-desktop/issues/2052)

---

## Final notes

The complete list of issues fixed in this release is available [here](https://github.com/containers/podman-desktop/issues?q=is%3Aclosed+milestone%3A0.14.0).

Get the latest release from the [Downloads](/downloads) section of the website and boost your development journey with Podman Desktop. Additionally, visit the [GitHub repository](https://github.com/containers/podman-desktop) and see how you can help us make Podman Desktop better.
