---
title: Release Notes - Podman Desktop 0.12
description: Podman Desktop 0.12 has been released!
slug: podman-desktop-release-0.12
authors: [slemeur]
tags: [podman-desktop, release, kubernetes]
hide_table_of_contents: false
---

import ReactPlayer from 'react-player'

This release note covers Podman Desktop 0.12 release changes.

<!--Main Features-->

- **Podman Version**: Podman 4.4.1 now included in Windows and Mac installers.
- **Containers Configuration**: Configure port mappings for an image without exported ports.
- **Windows Home Support**: Podman Desktop now supports Windows Home Edition.
- **Start minimized**: Option to start Podman Desktop minimized to system tray.
- **UX and UI Improvements**: Consistent actions, placeholder for logs, unified icons and others.

Podman Desktop 0.12 is now available. [Click here to download it](/downloads)!

![podman-desktop-0-12-hero](img/podman-desktop-release-0.12/podman-desktop-release-0.12.png)

<!--truncate-->

---

## Release Details

### Update to Podman v4.4.1 [#1456](https://github.com/containers/podman-desktop/pull/1456)

Podman Desktop 0.12 embeds [Podman 4.4.1](https://github.com/containers/podman/releases/tag/v4.4.1) in Windows and macOS installers. Make sure to upgrade to benefit from the latest Podman features and bug fixes.

### Configuring port mappings when an image has no exported port [#1265](https://github.com/containers/podman-desktop/pull/1265)

With the latest update, users can now add multiple local-to-remote port mappings when starting a container from an image that has no exported ports. This feature provides users with the flexibility to specify which ports on their local machine should map to which ports on the container, even if the container does not have any exported ports by default.

![port-mapping](https://user-images.githubusercontent.com/49404737/215112797-86dcf3f0-121a-487e-a71f-ad41e91f93da.gif)

### Installing Podman Desktop on Windows Home Edition [#1268](https://github.com/containers/podman-desktop/pull/1268)

Podman Desktop 0.12 offers the ability to be installed on Windows Home Edition. The mechanism uses Virtual Machine Platform detection, instead of hyper-v. WSL2 is still requires but can be installed along with the installation process.

![install-windows-home-edition-2](https://user-images.githubusercontent.com/436777/215121429-7c757aaa-a838-43db-98a2-78ad368f407e.png)

### Option to automatically minimize Podman Desktop on login [#1374](https://github.com/containers/podman-desktop/pull/1374)

Podman Desktop now provides a "start minimized" option when users log in onto the laptop. This option, available from the application's settings, can be useful if users want to automatically launch Podman Desktop at log in, but prefer not to have the window visible on the screen. With this feature, you can ensure that Podman Desktop is up and running in the background without any interruption to your workflows.

- Go to **<Icon icon="fa-solid fa-cog" size="lg" /> Settings > Preferences > Login: Minimize** to activate the option.

![minimize-on-login](https://user-images.githubusercontent.com/6422176/216651424-bcf756fd-7554-4b24-a838-e3e2f798fe6e.png)

### UI and UX Improvements

#### Improved actions consistency [#1225](https://github.com/containers/podman-desktop/pull/1225)

Actions displayed in the list pages for Images and Containers have been reviewed and made consistent between other pages.

![action-consistency-1](https://user-images.githubusercontent.com/19958075/214104678-2d4148d7-484e-41f9-9da9-aecee328ae2b.png)

Actions displayed in the header of the container's details page have been improved so that the actions are always displayed in the same order.

![action-consistency-2](https://user-images.githubusercontent.com/19958075/214104663-64fa0601-bb79-49bf-8226-6a78a88d3622.png)

#### Consistent status icons for Pods, Containers, Images and Volumes [#1326](https://github.com/containers/podman-desktop/pull/1326), [#1377](https://github.com/containers/podman-desktop/pull/1377), [#1459](https://github.com/containers/podman-desktop/pull/1459) and [#1245](https://github.com/containers/podman-desktop/pull/1245)

The status icons for Pods, Containers, Images, and Volumes have been unified and use consistent states.

![pods-status-icon](https://user-images.githubusercontent.com/19958075/216671859-bdd8dca4-56b7-40a8-961a-dcb6e01be61e.png)

Icons in empty screens have been updated to use the same consistent SVG icon as the status icons.

![empty-screen-2](https://user-images.githubusercontent.com/436777/214577726-f4cfde7b-017a-499d-a2a9-e50d455ffaf0.png)

#### Placeholder when logs for containers are being fetched [#1353](https://github.com/containers/podman-desktop/pull/1353)

A placeholder is now displayed when logs are being fetched.
![placeholder-loading-logs](https://user-images.githubusercontent.com/49404737/216952505-899308ae-183e-487a-b6e5-28832a0b6452.gif)

#### Fixed alignment in badges from the navigation sidebar [#1357](https://github.com/containers/podman-desktop/pull/1357)

Badges in the sidebar are now aligned with the title of the section.

![alignement-badges](https://user-images.githubusercontent.com/49404737/216336502-2a34dea3-fd41-4184-8cfe-9226d70da070.png)

#### Enable/disable open browser action based on container state [#1395](https://github.com/containers/podman-desktop/pull/1395) and [#1397](https://github.com/containers/podman-desktop/pull/1397)

The action to open the browser if a port is opened in a container, is now disabled when the container is stopped. It is also hidden in the kebab menu.

![enable-disable-container-actions](https://user-images.githubusercontent.com/49404737/217284414-1bdc820b-30a8-485e-b0f9-485229026696.gif)

---

## Other Notable Enhancements

- Display extension icons [#1058](https://github.com/containers/podman-desktop/pull/1058)
- Solid Icons [#1267](https://github.com/containers/podman-desktop/pull/1276)
- Differentiate icons compared to status icons [#1268](https://github.com/containers/podman-desktop/pull/1298)
- Refactors window initializing [#1309](https://github.com/containers/podman-desktop/pull/1309)
- Change window creation background color to dark [#1310](https://github.com/containers/podman-desktop/pull/1310)
- Use Podman `machine inspect` to read the address to connect to the Podman machine [#1364](https://github.com/containers/podman-desktop/pull/1364)
- Update the editor content when the pod name changes, and disable the deploy button when empty [#1403](https://github.com/containers/podman-desktop/pull/1403)
- Ability to manually set color of tray icon for Windows and Linux [#1243](https://github.com/containers/podman-desktop/pull/1243)
- Better UI feedback when starting pods [#1242](https://github.com/containers/podman-desktop/pull/1242)

---

## Documentation

The documentation had many editorial reviews, and new content.

- [Link to simple WSL2 installation instructions](/docs/installation/windows-install)
- [Refresh Windows Installation](/docs/installation/windows-install)
- [Revamped installation introduction](/docs/installation)
- [Reorganized Linux installation](/docs/installation/linux-install)
- [Installing Podman Desktop on Windows in a restricted environment](/docs/proxy
- Fixed documentation on `podman-mac-helper` setup

---

## Notable bug fixes

- Fixed handling path with spaces on Windows when installing Podman [#1270](https://github.com/containers/podman-desktop/pull/1270)
- Removed padding from SVG icons [#1253](https://github.com/containers/podman-desktop/pull/1253)
- Website: fixed download links for Windows and macOS binaries [#1255](https://github.com/containers/podman-desktop/pull/1255)
- Fixed prettier commands on Windows [#1266](https://github.com/containers/podman-desktop/pull/1267)
- Fixed new xterm instance spawn when clicking the logs route [#1344](https://github.com/containers/podman-desktop/pull/1344)
- Fixed need to wait that telemetry has been initialized before proceeding [#1373](https://github.com/containers/podman-desktop/pull/1373)
- Fixed new xterm instance spawn when clicking the logs route in pod details[#1393](https://github.com/containers/podman-desktop/pull/1393)
- Fixed stop spinner if image cannot be retrieved [#1394](https://github.com/containers/podman-desktop/pull/1394)
- Fixed escape command with quotes only for Windows [#1462](https://github.com/containers/podman-desktop/pull/1462)
- Fixed random CRC status change [#1420](https://github.com/containers/podman-desktop/pull/1420)

---

## Community Thank You

🎉 We’d like to say a big thank you to everyone who helped to make Podman Desktop 0.12 even better:

- [Philipp Wagner](https://github.com/imphil) in [#1274 - Link to simple WSL2 installation instructions](https://github.com/containers/podman-desktop/pull/1274)
- [Arthur S](https://github.com/arixmkii) in [#1364 - Get podman machine socketPath from podman machine inspect first](https://github.com/containers/podman-desktop/pull/1364)
- [Mitch West](https://github.com/Mitch9378) in [#1428 - Fix old documentation for 'podman-mac-helper setup'](https://github.com/containers/podman-desktop/pull/1428)

## Final Notes

The complete list of issues fixed in this release is available [here](https://github.com/containers/podman-desktop/issues?q=is%3Aclosed+milestone%3A0.12.0).

Get the latest release from the [Downloads](/downloads) section of the website and boost your development journey with Podman Desktop. Additionally, visit the [GitHub repository](https://github.com/containers/podman-desktop) and see how you can help us make Podman Desktop better.
